/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.scheduling;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.AbstractTimeSource;
import kotlinx.coroutines.AbstractTimeSourceKt;
import kotlinx.coroutines.DebugKt;
import kotlinx.coroutines.DebugStringsKt;
import kotlinx.coroutines.internal.ResizableAtomicArray;
import kotlinx.coroutines.internal.Symbol;
import kotlinx.coroutines.scheduling.GlobalQueue;
import kotlinx.coroutines.scheduling.Task;
import kotlinx.coroutines.scheduling.TaskContext;
import kotlinx.coroutines.scheduling.TaskImpl;
import kotlinx.coroutines.scheduling.TasksKt;
import kotlinx.coroutines.scheduling.WorkQueue;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b-\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\b\u0000\u0018\u0000 X2\u00020\\2\u00020]:\u0003XYZB+\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0018\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0004H\u0086\b\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0018\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0004H\u0082\b\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u000f\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J!\u0010\u001d\u001a\u00020\n2\n\u0010\u001a\u001a\u00060\u0018j\u0002`\u00192\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0018\u0010\u001f\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0004H\u0082\b\u00a2\u0006\u0004\b\u001f\u0010\u0011J\u0015\u0010!\u001a\b\u0018\u00010 R\u00020\u0000H\u0002\u00a2\u0006\u0004\b!\u0010\"J\u0010\u0010#\u001a\u00020\u0013H\u0082\b\u00a2\u0006\u0004\b#\u0010\u0015J\u0010\u0010$\u001a\u00020\u0001H\u0082\b\u00a2\u0006\u0004\b$\u0010\u0017J-\u0010&\u001a\u00020\u00132\n\u0010\u001a\u001a\u00060\u0018j\u0002`\u00192\b\b\u0002\u0010\u001c\u001a\u00020\u001b2\b\b\u0002\u0010%\u001a\u00020\f\u00a2\u0006\u0004\b&\u0010'J\u001b\u0010)\u001a\u00020\u00132\n\u0010(\u001a\u00060\u0018j\u0002`\u0019H\u0016\u00a2\u0006\u0004\b)\u0010*J\u0010\u0010+\u001a\u00020\u0004H\u0082\b\u00a2\u0006\u0004\b+\u0010,J\u0010\u0010-\u001a\u00020\u0001H\u0082\b\u00a2\u0006\u0004\b-\u0010\u0017J\u001b\u0010/\u001a\u00020\u00012\n\u0010.\u001a\u00060 R\u00020\u0000H\u0002\u00a2\u0006\u0004\b/\u00100J\u0015\u00101\u001a\b\u0018\u00010 R\u00020\u0000H\u0002\u00a2\u0006\u0004\b1\u0010\"J\u0019\u00102\u001a\u00020\f2\n\u0010.\u001a\u00060 R\u00020\u0000\u00a2\u0006\u0004\b2\u00103J)\u00106\u001a\u00020\u00132\n\u0010.\u001a\u00060 R\u00020\u00002\u0006\u00104\u001a\u00020\u00012\u0006\u00105\u001a\u00020\u0001\u00a2\u0006\u0004\b6\u00107J\u0010\u00108\u001a\u00020\u0004H\u0082\b\u00a2\u0006\u0004\b8\u0010,J\u0015\u00109\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b9\u0010:J\u0015\u0010<\u001a\u00020\u00132\u0006\u0010;\u001a\u00020\u0004\u00a2\u0006\u0004\b<\u0010=J\u0017\u0010?\u001a\u00020\u00132\u0006\u0010>\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b?\u0010@J\r\u0010A\u001a\u00020\u0013\u00a2\u0006\u0004\bA\u0010\u0015J\u000f\u0010B\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\bB\u0010CJ\u0010\u0010D\u001a\u00020\fH\u0082\b\u00a2\u0006\u0004\bD\u0010EJ\u0019\u0010F\u001a\u00020\f2\b\b\u0002\u0010\u000f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\bF\u0010GJ\u000f\u0010H\u001a\u00020\fH\u0002\u00a2\u0006\u0004\bH\u0010EJ+\u0010I\u001a\u0004\u0018\u00010\n*\b\u0018\u00010 R\u00020\u00002\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010%\u001a\u00020\fH\u0002\u00a2\u0006\u0004\bI\u0010JR\u0015\u0010\u0010\u001a\u00020\u00018\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bK\u0010\u0017R\u0014\u0010\u0002\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0002\u0010LR\u0015\u0010\u001f\u001a\u00020\u00018\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bM\u0010\u0017R\u0014\u0010O\u001a\u00020N8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\bO\u0010PR\u0014\u0010Q\u001a\u00020N8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\bQ\u0010PR\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010RR\u0011\u0010S\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\bS\u0010ER\u0014\u0010\u0003\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010LR\u0014\u0010\u0007\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010TR\u001e\u0010V\u001a\f\u0012\b\u0012\u00060 R\u00020\u00000U8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\bV\u0010W\u00a8\u0006["}, d2={"Lkotlinx/coroutines/scheduling/CoroutineScheduler;", "", "corePoolSize", "maxPoolSize", "", "idleWorkerKeepAliveNs", "", "schedulerName", "<init>", "(IIJLjava/lang/String;)V", "Lkotlinx/coroutines/scheduling/Task;", "task", "", "addToGlobalQueue", "(Lkotlinx/coroutines/scheduling/Task;)Z", "state", "availableCpuPermits", "(J)I", "blockingTasks", "", "close", "()V", "createNewWorker", "()I", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "block", "Lkotlinx/coroutines/scheduling/TaskContext;", "taskContext", "createTask", "(Ljava/lang/Runnable;Lkotlinx/coroutines/scheduling/TaskContext;)Lkotlinx/coroutines/scheduling/Task;", "createdWorkers", "Lkotlinx/coroutines/scheduling/CoroutineScheduler$Worker;", "currentWorker", "()Lkotlinx/coroutines/scheduling/CoroutineScheduler$Worker;", "decrementBlockingTasks", "decrementCreatedWorkers", "tailDispatch", "dispatch", "(Ljava/lang/Runnable;Lkotlinx/coroutines/scheduling/TaskContext;Z)V", "command", "execute", "(Ljava/lang/Runnable;)V", "incrementBlockingTasks", "()J", "incrementCreatedWorkers", "worker", "parkedWorkersStackNextIndex", "(Lkotlinx/coroutines/scheduling/CoroutineScheduler$Worker;)I", "parkedWorkersStackPop", "parkedWorkersStackPush", "(Lkotlinx/coroutines/scheduling/CoroutineScheduler$Worker;)Z", "oldIndex", "newIndex", "parkedWorkersStackTopUpdate", "(Lkotlinx/coroutines/scheduling/CoroutineScheduler$Worker;II)V", "releaseCpuPermit", "runSafely", "(Lkotlinx/coroutines/scheduling/Task;)V", "timeout", "shutdown", "(J)V", "skipUnpark", "signalBlockingWork", "(Z)V", "signalCpuWork", "toString", "()Ljava/lang/String;", "tryAcquireCpuPermit", "()Z", "tryCreateWorker", "(J)Z", "tryUnpark", "submitToLocalQueue", "(Lkotlinx/coroutines/scheduling/CoroutineScheduler$Worker;Lkotlinx/coroutines/scheduling/Task;Z)Lkotlinx/coroutines/scheduling/Task;", "getAvailableCpuPermits", "I", "getCreatedWorkers", "Lkotlinx/coroutines/scheduling/GlobalQueue;", "globalBlockingQueue", "Lkotlinx/coroutines/scheduling/GlobalQueue;", "globalCpuQueue", "J", "isTerminated", "Ljava/lang/String;", "Lkotlinx/coroutines/internal/ResizableAtomicArray;", "workers", "Lkotlinx/coroutines/internal/ResizableAtomicArray;", "Companion", "Worker", "WorkerState", "kotlinx-coroutines-core", "Ljava/util/concurrent/Executor;", "Ljava/io/Closeable;"})
public final class CoroutineScheduler
implements Closeable,
Executor {
    public static final Companion Companion = new Companion(null);
    @JvmField
    public final int corePoolSize;
    @JvmField
    public final int maxPoolSize;
    @JvmField
    public final long idleWorkerKeepAliveNs;
    @JvmField
    public final String schedulerName;
    @JvmField
    public final GlobalQueue globalCpuQueue;
    @JvmField
    public final GlobalQueue globalBlockingQueue;
    private volatile /* synthetic */ long parkedWorkersStack;
    private static final /* synthetic */ AtomicLongFieldUpdater parkedWorkersStack$FU;
    @JvmField
    public final ResizableAtomicArray<Worker> workers;
    volatile /* synthetic */ long controlState;
    static final /* synthetic */ AtomicLongFieldUpdater controlState$FU;
    private volatile /* synthetic */ int _isTerminated;
    private static final /* synthetic */ AtomicIntegerFieldUpdater _isTerminated$FU;
    @JvmField
    public static final Symbol NOT_IN_STACK = new Symbol("NOT_IN_STACK");
    private static final int PARKED = -1;
    private static final int CLAIMED = 0;
    private static final int TERMINATED = 1;
    private static final int BLOCKING_SHIFT = 21;
    private static final long CREATED_MASK = 0x1FFFFFL;
    private static final long BLOCKING_MASK = 4398044413952L;
    private static final int CPU_PERMITS_SHIFT = 42;
    private static final long CPU_PERMITS_MASK = 9223367638808264704L;
    public static final int MIN_SUPPORTED_POOL_SIZE = 1;
    public static final int MAX_SUPPORTED_POOL_SIZE = 0x1FFFFE;
    private static final long PARKED_INDEX_MASK = 0x1FFFFFL;
    private static final long PARKED_VERSION_MASK = -2097152L;
    private static final long PARKED_VERSION_INC = 0x200000L;

    /*
     * WARNING - void declaration
     */
    public CoroutineScheduler(int corePoolSize, int maxPoolSize, long idleWorkerKeepAliveNs, String schedulerName) {
        void var3_7;
        void var2_6;
        void var1_1;
        this.corePoolSize = var1_1;
        this.maxPoolSize = var2_6;
        this.idleWorkerKeepAliveNs = var3_7;
        this.schedulerName = schedulerName;
        if (!(this.corePoolSize > 0)) {
            String string = "Core pool size " + this.corePoolSize + " should be at least 1";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.maxPoolSize >= this.corePoolSize)) {
            String string = "Max pool size " + this.maxPoolSize + " should be greater than or equals to core pool size " + this.corePoolSize;
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.maxPoolSize <= 0x1FFFFE)) {
            String string = "Max pool size " + this.maxPoolSize + " should not exceed maximal supported number of threads 2097150";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.idleWorkerKeepAliveNs > 0L)) {
            String string = "Idle worker keep alive time " + this.idleWorkerKeepAliveNs + " must be positive";
            throw new IllegalArgumentException(string.toString());
        }
        this.globalCpuQueue = new GlobalQueue();
        this.globalBlockingQueue = new GlobalQueue();
        this.parkedWorkersStack = 0L;
        this.workers = new ResizableAtomicArray(this.corePoolSize + 1);
        this.controlState = (long)this.corePoolSize << 42;
        this._isTerminated = 0;
    }

    public /* synthetic */ CoroutineScheduler(int n, int n2, long l, String string, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            l = TasksKt.IDLE_WORKER_KEEP_ALIVE_NS;
        }
        if ((n3 & 8) != 0) {
            string = "DefaultDispatcher";
        }
        this(n, n2, l, string);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean addToGlobalQueue(Task task) {
        void var1_1;
        Task task2 = task;
        if (task2.taskContext.getTaskMode() == 1) {
            return this.globalBlockingQueue.addLast(task);
        }
        return this.globalCpuQueue.addLast(var1_1);
    }

    public final void parkedWorkersStackTopUpdate(Worker worker, int oldIndex, int newIndex) {
        int updIndex;
        long updVersion;
        long top;
        int n;
        CoroutineScheduler $this$loop$iv = this;
        do {
            top = $this$loop$iv.parkedWorkersStack;
            int index = (int)(top & 0x1FFFFFL);
            updVersion = top + 0x200000L & 0xFFFFFFFFFFE00000L;
            if (index == oldIndex) {
                if (newIndex == 0) {
                    n = this.parkedWorkersStackNextIndex(worker);
                    continue;
                }
                n = newIndex;
                continue;
            }
            n = updIndex = index;
        } while (n < 0 || !parkedWorkersStack$FU.compareAndSet(this, top, updVersion | (long)updIndex));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean parkedWorkersStackPush(Worker worker) {
        int updIndex;
        long updVersion;
        void var3_3;
        if (worker.getNextParkedWorker() != NOT_IN_STACK) {
            return false;
        }
        CoroutineScheduler $this$loop$iv = this;
        do {
            long top = $this$loop$iv.parkedWorkersStack;
            int index = (int)(top & 0x1FFFFFL);
            updVersion = top + 0x200000L & 0xFFFFFFFFFFE00000L;
            updIndex = worker.getIndexInArray();
            if (DebugKt.getASSERTIONS_ENABLED() && !(updIndex != 0)) {
                throw new AssertionError();
            }
            worker.setNextParkedWorker(this.workers.get(index));
        } while (!parkedWorkersStack$FU.compareAndSet(this, (long)var3_3, updVersion | (long)updIndex));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final Worker parkedWorkersStackPop() {
        long updVersion;
        void var2_2;
        Worker worker;
        int updIndex;
        CoroutineScheduler $this$loop$iv = this;
        do {
            long top;
            int index;
            if (this.workers.get(index = (int)((top = $this$loop$iv.parkedWorkersStack) & 0x1FFFFFL)) == null) {
                return null;
            }
            updVersion = top + 0x200000L & 0xFFFFFFFFFFE00000L;
        } while ((updIndex = this.parkedWorkersStackNextIndex(worker)) < 0 || !parkedWorkersStack$FU.compareAndSet(this, (long)var2_2, updVersion | (long)updIndex));
        worker.setNextParkedWorker(NOT_IN_STACK);
        return worker;
    }

    /*
     * WARNING - void declaration
     */
    private final int parkedWorkersStackNextIndex(Worker worker) {
        Object next = worker.getNextParkedWorker();
        while (next != NOT_IN_STACK) {
            Object object;
            if (next == null) {
                return 0;
            }
            Object object2 = next;
            Worker nextWorker = (Worker)object2;
            int updIndex = nextWorker.getIndexInArray();
            if (updIndex != 0) {
                void var2_2;
                return (int)var2_2;
            }
            object = ((Worker)object).getNextParkedWorker();
        }
        return -1;
    }

    private final int getCreatedWorkers() {
        return (int)(this.controlState & 0x1FFFFFL);
    }

    private final int getAvailableCpuPermits() {
        long l = this.controlState;
        return (int)((l & 0x7FFFFC0000000000L) >> 42);
    }

    private final int createdWorkers(long state) {
        return (int)(state & 0x1FFFFFL);
    }

    private final int blockingTasks(long state) {
        return (int)((state & 0x3FFFFE00000L) >> 21);
    }

    public final int availableCpuPermits(long state) {
        return (int)((state & 0x7FFFFC0000000000L) >> 42);
    }

    private final int incrementCreatedWorkers() {
        long l = controlState$FU.incrementAndGet(this);
        return (int)(l & 0x1FFFFFL);
    }

    private final int decrementCreatedWorkers() {
        long l = controlState$FU.getAndDecrement(this);
        return (int)(l & 0x1FFFFFL);
    }

    private final long incrementBlockingTasks() {
        return controlState$FU.addAndGet(this, 0x200000L);
    }

    private final void decrementBlockingTasks() {
        controlState$FU.addAndGet(this, -2097152L);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryAcquireCpuPermit() {
        long state;
        long update;
        void var2_2;
        CoroutineScheduler $this$loop$iv = this;
        do {
            int n;
            if ((n = (int)(((state = $this$loop$iv.controlState) & 0x7FFFFC0000000000L) >> 42)) != 0) continue;
            return false;
        } while (!controlState$FU.compareAndSet(this, (long)var2_2, update = state - 0x40000000000L));
        return true;
    }

    private final long releaseCpuPermit() {
        return controlState$FU.addAndGet(this, 0x40000000000L);
    }

    public final boolean isTerminated() {
        return this._isTerminated != 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void execute(Runnable command2) {
        void var1_1;
        CoroutineScheduler.dispatch$default(this, (Runnable)var1_1, null, false, 6, null);
    }

    @Override
    public final void close() {
        this.shutdown(10000L);
    }

    /*
     * WARNING - void declaration
     */
    public final void shutdown(long timeout) {
        ResizableAtomicArray<Worker> resizableAtomicArray;
        if (!_isTerminated$FU.compareAndSet(this, 0, 1)) {
            return;
        }
        Worker currentWorker = this.currentWorker();
        ResizableAtomicArray<Worker> resizableAtomicArray2 = resizableAtomicArray = this.workers;
        synchronized (resizableAtomicArray) {
            void var3_2;
            Runnable runnable;
            CoroutineScheduler coroutineScheduler = this;
            int n = (int)(coroutineScheduler.controlState & 0x1FFFFFL);
            // ** MonitorExit[var7_6] (shouldn't be in output)
            int created = n;
            int i = 1;
            if (created > 0) {
                while (true) {
                    Worker worker;
                    Intrinsics.checkNotNull((Object)this.workers.get(i));
                    if (worker != currentWorker) {
                        while (worker.isAlive()) {
                            LockSupport.unpark(worker);
                            worker.join(timeout);
                        }
                        WorkerState state = worker.state;
                        if (DebugKt.getASSERTIONS_ENABLED() && !(state == WorkerState.TERMINATED)) {
                            throw new AssertionError();
                        }
                        worker.localQueue.offloadAllWorkTo(this.globalBlockingQueue);
                    }
                    if (i == created) break;
                    ++i;
                }
            }
            this.globalBlockingQueue.close();
            this.globalCpuQueue.close();
            while ((runnable = currentWorker) != null && (runnable = runnable.findTask(true)) != null || (runnable = (Task)this.globalCpuQueue.removeFirstOrNull()) != null || (runnable = (Task)this.globalBlockingQueue.removeFirstOrNull()) != null) {
                Runnable task = runnable;
                this.runSafely((Task)task);
            }
            void v1 = var3_2;
            if (v1 != null) {
                v1.tryReleaseCpu(WorkerState.TERMINATED);
            }
            if (DebugKt.getASSERTIONS_ENABLED()) {
                CoroutineScheduler coroutineScheduler2 = this;
                long l = coroutineScheduler2.controlState;
                if (!((int)((l & 0x7FFFFC0000000000L) >> 42) == this.corePoolSize)) {
                    throw new AssertionError();
                }
            }
            this.parkedWorkersStack = 0L;
            this.controlState = 0L;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void dispatch(Runnable block, TaskContext taskContext, boolean tailDispatch) {
        void var2_3;
        void var1_1;
        void var3_4;
        boolean skipUnpark;
        AbstractTimeSource abstractTimeSource = AbstractTimeSourceKt.getTimeSource();
        if (abstractTimeSource != null) {
            abstractTimeSource.trackTask();
        }
        Task task = this.createTask(block, taskContext);
        Worker currentWorker = this.currentWorker();
        Task notAdded = this.submitToLocalQueue(currentWorker, task, tailDispatch);
        if (notAdded != null && !this.addToGlobalQueue(notAdded)) {
            throw new RejectedExecutionException(this.schedulerName + " was terminated");
        }
        boolean bl = skipUnpark = var3_4 != false && currentWorker != null;
        if (var1_1.taskContext.getTaskMode() == 0) {
            if (skipUnpark) {
                return;
            }
            this.signalCpuWork();
            return;
        }
        this.signalBlockingWork((boolean)var2_3);
    }

    public static /* synthetic */ void dispatch$default(CoroutineScheduler coroutineScheduler, Runnable runnable, TaskContext taskContext, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            taskContext = TasksKt.NonBlockingContext;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        coroutineScheduler.dispatch(runnable, taskContext, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final Task createTask(Runnable block, TaskContext taskContext) {
        void var2_2;
        void var3_3;
        void var1_1;
        long nanoTime = TasksKt.schedulerTimeSource.nanoTime();
        if (block instanceof Task) {
            ((Task)block).submissionTime = nanoTime;
            ((Task)block).taskContext = taskContext;
            return (Task)block;
        }
        return new TaskImpl((Runnable)var1_1, (long)var3_3, (TaskContext)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private final void signalBlockingWork(boolean skipUnpark) {
        void var2_3;
        void var1_1;
        CoroutineScheduler coroutineScheduler = this;
        long stateSnapshot = controlState$FU.addAndGet(coroutineScheduler, 0x200000L);
        if (var1_1 != false) {
            return;
        }
        if (this.tryUnpark()) {
            return;
        }
        if (this.tryCreateWorker((long)var2_3)) {
            return;
        }
        this.tryUnpark();
    }

    public final void signalCpuWork() {
        if (this.tryUnpark()) {
            return;
        }
        if (CoroutineScheduler.tryCreateWorker$default(this, 0L, 1, null)) {
            return;
        }
        this.tryUnpark();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryCreateWorker(long $i$f$createdWorkers) {
        void var3_3;
        int created = (int)($i$f$createdWorkers & 0x1FFFFFL);
        int blocking = (int)(($i$f$createdWorkers & 0x3FFFFE00000L) >> 21);
        if ((blocking = RangesKt.coerceAtLeast((int)(var3_3 - blocking), (int)0)) < this.corePoolSize) {
            void var1_2;
            int newCpuWorkers = this.createNewWorker();
            if (newCpuWorkers == 1 && this.corePoolSize > 1) {
                this.createNewWorker();
            }
            if (var1_2 > 0) {
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ boolean tryCreateWorker$default(CoroutineScheduler coroutineScheduler, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = coroutineScheduler.controlState;
        }
        return coroutineScheduler.tryCreateWorker(l);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryUnpark() {
        void var1_1;
        Worker worker;
        do {
            if (this.parkedWorkersStackPop() != null) continue;
            return false;
        } while (!Worker.workerCtl$FU.compareAndSet(worker, -1, 0));
        LockSupport.unpark((Thread)var1_1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final int createNewWorker() {
        ResizableAtomicArray<Worker> resizableAtomicArray = this.workers;
        ResizableAtomicArray<Worker> resizableAtomicArray2 = resizableAtomicArray;
        resizableAtomicArray2 = resizableAtomicArray;
        synchronized (resizableAtomicArray) {
            void var2_7;
            void var3_4;
            block10: {
                int created;
                block9: {
                    block8: {
                        if (!this.isTerminated()) break block8;
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return -1;
                    }
                    long state = this.controlState;
                    created = (int)(state & 0x1FFFFFL);
                    int blocking = (int)((state & 0x3FFFFE00000L) >> 21);
                    int cpuWorkers = RangesKt.coerceAtLeast((int)(created - blocking), (int)0);
                    if (cpuWorkers < this.corePoolSize) break block9;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return 0;
                }
                if (created < this.maxPoolSize) break block10;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return 0;
            }
            CoroutineScheduler state = this;
            int newIndex2 = (int)(state.controlState & 0x1FFFFFL) + 1;
            if (!(newIndex2 > 0 && this.workers.get(newIndex2) == null)) {
                String newIndex2 = "Failed requirement.";
                throw new IllegalArgumentException(newIndex2.toString());
            }
            Worker worker = new Worker(this, newIndex2);
            this.workers.setSynchronized(newIndex2, worker);
            CoroutineScheduler coroutineScheduler = this;
            long l = controlState$FU.incrementAndGet(coroutineScheduler);
            if (!(var3_4 == (int)(l & 0x1FFFFFL))) {
                String cpuWorkers = "Failed requirement.";
                throw new IllegalArgumentException(cpuWorkers.toString());
            }
            worker.start();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (int)(++var2_7);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Task submitToLocalQueue(Worker $this$submitToLocalQueue, Task task, boolean tailDispatch) {
        void var3_3;
        void var2_2;
        void var1_1;
        if ($this$submitToLocalQueue == null) {
            return task;
        }
        if ($this$submitToLocalQueue.state == WorkerState.TERMINATED) {
            return task;
        }
        Task task2 = task;
        if (task2.taskContext.getTaskMode() == 0 && $this$submitToLocalQueue.state == WorkerState.BLOCKING) {
            return task;
        }
        $this$submitToLocalQueue.mayHaveLocalTasks = true;
        return var1_1.localQueue.add((Task)var2_2, (boolean)var3_3);
    }

    private final Worker currentWorker() {
        Thread thread = Thread.currentThread();
        Worker worker = thread instanceof Worker ? (Worker)thread : null;
        if (worker != null) {
            thread = worker;
            Worker worker2 = worker;
            worker2 = worker;
            if (Intrinsics.areEqual((Object)worker.this$0, (Object)this)) {
                return thread;
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        void var2_2;
        void var3_3;
        int parkedWorkers = 0;
        int blockingWorkers = 0;
        int cpuWorkers = 0;
        int dormant = 0;
        int terminated = 0;
        ArrayList queueSizes = new ArrayList();
        int n = this.workers.currentLength();
        block7: for (int index = 1; index < n; ++index) {
            Worker worker;
            if (this.workers.get(index) == null) continue;
            int queueSize = worker.localQueue.getSize$kotlinx_coroutines_core();
            switch (WhenMappings.$EnumSwitchMapping$0[worker.state.ordinal()]) {
                case 1: {
                    ++parkedWorkers;
                    continue block7;
                }
                case 2: {
                    ++blockingWorkers;
                    ((Collection)queueSizes).add("" + queueSize + 'b');
                    continue block7;
                }
                case 3: {
                    ++cpuWorkers;
                    ((Collection)queueSizes).add("" + queueSize + 'c');
                    continue block7;
                }
                case 4: {
                    ++dormant;
                    if (queueSize <= 0) continue block7;
                    ((Collection)queueSizes).add("" + queueSize + 'd');
                    continue block7;
                }
                case 5: {
                    ++terminated;
                }
            }
        }
        long state = this.controlState;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.schedulerName).append('@').append(DebugStringsKt.getHexAddress(this)).append("[Pool Size {core = ").append(this.corePoolSize).append(", max = ").append(this.maxPoolSize).append("}, Worker States {CPU = ").append((int)var3_3).append(", blocking = ").append((int)var2_2).append(", parked = ").append((int)var1_1).append(", dormant = ").append(dormant).append(", terminated = ").append(terminated).append("}, running workers queues = ").append(queueSizes).append(", global CPU queue size = ").append(this.globalCpuQueue.getSize()).append(", global blocking queue size = ").append(this.globalBlockingQueue.getSize());
        stringBuilder.append(", Control State {created workers= ").append((int)(state & 0x1FFFFFL)).append(", blocking tasks = ").append((int)((state & 0x3FFFFE00000L) >> 21)).append(", CPUs acquired = ").append(this.corePoolSize - (int)((state & 0x7FFFFC0000000000L) >> 42)).append("}]");
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void runSafely(Task task) {
        try {
            task.run();
        }
        catch (Throwable e) {
            try {
                void var1_2;
                void var2_4;
                Thread thread = Thread.currentThread();
                thread.getUncaughtExceptionHandler().uncaughtException((Thread)var2_4, (Throwable)var1_2);
            }
            catch (Throwable throwable) {
                AbstractTimeSource abstractTimeSource = AbstractTimeSourceKt.getTimeSource();
                if (abstractTimeSource == null) throw throwable;
                abstractTimeSource.unTrackTask();
                throw throwable;
            }
            AbstractTimeSource abstractTimeSource = AbstractTimeSourceKt.getTimeSource();
            if (abstractTimeSource == null) return;
            abstractTimeSource.unTrackTask();
            return;
        }
        AbstractTimeSource abstractTimeSource = AbstractTimeSourceKt.getTimeSource();
        if (abstractTimeSource == null) return;
        abstractTimeSource.unTrackTask();
        return;
    }

    static {
        parkedWorkersStack$FU = AtomicLongFieldUpdater.newUpdater(CoroutineScheduler.class, "parkedWorkersStack");
        controlState$FU = AtomicLongFieldUpdater.newUpdater(CoroutineScheduler.class, "controlState");
        _isTerminated$FU = AtomicIntegerFieldUpdater.newUpdater(CoroutineScheduler.class, "_isTerminated");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lkotlinx/coroutines/scheduling/CoroutineScheduler$Companion;", "", "()V", "BLOCKING_MASK", "", "BLOCKING_SHIFT", "", "CLAIMED", "CPU_PERMITS_MASK", "CPU_PERMITS_SHIFT", "CREATED_MASK", "MAX_SUPPORTED_POOL_SIZE", "MIN_SUPPORTED_POOL_SIZE", "NOT_IN_STACK", "Lkotlinx/coroutines/internal/Symbol;", "PARKED", "PARKED_INDEX_MASK", "PARKED_VERSION_INC", "PARKED_VERSION_MASK", "TERMINATED", "kotlinx-coroutines-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\b\u0080\u0004\u0018\u00002\u00020GB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0005J\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\n\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\n\u0010\tJ\u0017\u0010\r\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0019\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u0017\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u0015\u0010\tJ\u000f\u0010\u0016\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0011\u0010\u001d\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u001f\u0010\u001cJ\u000f\u0010 \u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b \u0010\u001cJ\u000f\u0010!\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b!\u0010\u0017J\u000f\u0010\"\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\"\u0010\u001cJ\u0015\u0010%\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020#\u00a2\u0006\u0004\b%\u0010&J\u0019\u0010(\u001a\u0004\u0018\u00010\u000b2\u0006\u0010'\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b(\u0010\u0012J\u000f\u0010)\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b)\u0010\u001cR*\u0010*\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00018\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-\"\u0004\b.\u0010\tR\u0014\u00100\u001a\u00020/8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101R\u0016\u00102\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b2\u00103R\u0016\u00105\u001a\u0002048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b5\u00106R$\u00108\u001a\u0004\u0018\u0001078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b8\u00109\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u0016\u0010>\u001a\u00020\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b>\u0010+R\u0012\u0010B\u001a\u00020?8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b@\u0010AR\u0016\u0010C\u001a\u00020#8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\bC\u0010DR\u0016\u0010E\u001a\u0002048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bE\u00106\u00a8\u0006F"}, d2={"Lkotlinx/coroutines/scheduling/CoroutineScheduler$Worker;", "", "index", "<init>", "(Lkotlinx/coroutines/scheduling/CoroutineScheduler;I)V", "(Lkotlinx/coroutines/scheduling/CoroutineScheduler;)V", "taskMode", "", "afterTask", "(I)V", "beforeTask", "Lkotlinx/coroutines/scheduling/Task;", "task", "executeTask", "(Lkotlinx/coroutines/scheduling/Task;)V", "", "scanLocalQueue", "findAnyTask", "(Z)Lkotlinx/coroutines/scheduling/Task;", "findTask", "mode", "idleReset", "inStack", "()Z", "upperBound", "nextInt", "(I)I", "park", "()V", "pollGlobalQueues", "()Lkotlinx/coroutines/scheduling/Task;", "run", "runWorker", "tryAcquireCpuPermit", "tryPark", "Lkotlinx/coroutines/scheduling/CoroutineScheduler$WorkerState;", "newState", "tryReleaseCpu", "(Lkotlinx/coroutines/scheduling/CoroutineScheduler$WorkerState;)Z", "blockingOnly", "trySteal", "tryTerminateWorker", "indexInArray", "I", "getIndexInArray", "()I", "setIndexInArray", "Lkotlinx/coroutines/scheduling/WorkQueue;", "localQueue", "Lkotlinx/coroutines/scheduling/WorkQueue;", "mayHaveLocalTasks", "Z", "", "minDelayUntilStealableTaskNs", "J", "", "nextParkedWorker", "Ljava/lang/Object;", "getNextParkedWorker", "()Ljava/lang/Object;", "setNextParkedWorker", "(Ljava/lang/Object;)V", "rngState", "Lkotlinx/coroutines/scheduling/CoroutineScheduler;", "getScheduler", "()Lkotlinx/coroutines/scheduling/CoroutineScheduler;", "scheduler", "state", "Lkotlinx/coroutines/scheduling/CoroutineScheduler$WorkerState;", "terminationDeadline", "kotlinx-coroutines-core", "Ljava/lang/Thread;"})
    public final class Worker
    extends Thread {
        private volatile int indexInArray;
        @JvmField
        public final WorkQueue localQueue;
        @JvmField
        public WorkerState state;
        volatile /* synthetic */ int workerCtl;
        static final /* synthetic */ AtomicIntegerFieldUpdater workerCtl$FU;
        private long terminationDeadline;
        private volatile Object nextParkedWorker;
        private long minDelayUntilStealableTaskNs;
        private int rngState;
        @JvmField
        public boolean mayHaveLocalTasks;
        final /* synthetic */ CoroutineScheduler this$0;

        /*
         * WARNING - void declaration
         */
        private Worker(CoroutineScheduler this$0) {
            void var1_1;
            this.this$0 = var1_1;
            this.setDaemon(true);
            this.localQueue = new WorkQueue();
            this.state = WorkerState.DORMANT;
            this.workerCtl = 0;
            this.nextParkedWorker = NOT_IN_STACK;
            this.rngState = Random.Default.nextInt();
        }

        public final int getIndexInArray() {
            return this.indexInArray;
        }

        /*
         * WARNING - void declaration
         */
        public final void setIndexInArray(int index) {
            void var1_1;
            this.setName(this.this$0.schedulerName + "-worker-" + (index == 0 ? "TERMINATED" : String.valueOf(index)));
            this.indexInArray = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Worker(CoroutineScheduler this$0, int index) {
            this((CoroutineScheduler)var1_1);
            void var2_2;
            void var1_1;
            this.setIndexInArray((int)var2_2);
        }

        public final CoroutineScheduler getScheduler() {
            return this.this$0;
        }

        public final Object getNextParkedWorker() {
            return this.nextParkedWorker;
        }

        /*
         * WARNING - void declaration
         */
        public final void setNextParkedWorker(Object object) {
            void var1_1;
            this.nextParkedWorker = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private final boolean tryAcquireCpuPermit() {
            boolean bl;
            block3: {
                long state$iv;
                long update$iv;
                void var3_3;
                CoroutineScheduler this_$iv;
                if (this.state == WorkerState.CPU_ACQUIRED) {
                    return true;
                }
                CoroutineScheduler $this$loop$iv$iv = this_$iv = this.this$0;
                do {
                    int n;
                    if ((n = (int)(((state$iv = $this$loop$iv$iv.controlState) & 0x7FFFFC0000000000L) >> 42)) != 0) continue;
                    bl = false;
                    break block3;
                } while (!controlState$FU.compareAndSet(this_$iv, (long)var3_3, update$iv = state$iv - 0x40000000000L));
                bl = true;
            }
            if (bl) {
                this.state = WorkerState.CPU_ACQUIRED;
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean tryReleaseCpu(WorkerState newState) {
            void var3_3;
            void var2_2;
            WorkerState previousState = this.state;
            boolean hadCpu = previousState == WorkerState.CPU_ACQUIRED;
            if (hadCpu) {
                CoroutineScheduler coroutineScheduler = this.this$0;
                controlState$FU.addAndGet(coroutineScheduler, 0x40000000000L);
            }
            if (var2_2 != newState) {
                void var1_1;
                this.state = var1_1;
            }
            return (boolean)var3_3;
        }

        @Override
        public final void run() {
            this.runWorker();
        }

        /*
         * WARNING - void declaration
         */
        private final void runWorker() {
            boolean rescanned = false;
            while (!this.this$0.isTerminated() && this.state != WorkerState.TERMINATED) {
                Worker worker = this;
                Task task = worker.findTask(worker.mayHaveLocalTasks);
                if (task != null) {
                    void var2_2;
                    rescanned = false;
                    this.minDelayUntilStealableTaskNs = 0L;
                    this.executeTask((Task)var2_2);
                    continue;
                }
                this.mayHaveLocalTasks = false;
                if (this.minDelayUntilStealableTaskNs != 0L) {
                    if (!rescanned) {
                        rescanned = true;
                        continue;
                    }
                    rescanned = false;
                    this.tryReleaseCpu(WorkerState.PARKING);
                    Thread.interrupted();
                    LockSupport.parkNanos(this.minDelayUntilStealableTaskNs);
                    this.minDelayUntilStealableTaskNs = 0L;
                    continue;
                }
                this.tryPark();
            }
            this.tryReleaseCpu(WorkerState.TERMINATED);
        }

        private final void tryPark() {
            if (!this.inStack()) {
                this.this$0.parkedWorkersStackPush(this);
                return;
            }
            if (DebugKt.getASSERTIONS_ENABLED() && !(this.localQueue.getSize$kotlinx_coroutines_core() == 0)) {
                throw new AssertionError();
            }
            this.workerCtl = -1;
            while (this.inStack() && this.workerCtl == -1 && !this.this$0.isTerminated() && this.state != WorkerState.TERMINATED) {
                this.tryReleaseCpu(WorkerState.PARKING);
                Thread.interrupted();
                this.park();
            }
        }

        private final boolean inStack() {
            return this.nextParkedWorker != NOT_IN_STACK;
        }

        /*
         * WARNING - void declaration
         */
        private final void executeTask(Task task) {
            void var2_3;
            void var1_1;
            Task task2 = task;
            int taskMode = task2.taskContext.getTaskMode();
            this.idleReset(taskMode);
            this.beforeTask(taskMode);
            this.this$0.runSafely((Task)var1_1);
            this.afterTask((int)var2_3);
        }

        private final void beforeTask(int taskMode) {
            if (taskMode == 0) {
                return;
            }
            if (this.tryReleaseCpu(WorkerState.BLOCKING)) {
                this.this$0.signalCpuWork();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void afterTask(int taskMode2) {
            if (taskMode2 == 0) {
                return;
            }
            CoroutineScheduler taskMode2 = this.this$0;
            controlState$FU.addAndGet(taskMode2, -2097152L);
            WorkerState currentState = this.state;
            if (currentState != WorkerState.TERMINATED) {
                void var1_2;
                if (DebugKt.getASSERTIONS_ENABLED() && !(var1_2 == WorkerState.BLOCKING)) {
                    throw new AssertionError();
                }
                this.state = WorkerState.DORMANT;
            }
        }

        /*
         * WARNING - void declaration
         */
        public final int nextInt(int upperBound) {
            void var1_1;
            void var2_2;
            int r = this.rngState;
            r ^= r << 13;
            r ^= r >> 17;
            r ^= r << 5;
            this.rngState = r;
            int mask = upperBound - 1;
            if ((mask & upperBound) == 0) {
                void var3_3;
                return r & var3_3;
            }
            return (var2_2 & Integer.MAX_VALUE) % var1_1;
        }

        private final void park() {
            if (this.terminationDeadline == 0L) {
                this.terminationDeadline = System.nanoTime() + this.this$0.idleWorkerKeepAliveNs;
            }
            LockSupport.parkNanos(this.this$0.idleWorkerKeepAliveNs);
            if (System.nanoTime() - this.terminationDeadline >= 0L) {
                this.terminationDeadline = 0L;
                this.tryTerminateWorker();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void tryTerminateWorker() {
            ResizableAtomicArray<Worker> resizableAtomicArray = this.this$0.workers;
            CoroutineScheduler coroutineScheduler = this.this$0;
            synchronized (resizableAtomicArray) {
                if (coroutineScheduler.isTerminated()) {
                    return;
                }
                CoroutineScheduler coroutineScheduler2 = coroutineScheduler;
                if ((int)(coroutineScheduler2.controlState & 0x1FFFFFL) <= coroutineScheduler.corePoolSize) {
                    return;
                }
                if (!workerCtl$FU.compareAndSet(this, -1, 1)) {
                    return;
                }
                int oldIndex = this.indexInArray;
                this.setIndexInArray(0);
                coroutineScheduler.parkedWorkersStackTopUpdate(this, oldIndex, 0);
                CoroutineScheduler coroutineScheduler3 = coroutineScheduler;
                long l = controlState$FU.getAndDecrement(coroutineScheduler3);
                int lastIndex = (int)(l & 0x1FFFFFL);
                if (lastIndex != oldIndex) {
                    void var3_5;
                    Worker worker = coroutineScheduler.workers.get(lastIndex);
                    Intrinsics.checkNotNull((Object)worker);
                    Worker lastWorker = worker;
                    coroutineScheduler.workers.setSynchronized(oldIndex, lastWorker);
                    lastWorker.setIndexInArray(oldIndex);
                    coroutineScheduler.parkedWorkersStackTopUpdate(lastWorker, lastIndex, (int)var3_5);
                }
                coroutineScheduler.workers.setSynchronized(lastIndex, null);
            }
            this.state = WorkerState.TERMINATED;
        }

        /*
         * WARNING - void declaration
         */
        private final void idleReset(int mode) {
            this.terminationDeadline = 0L;
            if (this.state == WorkerState.PARKING) {
                void var1_1;
                if (DebugKt.getASSERTIONS_ENABLED() && !(var1_1 == true)) {
                    throw new AssertionError();
                }
                this.state = WorkerState.BLOCKING;
            }
        }

        /*
         * WARNING - void declaration
         */
        public final Task findTask(boolean scanLocalQueue) {
            Task task;
            void var1_1;
            if (this.tryAcquireCpuPermit()) {
                return this.findAnyTask(scanLocalQueue);
            }
            if (var1_1 == false || (task = this.localQueue.poll()) == null) {
                task = (Task)this.this$0.globalBlockingQueue.removeFirstOrNull();
            }
            Task task2 = task;
            Task task3 = task;
            if (task == null) {
                task3 = this.trySteal(true);
            }
            return task3;
        }

        /*
         * WARNING - void declaration
         */
        private final Task findAnyTask(boolean scanLocalQueue) {
            if (scanLocalQueue) {
                void var1_1;
                Task task;
                boolean globalFirst2 = this.nextInt(2 * this.this$0.corePoolSize) == 0;
                if (globalFirst2 && (task = this.pollGlobalQueues()) != null) {
                    Task globalFirst2 = task;
                    return globalFirst2;
                }
                task = this.localQueue.poll();
                if (task != null) {
                    Task globalFirst2 = task;
                    return globalFirst2;
                }
                if (var1_1 == false && (task = this.pollGlobalQueues()) != null) {
                    Task task2 = task;
                    return task2;
                }
            } else {
                Task task = this.pollGlobalQueues();
                if (task != null) {
                    return task;
                }
            }
            return this.trySteal(false);
        }

        private final Task pollGlobalQueues() {
            if (this.nextInt(2) == 0) {
                Task task = (Task)this.this$0.globalCpuQueue.removeFirstOrNull();
                if (task != null) {
                    return task;
                }
                return (Task)this.this$0.globalBlockingQueue.removeFirstOrNull();
            }
            Task task = (Task)this.this$0.globalBlockingQueue.removeFirstOrNull();
            if (task != null) {
                return task;
            }
            return (Task)this.this$0.globalCpuQueue.removeFirstOrNull();
        }

        private final Task trySteal(boolean blockingOnly) {
            if (DebugKt.getASSERTIONS_ENABLED() && !(this.localQueue.getSize$kotlinx_coroutines_core() == 0)) {
                throw new AssertionError();
            }
            CoroutineScheduler coroutineScheduler = this.this$0;
            int created = (int)(coroutineScheduler.controlState & 0x1FFFFFL);
            if (created < 2) {
                return null;
            }
            int currentIndex = this.nextInt(created);
            long minDelay = Long.MAX_VALUE;
            CoroutineScheduler coroutineScheduler2 = this.this$0;
            for (int i = 0; i < created; ++i) {
                Worker worker;
                if (++currentIndex > created) {
                    currentIndex = 1;
                }
                if ((worker = coroutineScheduler2.workers.get(currentIndex)) == null || worker == this) continue;
                if (DebugKt.getASSERTIONS_ENABLED() && !(this.localQueue.getSize$kotlinx_coroutines_core() == 0)) {
                    throw new AssertionError();
                }
                long stealResult = blockingOnly ? this.localQueue.tryStealBlockingFrom(worker.localQueue) : this.localQueue.tryStealFrom(worker.localQueue);
                if (stealResult == -1L) {
                    return this.localQueue.poll();
                }
                if (stealResult <= 0L) continue;
                minDelay = Math.min(minDelay, stealResult);
            }
            this.minDelayUntilStealableTaskNs = minDelay != Long.MAX_VALUE ? minDelay : 0L;
            return null;
        }

        static {
            workerCtl$FU = AtomicIntegerFieldUpdater.newUpdater(Worker.class, "workerCtl");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lkotlinx/coroutines/scheduling/CoroutineScheduler$WorkerState;", "", "(Ljava/lang/String;I)V", "CPU_ACQUIRED", "BLOCKING", "PARKING", "DORMANT", "TERMINATED", "kotlinx-coroutines-core"})
    public static final class WorkerState
    extends Enum<WorkerState> {
        public static final /* enum */ WorkerState CPU_ACQUIRED = new WorkerState();
        public static final /* enum */ WorkerState BLOCKING = new WorkerState();
        public static final /* enum */ WorkerState PARKING = new WorkerState();
        public static final /* enum */ WorkerState DORMANT = new WorkerState();
        public static final /* enum */ WorkerState TERMINATED = new WorkerState();
        private static final /* synthetic */ WorkerState[] $VALUES;

        /*
         * WARNING - void declaration
         */
        private WorkerState() {
            void var2_2;
            void var1_1;
        }

        public static WorkerState[] values() {
            return (WorkerState[])$VALUES.clone();
        }

        public static WorkerState valueOf(String value) {
            String string;
            return Enum.valueOf(WorkerState.class, string);
        }

        private static final /* synthetic */ WorkerState[] $values() {
            WorkerState[] workerStateArray = new WorkerState[5];
            WorkerState[] workerStateArray2 = workerStateArray;
            workerStateArray[0] = CPU_ACQUIRED;
            workerStateArray2[1] = BLOCKING;
            workerStateArray2[2] = PARKING;
            workerStateArray2[3] = DORMANT;
            workerStateArray2[4] = TERMINATED;
            return workerStateArray2;
        }

        static {
            $VALUES = WorkerState.$values();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WorkerState.values().length];
            int[] nArray2 = nArray;
            nArray[WorkerState.PARKING.ordinal()] = 1;
            nArray2[WorkerState.BLOCKING.ordinal()] = 2;
            nArray2[WorkerState.CPU_ACQUIRED.ordinal()] = 3;
            nArray2[WorkerState.DORMANT.ordinal()] = 4;
            nArray2[WorkerState.TERMINATED.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray2;
        }
    }
}

