/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.scheduling;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import kotlin.Metadata;
import kotlinx.coroutines.DebugKt;
import kotlinx.coroutines.scheduling.GlobalQueue;
import kotlinx.coroutines.scheduling.Task;
import kotlinx.coroutines.scheduling.TasksKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0000\b\u0000\u0018\u00002\u00020*B\u0007\u00a2\u0006\u0004\b\u0001\u0010\u0002J!\u0010\u0007\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\t\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0011\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u0017\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0015\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0000\u00a2\u0006\u0004\b\u001a\u0010\u0019J\u001f\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0015\u0010\u001e\u001a\u00020\r*\u0004\u0018\u00010\u0003H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u001c\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0014\u0010&\u001a\u00020#8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010(\u001a\u00020#8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010%\u00a8\u0006)"}, d2={"Lkotlinx/coroutines/scheduling/WorkQueue;", "<init>", "()V", "Lkotlinx/coroutines/scheduling/Task;", "task", "", "fair", "add", "(Lkotlinx/coroutines/scheduling/Task;Z)Lkotlinx/coroutines/scheduling/Task;", "addLast", "(Lkotlinx/coroutines/scheduling/Task;)Lkotlinx/coroutines/scheduling/Task;", "Lkotlinx/coroutines/scheduling/GlobalQueue;", "globalQueue", "", "offloadAllWorkTo", "(Lkotlinx/coroutines/scheduling/GlobalQueue;)V", "poll", "()Lkotlinx/coroutines/scheduling/Task;", "pollBuffer", "queue", "pollTo", "(Lkotlinx/coroutines/scheduling/GlobalQueue;)Z", "victim", "", "tryStealBlockingFrom", "(Lkotlinx/coroutines/scheduling/WorkQueue;)J", "tryStealFrom", "blockingOnly", "tryStealLastScheduled", "(Lkotlinx/coroutines/scheduling/WorkQueue;Z)J", "decrementIfBlocking", "(Lkotlinx/coroutines/scheduling/Task;)V", "Ljava/util/concurrent/atomic/AtomicReferenceArray;", "buffer", "Ljava/util/concurrent/atomic/AtomicReferenceArray;", "", "getBufferSize$kotlinx_coroutines_core", "()I", "bufferSize", "getSize$kotlinx_coroutines_core", "size", "kotlinx-coroutines-core", ""})
public final class WorkQueue {
    private final AtomicReferenceArray<Task> buffer = new AtomicReferenceArray(128);
    private volatile /* synthetic */ Object lastScheduledTask;
    private static final /* synthetic */ AtomicReferenceFieldUpdater lastScheduledTask$FU;
    private volatile /* synthetic */ int producerIndex;
    private static final /* synthetic */ AtomicIntegerFieldUpdater producerIndex$FU;
    private volatile /* synthetic */ int consumerIndex;
    private static final /* synthetic */ AtomicIntegerFieldUpdater consumerIndex$FU;
    private volatile /* synthetic */ int blockingTasksInBuffer;
    private static final /* synthetic */ AtomicIntegerFieldUpdater blockingTasksInBuffer$FU;

    public WorkQueue() {
        this.lastScheduledTask = null;
        this.producerIndex = 0;
        this.consumerIndex = 0;
        this.blockingTasksInBuffer = 0;
    }

    public final int getBufferSize$kotlinx_coroutines_core() {
        return this.producerIndex - this.consumerIndex;
    }

    public final int getSize$kotlinx_coroutines_core() {
        if (this.lastScheduledTask != null) {
            return this.getBufferSize$kotlinx_coroutines_core() + 1;
        }
        return this.getBufferSize$kotlinx_coroutines_core();
    }

    public final Task poll() {
        Task task = lastScheduledTask$FU.getAndSet(this, null);
        if (task == null) {
            task = this.pollBuffer();
        }
        return task;
    }

    /*
     * WARNING - void declaration
     */
    public final Task add(Task task, boolean fair) {
        void var1_1;
        if (fair) {
            return this.addLast(task);
        }
        Task task2 = lastScheduledTask$FU.getAndSet(this, task);
        if (task2 == null) {
            return null;
        }
        Task previous = task2;
        return this.addLast((Task)var1_1);
    }

    public static /* synthetic */ Task add$default(WorkQueue workQueue, Task task, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return workQueue.add(task, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final Task addLast(Task task) {
        void var1_1;
        void var2_3;
        Task task2 = task;
        if (task2.taskContext.getTaskMode() == 1) {
            blockingTasksInBuffer$FU.incrementAndGet(this);
        }
        if (this.getBufferSize$kotlinx_coroutines_core() == 127) {
            return task;
        }
        int nextIndex = this.producerIndex & 0x7F;
        while (this.buffer.get(nextIndex) != null) {
            Thread.yield();
        }
        this.buffer.lazySet((int)var2_3, (Task)var1_1);
        producerIndex$FU.incrementAndGet(this);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final long tryStealFrom(WorkQueue victim) {
        void var1_1;
        if (DebugKt.getASSERTIONS_ENABLED() && !(this.getBufferSize$kotlinx_coroutines_core() == 0)) {
            throw new AssertionError();
        }
        Task task = victim.pollBuffer();
        if (task != null) {
            void var2_2;
            Task notAdded = WorkQueue.add$default(this, (Task)var2_2, false, 2, null);
            if (DebugKt.getASSERTIONS_ENABLED() && !(var1_1 == null)) {
                throw new AssertionError();
            }
            return -1L;
        }
        return this.tryStealLastScheduled((WorkQueue)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public final long tryStealBlockingFrom(WorkQueue victim) {
        void var1_1;
        if (DebugKt.getASSERTIONS_ENABLED() && !(this.getBufferSize$kotlinx_coroutines_core() == 0)) {
            throw new AssertionError();
        }
        int end = victim.producerIndex;
        AtomicReferenceArray<Task> buffer = victim.buffer;
        for (int start = victim.consumerIndex; start != end; ++start) {
            int index = start & 0x7F;
            if (victim.blockingTasksInBuffer == 0) break;
            Task value = buffer.get(index);
            if (value == null) continue;
            Task task = value;
            if (!(task.taskContext.getTaskMode() == 1) || !buffer.compareAndSet(index, value, null)) continue;
            blockingTasksInBuffer$FU.decrementAndGet(victim);
            WorkQueue.add$default(this, value, false, 2, null);
            return -1L;
        }
        return this.tryStealLastScheduled((WorkQueue)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public final void offloadAllWorkTo(GlobalQueue globalQueue) {
        Task task = lastScheduledTask$FU.getAndSet(this, null);
        if (task != null) {
            void var2_2;
            Task it = task;
            globalQueue.addLast(var2_2);
        }
        while (this.pollTo(globalQueue)) {
        }
    }

    /*
     * WARNING - void declaration
     */
    private final long tryStealLastScheduled(WorkQueue victim, boolean blockingOnly) {
        void var3_3;
        Task lastScheduled;
        do {
            long l;
            long staleness;
            if ((Task)victim.lastScheduledTask == null) {
                return -2L;
            }
            if (blockingOnly) {
                Task task = lastScheduled;
                if (!(task.taskContext.getTaskMode() == 1)) {
                    return -2L;
                }
            }
            if ((staleness = (l = TasksKt.schedulerTimeSource.nanoTime()) - lastScheduled.submissionTime) >= TasksKt.WORK_STEALING_TIME_RESOLUTION_NS) continue;
            return TasksKt.WORK_STEALING_TIME_RESOLUTION_NS - staleness;
        } while (!lastScheduledTask$FU.compareAndSet(victim, lastScheduled, null));
        WorkQueue.add$default(this, (Task)var3_3, false, 2, null);
        return -1L;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean pollTo(GlobalQueue queue) {
        void var2_2;
        void var1_1;
        Task task = this.pollBuffer();
        if (task == null) {
            return false;
        }
        Task task2 = task;
        var1_1.addLast(var2_2);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final Task pollBuffer() {
        void var1_2;
        Task task;
        while (true) {
            void var2_3;
            int tailLocal;
            if ((tailLocal = this.consumerIndex) - this.producerIndex == 0) {
                return null;
            }
            int index = tailLocal & 0x7F;
            int n = tailLocal;
            if (!consumerIndex$FU.compareAndSet(this, n, n + 1)) continue;
            task = this.buffer.getAndSet((int)var2_3, null);
            if (task != null) break;
        }
        Task value = task;
        this.decrementIfBlocking(value);
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private final void decrementIfBlocking(Task $this$decrementIfBlocking) {
        if ($this$decrementIfBlocking != null && $this$decrementIfBlocking.taskContext.getTaskMode() == 1) {
            void var1_2;
            int value = blockingTasksInBuffer$FU.decrementAndGet(this);
            if (DebugKt.getASSERTIONS_ENABLED() && !(var1_2 >= 0)) {
                throw new AssertionError();
            }
        }
    }

    static {
        lastScheduledTask$FU = AtomicReferenceFieldUpdater.newUpdater(WorkQueue.class, Object.class, "lastScheduledTask");
        producerIndex$FU = AtomicIntegerFieldUpdater.newUpdater(WorkQueue.class, "producerIndex");
        consumerIndex$FU = AtomicIntegerFieldUpdater.newUpdater(WorkQueue.class, "consumerIndex");
        blockingTasksInBuffer$FU = AtomicIntegerFieldUpdater.newUpdater(WorkQueue.class, "blockingTasksInBuffer");
    }
}

