/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.sync;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.CancellableContinuationKt;
import kotlinx.coroutines.DebugKt;
import kotlinx.coroutines.internal.ConcurrentLinkedListKt;
import kotlinx.coroutines.internal.ConcurrentLinkedListNode;
import kotlinx.coroutines.internal.Segment;
import kotlinx.coroutines.internal.SegmentOrClosed;
import kotlinx.coroutines.internal.Symbol;
import kotlinx.coroutines.sync.CancelSemaphoreAcquisitionHandler;
import kotlinx.coroutines.sync.Semaphore;
import kotlinx.coroutines.sync.SemaphoreKt;
import kotlinx.coroutines.sync.SemaphoreSegment;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\b\u0002\u0018\u00002\u00020\u001eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\u0007\u001a\u00020\u0006H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\t\u001a\u00020\u0006H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\t\u0010\bJ\u001d\u0010\r\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u0019\u0010\u0014\u001a\u00020\f*\b\u0012\u0004\u0012\u00020\u00060\nH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u000eR\u0014\u0010\u0017\u001a\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R \u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00060\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0002\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0002\u0010\u001c\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001d"}, d2={"Lkotlinx/coroutines/sync/SemaphoreImpl;", "", "permits", "acquiredPermits", "<init>", "(II)V", "", "acquire", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "acquireSlowPath", "Lkotlinx/coroutines/CancellableContinuation;", "cont", "", "addAcquireToQueue", "(Lkotlinx/coroutines/CancellableContinuation;)Z", "release", "()V", "tryAcquire", "()Z", "tryResumeNextFromQueue", "tryResumeAcquire", "getAvailablePermits", "()I", "availablePermits", "Lkotlin/Function1;", "", "onCancellationRelease", "Lkotlin/jvm/functions/Function1;", "I", "kotlinx-coroutines-core", "Lkotlinx/coroutines/sync/Semaphore;"})
final class SemaphoreImpl
implements Semaphore {
    private final int permits;
    private volatile /* synthetic */ Object head;
    private static final /* synthetic */ AtomicReferenceFieldUpdater head$FU;
    private volatile /* synthetic */ long deqIdx;
    private static final /* synthetic */ AtomicLongFieldUpdater deqIdx$FU;
    private volatile /* synthetic */ Object tail;
    private static final /* synthetic */ AtomicReferenceFieldUpdater tail$FU;
    private volatile /* synthetic */ long enqIdx;
    private static final /* synthetic */ AtomicLongFieldUpdater enqIdx$FU;
    volatile /* synthetic */ int _availablePermits;
    static final /* synthetic */ AtomicIntegerFieldUpdater _availablePermits$FU;
    private final Function1<Throwable, Unit> onCancellationRelease;

    /*
     * WARNING - void declaration
     */
    public SemaphoreImpl(int permits2, int acquiredPermits) {
        void var2_5;
        void var1_4;
        this.permits = permits2;
        this.deqIdx = 0L;
        this.enqIdx = 0L;
        if (!(this.permits > 0)) {
            String permits2 = "Semaphore should have at least 1 permit, but had " + this.permits;
            throw new IllegalArgumentException(permits2.toString());
        }
        if (!(acquiredPermits >= 0 ? acquiredPermits <= this.permits : false)) {
            String permits2 = "The number of acquired permits should be in 0.." + this.permits;
            throw new IllegalArgumentException(permits2.toString());
        }
        SemaphoreSegment s = new SemaphoreSegment(0L, null, 2);
        this.head = s;
        this.tail = var1_4;
        this._availablePermits = this.permits - var2_5;
        this.onCancellationRelease = (Function1)new Function1<Throwable, Unit>(this){
            final /* synthetic */ SemaphoreImpl this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(1);
            }

            public final void invoke(Throwable throwable) {
                this.this$0.release();
            }
        };
    }

    @Override
    public final int getAvailablePermits() {
        return Math.max(this._availablePermits, 0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean tryAcquire() {
        void v0;
        SemaphoreImpl $this$loop$iv = this;
        do {
            void var2_2;
            int p;
            if ((p = $this$loop$iv._availablePermits) <= 0) {
                return false;
            }
            v0 = var2_2;
        } while (!_availablePermits$FU.compareAndSet(this, (int)v0, (int)(v0 - true)));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object acquire(Continuation<? super Unit> $completion) {
        void var1_1;
        int n = _availablePermits$FU.getAndDecrement(this);
        if (n > 0) {
            return Unit.INSTANCE;
        }
        Object object = this.acquireSlowPath((Continuation<? super Unit>)var1_1);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final Object acquireSlowPath(Continuation<? super Unit> $completion) {
        Continuation<? super Unit> continuation = $completion;
        CancellableContinuationImpl cancellable$iv = CancellableContinuationKt.getOrCreateCancellableContinuation(IntrinsicsKt.intercepted(continuation));
        CancellableContinuation cont = cancellable$iv;
        while (!SemaphoreImpl.access$addAcquireToQueue(this, cont)) {
            void var3_3;
            int n = _availablePermits$FU.getAndDecrement(this);
            if (n <= 0) continue;
            var3_3.resume(Unit.INSTANCE, (Function1<? super Throwable, Unit>)this.onCancellationRelease);
            break;
        }
        Object object = continuation.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            void var1_1;
            DebugProbesKt.probeCoroutineSuspended((Continuation)var1_1);
        }
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void release() {
        do {
            void var2_3;
            void var3_4;
            int cur$iv;
            Object $this$getAndUpdate$iv = this;
            do {
                if (!((cur$iv = ((SemaphoreImpl)$this$getAndUpdate$iv)._availablePermits) < this.permits)) {
                    $this$getAndUpdate$iv = "The number of released permits cannot be greater than " + this.permits;
                    throw new IllegalStateException($this$getAndUpdate$iv.toString());
                }
                int upd$iv = cur$iv + 1;
            } while (!_availablePermits$FU.compareAndSet($this$getAndUpdate$iv, cur$iv, (int)var3_4));
            void var1_1 = var2_3;
            if (var1_1 < 0) continue;
            return;
        } while (!this.tryResumeNextFromQueue());
    }

    /*
     * WARNING - void declaration
     */
    private final boolean addAcquireToQueue(CancellableContinuation<? super Unit> cont) {
        void var3_4;
        Object this_$iv;
        Object s$iv;
        boolean bl;
        SemaphoreSegment curTail = (SemaphoreSegment)this.tail;
        long enqIdx = enqIdx$FU.getAndIncrement(this);
        SemaphoreImpl semaphoreImpl = this;
        long id$iv22 = enqIdx / (long)SemaphoreKt.access$getSEGMENT_SIZE$p();
        block0: do {
            void $this$moveForward$iv$iv;
            void $this$findSegmentAndMoveForward$iv;
            Object object;
            Segment cur$iv$iv;
            block14: {
                Segment segment;
                cur$iv$iv = segment = (Segment)curTail;
                while (cur$iv$iv.getId() < id$iv22 || cur$iv$iv.getRemoved()) {
                    void p1;
                    ConcurrentLinkedListNode concurrentLinkedListNode = cur$iv$iv;
                    Object it$iv$iv$iv = ConcurrentLinkedListNode.access$getNextOrClosed(concurrentLinkedListNode);
                    if (it$iv$iv$iv == ConcurrentLinkedListKt.access$getCLOSED$p()) {
                        object = SegmentOrClosed.constructor-impl(ConcurrentLinkedListKt.access$getCLOSED$p());
                        break block14;
                    }
                    Segment next$iv$iv = (Segment)((ConcurrentLinkedListNode)it$iv$iv$iv);
                    if (next$iv$iv != null) {
                        cur$iv$iv = next$iv$iv;
                        continue;
                    }
                    next$iv$iv = (SemaphoreSegment)cur$iv$iv;
                    long l = cur$iv$iv.getId() + 1L;
                    Segment newTail$iv$iv = SemaphoreKt.access$createSegment(l, (SemaphoreSegment)p1);
                    if (!cur$iv$iv.trySetNext((ConcurrentLinkedListNode)newTail$iv$iv)) continue;
                    if (cur$iv$iv.getRemoved()) {
                        cur$iv$iv.remove();
                    }
                    cur$iv$iv = newTail$iv$iv;
                }
                object = s$iv = SegmentOrClosed.constructor-impl(cur$iv$iv);
            }
            if (SegmentOrClosed.isClosed-impl(object)) break;
            cur$iv$iv = $this$findSegmentAndMoveForward$iv;
            Object to$iv$iv = SegmentOrClosed.getSegment-impl(s$iv);
            void $this$loop$iv$iv$iv = $this$moveForward$iv$iv;
            while (true) {
                Segment cur$iv$iv2;
                if ((cur$iv$iv2 = (Segment)$this$loop$iv$iv$iv.tail).getId() >= ((Segment)to$iv$iv).getId()) {
                    bl = true;
                    continue block0;
                }
                if (!((Segment)to$iv$iv).tryIncPointers$kotlinx_coroutines_core()) {
                    bl = false;
                    continue block0;
                }
                if (tail$FU.compareAndSet($this$moveForward$iv$iv, cur$iv$iv2, to$iv$iv)) {
                    if (cur$iv$iv2.decPointers$kotlinx_coroutines_core()) {
                        cur$iv$iv2.remove();
                    }
                    bl = true;
                    continue block0;
                }
                if (!((Segment)to$iv$iv).decPointers$kotlinx_coroutines_core()) continue;
                ((ConcurrentLinkedListNode)to$iv$iv).remove();
            }
        } while (!bl);
        SemaphoreSegment segment = (SemaphoreSegment)SegmentOrClosed.getSegment-impl(s$iv);
        int i = (int)(enqIdx % (long)SemaphoreKt.access$getSEGMENT_SIZE$p());
        SemaphoreSegment id$iv22 = segment;
        Symbol expected$iv = null;
        if (((SemaphoreSegment)this_$iv).acquirers.compareAndSet(i, expected$iv, cont)) {
            this_$iv = new CancelSemaphoreAcquisitionHandler(segment, i);
            cont.invokeOnCancellation((Function1<Throwable, Unit>)((Function1)this_$iv));
            return true;
        }
        this_$iv = segment;
        expected$iv = SemaphoreKt.access$getPERMIT$p();
        Symbol value$iv = SemaphoreKt.access$getTAKEN$p();
        if (((SemaphoreSegment)this_$iv).acquirers.compareAndSet(i, expected$iv, var3_4)) {
            void var1_1;
            var1_1.resume(Unit.INSTANCE, this.onCancellationRelease);
            return true;
        }
        if (DebugKt.getASSERTIONS_ENABLED()) {
            void var2_2;
            void var8_15 = var2_2;
            if (!(var8_15.acquirers.get(i) == SemaphoreKt.access$getBROKEN$p())) {
                throw new AssertionError();
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryResumeNextFromQueue() {
        void var2_3;
        void this_$iv222;
        SemaphoreSegment $this$moveForward$iv$iv;
        Object s$iv;
        boolean bl;
        SemaphoreSegment curHead = (SemaphoreSegment)this.head;
        long deqIdx = deqIdx$FU.getAndIncrement(this);
        long id = deqIdx / (long)SemaphoreKt.access$getSEGMENT_SIZE$p();
        SemaphoreImpl $this$findSegmentAndMoveForward$iv = this;
        block0: do {
            SemaphoreImpl p1;
            Object object;
            block14: {
                Segment segment;
                Segment cur$iv$iv = segment = (Segment)curHead;
                while (cur$iv$iv.getId() < id || cur$iv$iv.getRemoved()) {
                    ConcurrentLinkedListNode concurrentLinkedListNode = cur$iv$iv;
                    Object it$iv$iv$iv = ConcurrentLinkedListNode.access$getNextOrClosed(concurrentLinkedListNode);
                    if (it$iv$iv$iv == ConcurrentLinkedListKt.access$getCLOSED$p()) {
                        object = SegmentOrClosed.constructor-impl(ConcurrentLinkedListKt.access$getCLOSED$p());
                        break block14;
                    }
                    Segment next$iv$iv = (Segment)((ConcurrentLinkedListNode)it$iv$iv$iv);
                    if (next$iv$iv != null) {
                        cur$iv$iv = next$iv$iv;
                        continue;
                    }
                    next$iv$iv = (SemaphoreSegment)cur$iv$iv;
                    long l = cur$iv$iv.getId() + 1L;
                    Segment newTail$iv$iv = SemaphoreKt.access$createSegment(l, (SemaphoreSegment)((Object)p1));
                    if (!cur$iv$iv.trySetNext((ConcurrentLinkedListNode)newTail$iv$iv)) continue;
                    if (cur$iv$iv.getRemoved()) {
                        cur$iv$iv.remove();
                    }
                    cur$iv$iv = newTail$iv$iv;
                }
                object = s$iv = SegmentOrClosed.constructor-impl(cur$iv$iv);
            }
            if (SegmentOrClosed.isClosed-impl(object)) break;
            p1 = $this$findSegmentAndMoveForward$iv;
            Object to$iv$iv = SegmentOrClosed.getSegment-impl(s$iv);
            void $this$loop$iv$iv$iv = $this$moveForward$iv$iv;
            while (true) {
                Segment cur$iv$iv;
                if ((cur$iv$iv = (Segment)$this$loop$iv$iv$iv.head).getId() >= ((Segment)to$iv$iv).getId()) {
                    bl = true;
                    continue block0;
                }
                if (!((Segment)to$iv$iv).tryIncPointers$kotlinx_coroutines_core()) {
                    bl = false;
                    continue block0;
                }
                if (head$FU.compareAndSet($this$moveForward$iv$iv, cur$iv$iv, to$iv$iv)) {
                    if (cur$iv$iv.decPointers$kotlinx_coroutines_core()) {
                        cur$iv$iv.remove();
                    }
                    bl = true;
                    continue block0;
                }
                if (!((Segment)to$iv$iv).decPointers$kotlinx_coroutines_core()) continue;
                ((ConcurrentLinkedListNode)to$iv$iv).remove();
            }
        } while (!bl);
        SemaphoreSegment segment = (SemaphoreSegment)SegmentOrClosed.getSegment-impl(s$iv);
        segment.cleanPrev();
        if (segment.getId() > id) {
            return false;
        }
        int i = (int)(deqIdx % (long)SemaphoreKt.access$getSEGMENT_SIZE$p());
        $this$moveForward$iv$iv = segment;
        Symbol value$iv2 = SemaphoreKt.access$getPERMIT$p();
        Object cellState = this_$iv222.acquirers.getAndSet(i, value$iv2);
        if (cellState == null) {
            void expected$iv;
            void var1_1;
            int this_$iv222 = SemaphoreKt.access$getMAX_SPIN_CYCLES$p();
            for (int value$iv2 = 0; value$iv2 < this_$iv222; ++value$iv2) {
                cellState = segment;
                if (((SemaphoreSegment)cellState).acquirers.get(i) != SemaphoreKt.access$getTAKEN$p()) continue;
                return true;
            }
            void this_$iv222 = var1_1;
            Symbol value$iv2 = SemaphoreKt.access$getPERMIT$p();
            Symbol value$iv3 = SemaphoreKt.access$getBROKEN$p();
            return !this_$iv222.acquirers.compareAndSet(i, expected$iv, value$iv3);
        }
        if (cellState == SemaphoreKt.access$getCANCELLED$p()) {
            return false;
        }
        return this.tryResumeAcquire((CancellableContinuation)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryResumeAcquire(CancellableContinuation<? super Unit> $this$tryResumeAcquire) {
        void var2_2;
        void var1_1;
        Object object = $this$tryResumeAcquire.tryResume((Unit)Unit.INSTANCE, null, this.onCancellationRelease);
        if (object == null) {
            return false;
        }
        Object token = object;
        var1_1.completeResume(var2_2);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Object access$acquireSlowPath(SemaphoreImpl $this, Continuation $completion) {
        void var1_1;
        return $this.acquireSlowPath((Continuation<? super Unit>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean access$addAcquireToQueue(SemaphoreImpl $this, CancellableContinuation cont) {
        void var1_1;
        return $this.addAcquireToQueue((CancellableContinuation<? super Unit>)var1_1);
    }

    static {
        head$FU = AtomicReferenceFieldUpdater.newUpdater(SemaphoreImpl.class, Object.class, "head");
        deqIdx$FU = AtomicLongFieldUpdater.newUpdater(SemaphoreImpl.class, "deqIdx");
        tail$FU = AtomicReferenceFieldUpdater.newUpdater(SemaphoreImpl.class, Object.class, "tail");
        enqIdx$FU = AtomicLongFieldUpdater.newUpdater(SemaphoreImpl.class, "enqIdx");
        _availablePermits$FU = AtomicIntegerFieldUpdater.newUpdater(SemaphoreImpl.class, "_availablePermits");
    }
}

