/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.joda.time.tz.DateTimeZoneBuilder;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.event.SubstituteLoggingEvent;
import org.slf4j.helpers.SubstituteLogger;
import org.slf4j.helpers.Util;
import org.slf4j.impl.StaticLoggerBinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LoggerFactory {
    private static volatile int INITIALIZATION_STATE = 0;
    private static Util.1 SUBST_FACTORY$43548378 = new ILoggerFactory(){
        private boolean postInitialization = false;
        private Map<String, SubstituteLogger> loggers = new HashMap<String, SubstituteLogger>();
        private LinkedBlockingQueue<SubstituteLoggingEvent> eventQueue = new LinkedBlockingQueue();

        /*
         * WARNING - void declaration
         */
        @Override
        public synchronized Logger getLogger(String name) {
            void var2_2;
            SubstituteLogger logger = this.loggers.get(name);
            if (logger == null) {
                void var1_1;
                logger = new SubstituteLogger(name, this.eventQueue, this.postInitialization);
                this.loggers.put((String)var1_1, logger);
            }
            return var2_2;
        }

        public List<SubstituteLogger> getLoggers() {
            return new ArrayList<SubstituteLogger>(this.loggers.values());
        }

        public LinkedBlockingQueue<SubstituteLoggingEvent> getEventQueue() {
            return this.eventQueue;
        }

        public void postInitialization() {
            this.postInitialization = true;
        }

        public void clear() {
            this.loggers.clear();
            this.eventQueue.clear();
        }
    };
    private static DateTimeZoneBuilder NOP_FALLBACK_FACTORY$3d653843 = new DateTimeZoneBuilder();
    private static boolean DETECT_LOGGER_NAME_MISMATCH = Util.safeGetBooleanSystemProperty("slf4j.detectLoggerNameMismatch");
    private static final String[] API_COMPATIBILITY_LIST = new String[]{"1.6", "1.7"};
    private static String STATIC_LOGGER_BINDER_PATH = "org/slf4j/impl/StaticLoggerBinder.class";

    private LoggerFactory() {
    }

    private static void postBindCleanUp() {
        LoggerFactory.fixSubstituteLoggers();
        LoggerFactory.replayEvents();
        SUBST_FACTORY$43548378.clear();
    }

    /*
     * WARNING - void declaration
     */
    private static void fixSubstituteLoggers() {
        Util.1 var0 = SUBST_FACTORY$43548378;
        synchronized (var0) {
            SUBST_FACTORY$43548378.postInitialization();
            for (SubstituteLogger substLogger : SUBST_FACTORY$43548378.getLoggers()) {
                void var3_4;
                void var2_3;
                Logger logger = LoggerFactory.getLogger(substLogger.getName());
                var2_3.setDelegate((Logger)var3_4);
            }
            return;
        }
    }

    private static void failedBinding(Throwable t) {
        Throwable throwable;
        INITIALIZATION_STATE = 2;
        Util.report("Failed to instantiate SLF4J LoggerFactory", throwable);
    }

    private static void replayEvents() {
        int n;
        LinkedBlockingQueue<SubstituteLoggingEvent> queue = SUBST_FACTORY$43548378.getEventQueue();
        int queueSize = queue.size();
        int count = 0;
        ArrayList eventList = new ArrayList(128);
        while ((n = queue.drainTo(eventList, 128)) != 0) {
            for (SubstituteLoggingEvent event : eventList) {
                LoggerFactory.replaySingleEvent(event);
                if (count++ != 0) continue;
                LoggerFactory.emitReplayOrSubstituionWarning(event, queueSize);
            }
            eventList.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void emitReplayOrSubstituionWarning(SubstituteLoggingEvent event, int queueSize) {
        SubstituteLoggingEvent substituteLoggingEvent;
        if (event.getLogger().isDelegateEventAware()) {
            void var1_1;
            LoggerFactory.emitReplayWarning((int)var1_1);
            return;
        }
        if (!substituteLoggingEvent.getLogger().isDelegateNOP()) {
            LoggerFactory.emitSubstitutionWarning();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void replaySingleEvent(SubstituteLoggingEvent event) {
        if (event == null) {
            return;
        }
        SubstituteLogger substLogger = event.getLogger();
        String loggerName = substLogger.getName();
        if (substLogger.isDelegateNull()) {
            throw new IllegalStateException("Delegate logger cannot be null at this state.");
        }
        if (!substLogger.isDelegateNOP()) {
            void var2_2;
            if (substLogger.isDelegateEventAware()) {
                SubstituteLoggingEvent substituteLoggingEvent;
                void var1_1;
                var1_1.log(substituteLoggingEvent);
                return;
            }
            Util.report((String)var2_2);
        }
    }

    private static void emitSubstitutionWarning() {
        Util.report("The following set of substitute loggers may have been accessed");
        Util.report("during the initialization phase. Logging calls during this");
        Util.report("phase were not honored. However, subsequent logging calls to these");
        Util.report("loggers will work as normally expected.");
        Util.report("See also http://www.slf4j.org/codes.html#substituteLogger");
    }

    private static void emitReplayWarning(int eventCount) {
        int n;
        Util.report("A number (" + n + ") of logging calls during the initialization phase have been intercepted and are");
        Util.report("now being replayed. These are subject to the filtering rules of the underlying logging system.");
        Util.report("See also http://www.slf4j.org/codes.html#replay");
    }

    /*
     * WARNING - void declaration
     */
    private static final void versionSanityCheck() {
        try {
            void var1_2;
            String requested = StaticLoggerBinder.REQUESTED_API_VERSION;
            boolean match = false;
            String[] stringArray = API_COMPATIBILITY_LIST;
            int n = API_COMPATIBILITY_LIST.length;
            for (int i = 0; i < n; ++i) {
                String aAPI_COMPATIBILITY_LIST = stringArray[i];
                if (!requested.startsWith(aAPI_COMPATIBILITY_LIST)) continue;
                match = true;
            }
            if (var1_2 == false) {
                Util.report("The requested version " + requested + " by your slf4j binding is not compatible with " + Arrays.asList(API_COMPATIBILITY_LIST).toString());
                Util.report("See http://www.slf4j.org/codes.html#version_mismatch for further details.");
            }
            return;
        }
        catch (NoSuchFieldError noSuchFieldError) {
            return;
        }
        catch (Throwable e) {
            void var0_1;
            Util.report("Unexpected problem occured during version sanity check", (Throwable)var0_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Set<URL> findPossibleStaticLoggerBinderPathSet() {
        void var0;
        LinkedHashSet<void> staticLoggerBinderPathSet = new LinkedHashSet<void>();
        try {
            Enumeration<URL> paths;
            ClassLoader loggerFactoryClassLoader = LoggerFactory.class.getClassLoader();
            paths = loggerFactoryClassLoader == null ? ClassLoader.getSystemResources(STATIC_LOGGER_BINDER_PATH) : ((ClassLoader)((Object)paths)).getResources(STATIC_LOGGER_BINDER_PATH);
            while (paths.hasMoreElements()) {
                void var2_3;
                URL path = paths.nextElement();
                staticLoggerBinderPathSet.add(var2_3);
            }
        }
        catch (IOException ioe) {
            void var1_2;
            Util.report("Error getting resources from path", (Throwable)var1_2);
        }
        return var0;
    }

    private static boolean isAmbiguousStaticLoggerBinderPathSet(Set<URL> binderPathSet) {
        return binderPathSet.size() > 1;
    }

    private static Logger getLogger(String name) {
        String string;
        ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
        return iLoggerFactory.getLogger(string);
    }

    /*
     * WARNING - void declaration
     */
    public static Logger getLogger(Class<?> clazz) {
        void var1_1;
        Class<?> clazz2;
        Class<?> clazz3;
        Class<?> autoComputedCallingClass;
        Logger logger = LoggerFactory.getLogger(clazz.getName());
        if (DETECT_LOGGER_NAME_MISMATCH && (autoComputedCallingClass = Util.getCallingClass()) != null && !(clazz3 = autoComputedCallingClass).isAssignableFrom(clazz2)) {
            void var2_2;
            Util.report(String.format("Detected logger name mismatch. Given name: \"%s\"; computed name: \"%s\".", logger.getName(), var2_2.getName()));
            Util.report("See http://www.slf4j.org/codes.html#loggerNameMismatch for an explanation");
        }
        return var1_1;
    }

    /*
     * Unable to fully structure code
     */
    private static ILoggerFactory getILoggerFactory() {
        if (LoggerFactory.INITIALIZATION_STATE != 0) ** GOTO lbl74
        var0 = LoggerFactory.class;
        synchronized (LoggerFactory.class) {
            block29: {
                block28: {
                    if (LoggerFactory.INITIALIZATION_STATE != 0) break block29;
                    LoggerFactory.INITIALIZATION_STATE = 1;
                    try {
                        var1_1 = null;
                        var2_7 = Util.safeGetSystemProperty("java.vendor.url");
                        if (!(var2_7 == null ? false : var2_7.toLowerCase().contains("android"))) {
                            var1_1 = LoggerFactory.findPossibleStaticLoggerBinderPathSet();
                            var2_7 = var1_1;
                            if (LoggerFactory.isAmbiguousStaticLoggerBinderPathSet(var1_1)) {
                                Util.report("Class path contains multiple SLF4J bindings.");
                                var2_7 = var2_7.iterator();
                                while (var2_7.hasNext()) {
                                    var3_10 = (URL)var2_7.next();
                                    Util.report("Found binding in [" + var3_10 + "]");
                                }
                                Util.report("See http://www.slf4j.org/codes.html#multiple_bindings for an explanation.");
                            }
                        }
                        StaticLoggerBinder.getSingleton();
                        LoggerFactory.INITIALIZATION_STATE = 3;
                        var2_7 = var1_1;
                        if (var2_7 != null && LoggerFactory.isAmbiguousStaticLoggerBinderPathSet(var2_7)) {
                            Util.report("Actual binding is of type [" + StaticLoggerBinder.getSingleton().getLoggerFactoryClassStr() + "]");
                        }
                    }
                    catch (NoClassDefFoundError v0) {
                        var1_2 = v0;
                        v1 = v0.getMessage();
                        var2_8 = v1;
                        var2_8 = v1;
                        if (v1 == null) ** GOTO lbl-1000
                        if (var2_8.contains("org/slf4j/impl/StaticLoggerBinder")) {
                            v2 = true;
                        } else if (var2_8.contains("org.slf4j.impl.StaticLoggerBinder")) {
                            v2 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v2 = false;
                        }
                        if (v2) {
                            LoggerFactory.INITIALIZATION_STATE = 4;
                            Util.report("Failed to load class \"org.slf4j.impl.StaticLoggerBinder\".");
                            Util.report("Defaulting to no-operation (NOP) logger implementation");
                            Util.report("See http://www.slf4j.org/codes.html#StaticLoggerBinder for further details.");
                            break block28;
                        }
                        LoggerFactory.failedBinding(var1_2);
                        throw var1_2;
                    }
                    catch (NoSuchMethodError v3) {
                        var1_3 = v3;
                        var2_9 = v3.getMessage();
                        if (var2_9 != null && var2_9.contains("org.slf4j.impl.StaticLoggerBinder.getSingleton()")) {
                            LoggerFactory.INITIALIZATION_STATE = 2;
                            Util.report("slf4j-api 1.6.x (or later) is incompatible with this binding.");
                            Util.report("Your binding is version 1.5.5 or earlier.");
                            Util.report("Upgrade your binding to version 1.6.x.");
                        }
                        throw var1_3;
                    }
                    catch (Exception v4) {
                        var1_4 = v4;
                        LoggerFactory.failedBinding(v4);
                        throw new IllegalStateException("Unexpected initialization failure", var1_4);
                    }
                    finally {
                        LoggerFactory.postBindCleanUp();
                    }
                }
                if (LoggerFactory.INITIALIZATION_STATE == 3) {
                    LoggerFactory.versionSanityCheck();
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
lbl74:
            // 2 sources

            switch (LoggerFactory.INITIALIZATION_STATE) {
                case 3: {
                    return StaticLoggerBinder.getSingleton().getLoggerFactory();
                }
                case 4: {
                    return LoggerFactory.NOP_FALLBACK_FACTORY$3d653843;
                }
                case 2: {
                    throw new IllegalStateException("org.slf4j.LoggerFactory in failed state. Original exception was thrown EARLIER. See also http://www.slf4j.org/codes.html#unsuccessfulInit");
                }
                case 1: {
                    return LoggerFactory.SUBST_FACTORY$43548378;
                }
            }
            throw new IllegalStateException("Unreachable code");
        }
    }
}

