/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.event;

import java.util.Queue;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.event.SubstituteLoggingEvent;
import org.slf4j.helpers.SubstituteLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EventRecodingLogger
implements Logger {
    private String name;
    private SubstituteLogger logger;
    private Queue<SubstituteLoggingEvent> eventQueue;

    /*
     * WARNING - void declaration
     */
    public EventRecodingLogger(SubstituteLogger logger, Queue<SubstituteLoggingEvent> eventQueue) {
        void var2_2;
        void var1_1;
        this.logger = logger;
        this.name = var1_1.getName();
        this.eventQueue = var2_2;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final boolean isTraceEnabled() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void trace(String format, Object arg) {
        void var2_2;
        void var1_1;
        this.recordEvent_1Args(Level.TRACE, null, (String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void trace(String format, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.recordEvent2Args(Level.TRACE, null, (String)var1_1, var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void trace(String format, Object ... arguments) {
        void var2_2;
        void var1_1;
        this.recordEventArgArray(Level.TRACE, null, (String)var1_1, (Object[])var2_2);
    }

    @Override
    public final boolean isDebugEnabled() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void debug(String msg) {
        void var1_1;
        this.recordEvent_0Args(Level.DEBUG, null, (String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void debug(String format, Object arg) {
        void var2_2;
        void var1_1;
        this.recordEvent_1Args(Level.DEBUG, null, (String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void debug(String format, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.recordEvent2Args(Level.DEBUG, null, (String)var1_1, var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void debug(String format, Object ... arguments) {
        void var2_2;
        void var1_1;
        this.recordEventArgArray(Level.DEBUG, null, (String)var1_1, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void info(String format, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.recordEvent2Args(Level.INFO, null, (String)var1_1, var2_2, var3_3);
    }

    @Override
    public final boolean isWarnEnabled() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void warn(String msg) {
        void var1_1;
        this.recordEvent_0Args(Level.WARN, null, (String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void warn(String format, Object arg) {
        void var2_2;
        void var1_1;
        this.recordEvent_1Args(Level.WARN, null, (String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void warn(String format, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.recordEvent2Args(Level.WARN, null, (String)var1_1, var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void warn(String format, Object ... arguments) {
        void var2_2;
        void var1_1;
        this.recordEventArgArray(Level.WARN, null, (String)var1_1, (Object[])var2_2);
    }

    @Override
    public final boolean isErrorEnabled() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void error(String msg) {
        void var1_1;
        this.recordEvent_0Args(Level.ERROR, null, (String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void error(String format, Object arg) {
        void var2_2;
        void var1_1;
        this.recordEvent_1Args(Level.ERROR, null, (String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void error(String format, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.recordEvent2Args(Level.ERROR, null, (String)var1_1, var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void error(String format, Object ... arguments) {
        void var2_2;
        void var1_1;
        this.recordEventArgArray(Level.ERROR, null, (String)var1_1, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void error(String msg, Throwable t) {
        void var2_2;
        void var1_1;
        this.recordEvent_0Args(Level.ERROR, null, (String)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void recordEvent_0Args(Level level, Marker marker, String msg, Throwable t) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.recordEvent((Level)var1_1, (Marker)var2_2, (String)var3_3, null, t);
    }

    /*
     * WARNING - void declaration
     */
    private void recordEvent_1Args(Level level, Marker marker, String msg, Object arg1) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.recordEvent((Level)var1_1, (Marker)var2_2, (String)var3_3, new Object[]{arg1}, null);
    }

    /*
     * WARNING - void declaration
     */
    private void recordEvent2Args(Level level, Marker marker, String msg, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (arg2 instanceof Throwable) {
            this.recordEvent(level, marker, msg, new Object[]{arg1}, (Throwable)arg2);
            return;
        }
        this.recordEvent((Level)var1_1, (Marker)var2_2, (String)var3_3, new Object[]{arg1, arg2}, null);
    }

    /*
     * WARNING - void declaration
     */
    private void recordEventArgArray(Level level, Marker marker, String msg, Object[] args) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Throwable throwableCandidate = ISODateTimeFormat.getThrowableCandidate((Object[])args);
        if (throwableCandidate != null) {
            Object[] trimmedCopy = ISODateTimeFormat.trimmedCopy((Object[])args);
            this.recordEvent(level, marker, msg, trimmedCopy, throwableCandidate);
            return;
        }
        this.recordEvent((Level)var1_1, (Marker)var2_2, (String)var3_3, (Object[])var4_4, null);
    }

    /*
     * WARNING - void declaration
     */
    private void recordEvent(Level level, Marker marker, String msg, Object[] args, Throwable throwable) {
        void var1_1;
        SubstituteLoggingEvent loggingEvent = new SubstituteLoggingEvent();
        System.currentTimeMillis();
        SubstituteLogger substituteLogger = this.logger;
        SubstituteLoggingEvent substituteLoggingEvent = loggingEvent;
        loggingEvent.logger = substituteLogger;
        Thread.currentThread().getName();
        this.eventQueue.add((SubstituteLoggingEvent)var1_1);
    }
}

