/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.event.EventRecodingLogger;
import org.slf4j.event.LoggingEvent;
import org.slf4j.event.SubstituteLoggingEvent;
import org.slf4j.helpers.NOPLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SubstituteLogger
implements Logger {
    private final String name;
    private volatile Logger _delegate;
    private Boolean delegateEventAware;
    private Method logMethodCache;
    private EventRecodingLogger eventRecodingLogger;
    private Queue<SubstituteLoggingEvent> eventQueue;
    private final boolean createdPostInitialization;

    /*
     * WARNING - void declaration
     */
    public SubstituteLogger(String name, Queue<SubstituteLoggingEvent> eventQueue, boolean createdPostInitialization) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.name = var1_1;
        this.eventQueue = var2_2;
        this.createdPostInitialization = var3_3;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final boolean isTraceEnabled() {
        return this.delegate().isTraceEnabled();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void trace(String format, Object arg) {
        void var2_2;
        void var1_1;
        this.delegate().trace((String)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void trace(String format, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.delegate().trace((String)var1_1, (Object)var2_2, (Object)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void trace(String format, Object ... arguments) {
        void var2_2;
        void var1_1;
        this.delegate().trace((String)var1_1, (Object[])var2_2);
    }

    @Override
    public final boolean isDebugEnabled() {
        return this.delegate().isDebugEnabled();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void debug(String msg) {
        void var1_1;
        this.delegate().debug((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void debug(String format, Object arg) {
        void var2_2;
        void var1_1;
        this.delegate().debug((String)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void debug(String format, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.delegate().debug((String)var1_1, (Object)var2_2, (Object)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void debug(String format, Object ... arguments) {
        void var2_2;
        void var1_1;
        this.delegate().debug((String)var1_1, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void info(String format, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.delegate().info((String)var1_1, var2_2, var3_3);
    }

    @Override
    public final boolean isWarnEnabled() {
        return this.delegate().isWarnEnabled();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void warn(String msg) {
        void var1_1;
        this.delegate().warn((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void warn(String format, Object arg) {
        void var2_2;
        void var1_1;
        this.delegate().warn((String)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void warn(String format, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.delegate().warn((String)var1_1, (Object)var2_2, (Object)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void warn(String format, Object ... arguments) {
        void var2_2;
        void var1_1;
        this.delegate().warn((String)var1_1, (Object[])var2_2);
    }

    @Override
    public final boolean isErrorEnabled() {
        return this.delegate().isErrorEnabled();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void error(String msg) {
        void var1_1;
        this.delegate().error((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void error(String format, Object arg) {
        void var2_2;
        void var1_1;
        this.delegate().error((String)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void error(String format, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.delegate().error((String)var1_1, (Object)var2_2, (Object)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void error(String format, Object ... arguments) {
        void var2_2;
        void var1_1;
        this.delegate().error((String)var1_1, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void error(String msg, Throwable t) {
        void var2_2;
        void var1_1;
        this.delegate().error((String)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubstituteLogger that = (SubstituteLogger)o;
        return this.name.equals(var1_1.name);
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    private Logger delegate() {
        if (this._delegate != null) {
            return this._delegate;
        }
        if (this.createdPostInitialization) {
            return NOPLogger.NOP_LOGGER;
        }
        return this.getEventRecordingLogger();
    }

    private Logger getEventRecordingLogger() {
        if (this.eventRecodingLogger == null) {
            SubstituteLogger substituteLogger = this;
            this.eventRecodingLogger = new EventRecodingLogger(substituteLogger, substituteLogger.eventQueue);
        }
        return this.eventRecodingLogger;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDelegate(Logger delegate) {
        void var1_1;
        this._delegate = var1_1;
    }

    public final boolean isDelegateEventAware() {
        if (this.delegateEventAware != null) {
            return this.delegateEventAware;
        }
        try {
            this.logMethodCache = this._delegate.getClass().getMethod("log", LoggingEvent.class);
            this.delegateEventAware = Boolean.TRUE;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.delegateEventAware = Boolean.FALSE;
        }
        return this.delegateEventAware;
    }

    /*
     * WARNING - void declaration
     */
    public final void log(LoggingEvent event) {
        if (this.isDelegateEventAware()) {
            try {
                void var1_1;
                this.logMethodCache.invoke((Object)this._delegate, var1_1);
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
    }

    public final boolean isDelegateNull() {
        return this._delegate == null;
    }

    public final boolean isDelegateNOP() {
        return this._delegate instanceof NOPLogger;
    }
}

