/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.SerialDescriptor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0001\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\b\u0010\u0011\u001a\u00020\u0006H\u0002J\u0006\u0010\u0012\u001a\u00020\u0006J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lkotlinx/serialization/internal/ElementMarker;", "", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "readIfAbsent", "Lkotlin/Function2;", "", "", "(Lkotlinx/serialization/descriptors/SerialDescriptor;Lkotlin/jvm/functions/Function2;)V", "highMarksArray", "", "lowerMarks", "", "mark", "", "index", "markHigh", "nextUnmarkedHighIndex", "nextUnmarkedIndex", "prepareHighMarksArray", "elementsCount", "Companion", "kotlinx-serialization-core"})
@PublishedApi
public final class ElementMarker {
    private final SerialDescriptor descriptor;
    private final Function2<SerialDescriptor, Integer, Boolean> readIfAbsent;
    private long lowerMarks;
    private final long[] highMarksArray;
    @Deprecated
    private static final long[] EMPTY_HIGH_MARKS;

    /*
     * WARNING - void declaration
     */
    public ElementMarker(SerialDescriptor descriptor2, Function2<? super SerialDescriptor, ? super Integer, Boolean> readIfAbsent) {
        void var1_2;
        void var2_3;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter(readIfAbsent, (String)"readIfAbsent");
        this.descriptor = descriptor2;
        this.readIfAbsent = var2_3;
        int elementsCount = this.descriptor.getElementsCount();
        if (elementsCount <= 64) {
            this.lowerMarks = elementsCount == 64 ? 0L : -1L << elementsCount;
            this.highMarksArray = EMPTY_HIGH_MARKS;
            return;
        }
        this.lowerMarks = 0L;
        void var2_4 = var1_2 - true >>> 6;
        int n = var1_2 & 0x3F;
        long[] lArray = new long[var2_4];
        if (n != 0) {
            lArray[ArraysKt.getLastIndex((long[])lArray)] = -1L << var1_2;
        }
        this.highMarksArray = lArray;
    }

    /*
     * WARNING - void declaration
     */
    public final void mark(int index) {
        void var1_1;
        if (index < 64) {
            this.lowerMarks |= 1L << index;
            return;
        }
        int n = var1_1;
        ElementMarker elementMarker = this;
        void var3_4 = (n >>> 6) - true;
        elementMarker.highMarksArray[var3_4] = elementMarker.highMarksArray[var3_4] | 1L << (n &= 0x3F);
    }

    /*
     * WARNING - void declaration
     */
    public final int nextUnmarkedIndex() {
        void var1_1;
        int n;
        int elementsCount = this.descriptor.getElementsCount();
        while (this.lowerMarks != -1L) {
            int index = Long.numberOfTrailingZeros(this.lowerMarks ^ 0xFFFFFFFFFFFFFFFFL);
            this.lowerMarks |= 1L << index;
            if (!((Boolean)this.readIfAbsent.invoke((Object)this.descriptor, (Object)index)).booleanValue()) continue;
            return n;
        }
        if (var1_1 > 64) {
            ElementMarker elementMarker = this;
            int n2 = elementMarker.highMarksArray.length;
            for (n = 0; n < n2; ++n) {
                long l;
                int n3;
                int n4 = n + 1 << 6;
                for (l = elementMarker.highMarksArray[n]; l != -1L; l |= 1L << n3) {
                    n3 = Long.numberOfTrailingZeros(l ^ 0xFFFFFFFFFFFFFFFFL);
                    if (!((Boolean)elementMarker.readIfAbsent.invoke((Object)elementMarker.descriptor, (Object)(n3 = n4 + n3))).booleanValue()) continue;
                    elementMarker.highMarksArray[n] = l;
                    return n3;
                }
                elementMarker.highMarksArray[n] = l;
            }
            return -1;
        }
        return -1;
    }

    static {
        new Companion(0);
        EMPTY_HIGH_MARKS = new long[0];
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lkotlinx/serialization/internal/ElementMarker$Companion;", "", "()V", "EMPTY_HIGH_MARKS", "", "kotlinx-serialization-core"})
    static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(byte by) {
            this();
        }
    }
}

