/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.collection;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u00032\u00020\u0002B\u000f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0012\u0010\u001b\u001a\u00020\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u0002H\u0002J\"\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001e\u001a\u00020\u0005H\u0002JD\u0010\u001f\u001a\u00020\u001626\u0010 \u001a2\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b(\u0019\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b($\u0012\u0004\u0012\u00020\u00160!H\u0086\b\u00f8\u0001\u0000J\u0018\u0010%\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0019\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010&J\u0006\u0010'\u001a\u00020\u0018J\u0006\u0010(\u001a\u00020\u0018J\u0015\u0010)\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0019\u001a\u00028\u0000\u00a2\u0006\u0002\u0010&JD\u0010*\u001a\u00020\u001626\u0010 \u001a2\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b(\u0019\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b($\u0012\u0004\u0012\u00020\u00180!H\u0086\b\u00f8\u0001\u0000J/\u0010+\u001a\u00020\u00162!\u0010 \u001a\u001d\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b($\u0012\u0004\u0012\u00020\u00180,H\u0086\b\u00f8\u0001\u0000J\u001e\u0010-\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010$\u001a\u00028\u0001H\u0086\u0002\u00a2\u0006\u0002\u0010.R$\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\bX\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u000e\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0006R$\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\bX\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\u0013\u0010\n\"\u0004\b\u0014\u0010\f\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006/"}, d2={"Landroidx/compose/runtime/collection/IdentityArrayMap;", "Key", "", "Value", "capacity", "", "(I)V", "keys", "", "getKeys$runtime", "()[Ljava/lang/Object;", "setKeys$runtime", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "size", "getSize$runtime", "()I", "setSize$runtime", "values", "getValues$runtime", "setValues$runtime", "clear", "", "contains", "", "key", "(Ljava/lang/Object;)Z", "find", "findExactIndex", "midIndex", "keyHash", "forEach", "block", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "value", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "isEmpty", "isNotEmpty", "remove", "removeIf", "removeValueIf", "Lkotlin/Function1;", "set", "(Ljava/lang/Object;Ljava/lang/Object;)V", "runtime"})
@SourceDebugExtension(value={"SMAP\nIdentityArrayMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdentityArrayMap.kt\nandroidx/compose/runtime/collection/IdentityArrayMap\n*L\n1#1,208:1\n118#1,22:209\n*S KotlinDebug\n*F\n+ 1 IdentityArrayMap.kt\nandroidx/compose/runtime/collection/IdentityArrayMap\n*L\n142#1:209,22\n*E\n"})
public final class IdentityArrayMap<Key, Value> {
    private Object[] keys;
    private Object[] values;
    private int size;

    /*
     * WARNING - void declaration
     */
    private IdentityArrayMap(int capacity) {
        void var1_1;
        this.keys = new Object[capacity];
        this.values = new Object[var1_1];
    }

    public /* synthetic */ IdentityArrayMap(int n, int n2) {
        this(16);
    }

    public final Object[] getKeys$runtime() {
        return this.keys;
    }

    public final Object[] getValues$runtime() {
        return this.values;
    }

    public final int getSize$runtime() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSize$runtime(int n) {
        void var1_1;
        this.size = var1_1;
    }

    public final boolean isNotEmpty() {
        return this.size > 0;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean contains(Key key) {
        void var1_1;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return this.find(var1_1) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    public final Value get(Key key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        int index = this.find(key);
        if (index >= 0) {
            void var1_2;
            return (Value)this.values[var1_2];
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final void set(Key key, Value value) {
        void var1_1;
        void var2_3;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        int index = this.find(key);
        if (index >= 0) {
            this.values[index] = value;
            return;
        }
        int insertIndex = -(index + 1);
        boolean resize = this.size == this.keys.length;
        Object[] destKeys = resize ? new Object[this.size << 1] : this.keys;
        ArraysKt.copyInto((Object[])this.keys, (Object[])destKeys, (int)(insertIndex + 1), (int)insertIndex, (int)this.size);
        if (resize) {
            ArraysKt.copyInto$default((Object[])this.keys, (Object[])destKeys, (int)0, (int)0, (int)insertIndex, (int)6, null);
        }
        destKeys[insertIndex] = key;
        this.keys = destKeys;
        Object[] destValues = resize ? new Object[this.size << 1] : this.values;
        ArraysKt.copyInto((Object[])this.values, (Object[])destValues, (int)(insertIndex + 1), (int)insertIndex, (int)this.size);
        if (resize) {
            ArraysKt.copyInto$default((Object[])this.values, (Object[])destValues, (int)0, (int)0, (int)insertIndex, (int)6, null);
        }
        destValues[var3_4] = var2_3;
        this.values = var1_1;
        int n = this.size;
        this.size = n + 1;
    }

    /*
     * WARNING - void declaration
     */
    public final Value remove(Key key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        int index = this.find(key);
        if (index >= 0) {
            void var2_3;
            void var1_2;
            void var3_4;
            Object value = this.values[index];
            int size = this.size;
            Object[] keys = this.keys;
            Object[] values = this.values;
            int n = index;
            ArraysKt.copyInto((Object[])keys, (Object[])keys, (int)n, (int)(n + 1), (int)size);
            int n2 = index;
            ArraysKt.copyInto((Object[])values, (Object[])values, (int)n2, (int)(n2 + 1), (int)size);
            void newSize = var3_4 - true;
            keys[newSize] = null;
            values[newSize] = null;
            this.size = var1_2;
            return var2_3;
        }
        return null;
    }

    public final void clear() {
        this.size = 0;
        ArraysKt.fill$default((Object[])this.keys, null, (int)0, (int)0, (int)6, null);
        ArraysKt.fill$default((Object[])this.values, null, (int)0, (int)0, (int)6, null);
    }

    /*
     * WARNING - void declaration
     */
    private final int find(Object key) {
        void var3_5;
        Object object = key;
        int keyIdentity = System.identityHashCode(object);
        int low = 0;
        int high = this.size - 1;
        while (low <= high) {
            void var2_4;
            void var1_1;
            Object midKey;
            int mid = low + high >>> 1;
            object = midKey = this.keys[mid];
            int midKeyHash = System.identityHashCode(midKey);
            if (midKeyHash < keyIdentity) {
                low = mid + 1;
                continue;
            }
            if (midKeyHash > keyIdentity) {
                high = mid - 1;
                continue;
            }
            if (key == midKey) {
                return mid;
            }
            return this.findExactIndex(mid, var1_1, (int)var2_4);
        }
        return (int)(-(var3_5 + true));
    }

    /*
     * WARNING - void declaration
     */
    private final int findExactIndex(int midIndex, Object key, int keyHash) {
        Object object;
        int i;
        for (i = midIndex - 1; i >= 0; --i) {
            Object k = this.keys[i];
            if (k == key) {
                return i;
            }
            object = k;
            if (System.identityHashCode(object) != keyHash) break;
        }
        int n = this.size;
        for (i = midIndex + 1; i < n; ++i) {
            void var1_2;
            Object k = this.keys[i];
            if (k == key) {
                return i;
            }
            object = var1_2;
            if (System.identityHashCode(object) == keyHash) continue;
            return -(i + 1);
        }
        return -(this.size + 1);
    }

    public IdentityArrayMap() {
        this(0, 1);
    }
}

