/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.collection;

import androidx.compose.runtime.collection.MutableVectorKt;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableList;
import kotlin.jvm.internal.markers.KMutableListIterator;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b)\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0004\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00060\u0002j\u0002`\u0003:\u0003pqrB\u001f\b\u0001\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001eJ\u001b\u0010\u001b\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00028\u0000\u00a2\u0006\u0002\u0010!J\u0017\u0010\"\u001a\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0086\bJ\u0019\u0010\"\u001a\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010$J\u001c\u0010\"\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u00072\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u001c\u0010\"\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u00072\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000%J\u001c\u0010\"\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u00072\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000&J\u0014\u0010\"\u001a\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000%J\u0017\u0010\"\u001a\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000&H\u0086\bJ+\u0010'\u001a\u00020\u001c2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001c0)H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018J\u0006\u0010+\u001a\u00020\u001fJ\u0016\u0010,\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0014\u0010-\u001a\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u0014\u0010-\u001a\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000%J\u0014\u0010-\u001a\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000&J\u0014\u0010.\u001a\u00020\u001c2\f\u0010/\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u000e\u00100\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u0007J\u000b\u00102\u001a\u00028\u0000\u00a2\u0006\u0002\u00103J0\u00102\u001a\u00028\u00002\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001c0)H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001\u00a2\u0006\u0002\u00104J\u0010\u00105\u001a\u0004\u0018\u00018\u0000H\u0086\b\u00a2\u0006\u0002\u00103J2\u00105\u001a\u0004\u0018\u00018\u00002\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001c0)H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001\u00a2\u0006\u0002\u00104JS\u00106\u001a\u0002H7\"\u0004\b\u0001\u001072\u0006\u00108\u001a\u0002H72'\u00109\u001a#\u0012\u0013\u0012\u0011H7\u00a2\u0006\f\b;\u0012\b\b<\u0012\u0004\b\b(=\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H70:H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0002\u00a2\u0006\u0002\u0010>Jh\u0010?\u001a\u0002H7\"\u0004\b\u0001\u001072\u0006\u00108\u001a\u0002H72<\u00109\u001a8\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b;\u0012\b\b<\u0012\u0004\b\b( \u0012\u0013\u0012\u0011H7\u00a2\u0006\f\b;\u0012\b\b<\u0012\u0004\b\b(=\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H70@H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0002\u00a2\u0006\u0002\u0010AJS\u0010B\u001a\u0002H7\"\u0004\b\u0001\u001072\u0006\u00108\u001a\u0002H72'\u00109\u001a#\u0012\u0004\u0012\u00028\u0000\u0012\u0013\u0012\u0011H7\u00a2\u0006\f\b;\u0012\b\b<\u0012\u0004\b\b(=\u0012\u0004\u0012\u0002H70:H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0002\u00a2\u0006\u0002\u0010>Jh\u0010C\u001a\u0002H7\"\u0004\b\u0001\u001072\u0006\u00108\u001a\u0002H72<\u00109\u001a8\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b;\u0012\b\b<\u0012\u0004\b\b( \u0012\u0004\u0012\u00028\u0000\u0012\u0013\u0012\u0011H7\u00a2\u0006\f\b;\u0012\b\b<\u0012\u0004\b\b(=\u0012\u0004\u0012\u0002H70@H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0002\u00a2\u0006\u0002\u0010AJ+\u0010D\u001a\u00020\u001f2\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001f0)H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J1\u0010F\u001a\u00020\u001f2\u0018\u0010E\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001f0:H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J+\u0010G\u001a\u00020\u001f2\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001f0)H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J1\u0010H\u001a\u00020\u001f2\u0018\u0010E\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001f0:H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J\u0016\u0010I\u001a\u00028\u00002\u0006\u0010 \u001a\u00020\u0007H\u0086\n\u00a2\u0006\u0002\u0010JJ\u0013\u0010K\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00028\u0000\u00a2\u0006\u0002\u0010LJ+\u0010M\u001a\u00020\u00072\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001c0)H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J+\u0010N\u001a\u00020\u00072\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001c0)H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J\u0006\u0010O\u001a\u00020\u001cJ\u0006\u0010P\u001a\u00020\u001cJ\u000b\u0010Q\u001a\u00028\u0000\u00a2\u0006\u0002\u00103J0\u0010Q\u001a\u00028\u00002\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001c0)H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001\u00a2\u0006\u0002\u00104J\u0013\u0010R\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00028\u0000\u00a2\u0006\u0002\u0010LJ\u0010\u0010S\u001a\u0004\u0018\u00018\u0000H\u0086\b\u00a2\u0006\u0002\u00103J2\u0010S\u001a\u0004\u0018\u00018\u00002\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001c0)H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001\u00a2\u0006\u0002\u00104J>\u0010T\u001a\b\u0012\u0004\u0012\u0002H70\u0005\"\u0006\b\u0001\u00107\u0018\u00012\u0012\u0010U\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H70)H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001\u00a2\u0006\u0002\u0010VJS\u0010W\u001a\b\u0012\u0004\u0012\u0002H70\u0005\"\u0006\b\u0001\u00107\u0018\u00012'\u0010U\u001a#\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b;\u0012\b\b<\u0012\u0004\b\b( \u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H70:H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001\u00a2\u0006\u0002\u0010XJP\u0010Y\u001a\b\u0012\u0004\u0012\u0002H70\u0000\"\u0006\b\u0001\u00107\u0018\u00012)\u0010U\u001a%\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b;\u0012\b\b<\u0012\u0004\b\b( \u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u0001H70:H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J;\u0010Z\u001a\b\u0012\u0004\u0012\u0002H70\u0000\"\u0006\b\u0001\u00107\u0018\u00012\u0014\u0010U\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u0001H70)H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J\u0016\u0010[\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00028\u0000H\u0086\n\u00a2\u0006\u0002\u0010\\J\u0016\u0010]\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00028\u0000H\u0086\n\u00a2\u0006\u0002\u0010\\J\u0013\u0010^\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001eJ\u0014\u0010_\u001a\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u0014\u0010_\u001a\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000%J\u0014\u0010_\u001a\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000&J\u0013\u0010`\u001a\u00028\u00002\u0006\u0010 \u001a\u00020\u0007\u00a2\u0006\u0002\u0010JJ\u0016\u0010a\u001a\u00020\u001f2\u0006\u0010b\u001a\u00020\u00072\u0006\u0010c\u001a\u00020\u0007J\u0014\u0010d\u001a\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000%J+\u0010e\u001a\u00020\u001c2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001c0)H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J\u001e\u0010f\u001a\u00028\u00002\u0006\u0010 \u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010gJ\u001e\u0010h\u001a\u00020\u001f2\u0016\u0010i\u001a\u0012\u0012\u0004\u0012\u00028\u00000jj\b\u0012\u0004\u0012\u00028\u0000`kJ+\u0010l\u001a\u00020\u00072\u0012\u0010m\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070)H\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0001J\b\u0010n\u001a\u00020oH\u0001R.\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u00058\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0016\n\u0002\u0010\u000f\u0012\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0012\u0010\u0010\u001a\u00020\u00118\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00020\u00078\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006s"}, d2={"Landroidx/compose/runtime/collection/MutableVector;", "T", "Ljava/util/RandomAccess;", "Lkotlin/collections/RandomAccess;", "content", "", "size", "", "([Ljava/lang/Object;I)V", "getContent$annotations", "()V", "getContent", "()[Ljava/lang/Object;", "setContent", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "indices", "Lkotlin/ranges/IntRange;", "getIndices", "()Lkotlin/ranges/IntRange;", "lastIndex", "getLastIndex", "()I", "list", "", "<set-?>", "getSize", "add", "", "element", "(Ljava/lang/Object;)Z", "", "index", "(ILjava/lang/Object;)V", "addAll", "elements", "([Ljava/lang/Object;)Z", "", "", "any", "predicate", "Lkotlin/Function1;", "asMutableList", "clear", "contains", "containsAll", "contentEquals", "other", "ensureCapacity", "capacity", "first", "()Ljava/lang/Object;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "firstOrNull", "fold", "R", "initial", "operation", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "acc", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "foldIndexed", "Lkotlin/Function3;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function3;)Ljava/lang/Object;", "foldRight", "foldRightIndexed", "forEach", "block", "forEachIndexed", "forEachReversed", "forEachReversedIndexed", "get", "(I)Ljava/lang/Object;", "indexOf", "(Ljava/lang/Object;)I", "indexOfFirst", "indexOfLast", "isEmpty", "isNotEmpty", "last", "lastIndexOf", "lastOrNull", "map", "transform", "(Lkotlin/jvm/functions/Function1;)[Ljava/lang/Object;", "mapIndexed", "(Lkotlin/jvm/functions/Function2;)[Ljava/lang/Object;", "mapIndexedNotNull", "mapNotNull", "minusAssign", "(Ljava/lang/Object;)V", "plusAssign", "remove", "removeAll", "removeAt", "removeRange", "start", "end", "retainAll", "reversedAny", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "sortWith", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "sumBy", "selector", "throwNoSuchElementException", "", "MutableVectorList", "SubList", "VectorListIterator", "runtime"})
@SourceDebugExtension(value={"SMAP\nMutableVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1194:1\n48#1:1198\n48#1:1199\n523#1:1200\n53#1:1203\n523#1:1204\n48#1:1205\n523#1:1206\n523#1:1207\n523#1:1208\n48#1:1209\n523#1:1210\n48#1:1211\n523#1:1212\n523#1:1213\n523#1:1214\n48#1:1215\n523#1:1216\n48#1:1219\n48#1:1220\n48#1:1221\n523#1:1222\n1864#2,3:1195\n1855#2,2:1201\n1855#2,2:1217\n*S KotlinDebug\n*F\n+ 1 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n*L\n249#1:1198\n259#1:1199\n260#1:1200\n292#1:1203\n293#1:1204\n307#1:1205\n308#1:1206\n334#1:1207\n359#1:1208\n595#1:1209\n595#1:1210\n637#1:1211\n637#1:1212\n665#1:1213\n675#1:1214\n768#1:1215\n769#1:1216\n794#1:1219\n821#1:1220\n833#1:1221\n834#1:1222\n185#1:1195,3\n281#1:1201,2\n782#1:1217,2\n*E\n"})
public final class MutableVector<T>
implements RandomAccess {
    private T[] content;
    private List<T> list;
    private int size;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    @PublishedApi
    public MutableVector(T[] content, int size) {
        void var1_1;
        Intrinsics.checkNotNullParameter(content, (String)"content");
        this.content = var1_1;
        this.size = 0;
    }

    public final T[] getContent() {
        return this.content;
    }

    public final int getSize() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean add(T element) {
        void var1_1;
        MutableVector mutableVector = this;
        mutableVector.ensureCapacity(mutableVector.size + 1);
        this.content[this.size] = var1_1;
        int n = this.size;
        this.size = n + 1;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void add(int index, T element) {
        void var2_2;
        MutableVector mutableVector = this;
        mutableVector.ensureCapacity(mutableVector.size + 1);
        Object[] content = this.content;
        if (index != this.size) {
            ArraysKt.copyInto((Object[])content, (Object[])content, (int)(index + 1), (int)index, (int)this.size);
        }
        var3_3[n] = var2_2;
        int n = this.size;
        this.size = n + 1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean addAll(int index, MutableVector<T> elements) {
        void var2_2;
        void var1_1;
        void var3_3;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (elements.isEmpty()) {
            return false;
        }
        MutableVector mutableVector = this;
        mutableVector.ensureCapacity(mutableVector.size + elements.size);
        Object[] content = this.content;
        if (index != this.size) {
            ArraysKt.copyInto((Object[])content, (Object[])content, (int)(index + elements.size), (int)index, (int)this.size);
        }
        ArraysKt.copyInto((Object[])elements.content, (Object[])var3_3, (int)var1_1, (int)0, (int)elements.size);
        this.size += var2_2.size;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean addAll(int index, Collection<? extends T> elements) {
        void var2_2;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (elements.isEmpty()) {
            return false;
        }
        MutableVector mutableVector = this;
        mutableVector.ensureCapacity(mutableVector.size + elements.size());
        Object[] content = this.content;
        if (index != this.size) {
            ArraysKt.copyInto((Object[])content, (Object[])content, (int)(index + elements.size()), (int)index, (int)this.size);
        }
        Iterable $this$forEachIndexed$iv = elements;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void item;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int i = n;
            content[index + i] = item;
        }
        this.size += var2_2.size();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean addAll(Collection<? extends T> elements) {
        void var1_1;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        MutableVector mutableVector = this;
        return mutableVector.addAll(mutableVector.size, (Collection<? extends T>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final List<T> asMutableList() {
        List list = this.list;
        if (list == null) {
            void var2_2;
            MutableVectorList mutableVectorList;
            MutableVectorList it = mutableVectorList = new MutableVectorList(this);
            this.list = (List)var2_2;
            list = mutableVectorList;
        }
        return list;
    }

    public final void clear() {
        T[] content = this.content;
        MutableVector mutableVector = this;
        mutableVector = mutableVector;
        for (int i = (v37505).size - 1; i >= 0; --i) {
            content[i] = null;
        }
        this.size = 0;
    }

    public final boolean contains(T element) {
        int i = 0;
        MutableVector mutableVector = this;
        MutableVector mutableVector2 = mutableVector;
        mutableVector2 = mutableVector;
        int n = mutableVector.size - 1;
        if (n >= 0) {
            while (true) {
                MutableVector mutableVector3;
                mutableVector2 = this;
                mutableVector2 = mutableVector2;
                if (Intrinsics.areEqual(mutableVector3.content[i], element)) {
                    return true;
                }
                if (i == n) break;
                ++i;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsAll(Collection<? extends T> elements) {
        Object object;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        object = (Iterable)object;
        object = object.iterator();
        while (object.hasNext()) {
            void var2_2;
            Object it = object.next();
            if (this.contains(var2_2)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void ensureCapacity(int capacity) {
        T[] oldContent = this.content;
        if (this.content.length < capacity) {
            void var1_1;
            void var2_2;
            int newSize = Math.max(capacity, oldContent.length << 1);
            T[] TArray = Arrays.copyOf(var2_2, (int)var1_1);
            Intrinsics.checkNotNullExpressionValue(TArray, (String)"copyOf(this, newSize)");
            this.content = TArray;
        }
    }

    public final T first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("MutableVector is empty.");
        }
        MutableVector mutableVector = this;
        MutableVector mutableVector2 = mutableVector;
        mutableVector2 = mutableVector;
        return mutableVector.content[0];
    }

    public final int indexOf(T element) {
        int size = this.size;
        if (size > 0) {
            int i = 0;
            T[] content = this.content;
            do {
                if (!Intrinsics.areEqual(element, content[i])) continue;
                return i;
            } while (++i < size);
        }
        return -1;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final boolean isNotEmpty() {
        return this.size != 0;
    }

    public final int lastIndexOf(T element) {
        int size = this.size;
        if (size > 0) {
            int i = size - 1;
            T[] content = this.content;
            do {
                if (!Intrinsics.areEqual(element, content[i])) continue;
                return i;
            } while (--i >= 0);
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean remove(T element) {
        int index = this.indexOf(element);
        if (index >= 0) {
            void var1_2;
            this.removeAt((int)var1_2);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean removeAll(Collection<? extends T> elements) {
        void var2_2;
        Object object;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (elements.isEmpty()) {
            return false;
        }
        int initialSize = this.size;
        object = (Iterable)object;
        object = object.iterator();
        while (object.hasNext()) {
            void var3_3;
            Object it = object.next();
            this.remove(var3_3);
        }
        return var2_2 != this.size;
    }

    /*
     * WARNING - void declaration
     */
    public final T removeAt(int index) {
        void var3_3;
        Object[] content = this.content;
        T item = this.content[index];
        MutableVector mutableVector = this;
        MutableVector mutableVector2 = mutableVector;
        mutableVector2 = mutableVector;
        if (index != mutableVector.size - 1) {
            void var1_1;
            void v1 = var1_1;
            ArraysKt.copyInto((Object[])content, (Object[])content, (int)v1, (int)(v1 + true), (int)this.size);
        }
        int n = this.size;
        this.size = n + -1;
        var2_2[this.size] = null;
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final void removeRange(int start2, int end2) {
        if (end2 > start2) {
            void var1_1;
            int newSize;
            if (end2 < this.size) {
                ArraysKt.copyInto((Object[])this.content, (Object[])this.content, (int)start2, (int)end2, (int)this.size);
            }
            int i = newSize = this.size - (end2 - start2);
            MutableVector mutableVector = this;
            MutableVector mutableVector2 = mutableVector;
            mutableVector2 = mutableVector;
            int n = mutableVector.size - 1;
            if (i <= n) {
                while (true) {
                    this.content[i] = null;
                    if (i == n) break;
                    ++i;
                }
            }
            this.size = var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean retainAll(Collection<? extends T> elements) {
        void var2_2;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int initialSize = this.size;
        MutableVector mutableVector = this;
        mutableVector = mutableVector;
        for (int i = (v37766).size - 1; i >= 0; --i) {
            MutableVector mutableVector2 = this;
            mutableVector = mutableVector2;
            mutableVector = mutableVector2;
            T item = mutableVector2.content[i];
            if (elements.contains(item)) continue;
            this.removeAt(i);
        }
        return var2_2 != this.size;
    }

    /*
     * WARNING - void declaration
     */
    public final T set(int index, T element) {
        void var2_2;
        T[] content = this.content;
        T old = this.content[index];
        var3_3[var1_1] = var2_2;
        return old;
    }

    /*
     * WARNING - void declaration
     */
    public final void sortWith(Comparator<T> comparator) {
        void var1_1;
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        ArraysKt.sortWith((Object[])this.content, (Comparator)var1_1, (int)0, (int)this.size);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0010+\n\u0002\b\n\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\rJ\u001d\u0010\n\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0010J\u001e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013H\u0016J\u0016\u0010\u0011\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0016J\u0016\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u0016\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013H\u0016J\u0016\u0010\u0017\u001a\u00028\u00012\u0006\u0010\u000f\u001a\u00020\u0007H\u0096\u0002\u00a2\u0006\u0002\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\u00072\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u000bH\u0016J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00010\u001dH\u0096\u0002J\u0015\u0010\u001e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00010 H\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00010 2\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\u0015\u0010!\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\"\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013H\u0016J\u0015\u0010#\u001a\u00028\u00012\u0006\u0010\u000f\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010$\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013H\u0016J\u001e\u0010%\u001a\u00028\u00012\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\f\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010&J\u001e\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00010\u00022\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u0007H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Landroidx/compose/runtime/collection/MutableVector$MutableVectorList;", "T", "", "vector", "Landroidx/compose/runtime/collection/MutableVector;", "(Landroidx/compose/runtime/collection/MutableVector;)V", "size", "", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "", "index", "(ILjava/lang/Object;)V", "addAll", "elements", "", "clear", "contains", "containsAll", "get", "(I)Ljava/lang/Object;", "indexOf", "(Ljava/lang/Object;)I", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "remove", "removeAll", "removeAt", "retainAll", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "subList", "fromIndex", "toIndex", "runtime"})
    @SourceDebugExtension(value={"SMAP\nMutableVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector$MutableVectorList\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n*L\n1#1,1194:1\n523#2:1195\n*S KotlinDebug\n*F\n+ 1 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector$MutableVectorList\n*L\n941#1:1195\n*E\n"})
    static final class MutableVectorList<T>
    implements List<T>,
    KMutableList {
        private final MutableVector<T> vector;

        /*
         * WARNING - void declaration
         */
        public MutableVectorList(MutableVector<T> vector) {
            void var1_1;
            Intrinsics.checkNotNullParameter(vector, (String)"vector");
            this.vector = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object element) {
            void var1_1;
            return this.vector.contains(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean containsAll(Collection<? extends Object> elements) {
            void var1_1;
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return this.vector.containsAll((Collection<T>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final T get(int index) {
            void var1_1;
            MutableVectorKt.access$checkIndex(this, index);
            MutableVector<T> mutableVector = this.vector;
            return mutableVector.getContent()[var1_1];
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int indexOf(Object element) {
            void var1_1;
            return this.vector.indexOf(var1_1);
        }

        @Override
        public final boolean isEmpty() {
            return this.vector.isEmpty();
        }

        @Override
        public final Iterator<T> iterator() {
            return new VectorListIterator(this, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int lastIndexOf(Object element) {
            void var1_1;
            return this.vector.lastIndexOf(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean add(T element) {
            void var1_1;
            return this.vector.add(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void add(int index, T element) {
            void var2_2;
            void var1_1;
            this.vector.add((int)var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean addAll(int index, Collection<? extends T> elements) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return this.vector.addAll((int)var1_1, (Collection<T>)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean addAll(Collection<? extends T> elements) {
            void var1_1;
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return this.vector.addAll((Collection<T>)var1_1);
        }

        @Override
        public final void clear() {
            this.vector.clear();
        }

        @Override
        public final ListIterator<T> listIterator() {
            return new VectorListIterator(this, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ListIterator<T> listIterator(int index) {
            void var1_1;
            return new VectorListIterator(this, (int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean remove(Object element) {
            void var1_1;
            return this.vector.remove(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean removeAll(Collection<? extends Object> elements) {
            void var1_1;
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return this.vector.removeAll((Collection<T>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean retainAll(Collection<? extends Object> elements) {
            void var1_1;
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return this.vector.retainAll((Collection<T>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final T set(int index, T element) {
            void var2_2;
            void var1_1;
            MutableVectorKt.access$checkIndex(this, index);
            return this.vector.set((int)var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final List<T> subList(int fromIndex, int toIndex) {
            void var2_2;
            void var1_1;
            MutableVectorKt.access$checkSubIndex(this, fromIndex, toIndex);
            return new SubList(this, (int)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <T> T[] toArray(T[] array) {
            void var1_1;
            Intrinsics.checkNotNullParameter(array, (String)"array");
            return CollectionToArray.toArray((Collection)this, (Object[])var1_1);
        }

        @Override
        public final Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0010+\n\u0002\b\n\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u001d\u0010\u000b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0014H\u0016J\u0016\u0010\u0012\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u000fH\u0016J\u0016\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u0017\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0014H\u0016J\u0016\u0010\u0018\u001a\u00028\u00012\u0006\u0010\u0010\u001a\u00020\u0005H\u0096\u0002\u00a2\u0006\u0002\u0010\u0019J\u0015\u0010\u001a\u001a\u00020\u00052\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\fH\u0016J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00010\u001eH\u0096\u0002J\u0015\u0010\u001f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00010!H\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00010!2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0015\u0010\"\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010#\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0014H\u0016J\u0015\u0010$\u001a\u00028\u00012\u0006\u0010\u0010\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0016\u0010%\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0014H\u0016J\u001e\u0010&\u001a\u00028\u00012\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010'J\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00010\u00022\u0006\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u0005H\u0016R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Landroidx/compose/runtime/collection/MutableVector$SubList;", "T", "", "list", "start", "", "end", "(Ljava/util/List;II)V", "size", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "", "index", "(ILjava/lang/Object;)V", "addAll", "elements", "", "clear", "contains", "containsAll", "get", "(I)Ljava/lang/Object;", "indexOf", "(Ljava/lang/Object;)I", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "remove", "removeAll", "removeAt", "retainAll", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "subList", "fromIndex", "toIndex", "runtime"})
    @SourceDebugExtension(value={"SMAP\nMutableVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector$SubList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1194:1\n1855#2,2:1195\n1855#2,2:1197\n*S KotlinDebug\n*F\n+ 1 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector$SubList\n*L\n1013#1:1195,2\n1095#1:1197,2\n*E\n"})
    static final class SubList<T>
    implements List<T>,
    KMutableList {
        private final List<T> list;
        private final int start;
        private int end;

        /*
         * WARNING - void declaration
         */
        public SubList(List<T> list, int start2, int end2) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter(list, (String)"list");
            this.list = var1_1;
            this.start = var2_2;
            this.end = var3_3;
        }

        @Override
        public final boolean contains(Object element) {
            int n = this.end;
            for (int i = this.start; i < n; ++i) {
                if (!Intrinsics.areEqual(this.list.get(i), (Object)element)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean containsAll(Collection<? extends Object> elements) {
            Object object;
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            object = (Iterable)object;
            object = object.iterator();
            while (object.hasNext()) {
                void var2_2;
                Object it = object.next();
                if (this.contains(var2_2)) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final T get(int index) {
            void var1_1;
            MutableVectorKt.access$checkIndex(this, index);
            return this.list.get((int)(var1_1 + this.start));
        }

        @Override
        public final int indexOf(Object element) {
            int n = this.end;
            for (int i = this.start; i < n; ++i) {
                if (!Intrinsics.areEqual(this.list.get(i), (Object)element)) continue;
                return i - this.start;
            }
            return -1;
        }

        @Override
        public final boolean isEmpty() {
            return this.end == this.start;
        }

        @Override
        public final Iterator<T> iterator() {
            return new VectorListIterator(this, 0);
        }

        @Override
        public final int lastIndexOf(Object element) {
            int n = this.start;
            int i = this.end - 1;
            if (n <= i) {
                while (true) {
                    if (Intrinsics.areEqual(this.list.get(i), (Object)element)) {
                        return i - this.start;
                    }
                    if (i == n) break;
                    --i;
                }
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean add(T element) {
            void var1_1;
            int n = this.end;
            this.end = n + 1;
            this.list.add(n, var1_1);
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void add(int index, T element) {
            void var2_2;
            int n;
            this.list.add((int)(n + this.start), var2_2);
            n = this.end;
            this.end = n + 1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean addAll(int index, Collection<? extends T> elements) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            this.list.addAll((int)(var1_1 + this.start), elements);
            this.end += elements.size();
            return var2_2.size() > 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean addAll(Collection<? extends T> elements) {
            void var1_1;
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            this.list.addAll(this.end, elements);
            this.end += elements.size();
            return var1_1.size() > 0;
        }

        @Override
        public final void clear() {
            int n = this.start;
            int i = this.end - 1;
            if (n <= i) {
                while (true) {
                    this.list.remove(i);
                    if (i == n) break;
                    --i;
                }
            }
            this.end = this.start;
        }

        @Override
        public final ListIterator<T> listIterator() {
            return new VectorListIterator(this, 0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ListIterator<T> listIterator(int index) {
            void var1_1;
            return new VectorListIterator(this, (int)var1_1);
        }

        @Override
        public final boolean remove(Object element2) {
            int n = this.end;
            for (int i = this.start; i < n; ++i) {
                if (!Intrinsics.areEqual(this.list.get(i), (Object)element2)) continue;
                this.list.remove(i);
                int element2 = this.end;
                this.end = element2 + -1;
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean removeAll(Collection<? extends Object> elements) {
            void var2_2;
            Object object;
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            int originalEnd = this.end;
            object = (Iterable)object;
            object = object.iterator();
            while (object.hasNext()) {
                void var3_3;
                Object it = object.next();
                this.remove(var3_3);
            }
            return var2_2 != this.end;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean retainAll(Collection<? extends Object> elements) {
            void var2_2;
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            int originalEnd = this.end;
            int i = this.end - 1;
            int n = this.start;
            if (n <= i) {
                while (true) {
                    T item;
                    if (!elements.contains(item = this.list.get(i))) {
                        this.list.remove(i);
                        int n2 = this.end;
                        this.end = n2 + -1;
                    }
                    if (i == n) break;
                    --i;
                }
            }
            return var2_2 != this.end;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final T set(int index, T element) {
            void var2_2;
            void var1_1;
            MutableVectorKt.access$checkIndex(this, index);
            return this.list.set((int)(var1_1 + this.start), var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final List<T> subList(int fromIndex, int toIndex) {
            void var2_2;
            void var1_1;
            MutableVectorKt.access$checkSubIndex(this, fromIndex, toIndex);
            return new SubList<T>(this, (int)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <T> T[] toArray(T[] array) {
            void var1_1;
            Intrinsics.checkNotNullParameter(array, (String)"array");
            return CollectionToArray.toArray((Collection)this, (Object[])var1_1);
        }

        @Override
        public final Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010+\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\f\u001a\u00020\rH\u0096\u0002J\b\u0010\u000e\u001a\u00020\rH\u0016J\u000e\u0010\u000f\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0006H\u0016J\r\u0010\u0012\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0013\u001a\u00020\u0006H\u0016J\b\u0010\u0014\u001a\u00020\tH\u0016J\u0015\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/compose/runtime/collection/MutableVector$VectorListIterator;", "T", "", "list", "", "index", "", "(Ljava/util/List;I)V", "add", "", "element", "(Ljava/lang/Object;)V", "hasNext", "", "hasPrevious", "next", "()Ljava/lang/Object;", "nextIndex", "previous", "previousIndex", "remove", "set", "runtime"})
    static final class VectorListIterator<T>
    implements ListIterator<T>,
    KMutableListIterator {
        private final List<T> list;
        private int index;

        /*
         * WARNING - void declaration
         */
        public VectorListIterator(List<T> list, int index) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter(list, (String)"list");
            this.list = var1_1;
            this.index = var2_2;
        }

        @Override
        public final boolean hasNext() {
            return this.index < this.list.size();
        }

        @Override
        public final T next() {
            int n = this.index;
            this.index = n + 1;
            return this.list.get(n);
        }

        @Override
        public final void remove() {
            int n = this.index;
            this.index = n + -1;
            this.list.remove(this.index);
        }

        @Override
        public final boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public final int nextIndex() {
            return this.index;
        }

        @Override
        public final T previous() {
            int n = this.index;
            this.index = n + -1;
            return this.list.get(this.index);
        }

        @Override
        public final int previousIndex() {
            return this.index - 1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void add(T element) {
            void var1_1;
            this.list.add(this.index, var1_1);
            int n = this.index;
            this.index = n + 1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void set(T element) {
            void var1_1;
            this.list.set(this.index, var1_1);
        }
    }
}

