/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList;

import androidx.compose.foundation.lazy.LazyListItemProviderKt;
import androidx.compose.runtime.external.kotlinx.collections.immutable.PersistentList;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.AbstractPersistentList;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.PersistentVectorBuilder;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.PersistentVectorIterator;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.SmallPersistentVector;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.UtilsKt;
import androidx.compose.runtime.external.kotlinx.collections.immutable.internal.ListImplementation;
import java.util.Arrays;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010*\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\t\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B5\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u001b\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J#\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J\u001d\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0012\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017H\u0016J\u0016\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\tH\u0096\u0002\u00a2\u0006\u0002\u0010\u0019JG\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\u0010\u001eJ5\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010 \u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010!J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#2\u0006\u0010\u0012\u001a\u00020\tH\u0016J?\u0010$\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00052\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\u0010&J3\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010(\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010)JC\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u000e\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u000e\u0010,\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005H\u0002\u00a2\u0006\u0002\u0010-J?\u0010.\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0010\u0010\u0004\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00052\u0006\u0010\u001b\u001a\u00020\t2\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005H\u0002\u00a2\u0006\u0002\u0010/J\"\u00100\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020302H\u0016J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\u0012\u001a\u00020\tH\u0016J=\u00105\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\u0010&J;\u00106\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010(\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u00107J\b\u0010(\u001a\u00020\tH\u0002J#\u00108\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J?\u00109\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\b\u0010:\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010;R\u0018\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006<"}, d2={"Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/PersistentVector;", "E", "Landroidx/compose/runtime/external/kotlinx/collections/immutable/PersistentList;", "Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/AbstractPersistentList;", "root", "", "", "tail", "size", "", "rootShift", "([Ljava/lang/Object;[Ljava/lang/Object;II)V", "[Ljava/lang/Object;", "getSize", "()I", "add", "element", "(Ljava/lang/Object;)Landroidx/compose/runtime/external/kotlinx/collections/immutable/PersistentList;", "index", "(ILjava/lang/Object;)Landroidx/compose/runtime/external/kotlinx/collections/immutable/PersistentList;", "bufferFor", "(I)[Ljava/lang/Object;", "builder", "Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/PersistentVectorBuilder;", "get", "(I)Ljava/lang/Object;", "insertIntoRoot", "shift", "elementCarry", "Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/ObjectRef;", "([Ljava/lang/Object;IILjava/lang/Object;Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/ObjectRef;)[Ljava/lang/Object;", "insertIntoTail", "tailIndex", "([Ljava/lang/Object;ILjava/lang/Object;)Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/PersistentVector;", "listIterator", "", "pullLastBuffer", "tailCarry", "([Ljava/lang/Object;IILandroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/ObjectRef;)[Ljava/lang/Object;", "pullLastBufferFromRoot", "rootSize", "([Ljava/lang/Object;II)Landroidx/compose/runtime/external/kotlinx/collections/immutable/PersistentList;", "pushFilledTail", "filledTail", "newTail", "([Ljava/lang/Object;[Ljava/lang/Object;[Ljava/lang/Object;)Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/PersistentVector;", "pushTail", "([Ljava/lang/Object;I[Ljava/lang/Object;)[Ljava/lang/Object;", "removeAll", "predicate", "Lkotlin/Function1;", "", "removeAt", "removeFromRootAt", "removeFromTailAt", "([Ljava/lang/Object;III)Landroidx/compose/runtime/external/kotlinx/collections/immutable/PersistentList;", "set", "setInRoot", "e", "([Ljava/lang/Object;IILjava/lang/Object;)[Ljava/lang/Object;", "runtime"})
@SourceDebugExtension(value={"SMAP\nPersistentVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersistentVector.kt\nandroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/PersistentVector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,325:1\n1#2:326\n*E\n"})
public final class PersistentVector<E>
extends AbstractPersistentList<E> {
    private final Object[] root;
    private final Object[] tail;
    private final int size;
    private final int rootShift;

    /*
     * WARNING - void declaration
     */
    public PersistentVector(Object[] root, Object[] tail, int size, int rootShift) {
        void var3_3;
        void var2_2;
        String string;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)tail, (String)"tail");
        this.root = string;
        this.tail = var2_2;
        this.size = var3_3;
        this.rootShift = rootShift;
        if (!(this.size() > 32)) {
            string = "Trie-based persistent vector should have at least 33 elements, got " + this.size();
            throw new IllegalArgumentException(string.toString());
        }
        this.size();
        this.size();
        RangesKt.coerceAtMost((int)this.tail.length, (int)32);
    }

    public final int getSize() {
        return this.size;
    }

    private final int rootSize() {
        int n = this.size();
        return n - 1 & 0xFFFFFFE0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final PersistentList<E> add(E element) {
        void var3_4;
        void var1_1;
        int tailSize = this.size() - this.rootSize();
        if (tailSize < 32) {
            Object[] objectArray = Arrays.copyOf(this.tail, 32);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(this, newSize)");
            Object[] newTail = objectArray;
            objectArray[var2_2] = element;
            return new PersistentVector<E>(this.root, newTail, this.size() + 1, this.rootShift);
        }
        Object[] newTail = UtilsKt.presizedBufferWith(var1_1);
        PersistentVector persistentVector = this;
        return persistentVector.pushFilledTail(persistentVector.root, this.tail, (Object[])var3_4);
    }

    /*
     * WARNING - void declaration
     */
    private final PersistentVector<E> pushFilledTail(Object[] root, Object[] filledTail, Object[] newTail) {
        void var3_3;
        void var1_1;
        void var2_2;
        Object[] newRoot;
        if (this.size() >> 5 > 1 << this.rootShift) {
            newRoot = UtilsKt.presizedBufferWith(root);
            int newRootShift = this.rootShift + 5;
            newRoot = this.pushTail(newRoot, newRootShift, filledTail);
            return new PersistentVector<E>(newRoot, newTail, this.size() + 1, newRootShift);
        }
        newRoot = this.pushTail(newRoot, this.rootShift, (Object[])var2_2);
        return new PersistentVector<E>((Object[])var1_1, (Object[])var3_3, this.size() + 1, this.rootShift);
    }

    /*
     * WARNING - void declaration
     */
    private final Object[] pushTail(Object[] root, int shift, Object[] tail) {
        void var1_1;
        void var3_3;
        void var2_2;
        Object[] objectArray;
        int bufferIndex;
        block3: {
            block2: {
                int n = shift;
                int n2 = this.size() - 1;
                bufferIndex = n2 >> n & 0x1F;
                objectArray = root;
                if (root == null) break block2;
                Object[] objectArray2 = Arrays.copyOf(objectArray, 32);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"copyOf(this, newSize)");
                objectArray = objectArray2;
                if (objectArray2 != null) break block3;
            }
            objectArray = new Object[32];
        }
        Object[] newRootNode = objectArray;
        newRootNode[bufferIndex] = shift == 5 ? tail : this.pushTail((Object[])newRootNode[bufferIndex], (int)(var2_2 - 5), (Object[])var3_3);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final PersistentList<E> add(int index, E element) {
        void var3_5;
        void var1_2;
        void var2_3;
        ListImplementation.checkPositionIndex$runtime(index, this.size());
        if (index == this.size()) {
            return this.add(element);
        }
        int rootSize = this.rootSize();
        if (index >= rootSize) {
            PersistentVector persistentVector = this;
            return persistentVector.insertIntoTail(persistentVector.root, index - rootSize, element);
        }
        LazyListItemProviderKt elementCarry = new LazyListItemProviderKt(null);
        PersistentVector persistentVector = this;
        Object[] newRoot = persistentVector.insertIntoRoot$721596a4(persistentVector.root, this.rootShift, index, var2_3, elementCarry);
        return this.insertIntoTail((Object[])var1_2, 0, var3_5.getValue());
    }

    /*
     * WARNING - void declaration
     */
    private final PersistentVector<E> insertIntoTail(Object[] root, int tailIndex, Object element) {
        void var1_1;
        void var3_3;
        int tailSize = this.size() - this.rootSize();
        Object[] objectArray = Arrays.copyOf(this.tail, 32);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(this, newSize)");
        Object[] newTail = objectArray;
        if (tailSize < 32) {
            ArraysKt.copyInto((Object[])this.tail, (Object[])newTail, (int)(tailIndex + 1), (int)tailIndex, (int)tailSize);
            newTail[tailIndex] = element;
            return new PersistentVector<E>(root, newTail, this.size() + 1, this.rootShift);
        }
        Object lastElement = this.tail[31];
        ArraysKt.copyInto((Object[])this.tail, (Object[])newTail, (int)(tailIndex + 1), (int)tailIndex, (int)(tailSize - 1));
        newTail[var2_2] = var3_3;
        return this.pushFilledTail((Object[])var1_1, newTail, UtilsKt.presizedBufferWith(lastElement));
    }

    private final Object[] insertIntoRoot$721596a4(Object[] root, int shift, int index, Object element, LazyListItemProviderKt elementCarry) {
        int n = shift;
        int n2 = index;
        int bufferIndex = n2 >> n & 0x1F;
        if (shift == 0) {
            Object[] objectArray;
            if (bufferIndex == 0) {
                objectArray = new Object[32];
            } else {
                Object[] objectArray2 = Arrays.copyOf(root, 32);
                objectArray = objectArray2;
                Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"copyOf(this, newSize)");
            }
            Object[] newRoot = objectArray;
            ArraysKt.copyInto((Object[])root, (Object[])newRoot, (int)(bufferIndex + 1), (int)bufferIndex, (int)31);
            elementCarry.setValue(root[31]);
            newRoot[bufferIndex] = element;
            return newRoot;
        }
        Object[] objectArray = Arrays.copyOf(root, 32);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(this, newSize)");
        Object[] newRoot = objectArray;
        int lowerLevelShift = shift - 5;
        Object object = root[bufferIndex];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
        newRoot[bufferIndex] = this.insertIntoRoot$721596a4((Object[])object, lowerLevelShift, index, element, elementCarry);
        for (int i = bufferIndex + 1; i < 32 && newRoot[i] != null; ++i) {
            Object object2 = root[i];
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            newRoot[i] = this.insertIntoRoot$721596a4((Object[])object2, lowerLevelShift, 0, elementCarry.getValue(), elementCarry);
        }
        return newRoot;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final PersistentList<E> removeAt(int index) {
        void var2_3;
        void var1_2;
        ListImplementation.checkElementIndex$runtime(index, this.size());
        int rootSize = this.rootSize();
        if (index >= rootSize) {
            PersistentVector persistentVector = this;
            return persistentVector.removeFromTailAt(persistentVector.root, rootSize, this.rootShift, index - rootSize);
        }
        PersistentVector persistentVector = this;
        Object[] newRoot = persistentVector.removeFromRootAt$734c9448(persistentVector.root, this.rootShift, index, new LazyListItemProviderKt(this.tail[0]));
        return this.removeFromTailAt((Object[])var1_2, (int)var2_3, this.rootShift, 0);
    }

    /*
     * WARNING - void declaration
     */
    private final PersistentList<E> removeFromTailAt(Object[] root, int rootSize, int shift, int index) {
        void var3_3;
        void var2_2;
        void var1_1;
        int tailSize = this.size() - rootSize;
        if (tailSize == 1) {
            return this.pullLastBufferFromRoot(root, rootSize, shift);
        }
        Object[] objectArray = Arrays.copyOf(this.tail, 32);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(this, newSize)");
        Object[] newTail = objectArray;
        if (index < tailSize - 1) {
            int n = index;
            ArraysKt.copyInto((Object[])this.tail, (Object[])newTail, (int)n, (int)(n + 1), (int)tailSize);
        }
        newTail[tailSize - 1] = null;
        return new PersistentVector<E>((Object[])var1_1, newTail, (int)(var2_2 + tailSize - true), (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private final PersistentList<E> pullLastBufferFromRoot(Object[] root, int rootSize, int shift) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (shift == 0) {
            Object[] objectArray;
            if (root.length == 33) {
                Object[] objectArray2 = Arrays.copyOf(root, 32);
                objectArray = objectArray2;
                Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"copyOf(this, newSize)");
            } else {
                objectArray = root;
            }
            Object[] buffer = objectArray;
            return new SmallPersistentVector(buffer);
        }
        LazyListItemProviderKt tailCarry = new LazyListItemProviderKt(null);
        Object[] objectArray = this.pullLastBuffer$734c9448(root, shift, rootSize - 1, tailCarry);
        Intrinsics.checkNotNull((Object)objectArray);
        Object[] newRoot = objectArray;
        Object object = tailCarry.getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
        Object[] newTail = (Object[])object;
        if (newRoot[1] == null) {
            Object object2 = newRoot[0];
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            Object[] lowerLevelRoot = (Object[])object2;
            return new PersistentVector<E>((Object[])var1_1, newTail, rootSize, shift - 5);
        }
        return new PersistentVector<E>((Object[])var1_1, newTail, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private final Object[] pullLastBuffer$734c9448(Object[] root, int shift, int index, LazyListItemProviderKt tailCarry) {
        void var1_1;
        void var2_3;
        Object[] objectArray;
        int n = shift;
        int n2 = index;
        int bufferIndex = n2 >> n & 0x1F;
        if (shift == 5) {
            tailCarry.setValue(root[bufferIndex]);
            objectArray = null;
        } else {
            void var3_4;
            Object[] newBufferAtIndex;
            Object object = root[bufferIndex];
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            objectArray = newBufferAtIndex = this.pullLastBuffer$734c9448((Object[])object, shift - 5, (int)var3_4, tailCarry);
        }
        if (objectArray == null && bufferIndex == 0) {
            return null;
        }
        Object[] objectArray2 = Arrays.copyOf(root, 32);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"copyOf(this, newSize)");
        Object[] newRoot = objectArray2;
        objectArray2[bufferIndex] = var2_3;
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private final Object[] removeFromRootAt$734c9448(Object[] root, int shift, int index, LazyListItemProviderKt tailCarry) {
        void var1_1;
        void var3_3;
        void var2_2;
        int n = shift;
        int n2 = index;
        int bufferIndex = n2 >> n & 0x1F;
        if (shift == 0) {
            Object[] objectArray;
            if (bufferIndex == 0) {
                objectArray = new Object[32];
            } else {
                Object[] objectArray2 = Arrays.copyOf(root, 32);
                objectArray = objectArray2;
                Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"copyOf(this, newSize)");
            }
            Object[] newRoot = objectArray;
            int n3 = bufferIndex;
            ArraysKt.copyInto((Object[])root, (Object[])newRoot, (int)n3, (int)(n3 + 1), (int)32);
            newRoot[31] = tailCarry.getValue();
            tailCarry.setValue(root[bufferIndex]);
            return newRoot;
        }
        int bufferLastIndex = 31;
        if (root[31] == null) {
            n = shift;
            bufferLastIndex = this.rootSize() - 1;
            bufferLastIndex = bufferLastIndex >> n & 0x1F;
        }
        Object[] objectArray = Arrays.copyOf(root, 32);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(this, newSize)");
        Object[] newRoot = objectArray;
        int lowerLevelShift = shift - 5;
        int i = bufferLastIndex;
        n = bufferIndex + 1;
        if (n <= i) {
            while (true) {
                Object object = newRoot[i];
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
                newRoot[i] = this.removeFromRootAt$734c9448((Object[])object, lowerLevelShift, 0, tailCarry);
                if (i == n) break;
                --i;
            }
        }
        Object object = newRoot[bufferIndex];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
        newRoot[bufferIndex] = this.removeFromRootAt$734c9448((Object[])object, (int)var2_2, (int)var3_3, tailCarry);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final PersistentList<E> removeAll(Function1<? super E, Boolean> predicate) {
        void var1_1;
        PersistentList.Builder builder;
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        PersistentList.Builder builder2 = builder = this.builder();
        ((PersistentVectorBuilder)builder).removeAllWithPredicate(var1_1);
        return ((PersistentVectorBuilder)builder).build();
    }

    @Override
    private PersistentVectorBuilder<E> builder() {
        return new PersistentVectorBuilder(this, this.root, this.tail, this.rootShift);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ListIterator<E> listIterator(int index) {
        void var1_1;
        ListImplementation.checkPositionIndex$runtime(index, this.size());
        return new PersistentVectorIterator<Object>(this.root, this.tail, (int)var1_1, this.size(), this.rootShift / 5 + 1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final E get(int index) {
        void var1_1;
        Object[] objectArray;
        ListImplementation.checkElementIndex$runtime(index, this.size());
        int n = index;
        Object[] objectArray2 = this;
        if (this.rootSize() <= n) {
            objectArray = objectArray2.tail;
        } else {
            Object[] objectArray3 = objectArray2.root;
            for (int i = objectArray2.rootShift; i > 0; i -= 5) {
                int n2 = i;
                int n3 = n;
                Object object = objectArray3[n3 >> n2 & 0x1F];
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
                objectArray3 = (Object[])object;
            }
            objectArray = objectArray3;
        }
        objectArray2 = objectArray;
        return (E)objectArray[var1_1 & 0x1F];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final PersistentList<E> set(int index, E element) {
        void var3_4;
        void var2_2;
        void var1_1;
        ListImplementation.checkElementIndex$runtime(index, this.size());
        if (this.rootSize() <= index) {
            Object[] objectArray = Arrays.copyOf(this.tail, 32);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(this, newSize)");
            Object[] newTail = objectArray;
            objectArray[index & 0x1F] = element;
            return new PersistentVector<E>(this.root, newTail, this.size(), this.rootShift);
        }
        PersistentVector persistentVector = this;
        Object[] newRoot = persistentVector.setInRoot(persistentVector.root, this.rootShift, (int)var1_1, var2_2);
        return new PersistentVector<E>((Object[])var3_4, this.tail, this.size(), this.rootShift);
    }

    /*
     * WARNING - void declaration
     */
    private final Object[] setInRoot(Object[] root, int shift, int index, Object e) {
        void var1_1;
        int n = shift;
        int n2 = index;
        int bufferIndex = n2 >> n & 0x1F;
        Object[] objectArray = Arrays.copyOf(root, 32);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(this, newSize)");
        Object[] newRoot = objectArray;
        if (shift == 0) {
            newRoot[bufferIndex] = e;
        } else {
            void var3_3;
            void var2_2;
            Object object = newRoot[bufferIndex];
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            newRoot[bufferIndex] = this.setInRoot((Object[])object, (int)(var2_2 - 5), (int)var3_3, e);
        }
        return var1_1;
    }
}

