/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList;

import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.AbstractListIterator;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.PersistentVectorBuilder;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.TrieIterator;
import java.util.ConcurrentModificationException;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableListIterator;
import kotlin.ranges.RangesKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010+\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u000eH\u0002J\b\u0010\u0012\u001a\u00020\u000eH\u0002J\u000e\u0010\u0013\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0014J\r\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0016\u001a\u00020\u000eH\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0002J\u0015\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0019\u001a\u00020\u000eH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/PersistentVectorMutableIterator;", "T", "", "Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/AbstractListIterator;", "builder", "Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/PersistentVectorBuilder;", "index", "", "(Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/PersistentVectorBuilder;I)V", "expectedModCount", "lastIteratedIndex", "trieIterator", "Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/TrieIterator;", "add", "", "element", "(Ljava/lang/Object;)V", "checkForComodification", "checkHasIterated", "next", "()Ljava/lang/Object;", "previous", "remove", "reset", "set", "setupTrieIterator", "runtime"})
public final class PersistentVectorMutableIterator<T>
extends AbstractListIterator<T>
implements ListIterator<T>,
KMutableListIterator {
    private final PersistentVectorBuilder<T> builder;
    private int expectedModCount;
    private TrieIterator<? extends T> trieIterator;
    private int lastIteratedIndex;

    /*
     * WARNING - void declaration
     */
    public PersistentVectorMutableIterator(PersistentVectorBuilder<T> builder, int index) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        super((int)var2_2, builder.size());
        this.builder = var1_1;
        this.expectedModCount = this.builder.getModCount$runtime();
        this.lastIteratedIndex = -1;
        this.setupTrieIterator();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final T previous() {
        void var1_1;
        this.checkForComodification();
        this.checkHasPrevious$runtime();
        this.lastIteratedIndex = this.getIndex() - 1;
        TrieIterator<T> trieIterator = this.trieIterator;
        if (trieIterator == null) {
            Object[] objectArray = this.builder.getTail$runtime();
            PersistentVectorMutableIterator persistentVectorMutableIterator = this;
            persistentVectorMutableIterator.setIndex(persistentVectorMutableIterator.getIndex() + -1);
            return (T)objectArray[this.getIndex()];
        }
        TrieIterator<T> trieIterator2 = trieIterator;
        if (this.getIndex() > trieIterator2.getSize()) {
            Object[] objectArray = this.builder.getTail$runtime();
            PersistentVectorMutableIterator persistentVectorMutableIterator = this;
            persistentVectorMutableIterator.setIndex(persistentVectorMutableIterator.getIndex() + -1);
            return (T)objectArray[this.getIndex() - trieIterator2.getSize()];
        }
        int n = this.getIndex();
        this.setIndex(n + -1);
        return (T)var1_1.previous();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final T next() {
        void var1_2;
        this.checkForComodification();
        this.checkHasNext$runtime();
        this.lastIteratedIndex = this.getIndex();
        TrieIterator<T> trieIterator = this.trieIterator;
        if (trieIterator == null) {
            Object[] objectArray = this.builder.getTail$runtime();
            int n = this.getIndex();
            this.setIndex(n + 1);
            return (T)objectArray[n];
        }
        TrieIterator<T> trieIterator2 = trieIterator;
        if (trieIterator.hasNext()) {
            int n = this.getIndex();
            this.setIndex(n + 1);
            return trieIterator2.next();
        }
        Object[] objectArray = this.builder.getTail$runtime();
        int n = this.getIndex();
        this.setIndex(n + 1);
        return (T)objectArray[n - var1_2.getSize()];
    }

    private final void reset() {
        PersistentVectorMutableIterator persistentVectorMutableIterator = this;
        persistentVectorMutableIterator.setSize(persistentVectorMutableIterator.builder.size());
        this.expectedModCount = this.builder.getModCount$runtime();
        this.lastIteratedIndex = -1;
        this.setupTrieIterator();
    }

    /*
     * WARNING - void declaration
     */
    private final void setupTrieIterator() {
        void var3_3;
        void var1_1;
        Object[] root = this.builder.getRoot$runtime();
        if (root == null) {
            this.trieIterator = null;
            return;
        }
        int n = this.builder.size();
        int trieSize = n - 1 & 0xFFFFFFE0;
        int trieIndex = RangesKt.coerceAtMost((int)this.getIndex(), (int)trieSize);
        int trieHeight = this.builder.getRootShift$runtime() / 5 + 1;
        if (this.trieIterator == null) {
            this.trieIterator = new TrieIterator(root, trieIndex, trieSize, trieHeight);
            return;
        }
        TrieIterator<T> trieIterator = this.trieIterator;
        Intrinsics.checkNotNull(trieIterator);
        trieIterator.reset$runtime((Object[])var1_1, (int)var3_3, n, trieHeight);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void add(T element) {
        void var1_1;
        this.checkForComodification();
        this.builder.add(this.getIndex(), var1_1);
        int n = this.getIndex();
        this.setIndex(n + 1);
        this.reset();
    }

    @Override
    public final void remove() {
        this.checkForComodification();
        this.checkHasIterated();
        this.builder.remove(this.lastIteratedIndex);
        if (this.lastIteratedIndex < this.getIndex()) {
            PersistentVectorMutableIterator persistentVectorMutableIterator = this;
            persistentVectorMutableIterator.setIndex(persistentVectorMutableIterator.lastIteratedIndex);
        }
        this.reset();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void set(T element) {
        void var1_1;
        this.checkForComodification();
        this.checkHasIterated();
        this.builder.set(this.lastIteratedIndex, var1_1);
        this.expectedModCount = this.builder.getModCount$runtime();
        this.setupTrieIterator();
    }

    private final void checkForComodification() {
        if (this.expectedModCount != this.builder.getModCount$runtime()) {
            throw new ConcurrentModificationException();
        }
    }

    private final void checkHasIterated() {
        if (this.lastIteratedIndex == -1) {
            throw new IllegalStateException();
        }
    }
}

