/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.snapshots;

import androidx.compose.runtime.snapshots.SnapshotStateList;
import androidx.compose.runtime.snapshots.SnapshotStateListKt;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableList;
import kotlin.ranges.RangesKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0010+\n\u0002\b\t\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014J\u001d\u0010\u0011\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J\u001e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00062\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0016J\u0016\u0010\u0018\u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0015H\u0016J\u0016\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010\u001d\u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0016J\u0016\u0010\u001e\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u0006H\u0096\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0015\u0010 \u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020\u0012H\u0016J\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$H\u0096\u0002J\u0015\u0010%\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010!J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000'H\u0016J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000'2\u0006\u0010\u0016\u001a\u00020\u0006H\u0016J\u0015\u0010(\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010)\u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0016J\u0015\u0010*\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0016\u0010+\u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0016J\u001e\u0010,\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010-J\u001e\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010/\u001a\u00020\u0015H\u0002R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00060"}, d2={"Landroidx/compose/runtime/snapshots/SubList;", "T", "", "parentList", "Landroidx/compose/runtime/snapshots/SnapshotStateList;", "fromIndex", "", "toIndex", "(Landroidx/compose/runtime/snapshots/SnapshotStateList;II)V", "modification", "offset", "getParentList", "()Landroidx/compose/runtime/snapshots/SnapshotStateList;", "<set-?>", "size", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "", "index", "(ILjava/lang/Object;)V", "addAll", "elements", "", "clear", "contains", "containsAll", "get", "(I)Ljava/lang/Object;", "indexOf", "(Ljava/lang/Object;)I", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "remove", "removeAll", "removeAt", "retainAll", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "subList", "validateModification", "runtime"})
@SourceDebugExtension(value={"SMAP\nSnapshotStateList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SnapshotStateList.kt\nandroidx/compose/runtime/snapshots/SubList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,458:1\n1726#2,3:459\n1855#2,2:462\n*S KotlinDebug\n*F\n+ 1 SnapshotStateList.kt\nandroidx/compose/runtime/snapshots/SubList\n*L\n312#1:459,3\n321#1:462,2\n*E\n"})
final class SubList<T>
implements List<T>,
KMutableList {
    private final SnapshotStateList<T> parentList;
    private final int offset;
    private int modification;
    private int size;

    /*
     * WARNING - void declaration
     */
    public SubList(SnapshotStateList<T> parentList, int fromIndex, int toIndex) {
        void var2_2;
        void var3_3;
        void var1_1;
        Intrinsics.checkNotNullParameter(parentList, (String)"parentList");
        this.parentList = var1_1;
        this.offset = fromIndex;
        this.modification = this.parentList.getModification$runtime();
        this.size = var3_3 - var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(Object element) {
        void var1_1;
        return this.indexOf(var1_1) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean containsAll(Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Iterable $this$all$iv = elements;
        if (!((Collection)$this$all$iv).isEmpty()) {
            Iterator iterator2;
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                void var2_2;
                Object it = iterator2.next();
                if (this.contains(var2_2)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final T get(int index) {
        void var1_1;
        this.validateModification();
        SnapshotStateListKt.access$validateRange(index, this.size());
        return this.parentList.get(this.offset + var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int indexOf(Object element) {
        this.validateModification();
        Object object = (Iterable)RangesKt.until((int)this.offset, (int)(this.offset + this.size()));
        object = object.iterator();
        while (object.hasNext()) {
            void var3_3;
            int element$iv = ((IntIterator)object).nextInt();
            if (!Intrinsics.areEqual((Object)element, this.parentList.get(element$iv))) continue;
            return (int)(var3_3 - this.offset);
        }
        return -1;
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public final Iterator<T> iterator() {
        return this.listIterator();
    }

    @Override
    public final int lastIndexOf(Object element) {
        this.validateModification();
        for (int index = this.offset + this.size() - 1; index >= this.offset; --index) {
            if (!Intrinsics.areEqual((Object)element, this.parentList.get(index))) continue;
            return index - this.offset;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean add(T element) {
        void var1_1;
        this.validateModification();
        this.parentList.add(this.offset + this.size(), var1_1);
        int n = this.size();
        this.size = n + 1;
        this.modification = this.parentList.getModification$runtime();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void add(int index, T element) {
        void var2_2;
        int n;
        this.validateModification();
        this.parentList.add(this.offset + n, var2_2);
        n = this.size();
        this.size = n + 1;
        this.modification = this.parentList.getModification$runtime();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean addAll(int index, Collection<? extends T> elements) {
        void var1_1;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        this.validateModification();
        boolean result2 = this.parentList.addAll(index + this.offset, elements);
        if (result2) {
            void var2_2;
            this.size = this.size() + var2_2.size();
            this.modification = this.parentList.getModification$runtime();
        }
        return (boolean)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean addAll(Collection<? extends T> elements) {
        void var1_1;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        SubList subList = this;
        return subList.addAll(subList.size(), (Collection<? extends T>)var1_1);
    }

    @Override
    public final void clear() {
        if (this.size() > 0) {
            this.validateModification();
            this.parentList.removeRange(this.offset, this.offset + this.size());
            this.size = 0;
            this.modification = this.parentList.getModification$runtime();
        }
    }

    @Override
    public final ListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ListIterator<T> listIterator(int index) {
        void var2_2;
        void var1_1;
        this.validateModification();
        Ref.IntRef current = new Ref.IntRef();
        new Ref.IntRef().element = var1_1 - true;
        return new ListIterator<T>((Ref.IntRef)var2_2, this){
            private /* synthetic */ Ref.IntRef $current;
            private /* synthetic */ SubList<T> this$0;
            {
                void var2_2;
                void var1_1;
                this.$current = var1_1;
                this.this$0 = var2_2;
            }

            public final boolean hasPrevious() {
                return this.$current.element >= 0;
            }

            public final int nextIndex() {
                return this.$current.element + 1;
            }

            /*
             * WARNING - void declaration
             */
            public final T previous() {
                void var1_1;
                int oldCurrent = this.$current.element;
                SnapshotStateListKt.access$validateRange(oldCurrent, this.this$0.size());
                this.$current.element = oldCurrent - 1;
                return this.this$0.get((int)var1_1);
            }

            public final int previousIndex() {
                return this.$current.element;
            }

            public final boolean hasNext() {
                return this.$current.element < this.this$0.size() - 1;
            }

            /*
             * WARNING - void declaration
             */
            public final T next() {
                void var1_1;
                int newCurrent = this.$current.element + 1;
                SnapshotStateListKt.access$validateRange(newCurrent, this.this$0.size());
                this.$current.element = newCurrent;
                return this.this$0.get((int)var1_1);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean remove(Object element) {
        int index = this.indexOf(element);
        if (index >= 0) {
            void var1_2;
            this.remove((int)var1_2);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean removeAll(Collection<? extends Object> elements) {
        void var2_2;
        Iterator iterator2;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean removed = false;
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            void var3_3;
            Object element = iterator2.next();
            removed = this.remove(var3_3) || removed;
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean retainAll(Collection<? extends Object> elements) {
        void var1_2;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        this.validateModification();
        int removed = this.parentList.retainAllInRange$runtime(elements, this.offset, this.offset + this.size());
        if (removed > 0) {
            this.modification = this.parentList.getModification$runtime();
            this.size = this.size() - removed;
        }
        return var1_2 > 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final T set(int index, T element) {
        void var1_2;
        void var2_3;
        SnapshotStateListKt.access$validateRange(index, this.size());
        this.validateModification();
        void result2 = this.parentList.set(index + this.offset, var2_3);
        this.modification = this.parentList.getModification$runtime();
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final List<T> subList(int fromIndex2, int toIndex) {
        void var2_3;
        void var1_1;
        if (!((fromIndex2 >= 0 ? fromIndex2 <= toIndex : false) && toIndex <= this.size())) {
            String fromIndex2 = "Failed requirement.";
            throw new IllegalArgumentException(fromIndex2.toString());
        }
        this.validateModification();
        return new SubList<T>(this.parentList, (int)(var1_1 + this.offset), (int)(var2_3 + this.offset));
    }

    private final void validateModification() {
        if (this.parentList.getModification$runtime() != this.modification) {
            throw new ConcurrentModificationException();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> T[] toArray(T[] array) {
        void var1_1;
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])var1_1);
    }

    @Override
    public final Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }
}

