/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.internal.Util;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0011\u0018\u0000 !2\u00020\u0001:\u0002 !Bq\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u0012\u0006\u0010\f\u001a\u00020\u0006\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u0012\u0006\u0010\u000f\u001a\u00020\u0003\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012J\r\u0010\u000f\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b\u0015J\r\u0010\u0005\u001a\u00020\u0006H\u0007\u00a2\u0006\u0002\b\u0016J\r\u0010\u000b\u001a\u00020\u0006H\u0007\u00a2\u0006\u0002\b\u0017J\r\u0010\f\u001a\u00020\u0006H\u0007\u00a2\u0006\u0002\b\u0018J\r\u0010\n\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b\u0019J\r\u0010\u0002\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b\u001aJ\r\u0010\u0004\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b\u001bJ\r\u0010\u000e\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b\u001cJ\r\u0010\r\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b\u001dJ\r\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0002\b\u001eJ\b\u0010\u001f\u001a\u00020\u0011H\u0016R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0013R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0013R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0013R\u0013\u0010\u0005\u001a\u00020\u00068\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0014R\u0013\u0010\u000b\u001a\u00020\u00068\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0014R\u0013\u0010\f\u001a\u00020\u00068\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0014R\u0013\u0010\n\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0013R\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0013R\u0013\u0010\u0004\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0013R\u0013\u0010\u000e\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0013R\u0013\u0010\r\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0013R\u0013\u0010\u0007\u001a\u00020\u00068\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0014\u00a8\u0006\""}, d2={"Lokhttp3/CacheControl;", "", "noCache", "", "noStore", "maxAgeSeconds", "", "sMaxAgeSeconds", "isPrivate", "isPublic", "mustRevalidate", "maxStaleSeconds", "minFreshSeconds", "onlyIfCached", "noTransform", "immutable", "headerValue", "", "(ZZIIZZZIIZZZLjava/lang/String;)V", "()Z", "()I", "-deprecated_immutable", "-deprecated_maxAgeSeconds", "-deprecated_maxStaleSeconds", "-deprecated_minFreshSeconds", "-deprecated_mustRevalidate", "-deprecated_noCache", "-deprecated_noStore", "-deprecated_noTransform", "-deprecated_onlyIfCached", "-deprecated_sMaxAgeSeconds", "toString", "Builder", "Companion", "okhttp"})
public final class CacheControl {
    public static final Companion Companion = new Companion(0);
    private final boolean noCache;
    private final boolean noStore;
    private final int maxAgeSeconds;
    private final int sMaxAgeSeconds;
    private final boolean isPrivate;
    private final boolean isPublic;
    private final boolean mustRevalidate;
    private final int maxStaleSeconds;
    private final int minFreshSeconds;
    private final boolean onlyIfCached;
    private final boolean noTransform;
    private final boolean immutable;
    private String headerValue;

    /*
     * WARNING - void declaration
     */
    private CacheControl(boolean noCache, boolean noStore, int maxAgeSeconds, int sMaxAgeSeconds, boolean isPrivate, boolean isPublic, boolean mustRevalidate, int maxStaleSeconds, int minFreshSeconds, boolean onlyIfCached, boolean noTransform, boolean immutable, String headerValue) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.noCache = var1_1;
        this.noStore = var2_2;
        this.maxAgeSeconds = var3_3;
        this.sMaxAgeSeconds = sMaxAgeSeconds;
        this.isPrivate = isPrivate;
        this.isPublic = isPublic;
        this.mustRevalidate = mustRevalidate;
        this.maxStaleSeconds = maxStaleSeconds;
        this.minFreshSeconds = minFreshSeconds;
        this.onlyIfCached = onlyIfCached;
        this.noTransform = noTransform;
        this.immutable = immutable;
        this.headerValue = headerValue;
    }

    @JvmName(name="noCache")
    public final boolean noCache() {
        return this.noCache;
    }

    @JvmName(name="noStore")
    public final boolean noStore() {
        return this.noStore;
    }

    @JvmName(name="maxAgeSeconds")
    public final int maxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    public final boolean isPrivate() {
        return this.isPrivate;
    }

    public final boolean isPublic() {
        return this.isPublic;
    }

    @JvmName(name="mustRevalidate")
    public final boolean mustRevalidate() {
        return this.mustRevalidate;
    }

    @JvmName(name="maxStaleSeconds")
    public final int maxStaleSeconds() {
        return this.maxStaleSeconds;
    }

    @JvmName(name="minFreshSeconds")
    public final int minFreshSeconds() {
        return this.minFreshSeconds;
    }

    @JvmName(name="onlyIfCached")
    public final boolean onlyIfCached() {
        return this.onlyIfCached;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        CharSequence result = this.headerValue;
        if (result == null) {
            void var2_2;
            result = new StringBuilder();
            StringBuilder $this$toString_u24lambda_u2d0 = result;
            CacheControl cacheControl = this;
            if (cacheControl.noCache) {
                $this$toString_u24lambda_u2d0.append("no-cache, ");
            }
            cacheControl = this;
            if (cacheControl.noStore) {
                $this$toString_u24lambda_u2d0.append("no-store, ");
            }
            cacheControl = this;
            if (cacheControl.maxAgeSeconds != -1) {
                cacheControl = this;
                $this$toString_u24lambda_u2d0.append("max-age=").append(cacheControl.maxAgeSeconds).append(", ");
            }
            cacheControl = this;
            if (cacheControl.sMaxAgeSeconds != -1) {
                cacheControl = this;
                $this$toString_u24lambda_u2d0.append("s-maxage=").append(cacheControl.sMaxAgeSeconds).append(", ");
            }
            cacheControl = this;
            if (cacheControl.isPrivate) {
                $this$toString_u24lambda_u2d0.append("private, ");
            }
            cacheControl = this;
            if (cacheControl.isPublic) {
                $this$toString_u24lambda_u2d0.append("public, ");
            }
            cacheControl = this;
            if (cacheControl.mustRevalidate) {
                $this$toString_u24lambda_u2d0.append("must-revalidate, ");
            }
            cacheControl = this;
            if (cacheControl.maxStaleSeconds != -1) {
                cacheControl = this;
                $this$toString_u24lambda_u2d0.append("max-stale=").append(cacheControl.maxStaleSeconds).append(", ");
            }
            cacheControl = this;
            if (cacheControl.minFreshSeconds != -1) {
                cacheControl = this;
                $this$toString_u24lambda_u2d0.append("min-fresh=").append(cacheControl.minFreshSeconds).append(", ");
            }
            cacheControl = this;
            if (cacheControl.onlyIfCached) {
                $this$toString_u24lambda_u2d0.append("only-if-cached, ");
            }
            cacheControl = this;
            if (cacheControl.noTransform) {
                $this$toString_u24lambda_u2d0.append("no-transform, ");
            }
            cacheControl = this;
            if (cacheControl.immutable) {
                $this$toString_u24lambda_u2d0.append("immutable, ");
            }
            if (((CharSequence)$this$toString_u24lambda_u2d0).length() == 0) {
                return "";
            }
            StringBuilder stringBuilder = $this$toString_u24lambda_u2d0;
            stringBuilder.delete(stringBuilder.length() - 2, var2_2.length());
            String string = ((StringBuilder)result).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            result = string;
            this.headerValue = result;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ CacheControl(boolean noCache, boolean noStore, int maxAgeSeconds, int sMaxAgeSeconds, boolean isPrivate, boolean isPublic, boolean mustRevalidate, int maxStaleSeconds, int minFreshSeconds, boolean onlyIfCached, boolean noTransform, boolean immutable, String headerValue, byte by) {
        this((boolean)var1_1, (boolean)var2_2, (int)var3_3, sMaxAgeSeconds, isPrivate, isPublic, mustRevalidate, maxStaleSeconds, minFreshSeconds, onlyIfCached, noTransform, immutable, headerValue);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    static {
        new Builder().noCache().build();
        new Builder().onlyIfCached().maxStale(Integer.MAX_VALUE, TimeUnit.SECONDS).build();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u0003\u001a\u00020\u0000J\u0016\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\t\u001a\u00020\u0000J\u0006\u0010\n\u001a\u00020\u0000J\u0006\u0010\u000b\u001a\u00020\u0000J\u0006\u0010\f\u001a\u00020\u0000J\f\u0010\u0014\u001a\u00020\u0006*\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lokhttp3/CacheControl$Builder;", "", "()V", "immutable", "", "maxAgeSeconds", "", "maxStaleSeconds", "minFreshSeconds", "noCache", "noStore", "noTransform", "onlyIfCached", "build", "Lokhttp3/CacheControl;", "maxAge", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "maxStale", "minFresh", "clampToInt", "", "okhttp"})
    public static final class Builder {
        private boolean noCache;
        private int maxAgeSeconds = -1;
        private int maxStaleSeconds = -1;
        private int minFreshSeconds = -1;
        private boolean onlyIfCached;

        public final Builder noCache() {
            Builder builder;
            Builder builder2 = builder = this;
            builder.noCache = true;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder maxStale(int maxStale, TimeUnit timeUnit) {
            void var2_3;
            long maxStaleSecondsLong;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
            Builder $this$maxStale_u24lambda_u2d5 = builder = this;
            long l = maxStaleSecondsLong = var2_3.toSeconds(Integer.MAX_VALUE);
            var3_4.maxStaleSeconds = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
            return builder;
        }

        public final Builder onlyIfCached() {
            Builder builder;
            Builder builder2 = builder = this;
            builder.onlyIfCached = true;
            return builder;
        }

        public final CacheControl build() {
            return new CacheControl(this.noCache, false, this.maxAgeSeconds, -1, false, false, false, this.maxStaleSeconds, this.minFreshSeconds, this.onlyIfCached, false, false, null, 0);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001e\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\nH\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lokhttp3/CacheControl$Companion;", "", "()V", "FORCE_CACHE", "Lokhttp3/CacheControl;", "FORCE_NETWORK", "parse", "headers", "Lokhttp3/Headers;", "indexOfElement", "", "", "characters", "startIndex", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final CacheControl parse(Headers headers) {
            void var3_3;
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            boolean noCache = false;
            boolean noStore = false;
            int maxAgeSeconds = -1;
            int sMaxAgeSeconds = -1;
            boolean isPrivate = false;
            boolean isPublic = false;
            boolean mustRevalidate = false;
            int maxStaleSeconds = -1;
            int minFreshSeconds = -1;
            boolean onlyIfCached = false;
            boolean noTransform = false;
            boolean immutable = false;
            boolean canUseHeaderValue = true;
            String headerValue = null;
            int n = 0;
            int n2 = headers.size();
            while (n < n2) {
                int i = n++;
                String name = headers.name(i);
                String value = headers.value(i);
                if (StringsKt.equals((String)name, (String)"Cache-Control", (boolean)true)) {
                    if (headerValue != null) {
                        canUseHeaderValue = false;
                    } else {
                        headerValue = value;
                    }
                } else {
                    if (!StringsKt.equals((String)name, (String)"Pragma", (boolean)true)) continue;
                    canUseHeaderValue = false;
                }
                int pos = 0;
                while (pos < value.length()) {
                    String string;
                    int tokenStart = pos;
                    pos = okhttp3.CacheControl$Companion.indexOfElement(value, "=,;", pos);
                    String string2 = value.substring(tokenStart, pos);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    String directive = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                    if (pos == value.length() || value.charAt(pos) == ',' || value.charAt(pos) == ';') {
                        int n3 = pos;
                        pos = n3 + 1;
                        Object parameter = null;
                    } else {
                        int parameterStart;
                        int parameter = pos;
                        pos = parameter + 1;
                        if ((pos = Util.indexOfNonWhitespace(value, pos)) < value.length() && value.charAt(pos) == '\"') {
                            parameter = pos;
                            parameterStart = pos = parameter + 1;
                            pos = StringsKt.indexOf$default((CharSequence)value, (char)'\"', (int)pos, (boolean)false, (int)4, null);
                            Intrinsics.checkNotNullExpressionValue((Object)value.substring(parameterStart, pos), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                            ++pos;
                        } else {
                            parameterStart = pos;
                            pos = okhttp3.CacheControl$Companion.indexOfElement(value, ",;", pos);
                            String string3 = value.substring(parameterStart, pos);
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                            string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                        }
                    }
                    if (StringsKt.equals((String)"no-cache", (String)directive, (boolean)true)) {
                        noCache = true;
                        continue;
                    }
                    if (StringsKt.equals((String)"no-store", (String)directive, (boolean)true)) {
                        noStore = true;
                        continue;
                    }
                    if (StringsKt.equals((String)"max-age", (String)directive, (boolean)true)) {
                        maxAgeSeconds = Util.toNonNegativeInt(string, -1);
                        continue;
                    }
                    if (StringsKt.equals((String)"s-maxage", (String)directive, (boolean)true)) {
                        sMaxAgeSeconds = Util.toNonNegativeInt(string, -1);
                        continue;
                    }
                    if (StringsKt.equals((String)"private", (String)directive, (boolean)true)) {
                        isPrivate = true;
                        continue;
                    }
                    if (StringsKt.equals((String)"public", (String)directive, (boolean)true)) {
                        isPublic = true;
                        continue;
                    }
                    if (StringsKt.equals((String)"must-revalidate", (String)directive, (boolean)true)) {
                        mustRevalidate = true;
                        continue;
                    }
                    if (StringsKt.equals((String)"max-stale", (String)directive, (boolean)true)) {
                        maxStaleSeconds = Util.toNonNegativeInt(string, Integer.MAX_VALUE);
                        continue;
                    }
                    if (StringsKt.equals((String)"min-fresh", (String)directive, (boolean)true)) {
                        minFreshSeconds = Util.toNonNegativeInt(string, -1);
                        continue;
                    }
                    if (StringsKt.equals((String)"only-if-cached", (String)directive, (boolean)true)) {
                        onlyIfCached = true;
                        continue;
                    }
                    if (StringsKt.equals((String)"no-transform", (String)directive, (boolean)true)) {
                        noTransform = true;
                        continue;
                    }
                    if (!StringsKt.equals((String)"immutable", (String)directive, (boolean)true)) continue;
                    immutable = true;
                }
            }
            if (!canUseHeaderValue) {
                headerValue = null;
            }
            return new CacheControl((boolean)var2_2, (boolean)var3_3, maxAgeSeconds, sMaxAgeSeconds, isPrivate, isPublic, mustRevalidate, maxStaleSeconds, minFreshSeconds, onlyIfCached, noTransform, immutable, headerValue, 0);
        }

        private static int indexOfElement(String $this$indexOfElement, String characters, int startIndex) {
            String string;
            int n = startIndex;
            int n2 = $this$indexOfElement.length();
            while (n < n2) {
                int i;
                if (!StringsKt.contains$default((CharSequence)characters, (char)$this$indexOfElement.charAt(i = n++), (boolean)false, (int)2, null)) continue;
                return i;
            }
            return string.length();
        }

        public /* synthetic */ Companion(byte by) {
            this();
        }
    }
}

