/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.Serializable;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.tls.CertificateChainCleaner;
import okio.ByteString;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \"2\u00020\u0001:\u0003!\"#B!\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J)\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0011H\u0000\u00a2\u0006\u0002\b\u0014J)\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\"\u00020\u0017H\u0007\u00a2\u0006\u0002\u0010\u0018J\u001c\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0012J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0015\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006$"}, d2={"Lokhttp3/CertificatePinner;", "", "pins", "", "Lokhttp3/CertificatePinner$Pin;", "certificateChainCleaner", "Lokhttp3/internal/tls/CertificateChainCleaner;", "(Ljava/util/Set;Lokhttp3/internal/tls/CertificateChainCleaner;)V", "getCertificateChainCleaner$okhttp", "()Lokhttp3/internal/tls/CertificateChainCleaner;", "getPins", "()Ljava/util/Set;", "check", "", "hostname", "", "cleanedPeerCertificatesFn", "Lkotlin/Function0;", "", "Ljava/security/cert/X509Certificate;", "check$okhttp", "peerCertificates", "", "Ljava/security/cert/Certificate;", "(Ljava/lang/String;[Ljava/security/cert/Certificate;)V", "equals", "", "other", "findMatchingPins", "hashCode", "", "withCertificateChainCleaner", "withCertificateChainCleaner$okhttp", "Builder", "Companion", "Pin", "okhttp"})
public final class CertificatePinner {
    public static final Companion Companion = new Companion(0);
    private final Set<Pin> pins;
    private final CertificateChainCleaner certificateChainCleaner;
    @JvmField
    public static final CertificatePinner DEFAULT = new Builder().build();

    /*
     * WARNING - void declaration
     */
    private CertificatePinner(Set<Pin> pins, CertificateChainCleaner certificateChainCleaner) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(pins, (String)"pins");
        this.pins = var1_1;
        this.certificateChainCleaner = var2_2;
    }

    public /* synthetic */ CertificatePinner(Set set, CertificateChainCleaner certificateChainCleaner, int n) {
        certificateChainCleaner = null;
        this(set, certificateChainCleaner);
    }

    public final CertificateChainCleaner getCertificateChainCleaner$okhttp() {
        return this.certificateChainCleaner;
    }

    /*
     * WARNING - void declaration
     */
    public final void check(String hostname, List<? extends Certificate> peerCertificates2) throws SSLPeerUnverifiedException {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        Intrinsics.checkNotNullParameter(peerCertificates2, (String)"peerCertificates");
        this.check$okhttp(hostname, (Function0<? extends List<? extends X509Certificate>>)((Function0)new Function0<List<? extends X509Certificate>>(this, (List<? extends Certificate>)var2_2, (String)var1_1){
            private /* synthetic */ CertificatePinner this$0;
            private /* synthetic */ List<Certificate> $peerCertificates;
            private /* synthetic */ String $hostname;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.$peerCertificates = var2_2;
                this.$hostname = var3_3;
                super(0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    public final void check$okhttp(String hostname, Function0<? extends List<? extends X509Certificate>> cleanedPeerCertificatesFn) {
        void var3_3;
        void var1_1;
        Iterator<Pin> iterator;
        Serializable serializable;
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        Intrinsics.checkNotNullParameter(cleanedPeerCertificatesFn, (String)"cleanedPeerCertificatesFn");
        List<Pin> pins = this.findMatchingPins(hostname);
        if (pins.isEmpty()) {
            return;
        }
        Object peerCertificates2 = (List)cleanedPeerCertificatesFn.invoke();
        Iterator iterator2 = peerCertificates2.iterator();
        while (iterator2.hasNext()) {
            serializable = (X509Certificate)iterator2.next();
            Object var6_6 = null;
            serializable = null;
            iterator = pins.iterator();
            if (!iterator.hasNext()) continue;
            Object object = peerCertificates2 = iterator.next();
            throw null;
        }
        serializable = new StringBuilder();
        StringBuilder $this$check_u24lambda_u2d0 = serializable;
        ((StringBuilder)serializable).append("Certificate pinning failure!");
        $this$check_u24lambda_u2d0.append("\n  Peer certificate chain:");
        iterator = peerCertificates2.iterator();
        while (iterator.hasNext()) {
            X509Certificate element = (X509Certificate)((Object)iterator.next());
            $this$check_u24lambda_u2d0.append("\n    ");
            $this$check_u24lambda_u2d0.append(Companion.pin(element));
            $this$check_u24lambda_u2d0.append(": ");
            $this$check_u24lambda_u2d0.append(element.getSubjectDN().getName());
        }
        $this$check_u24lambda_u2d0.append("\n  Pinned certificates for ");
        $this$check_u24lambda_u2d0.append((String)var1_1);
        $this$check_u24lambda_u2d0.append(":");
        for (Pin pin : var3_3) {
            void var2_2;
            $this$check_u24lambda_u2d0.append("\n    ");
            $this$check_u24lambda_u2d0.append(var2_2);
        }
        String string = ((StringBuilder)serializable).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String message = string;
        throw new SSLPeerUnverifiedException(message);
    }

    /*
     * WARNING - void declaration
     */
    private List<Pin> findMatchingPins(String hostname) {
        void var3_3;
        Object object;
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        Iterable $this$filterList$iv = this.pins;
        List result$iv = CollectionsKt.emptyList();
        object = object.iterator();
        if (object.hasNext()) {
            void var1_1;
            object = object.next();
            Object object2 = object = (Pin)object;
            void v1 = var1_1;
            throw null;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final CertificatePinner withCertificateChainCleaner$okhttp(CertificateChainCleaner certificateChainCleaner) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)certificateChainCleaner, (String)"certificateChainCleaner");
        if (Intrinsics.areEqual((Object)this.certificateChainCleaner, (Object)certificateChainCleaner)) {
            return this;
        }
        return new CertificatePinner(this.pins, (CertificateChainCleaner)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        return other instanceof CertificatePinner && Intrinsics.areEqual(((CertificatePinner)other).pins, this.pins) && Intrinsics.areEqual((Object)((CertificatePinner)var1_1).certificateChainCleaner, (Object)this.certificateChainCleaner);
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int result = 1517 + ((Object)this.pins).hashCode();
        CertificateChainCleaner certificateChainCleaner = this.certificateChainCleaner;
        var1_1 = var1_1 * 41 + (certificateChainCleaner != null ? certificateChainCleaner.hashCode() : 0);
        return (int)var1_1;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0003J\b\u0010\u0018\u001a\u00020\u0003H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0019"}, d2={"Lokhttp3/CertificatePinner$Pin;", "", "pattern", "", "pin", "(Ljava/lang/String;Ljava/lang/String;)V", "hash", "Lokio/ByteString;", "getHash", "()Lokio/ByteString;", "hashAlgorithm", "getHashAlgorithm", "()Ljava/lang/String;", "getPattern", "equals", "", "other", "hashCode", "", "matchesCertificate", "certificate", "Ljava/security/cert/X509Certificate;", "matchesHostname", "hostname", "toString", "okhttp"})
    public static final class Pin {
        public final String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            Pin pin = this;
            throw null;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object other) {
            void var1_1;
            if (this == other) {
                return true;
            }
            if (!(var1_1 instanceof Pin)) {
                return false;
            }
            Pin pin = this;
            throw null;
        }

        public final int hashCode() {
            Pin pin = this;
            throw null;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J'\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u000b\"\u00020\n\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\r\u001a\u00020\u000eR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lokhttp3/CertificatePinner$Builder;", "", "()V", "pins", "", "Lokhttp3/CertificatePinner$Pin;", "getPins", "()Ljava/util/List;", "add", "pattern", "", "", "(Ljava/lang/String;[Ljava/lang/String;)Lokhttp3/CertificatePinner$Builder;", "build", "Lokhttp3/CertificatePinner;", "okhttp"})
    public static final class Builder {
        private final List<Pin> pins = new ArrayList();

        public final CertificatePinner build() {
            return new CertificatePinner(CollectionsKt.toSet((Iterable)this.pins), null, 2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0007J\f\u0010\f\u001a\u00020\n*\u00020\u000bH\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lokhttp3/CertificatePinner$Companion;", "", "()V", "DEFAULT", "Lokhttp3/CertificatePinner;", "pin", "", "certificate", "Ljava/security/cert/Certificate;", "sha1Hash", "Lokio/ByteString;", "Ljava/security/cert/X509Certificate;", "sha256Hash", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public static ByteString sha256Hash(X509Certificate $this$sha256Hash) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)$this$sha256Hash, (String)"<this>");
            byte[] byArray = ((Certificate)object).getPublicKey().getEncoded();
            object = byArray;
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"publicKey.encoded");
            object = ByteString.Companion.of$default$5b50e2db((ByteString.Companion)ByteString.Companion, (byte[])object, (int)0, (int)0, (int)3);
            return object.digest$okio("SHA-256");
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final String pin(Certificate certificate) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
            if (!(certificate instanceof X509Certificate)) {
                certificate = "Certificate pinning requires X509 certificates";
                throw new IllegalArgumentException(certificate.toString());
            }
            return Intrinsics.stringPlus((String)"sha256/", (Object)okhttp3.CertificatePinner$Companion.sha256Hash((X509Certificate)var1_1).base64());
        }

        public /* synthetic */ Companion(byte by) {
            this();
        }
    }
}

