/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLSocket;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.CipherSuite;
import okhttp3.TlsVersion;
import okhttp3.internal.Util;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\t\u0018\u0000 $2\u00020\u0001:\u0002#$B7\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\tJ\u001d\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u0017J\u0015\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0007\u00a2\u0006\u0002\b\u0018J\u0013\u0010\u0019\u001a\u00020\u00032\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u000e\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0015J\u0018\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\r\u0010\u0004\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b J\u0015\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000bH\u0007\u00a2\u0006\u0002\b!J\b\u0010\"\u001a\u00020\u0007H\u0016R\u0019\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b8G\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\rR\u0018\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u000fR\u0013\u0010\u0004\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000fR\u0019\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000b8G\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\rR\u0018\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006%"}, d2={"Lokhttp3/ConnectionSpec;", "", "isTls", "", "supportsTlsExtensions", "cipherSuitesAsString", "", "", "tlsVersionsAsString", "(ZZ[Ljava/lang/String;[Ljava/lang/String;)V", "cipherSuites", "", "Lokhttp3/CipherSuite;", "()Ljava/util/List;", "[Ljava/lang/String;", "()Z", "tlsVersions", "Lokhttp3/TlsVersion;", "apply", "", "sslSocket", "Ljavax/net/ssl/SSLSocket;", "isFallback", "apply$okhttp", "-deprecated_cipherSuites", "equals", "other", "hashCode", "", "isCompatible", "socket", "supportedSpec", "-deprecated_supportsTlsExtensions", "-deprecated_tlsVersions", "toString", "Builder", "Companion", "okhttp"})
public final class ConnectionSpec {
    private final boolean isTls;
    private final boolean supportsTlsExtensions;
    private final String[] cipherSuitesAsString;
    private final String[] tlsVersionsAsString;
    private static final CipherSuite[] RESTRICTED_CIPHER_SUITES;
    private static final CipherSuite[] APPROVED_CIPHER_SUITES;
    @JvmField
    public static final ConnectionSpec MODERN_TLS;
    @JvmField
    public static final ConnectionSpec CLEARTEXT;

    /*
     * WARNING - void declaration
     */
    public ConnectionSpec(boolean isTls, boolean supportsTlsExtensions, String[] cipherSuitesAsString, String[] tlsVersionsAsString) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.isTls = var1_1;
        this.supportsTlsExtensions = var2_2;
        this.cipherSuitesAsString = var3_3;
        this.tlsVersionsAsString = tlsVersionsAsString;
    }

    @JvmName(name="isTls")
    public final boolean isTls() {
        return this.isTls;
    }

    @JvmName(name="supportsTlsExtensions")
    public final boolean supportsTlsExtensions() {
        return this.supportsTlsExtensions;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="cipherSuites")
    private List<CipherSuite> cipherSuites() {
        List list;
        void $this$mapTo$iv$iv;
        if (this.cipherSuitesAsString == null) {
            return null;
        }
        String[] $this$map$iv = this.cipherSuitesAsString;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Collection collection = destination$iv$iv;
            collection.add(CipherSuite.Companion.forJavaName((String)it));
        }
        list = list;
        return CollectionsKt.toList((Iterable)list);
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="tlsVersions")
    private List<TlsVersion> tlsVersions() {
        List list;
        void $this$mapTo$iv$iv;
        if (this.tlsVersionsAsString == null) {
            return null;
        }
        String[] $this$map$iv = this.tlsVersionsAsString;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Collection collection = destination$iv$iv;
            collection.add(TlsVersion.Companion.forJavaName((String)it));
        }
        list = list;
        return CollectionsKt.toList((Iterable)list);
    }

    /*
     * WARNING - void declaration
     */
    public final void apply$okhttp(SSLSocket sslSocket, boolean isFallback2) {
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3;
        String[] stringArray4;
        String[] stringArray5;
        Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
        boolean bl = isFallback2;
        SSLSocket sSLSocket = sslSocket;
        String[] isFallback2 = this;
        if (this.cipherSuitesAsString != null) {
            stringArray5 = sSLSocket.getEnabledCipherSuites();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray5, (String)"sslSocket.enabledCipherSuites");
            stringArray4 = Util.intersect(stringArray5, isFallback2.cipherSuitesAsString, CipherSuite.access$getORDER_BY_NAME$cp());
        } else {
            stringArray4 = stringArray3 = sSLSocket.getEnabledCipherSuites();
        }
        if (isFallback2.tlsVersionsAsString != null) {
            stringArray2 = sSLSocket.getEnabledProtocols();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"sslSocket.enabledProtocols");
            stringArray = Util.intersect(stringArray2, isFallback2.tlsVersionsAsString, ComparisonsKt.naturalOrder());
        } else {
            stringArray = sSLSocket.getEnabledProtocols();
        }
        stringArray5 = stringArray;
        stringArray2 = sSLSocket.getSupportedCipherSuites();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"supportedCipherSuites");
        int n = Util.indexOf(stringArray2, "TLS_FALLBACK_SCSV", CipherSuite.access$getORDER_BY_NAME$cp());
        if (bl && n != -1) {
            Object object = stringArray3;
            Intrinsics.checkNotNullExpressionValue((Object)stringArray3, (String)"cipherSuitesIntersection");
            String[] stringArray6 = object;
            object = stringArray2[n];
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"supportedCipherSuites[indexOfFallbackScsv]");
            stringArray3 = Util.concat(stringArray6, (String)object);
        }
        Builder builder = new Builder((ConnectionSpec)isFallback2);
        isFallback2 = stringArray3;
        Intrinsics.checkNotNullExpressionValue((Object)stringArray3, (String)"cipherSuitesIntersection");
        String[] stringArray7 = isFallback2;
        Builder builder2 = builder.cipherSuites(Arrays.copyOf(isFallback2, stringArray7.length));
        Intrinsics.checkNotNullExpressionValue((Object)stringArray5, (String)"tlsVersionsIntersection");
        stringArray7 = stringArray5;
        ConnectionSpec specToApply = builder2.tlsVersions(Arrays.copyOf(stringArray5, stringArray7.length)).build();
        if (specToApply.tlsVersions() != null) {
            sslSocket.setEnabledProtocols(specToApply.tlsVersionsAsString);
        }
        if (specToApply.cipherSuites() != null) {
            void var2_3;
            void var1_1;
            var1_1.setEnabledCipherSuites(var2_3.cipherSuitesAsString);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isCompatible(SSLSocket socket) {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        if (!this.isTls) {
            return false;
        }
        if (this.tlsVersionsAsString != null && !Util.hasIntersection(this.tlsVersionsAsString, socket.getEnabledProtocols(), ComparisonsKt.naturalOrder())) {
            return false;
        }
        if (this.cipherSuitesAsString != null) {
            void var1_1;
            if (!Util.hasIntersection(this.cipherSuitesAsString, var1_1.getEnabledCipherSuites(), CipherSuite.access$getORDER_BY_NAME$cp())) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        if (!(other instanceof ConnectionSpec)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.isTls != ((ConnectionSpec)other).isTls) {
            return false;
        }
        if (this.isTls) {
            void var1_1;
            if (!Arrays.equals(this.cipherSuitesAsString, ((ConnectionSpec)other).cipherSuitesAsString)) {
                return false;
            }
            if (!Arrays.equals(this.tlsVersionsAsString, ((ConnectionSpec)other).tlsVersionsAsString)) {
                return false;
            }
            if (this.supportsTlsExtensions != ((ConnectionSpec)var1_1).supportsTlsExtensions) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int result4222 = 17;
        if (this.isTls) {
            Object[] result4222 = this.cipherSuitesAsString;
            int result4222 = 527 + (this.cipherSuitesAsString == null ? 0 : (result4222 = Arrays.hashCode(result4222)));
            Object[] result4222 = this.tlsVersionsAsString;
            result4222 = result4222 * 31 + (this.tlsVersionsAsString == null ? 0 : (result4222 = Arrays.hashCode(result4222)));
            result4222 = result4222 * 31 + (this.supportsTlsExtensions ? 0 : 1);
        }
        return (int)var1_1;
    }

    public final String toString() {
        if (!this.isTls) {
            return "ConnectionSpec()";
        }
        return "ConnectionSpec(cipherSuites=" + Objects.toString(this.cipherSuites(), "[all enabled]") + ", tlsVersions=" + Objects.toString(this.tlsVersions(), "[all enabled]") + ", supportsTlsExtensions=" + this.supportsTlsExtensions + ')';
    }

    static {
        new Companion(0);
        CipherSuite[] cipherSuiteArray = new CipherSuite[9];
        Object[] objectArray = cipherSuiteArray;
        cipherSuiteArray[0] = CipherSuite.TLS_AES_128_GCM_SHA256;
        objectArray[1] = CipherSuite.TLS_AES_256_GCM_SHA384;
        objectArray[2] = CipherSuite.TLS_CHACHA20_POLY1305_SHA256;
        objectArray[3] = CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256;
        objectArray[4] = CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256;
        objectArray[5] = CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384;
        objectArray[6] = CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384;
        objectArray[7] = CipherSuite.TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256;
        objectArray[8] = CipherSuite.TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256;
        RESTRICTED_CIPHER_SUITES = objectArray;
        CipherSuite[] cipherSuiteArray2 = new CipherSuite[16];
        objectArray = cipherSuiteArray2;
        cipherSuiteArray2[0] = CipherSuite.TLS_AES_128_GCM_SHA256;
        objectArray[1] = CipherSuite.TLS_AES_256_GCM_SHA384;
        objectArray[2] = CipherSuite.TLS_CHACHA20_POLY1305_SHA256;
        objectArray[3] = CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256;
        objectArray[4] = CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256;
        objectArray[5] = CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384;
        objectArray[6] = CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384;
        objectArray[7] = CipherSuite.TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256;
        objectArray[8] = CipherSuite.TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256;
        objectArray[9] = CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA;
        objectArray[10] = CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA;
        objectArray[11] = CipherSuite.TLS_RSA_WITH_AES_128_GCM_SHA256;
        objectArray[12] = CipherSuite.TLS_RSA_WITH_AES_256_GCM_SHA384;
        objectArray[13] = CipherSuite.TLS_RSA_WITH_AES_128_CBC_SHA;
        objectArray[14] = CipherSuite.TLS_RSA_WITH_AES_256_CBC_SHA;
        objectArray[15] = CipherSuite.TLS_RSA_WITH_3DES_EDE_CBC_SHA;
        APPROVED_CIPHER_SUITES = objectArray;
        objectArray = RESTRICTED_CIPHER_SUITES;
        Builder builder = new Builder(true).cipherSuites(Arrays.copyOf(RESTRICTED_CIPHER_SUITES, objectArray.length));
        TlsVersion[] tlsVersionArray = new TlsVersion[2];
        objectArray = tlsVersionArray;
        tlsVersionArray[0] = TlsVersion.TLS_1_3;
        objectArray[1] = TlsVersion.TLS_1_2;
        builder.tlsVersions((TlsVersion[])objectArray).supportsTlsExtensions(true).build();
        objectArray = APPROVED_CIPHER_SUITES;
        Builder builder2 = new Builder(true).cipherSuites(Arrays.copyOf(APPROVED_CIPHER_SUITES, objectArray.length));
        TlsVersion[] tlsVersionArray2 = new TlsVersion[2];
        objectArray = tlsVersionArray2;
        tlsVersionArray2[0] = TlsVersion.TLS_1_3;
        objectArray[1] = TlsVersion.TLS_1_2;
        MODERN_TLS = builder2.tlsVersions((TlsVersion[])objectArray).supportsTlsExtensions(true).build();
        objectArray = APPROVED_CIPHER_SUITES;
        Builder builder3 = new Builder(true).cipherSuites(Arrays.copyOf(APPROVED_CIPHER_SUITES, objectArray.length));
        TlsVersion[] tlsVersionArray3 = new TlsVersion[4];
        objectArray = tlsVersionArray3;
        tlsVersionArray3[0] = TlsVersion.TLS_1_3;
        objectArray[1] = TlsVersion.TLS_1_2;
        objectArray[2] = TlsVersion.TLS_1_1;
        objectArray[3] = TlsVersion.TLS_1_0;
        builder3.tlsVersions((TlsVersion[])objectArray).supportsTlsExtensions(true).build();
        CLEARTEXT = new Builder(false).build();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0019\u001a\u00020\u0000J\u0006\u0010\u001a\u001a\u00020\u0000J\u0006\u0010\u001b\u001a\u00020\u0006J\u001f\u0010\b\u001a\u00020\u00002\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\n\u00a2\u0006\u0002\u0010\u001cJ\u001f\u0010\b\u001a\u00020\u00002\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\t\"\u00020\u001d\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0003H\u0007J\u001f\u0010\u0016\u001a\u00020\u00002\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\n\u00a2\u0006\u0002\u0010\u001cJ\u001f\u0010\u0016\u001a\u00020\u00002\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0\t\"\u00020\u001f\u00a2\u0006\u0002\u0010 R$\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0010\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0012\"\u0004\b\u0015\u0010\u0004R$\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u0017\u0010\f\"\u0004\b\u0018\u0010\u000e\u00a8\u0006!"}, d2={"Lokhttp3/ConnectionSpec$Builder;", "", "tls", "", "(Z)V", "connectionSpec", "Lokhttp3/ConnectionSpec;", "(Lokhttp3/ConnectionSpec;)V", "cipherSuites", "", "", "getCipherSuites$okhttp", "()[Ljava/lang/String;", "setCipherSuites$okhttp", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "supportsTlsExtensions", "getSupportsTlsExtensions$okhttp", "()Z", "setSupportsTlsExtensions$okhttp", "getTls$okhttp", "setTls$okhttp", "tlsVersions", "getTlsVersions$okhttp", "setTlsVersions$okhttp", "allEnabledCipherSuites", "allEnabledTlsVersions", "build", "([Ljava/lang/String;)Lokhttp3/ConnectionSpec$Builder;", "Lokhttp3/CipherSuite;", "([Lokhttp3/CipherSuite;)Lokhttp3/ConnectionSpec$Builder;", "Lokhttp3/TlsVersion;", "([Lokhttp3/TlsVersion;)Lokhttp3/ConnectionSpec$Builder;", "okhttp"})
    public static final class Builder {
        private boolean tls;
        private String[] cipherSuites;
        private String[] tlsVersions;
        private boolean supportsTlsExtensions;

        /*
         * WARNING - void declaration
         */
        public Builder(boolean tls) {
            void var1_1;
            this.tls = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Builder(ConnectionSpec connectionSpec) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)connectionSpec, (String)"connectionSpec");
            this.tls = connectionSpec.isTls();
            this.cipherSuites = connectionSpec.cipherSuitesAsString;
            this.tlsVersions = connectionSpec.tlsVersionsAsString;
            this.supportsTlsExtensions = var1_1.supportsTlsExtensions();
        }

        /*
         * WARNING - void declaration
         */
        public final Builder cipherSuites(CipherSuite ... cipherSuites) {
            void var2_2;
            void var1_1;
            void $this$mapTo$iv$iv;
            CipherSuite[] $this$cipherSuites_u24lambda_u2d4;
            Intrinsics.checkNotNullParameter((Object)cipherSuites, (String)"cipherSuites");
            Object object = $this$cipherSuites_u24lambda_u2d4 = this;
            if (!$this$cipherSuites_u24lambda_u2d4.tls) {
                cipherSuites = "no cipher suites for cleartext connections";
                throw new IllegalArgumentException(cipherSuites.toString());
            }
            CipherSuite[] $this$map$iv = cipherSuites;
            object = cipherSuites;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Collection collection = destination$iv$iv;
                collection.add(it.javaName());
            }
            destination$iv$iv = (List)destination$iv$iv;
            object = destination$iv$iv;
            String[] stringArray = destination$iv$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            String[] strings = stringArray;
            void v1 = var1_1;
            return var2_2.cipherSuites((String[])Arrays.copyOf(v1, ((void)v1).length));
        }

        /*
         * WARNING - void declaration
         */
        public final Builder cipherSuites(String ... cipherSuites) {
            void var3_3;
            String[] stringArray;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)cipherSuites, (String)"cipherSuites");
            Builder $this$cipherSuites_u24lambda_u2d7 = builder = this;
            Builder builder2 = builder;
            if (!builder.tls) {
                cipherSuites = "no cipher suites for cleartext connections";
                throw new IllegalArgumentException(cipherSuites.toString());
            }
            if (!(!(((String[])cipherSuites).length == 0))) {
                cipherSuites = "At least one cipher suite is required";
                throw new IllegalArgumentException(cipherSuites.toString());
            }
            stringArray = (String[])stringArray.clone();
            builder2 = var3_3;
            var3_3.cipherSuites = stringArray;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder tlsVersions(TlsVersion ... tlsVersions) {
            void var2_2;
            void var1_1;
            void $this$mapTo$iv$iv;
            TlsVersion[] $this$tlsVersions_u24lambda_u2d12;
            Intrinsics.checkNotNullParameter((Object)tlsVersions, (String)"tlsVersions");
            Object object = $this$tlsVersions_u24lambda_u2d12 = this;
            if (!$this$tlsVersions_u24lambda_u2d12.tls) {
                tlsVersions = "no TLS versions for cleartext connections";
                throw new IllegalArgumentException(tlsVersions.toString());
            }
            TlsVersion[] $this$map$iv = tlsVersions;
            object = tlsVersions;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Collection collection = destination$iv$iv;
                collection.add(it.javaName());
            }
            destination$iv$iv = (List)destination$iv$iv;
            object = destination$iv$iv;
            String[] stringArray = destination$iv$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            String[] strings = stringArray;
            void v1 = var1_1;
            return var2_2.tlsVersions((String[])Arrays.copyOf(v1, ((void)v1).length));
        }

        /*
         * WARNING - void declaration
         */
        public final Builder tlsVersions(String ... tlsVersions) {
            void var3_3;
            String[] stringArray;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)tlsVersions, (String)"tlsVersions");
            Builder $this$tlsVersions_u24lambda_u2d15 = builder = this;
            Builder builder2 = builder;
            if (!builder.tls) {
                tlsVersions = "no TLS versions for cleartext connections";
                throw new IllegalArgumentException(tlsVersions.toString());
            }
            if (!(!(((String[])tlsVersions).length == 0))) {
                tlsVersions = "At least one TLS version is required";
                throw new IllegalArgumentException(tlsVersions.toString());
            }
            stringArray = (String[])stringArray.clone();
            builder2 = var3_3;
            var3_3.tlsVersions = stringArray;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated(message="since OkHttp 3.13 all TLS-connections are expected to support TLS extensions.\nIn a future release setting this to true will be unnecessary and setting it to false\nwill have no effect.")
        public final Builder supportsTlsExtensions(boolean supportsTlsExtensions) {
            void var2_3;
            Object object = this;
            Builder $this$supportsTlsExtensions_u24lambda_u2d17 = object;
            Builder builder = object;
            if (!((Builder)object).tls) {
                object = "no TLS extensions for cleartext connections";
                throw new IllegalArgumentException(object.toString());
            }
            boolean bl = true;
            builder = var2_3;
            var2_3.supportsTlsExtensions = bl;
            return (Builder)object;
        }

        public final ConnectionSpec build() {
            return new ConnectionSpec(this.tls, this.supportsTlsExtensions, this.cipherSuites, this.tlsVersions);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0010\u0010\f\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lokhttp3/ConnectionSpec$Companion;", "", "()V", "APPROVED_CIPHER_SUITES", "", "Lokhttp3/CipherSuite;", "[Lokhttp3/CipherSuite;", "CLEARTEXT", "Lokhttp3/ConnectionSpec;", "COMPATIBLE_TLS", "MODERN_TLS", "RESTRICTED_CIPHER_SUITES", "RESTRICTED_TLS", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(byte by) {
            this();
        }
    }
}

