/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.internal.HostnamesKt;
import okhttp3.internal.Util;
import okhttp3.internal.http.DatesKt;
import okhttp3.internal.publicsuffix.PublicSuffixDatabase;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 &2\u00020\u0001:\u0002%&BO\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000eJ\r\u0010\u0007\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b\u0012J\u0013\u0010\u0013\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\r\u0010\u0005\u001a\u00020\u0006H\u0007\u00a2\u0006\u0002\b\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0017J\r\u0010\r\u001a\u00020\nH\u0007\u00a2\u0006\u0002\b\u0018J\r\u0010\u000b\u001a\u00020\nH\u0007\u00a2\u0006\u0002\b\u0019J\u000e\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cJ\r\u0010\u0002\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b\u001dJ\r\u0010\b\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b\u001eJ\r\u0010\f\u001a\u00020\nH\u0007\u00a2\u0006\u0002\b\u001fJ\r\u0010\t\u001a\u00020\nH\u0007\u00a2\u0006\u0002\b J\b\u0010!\u001a\u00020\u0003H\u0016J\u0015\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b#J\r\u0010\u0004\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b$R\u0013\u0010\u0007\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u000fR\u0013\u0010\u0005\u001a\u00020\u00068\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0010R\u0013\u0010\r\u001a\u00020\n8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0011R\u0013\u0010\u000b\u001a\u00020\n8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0011R\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u000fR\u0013\u0010\b\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u000fR\u0013\u0010\f\u001a\u00020\n8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0011R\u0013\u0010\t\u001a\u00020\n8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0011R\u0013\u0010\u0004\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000f\u00a8\u0006'"}, d2={"Lokhttp3/Cookie;", "", "name", "", "value", "expiresAt", "", "domain", "path", "secure", "", "httpOnly", "persistent", "hostOnly", "(Ljava/lang/String;Ljava/lang/String;JLjava/lang/String;Ljava/lang/String;ZZZZ)V", "()Ljava/lang/String;", "()J", "()Z", "-deprecated_domain", "equals", "other", "-deprecated_expiresAt", "hashCode", "", "-deprecated_hostOnly", "-deprecated_httpOnly", "matches", "url", "Lokhttp3/HttpUrl;", "-deprecated_name", "-deprecated_path", "-deprecated_persistent", "-deprecated_secure", "toString", "forObsoleteRfc2965", "toString$okhttp", "-deprecated_value", "Builder", "Companion", "okhttp"})
public final class Cookie {
    public static final Companion Companion = new Companion(0);
    private final String name;
    private final String value;
    private final long expiresAt;
    private final String domain;
    private final String path;
    private final boolean secure;
    private final boolean httpOnly;
    private final boolean persistent;
    private final boolean hostOnly;
    private static final Pattern YEAR_PATTERN = Pattern.compile("(\\d{2,4})[^\\d]*");
    private static final Pattern MONTH_PATTERN = Pattern.compile("(?i)(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec).*");
    private static final Pattern DAY_OF_MONTH_PATTERN = Pattern.compile("(\\d{1,2})[^\\d]*");
    private static final Pattern TIME_PATTERN = Pattern.compile("(\\d{1,2}):(\\d{1,2}):(\\d{1,2})[^\\d]*");

    /*
     * WARNING - void declaration
     */
    private Cookie(String name, String value, long expiresAt, String domain, String path, boolean secure, boolean httpOnly, boolean persistent, boolean hostOnly) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.name = var1_1;
        this.value = var2_2;
        this.expiresAt = var3_3;
        this.domain = domain;
        this.path = path;
        this.secure = secure;
        this.httpOnly = httpOnly;
        this.persistent = persistent;
        this.hostOnly = hostOnly;
    }

    @JvmName(name="name")
    public final String name() {
        return this.name;
    }

    @JvmName(name="value")
    public final String value() {
        return this.value;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        return other instanceof Cookie && Intrinsics.areEqual((Object)((Cookie)other).name, (Object)this.name) && Intrinsics.areEqual((Object)((Cookie)other).value, (Object)this.value) && ((Cookie)other).expiresAt == this.expiresAt && Intrinsics.areEqual((Object)((Cookie)other).domain, (Object)this.domain) && Intrinsics.areEqual((Object)((Cookie)other).path, (Object)this.path) && ((Cookie)other).secure == this.secure && ((Cookie)other).httpOnly == this.httpOnly && ((Cookie)other).persistent == this.persistent && ((Cookie)var1_1).hostOnly == this.hostOnly;
    }

    /*
     * WARNING - void declaration
     */
    @IgnoreJRERequirement
    public final int hashCode() {
        void var1_1;
        int result = 527 + this.name.hashCode();
        result = result * 31 + this.value.hashCode();
        result = result * 31 + Long.hashCode(this.expiresAt);
        result = result * 31 + this.domain.hashCode();
        result = result * 31 + this.path.hashCode();
        result = result * 31 + Boolean.hashCode(this.secure);
        result = result * 31 + Boolean.hashCode(this.httpOnly);
        result = result * 31 + Boolean.hashCode(this.persistent);
        var1_1 = var1_1 * 31 + Boolean.hashCode(this.hostOnly);
        return (int)var1_1;
    }

    public final String toString() {
        boolean bl = false;
        Object object = this;
        StringBuilder stringBuilder = new StringBuilder();
        Cookie cookie = object;
        stringBuilder.append(cookie.name);
        stringBuilder.append('=');
        cookie = object;
        stringBuilder.append(cookie.value);
        cookie = object;
        if (cookie.persistent) {
            cookie = object;
            if (cookie.expiresAt == Long.MIN_VALUE) {
                stringBuilder.append("; max-age=0");
            } else {
                cookie = object;
                stringBuilder.append("; expires=").append(DatesKt.toHttpDateString(new Date(cookie.expiresAt)));
            }
        }
        cookie = object;
        if (!cookie.hostOnly) {
            stringBuilder.append("; domain=");
            cookie = object;
            stringBuilder.append(cookie.domain);
        }
        cookie = object;
        stringBuilder.append("; path=").append(cookie.path);
        cookie = object;
        if (cookie.secure) {
            stringBuilder.append("; secure");
        }
        cookie = object;
        if (cookie.httpOnly) {
            stringBuilder.append("; httponly");
        }
        object = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"toString()");
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ Cookie(String name, String value, long expiresAt, String domain, String path, boolean secure, boolean httpOnly, boolean persistent, boolean hostOnly, byte by) {
        this((String)var1_1, (String)var2_2, (long)var3_3, domain, path, secure, httpOnly, persistent, hostOnly);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\fH\u0002J'\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u001bJ\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\fH\u0007J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u0010\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\fH\u0002J \u0010\"\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0010\u0010#\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\fH\u0002J\u0018\u0010$\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\fH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lokhttp3/Cookie$Companion;", "", "()V", "DAY_OF_MONTH_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "MONTH_PATTERN", "TIME_PATTERN", "YEAR_PATTERN", "dateCharacterOffset", "", "input", "", "pos", "limit", "invert", "", "domainMatch", "urlHost", "domain", "parse", "Lokhttp3/Cookie;", "currentTimeMillis", "", "url", "Lokhttp3/HttpUrl;", "setCookie", "parse$okhttp", "parseAll", "", "headers", "Lokhttp3/Headers;", "parseDomain", "s", "parseExpires", "parseMaxAge", "pathMatch", "path", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Cookie parse$okhttp(long currentTimeMillis, HttpUrl url, String setCookie) {
            String string;
            void var3_2;
            String encodedPath;
            int lastSlash;
            String string2;
            void var1_1;
            long deltaMilliseconds;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)setCookie, (String)"setCookie");
            int cookiePairEnd = Util.delimiterOffset$default$263f57ec(setCookie, ';', 0, 0, 6);
            int pairEqualsSign = Util.delimiterOffset$default$263f57ec(setCookie, '=', 0, cookiePairEnd, 2);
            if (pairEqualsSign == cookiePairEnd) {
                return null;
            }
            String cookieName = Util.trimSubstring$default$7bab7980(setCookie, 0, pairEqualsSign, 1);
            if (((CharSequence)cookieName).length() == 0) {
                return null;
            }
            boolean bl = false;
            if (bl) return null;
            if (Util.indexOfControlOrNonAscii(cookieName) != -1) {
                return null;
            }
            String cookieValue = Util.trimSubstring(setCookie, pairEqualsSign + 1, cookiePairEnd);
            if (Util.indexOfControlOrNonAscii(cookieValue) != -1) {
                return null;
            }
            long expiresAt = 253402300799999L;
            long deltaSeconds = -1L;
            String domain = null;
            String path = null;
            boolean secureOnly = false;
            boolean httpOnly = false;
            boolean hostOnly = true;
            boolean persistent = false;
            int pos = cookiePairEnd + 1;
            int limit = setCookie.length();
            while (pos < limit) {
                String attributeValue;
                int attributePairEnd = Util.delimiterOffset(setCookie, ';', pos, limit);
                int attributeEqualsSign = Util.delimiterOffset(setCookie, '=', pos, attributePairEnd);
                Object attributeName42222 = Util.trimSubstring(setCookie, pos, attributeEqualsSign);
                String string3 = attributeValue = attributeEqualsSign < attributePairEnd ? Util.trimSubstring(setCookie, attributeEqualsSign + 1, attributePairEnd) : "";
                if (StringsKt.equals((String)attributeName42222, (String)"expires", (boolean)true)) {
                    try {
                        int n = attributeValue.length();
                        boolean attributeName42222 = false;
                        Companion attributeName42222 = this;
                        int attributeName42222 = okhttp3.Cookie$Companion.dateCharacterOffset(attributeValue, 0, n, false);
                        attributeEqualsSign = -1;
                        int n2 = -1;
                        int n3 = -1;
                        int n4 = -1;
                        int n5 = -1;
                        int n6 = -1;
                        Matcher matcher = TIME_PATTERN.matcher(attributeValue);
                        while (attributeName42222 < n) {
                            int n7 = okhttp3.Cookie$Companion.dateCharacterOffset(attributeValue, attributeName42222 + 1, n, true);
                            matcher.region(attributeName42222, n7);
                            if (attributeEqualsSign == -1 && matcher.usePattern(TIME_PATTERN).matches()) {
                                String attributeName42222 = matcher.group(1);
                                Intrinsics.checkNotNullExpressionValue((Object)attributeName42222, (String)"matcher.group(1)");
                                attributeEqualsSign = Integer.parseInt(attributeName42222);
                                attributeName42222 = matcher.group(2);
                                Intrinsics.checkNotNullExpressionValue((Object)attributeName42222, (String)"matcher.group(2)");
                                n2 = Integer.parseInt(attributeName42222);
                                attributeName42222 = matcher.group(3);
                                Intrinsics.checkNotNullExpressionValue((Object)attributeName42222, (String)"matcher.group(3)");
                                n3 = Integer.parseInt(attributeName42222);
                            } else if (n4 == -1 && matcher.usePattern(DAY_OF_MONTH_PATTERN).matches()) {
                                String attributeName42222 = matcher.group(1);
                                Intrinsics.checkNotNullExpressionValue((Object)attributeName42222, (String)"matcher.group(1)");
                                n4 = Integer.parseInt(attributeName42222);
                            } else if (n5 == -1 && matcher.usePattern(MONTH_PATTERN).matches()) {
                                String string4 = matcher.group(1);
                                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"matcher.group(1)");
                                Object attributeName42222 = Locale.US;
                                Intrinsics.checkNotNullExpressionValue((Object)attributeName42222, (String)"US");
                                String string5 = string4.toLowerCase((Locale)attributeName42222);
                                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).toLowerCase(locale)");
                                attributeName42222 = string5;
                                string4 = MONTH_PATTERN.pattern();
                                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"MONTH_PATTERN.pattern()");
                                n5 = StringsKt.indexOf$default((CharSequence)string4, (String)attributeName42222, (int)0, (boolean)false, (int)6, null) / 4;
                            } else if (n6 == -1 && matcher.usePattern(YEAR_PATTERN).matches()) {
                                String attributeName42222 = matcher.group(1);
                                Intrinsics.checkNotNullExpressionValue((Object)attributeName42222, (String)"matcher.group(1)");
                                n6 = Integer.parseInt(attributeName42222);
                            }
                            attributeName42222 = okhttp3.Cookie$Companion.dateCharacterOffset(attributeValue, n7 + 1, n, false);
                        }
                        boolean bl2 = 70 <= n6 ? n6 < 100 : false;
                        if (bl2) {
                            n6 += 1900;
                        }
                        boolean bl3 = n6 >= 0 ? n6 < 70 : false;
                        if (bl3) {
                            n6 += 2000;
                        }
                        if (!(n6 >= 1601)) {
                            String attributeName42222 = "Failed requirement.";
                            throw new IllegalArgumentException(attributeName42222.toString());
                        }
                        if (!(n5 != -1)) {
                            String attributeName42222 = "Failed requirement.";
                            throw new IllegalArgumentException(attributeName42222.toString());
                        }
                        if (!(n4 > 0 ? n4 < 32 : false)) {
                            String attributeName42222 = "Failed requirement.";
                            throw new IllegalArgumentException(attributeName42222.toString());
                        }
                        if (!(attributeEqualsSign >= 0 ? attributeEqualsSign < 24 : false)) {
                            String attributeName42222 = "Failed requirement.";
                            throw new IllegalArgumentException(attributeName42222.toString());
                        }
                        if (!(n2 >= 0 ? n2 < 60 : false)) {
                            String attributeName42222 = "Failed requirement.";
                            throw new IllegalArgumentException(attributeName42222.toString());
                        }
                        if (!(n3 >= 0 ? n3 < 60 : false)) {
                            String attributeName42222 = "Failed requirement.";
                            throw new IllegalArgumentException(attributeName42222.toString());
                        }
                        attributeName42222 = new GregorianCalendar(Util.UTC);
                        ((Calendar)attributeName42222).setLenient(false);
                        ((Calendar)attributeName42222).set(1, n6);
                        ((Calendar)attributeName42222).set(2, n5 - 1);
                        ((Calendar)attributeName42222).set(5, n4);
                        ((Calendar)attributeName42222).set(11, attributeEqualsSign);
                        ((Calendar)attributeName42222).set(12, n2);
                        ((Calendar)attributeName42222).set(13, n3);
                        ((Calendar)attributeName42222).set(14, 0);
                        expiresAt = ((Calendar)attributeName42222).getTimeInMillis();
                        persistent = true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else if (StringsKt.equals((String)attributeName42222, (String)"max-age", (boolean)true)) {
                    try {
                        deltaSeconds = okhttp3.Cookie$Companion.parseMaxAge(attributeValue);
                        persistent = true;
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (StringsKt.equals((String)attributeName42222, (String)"domain", (boolean)true)) {
                    try {
                        attributeName42222 = attributeValue;
                        if (!(!StringsKt.endsWith$default((String)attributeName42222, (String)".", (boolean)false, (int)2, null))) {
                            attributeName42222 = "Failed requirement.";
                            throw new IllegalArgumentException(attributeName42222.toString());
                        }
                        if (HostnamesKt.toCanonicalHost(StringsKt.removePrefix((String)attributeName42222, (CharSequence)".")) == null) {
                            throw new IllegalArgumentException();
                        }
                        hostOnly = false;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else if (StringsKt.equals((String)attributeName42222, (String)"path", (boolean)true)) {
                    path = attributeValue;
                } else if (StringsKt.equals((String)attributeName42222, (String)"secure", (boolean)true)) {
                    secureOnly = true;
                } else if (StringsKt.equals((String)attributeName42222, (String)"httponly", (boolean)true)) {
                    httpOnly = true;
                }
                int attributeName42222 = attributePairEnd + 1;
            }
            if (deltaSeconds == Long.MIN_VALUE) {
                expiresAt = Long.MIN_VALUE;
            } else if (deltaSeconds != -1L && ((expiresAt = currentTimeMillis + (deltaMilliseconds = deltaSeconds <= 9223372036854775L ? deltaSeconds * 1000L : Long.MAX_VALUE)) < var1_1 || expiresAt > 253402300799999L)) {
                expiresAt = 253402300799999L;
            }
            String urlHost = url.host();
            if (domain == null) {
                domain = urlHost;
            } else {
                boolean bl4;
                String attributeName42222 = urlHost;
                string2 = domain;
                if (Intrinsics.areEqual((Object)attributeName42222, (Object)string2)) {
                    bl4 = true;
                } else {
                    if (!StringsKt.endsWith$default((String)attributeName42222, (String)string2, (boolean)false, (int)2, null)) return null;
                    String string6 = attributeName42222;
                    if (string6.charAt(string6.length() - string2.length() - 1) != '.') return null;
                    if (Util.canParseAsIpAddress(attributeName42222)) return null;
                    bl4 = true;
                }
                if (!bl4) {
                    return null;
                }
            }
            if (urlHost.length() != domain.length()) {
                if (PublicSuffixDatabase.access$getInstance$cp().getEffectiveTldPlusOne(domain) == null) {
                    return null;
                }
            }
            if (path != null) {
                if (StringsKt.startsWith$default(path, (String)"/", (boolean)false, (int)2, null)) return new Cookie(cookieName, cookieValue, expiresAt, domain, path, secureOnly, httpOnly, persistent, hostOnly, 0);
            }
            if ((lastSlash = StringsKt.lastIndexOf$default((CharSequence)(encodedPath = var3_2.encodedPath()), (char)'/', (int)0, (boolean)false, (int)6, null)) != 0) {
                string2 = encodedPath;
                String string7 = string2.substring(0, lastSlash);
                string = string7;
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            } else {
                string = "/";
            }
            path = string;
            return new Cookie(cookieName, cookieValue, expiresAt, domain, path, secureOnly, httpOnly, persistent, hostOnly, 0);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        private static int dateCharacterOffset(String input, int pos, int limit, boolean invert) {
            int i;
            boolean bl;
            int n = pos;
            do {
                boolean bl2;
                block6: {
                    block5: {
                        char c;
                        if (n >= limit) {
                            void var2_2;
                            return (int)var2_2;
                        }
                        if ((c = input.charAt(i = n++)) < ' ' && c != '\t' || c >= '\u007f') break block5;
                        if (c <= '9' ? '0' <= c : false) break block5;
                        if (c <= 'z' ? 'a' <= c : false) break block5;
                        boolean bl3 = c <= 'Z' ? 'A' <= c : false;
                        if (!bl3 && c != ':') break block6;
                    }
                    bl = true;
                    continue;
                }
                bl = bl2 = false;
            } while (bl != !invert);
            return i;
        }

        /*
         * WARNING - void declaration
         */
        private static long parseMaxAge(String s) {
            try {
                long parsed = Long.parseLong(s);
                if (parsed <= 0L) {
                    return Long.MIN_VALUE;
                }
                return parsed;
            }
            catch (NumberFormatException e) {
                void var1_2;
                CharSequence charSequence = s;
                if (new Regex("-?\\d+").matches(charSequence)) {
                    String string;
                    if (StringsKt.startsWith$default((String)string, (String)"-", (boolean)false, (int)2, null)) {
                        return Long.MIN_VALUE;
                    }
                    return Long.MAX_VALUE;
                }
                throw var1_2;
            }
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final List<Cookie> parseAll(HttpUrl url, Headers headers) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            List<String> cookieStrings = headers.values("Set-Cookie");
            List cookies = null;
            int n = 0;
            int n2 = cookieStrings.size();
            while (n < n2) {
                Cookie cookie;
                int i22 = n++;
                String string = cookieStrings.get(i22);
                HttpUrl httpUrl = url;
                Companion i22 = this;
                Intrinsics.checkNotNullParameter((Object)httpUrl, (String)"url");
                Intrinsics.checkNotNullParameter((Object)string, (String)"setCookie");
                if (i22.parse$okhttp(System.currentTimeMillis(), httpUrl, string) == null) continue;
                if (cookies == null) {
                    cookies = new ArrayList();
                }
                cookies.add(cookie);
            }
            if (cookies != null) {
                void var3_3;
                List<Cookie> list = Collections.unmodifiableList(var3_3);
                Intrinsics.checkNotNullExpressionValue(list, (String)"{\n        Collections.un\u2026ableList(cookies)\n      }");
                return list;
            }
            return CollectionsKt.emptyList();
        }

        public /* synthetic */ Companion(byte by) {
            this();
        }
    }
}

