/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.internal.HostnamesKt;
import okhttp3.internal.Util;
import okio.Buffer;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 J2\u00020\u0001:\u0002IJBa\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u0012\u0010\u0010\u000b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\n\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\r\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000eJ\u000f\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0007\u00a2\u0006\u0002\b!J\r\u0010\u0011\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b\"J\r\u0010\u0012\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b#J\u0013\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u0007\u00a2\u0006\u0002\b$J\u000f\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u0007\u00a2\u0006\u0002\b%J\r\u0010\u0016\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b&J\u0013\u0010'\u001a\u00020\u00182\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u000f\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0007\u00a2\u0006\u0002\b)J\b\u0010*\u001a\u00020\bH\u0016J\r\u0010\u0006\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b+J\u0006\u0010,\u001a\u00020-J\u0010\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020\u0003J\r\u0010\u0005\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b/J\u0013\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u0007\u00a2\u0006\u0002\b0J\r\u0010\u001a\u001a\u00020\bH\u0007\u00a2\u0006\u0002\b1J\r\u0010\u0007\u001a\u00020\bH\u0007\u00a2\u0006\u0002\b2J\u000f\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0007\u00a2\u0006\u0002\b3J\u0010\u00104\u001a\u0004\u0018\u00010\u00032\u0006\u00105\u001a\u00020\u0003J\u000e\u00106\u001a\u00020\u00032\u0006\u00107\u001a\u00020\bJ\u0013\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u001eH\u0007\u00a2\u0006\u0002\b8J\u0010\u00109\u001a\u0004\u0018\u00010\u00032\u0006\u00107\u001a\u00020\bJ\u0016\u0010:\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\n2\u0006\u00105\u001a\u00020\u0003J\r\u0010 \u001a\u00020\bH\u0007\u00a2\u0006\u0002\b;J\u0006\u0010<\u001a\u00020\u0003J\u0010\u0010=\u001a\u0004\u0018\u00010\u00002\u0006\u0010.\u001a\u00020\u0003J\r\u0010\u0002\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b>J\b\u0010?\u001a\u00020\u0003H\u0016J\r\u0010@\u001a\u00020AH\u0007\u00a2\u0006\u0002\bBJ\r\u0010C\u001a\u00020DH\u0007\u00a2\u0006\u0002\b\rJ\b\u0010E\u001a\u0004\u0018\u00010\u0003J\r\u0010B\u001a\u00020AH\u0007\u00a2\u0006\u0002\bFJ\r\u0010\r\u001a\u00020DH\u0007\u00a2\u0006\u0002\bGJ\r\u0010\u0004\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\bHR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00038G\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0012\u001a\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\n8G\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00038G\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0010R\u0011\u0010\u0016\u001a\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010R\u0015\u0010\f\u001a\u0004\u0018\u00010\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0010R\u0013\u0010\u0006\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0010R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0019R\u0013\u0010\u0005\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0010R\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0014R\u0011\u0010\u001a\u001a\u00020\b8G\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u0007\u001a\u00020\b8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u001bR\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u00038G\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0010R\u0018\u0010\u000b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u001e8G\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001fR\u0011\u0010 \u001a\u00020\b8G\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001bR\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0010R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0010\u00a8\u0006K"}, d2={"Lokhttp3/HttpUrl;", "", "scheme", "", "username", "password", "host", "port", "", "pathSegments", "", "queryNamesAndValues", "fragment", "url", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/util/List;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;)V", "encodedFragment", "()Ljava/lang/String;", "encodedPassword", "encodedPath", "encodedPathSegments", "()Ljava/util/List;", "encodedQuery", "encodedUsername", "isHttps", "", "()Z", "pathSize", "()I", "query", "queryParameterNames", "", "()Ljava/util/Set;", "querySize", "-deprecated_encodedFragment", "-deprecated_encodedPassword", "-deprecated_encodedPath", "-deprecated_encodedPathSegments", "-deprecated_encodedQuery", "-deprecated_encodedUsername", "equals", "other", "-deprecated_fragment", "hashCode", "-deprecated_host", "newBuilder", "Lokhttp3/HttpUrl$Builder;", "link", "-deprecated_password", "-deprecated_pathSegments", "-deprecated_pathSize", "-deprecated_port", "-deprecated_query", "queryParameter", "name", "queryParameterName", "index", "-deprecated_queryParameterNames", "queryParameterValue", "queryParameterValues", "-deprecated_querySize", "redact", "resolve", "-deprecated_scheme", "toString", "toUri", "Ljava/net/URI;", "uri", "toUrl", "Ljava/net/URL;", "topPrivateDomain", "-deprecated_uri", "-deprecated_url", "-deprecated_username", "Builder", "Companion", "okhttp"})
public final class HttpUrl {
    public static final Companion Companion = new Companion(0);
    private final String scheme;
    private final String username;
    private final String password;
    private final String host;
    private final int port;
    private final List<String> pathSegments;
    private final List<String> queryNamesAndValues;
    private final String fragment;
    private final String url;
    private final boolean isHttps;
    private static final char[] HEX_DIGITS;

    /*
     * WARNING - void declaration
     */
    public HttpUrl(String scheme, String username, String password, String host, int port, List<String> pathSegments, List<String> queryNamesAndValues, String fragment, String url) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter(pathSegments, (String)"pathSegments");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.scheme = var1_1;
        this.username = var2_2;
        this.password = var3_3;
        this.host = host;
        this.port = port;
        this.pathSegments = pathSegments;
        this.queryNamesAndValues = queryNamesAndValues;
        this.fragment = fragment;
        this.url = url;
        this.isHttps = Intrinsics.areEqual((Object)this.scheme, (Object)"https");
    }

    @JvmName(name="scheme")
    public final String scheme() {
        return this.scheme;
    }

    @JvmName(name="host")
    public final String host() {
        return this.host;
    }

    @JvmName(name="port")
    public final int port() {
        return this.port;
    }

    @JvmName(name="pathSegments")
    public final List<String> pathSegments() {
        return this.pathSegments;
    }

    public final boolean isHttps() {
        return this.isHttps;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="url")
    public final URL url() {
        try {
            return new URL(this.url);
        }
        catch (MalformedURLException e) {
            void var1_1;
            throw new RuntimeException((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="uri")
    public final URI uri() {
        String string;
        int n;
        String string2;
        Object object = this;
        Object object2 = new Builder();
        ((Builder)object2).setScheme$okhttp(((HttpUrl)object).scheme);
        ((Builder)object2).setEncodedUsername$okhttp(((HttpUrl)object).encodedUsername());
        ((Builder)object2).setEncodedPassword$okhttp(((HttpUrl)object).encodedPassword());
        ((Builder)object2).setHost$okhttp(((HttpUrl)object).host);
        ((Builder)object2).setPort$okhttp(((HttpUrl)object).port != okhttp3.HttpUrl$Companion.defaultPort(((HttpUrl)object).scheme) ? ((HttpUrl)object).port : -1);
        ((Builder)object2).getEncodedPathSegments$okhttp().clear();
        ((Builder)object2).getEncodedPathSegments$okhttp().addAll((Collection<String>)((HttpUrl)object).encodedPathSegments());
        ((Builder)object2).encodedQuery(((HttpUrl)object).encodedQuery());
        if (((HttpUrl)object).fragment == null) {
            string2 = null;
        } else {
            n = StringsKt.indexOf$default((CharSequence)((HttpUrl)object).url, (char)'#', (int)0, (boolean)false, (int)6, null) + 1;
            String string3 = ((HttpUrl)object).url.substring(n);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
        }
        ((Builder)object2).setEncodedFragment$okhttp(string2);
        Builder builder = object2;
        object = builder;
        object2 = builder;
        object = builder;
        String string4 = ((Builder)object).getHost$okhttp();
        if (string4 == null) {
            string = null;
        } else {
            CharSequence charSequence = string4;
            Regex regex = new Regex("[\"<>^`{|}]");
            String string5 = "";
            string = regex.replace(charSequence, string5);
        }
        builder.setHost$okhttp(string);
        n = 0;
        int n2 = ((Builder)object).getEncodedPathSegments$okhttp().size();
        while (n < n2) {
            int n3 = n++;
            ((Builder)object).getEncodedPathSegments$okhttp().set(n3, okhttp3.HttpUrl$Companion.canonicalize$okhttp$default$72d20940(Companion, ((Builder)object).getEncodedPathSegments$okhttp().get(n3), 0, 0, "[]", true, true, false, false, null, 227));
        }
        Regex regex = ((Builder)object).getEncodedQueryNamesAndValues$okhttp();
        if (regex != null) {
            n2 = 0;
            int n4 = regex.size();
            while (n2 < n4) {
                int n5 = n2++;
                String string6 = regex.get(n5);
                regex.set(n5, string6 == null ? null : okhttp3.HttpUrl$Companion.canonicalize$okhttp$default$72d20940(Companion, string6, 0, 0, "\\^`{|}", true, true, true, false, null, 195));
            }
        }
        Object object3 = object;
        String string7 = ((Builder)object3).getEncodedFragment$okhttp();
        ((Builder)object3).setEncodedFragment$okhttp(string7 == null ? null : okhttp3.HttpUrl$Companion.canonicalize$okhttp$default$72d20940(Companion, string7, 0, 0, " \"#<>\\^`{|}", true, true, false, true, null, 163));
        String uri = ((Builder)object2).toString();
        try {
            object2 = new URI(uri);
        }
        catch (URISyntaxException e) {
            try {
                object = (CharSequence)object;
                regex = new Regex("[\\u0000-\\u001F\\u007F-\\u009F\\p{javaWhitespace}]");
                String string8 = "";
                object = regex.replace((CharSequence)object, string8);
                object = URI.create((String)object);
            }
            catch (Exception exception) {
                void var2_3;
                throw new RuntimeException((Throwable)var2_3);
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n      // Unlikely edge\u2026Unexpected!\n      }\n    }");
            object2 = object;
        }
        return object2;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="encodedUsername")
    public final String encodedUsername() {
        void var2_2;
        void var1_1;
        if (((CharSequence)this.username).length() == 0) {
            return "";
        }
        int usernameStart = this.scheme.length() + 3;
        int usernameEnd = Util.delimiterOffset(this.url, ":@", usernameStart, this.url.length());
        String string = this.url.substring((int)var1_1, (int)var2_2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="encodedPassword")
    public final String encodedPassword() {
        void var2_2;
        void var1_1;
        if (((CharSequence)this.password).length() == 0) {
            return "";
        }
        int passwordStart = StringsKt.indexOf$default((CharSequence)this.url, (char)':', (int)(this.scheme.length() + 3), (boolean)false, (int)4, null) + 1;
        int passwordEnd = StringsKt.indexOf$default((CharSequence)this.url, (char)'@', (int)0, (boolean)false, (int)6, null);
        String string = this.url.substring((int)var1_1, (int)var2_2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="encodedPath")
    public final String encodedPath() {
        void var2_2;
        void var1_1;
        int pathStart = StringsKt.indexOf$default((CharSequence)this.url, (char)'/', (int)(this.scheme.length() + 3), (boolean)false, (int)4, null);
        int pathEnd = Util.delimiterOffset(this.url, "?#", pathStart, this.url.length());
        String string = this.url.substring((int)var1_1, (int)var2_2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="encodedPathSegments")
    public final List<String> encodedPathSegments() {
        void var3_3;
        int i;
        int pathStart = StringsKt.indexOf$default((CharSequence)this.url, (char)'/', (int)(this.scheme.length() + 3), (boolean)false, (int)4, null);
        int pathEnd = Util.delimiterOffset(this.url, "?#", pathStart, this.url.length());
        List result = new ArrayList();
        while (i < pathEnd) {
            void var4_4 = i;
            i = var4_4 + true;
            int segmentEnd = Util.delimiterOffset(this.url, '/', i, pathEnd);
            String string = this.url.substring(i, segmentEnd);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            result.add(string);
            i = segmentEnd;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="encodedQuery")
    public final String encodedQuery() {
        void var2_2;
        void var1_1;
        if (this.queryNamesAndValues == null) {
            return null;
        }
        int queryStart = StringsKt.indexOf$default((CharSequence)this.url, (char)'?', (int)0, (boolean)false, (int)6, null) + 1;
        int queryEnd = Util.delimiterOffset(this.url, '#', queryStart, this.url.length());
        String string = this.url.substring((int)var1_1, (int)var2_2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="query")
    public final String query() {
        void var1_1;
        if (this.queryNamesAndValues == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        okhttp3.HttpUrl$Companion.toQueryString$okhttp(this.queryNamesAndValues, result);
        return var1_1.toString();
    }

    public final String redact() {
        Builder builder = this.newBuilder("/...");
        Intrinsics.checkNotNull((Object)builder);
        String string = "";
        Builder builder2 = builder;
        Intrinsics.checkNotNullParameter((Object)string, (String)"username");
        Builder builder3 = builder2;
        builder2.setEncodedUsername$okhttp(okhttp3.HttpUrl$Companion.canonicalize$okhttp$default$72d20940(Companion, string, 0, 0, " \"':;<=>@[]^`{}|/\\?#", false, false, false, false, null, 251));
        string = "";
        Intrinsics.checkNotNullParameter((Object)string, (String)"password");
        builder3 = builder2;
        builder2.setEncodedPassword$okhttp(okhttp3.HttpUrl$Companion.canonicalize$okhttp$default$72d20940(Companion, string, 0, 0, " \"':;<=>@[]^`{}|/\\?#", false, false, false, false, null, 251));
        return builder2.build().toString();
    }

    /*
     * WARNING - void declaration
     */
    public final HttpUrl resolve(String link) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Builder builder = this.newBuilder((String)var1_1);
        if (builder == null) {
            return null;
        }
        return builder.build();
    }

    public final Builder newBuilder(String link) {
        Builder builder;
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        try {
            builder = new Builder().parse$okhttp(this, (String)((Object)builder));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            builder = null;
        }
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        return other instanceof HttpUrl && Intrinsics.areEqual((Object)((HttpUrl)var1_1).url, (Object)this.url);
    }

    public final int hashCode() {
        return this.url.hashCode();
    }

    public final String toString() {
        return this.url;
    }

    @JvmStatic
    @JvmName(name="get")
    public static final HttpUrl get(String $this$get) {
        return okhttp3.HttpUrl$Companion.get($this$get);
    }

    static {
        char[] cArray = new char[16];
        char[] cArray2 = cArray;
        cArray[0] = 48;
        cArray2[1] = 49;
        cArray2[2] = 50;
        cArray2[3] = 51;
        cArray2[4] = 52;
        cArray2[5] = 53;
        cArray2[6] = 54;
        cArray2[7] = 55;
        cArray2[8] = 56;
        cArray2[9] = 57;
        cArray2[10] = 65;
        cArray2[11] = 66;
        cArray2[12] = 67;
        cArray2[13] = 68;
        cArray2[14] = 69;
        cArray2[15] = 70;
        HEX_DIGITS = cArray2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0017\u0018\u0000 V2\u00020\u0001:\u0001VB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u0004J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0004J\u0018\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u00042\b\u0010(\u001a\u0004\u0018\u00010\u0004J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0004J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0004J\u0018\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020.H\u0002J\u0018\u0010/\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u00042\b\u00101\u001a\u0004\u0018\u00010\u0004J\u0006\u00102\u001a\u000203J\b\u00104\u001a\u00020\u001bH\u0002J\u0010\u0010\u0003\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0004J\u000e\u00105\u001a\u00020\u00002\u0006\u00105\u001a\u00020\u0004J\u0010\u00106\u001a\u00020\u00002\b\u00106\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0004J\u0010\u00107\u001a\u00020\u00002\b\u00107\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0004J\u0010\u00108\u001a\u00020.2\u0006\u00109\u001a\u00020\u0004H\u0002J\u0010\u0010:\u001a\u00020.2\u0006\u00109\u001a\u00020\u0004H\u0002J\u001f\u0010;\u001a\u00020\u00002\b\u0010<\u001a\u0004\u0018\u0001032\u0006\u00109\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b=J\u000e\u0010>\u001a\u00020\u00002\u0006\u0010>\u001a\u00020\u0004J\b\u0010?\u001a\u00020@H\u0002J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bJ0\u0010A\u001a\u00020@2\u0006\u00109\u001a\u00020\u00042\u0006\u0010B\u001a\u00020\u001b2\u0006\u0010C\u001a\u00020\u001b2\u0006\u0010D\u001a\u00020.2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010E\u001a\u00020\u00002\b\u0010E\u001a\u0004\u0018\u00010\u0004J\r\u0010F\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\bGJ\u0010\u0010H\u001a\u00020@2\u0006\u0010I\u001a\u00020\u0004H\u0002J\u000e\u0010J\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0004J\u000e\u0010K\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u0004J\u000e\u0010L\u001a\u00020\u00002\u0006\u0010M\u001a\u00020\u001bJ \u0010N\u001a\u00020@2\u0006\u00109\u001a\u00020\u00042\u0006\u0010O\u001a\u00020\u001b2\u0006\u0010C\u001a\u00020\u001bH\u0002J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0004J\u0016\u0010P\u001a\u00020\u00002\u0006\u0010M\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u0004J\u0018\u0010Q\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u00042\b\u0010(\u001a\u0004\u0018\u00010\u0004J\u0016\u0010R\u001a\u00020\u00002\u0006\u0010M\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\u0004J\u0018\u0010S\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u00042\b\u00101\u001a\u0004\u0018\u00010\u0004J\b\u0010T\u001a\u00020\u0004H\u0016J\u000e\u0010U\u001a\u00020\u00002\u0006\u0010U\u001a\u00020\u0004R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR$\u0010\u0010\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000f\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0006\"\u0004\b\u0016\u0010\bR\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0006\"\u0004\b\u0019\u0010\bR\u001a\u0010\u001a\u001a\u00020\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0006\"\u0004\b\"\u0010\b\u00a8\u0006W"}, d2={"Lokhttp3/HttpUrl$Builder;", "", "()V", "encodedFragment", "", "getEncodedFragment$okhttp", "()Ljava/lang/String;", "setEncodedFragment$okhttp", "(Ljava/lang/String;)V", "encodedPassword", "getEncodedPassword$okhttp", "setEncodedPassword$okhttp", "encodedPathSegments", "", "getEncodedPathSegments$okhttp", "()Ljava/util/List;", "encodedQueryNamesAndValues", "getEncodedQueryNamesAndValues$okhttp", "setEncodedQueryNamesAndValues$okhttp", "(Ljava/util/List;)V", "encodedUsername", "getEncodedUsername$okhttp", "setEncodedUsername$okhttp", "host", "getHost$okhttp", "setHost$okhttp", "port", "", "getPort$okhttp", "()I", "setPort$okhttp", "(I)V", "scheme", "getScheme$okhttp", "setScheme$okhttp", "addEncodedPathSegment", "encodedPathSegment", "addEncodedPathSegments", "addEncodedQueryParameter", "encodedName", "encodedValue", "addPathSegment", "pathSegment", "addPathSegments", "pathSegments", "alreadyEncoded", "", "addQueryParameter", "name", "value", "build", "Lokhttp3/HttpUrl;", "effectivePort", "encodedPath", "encodedQuery", "fragment", "isDot", "input", "isDotDot", "parse", "base", "parse$okhttp", "password", "pop", "", "push", "pos", "limit", "addTrailingSlash", "query", "reencodeForUri", "reencodeForUri$okhttp", "removeAllCanonicalQueryParameters", "canonicalName", "removeAllEncodedQueryParameters", "removeAllQueryParameters", "removePathSegment", "index", "resolvePath", "startPos", "setEncodedPathSegment", "setEncodedQueryParameter", "setPathSegment", "setQueryParameter", "toString", "username", "Companion", "okhttp"})
    public static final class Builder {
        private static Companion Companion = new Companion(0);
        private String scheme;
        private String encodedUsername = "";
        private String encodedPassword = "";
        private String host;
        private int port = -1;
        private final List<String> encodedPathSegments = new ArrayList();
        private List<String> encodedQueryNamesAndValues;
        private String encodedFragment;

        public Builder() {
            this.encodedPathSegments.add("");
        }

        /*
         * WARNING - void declaration
         */
        public final void setScheme$okhttp(String string) {
            void var1_1;
            this.scheme = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final void setEncodedUsername$okhttp(String string) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.encodedUsername = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final void setEncodedPassword$okhttp(String string) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.encodedPassword = var1_1;
        }

        public final String getHost$okhttp() {
            return this.host;
        }

        /*
         * WARNING - void declaration
         */
        public final void setHost$okhttp(String string) {
            void var1_1;
            this.host = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final void setPort$okhttp(int n) {
            void var1_1;
            this.port = var1_1;
        }

        public final List<String> getEncodedPathSegments$okhttp() {
            return this.encodedPathSegments;
        }

        public final List<String> getEncodedQueryNamesAndValues$okhttp() {
            return this.encodedQueryNamesAndValues;
        }

        public final String getEncodedFragment$okhttp() {
            return this.encodedFragment;
        }

        /*
         * WARNING - void declaration
         */
        public final void setEncodedFragment$okhttp(String string) {
            void var1_1;
            this.encodedFragment = var1_1;
        }

        private final int effectivePort() {
            if (this.port != -1) {
                return this.port;
            }
            String string = this.scheme;
            Intrinsics.checkNotNull((Object)string);
            return okhttp3.HttpUrl$Companion.defaultPort(string);
        }

        public final Builder encodedQuery(String encodedQuery) {
            Object object;
            Builder builder;
            Builder builder2 = builder = this;
            builder2 = object == null ? null : ((object = okhttp3.HttpUrl$Companion.canonicalize$okhttp$default$72d20940(Companion, (String)object, 0, 0, " \"'<>#", true, false, true, false, null, 211)) == null ? null : okhttp3.HttpUrl$Companion.toQueryNamesAndValues$okhttp((String)object));
            object = builder;
            builder.encodedQueryNamesAndValues = builder2;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder addQueryParameter(String name, String value) {
            void var2_2;
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Builder $this$addQueryParameter_u24lambda_u2d20 = builder = this;
            Builder builder2 = builder;
            if (builder.encodedQueryNamesAndValues == null) {
                List list = new ArrayList();
                builder2 = $this$addQueryParameter_u24lambda_u2d20;
                $this$addQueryParameter_u24lambda_u2d20.encodedQueryNamesAndValues = list;
            }
            builder2 = $this$addQueryParameter_u24lambda_u2d20;
            List<String> list = builder2.encodedQueryNamesAndValues;
            Intrinsics.checkNotNull(list);
            list.add(okhttp3.HttpUrl$Companion.canonicalize$okhttp$default$72d20940(Companion, (String)var1_1, 0, 0, " !\"#$&'(),/:;<=>?@[]\\^`{|}~", false, false, true, false, null, 219));
            builder2 = $this$addQueryParameter_u24lambda_u2d20;
            List<String> list2 = builder2.encodedQueryNamesAndValues;
            Intrinsics.checkNotNull(list2);
            void v2 = var2_2;
            list2.add(v2 == null ? null : okhttp3.HttpUrl$Companion.canonicalize$okhttp$default$72d20940(Companion, (String)v2, 0, 0, " !\"#$&'(),/:;<=>?@[]\\^`{|}~", false, false, true, false, null, 219));
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder addEncodedQueryParameter(String encodedName, String encodedValue) {
            void var2_2;
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)encodedName, (String)"encodedName");
            Builder $this$addEncodedQueryParameter_u24lambda_u2d21 = builder = this;
            Builder builder2 = builder;
            if (builder.encodedQueryNamesAndValues == null) {
                List list = new ArrayList();
                builder2 = $this$addEncodedQueryParameter_u24lambda_u2d21;
                $this$addEncodedQueryParameter_u24lambda_u2d21.encodedQueryNamesAndValues = list;
            }
            builder2 = $this$addEncodedQueryParameter_u24lambda_u2d21;
            List<String> list = builder2.encodedQueryNamesAndValues;
            Intrinsics.checkNotNull(list);
            list.add(okhttp3.HttpUrl$Companion.canonicalize$okhttp$default$72d20940(Companion, (String)var1_1, 0, 0, " \"'<>#&=", true, false, true, false, null, 211));
            builder2 = $this$addEncodedQueryParameter_u24lambda_u2d21;
            List<String> list2 = builder2.encodedQueryNamesAndValues;
            Intrinsics.checkNotNull(list2);
            void v2 = var2_2;
            list2.add(v2 == null ? null : okhttp3.HttpUrl$Companion.canonicalize$okhttp$default$72d20940(Companion, (String)v2, 0, 0, " \"'<>#&=", true, false, true, false, null, 211));
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final HttpUrl build() {
            Object object;
            Object object2;
            Collection<String> collection;
            Object object3;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            String string = this.scheme;
            if (string == null) {
                throw new IllegalStateException("scheme == null");
            }
            String string2 = this.host;
            if (string2 == null) {
                throw new IllegalStateException("host == null");
            }
            Object object4 = this.encodedPathSegments;
            int n = this.effectivePort();
            String string3 = string2;
            String string4 = okhttp3.HttpUrl$Companion.percentDecode$okhttp$default$4e9e714e(Companion, this.encodedPassword, 0, 0, false, 7);
            String string5 = okhttp3.HttpUrl$Companion.percentDecode$okhttp$default$4e9e714e(Companion, this.encodedUsername, 0, 0, false, 7);
            String string6 = string;
            Object object5 = $this$map$iv;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object3 = (String)object5;
                collection = destination$iv$iv;
                collection.add(okhttp3.HttpUrl$Companion.percentDecode$okhttp$default$4e9e714e(Companion, (String)it, 0, 0, false, 7));
            }
            collection = (List)destination$iv$iv;
            String string7 = string6;
            String string8 = string5;
            String string9 = string4;
            String string10 = string3;
            int n2 = n;
            Collection<String> collection2 = collection;
            List<String> list = this.encodedQueryNamesAndValues;
            if (list == null) {
                object2 = null;
            } else {
                String $this$mapTo$iv$iv2;
                $this$map$iv = list;
                collection = collection2;
                n = n2;
                string3 = string10;
                string4 = string9;
                string5 = string8;
                string6 = string7;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                object5 = $this$mapTo$iv$iv2.iterator();
                while (object5.hasNext()) {
                    Object item$iv$iv = object5.next();
                    $this$mapTo$iv$iv2 = (String)item$iv$iv;
                    object3 = destination$iv$iv2;
                    Object object6 = object;
                    object3.add(object6 == null ? null : okhttp3.HttpUrl$Companion.percentDecode$okhttp$default$4e9e714e(Companion, (String)object6, 0, 0, true, 3));
                }
                object3 = (List)object4;
                string7 = string6;
                string8 = string5;
                string9 = string4;
                string10 = string3;
                n2 = n;
                collection2 = collection;
                object2 = object3;
            }
            String string11 = this.encodedFragment;
            object4 = this.toString();
            object5 = string11 == null ? null : okhttp3.HttpUrl$Companion.percentDecode$okhttp$default$4e9e714e(Companion, string11, 0, 0, false, 7);
            object = object2;
            object3 = collection2;
            int n3 = n2;
            string5 = string10;
            string4 = string9;
            string3 = string8;
            String string12 = string7;
            return new HttpUrl(string12, string3, string4, string5, n3, (List<String>)object3, (List<String>)object, (String)object5, (String)object4);
        }

        /*
         * WARNING - void declaration
         */
        public final String toString() {
            Builder builder;
            StringBuilder $this$toString_u24lambda_u2d31;
            StringBuilder stringBuilder;
            block17: {
                void var3_5;
                block18: {
                    block16: {
                        block15: {
                            block14: {
                                $this$toString_u24lambda_u2d31 = stringBuilder = new StringBuilder();
                                builder = this;
                                if (builder.scheme != null) {
                                    builder = this;
                                    $this$toString_u24lambda_u2d31.append(builder.scheme);
                                    $this$toString_u24lambda_u2d31.append("://");
                                } else {
                                    $this$toString_u24lambda_u2d31.append("//");
                                }
                                builder = this;
                                if (((CharSequence)builder.encodedUsername).length() > 0) break block14;
                                builder = this;
                                if (!(((CharSequence)builder.encodedPassword).length() > 0)) break block15;
                            }
                            builder = this;
                            $this$toString_u24lambda_u2d31.append(builder.encodedUsername);
                            builder = this;
                            if (((CharSequence)builder.encodedPassword).length() > 0) {
                                $this$toString_u24lambda_u2d31.append(':');
                                builder = this;
                                $this$toString_u24lambda_u2d31.append(builder.encodedPassword);
                            }
                            $this$toString_u24lambda_u2d31.append('@');
                        }
                        builder = this;
                        if (builder.host != null) {
                            builder = this;
                            String string = builder.host;
                            Intrinsics.checkNotNull((Object)string);
                            if (StringsKt.contains$default((CharSequence)string, (char)':', (boolean)false, (int)2, null)) {
                                $this$toString_u24lambda_u2d31.append('[');
                                builder = this;
                                $this$toString_u24lambda_u2d31.append(builder.host);
                                $this$toString_u24lambda_u2d31.append(']');
                            } else {
                                builder = this;
                                $this$toString_u24lambda_u2d31.append(builder.host);
                            }
                        }
                        Builder builder2 = this;
                        if (builder2.port != -1) break block16;
                        builder = this;
                        if (builder.scheme == null) break block17;
                    }
                    int effectivePort = this.effectivePort();
                    builder = this;
                    if (builder.scheme == null) break block18;
                    builder = this;
                    String string = builder.scheme;
                    Intrinsics.checkNotNull((Object)string);
                    if (effectivePort == okhttp3.HttpUrl$Companion.defaultPort(string)) break block17;
                }
                $this$toString_u24lambda_u2d31.append(':');
                $this$toString_u24lambda_u2d31.append((int)var3_5);
            }
            builder = this;
            okhttp3.HttpUrl$Companion.toPathString$okhttp(builder.encodedPathSegments, $this$toString_u24lambda_u2d31);
            builder = this;
            if (builder.encodedQueryNamesAndValues != null) {
                $this$toString_u24lambda_u2d31.append('?');
                builder = this;
                List<String> list = builder.encodedQueryNamesAndValues;
                Intrinsics.checkNotNull(list);
                okhttp3.HttpUrl$Companion.toQueryString$okhttp(list, $this$toString_u24lambda_u2d31);
            }
            builder = this;
            if (builder.encodedFragment != null) {
                void var2_2;
                $this$toString_u24lambda_u2d31.append('#');
                builder = this;
                var2_2.append(builder.encodedFragment);
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        public final Builder parse$okhttp(HttpUrl base, String input) {
            void var1_5;
            int n;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            int pos = Util.indexOfFirstNonAsciiWhitespace$default$4abc9f13(input, 0, 0, 3);
            int limit = Util.indexOfLastNonAsciiWhitespace$default$4abc9f13(input, pos, 0, 2);
            int schemeDelimiterOffset = Companion.access$schemeDelimiterOffset(Companion, input, pos, limit);
            if (schemeDelimiterOffset != -1) {
                if (StringsKt.startsWith((String)input, (String)"https:", (int)pos, (boolean)true)) {
                    this.scheme = "https";
                    pos += 6;
                } else {
                    if (!StringsKt.startsWith((String)input, (String)"http:", (int)pos, (boolean)true)) {
                        StringBuilder stringBuilder = new StringBuilder("Expected URL scheme 'http' or 'https' but was '");
                        String string = input;
                        String string2 = string.substring(0, schemeDelimiterOffset);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        throw new IllegalArgumentException(stringBuilder.append(string2).append('\'').toString());
                    }
                    this.scheme = "http";
                    pos += 5;
                }
            } else if (base != null) {
                this.scheme = base.scheme();
            } else {
                String truncated = input.length() > 6 ? Intrinsics.stringPlus((String)StringsKt.take((String)input, (int)6), (Object)"...") : input;
                throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Expected URL scheme 'http' or 'https' but no scheme was found for ", (Object)truncated));
            }
            boolean hasUsername = false;
            boolean hasPassword = false;
            int slashCount = Companion.access$slashCount(Companion, input, pos, limit);
            if (slashCount < 2 && base != null && Intrinsics.areEqual((Object)base.scheme(), (Object)this.scheme)) {
                void componentDelimiterOffset2;
                this.encodedUsername = componentDelimiterOffset2.encodedUsername();
                this.encodedPassword = componentDelimiterOffset2.encodedPassword();
                this.host = componentDelimiterOffset2.host();
                this.port = componentDelimiterOffset2.port();
                this.encodedPathSegments.clear();
                this.encodedPathSegments.addAll((Collection<String>)componentDelimiterOffset2.encodedPathSegments());
                if (n == limit || input.charAt(n) == '#') {
                    this.encodedQuery(componentDelimiterOffset2.encodedQuery());
                }
            } else {
                pos += slashCount;
                block4: while (true) {
                    int componentDelimiterOffset2;
                    slashCount = (componentDelimiterOffset2 = Util.delimiterOffset(input, "@/\\?#", pos, limit)) != limit ? (int)input.charAt(componentDelimiterOffset2) : -1;
                    switch (slashCount) {
                        case 64: {
                            if (!hasPassword) {
                                void var3_8;
                                int passwordColonOffset = Util.delimiterOffset(input, ':', pos, componentDelimiterOffset2);
                                String canonicalUsername = okhttp3.HttpUrl$Companion.canonicalize$okhttp$default$72d20940(Companion, input, pos, passwordColonOffset, " \"':;<=>@[]^`{}|/\\?#", true, false, false, false, null, 240);
                                Object object = this.encodedUsername = hasUsername ? this.encodedUsername + "%40" + canonicalUsername : var3_8;
                                if (passwordColonOffset != componentDelimiterOffset2) {
                                    hasPassword = true;
                                    this.encodedPassword = okhttp3.HttpUrl$Companion.canonicalize$okhttp$default$72d20940(Companion, input, passwordColonOffset + 1, componentDelimiterOffset2, " \"':;<=>@[]^`{}|/\\?#", true, false, false, false, null, 240);
                                }
                                hasUsername = true;
                            } else {
                                this.encodedPassword = this.encodedPassword + "%40" + okhttp3.HttpUrl$Companion.canonicalize$okhttp$default$72d20940(Companion, input, n, componentDelimiterOffset2, " \"':;<=>@[]^`{}|/\\?#", true, false, false, false, null, 240);
                            }
                            n = componentDelimiterOffset2 + 1;
                            continue block4;
                        }
                        case -1: 
                        case 35: 
                        case 47: 
                        case 63: 
                        case 92: {
                            int portColonOffset = Companion.access$portColonOffset(Companion, input, n, componentDelimiterOffset2);
                            if (portColonOffset + 1 < componentDelimiterOffset2) {
                                this.host = HostnamesKt.toCanonicalHost(okhttp3.HttpUrl$Companion.percentDecode$okhttp$default$4e9e714e(Companion, input, n, portColonOffset, false, 4));
                                this.port = Companion.access$parsePort(Companion, input, portColonOffset + 1, componentDelimiterOffset2);
                                if (!(this.port != -1)) {
                                    StringBuilder stringBuilder = new StringBuilder("Invalid URL port: \"");
                                    n = portColonOffset + 1;
                                    String string = input.substring(n, componentDelimiterOffset2);
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                                    String componentDelimiterOffset2 = stringBuilder.append(string).append('\"').toString();
                                    throw new IllegalArgumentException(componentDelimiterOffset2.toString());
                                }
                            } else {
                                this.host = HostnamesKt.toCanonicalHost(okhttp3.HttpUrl$Companion.percentDecode$okhttp$default$4e9e714e(Companion, input, n, portColonOffset, false, 4));
                                String string = this.scheme;
                                Intrinsics.checkNotNull((Object)string);
                                this.port = okhttp3.HttpUrl$Companion.defaultPort(string);
                            }
                            if (!(this.host != null)) {
                                StringBuilder stringBuilder = new StringBuilder("Invalid URL host: \"");
                                String string = input.substring(n, portColonOffset);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                                String componentDelimiterOffset2 = stringBuilder.append(string).append('\"').toString();
                                throw new IllegalArgumentException(componentDelimiterOffset2.toString());
                            }
                            n = componentDelimiterOffset2;
                            break block4;
                        }
                        default: {
                            continue block4;
                        }
                    }
                    break;
                }
            }
            int pathDelimiterOffset = Util.delimiterOffset(input, "?#", n, limit);
            this.resolvePath(input, n, pathDelimiterOffset);
            n = var1_5;
            if (n < limit && input.charAt(n) == '?') {
                int queryDelimiterOffset = Util.delimiterOffset(input, '#', n, limit);
                this.encodedQueryNamesAndValues = okhttp3.HttpUrl$Companion.toQueryNamesAndValues$okhttp(okhttp3.HttpUrl$Companion.canonicalize$okhttp$default$72d20940(Companion, input, n + 1, queryDelimiterOffset, " \"'<>#", true, false, true, false, null, 208));
                n = queryDelimiterOffset;
            }
            if (n < limit && input.charAt(n) == '#') {
                void var2_6;
                this.encodedFragment = okhttp3.HttpUrl$Companion.canonicalize$okhttp$default$72d20940(Companion, (String)var2_6, n + 1, limit, "", true, false, false, true, null, 176);
            }
            return this;
        }

        private final void resolvePath(String input, int startPos, int limit) {
            int i22;
            int pos = startPos;
            if (pos == limit) {
                return;
            }
            char c = input.charAt(pos);
            if (c == '/' || c == '\\') {
                this.encodedPathSegments.clear();
                this.encodedPathSegments.add("");
                ++pos;
            } else {
                this.encodedPathSegments.set(this.encodedPathSegments.size() - 1, "");
            }
            while (i22 < limit) {
                int pathSegmentDelimiterOffset = Util.delimiterOffset(input, "/\\", i22, limit);
                boolean segmentHasTrailingSlash = pathSegmentDelimiterOffset < limit;
                void v0 = i22;
                i22 = 1;
                boolean bl = segmentHasTrailingSlash;
                int n = pathSegmentDelimiterOffset;
                void var7_9 = v0;
                String string = input;
                Object i22 = this;
                string = okhttp3.HttpUrl$Companion.canonicalize$okhttp$default$72d20940(Companion, string, (int)var7_9, n, " \"<>^`{}|/\\?#", true, false, false, false, null, 240);
                Object object = string;
                if (!(Intrinsics.areEqual((Object)string, (Object)".") || StringsKt.equals((String)object, (String)"%2e", (boolean)true))) {
                    object = string;
                    if (Intrinsics.areEqual((Object)object, (Object)"..") || StringsKt.equals((String)object, (String)"%2e.", (boolean)true) || StringsKt.equals((String)object, (String)".%2e", (boolean)true) || StringsKt.equals((String)object, (String)"%2e%2e", (boolean)true)) {
                        object = i22;
                        i22 = ((Builder)object).encodedPathSegments.remove(((Builder)object).encodedPathSegments.size() - 1);
                        if (((CharSequence)i22).length() == 0 && !((Collection)((Builder)object).encodedPathSegments).isEmpty()) {
                            ((Builder)object).encodedPathSegments.set(((Builder)object).encodedPathSegments.size() - 1, "");
                        } else {
                            ((Builder)object).encodedPathSegments.add("");
                        }
                    } else {
                        if (((CharSequence)((Builder)i22).encodedPathSegments.get(((Builder)i22).encodedPathSegments.size() - 1)).length() == 0) {
                            ((Builder)i22).encodedPathSegments.set(((Builder)i22).encodedPathSegments.size() - 1, string);
                        } else {
                            ((Builder)i22).encodedPathSegments.add(string);
                        }
                        if (bl) {
                            ((Builder)i22).encodedPathSegments.add("");
                        }
                    }
                }
                i22 = pathSegmentDelimiterOffset;
                if (!segmentHasTrailingSlash) continue;
                ++i22;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002J \u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002J \u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u001c\u0010\f\u001a\u00020\u0006*\u00020\u00042\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lokhttp3/HttpUrl$Builder$Companion;", "", "()V", "INVALID_HOST", "", "parsePort", "", "input", "pos", "limit", "portColonOffset", "schemeDelimiterOffset", "slashCount", "okhttp"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            private static int parsePort(String input, int pos, int limit) {
                int n;
                try {
                    void var2_3;
                    void var1_2;
                    input = okhttp3.HttpUrl$Companion.canonicalize$okhttp$default$72d20940(HttpUrl.Companion, input, (int)var1_2, (int)var2_3, "", false, false, false, false, null, 248);
                    int i = Integer.parseInt(input);
                    n = (i > 0 ? i < 65536 : false) ? n : -1;
                }
                catch (NumberFormatException numberFormatException) {
                    n = -1;
                }
                return n;
            }

            /*
             * WARNING - void declaration
             */
            public static final /* synthetic */ int access$schemeDelimiterOffset(Companion $this, String input, int pos, int limit) {
                int n;
                block4: {
                    char c;
                    void var2_3;
                    void v0 = var2_3;
                    var2_3 = c;
                    void var1_2 = v0;
                    String string = input;
                    if (var2_3 - var1_2 >= 2) {
                        c = string.charAt((int)var1_2);
                        if (!(Intrinsics.compare((int)c, (int)97) >= 0 && Intrinsics.compare((int)c, (int)122) <= 0 || Intrinsics.compare((int)c, (int)65) >= 0 && Intrinsics.compare((int)c, (int)90) <= 0)) {
                            return -1;
                        }
                        ++var1_2;
                        while (var1_2 < var2_3) {
                            char c2;
                            if (((((('a' <= (c2 = string.charAt(c = var1_2++)) ? c2 < '{' : false) ? true : ('A' <= c2 ? c2 < '[' : false)) ? true : ('0' <= c2 ? c2 < ':' : false)) ? true : c2 == '+') ? true : c2 == '-') ? true : c2 == '.') continue;
                            if (c2 == ':') {
                                n = c;
                                break block4;
                            }
                            return -1;
                        }
                    }
                    n = -1;
                }
                return n;
            }

            /*
             * WARNING - void declaration
             */
            public static final /* synthetic */ int access$slashCount(Companion $this, String $receiver, int pos, int limit) {
                int n;
                void var2_3;
                void v0 = var2_3;
                var2_3 = n;
                void var1_2 = v0;
                String string = $receiver;
                n = 0;
                while (var1_2 < var2_3) {
                    char c = var1_2++;
                    if ((c = string.charAt(c)) != '\\' && c != '/') break;
                    ++n;
                }
                return n;
            }

            /*
             * WARNING - void declaration
             */
            public static final /* synthetic */ int access$portColonOffset(Companion $this, String input, int pos, int limit) {
                char c;
                void var2_3;
                void v0 = var2_3;
                var2_3 = c;
                void var1_2 = v0;
                String string = input;
                while (var1_2 < var2_3) {
                    c = string.charAt((int)var1_2);
                    if (c == '[') {
                        while (++var1_2 < var2_3 && string.charAt((int)var1_2) != ']') {
                        }
                    } else if (c == ':') {
                        return (int)var1_2;
                    }
                    c = var1_2;
                    var1_2 = c + true;
                }
                return (int)var2_3;
            }

            /*
             * WARNING - void declaration
             */
            public static final /* synthetic */ int access$parsePort(Companion $this, String input, int pos, int limit) {
                void var3_3;
                void var2_2;
                return okhttp3.HttpUrl$Builder$Companion.parsePort(input, (int)var2_2, (int)var3_3);
            }

            public /* synthetic */ Companion(byte by) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004H\u0007J\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007\u00a2\u0006\u0002\b\u0018J\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0007\u00a2\u0006\u0002\b\u0018J\u0015\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0004H\u0007\u00a2\u0006\u0002\b\u0018J\u0017\u0010\u001b\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0019\u001a\u00020\u0004H\u0007\u00a2\u0006\u0002\b\u001cJa\u0010\u001d\u001a\u00020\u0004*\u00020\u00042\b\b\u0002\u0010\u001e\u001a\u00020\u00122\b\b\u0002\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00042\b\b\u0002\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020\"2\b\b\u0002\u0010$\u001a\u00020\"2\b\b\u0002\u0010%\u001a\u00020\"2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'H\u0000\u00a2\u0006\u0002\b(J\u001c\u0010)\u001a\u00020\"*\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0012H\u0002J/\u0010*\u001a\u00020\u0004*\u00020\u00042\b\b\u0002\u0010\u001e\u001a\u00020\u00122\b\b\u0002\u0010\u001f\u001a\u00020\u00122\b\b\u0002\u0010$\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b+J\u0011\u0010,\u001a\u00020\u0015*\u00020\u0004H\u0007\u00a2\u0006\u0002\b\u0014J\u0013\u0010-\u001a\u0004\u0018\u00010\u0015*\u00020\u0017H\u0007\u00a2\u0006\u0002\b\u0014J\u0013\u0010-\u001a\u0004\u0018\u00010\u0015*\u00020\u001aH\u0007\u00a2\u0006\u0002\b\u0014J\u0013\u0010-\u001a\u0004\u0018\u00010\u0015*\u00020\u0004H\u0007\u00a2\u0006\u0002\b\u001bJ#\u0010.\u001a\u00020/*\b\u0012\u0004\u0012\u00020\u0004002\n\u00101\u001a\u000602j\u0002`3H\u0000\u00a2\u0006\u0002\b4J\u0019\u00105\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000406*\u00020\u0004H\u0000\u00a2\u0006\u0002\b7J%\u00108\u001a\u00020/*\n\u0012\u0006\u0012\u0004\u0018\u00010\u0004002\n\u00101\u001a\u000602j\u0002`3H\u0000\u00a2\u0006\u0002\b9JV\u0010:\u001a\u00020/*\u00020;2\u0006\u0010<\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\"2\b\u0010&\u001a\u0004\u0018\u00010'H\u0002J,\u0010=\u001a\u00020/*\u00020;2\u0006\u0010>\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\"H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lokhttp3/HttpUrl$Companion;", "", "()V", "FORM_ENCODE_SET", "", "FRAGMENT_ENCODE_SET", "FRAGMENT_ENCODE_SET_URI", "HEX_DIGITS", "", "PASSWORD_ENCODE_SET", "PATH_SEGMENT_ENCODE_SET", "PATH_SEGMENT_ENCODE_SET_URI", "QUERY_COMPONENT_ENCODE_SET", "QUERY_COMPONENT_ENCODE_SET_URI", "QUERY_COMPONENT_REENCODE_SET", "QUERY_ENCODE_SET", "USERNAME_ENCODE_SET", "defaultPort", "", "scheme", "get", "Lokhttp3/HttpUrl;", "uri", "Ljava/net/URI;", "-deprecated_get", "url", "Ljava/net/URL;", "parse", "-deprecated_parse", "canonicalize", "pos", "limit", "encodeSet", "alreadyEncoded", "", "strict", "plusIsSpace", "unicodeAllowed", "charset", "Ljava/nio/charset/Charset;", "canonicalize$okhttp", "isPercentEncoded", "percentDecode", "percentDecode$okhttp", "toHttpUrl", "toHttpUrlOrNull", "toPathString", "", "", "out", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "toPathString$okhttp", "toQueryNamesAndValues", "", "toQueryNamesAndValues$okhttp", "toQueryString", "toQueryString$okhttp", "writeCanonicalized", "Lokio/Buffer;", "input", "writePercentDecoded", "encoded", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public static int defaultPort(String scheme) {
            String string;
            Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
            if (Intrinsics.areEqual((Object)string, (Object)"http")) {
                return 80;
            }
            if (Intrinsics.areEqual((Object)string, (Object)"https")) {
                return 443;
            }
            return -1;
        }

        public static void toPathString$okhttp(List<String> $this$toPathString, StringBuilder out) {
            Intrinsics.checkNotNullParameter($this$toPathString, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            int n = 0;
            int n2 = $this$toPathString.size();
            while (n < n2) {
                int i = n++;
                out.append('/');
                out.append($this$toPathString.get(i));
            }
        }

        public static void toQueryString$okhttp(List<String> $this$toQueryString, StringBuilder out) {
            Intrinsics.checkNotNullParameter($this$toQueryString, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)$this$toQueryString.size())), (int)2);
            int n = intProgression.getFirst();
            int n2 = intProgression.getLast();
            int n3 = intProgression.getStep();
            if (n3 > 0 && n <= n2 || n3 < 0 && n2 <= n) {
                int i;
                do {
                    i = n;
                    n += n3;
                    String name = $this$toQueryString.get(i);
                    String value = $this$toQueryString.get(i + 1);
                    if (i > 0) {
                        out.append('&');
                    }
                    out.append(name);
                    if (value == null) continue;
                    out.append('=');
                    out.append(value);
                } while (i != n2);
            }
        }

        /*
         * WARNING - void declaration
         */
        public static List<String> toQueryNamesAndValues$okhttp(String $this$toQueryNamesAndValues) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)$this$toQueryNamesAndValues, (String)"<this>");
            List result = new ArrayList();
            int pos2 = 0;
            while (pos2 <= $this$toQueryNamesAndValues.length()) {
                void var3_4;
                int equalsOffset;
                int ampersandOffset = StringsKt.indexOf$default((CharSequence)$this$toQueryNamesAndValues, (char)'&', (int)pos2, (boolean)false, (int)4, null);
                if (ampersandOffset == -1) {
                    ampersandOffset = $this$toQueryNamesAndValues.length();
                }
                if ((equalsOffset = StringsKt.indexOf$default((CharSequence)$this$toQueryNamesAndValues, (char)'=', (int)pos2, (boolean)false, (int)4, null)) == -1 || equalsOffset > ampersandOffset) {
                    String string = $this$toQueryNamesAndValues.substring(pos2, ampersandOffset);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    result.add(string);
                    result.add(null);
                } else {
                    String string = $this$toQueryNamesAndValues.substring(pos2, equalsOffset);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    result.add(string);
                    String pos2 = $this$toQueryNamesAndValues;
                    int n = equalsOffset + 1;
                    String string2 = pos2.substring(n, ampersandOffset);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    result.add(string2);
                }
                pos2 = var3_4 + true;
            }
            return var1_1;
        }

        @JvmStatic
        @JvmName(name="get")
        public static HttpUrl get(String $this$toHttpUrl) {
            String string;
            Intrinsics.checkNotNullParameter((Object)$this$toHttpUrl, (String)"<this>");
            return new Builder().parse$okhttp(null, string).build();
        }

        /*
         * WARNING - void declaration
         */
        private String percentDecode$okhttp(String $this$percentDecode, int pos2, int limit, boolean plusIsSpace) {
            void var3_4;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)$this$percentDecode, (String)"<this>");
            int n = pos2;
            while (n < limit) {
                int i;
                char c;
                if ((c = $this$percentDecode.charAt(i = n++)) != '%' && (c != '+' || !plusIsSpace)) continue;
                Buffer out = new Buffer();
                out.writeUtf8($this$percentDecode, pos2, i);
                boolean bl = plusIsSpace;
                int n2 = limit;
                limit = i;
                String pos2 = $this$percentDecode;
                $this$percentDecode = out;
                int n3 = limit;
                while (n3 < n2) {
                    int n4;
                    limit = pos2.codePointAt(n3);
                    if (limit == 37 && n3 + 2 < n2) {
                        n4 = Util.parseHexDigit(pos2.charAt(n3 + 1));
                        int n5 = Util.parseHexDigit(pos2.charAt(n3 + 2));
                        if (n4 != -1 && n5 != -1) {
                            $this$percentDecode.writeByte((n4 << 4) + n5);
                            n3 += 2;
                            n3 += Character.charCount(limit);
                            continue;
                        }
                    } else if (limit == 43 && bl) {
                        $this$percentDecode.writeByte(32);
                        n4 = n3;
                        n3 = n4 + 1;
                        continue;
                    }
                    $this$percentDecode.writeUtf8CodePoint(limit);
                    n3 += Character.charCount(limit);
                }
                return out.readUtf8();
            }
            String string = var1_1.substring((int)var2_2, (int)var3_4);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return string;
        }

        public static /* synthetic */ String percentDecode$okhttp$default$4e9e714e(Companion companion, String string, int n, int n2, boolean bl, int n3) {
            if ((n3 & 1) != 0) {
                n = 0;
            }
            if ((n3 & 2) != 0) {
                n2 = string.length();
            }
            if ((n3 & 4) != 0) {
                bl = false;
            }
            return companion.percentDecode$okhttp(string, n, n2, bl);
        }

        /*
         * WARNING - void declaration
         */
        private static boolean isPercentEncoded(String $this$isPercentEncoded, int pos, int limit) {
            void var1_1;
            String string;
            void var2_2;
            return pos + 2 < var2_2 && $this$isPercentEncoded.charAt(pos) == '%' && Util.parseHexDigit($this$isPercentEncoded.charAt(pos + 1)) != -1 && Util.parseHexDigit(string.charAt((int)(var1_1 + 2))) != -1;
        }

        /*
         * WARNING - void declaration
         */
        private String canonicalize$okhttp(String $this$canonicalize, int pos2, int limit2, String encodeSet2, boolean alreadyEncoded, boolean strict2, boolean plusIsSpace, boolean unicodeAllowed, Charset charset3) {
            void var3_4;
            void var2_2;
            void var1_1;
            void var10_16;
            Intrinsics.checkNotNullParameter((Object)$this$canonicalize, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)encodeSet2, (String)"encodeSet");
            for (int i = pos2; i < limit2; i += Character.charCount((int)var10_16)) {
                int codePoint = ((String)$this$canonicalize).codePointAt(i);
                if (!(codePoint < 32 || codePoint == 127 || codePoint >= 128 && !unicodeAllowed || StringsKt.contains$default((CharSequence)encodeSet2, (char)((char)codePoint), (boolean)false, (int)2, null) || codePoint == 37 && (alreadyEncoded == 0 || strict2 && !okhttp3.HttpUrl$Companion.isPercentEncoded((String)$this$canonicalize, i, limit2))) && (codePoint != 43 || plusIsSpace == 0)) continue;
                Buffer out = new Buffer();
                out.writeUtf8((String)$this$canonicalize, pos2, i);
                int n = i;
                Charset charset2 = charset3;
                i = unicodeAllowed ? 1 : 0;
                int charset3 = plusIsSpace;
                unicodeAllowed = strict2;
                plusIsSpace = alreadyEncoded;
                String strict2 = encodeSet2;
                alreadyEncoded = limit2;
                int encodeSet2 = n;
                String limit2 = $this$canonicalize;
                Buffer pos2 = out;
                $this$canonicalize = this;
                $this$canonicalize = null;
                for (int j = encodeSet2; j < alreadyEncoded; j += Character.charCount(encodeSet2)) {
                    encodeSet2 = limit2.codePointAt(j);
                    if (plusIsSpace != 0 && (encodeSet2 == 9 || encodeSet2 == 10 || encodeSet2 == 12 || encodeSet2 == 13)) continue;
                    if (encodeSet2 == 43 && charset3 != 0) {
                        pos2.writeUtf8(plusIsSpace != 0 ? "+" : "%2B");
                        continue;
                    }
                    if (encodeSet2 < 32 || encodeSet2 == 127 || encodeSet2 >= 128 && i == 0 || StringsKt.contains$default((CharSequence)strict2, (char)((char)encodeSet2), (boolean)false, (int)2, null) || encodeSet2 == 37 && (plusIsSpace == 0 || unicodeAllowed && !okhttp3.HttpUrl$Companion.isPercentEncoded(limit2, j, alreadyEncoded))) {
                        if ($this$canonicalize == null) {
                            $this$canonicalize = new Buffer();
                        }
                        if (charset2 == null || Intrinsics.areEqual((Object)charset2, (Object)StandardCharsets.UTF_8)) {
                            $this$canonicalize.writeUtf8CodePoint(encodeSet2);
                        } else {
                            Buffer buffer;
                            int n2;
                            Charset charset4 = charset2;
                            int n3 = j + Character.charCount(encodeSet2);
                            Object object = limit2;
                            Object object2 = $this$canonicalize;
                            Intrinsics.checkNotNullParameter((Object)object, (String)"string");
                            Intrinsics.checkNotNullParameter((Object)charset4, (String)"charset");
                            if (!(n2 >= 0)) {
                                $this$canonicalize = "beginIndex < 0: " + n2;
                                throw new IllegalArgumentException($this$canonicalize.toString());
                            }
                            if (!(n3 >= n2)) {
                                $this$canonicalize = "endIndex < beginIndex: " + n3 + " < " + n2;
                                throw new IllegalArgumentException($this$canonicalize.toString());
                            }
                            if (!(n3 <= ((String)object).length())) {
                                $this$canonicalize = "endIndex > string.length: " + n3 + " > " + ((String)object).length();
                                throw new IllegalArgumentException($this$canonicalize.toString());
                            }
                            if (Intrinsics.areEqual((Object)charset4, (Object)Charsets.UTF_8)) {
                                buffer = object2.writeUtf8((String)object, n2, n3);
                            } else {
                                String string = ((String)object).substring(n2, n3);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                                byte[] byArray = string.getBytes(charset4);
                                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                                object = byArray;
                                buffer = object2.write((byte[])object, 0, ((Object)object).length);
                            }
                        }
                        while (!$this$canonicalize.exhausted()) {
                            int n4 = $this$canonicalize.readByte() & 0xFF;
                            pos2.writeByte(37);
                            pos2.writeByte((int)HEX_DIGITS[n4 >> 4 & 0xF]);
                            pos2.writeByte((int)HEX_DIGITS[n4 & 0xF]);
                        }
                        continue;
                    }
                    pos2.writeUtf8CodePoint(encodeSet2);
                }
                return out.readUtf8();
            }
            String string = var1_1.substring((int)var2_2, (int)var3_4);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return string;
        }

        public static /* synthetic */ String canonicalize$okhttp$default$72d20940(Companion companion, String string, int n, int n2, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, Charset charset, int n3) {
            if ((n3 & 1) != 0) {
                n = 0;
            }
            if ((n3 & 2) != 0) {
                n2 = string.length();
            }
            if ((n3 & 8) != 0) {
                bl = false;
            }
            if ((n3 & 0x10) != 0) {
                bl2 = false;
            }
            if ((n3 & 0x20) != 0) {
                bl3 = false;
            }
            if ((n3 & 0x40) != 0) {
                bl4 = false;
            }
            if ((n3 & 0x80) != 0) {
                charset = null;
            }
            return companion.canonicalize$okhttp(string, n, n2, string2, bl, bl2, bl3, bl4, charset);
        }

        public /* synthetic */ Companion(byte by) {
            this();
        }
    }
}

