/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 #2\u00020\u0001:\u0003\"#$B%\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\r\u0010\n\u001a\u00020\u000bH\u0007\u00a2\u0006\u0002\b\u0015J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0016J\u000e\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0012J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a2\u0006\u0002\b\u0018J\r\u0010\u0011\u001a\u00020\u0012H\u0007\u00a2\u0006\u0002\b\u0019J\r\u0010\u0004\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\b\u001aJ\u001a\u0010\u001b\u001a\u00020\u000e2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\n\u001a\u00020\u000b8G\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128G\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0013\u0010\u0004\u001a\u00020\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0014\u00a8\u0006%"}, d2={"Lokhttp3/MultipartBody;", "Lokhttp3/RequestBody;", "boundaryByteString", "Lokio/ByteString;", "type", "Lokhttp3/MediaType;", "parts", "", "Lokhttp3/MultipartBody$Part;", "(Lokio/ByteString;Lokhttp3/MediaType;Ljava/util/List;)V", "boundary", "", "()Ljava/lang/String;", "contentLength", "", "contentType", "()Ljava/util/List;", "size", "", "()I", "()Lokhttp3/MediaType;", "-deprecated_boundary", "part", "index", "-deprecated_parts", "-deprecated_size", "-deprecated_type", "writeOrCountBytes", "sink", "Lokio/BufferedSink;", "countBytes", "", "writeTo", "", "Builder", "Companion", "Part", "okhttp"})
public final class MultipartBody
extends RequestBody {
    private final ByteString boundaryByteString;
    private final MediaType type;
    private final List<Part> parts;
    private final MediaType contentType;
    private long contentLength;
    @JvmField
    public static final MediaType MIXED;
    @JvmField
    public static final MediaType FORM;
    private static final byte[] COLONSPACE;
    private static final byte[] CRLF;
    private static final byte[] DASHDASH;

    /*
     * WARNING - void declaration
     */
    public MultipartBody(ByteString boundaryByteString, MediaType type, List<Part> parts) {
        void var3_3;
        void var2_2;
        MultipartBody multipartBody;
        Intrinsics.checkNotNullParameter((Object)boundaryByteString, (String)"boundaryByteString");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(parts, (String)"parts");
        this.boundaryByteString = multipartBody;
        this.type = var2_2;
        this.parts = var3_3;
        multipartBody = this;
        this.contentType = MediaType.Companion.get(this.type + "; boundary=" + multipartBody.boundaryByteString.utf8());
        this.contentLength = -1L;
    }

    @Override
    public final MediaType contentType() {
        return this.contentType;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long contentLength() throws IOException {
        void var1_1;
        long result = this.contentLength;
        if (result == -1L) {
            this.contentLength = result = this.writeOrCountBytes(null, true);
        }
        return (long)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeTo(BufferedSink sink) throws IOException {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        this.writeOrCountBytes((BufferedSink)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    private final long writeOrCountBytes(BufferedSink sink, boolean countBytes) throws IOException {
        void var2_2;
        void var1_1;
        long byteCount = 0L;
        Buffer byteCountBuffer = null;
        if (countBytes) {
            byteCountBuffer = new Buffer();
            sink = (BufferedSink)byteCountBuffer;
        }
        int n = 0;
        int n2 = this.parts.size();
        while (n < n2) {
            long contentLength;
            MediaType contentType;
            int p = n++;
            Part part = this.parts.get(p);
            Headers headers = part.headers();
            RequestBody body = part.body();
            BufferedSink bufferedSink = sink;
            Intrinsics.checkNotNull((Object)bufferedSink);
            bufferedSink.write(DASHDASH);
            sink.write(this.boundaryByteString);
            sink.write(CRLF);
            if (headers != null) {
                int n3 = 0;
                int n4 = headers.size();
                while (n3 < n4) {
                    int h = n3++;
                    sink.writeUtf8(headers.name(h)).write(COLONSPACE).writeUtf8(headers.value(h)).write(CRLF);
                }
            }
            if ((contentType = body.contentType()) != null) {
                sink.writeUtf8("Content-Type: ").writeUtf8(contentType.toString()).write(CRLF);
            }
            if ((contentLength = body.contentLength()) != -1L) {
                sink.writeUtf8("Content-Length: ").writeDecimalLong(contentLength).write(CRLF);
            } else if (countBytes) {
                Buffer buffer = byteCountBuffer;
                Intrinsics.checkNotNull((Object)buffer);
                buffer.clear();
                return -1L;
            }
            sink.write(CRLF);
            if (countBytes) {
                byteCount += contentLength;
            } else {
                body.writeTo(sink);
            }
            sink.write(CRLF);
        }
        BufferedSink bufferedSink = sink;
        Intrinsics.checkNotNull((Object)bufferedSink);
        bufferedSink.write(DASHDASH);
        sink.write(this.boundaryByteString);
        sink.write(DASHDASH);
        var1_1.write(CRLF);
        if (var2_2 != false) {
            void var3_4;
            Buffer buffer = byteCountBuffer;
            Intrinsics.checkNotNull((Object)buffer);
            byteCount += buffer.size();
            var3_4.clear();
        }
        return byteCount;
    }

    static {
        new Companion(0);
        MIXED = MediaType.Companion.get("multipart/mixed");
        MediaType.Companion.get("multipart/alternative");
        MediaType.Companion.get("multipart/digest");
        MediaType.Companion.get("multipart/parallel");
        FORM = MediaType.Companion.get("multipart/form-data");
        byte[] byArray = new byte[2];
        byte[] byArray2 = byArray;
        byArray[0] = 58;
        byArray2[1] = 32;
        COLONSPACE = byArray2;
        byte[] byArray3 = new byte[2];
        byArray2 = byArray3;
        byArray3[0] = 13;
        byArray2[1] = 10;
        CRLF = byArray2;
        byte[] byArray4 = new byte[2];
        byArray2 = byArray4;
        byArray4[0] = 45;
        byArray2[1] = 45;
        DASHDASH = byArray2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0019\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u0004\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\b\tJ\u000f\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0007\u00a2\u0006\u0002\b\nR\u0013\u0010\u0004\u001a\u00020\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\b\u00a8\u0006\f"}, d2={"Lokhttp3/MultipartBody$Part;", "", "headers", "Lokhttp3/Headers;", "body", "Lokhttp3/RequestBody;", "(Lokhttp3/Headers;Lokhttp3/RequestBody;)V", "()Lokhttp3/RequestBody;", "()Lokhttp3/Headers;", "-deprecated_body", "-deprecated_headers", "Companion", "okhttp"})
    public static final class Part {
        public static final Companion Companion = new Companion(0);
        private final Headers headers;
        private final RequestBody body;

        /*
         * WARNING - void declaration
         */
        private Part(Headers headers, RequestBody body) {
            void var2_2;
            void var1_1;
            this.headers = var1_1;
            this.body = var2_2;
        }

        @JvmName(name="headers")
        public final Headers headers() {
            return this.headers;
        }

        @JvmName(name="body")
        public final RequestBody body() {
            return this.body;
        }

        /*
         * WARNING - void declaration
         */
        public /* synthetic */ Part(Headers headers, RequestBody body, byte by) {
            this((Headers)var1_1, (RequestBody)var2_2);
            void var2_2;
            void var1_1;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0007J\"\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\u000e"}, d2={"Lokhttp3/MultipartBody$Part$Companion;", "", "()V", "create", "Lokhttp3/MultipartBody$Part;", "headers", "Lokhttp3/Headers;", "body", "Lokhttp3/RequestBody;", "createFormData", "name", "", "value", "filename", "okhttp"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(byte by) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003J \u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u00002\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\bJ\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lokhttp3/MultipartBody$Builder;", "", "boundary", "", "(Ljava/lang/String;)V", "Lokio/ByteString;", "parts", "", "Lokhttp3/MultipartBody$Part;", "type", "Lokhttp3/MediaType;", "addFormDataPart", "name", "value", "filename", "body", "Lokhttp3/RequestBody;", "addPart", "headers", "Lokhttp3/Headers;", "part", "build", "Lokhttp3/MultipartBody;", "setType", "okhttp"})
    public static final class Builder {
        private final ByteString boundary;
        private MediaType type;
        private final List<Part> parts;

        /*
         * WARNING - void declaration
         */
        @JvmOverloads
        private Builder(String boundary) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)boundary, (String)"boundary");
            this.boundary = ByteString.Companion.encodeUtf8((String)var1_1);
            this.type = MIXED;
            this.parts = new ArrayList();
        }

        private /* synthetic */ Builder(String string, int n) {
            string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
            this(string);
        }

        /*
         * WARNING - void declaration
         */
        public final Builder setType(MediaType type) {
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Builder $this$setType_u24lambda_u2d1 = builder = this;
            if (!Intrinsics.areEqual((Object)((MediaType)type).type(), (Object)"multipart")) {
                type = Intrinsics.stringPlus((String)"multipart != ", (Object)type);
                throw new IllegalArgumentException(type.toString());
            }
            var3_3.type = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder addPart(Headers headers, RequestBody body) {
            String string;
            void var2_2;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Builder builder2 = builder = this;
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"body");
            void v0 = string;
            if (!((v0 == null ? null : v0.get("Content-Type")) == null)) {
                string = "Unexpected header: Content-Type";
                throw new IllegalArgumentException(string.toString());
            }
            void v1 = string;
            if (!((v1 == null ? null : v1.get("Content-Length")) == null)) {
                string = "Unexpected header: Content-Length";
                throw new IllegalArgumentException(string.toString());
            }
            builder.addPart(new Part((Headers)((Object)string), (RequestBody)var2_2, 0));
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder addPart(Part part) {
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)part, (String)"part");
            Builder builder2 = builder = this;
            ((Collection)builder.parts).add(var1_1);
            return builder;
        }

        public final MultipartBody build() {
            if (!(!((Collection)this.parts).isEmpty())) {
                String string = "Multipart body must have at least one part.";
                throw new IllegalStateException(string.toString());
            }
            return new MultipartBody(this.boundary, this.type, Util.toImmutableList(this.parts));
        }

        @JvmOverloads
        public Builder() {
            this(null, 1);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\r\u001a\u00020\u000e*\u00060\u000fj\u0002`\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lokhttp3/MultipartBody$Companion;", "", "()V", "ALTERNATIVE", "Lokhttp3/MediaType;", "COLONSPACE", "", "CRLF", "DASHDASH", "DIGEST", "FORM", "MIXED", "PARALLEL", "appendQuotedString", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "key", "", "appendQuotedString$okhttp", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(byte by) {
            this();
        }
    }
}

