/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.CacheControl;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okhttp3.internal.http.HttpMethod;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0001*BA\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0016\u0010\n\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\u0004\u0012\u00020\u00010\u000b\u00a2\u0006\u0002\u0010\rJ\u000f\u0010\b\u001a\u0004\u0018\u00010\tH\u0007\u00a2\u0006\u0002\b\u001bJ\r\u0010\u000f\u001a\u00020\u0010H\u0007\u00a2\u0006\u0002\b\u001cJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001e\u001a\u00020\u0005J\r\u0010\u0006\u001a\u00020\u0007H\u0007\u00a2\u0006\u0002\b\u001fJ\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050 2\u0006\u0010\u001e\u001a\u00020\u0005J\r\u0010\u0004\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\b!J\u0006\u0010\"\u001a\u00020#J\b\u0010$\u001a\u0004\u0018\u00010\u0001J#\u0010$\u001a\u0004\u0018\u0001H%\"\u0004\b\u0000\u0010%2\u000e\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u0002H%0\f\u00a2\u0006\u0002\u0010'J\b\u0010(\u001a\u00020\u0005H\u0016J\r\u0010\u0002\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b)R\u0015\u0010\b\u001a\u0004\u0018\u00010\t8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108G\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0013\u0010\u0006\u001a\u00020\u00078\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u00020\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0017R$\u0010\n\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\u0004\u0012\u00020\u00010\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u001a\u00a8\u0006+"}, d2={"Lokhttp3/Request;", "", "url", "Lokhttp3/HttpUrl;", "method", "", "headers", "Lokhttp3/Headers;", "body", "Lokhttp3/RequestBody;", "tags", "", "Ljava/lang/Class;", "(Lokhttp3/HttpUrl;Ljava/lang/String;Lokhttp3/Headers;Lokhttp3/RequestBody;Ljava/util/Map;)V", "()Lokhttp3/RequestBody;", "cacheControl", "Lokhttp3/CacheControl;", "()Lokhttp3/CacheControl;", "()Lokhttp3/Headers;", "isHttps", "", "()Z", "lazyCacheControl", "()Ljava/lang/String;", "getTags$okhttp", "()Ljava/util/Map;", "()Lokhttp3/HttpUrl;", "-deprecated_body", "-deprecated_cacheControl", "header", "name", "-deprecated_headers", "", "-deprecated_method", "newBuilder", "Lokhttp3/Request$Builder;", "tag", "T", "type", "(Ljava/lang/Class;)Ljava/lang/Object;", "toString", "-deprecated_url", "Builder", "okhttp"})
public final class Request {
    private final HttpUrl url;
    private final String method;
    private final Headers headers;
    private final RequestBody body;
    private final Map<Class<?>, Object> tags;
    private CacheControl lazyCacheControl;

    /*
     * WARNING - void declaration
     */
    public Request(HttpUrl url, String method, Headers headers, RequestBody body, Map<Class<?>, ? extends Object> tags) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        this.url = var1_1;
        this.method = var2_2;
        this.headers = var3_3;
        this.body = body;
        this.tags = tags;
    }

    @JvmName(name="url")
    public final HttpUrl url() {
        return this.url;
    }

    @JvmName(name="method")
    public final String method() {
        return this.method;
    }

    @JvmName(name="headers")
    public final Headers headers() {
        return this.headers;
    }

    @JvmName(name="body")
    public final RequestBody body() {
        return this.body;
    }

    public final Map<Class<?>, Object> getTags$okhttp() {
        return this.tags;
    }

    public final boolean isHttps() {
        return this.url.isHttps();
    }

    /*
     * WARNING - void declaration
     */
    public final String header(String name) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.headers.get((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final <T> T tag(Class<? extends T> type) {
        void var1_1;
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return type.cast(this.tags.get(var1_1));
    }

    public final Builder newBuilder() {
        return new Builder(this);
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="cacheControl")
    public final CacheControl cacheControl() {
        void var1_1;
        CacheControl result = this.lazyCacheControl;
        if (result == null) {
            this.lazyCacheControl = result = CacheControl.Companion.parse(this.headers);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var2_2;
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u2d1 = stringBuilder = new StringBuilder();
        stringBuilder.append("Request{method=");
        Object object = this;
        $this$toString_u24lambda_u2d1.append(((Request)object).method);
        $this$toString_u24lambda_u2d1.append(", url=");
        object = this;
        $this$toString_u24lambda_u2d1.append(((Request)object).url);
        object = this;
        if (((Request)object).headers.size() != 0) {
            $this$toString_u24lambda_u2d1.append(", headers=[");
            object = this;
            Iterable $this$forEachIndexed$iv = ((Request)object).headers;
            int index$iv = 0;
            object = object.iterator();
            while (object.hasNext()) {
                void $dstr$name$value;
                int n;
                Object item$iv = object.next();
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                item$iv = (Pair)item$iv;
                int index = n;
                String name = (String)$dstr$name$value.component1();
                String value = (String)$dstr$name$value.component2();
                if (index > 0) {
                    $this$toString_u24lambda_u2d1.append(", ");
                }
                $this$toString_u24lambda_u2d1.append(name);
                $this$toString_u24lambda_u2d1.append(':');
                $this$toString_u24lambda_u2d1.append(value);
            }
            $this$toString_u24lambda_u2d1.append(']');
        }
        object = this;
        if (!((Request)object).tags.isEmpty()) {
            $this$toString_u24lambda_u2d1.append(", tags=");
            object = this;
            $this$toString_u24lambda_u2d1.append(((Request)object).tags);
        }
        var2_2.append('}');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u0013H\u0016J\b\u0010(\u001a\u00020\u0004H\u0016J\u0010\u0010)\u001a\u00020\u00002\u0006\u0010)\u001a\u00020*H\u0016J\u0014\u0010+\u001a\u00020\u00002\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0017J\b\u0010,\u001a\u00020\u0000H\u0016J\b\u0010-\u001a\u00020\u0000H\u0016J\u0018\u0010.\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u0013H\u0016J\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020/H\u0016J\u001a\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u00100\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u00101\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u00102\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u00103\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0013H\u0016J-\u00104\u001a\u00020\u0000\"\u0004\b\u0000\u001052\u000e\u00106\u001a\n\u0012\u0006\b\u0000\u0012\u0002H50\u001a2\b\u00104\u001a\u0004\u0018\u0001H5H\u0016\u00a2\u0006\u0002\u00107J\u0012\u00104\u001a\u00020\u00002\b\u00104\u001a\u0004\u0018\u00010\u0001H\u0016J\u0010\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u000208H\u0016J\u0010\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0013H\u0016J\u0010\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020 H\u0016R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R*\u0010\u0018\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a\u0012\u0004\u0012\u00020\u00010\u0019X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u00069"}, d2={"Lokhttp3/Request$Builder;", "", "()V", "request", "Lokhttp3/Request;", "(Lokhttp3/Request;)V", "body", "Lokhttp3/RequestBody;", "getBody$okhttp", "()Lokhttp3/RequestBody;", "setBody$okhttp", "(Lokhttp3/RequestBody;)V", "headers", "Lokhttp3/Headers$Builder;", "getHeaders$okhttp", "()Lokhttp3/Headers$Builder;", "setHeaders$okhttp", "(Lokhttp3/Headers$Builder;)V", "method", "", "getMethod$okhttp", "()Ljava/lang/String;", "setMethod$okhttp", "(Ljava/lang/String;)V", "tags", "", "Ljava/lang/Class;", "getTags$okhttp", "()Ljava/util/Map;", "setTags$okhttp", "(Ljava/util/Map;)V", "url", "Lokhttp3/HttpUrl;", "getUrl$okhttp", "()Lokhttp3/HttpUrl;", "setUrl$okhttp", "(Lokhttp3/HttpUrl;)V", "addHeader", "name", "value", "build", "cacheControl", "Lokhttp3/CacheControl;", "delete", "get", "head", "header", "Lokhttp3/Headers;", "patch", "post", "put", "removeHeader", "tag", "T", "type", "(Ljava/lang/Class;Ljava/lang/Object;)Lokhttp3/Request$Builder;", "Ljava/net/URL;", "okhttp"})
    public static final class Builder {
        private HttpUrl url;
        private String method;
        private Headers.Builder headers;
        private RequestBody body;
        private Map<Class<?>, Object> tags;

        /*
         * WARNING - void declaration
         */
        private void setMethod$okhttp(String string) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.method = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private void setHeaders$okhttp(Headers.Builder builder) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)builder, (String)"<set-?>");
            this.headers = var1_1;
        }

        public Builder() {
            this.tags = new LinkedHashMap();
            this.method = "GET";
            this.headers = new Headers.Builder();
        }

        /*
         * WARNING - void declaration
         */
        public Builder(Request request) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            this.tags = new LinkedHashMap();
            this.url = request.url();
            this.method = request.method();
            this.body = request.body();
            this.tags = request.getTags$okhttp().isEmpty() ? (Map)new LinkedHashMap() : MapsKt.toMutableMap(request.getTags$okhttp());
            this.headers = var1_1.headers().newBuilder();
        }

        public final Builder url(HttpUrl url) {
            Builder builder;
            Builder builder2;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Builder builder3 = builder2 = this;
            builder3 = builder;
            builder = builder2;
            builder2.url = builder3;
            return builder2;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder header(String name, String value) {
            void var2_2;
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder builder2 = builder = this;
            builder2 = builder;
            builder.headers.set((String)var1_1, (String)var2_2);
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder removeHeader(String name) {
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Builder builder2 = builder = this;
            builder2 = builder;
            builder.headers.removeAll((String)var1_1);
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder headers(Headers headers) {
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            Builder builder2 = builder = this;
            builder.setHeaders$okhttp(var1_1.newBuilder());
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder method(String method, RequestBody body) {
            void var2_2;
            Builder builder;
            Builder builder2;
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Builder $this$method_u24lambda_u2d8 = builder2 = this;
            if (!(((CharSequence)method).length() > 0)) {
                method = "method.isEmpty() == true";
                throw new IllegalArgumentException(method.toString());
            }
            if (body == null) {
                if (!(!HttpMethod.requiresRequestBody(method))) {
                    method = "method " + method + " must have a request body.";
                    throw new IllegalArgumentException(method.toString());
                }
            } else if (!HttpMethod.permitsRequestBody(method)) {
                method = "method " + method + " must not have a request body.";
                throw new IllegalArgumentException(method.toString());
            }
            $this$method_u24lambda_u2d8.setMethod$okhttp((String)((Object)builder));
            builder = $this$method_u24lambda_u2d8;
            $this$method_u24lambda_u2d8.body = var2_2;
            return builder2;
        }

        /*
         * WARNING - void declaration
         */
        public final <T> Builder tag(Class<? super T> type, T tag) {
            Builder builder;
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Builder $this$tag_u24lambda_u2d9 = builder = this;
            if (tag == null) {
                Builder builder2 = $this$tag_u24lambda_u2d9;
                builder2.tags.remove(type);
            } else {
                void var1_1;
                T t;
                Builder builder3 = $this$tag_u24lambda_u2d9;
                if (builder3.tags.isEmpty()) {
                    Map map = new LinkedHashMap();
                    builder3 = $this$tag_u24lambda_u2d9;
                    Intrinsics.checkNotNullParameter((Object)map, (String)"<set-?>");
                    builder3.tags = map;
                }
                builder3 = $this$tag_u24lambda_u2d9;
                Map<Class<?>, Object> map = builder3.tags;
                T t2 = type.cast(t);
                Intrinsics.checkNotNull(t2);
                t = t2;
                map.put((Class<?>)var1_1, t);
            }
            return builder;
        }

        public final Request build() {
            HttpUrl httpUrl = this.url;
            if (httpUrl == null) {
                String string = "url == null";
                throw new IllegalStateException(string.toString());
            }
            Map<Class<?>, Object> map = Util.toImmutableMap(this.tags);
            RequestBody requestBody = this.body;
            Headers headers = this.headers.build();
            String string = this.method;
            HttpUrl httpUrl2 = httpUrl;
            return new Request(httpUrl2, string, headers, requestBody, map);
        }
    }
}

