/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.Closeable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.CacheControl;
import okhttp3.Challenge;
import okhttp3.Handshake;
import okhttp3.Headers;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.ResponseBody;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.http.HttpHeaders;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0001FB{\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0000\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0000\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0014\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0002\u0010\u0018J\u000f\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007\u00a2\u0006\u0002\b+J\r\u0010\u001a\u001a\u00020\u001bH\u0007\u00a2\u0006\u0002\b,J\u000f\u0010\u0011\u001a\u0004\u0018\u00010\u0000H\u0007\u00a2\u0006\u0002\b-J\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/J\b\u00101\u001a\u000202H\u0016J\r\u0010\b\u001a\u00020\tH\u0007\u00a2\u0006\u0002\b3J\u000f\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007\u00a2\u0006\u0002\b4J\u001e\u00105\u001a\u0004\u0018\u00010\u00072\u0006\u00106\u001a\u00020\u00072\n\b\u0002\u00107\u001a\u0004\u0018\u00010\u0007H\u0007J\r\u0010\f\u001a\u00020\rH\u0007\u00a2\u0006\u0002\b8J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070/2\u0006\u00106\u001a\u00020\u0007J\r\u0010\u0006\u001a\u00020\u0007H\u0007\u00a2\u0006\u0002\b9J\u000f\u0010\u0010\u001a\u0004\u0018\u00010\u0000H\u0007\u00a2\u0006\u0002\b:J\u0006\u0010;\u001a\u00020<J\u000e\u0010=\u001a\u00020\u000f2\u0006\u0010>\u001a\u00020\u0014J\u000f\u0010\u0012\u001a\u0004\u0018\u00010\u0000H\u0007\u00a2\u0006\u0002\b?J\r\u0010\u0004\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\b@J\r\u0010\u0015\u001a\u00020\u0014H\u0007\u00a2\u0006\u0002\bAJ\r\u0010\u0002\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\bBJ\r\u0010\u0013\u001a\u00020\u0014H\u0007\u00a2\u0006\u0002\bCJ\b\u0010D\u001a\u00020\u0007H\u0016J\u0006\u0010E\u001a\u00020\rR\u0015\u0010\u000e\u001a\u0004\u0018\u00010\u000f8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b8G\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001cR\u0015\u0010\u0011\u001a\u0004\u0018\u00010\u00008\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u001dR\u0013\u0010\b\u001a\u00020\t8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u001eR\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u00178\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u001fR\u0015\u0010\n\u001a\u0004\u0018\u00010\u000b8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010 R\u0013\u0010\f\u001a\u00020\r8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010!R\u0011\u0010\"\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010$R\u0011\u0010%\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010$R\u0010\u0010&\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00020\u00078\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010'R\u0015\u0010\u0010\u001a\u0004\u0018\u00010\u00008\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u001dR\u0015\u0010\u0012\u001a\u0004\u0018\u00010\u00008\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u001dR\u0013\u0010\u0004\u001a\u00020\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010(R\u0013\u0010\u0015\u001a\u00020\u00148\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010)R\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010*R\u0013\u0010\u0013\u001a\u00020\u00148\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010)\u00a8\u0006G"}, d2={"Lokhttp3/Response;", "Ljava/io/Closeable;", "request", "Lokhttp3/Request;", "protocol", "Lokhttp3/Protocol;", "message", "", "code", "", "handshake", "Lokhttp3/Handshake;", "headers", "Lokhttp3/Headers;", "body", "Lokhttp3/ResponseBody;", "networkResponse", "cacheResponse", "priorResponse", "sentRequestAtMillis", "", "receivedResponseAtMillis", "exchange", "Lokhttp3/internal/connection/Exchange;", "(Lokhttp3/Request;Lokhttp3/Protocol;Ljava/lang/String;ILokhttp3/Handshake;Lokhttp3/Headers;Lokhttp3/ResponseBody;Lokhttp3/Response;Lokhttp3/Response;Lokhttp3/Response;JJLokhttp3/internal/connection/Exchange;)V", "()Lokhttp3/ResponseBody;", "cacheControl", "Lokhttp3/CacheControl;", "()Lokhttp3/CacheControl;", "()Lokhttp3/Response;", "()I", "()Lokhttp3/internal/connection/Exchange;", "()Lokhttp3/Handshake;", "()Lokhttp3/Headers;", "isRedirect", "", "()Z", "isSuccessful", "lazyCacheControl", "()Ljava/lang/String;", "()Lokhttp3/Protocol;", "()J", "()Lokhttp3/Request;", "-deprecated_body", "-deprecated_cacheControl", "-deprecated_cacheResponse", "challenges", "", "Lokhttp3/Challenge;", "close", "", "-deprecated_code", "-deprecated_handshake", "header", "name", "defaultValue", "-deprecated_headers", "-deprecated_message", "-deprecated_networkResponse", "newBuilder", "Lokhttp3/Response$Builder;", "peekBody", "byteCount", "-deprecated_priorResponse", "-deprecated_protocol", "-deprecated_receivedResponseAtMillis", "-deprecated_request", "-deprecated_sentRequestAtMillis", "toString", "trailers", "Builder", "okhttp"})
public final class Response
implements Closeable {
    private final Request request;
    private final Protocol protocol;
    private final String message;
    private final int code;
    private final Handshake handshake;
    private final Headers headers;
    private final ResponseBody body;
    private final Response networkResponse;
    private final Response cacheResponse;
    private final Response priorResponse;
    private final long sentRequestAtMillis;
    private final long receivedResponseAtMillis;
    private final Exchange exchange;
    private CacheControl lazyCacheControl;

    /*
     * WARNING - void declaration
     */
    public Response(Request request, Protocol protocol, String message, int code, Handshake handshake2, Headers headers, ResponseBody body, Response networkResponse, Response cacheResponse, Response priorResponse, long sentRequestAtMillis, long receivedResponseAtMillis, Exchange exchange) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)((Object)protocol), (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        this.request = var1_1;
        this.protocol = var2_2;
        this.message = var3_3;
        this.code = code;
        this.handshake = handshake2;
        this.headers = headers;
        this.body = body;
        this.networkResponse = networkResponse;
        this.cacheResponse = cacheResponse;
        this.priorResponse = priorResponse;
        this.sentRequestAtMillis = sentRequestAtMillis;
        this.receivedResponseAtMillis = receivedResponseAtMillis;
        this.exchange = exchange;
    }

    @JvmName(name="request")
    public final Request request() {
        return this.request;
    }

    @JvmName(name="protocol")
    public final Protocol protocol() {
        return this.protocol;
    }

    @JvmName(name="message")
    public final String message() {
        return this.message;
    }

    @JvmName(name="code")
    public final int code() {
        return this.code;
    }

    @JvmName(name="handshake")
    public final Handshake handshake() {
        return this.handshake;
    }

    @JvmName(name="headers")
    public final Headers headers() {
        return this.headers;
    }

    @JvmName(name="body")
    public final ResponseBody body() {
        return this.body;
    }

    @JvmName(name="networkResponse")
    public final Response networkResponse() {
        return this.networkResponse;
    }

    @JvmName(name="cacheResponse")
    public final Response cacheResponse() {
        return this.cacheResponse;
    }

    @JvmName(name="priorResponse")
    public final Response priorResponse() {
        return this.priorResponse;
    }

    @JvmName(name="sentRequestAtMillis")
    public final long sentRequestAtMillis() {
        return this.sentRequestAtMillis;
    }

    @JvmName(name="receivedResponseAtMillis")
    public final long receivedResponseAtMillis() {
        return this.receivedResponseAtMillis;
    }

    @JvmName(name="exchange")
    public final Exchange exchange() {
        return this.exchange;
    }

    public final boolean isSuccessful() {
        int n = this.code;
        if (200 <= n) {
            return n < 300;
        }
        return false;
    }

    public static /* synthetic */ String header$default$b4243d8(Response response, String string, String string2, int n) {
        string2 = null;
        Intrinsics.checkNotNullParameter((Object)string, (String)"name");
        String string3 = response.headers.get(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public final Builder newBuilder() {
        return new Builder(this);
    }

    public final List<Challenge> challenges() {
        String string;
        switch (this.code) {
            case 401: {
                string = "WWW-Authenticate";
                break;
            }
            case 407: {
                string = "Proxy-Authenticate";
                break;
            }
            default: {
                return CollectionsKt.emptyList();
            }
        }
        return HttpHeaders.parseChallenges(this.headers, string);
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="cacheControl")
    public final CacheControl cacheControl() {
        void var1_1;
        CacheControl result = this.lazyCacheControl;
        if (result == null) {
            this.lazyCacheControl = result = CacheControl.Companion.parse(this.headers);
        }
        return var1_1;
    }

    @Override
    public final void close() {
        ResponseBody responseBody = this.body;
        if (responseBody == null) {
            String string = "response is not eligible for a body and must not be closed";
            throw new IllegalStateException(string.toString());
        }
        responseBody.close();
    }

    public final String toString() {
        return "Response{protocol=" + (Object)((Object)this.protocol) + ", code=" + this.code + ", message=" + this.message + ", url=" + this.request.url() + '}';
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010I\u001a\u00020\u00002\u0006\u0010J\u001a\u00020)2\u0006\u0010K\u001a\u00020)H\u0016J\u0012\u0010\u0006\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010L\u001a\u00020\u0004H\u0016J\u0012\u0010\f\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\u0004H\u0016J\u0012\u0010M\u001a\u00020N2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0002J\u001a\u0010O\u001a\u00020N2\u0006\u0010J\u001a\u00020)2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u001c\u001a\u00020\u00002\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0018\u0010P\u001a\u00020\u00002\u0006\u0010J\u001a\u00020)2\u0006\u0010K\u001a\u00020)H\u0016J\u0010\u0010\"\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020QH\u0016J\u0015\u0010R\u001a\u00020N2\u0006\u0010S\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\bTJ\u0010\u0010(\u001a\u00020\u00002\u0006\u0010(\u001a\u00020)H\u0016J\u0012\u0010.\u001a\u00020\u00002\b\u0010.\u001a\u0004\u0018\u00010\u0004H\u0016J\u0012\u00101\u001a\u00020\u00002\b\u00101\u001a\u0004\u0018\u00010\u0004H\u0016J\u0010\u00104\u001a\u00020\u00002\u0006\u00104\u001a\u000205H\u0016J\u0010\u0010:\u001a\u00020\u00002\u0006\u0010:\u001a\u00020;H\u0016J\u0010\u0010U\u001a\u00020\u00002\u0006\u0010J\u001a\u00020)H\u0016J\u0010\u0010@\u001a\u00020\u00002\u0006\u0010@\u001a\u00020AH\u0016J\u0010\u0010F\u001a\u00020\u00002\u0006\u0010F\u001a\u00020;H\u0016R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0005R\u001a\u0010\u0010\u001a\u00020\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020#X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001c\u0010(\u001a\u0004\u0018\u00010)X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001c\u0010.\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u000e\"\u0004\b0\u0010\u0005R\u001c\u00101\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u000e\"\u0004\b3\u0010\u0005R\u001c\u00104\u001a\u0004\u0018\u000105X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u001a\u0010:\u001a\u00020;X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u001c\u0010@\u001a\u0004\u0018\u00010AX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER\u001a\u0010F\u001a\u00020;X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010=\"\u0004\bH\u0010?\u00a8\u0006V"}, d2={"Lokhttp3/Response$Builder;", "", "()V", "response", "Lokhttp3/Response;", "(Lokhttp3/Response;)V", "body", "Lokhttp3/ResponseBody;", "getBody$okhttp", "()Lokhttp3/ResponseBody;", "setBody$okhttp", "(Lokhttp3/ResponseBody;)V", "cacheResponse", "getCacheResponse$okhttp", "()Lokhttp3/Response;", "setCacheResponse$okhttp", "code", "", "getCode$okhttp", "()I", "setCode$okhttp", "(I)V", "exchange", "Lokhttp3/internal/connection/Exchange;", "getExchange$okhttp", "()Lokhttp3/internal/connection/Exchange;", "setExchange$okhttp", "(Lokhttp3/internal/connection/Exchange;)V", "handshake", "Lokhttp3/Handshake;", "getHandshake$okhttp", "()Lokhttp3/Handshake;", "setHandshake$okhttp", "(Lokhttp3/Handshake;)V", "headers", "Lokhttp3/Headers$Builder;", "getHeaders$okhttp", "()Lokhttp3/Headers$Builder;", "setHeaders$okhttp", "(Lokhttp3/Headers$Builder;)V", "message", "", "getMessage$okhttp", "()Ljava/lang/String;", "setMessage$okhttp", "(Ljava/lang/String;)V", "networkResponse", "getNetworkResponse$okhttp", "setNetworkResponse$okhttp", "priorResponse", "getPriorResponse$okhttp", "setPriorResponse$okhttp", "protocol", "Lokhttp3/Protocol;", "getProtocol$okhttp", "()Lokhttp3/Protocol;", "setProtocol$okhttp", "(Lokhttp3/Protocol;)V", "receivedResponseAtMillis", "", "getReceivedResponseAtMillis$okhttp", "()J", "setReceivedResponseAtMillis$okhttp", "(J)V", "request", "Lokhttp3/Request;", "getRequest$okhttp", "()Lokhttp3/Request;", "setRequest$okhttp", "(Lokhttp3/Request;)V", "sentRequestAtMillis", "getSentRequestAtMillis$okhttp", "setSentRequestAtMillis$okhttp", "addHeader", "name", "value", "build", "checkPriorResponse", "", "checkSupportResponse", "header", "Lokhttp3/Headers;", "initExchange", "deferredTrailers", "initExchange$okhttp", "removeHeader", "okhttp"})
    public static final class Builder {
        private Request request;
        private Protocol protocol;
        private int code;
        private String message;
        private Handshake handshake;
        private Headers.Builder headers;
        private ResponseBody body;
        private Response networkResponse;
        private Response cacheResponse;
        private Response priorResponse;
        private long sentRequestAtMillis;
        private long receivedResponseAtMillis;
        private Exchange exchange;

        public final int getCode$okhttp() {
            return this.code;
        }

        /*
         * WARNING - void declaration
         */
        private void setHeaders$okhttp(Headers.Builder builder) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)builder, (String)"<set-?>");
            this.headers = var1_1;
        }

        public Builder() {
            this.code = -1;
            this.headers = new Headers.Builder();
        }

        /*
         * WARNING - void declaration
         */
        public Builder(Response response) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            this.code = -1;
            this.request = response.request();
            this.protocol = response.protocol();
            this.code = response.code();
            this.message = response.message();
            this.handshake = response.handshake();
            this.headers = response.headers().newBuilder();
            this.body = response.body();
            this.networkResponse = response.networkResponse();
            this.cacheResponse = response.cacheResponse();
            this.priorResponse = response.priorResponse();
            this.sentRequestAtMillis = response.sentRequestAtMillis();
            this.receivedResponseAtMillis = response.receivedResponseAtMillis();
            this.exchange = var1_1.exchange();
        }

        public final Builder request(Request request) {
            Builder builder;
            Builder builder2;
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Builder builder3 = builder2 = this;
            builder3 = builder;
            builder = builder2;
            builder2.request = builder3;
            return builder2;
        }

        public final Builder protocol(Protocol protocol) {
            Builder builder;
            Builder builder2;
            Intrinsics.checkNotNullParameter((Object)((Object)protocol), (String)"protocol");
            Builder builder3 = builder2 = this;
            builder3 = builder;
            builder = builder2;
            builder2.protocol = builder3;
            return builder2;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder code(int code) {
            void var1_1;
            Builder builder;
            Builder builder2 = builder = this;
            void var3_5 = var1_1;
            Builder builder3 = builder;
            builder.code = var3_5;
            return builder;
        }

        public final Builder message(String message) {
            Builder builder;
            Builder builder2;
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Builder builder3 = builder2 = this;
            builder3 = builder;
            builder = builder2;
            builder2.message = builder3;
            return builder2;
        }

        public final Builder handshake(Handshake handshake2) {
            Builder builder;
            Builder builder2;
            Builder builder3 = builder2 = this;
            builder3 = builder;
            builder = builder2;
            builder2.handshake = builder3;
            return builder2;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder header(String name, String value) {
            void var2_2;
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder builder2 = builder = this;
            builder2 = builder;
            builder.headers.set((String)var1_1, (String)var2_2);
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder addHeader(String name, String value) {
            void var2_2;
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder builder2 = builder = this;
            builder2 = builder;
            builder.headers.add((String)var1_1, (String)var2_2);
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder headers(Headers headers) {
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            Builder builder2 = builder = this;
            builder.setHeaders$okhttp(var1_1.newBuilder());
            return builder;
        }

        public final Builder body(ResponseBody body) {
            Builder builder;
            Builder builder2;
            Builder builder3 = builder2 = this;
            builder3 = builder;
            builder = builder2;
            builder2.body = builder3;
            return builder2;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder networkResponse(Response networkResponse) {
            void var1_1;
            void var3_3;
            Builder builder;
            Builder $this$networkResponse_u24lambda_u2d10 = builder = this;
            Builder.checkSupportResponse("networkResponse", networkResponse);
            void v0 = var3_3;
            var3_3 = var1_1;
            var1_1 = v0;
            v0.networkResponse = var3_3;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder cacheResponse(Response cacheResponse) {
            void var1_1;
            void var3_3;
            Builder builder;
            Builder $this$cacheResponse_u24lambda_u2d11 = builder = this;
            Builder.checkSupportResponse("cacheResponse", cacheResponse);
            void v0 = var3_3;
            var3_3 = var1_1;
            var1_1 = v0;
            v0.cacheResponse = var3_3;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        private static void checkSupportResponse(String name, Response response) {
            void var1_1;
            Response response2 = response;
            if (response2 == null) {
                return;
            }
            response = response2;
            Response $this$checkSupportResponse_u24lambda_u2d16 = response2;
            if (!(response2.body() == null)) {
                name = Intrinsics.stringPlus((String)name, (Object)".body != null");
                throw new IllegalArgumentException(name.toString());
            }
            if (!($this$checkSupportResponse_u24lambda_u2d16.networkResponse() == null)) {
                name = Intrinsics.stringPlus((String)name, (Object)".networkResponse != null");
                throw new IllegalArgumentException(name.toString());
            }
            if (!($this$checkSupportResponse_u24lambda_u2d16.cacheResponse() == null)) {
                name = Intrinsics.stringPlus((String)name, (Object)".cacheResponse != null");
                throw new IllegalArgumentException(name.toString());
            }
            if (!(var1_1.priorResponse() == null)) {
                String string;
                string = Intrinsics.stringPlus((String)string, (Object)".priorResponse != null");
                throw new IllegalArgumentException(string.toString());
            }
        }

        /*
         * WARNING - void declaration
         */
        public final Builder priorResponse(Response priorResponse) {
            void var1_1;
            void var3_3;
            Response response;
            Builder builder;
            Builder $this$priorResponse_u24lambda_u2d17 = builder = this;
            Response response2 = response = priorResponse;
            if (response2 != null) {
                response = response2;
                response = response2;
                if (!(response2.body() == null)) {
                    priorResponse = "priorResponse.body != null";
                    throw new IllegalArgumentException(priorResponse.toString());
                }
            }
            response = var3_3;
            var3_3.priorResponse = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder sentRequestAtMillis(long sentRequestAtMillis) {
            void var1_1;
            Builder builder;
            Builder builder2 = builder = this;
            void var6_5 = var1_1;
            Builder builder3 = builder;
            builder.sentRequestAtMillis = var6_5;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder receivedResponseAtMillis(long receivedResponseAtMillis) {
            void var1_1;
            Builder builder;
            Builder builder2 = builder = this;
            void var6_5 = var1_1;
            Builder builder3 = builder;
            builder.receivedResponseAtMillis = var6_5;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final void initExchange$okhttp(Exchange deferredTrailers) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)deferredTrailers, (String)"deferredTrailers");
            this.exchange = var1_1;
        }

        public final Response build() {
            if (!(this.code >= 0)) {
                Object object = this;
                object = Intrinsics.stringPlus((String)"code < 0: ", (Object)((Builder)object).code);
                throw new IllegalStateException(object.toString());
            }
            Request request = this.request;
            if (request == null) {
                String string = "request == null";
                throw new IllegalStateException(string.toString());
            }
            Protocol protocol = this.protocol;
            if (protocol == null) {
                String string = "protocol == null";
                throw new IllegalStateException(string.toString());
            }
            String string = this.message;
            if (string == null) {
                String string2 = "message == null";
                string2 = "message == null";
                throw new IllegalStateException(string2.toString());
            }
            Exchange exchange = this.exchange;
            long l = this.receivedResponseAtMillis;
            long l2 = this.sentRequestAtMillis;
            Response response = this.priorResponse;
            Response response2 = this.cacheResponse;
            Response response3 = this.networkResponse;
            ResponseBody responseBody = this.body;
            Headers headers = this.headers.build();
            Handshake handshake2 = this.handshake;
            int n = this.code;
            String string3 = string;
            Protocol protocol2 = protocol;
            Request request2 = request;
            return new Response(request2, protocol2, string3, n, handshake2, headers, responseBody, response3, response2, response, l2, l, exchange);
        }
    }
}

