/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal;

import java.net.IDN;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.internal.Util;
import okio.Buffer;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0002\u001a\"\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\f\u0010\r\u001a\u00020\u0001*\u00020\u0003H\u0002\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\u0003*\u00020\u0003\u00a8\u0006\u000f"}, d2={"decodeIpv4Suffix", "", "input", "", "pos", "", "limit", "address", "", "addressOffset", "decodeIpv6", "Ljava/net/InetAddress;", "inet6AddressToAscii", "containsInvalidHostnameAsciiCodes", "toCanonicalHost", "okhttp"})
public final class HostnamesKt {
    /*
     * WARNING - void declaration
     */
    public static final String toCanonicalHost(String $this$toCanonicalHost) {
        Intrinsics.checkNotNullParameter((Object)$this$toCanonicalHost, (String)"<this>");
        Locale host = $this$toCanonicalHost;
        if (StringsKt.contains$default((CharSequence)((CharSequence)((Object)host)), (CharSequence)":", (boolean)false, (int)2, null)) {
            InetAddress inetAddress = StringsKt.startsWith$default((String)((Object)host), (String)"[", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)((Object)host), (String)"]", (boolean)false, (int)2, null) ? HostnamesKt.decodeIpv6((String)((Object)host), 1, ((String)((Object)host)).length() - 1) : HostnamesKt.decodeIpv6((String)((Object)host), 0, ((String)((Object)host)).length());
            if (inetAddress == null) {
                return null;
            }
            InetAddress inetAddress22 = inetAddress;
            byte[] address2 = inetAddress22.getAddress();
            if (address2.length == 16) {
                int n;
                int n2;
                Intrinsics.checkNotNullExpressionValue((Object)address2, (String)"address");
                host = (Locale)address2;
                int inetAddress22 = -1;
                int address2 = 0;
                for (n2 = 0; n2 < ((Object)host).length; n2 += 2) {
                    n = n2;
                    while (n2 < 16 && host[n2] == false && host[n2 + 1] == false) {
                        n2 += 2;
                    }
                    int n3 = n2 - n;
                    if (n3 <= address2 || n3 < 4) continue;
                    inetAddress22 = n;
                    address2 = n3;
                }
                Buffer buffer = new Buffer();
                n2 = 0;
                while (n2 < ((Object)host).length) {
                    if (n2 == inetAddress22) {
                        buffer.writeByte(58);
                        if ((n2 += address2) != 16) continue;
                        buffer.writeByte(58);
                        continue;
                    }
                    if (n2 > 0) {
                        buffer.writeByte(58);
                    }
                    n = Util.and((byte)host[n2], 255) << 8 | Util.and((byte)host[n2 + 1], 255);
                    buffer.writeHexadecimalUnsignedLong((long)n);
                    n2 += 2;
                }
                return buffer.readUtf8();
            }
            if (((InetAddress)inetAddress).length == 4) {
                return inetAddress22.getHostAddress();
            }
            throw new AssertionError((Object)("Invalid IPv6 address: '" + (String)((Object)host) + '\''));
        }
        try {
            void var1_6;
            Locale locale;
            String string = IDN.toASCII((String)((Object)locale));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toASCII(host)");
            locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
            String result = string2;
            if (((CharSequence)string2).length() == 0) {
                return null;
            }
            if (HostnamesKt.containsInvalidHostnameAsciiCodes(result)) {
                return null;
            }
            return var1_6;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean containsInvalidHostnameAsciiCodes(String $this$containsInvalidHostnameAsciiCodes) {
        int n = 0;
        int n2 = $this$containsInvalidHostnameAsciiCodes.length();
        while (n < n2) {
            void var3_3;
            int i;
            char c;
            if (Intrinsics.compare((int)(c = $this$containsInvalidHostnameAsciiCodes.charAt(i = n++)), (int)31) <= 0 || Intrinsics.compare((int)c, (int)127) >= 0) {
                return true;
            }
            if (StringsKt.indexOf$default((CharSequence)" #%/:?@[\\]", (char)var3_3, (int)0, (boolean)false, (int)6, null) == -1) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final InetAddress decodeIpv6(String input, int pos, int limit) {
        void var3_3;
        void i;
        byte[] address = new byte[16];
        int b = 0;
        int compress = -1;
        int groupOffset = -1;
        while (i < limit) {
            int hexDigit;
            if (b == 16) {
                return null;
            }
            if (i + 2 <= limit && StringsKt.startsWith$default((String)input, (String)"::", (int)i, (boolean)false, (int)4, null)) {
                if (compress != -1) {
                    return null;
                }
                compress = b += 2;
                if ((i += 2) == limit) {
                    break;
                }
            } else if (b != 0) {
                if (StringsKt.startsWith$default((String)input, (String)":", (int)i, (boolean)false, (int)4, null)) {
                    void var7_7 = i;
                    i = var7_7 + true;
                } else {
                    if (StringsKt.startsWith$default((String)input, (String)".", (int)i, (boolean)false, (int)4, null)) {
                        if (!HostnamesKt.decodeIpv4Suffix(input, groupOffset, limit, address, b - 2)) {
                            return null;
                        }
                        b += 2;
                        break;
                    }
                    return null;
                }
            }
            int value = 0;
            groupOffset = i;
            while (i < limit && (hexDigit = Util.parseHexDigit(input.charAt((int)i))) != -1) {
                value = (value << 4) + hexDigit;
                hexDigit = i;
                i = hexDigit + true;
            }
            void groupLength = i - groupOffset;
            if (groupLength == false || groupLength > 4) {
                return null;
            }
            int n = b;
            b = n + 1;
            address[n] = (byte)(value >>> 8);
            n = b;
            b = n + 1;
            address[n] = (byte)value;
        }
        if (b != 16) {
            if (compress == -1) {
                return null;
            }
            System.arraycopy(address, compress, address, 16 - (b - compress), b - compress);
            int n = compress;
            Arrays.fill(address, n, n + (16 - b), (byte)0);
        }
        return InetAddress.getByAddress((byte[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean decodeIpv4Suffix(String input, int pos, int limit, byte[] address, int addressOffset) {
        void i;
        int b = addressOffset;
        while (i < limit) {
            int n;
            char c;
            if (b == 16) {
                return false;
            }
            if (b != addressOffset) {
                if (input.charAt((int)i) != '.') {
                    return false;
                }
                void var6_6 = i;
                i = var6_6 + true;
            }
            int value = 0;
            void groupOffset = i;
            while (i < limit && Intrinsics.compare((int)(c = input.charAt((int)i)), (int)48) >= 0 && Intrinsics.compare((int)c, (int)57) <= 0) {
                if (value == 0 && groupOffset != i) {
                    return false;
                }
                if ((value = value * 10 + c - 48) > 255) {
                    return false;
                }
                n = i;
                i = n + true;
            }
            n = i - groupOffset;
            if (n == 0) {
                return false;
            }
            n = b;
            b = n + 1;
            address[n] = (byte)value;
        }
        return b == addressOffset + 4;
    }
}

