/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.authenticator;

import java.io.IOException;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Address;
import okhttp3.Authenticator;
import okhttp3.Challenge;
import okhttp3.Credentials;
import okhttp3.Dns;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lokhttp3/internal/authenticator/JavaNetAuthenticator;", "Lokhttp3/Authenticator;", "defaultDns", "Lokhttp3/Dns;", "(Lokhttp3/Dns;)V", "authenticate", "Lokhttp3/Request;", "route", "Lokhttp3/Route;", "response", "Lokhttp3/Response;", "connectToInetAddress", "Ljava/net/InetAddress;", "Ljava/net/Proxy;", "url", "Lokhttp3/HttpUrl;", "dns", "okhttp"})
public final class JavaNetAuthenticator
implements Authenticator {
    private final Dns defaultDns;

    /*
     * WARNING - void declaration
     */
    private JavaNetAuthenticator(Dns defaultDns) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)defaultDns, (String)"defaultDns");
        this.defaultDns = var1_1;
    }

    public /* synthetic */ JavaNetAuthenticator(Dns dns, int n) {
        dns = Dns.SYSTEM;
        this(dns);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Request authenticate(Route route, Response response) throws IOException {
        Iterator iterator;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        List<Challenge> challenges = response.challenges();
        Request request = response.request();
        HttpUrl url = request.url();
        boolean proxyAuthorization = response.code() == 407;
        Route route2 = route;
        Proxy proxy = route2 == null ? null : route2.proxy();
        if (proxy == null) {
            proxy = Proxy.NO_PROXY;
        }
        Proxy proxy2 = proxy;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var1_1;
            void var2_3;
            PasswordAuthentication auth;
            PasswordAuthentication passwordAuthentication;
            Dns dns;
            Dns dns2;
            Dns dns3;
            Challenge challenge = (Challenge)iterator.next();
            if (!StringsKt.equals((String)"Basic", (String)challenge.scheme(), (boolean)true)) continue;
            Route route3 = route;
            if (route3 == null) {
                dns3 = null;
            } else {
                Address address = route3.address();
                dns3 = dns2 = address == null ? null : address.dns();
            }
            if (dns3 == null) {
                dns2 = dns = this.defaultDns;
            }
            if (proxyAuthorization) {
                SocketAddress socketAddress = proxy2.address();
                if (socketAddress == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.net.InetSocketAddress");
                }
                InetSocketAddress proxyAddress = (InetSocketAddress)socketAddress;
                String string = proxyAddress.getHostName();
                Intrinsics.checkNotNullExpressionValue((Object)proxy2, (String)"proxy");
                passwordAuthentication = java.net.Authenticator.requestPasswordAuthentication(string, JavaNetAuthenticator.connectToInetAddress(proxy2, url, dns), proxyAddress.getPort(), url.scheme(), challenge.realm(), challenge.scheme(), url.url(), Authenticator.RequestorType.PROXY);
            } else {
                String string = url.host();
                Intrinsics.checkNotNullExpressionValue((Object)proxy2, (String)"proxy");
                passwordAuthentication = auth = java.net.Authenticator.requestPasswordAuthentication(string, JavaNetAuthenticator.connectToInetAddress(proxy2, url, dns), url.port(), url.scheme(), challenge.realm(), challenge.scheme(), url.url(), Authenticator.RequestorType.SERVER);
            }
            if (passwordAuthentication == null) continue;
            String credentialHeader = var2_3 != false ? "Proxy-Authorization" : "Authorization";
            route = auth.getUserName();
            Intrinsics.checkNotNullExpressionValue((Object)route, (String)"auth.userName");
            Object object = route;
            char[] cArray = auth.getPassword();
            route = cArray;
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"auth.password");
            String credential = Credentials.basic((String)object, new String((char[])route), challenge.charset());
            return request.newBuilder().header(credentialHeader, (String)var1_1).build();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static InetAddress connectToInetAddress(Proxy $this$connectToInetAddress, HttpUrl url, Dns dns) throws IOException {
        InetAddress inetAddress;
        Proxy.Type type = $this$connectToInetAddress.type();
        if ((type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) == 1) {
            void var1_1;
            void var2_2;
            return (InetAddress)CollectionsKt.first(var2_2.lookup(var1_1.host()));
        }
        SocketAddress socketAddress = ((Proxy)((Object)inetAddress)).address();
        if (socketAddress == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.net.InetSocketAddress");
        }
        inetAddress = ((InetSocketAddress)socketAddress).getAddress();
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"address() as InetSocketAddress).address");
        return inetAddress;
    }

    public JavaNetAuthenticator() {
        this(null, 1);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Proxy.Type.values().length];
            int[] nArray2 = nArray;
            nArray[Proxy.Type.DIRECT.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray2;
        }
    }
}

