/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.cache;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Cache;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import okhttp3.internal.cache.CacheStrategy;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.HttpMethod;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lokhttp3/internal/cache/CacheInterceptor;", "Lokhttp3/Interceptor;", "cache", "Lokhttp3/Cache;", "(Lokhttp3/Cache;)V", "getCache$okhttp", "()Lokhttp3/Cache;", "cacheWritingResponse", "Lokhttp3/Response;", "cacheRequest", "Lokhttp3/internal/cache/CacheRequest;", "response", "intercept", "chain", "Lokhttp3/Interceptor$Chain;", "Companion", "okhttp"})
public final class CacheInterceptor
implements Interceptor {
    private static Companion Companion = new Companion(0);
    private final Cache cache;

    /*
     * WARNING - void declaration
     */
    public CacheInterceptor(Cache cache) {
        void var1_1;
        this.cache = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Response intercept(Interceptor.Chain chain) throws IOException {
        void var1_1;
        Response networkResponse;
        Response it2;
        Response cacheResponse;
        Request networkRequest;
        block24: {
            ResponseBody responseBody;
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            Call call = chain.call();
            if (this.cache != null) {
                Request request = chain.request();
                throw null;
            }
            Response cacheCandidate = null;
            long now = System.currentTimeMillis();
            CacheStrategy strategy = new CacheStrategy.Factory(now, chain.request(), cacheCandidate).compute();
            networkRequest = strategy.getNetworkRequest();
            cacheResponse = strategy.getCacheResponse();
            if (this.cache != null) {
                CacheStrategy cacheStrategy = strategy;
                throw null;
            }
            RealCall realCall = call instanceof RealCall ? (RealCall)call : null;
            if ((realCall == null ? null : realCall.getEventListener$okhttp()) == null) {
            }
            if (cacheCandidate != null && cacheResponse == null) {
                ResponseBody responseBody2 = cacheCandidate.body();
                if (responseBody2 != null) {
                    Util.closeQuietly(responseBody2);
                }
            }
            if (networkRequest == null && cacheResponse == null) {
                chain = new Response.Builder().request(chain.request()).protocol(Protocol.HTTP_1_1).code(504).message("Unsatisfiable Request (only-if-cached)").body(Util.EMPTY_RESPONSE).sentRequestAtMillis(-1L).receivedResponseAtMillis(System.currentTimeMillis()).build();
                it2 = chain;
                EventListener.satisfactionFailure(call, it2);
                return chain;
            }
            if (networkRequest == null) {
                Response response = cacheResponse;
                Intrinsics.checkNotNull((Object)response);
                chain = response.newBuilder().cacheResponse(okhttp3.internal.cache.CacheInterceptor$Companion.access$stripBody(Companion, cacheResponse)).build();
                it2 = chain;
                EventListener.cacheHit(call, it2);
                return chain;
            }
            if (cacheResponse != null) {
                EventListener.cacheConditionalHit(call, cacheResponse);
            } else if (this.cache != null) {
                void var2_2;
                EventListener.cacheMiss((Call)var2_2);
            }
            try {
                networkResponse = chain.proceed(networkRequest);
                if (networkResponse != null || cacheCandidate == null) break block24;
                responseBody = cacheCandidate.body();
            }
            catch (Throwable it2) {
                if (cacheCandidate != null) {
                    void var3_3;
                    ResponseBody responseBody3 = var3_3.body();
                    if (responseBody3 != null) {
                        Util.closeQuietly(responseBody3);
                    }
                }
                throw it2;
            }
            if (responseBody != null) {
                Util.closeQuietly(responseBody);
            }
        }
        if (cacheResponse != null) {
            Response response = networkResponse;
            if (response != null && response.code() == 304) {
                it2 = cacheResponse.newBuilder().headers(okhttp3.internal.cache.CacheInterceptor$Companion.access$combine(Companion, cacheResponse.headers(), networkResponse.headers())).sentRequestAtMillis(networkResponse.sentRequestAtMillis()).receivedResponseAtMillis(networkResponse.receivedResponseAtMillis()).cacheResponse(okhttp3.internal.cache.CacheInterceptor$Companion.access$stripBody(Companion, cacheResponse)).networkResponse(okhttp3.internal.cache.CacheInterceptor$Companion.access$stripBody(Companion, networkResponse)).build();
                ResponseBody responseBody = networkResponse.body();
                Intrinsics.checkNotNull((Object)responseBody);
                responseBody.close();
                Cache cache = this.cache;
                Cache cache2 = cache;
                Intrinsics.checkNotNull((Object)cache);
                throw null;
            }
            ResponseBody responseBody = cacheResponse.body();
            if (responseBody != null) {
                Util.closeQuietly(responseBody);
            }
        }
        Response response = networkResponse;
        Intrinsics.checkNotNull((Object)response);
        Response response2 = response.newBuilder().cacheResponse(okhttp3.internal.cache.CacheInterceptor$Companion.access$stripBody(Companion, cacheResponse)).networkResponse(okhttp3.internal.cache.CacheInterceptor$Companion.access$stripBody(Companion, (Response)var1_1)).build();
        if (this.cache != null) {
            if (HttpHeaders.promisesBody(response2)) {
                if (CacheStrategy.Companion.isCacheable(response2, networkRequest)) {
                    Cache cache = this.cache;
                    Response response3 = response2;
                    throw null;
                }
            }
            if (HttpMethod.invalidatesCache(networkRequest.method())) {
                try {
                    Cache cache = this.cache;
                    Request request = networkRequest;
                    throw null;
                }
                catch (IOException iOException) {}
            }
        }
        return response2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0002\u00a8\u0006\u000f"}, d2={"Lokhttp3/internal/cache/CacheInterceptor$Companion;", "", "()V", "combine", "Lokhttp3/Headers;", "cachedHeaders", "networkHeaders", "isContentSpecificHeader", "", "fieldName", "", "isEndToEnd", "stripBody", "Lokhttp3/Response;", "response", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        private static boolean isEndToEnd(String fieldName) {
            String string;
            return !StringsKt.equals((String)"Connection", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Keep-Alive", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Proxy-Authenticate", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Proxy-Authorization", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"TE", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Trailers", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Transfer-Encoding", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Upgrade", (String)string, (boolean)true);
        }

        private static boolean isContentSpecificHeader(String fieldName) {
            String string;
            return StringsKt.equals((String)"Content-Length", (String)fieldName, (boolean)true) || StringsKt.equals((String)"Content-Encoding", (String)fieldName, (boolean)true) || StringsKt.equals((String)"Content-Type", (String)string, (boolean)true);
        }

        public static final /* synthetic */ Response access$stripBody(Companion $this, Response response) {
            Response response2 = response;
            if ((response2 == null ? null : response2.body()) != null) {
                return response2.newBuilder().body(null).build();
            }
            return response2;
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ Headers access$combine(Companion $this, Headers cachedHeaders, Headers networkHeaders) {
            void var2_2;
            String string;
            void var1_1;
            Object object = $this;
            object = new Headers.Builder();
            int n = 0;
            int n2 = var1_1.size();
            while (n < n2) {
                int n3 = n++;
                string = var1_1.name(n3);
                String string2 = var1_1.value(n3);
                if (StringsKt.equals((String)"Warning", (String)string, (boolean)true) && StringsKt.startsWith$default((String)string2, (String)"1", (boolean)false, (int)2, null) || !okhttp3.internal.cache.CacheInterceptor$Companion.isContentSpecificHeader(string) && okhttp3.internal.cache.CacheInterceptor$Companion.isEndToEnd(string) && var2_2.get(string) != null) continue;
                ((Headers.Builder)object).addLenient$okhttp(string, string2);
            }
            n = 0;
            n2 = var2_2.size();
            while (n < n2) {
                int n4;
                if (okhttp3.internal.cache.CacheInterceptor$Companion.isContentSpecificHeader(string = var2_2.name(n4 = n++)) || !okhttp3.internal.cache.CacheInterceptor$Companion.isEndToEnd(string)) continue;
                ((Headers.Builder)object).addLenient$okhttp(string, var2_2.value(n4));
            }
            return ((Headers.Builder)object).build();
        }

        public /* synthetic */ Companion(byte by) {
            this();
        }
    }
}

