/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.cache;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;
import okhttp3.internal.http.DatesKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u000b2\u00020\u0001:\u0002\u000b\fB\u001b\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lokhttp3/internal/cache/CacheStrategy;", "", "networkRequest", "Lokhttp3/Request;", "cacheResponse", "Lokhttp3/Response;", "(Lokhttp3/Request;Lokhttp3/Response;)V", "getCacheResponse", "()Lokhttp3/Response;", "getNetworkRequest", "()Lokhttp3/Request;", "Companion", "Factory", "okhttp"})
public final class CacheStrategy {
    public static final Companion Companion = new Companion(0);
    private final Request networkRequest;
    private final Response cacheResponse;

    /*
     * WARNING - void declaration
     */
    public CacheStrategy(Request networkRequest, Response cacheResponse) {
        void var2_2;
        void var1_1;
        this.networkRequest = var1_1;
        this.cacheResponse = var2_2;
    }

    public final Request getNetworkRequest() {
        return this.networkRequest;
    }

    public final Response getCacheResponse() {
        return this.cacheResponse;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0017\u001a\u00020\u0003H\u0002J\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u0003H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u001e\u001a\u00020\u001dH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lokhttp3/internal/cache/CacheStrategy$Factory;", "", "nowMillis", "", "request", "Lokhttp3/Request;", "cacheResponse", "Lokhttp3/Response;", "(JLokhttp3/Request;Lokhttp3/Response;)V", "ageSeconds", "", "etag", "", "expires", "Ljava/util/Date;", "lastModified", "lastModifiedString", "receivedResponseMillis", "getRequest$okhttp", "()Lokhttp3/Request;", "sentRequestMillis", "servedDate", "servedDateString", "cacheResponseAge", "compute", "Lokhttp3/internal/cache/CacheStrategy;", "computeCandidate", "computeFreshnessLifetime", "hasConditions", "", "isFreshnessLifetimeHeuristic", "okhttp"})
    public static final class Factory {
        private final long nowMillis;
        private final Request request;
        private final Response cacheResponse;
        private Date servedDate;
        private String servedDateString;
        private Date lastModified;
        private String lastModifiedString;
        private Date expires;
        private long sentRequestMillis;
        private long receivedResponseMillis;
        private String etag;
        private int ageSeconds;

        /*
         * WARNING - void declaration
         */
        public Factory(long nowMillis, Request request, Response cacheResponse) {
            void var3_3;
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            this.nowMillis = nowMillis;
            this.request = var3_3;
            this.cacheResponse = cacheResponse;
            this.ageSeconds = -1;
            if (this.cacheResponse != null) {
                this.sentRequestMillis = this.cacheResponse.sentRequestAtMillis();
                this.receivedResponseMillis = this.cacheResponse.receivedResponseAtMillis();
                Headers headers = this.cacheResponse.headers();
                int n = 0;
                int n2 = headers.size();
                while (n < n2) {
                    int i = n++;
                    String fieldName = headers.name(i);
                    String value = headers.value(i);
                    if (StringsKt.equals((String)fieldName, (String)"Date", (boolean)true)) {
                        this.servedDate = DatesKt.toHttpDateOrNull(value);
                        this.servedDateString = value;
                        continue;
                    }
                    if (StringsKt.equals((String)fieldName, (String)"Expires", (boolean)true)) {
                        this.expires = DatesKt.toHttpDateOrNull(value);
                        continue;
                    }
                    if (StringsKt.equals((String)fieldName, (String)"Last-Modified", (boolean)true)) {
                        this.lastModified = DatesKt.toHttpDateOrNull(value);
                        this.lastModifiedString = value;
                        continue;
                    }
                    if (StringsKt.equals((String)fieldName, (String)"ETag", (boolean)true)) {
                        this.etag = value;
                        continue;
                    }
                    if (!StringsKt.equals((String)fieldName, (String)"Age", (boolean)true)) continue;
                    this.ageSeconds = Util.toNonNegativeInt(value, -1);
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        public final CacheStrategy compute() {
            block20: {
                block26: {
                    block25: {
                        block24: {
                            block23: {
                                block22: {
                                    block21: {
                                        block19: {
                                            var1_1 = this;
                                            if (var1_1.cacheResponse != null) break block19;
                                            v0 = new CacheStrategy(var1_1.request, null);
                                            break block20;
                                        }
                                        if (!var1_1.request.isHttps() || var1_1.cacheResponse.handshake() != null) break block21;
                                        v0 = new CacheStrategy(var1_1.request, null);
                                        break block20;
                                    }
                                    if (okhttp3.internal.cache.CacheStrategy$Companion.isCacheable(var1_1.cacheResponse, var1_1.request)) break block22;
                                    v0 = new CacheStrategy(var1_1.request, null);
                                    break block20;
                                }
                                var2_2 = var1_1.request.cacheControl();
                                if (!var2_2.noCache() && !((var4_3 = var1_1.request).header("If-Modified-Since") != null || var4_3.header("If-None-Match") != null)) break block23;
                                v0 = new CacheStrategy(var1_1.request, null);
                                break block20;
                            }
                            var3_4 = var1_1.cacheResponse.cacheControl();
                            var4_3 = var1_1;
                            var7_5 = var4_3.servedDate;
                            if (var7_5 != null) {
                                var23_7 = var4_3.receivedResponseMillis - var7_5.getTime();
                                v1 = Math.max(0L, var23_7);
                            } else {
                                v1 = var19_8 = 0L;
                            }
                            if (var4_3.ageSeconds != -1) {
                                var23_7 = TimeUnit.SECONDS.toMillis(var4_3.ageSeconds);
                                v2 = Math.max(var19_8, var23_7);
                            } else {
                                v2 = var19_8;
                            }
                            var21_10 = v2;
                            var23_7 = var4_3.receivedResponseMillis - var4_3.sentRequestMillis;
                            var25_11 = var4_3.nowMillis - var4_3.receivedResponseMillis;
                            var5_12 = var21_10 + var23_7 + var25_11;
                            var4_3 = var1_1;
                            v3 = var4_3.cacheResponse;
                            Intrinsics.checkNotNull((Object)v3);
                            var7_5 = v3.cacheControl();
                            if (var7_5.maxAgeSeconds() != -1) {
                                v4 = TimeUnit.SECONDS.toMillis(var7_5.maxAgeSeconds());
                            } else {
                                var19_9 = var4_3.expires;
                                if (var19_9 != null) {
                                    v5 = var4_3.servedDate;
                                    v6 = v5 == null ? null : Long.valueOf(v5.getTime());
                                    var20_13 = v6 == null ? var4_3.receivedResponseMillis : v6;
                                    var22_14 = var19_9.getTime() - var20_13;
                                    v4 = var22_14 > 0L ? var22_14 : 0L;
                                } else if (var4_3.lastModified != null && var4_3.cacheResponse.request().url().query() == null) {
                                    v7 = var4_3.servedDate;
                                    v8 = v7 == null ? null : Long.valueOf(v7.getTime());
                                    var20_13 = v8 == null ? var4_3.sentRequestMillis : v8;
                                    v9 = var4_3.lastModified;
                                    Intrinsics.checkNotNull((Object)v9);
                                    var22_14 = var20_13 - v9.getTime();
                                    v4 = var22_14 > 0L ? var22_14 / 10L : 0L;
                                } else {
                                    v4 = var7_6 = 0L;
                                }
                            }
                            if (var2_2.maxAgeSeconds() != -1) {
                                var9_15 = TimeUnit.SECONDS.toMillis(var2_2.maxAgeSeconds());
                                var7_6 = Math.min(var7_6, var9_15);
                            }
                            var9_15 = 0L;
                            if (var2_2.minFreshSeconds() != -1) {
                                var9_15 = TimeUnit.SECONDS.toMillis(var2_2.minFreshSeconds());
                            }
                            var11_16 = 0L;
                            if (!var3_4.mustRevalidate() && var2_2.maxStaleSeconds() != -1) {
                                var11_16 = TimeUnit.SECONDS.toMillis(var2_2.maxStaleSeconds());
                            }
                            if (var3_4.noCache() || var5_12 + var9_15 >= var7_6 + var11_16) break block24;
                            var2_2 = var1_1.cacheResponse.newBuilder();
                            if (var5_12 + var9_15 >= var7_6) {
                                var2_2.addHeader("Warning", "110 HttpURLConnection \"Response is stale\"");
                            }
                            if (var5_12 > 86400000L) {
                                var4_3 = var1_1;
                                v10 = var4_3.cacheResponse;
                                Intrinsics.checkNotNull((Object)v10);
                                if (v10.cacheControl().maxAgeSeconds() == -1 && var4_3.expires == null) {
                                    var2_2.addHeader("Warning", "113 HttpURLConnection \"Heuristic expiration\"");
                                }
                            }
                            v0 = new CacheStrategy(null, var2_2.build());
                            break block20;
                        }
                        if (var1_1.etag == null) break block25;
                        var2_2 = "If-None-Match";
                        var3_4 = var1_1.etag;
                        ** GOTO lbl100
                    }
                    if (var1_1.lastModified == null) break block26;
                    var2_2 = "If-Modified-Since";
                    var3_4 = var1_1.lastModifiedString;
                    ** GOTO lbl100
                }
                if (var1_1.servedDate == null) {
                    v0 = new CacheStrategy(var1_1.request, null);
                } else {
                    var2_2 = "If-Modified-Since";
                    var3_4 = var1_1.servedDateString;
lbl100:
                    // 3 sources

                    var4_3 = var1_1.request.headers().newBuilder();
                    v11 = var3_4;
                    Intrinsics.checkNotNull((Object)v11);
                    var4_3.addLenient$okhttp((String)var2_2, (String)v11);
                    var2_2 = var1_1.request.newBuilder().headers(var4_3.build()).build();
                    v0 = candidate = new CacheStrategy((Request)var2_2, var1_1.cacheResponse);
                }
            }
            if (v0.getNetworkRequest() != null && this.request.cacheControl().onlyIfCached()) {
                return new CacheStrategy(null, null);
            }
            return var1_1;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lokhttp3/internal/cache/CacheStrategy$Companion;", "", "()V", "isCacheable", "", "response", "Lokhttp3/Response;", "request", "Lokhttp3/Request;", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public static boolean isCacheable(Response response, Request request) {
            void var1_1;
            Response response2;
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            switch (response.code()) {
                case 200: 
                case 203: 
                case 204: 
                case 300: 
                case 301: 
                case 308: 
                case 404: 
                case 405: 
                case 410: 
                case 414: 
                case 501: {
                    break;
                }
                case 302: 
                case 307: {
                    if (Response.header$default$b4243d8(response, "Expires", null, 2) != null || response.cacheControl().maxAgeSeconds() != -1 || response.cacheControl().isPublic() || response.cacheControl().isPrivate()) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            return !response2.cacheControl().noStore() && !var1_1.cacheControl().noStore();
        }

        public /* synthetic */ Companion(byte by) {
            this();
        }
    }
}

