/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.concurrent;

import androidx.compose.animation.core.AnimationSpecKt;
import com.ibm.icu.text.UnicodeSet;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.Util;
import okhttp3.internal.concurrent.TaskRunner;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u00013B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010!\u001a\u00020\"J\r\u0010#\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b$J8\u0010%\u001a\u00020\"2\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010&\u001a\u00020'2\b\b\u0002\u0010(\u001a\u00020\u000e2\u000e\b\u0004\u0010)\u001a\b\u0012\u0004\u0012\u00020\"0*H\u0086\b\u00f8\u0001\u0000J\u0006\u0010+\u001a\u00020,J.\u0010-\u001a\u00020\"2\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010&\u001a\u00020'2\u000e\b\u0004\u0010)\u001a\b\u0012\u0004\u0012\u00020'0*H\u0086\b\u00f8\u0001\u0000J\u0018\u0010-\u001a\u00020\"2\u0006\u0010.\u001a\u00020\b2\b\b\u0002\u0010&\u001a\u00020'J%\u0010/\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\b2\u0006\u0010&\u001a\u00020'2\u0006\u00100\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b1J\u0006\u0010\u001c\u001a\u00020\"J\b\u00102\u001a\u00020\u0005H\u0016R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0016R\u001a\u0010\u001c\u001a\u00020\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0010\"\u0004\b\u001e\u0010\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00064"}, d2={"Lokhttp3/internal/concurrent/TaskQueue;", "", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "name", "", "(Lokhttp3/internal/concurrent/TaskRunner;Ljava/lang/String;)V", "activeTask", "Lokhttp3/internal/concurrent/Task;", "getActiveTask$okhttp", "()Lokhttp3/internal/concurrent/Task;", "setActiveTask$okhttp", "(Lokhttp3/internal/concurrent/Task;)V", "cancelActiveTask", "", "getCancelActiveTask$okhttp", "()Z", "setCancelActiveTask$okhttp", "(Z)V", "futureTasks", "", "getFutureTasks$okhttp", "()Ljava/util/List;", "getName$okhttp", "()Ljava/lang/String;", "scheduledTasks", "", "getScheduledTasks", "shutdown", "getShutdown$okhttp", "setShutdown$okhttp", "getTaskRunner$okhttp", "()Lokhttp3/internal/concurrent/TaskRunner;", "cancelAll", "", "cancelAllAndDecide", "cancelAllAndDecide$okhttp", "execute", "delayNanos", "", "cancelable", "block", "Lkotlin/Function0;", "idleLatch", "Ljava/util/concurrent/CountDownLatch;", "schedule", "task", "scheduleAndDecide", "recurrence", "scheduleAndDecide$okhttp", "toString", "AwaitIdleTask", "okhttp"})
public final class TaskQueue {
    private final TaskRunner taskRunner;
    private final String name;
    private boolean shutdown;
    private UnicodeSet.XSymbolTable activeTask$365b969c;
    private final List<UnicodeSet.XSymbolTable> futureTasks;
    private boolean cancelActiveTask;

    /*
     * WARNING - void declaration
     */
    public TaskQueue(TaskRunner taskRunner, String name) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)taskRunner, (String)"taskRunner");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.taskRunner = var1_1;
        this.name = var2_2;
        this.futureTasks = new ArrayList();
    }

    public final TaskRunner getTaskRunner$okhttp() {
        return this.taskRunner;
    }

    public final String getName$okhttp() {
        return this.name;
    }

    public final boolean getShutdown$okhttp() {
        return this.shutdown;
    }

    public final UnicodeSet.XSymbolTable getActiveTask$okhttp$6c3bee25() {
        return this.activeTask$365b969c;
    }

    /*
     * WARNING - void declaration
     */
    public final void setActiveTask$okhttp$468b1d9(UnicodeSet.XSymbolTable xSymbolTable) {
        void var1_1;
        this.activeTask$365b969c = var1_1;
    }

    public final List<UnicodeSet.XSymbolTable> getFutureTasks$okhttp() {
        return this.futureTasks;
    }

    public final boolean getCancelActiveTask$okhttp() {
        return this.cancelActiveTask;
    }

    public final void setCancelActiveTask$okhttp(boolean bl) {
        this.cancelActiveTask = false;
    }

    /*
     * WARNING - void declaration
     */
    public final void schedule$7751fff5(UnicodeSet.XSymbolTable task, long delayNanos2) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        TaskRunner taskRunner = this.taskRunner;
        synchronized (taskRunner) {
            void var2_3;
            void var1_1;
            TaskQueue taskQueue = this;
            if (taskQueue.shutdown) {
                if (task.getCancelable()) {
                    if (TaskRunner.access$getLogger$cp().isLoggable(Level.FINE)) {
                        UnicodeSet.XSymbolTable xSymbolTable = task;
                        task = this;
                        UnicodeSet.XSymbolTable delayNanos2 = xSymbolTable;
                        String string = "schedule canceled (queue is shutdown)";
                        AnimationSpecKt.access$log$459af22c((UnicodeSet.XSymbolTable)delayNanos2, (TaskQueue)task, (String)string);
                    }
                    return;
                }
                if (TaskRunner.access$getLogger$cp().isLoggable(Level.FINE)) {
                    UnicodeSet.XSymbolTable xSymbolTable = task;
                    task = this;
                    UnicodeSet.XSymbolTable delayNanos2 = xSymbolTable;
                    String string = "schedule failed (queue is shutdown)";
                    AnimationSpecKt.access$log$459af22c((UnicodeSet.XSymbolTable)delayNanos2, (TaskQueue)task, (String)string);
                }
                throw new RejectedExecutionException();
            }
            if (this.scheduleAndDecide$okhttp$72ed4bd3((UnicodeSet.XSymbolTable)var1_1, (long)var2_3, false)) {
                taskQueue = this;
                taskQueue.taskRunner.kickCoordinator$okhttp(this);
            }
            return;
        }
    }

    public static /* synthetic */ void schedule$default$6ac1683b$560effd7(TaskQueue taskQueue, UnicodeSet.XSymbolTable xSymbolTable, long l, int n) {
        taskQueue.schedule$7751fff5(xSymbolTable, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean scheduleAndDecide$okhttp$72ed4bd3(UnicodeSet.XSymbolTable task, long delayNanos, boolean recurrence222) {
        void var2_3;
        void var1_1;
        int insertAt;
        int n;
        block7: {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            task.initQueue$okhttp(this);
            long now = this.taskRunner.getBackend().nanoTime();
            long executeNanoTime = now + delayNanos;
            int existingIndex2 = this.futureTasks.indexOf(task);
            if (existingIndex2 != -1) {
                if (task.getNextExecuteNanoTime$okhttp() <= executeNanoTime) {
                    if (TaskRunner.access$getLogger$cp().isLoggable(Level.FINE)) {
                        TaskQueue taskQueue = this;
                        UnicodeSet.XSymbolTable existingIndex2 = task;
                        String recurrence222 = "already scheduled";
                        AnimationSpecKt.access$log$459af22c((UnicodeSet.XSymbolTable)existingIndex2, (TaskQueue)taskQueue, (String)recurrence222);
                    }
                    return false;
                }
                this.futureTasks.remove(existingIndex2);
            }
            task.setNextExecuteNanoTime$okhttp(executeNanoTime);
            if (TaskRunner.access$getLogger$cp().isLoggable(Level.FINE)) {
                boolean recurrence222;
                TaskQueue taskQueue = this;
                UnicodeSet.XSymbolTable xSymbolTable = task;
                String recurrence222 = recurrence222 ? Intrinsics.stringPlus((String)"run again after ", (Object)AnimationSpecKt.formatDuration((long)(executeNanoTime - now))) : Intrinsics.stringPlus((String)"scheduled after ", (Object)AnimationSpecKt.formatDuration((long)(executeNanoTime - now)));
                AnimationSpecKt.access$log$459af22c((UnicodeSet.XSymbolTable)xSymbolTable, (TaskQueue)taskQueue, (String)recurrence222);
            }
            List<UnicodeSet.XSymbolTable> $this$indexOfFirst$iv = this.futureTasks;
            int index$iv = 0;
            for (UnicodeSet.XSymbolTable xSymbolTable : $this$indexOfFirst$iv) {
                UnicodeSet.XSymbolTable xSymbolTable2;
                xSymbolTable = xSymbolTable;
                if (xSymbolTable2.getNextExecuteNanoTime$okhttp() - now > delayNanos) {
                    n = index$iv;
                    break block7;
                }
                ++index$iv;
            }
            n = insertAt = -1;
        }
        if (n == -1) {
            insertAt = this.futureTasks.size();
        }
        this.futureTasks.add(insertAt, (UnicodeSet.XSymbolTable)var1_1);
        return var2_3 == false;
    }

    public final void cancelAll() {
        TaskRunner taskRunner;
        TaskQueue $this$assertThreadDoesntHoldLock$iv = this;
        if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + taskRunner));
        }
        taskRunner = this.taskRunner;
        synchronized (taskRunner) {
            if (this.cancelAllAndDecide$okhttp()) {
                TaskQueue taskQueue = this;
                taskQueue.taskRunner.kickCoordinator$okhttp(this);
            }
            return;
        }
    }

    public final void shutdown() {
        TaskRunner taskRunner;
        TaskQueue $this$assertThreadDoesntHoldLock$iv = this;
        if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + taskRunner));
        }
        taskRunner = this.taskRunner;
        synchronized (taskRunner) {
            boolean bl = true;
            TaskQueue taskQueue = this;
            this.shutdown = true;
            if (this.cancelAllAndDecide$okhttp()) {
                taskQueue = this;
                taskQueue.taskRunner.kickCoordinator$okhttp(this);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean cancelAllAndDecide$okhttp() {
        boolean bl;
        if (this.activeTask$365b969c != null) {
            UnicodeSet.XSymbolTable xSymbolTable = this.activeTask$365b969c;
            Intrinsics.checkNotNull((Object)xSymbolTable);
            if (xSymbolTable.getCancelable()) {
                this.cancelActiveTask = true;
            }
        }
        boolean tasksCanceled = false;
        int n = this.futureTasks.size() - 1;
        if (n >= 0) {
            do {
                void var3_4;
                int i;
                if (!this.futureTasks.get(i = n--).getCancelable()) continue;
                UnicodeSet.XSymbolTable task$iv = this.futureTasks.get(i);
                if (TaskRunner.access$getLogger$cp().isLoggable(Level.FINE)) {
                    void var1_2;
                    TaskQueue taskQueue = this;
                    String string = "canceled";
                    AnimationSpecKt.access$log$459af22c((UnicodeSet.XSymbolTable)var1_2, (TaskQueue)taskQueue, (String)string);
                }
                bl = true;
                this.futureTasks.remove((int)var3_4);
            } while (n >= 0);
        }
        return bl;
    }

    public final String toString() {
        return this.name;
    }
}

