/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.concurrent;

import androidx.compose.animation.core.AnimationSpecKt;
import com.ibm.icu.text.UnicodeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.Util;
import okhttp3.internal.concurrent.TaskQueue;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 #2\u00020\u0001:\u0003\"#$B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\rH\u0002J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0018J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0006\u0010\u001c\u001a\u00020\u0016J\u0015\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u001fJ\u0006\u0010 \u001a\u00020\tJ\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lokhttp3/internal/concurrent/TaskRunner;", "", "backend", "Lokhttp3/internal/concurrent/TaskRunner$Backend;", "(Lokhttp3/internal/concurrent/TaskRunner$Backend;)V", "getBackend", "()Lokhttp3/internal/concurrent/TaskRunner$Backend;", "busyQueues", "", "Lokhttp3/internal/concurrent/TaskQueue;", "coordinatorWaiting", "", "coordinatorWakeUpAt", "", "nextQueueName", "", "readyQueues", "runnable", "Ljava/lang/Runnable;", "activeQueues", "", "afterRun", "", "task", "Lokhttp3/internal/concurrent/Task;", "delayNanos", "awaitTaskToRun", "beforeRun", "cancelAll", "kickCoordinator", "taskQueue", "kickCoordinator$okhttp", "newQueue", "runTask", "Backend", "Companion", "RealBackend", "okhttp"})
public final class TaskRunner {
    public static final Companion Companion = new Companion(0);
    private final Backend backend;
    private int nextQueueName;
    private boolean coordinatorWaiting;
    private long coordinatorWakeUpAt;
    private final List<TaskQueue> busyQueues;
    private final List<TaskQueue> readyQueues;
    private final Runnable runnable;
    @JvmField
    public static final TaskRunner INSTANCE = new TaskRunner(new RealBackend(Util.threadFactory(Intrinsics.stringPlus((String)Util.okHttpName, (Object)" TaskRunner"), true)));
    private static final Logger logger;

    /*
     * WARNING - void declaration
     */
    private TaskRunner(Backend backend) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)backend, (String)"backend");
        this.backend = var1_1;
        this.nextQueueName = 10000;
        this.busyQueues = new ArrayList();
        this.readyQueues = new ArrayList();
        this.runnable = new Runnable(this){
            private /* synthetic */ TaskRunner this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final void run() {
                while (true) {
                    long elapsedNs$iv;
                    TaskQueue taskQueue;
                    UnicodeSet.XSymbolTable xSymbolTable;
                    TaskRunner taskRunner = this.this$0;
                    TaskRunner taskRunner2 = this.this$0;
                    TaskRunner taskRunner3 = taskRunner;
                    synchronized (taskRunner3) {
                        xSymbolTable = taskRunner2.awaitTaskToRun$6c3bee25();
                    }
                    UnicodeSet.XSymbolTable xSymbolTable2 = xSymbolTable;
                    if (xSymbolTable2 == null) {
                        return;
                    }
                    UnicodeSet.XSymbolTable task = xSymbolTable2;
                    Intrinsics.checkNotNull((Object)task.getQueue$okhttp());
                    taskRunner = this.this$0;
                    long startNs$iv = -1L;
                    boolean loggingEnabled$iv = TaskRunner.access$getLogger$cp().isLoggable(Level.FINE);
                    if (loggingEnabled$iv) {
                        startNs$iv = taskQueue.getTaskRunner$okhttp().getBackend().nanoTime();
                        AnimationSpecKt.access$log$459af22c((UnicodeSet.XSymbolTable)task, (TaskQueue)taskQueue, (String)"starting");
                    }
                    boolean completedNormally$iv = false;
                    try {
                        try {
                            TaskRunner.access$runTask$b40ead3(taskRunner, task);
                        }
                        catch (Throwable throwable) {
                            taskRunner.getBackend().execute(this);
                            throw throwable;
                        }
                        completedNormally$iv = true;
                        if (!loggingEnabled$iv) continue;
                        elapsedNs$iv = taskQueue.getTaskRunner$okhttp().getBackend().nanoTime() - startNs$iv;
                    }
                    catch (Throwable throwable) {
                        if (!loggingEnabled$iv) throw throwable;
                        long elapsedNs$iv2 = taskQueue.getTaskRunner$okhttp().getBackend().nanoTime() - startNs$iv;
                        if (completedNormally$iv) {
                            AnimationSpecKt.access$log$459af22c((UnicodeSet.XSymbolTable)task, (TaskQueue)taskQueue, (String)Intrinsics.stringPlus((String)"finished run in ", (Object)AnimationSpecKt.formatDuration((long)elapsedNs$iv2)));
                            throw throwable;
                        }
                        AnimationSpecKt.access$log$459af22c((UnicodeSet.XSymbolTable)taskRunner2, (TaskQueue)taskQueue, (String)Intrinsics.stringPlus((String)"failed a run in ", (Object)AnimationSpecKt.formatDuration((long)elapsedNs$iv2)));
                        throw throwable;
                    }
                    AnimationSpecKt.access$log$459af22c((UnicodeSet.XSymbolTable)task, (TaskQueue)taskQueue, (String)Intrinsics.stringPlus((String)"finished run in ", (Object)AnimationSpecKt.formatDuration((long)elapsedNs$iv)));
                }
            }
        };
    }

    public final Backend getBackend() {
        return this.backend;
    }

    /*
     * WARNING - void declaration
     */
    public final void kickCoordinator$okhttp(TaskQueue taskQueue) {
        Intrinsics.checkNotNullParameter((Object)taskQueue, (String)"taskQueue");
        TaskRunner $this$assertThreadHoldsLock$iv = this;
        if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            void var2_2;
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + var2_2));
        }
        if (taskQueue.getActiveTask$okhttp$6c3bee25() == null) {
            if (!((Collection)taskQueue.getFutureTasks$okhttp()).isEmpty()) {
                Util.addIfAbsent(this.readyQueues, taskQueue);
            } else {
                void var1_1;
                this.readyQueues.remove(var1_1);
            }
        }
        if (this.coordinatorWaiting) {
            this.backend.coordinatorNotify(this);
            return;
        }
        this.backend.execute(this.runnable);
    }

    /*
     * WARNING - void declaration
     */
    private final void afterRun$7751fff5(UnicodeSet.XSymbolTable task, long delayNanos) {
        TaskRunner $this$assertThreadHoldsLock$iv = this;
        if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertThreadHoldsLock$iv));
        }
        TaskQueue taskQueue = task.getQueue$okhttp();
        Intrinsics.checkNotNull((Object)taskQueue);
        TaskQueue queue = taskQueue;
        if (!(taskQueue.getActiveTask$okhttp$6c3bee25() == task)) {
            task = "Check failed.";
            throw new IllegalStateException(task.toString());
        }
        boolean cancelActiveTask = queue.getCancelActiveTask$okhttp();
        queue.setCancelActiveTask$okhttp(false);
        queue.setActiveTask$okhttp$468b1d9(null);
        this.busyQueues.remove(queue);
        if (delayNanos != -1L && !cancelActiveTask && !queue.getShutdown$okhttp()) {
            void var2_2;
            void var1_1;
            queue.scheduleAndDecide$okhttp$72ed4bd3((UnicodeSet.XSymbolTable)var1_1, (long)var2_2, true);
        }
        if (!((Collection)queue.getFutureTasks$okhttp()).isEmpty()) {
            this.readyQueues.add(queue);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final UnicodeSet.XSymbolTable awaitTaskToRun$6c3bee25() {
        TaskRunner $this$assertThreadHoldsLock$iv = this;
        if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertThreadHoldsLock$iv));
        }
        while (!this.readyQueues.isEmpty()) {
            void var1_2;
            long now2 = this.backend.nanoTime();
            long minDelayNanos2 = Long.MAX_VALUE;
            UnicodeSet.XSymbolTable readyTask = null;
            boolean multipleReadyTasks = false;
            for (TaskQueue taskQueue : this.readyQueues) {
                UnicodeSet.XSymbolTable candidate = taskQueue.getFutureTasks$okhttp().get(0);
                long l = candidate.getNextExecuteNanoTime$okhttp() - now2;
                long candidateDelay = Math.max(0L, l);
                if (candidateDelay > 0L) {
                    minDelayNanos2 = Math.min(candidateDelay, minDelayNanos2);
                    continue;
                }
                if (readyTask != null) {
                    multipleReadyTasks = true;
                    break;
                }
                readyTask = candidate;
            }
            if (readyTask != null) {
                UnicodeSet.XSymbolTable xSymbolTable = readyTask;
                TaskRunner now2 = this;
                Object minDelayNanos2 = now2;
                if (Util.assertionsEnabled && !Thread.holdsLock(minDelayNanos2)) {
                    throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + minDelayNanos2));
                }
                xSymbolTable.setNextExecuteNanoTime$okhttp(-1L);
                TaskQueue taskQueue = xSymbolTable.getQueue$okhttp();
                Intrinsics.checkNotNull((Object)taskQueue);
                minDelayNanos2 = taskQueue;
                taskQueue.getFutureTasks$okhttp().remove(xSymbolTable);
                now2.readyQueues.remove(minDelayNanos2);
                ((TaskQueue)minDelayNanos2).setActiveTask$okhttp$468b1d9(xSymbolTable);
                now2.busyQueues.add((TaskQueue)minDelayNanos2);
                if (multipleReadyTasks || !this.coordinatorWaiting && !((Collection)this.readyQueues).isEmpty()) {
                    this.backend.execute(this.runnable);
                }
                return readyTask;
            }
            if (this.coordinatorWaiting) {
                if (minDelayNanos2 < this.coordinatorWakeUpAt - now2) {
                    this.backend.coordinatorNotify(this);
                }
                return null;
            }
            this.coordinatorWaiting = true;
            this.coordinatorWakeUpAt = var1_2 + minDelayNanos2;
            try {
                void var3_4;
                this.backend.coordinatorWait(this, (long)var3_4);
                continue;
            }
            catch (InterruptedException interruptedException) {
                this.cancelAll();
                continue;
            }
            finally {
                this.coordinatorWaiting = false;
                continue;
            }
            break;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final TaskQueue newQueue() {
        void var1_2;
        int n;
        TaskRunner taskRunner = this;
        synchronized (taskRunner) {
            n = this.nextQueueName;
            this.nextQueueName = n + 1;
        }
        int name = n;
        return new TaskQueue(this, Intrinsics.stringPlus((String)"Q", (Object)((int)var1_2)));
    }

    /*
     * WARNING - void declaration
     */
    private void cancelAll() {
        int i;
        int n = this.busyQueues.size() - 1;
        if (n >= 0) {
            do {
                i = n--;
                this.busyQueues.get(i).cancelAllAndDecide$okhttp();
            } while (n >= 0);
        }
        if ((n = this.readyQueues.size() - 1) >= 0) {
            do {
                void var2_2;
                void var3_3;
                i = n--;
                TaskQueue queue = this.readyQueues.get(i);
                queue.cancelAllAndDecide$okhttp();
                if (!var3_3.getFutureTasks$okhttp().isEmpty()) continue;
                this.readyQueues.remove((int)var2_2);
            } while (n >= 0);
        }
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$runTask$b40ead3(TaskRunner $this, UnicodeSet.XSymbolTable task) {
        TaskRunner taskRunner;
        long l;
        void var1_2;
        TaskRunner taskRunner2 = $this;
        Object object = taskRunner2;
        if (Util.assertionsEnabled && Thread.holdsLock(object)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + object));
        }
        object = Thread.currentThread();
        String string = ((Thread)object).getName();
        ((Thread)object).setName(var1_2.getName());
        try {
            l = var1_2.runOnce();
            taskRunner = taskRunner2;
        }
        catch (Throwable throwable) {
            TaskRunner taskRunner3 = taskRunner2;
            synchronized (taskRunner3) {
                taskRunner2.afterRun$7751fff5((UnicodeSet.XSymbolTable)var1_2, -1L);
            }
            ((Thread)object).setName(string);
            throw throwable;
        }
        synchronized (taskRunner) {
            taskRunner2.afterRun$7751fff5((UnicodeSet.XSymbolTable)var1_2, l);
        }
        ((Thread)object).setName(string);
    }

    static {
        Logger logger = Logger.getLogger(TaskRunner.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(TaskRunner::class.java.name)");
        TaskRunner.logger = logger;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH&J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH&J\b\u0010\r\u001a\u00020\tH&\u00a8\u0006\u000e"}, d2={"Lokhttp3/internal/concurrent/TaskRunner$Backend;", "", "beforeTask", "", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "coordinatorNotify", "coordinatorWait", "nanos", "", "execute", "runnable", "Ljava/lang/Runnable;", "nanoTime", "okhttp"})
    public static interface Backend {
        public long nanoTime();

        public void coordinatorNotify(TaskRunner var1);

        public void coordinatorWait(TaskRunner var1, long var2);

        public void execute(Runnable var1);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0016J\u0006\u0010\u0013\u001a\u00020\bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lokhttp3/internal/concurrent/TaskRunner$RealBackend;", "Lokhttp3/internal/concurrent/TaskRunner$Backend;", "threadFactory", "Ljava/util/concurrent/ThreadFactory;", "(Ljava/util/concurrent/ThreadFactory;)V", "executor", "Ljava/util/concurrent/ThreadPoolExecutor;", "beforeTask", "", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "coordinatorNotify", "coordinatorWait", "nanos", "", "execute", "runnable", "Ljava/lang/Runnable;", "nanoTime", "shutdown", "okhttp"})
    public static final class RealBackend
    implements Backend {
        private final ThreadPoolExecutor executor;

        /*
         * WARNING - void declaration
         */
        public RealBackend(ThreadFactory threadFactory) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)threadFactory, (String)"threadFactory");
            this.executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)new SynchronousQueue(), (ThreadFactory)var1_1);
        }

        @Override
        public final long nanoTime() {
            return System.nanoTime();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void coordinatorNotify(TaskRunner taskRunner) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)taskRunner, (String)"taskRunner");
            ((Object)var1_1).notify();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void coordinatorWait(TaskRunner taskRunner, long nanos) throws InterruptedException {
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)taskRunner, (String)"taskRunner");
            long ms = nanos / 1000000L;
            long ns = nanos - ms * 1000000L;
            if (ms > 0L || var2_2 > 0L) {
                void var1_1;
                ((Object)var1_1).wait(ms, (int)ns);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void execute(Runnable runnable2) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
            this.executor.execute((Runnable)var1_1);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lokhttp3/internal/concurrent/TaskRunner$Companion;", "", "()V", "INSTANCE", "Lokhttp3/internal/concurrent/TaskRunner;", "logger", "Ljava/util/logging/Logger;", "getLogger", "()Ljava/util/logging/Logger;", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(byte by) {
            this();
        }
    }
}

