/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import androidx.compose.foundation.interaction.DragInteraction;
import androidx.compose.runtime.external.kotlinx.collections.immutable.ExtensionsKt;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.TrieNodeKt;
import androidx.compose.runtime.saveable.ListSaverKt;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Address;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.CertificatePinner;
import okhttp3.EventListener;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;
import okhttp3.internal.cache.CacheInterceptor;
import okhttp3.internal.connection.ConnectInterceptor;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.http.BridgeInterceptor;
import okhttp3.internal.http.CallServerInterceptor;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.RetryAndFollowUpInterceptor;
import okhttp3.internal.platform.Platform;
import okio.AsyncTimeout;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a7\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006*\u0001.\u0018\u00002\u00020\u0001:\u0002deB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u00101\u001a\u0002022\u0006\u0010\u0010\u001a\u00020\u000fJ!\u00103\u001a\u0002H4\"\n\b\u0000\u00104*\u0004\u0018\u0001052\u0006\u00106\u001a\u0002H4H\u0002\u00a2\u0006\u0002\u00107J\b\u00108\u001a\u000202H\u0002J\b\u00109\u001a\u000202H\u0016J\b\u0010:\u001a\u00020\u0000H\u0016J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0002J\u0010\u0010?\u001a\u0002022\u0006\u0010@\u001a\u00020AH\u0016J\u0016\u0010B\u001a\u0002022\u0006\u0010C\u001a\u00020\u00052\u0006\u0010D\u001a\u00020\u0007J\b\u0010E\u001a\u00020FH\u0016J\u0015\u0010G\u001a\u0002022\u0006\u0010H\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\bIJ\r\u0010J\u001a\u00020FH\u0000\u00a2\u0006\u0002\bKJ\u0015\u0010L\u001a\u00020\u001e2\u0006\u0010M\u001a\u00020NH\u0000\u00a2\u0006\u0002\bOJ\b\u0010P\u001a\u00020\u0007H\u0016J\b\u0010Q\u001a\u00020\u0007H\u0016J;\u0010R\u001a\u0002H4\"\n\b\u0000\u00104*\u0004\u0018\u0001052\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010S\u001a\u00020\u00072\u0006\u0010T\u001a\u00020\u00072\u0006\u00106\u001a\u0002H4H\u0000\u00a2\u0006\u0004\bU\u0010VJ\u0019\u0010W\u001a\u0004\u0018\u0001052\b\u00106\u001a\u0004\u0018\u000105H\u0000\u00a2\u0006\u0002\bXJ\r\u0010Y\u001a\u00020ZH\u0000\u00a2\u0006\u0002\b[J\u000f\u0010\\\u001a\u0004\u0018\u00010]H\u0000\u00a2\u0006\u0002\b^J\b\u0010C\u001a\u00020\u0005H\u0016J\u0006\u0010_\u001a\u00020\u0007J\b\u0010-\u001a\u00020`H\u0016J\u0006\u00100\u001a\u000202J!\u0010a\u001a\u0002H4\"\n\b\u0000\u00104*\u0004\u0018\u0001052\u0006\u0010b\u001a\u0002H4H\u0002\u00a2\u0006\u0002\u00107J\b\u0010c\u001a\u00020ZH\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\"\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\"\u0010&\u001a\u0004\u0018\u00010\u001e2\b\u0010\u000e\u001a\u0004\u0018\u00010\u001e@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010/R\u000e\u00100\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006f"}, d2={"Lokhttp3/internal/connection/RealCall;", "Lokhttp3/Call;", "client", "Lokhttp3/OkHttpClient;", "originalRequest", "Lokhttp3/Request;", "forWebSocket", "", "(Lokhttp3/OkHttpClient;Lokhttp3/Request;Z)V", "callStackTrace", "", "canceled", "getClient", "()Lokhttp3/OkHttpClient;", "<set-?>", "Lokhttp3/internal/connection/RealConnection;", "connection", "getConnection", "()Lokhttp3/internal/connection/RealConnection;", "connectionPool", "Lokhttp3/internal/connection/RealConnectionPool;", "connectionToCancel", "getConnectionToCancel", "setConnectionToCancel", "(Lokhttp3/internal/connection/RealConnection;)V", "eventListener", "Lokhttp3/EventListener;", "getEventListener$okhttp", "()Lokhttp3/EventListener;", "exchange", "Lokhttp3/internal/connection/Exchange;", "exchangeFinder", "Lokhttp3/internal/connection/ExchangeFinder;", "executed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "expectMoreExchanges", "getForWebSocket", "()Z", "interceptorScopedExchange", "getInterceptorScopedExchange$okhttp", "()Lokhttp3/internal/connection/Exchange;", "getOriginalRequest", "()Lokhttp3/Request;", "requestBodyOpen", "responseBodyOpen", "timeout", "okhttp3/internal/connection/RealCall$timeout$1", "Lokhttp3/internal/connection/RealCall$timeout$1;", "timeoutEarlyExit", "acquireConnectionNoEvents", "", "callDone", "E", "Ljava/io/IOException;", "e", "(Ljava/io/IOException;)Ljava/io/IOException;", "callStart", "cancel", "clone", "createAddress", "Lokhttp3/Address;", "url", "Lokhttp3/HttpUrl;", "enqueue", "responseCallback", "Lokhttp3/Callback;", "enterNetworkInterceptorExchange", "request", "newExchangeFinder", "execute", "Lokhttp3/Response;", "exitNetworkInterceptorExchange", "closeExchange", "exitNetworkInterceptorExchange$okhttp", "getResponseWithInterceptorChain", "getResponseWithInterceptorChain$okhttp", "initExchange", "chain", "Lokhttp3/internal/http/RealInterceptorChain;", "initExchange$okhttp", "isCanceled", "isExecuted", "messageDone", "requestDone", "responseDone", "messageDone$okhttp", "(Lokhttp3/internal/connection/Exchange;ZZLjava/io/IOException;)Ljava/io/IOException;", "noMoreExchanges", "noMoreExchanges$okhttp", "redactedUrl", "", "redactedUrl$okhttp", "releaseConnectionNoEvents", "Ljava/net/Socket;", "releaseConnectionNoEvents$okhttp", "retryAfterFailure", "Lokio/AsyncTimeout;", "timeoutExit", "cause", "toLoggableString", "AsyncCall", "CallReference", "okhttp"})
public final class RealCall
implements Call {
    private final OkHttpClient client;
    private final Request originalRequest;
    private final boolean forWebSocket;
    private final RealConnectionPool connectionPool;
    private final EventListener eventListener;
    private final timeout.1 timeout;
    private final AtomicBoolean executed;
    private Object callStackTrace;
    private TrieNodeKt exchangeFinder$1e566719;
    private RealConnection connection;
    private boolean timeoutEarlyExit;
    private Exchange interceptorScopedExchange;
    private boolean requestBodyOpen;
    private boolean responseBodyOpen;
    private boolean expectMoreExchanges;
    private volatile boolean canceled;
    private volatile Exchange exchange;
    private volatile RealConnection connectionToCancel;

    /*
     * WARNING - void declaration
     */
    public RealCall(OkHttpClient client, Request originalRequest, boolean forWebSocket) {
        RealCall realCall;
        void var3_3;
        AsyncTimeout asyncTimeout;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)originalRequest, (String)"originalRequest");
        this.client = asyncTimeout;
        this.originalRequest = originalRequest;
        this.forWebSocket = var3_3;
        this.connectionPool = this.client.connectionPool$5b098db6().getDelegate$okhttp();
        this.eventListener = this.client.eventListenerFactory().create(this);
        AsyncTimeout $this$timeout_u24lambda_u2d0 = asyncTimeout = new AsyncTimeout(this){
            private /* synthetic */ RealCall this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            protected final void timedOut() {
                this.this$0.cancel();
            }
        };
        RealCall realCall2 = this;
        void v0 = realCall;
        realCall = this;
        v0.timeout((long)realCall.client.callTimeoutMillis(), TimeUnit.MILLISECONDS);
        realCall2.timeout = asyncTimeout;
        this.executed = new AtomicBoolean();
        this.expectMoreExchanges = true;
    }

    public final OkHttpClient getClient() {
        return this.client;
    }

    public final Request getOriginalRequest() {
        return this.originalRequest;
    }

    public final boolean getForWebSocket() {
        return this.forWebSocket;
    }

    public final EventListener getEventListener$okhttp() {
        return this.eventListener;
    }

    public final RealConnection getConnection() {
        return this.connection;
    }

    public final Exchange getInterceptorScopedExchange$okhttp() {
        return this.interceptorScopedExchange;
    }

    /*
     * WARNING - void declaration
     */
    public final void setConnectionToCancel(RealConnection realConnection) {
        void var1_1;
        this.connectionToCancel = var1_1;
    }

    @Override
    public final Request request() {
        return this.originalRequest;
    }

    @Override
    public final void cancel() {
        if (this.canceled) {
            return;
        }
        this.canceled = true;
        Exchange exchange = this.exchange;
        if (exchange != null) {
            exchange.cancel();
        }
        RealConnection realConnection = this.connectionToCancel;
        if (realConnection != null) {
            realConnection.cancel();
        }
        EventListener.canceled(this);
    }

    @Override
    public final boolean isCanceled() {
        return this.canceled;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void enqueue(Callback responseCallback) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)responseCallback, (String)"responseCallback");
        if (!this.executed.compareAndSet(false, true)) {
            responseCallback = "Already Executed";
            throw new IllegalStateException(responseCallback.toString());
        }
        RealCall realCall = this;
        this.callStackTrace = Platform.access$getPlatform$cp().getStackTraceForCloseable("response.body().close()");
        EventListener.callStart(realCall);
        this.client.dispatcher$3783a349().enqueue$okhttp(new AsyncCall(this, (Callback)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final Response getResponseWithInterceptorChain$okhttp() throws IOException {
        Response response;
        List interceptors = new ArrayList();
        CollectionsKt.addAll((Collection)interceptors, (Iterable)this.client.interceptors());
        ((Collection)interceptors).add(new RetryAndFollowUpInterceptor(this.client));
        ((Collection)interceptors).add(new BridgeInterceptor(this.client.cookieJar()));
        ((Collection)interceptors).add(new CacheInterceptor(this.client.cache()));
        ((Collection)interceptors).add(ConnectInterceptor.INSTANCE);
        if (!this.forWebSocket) {
            CollectionsKt.addAll((Collection)interceptors, (Iterable)this.client.networkInterceptors());
        }
        ((Collection)interceptors).add(new CallServerInterceptor(this.forWebSocket));
        ListSaverKt chain = new ListSaverKt(this, interceptors, 0, null, this.originalRequest, this.client.connectTimeoutMillis(), this.client.readTimeoutMillis(), this.client.writeTimeoutMillis());
        boolean calledNoMoreExchanges = false;
        try {
            response = chain.proceed(this.originalRequest);
            RealCall realCall = this;
            if (realCall.canceled) {
                Util.closeQuietly(response);
                throw new IOException("Canceled");
            }
            this.noMoreExchanges$okhttp(null);
        }
        catch (IOException e) {
            try {
                void var1_2;
                calledNoMoreExchanges = true;
                IOException iOException = this.noMoreExchanges$okhttp((IOException)var1_2);
                if (iOException == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Throwable");
                }
                throw (Throwable)iOException;
            }
            catch (Throwable throwable) {
                void var2_4;
                if (var2_4 == false) {
                    this.noMoreExchanges$okhttp(null);
                }
                throw throwable;
            }
        }
        return response;
    }

    /*
     * WARNING - void declaration
     */
    public final void enterNetworkInterceptorExchange(Request request, boolean newExchangeFinder) {
        void var2_3;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!(this.interceptorScopedExchange == null)) {
            request = "Check failed.";
            throw new IllegalStateException(request.toString());
        }
        Object object = this;
        synchronized (object) {
            if (!(!this.responseBodyOpen)) {
                request = "cannot make a new request because the previous response is still open: please call response.close()";
                throw new IllegalStateException(request.toString());
            }
            if (!(!this.requestBodyOpen)) {
                request = "Check failed.";
                throw new IllegalStateException(request.toString());
            }
        }
        if (var2_3 != false) {
            RealCall realCall;
            HttpUrl httpUrl = ((Request)((Object)realCall)).url();
            realCall = this;
            object = null;
            HostnameVerifier hostnameVerifier = null;
            CertificatePinner certificatePinner = null;
            if (httpUrl.isHttps()) {
                object = realCall.client.sslSocketFactory();
                hostnameVerifier = realCall.client.hostnameVerifier();
                certificatePinner = realCall.client.certificatePinner();
            }
            RealCall realCall2 = this;
            this.exchangeFinder$1e566719 = new TrieNodeKt(this.connectionPool, new Address(httpUrl.host(), httpUrl.port(), realCall.client.dns(), realCall.client.socketFactory(), (SSLSocketFactory)object, hostnameVerifier, certificatePinner, realCall.client.proxyAuthenticator(), realCall.client.proxy(), realCall.client.protocols(), realCall.client.connectionSpecs(), realCall.client.proxySelector()), realCall2, realCall2.eventListener);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Exchange initExchange$okhttp$4cf9396e(ListSaverKt chain) {
        void var1_1;
        Exchange result;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        RealCall realCall = this;
        synchronized (realCall) {
            if (!this.expectMoreExchanges) {
                String string = "released";
                throw new IllegalStateException(string.toString());
            }
            if (!(!this.responseBodyOpen)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            if (!(!this.requestBodyOpen)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
        }
        TrieNodeKt trieNodeKt = this.exchangeFinder$1e566719;
        Intrinsics.checkNotNull((Object)trieNodeKt);
        TrieNodeKt exchangeFinder = trieNodeKt;
        ExchangeCodec codec = trieNodeKt.find$55b10e78(this.client, chain);
        RealCall realCall2 = this;
        this.interceptorScopedExchange = result = new Exchange(realCall2, realCall2.eventListener, (TrieNodeKt)realCall, codec);
        this.exchange = result;
        RealCall realCall3 = this;
        synchronized (realCall3) {
            this.requestBodyOpen = true;
            this.responseBodyOpen = true;
        }
        if (this.canceled) {
            throw new IOException("Canceled");
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void acquireConnectionNoEvents(RealConnection connection) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        RealConnection $this$assertThreadHoldsLock$iv = connection;
        if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            void var2_2;
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + var2_2));
        }
        if (!(this.connection == null)) {
            connection = "Check failed.";
            throw new IllegalStateException(connection.toString());
        }
        this.connection = connection;
        RealCall realCall = this;
        var1_1.getCalls().add(new CallReference(realCall, realCall.callStackTrace));
    }

    /*
     * WARNING - void declaration
     */
    public final <E extends IOException> E messageDone$okhttp(Exchange exchange, boolean requestDone, boolean responseDone, E e) {
        void var1_2;
        Intrinsics.checkNotNullParameter((Object)exchange, (String)"exchange");
        if (!Intrinsics.areEqual((Object)exchange, (Object)this.exchange)) {
            return e;
        }
        boolean bothStreamsDone = false;
        boolean callDone = false;
        RealCall realCall = this;
        synchronized (realCall) {
            if (requestDone && this.requestBodyOpen || responseDone && this.responseBodyOpen) {
                void var3_5;
                void var2_4;
                if (var2_4 != false) {
                    this.requestBodyOpen = false;
                }
                if (var3_5 != false) {
                    this.responseBodyOpen = false;
                }
                bothStreamsDone = !this.requestBodyOpen && !this.responseBodyOpen;
                callDone = !this.requestBodyOpen && !this.responseBodyOpen && !this.expectMoreExchanges;
            }
        }
        if (var1_2 != false) {
            this.exchange = null;
            RealConnection realConnection = this.connection;
            if (realConnection != null) {
                realConnection.incrementSuccessCount$okhttp();
            }
        }
        if (callDone) {
            return this.callDone(e);
        }
        return e;
    }

    /*
     * WARNING - void declaration
     */
    public final IOException noMoreExchanges$okhttp(IOException e) {
        void var1_1;
        void var2_3;
        boolean callDone = false;
        RealCall realCall = this;
        synchronized (realCall) {
            if (this.expectMoreExchanges) {
                this.expectMoreExchanges = false;
                callDone = !this.requestBodyOpen && !this.responseBodyOpen;
            }
        }
        if (var2_3 != false) {
            return this.callDone(e);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private final <E extends IOException> E callDone(E e) {
        void var3_3;
        void var1_1;
        E result;
        Object object;
        Object object2;
        Object socket;
        RealCall $this$assertThreadDoesntHoldLock$iv = this;
        if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
        }
        RealConnection connection = this.connection;
        if (connection != null) {
            Object object3;
            RealConnection $this$assertThreadDoesntHoldLock$iv2 = connection;
            if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv2)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv2));
            }
            $this$assertThreadDoesntHoldLock$iv2 = connection;
            synchronized ($this$assertThreadDoesntHoldLock$iv2) {
                object3 = this.releaseConnectionNoEvents$okhttp();
            }
            socket = object3;
            if (this.connection == null) {
                Object object4 = socket;
                if (object4 != null) {
                    Util.closeQuietly(object4);
                }
                EventListener.connectionReleased$295518d7(this, (DragInteraction)object2);
            } else if (!(socket == null)) {
                object3 = "Check failed.";
                throw new IllegalStateException(object3.toString());
            }
        }
        socket = e;
        object2 = this;
        if (object2.timeoutEarlyExit) {
            object = socket;
        } else {
            object2 = object2.timeout;
            if (!AsyncTimeout.Companion.access$cancelScheduledTimeout((AsyncTimeout.Companion)AsyncTimeout.Companion, (AsyncTimeout)object2)) {
                object = socket;
            } else {
                object2 = new InterruptedIOException("timeout");
                if (socket != null) {
                    ((Throwable)object2).initCause((Throwable)socket);
                }
                object = result = (IOException)object2;
            }
        }
        if (var1_1 != null) {
            Call call = this;
            E e2 = result;
            Intrinsics.checkNotNull(e2);
            EventListener.callFailed(call, e2);
        } else {
            EventListener.callEnd(this);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final Socket releaseConnectionNoEvents$okhttp() {
        void var2_2;
        void var3_4;
        int n;
        List<Reference<RealCall>> calls;
        Object connection;
        block6: {
            int index;
            RealConnection realConnection = this.connection;
            Intrinsics.checkNotNull((Object)realConnection);
            connection = realConnection;
            RealConnection $this$assertThreadHoldsLock$iv = realConnection;
            if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertThreadHoldsLock$iv));
            }
            calls = ((RealConnection)connection).getCalls();
            Object $this$indexOfFirst$iv = calls;
            int index$iv = 0;
            $this$indexOfFirst$iv = $this$indexOfFirst$iv.iterator();
            while ($this$indexOfFirst$iv.hasNext()) {
                Object object = $this$indexOfFirst$iv.next();
                if (Intrinsics.areEqual(((Reference)(object = (Reference)object)).get(), (Object)this)) {
                    n = index$iv;
                    break block6;
                }
                ++index$iv;
            }
            n = index = -1;
        }
        if (!(n != -1)) {
            connection = "Check failed.";
            throw new IllegalStateException(connection.toString());
        }
        calls.remove((int)var3_4);
        this.connection = null;
        if (var2_2.isEmpty()) {
            ((RealConnection)connection).setIdleAtNs$okhttp(System.nanoTime());
            if (this.connectionPool.connectionBecameIdle((RealConnection)connection)) {
                void var1_1;
                return var1_1.socket();
            }
        }
        return null;
    }

    public final void timeoutEarlyExit() {
        if (!(!this.timeoutEarlyExit)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.timeoutEarlyExit = true;
        timeout.1 var1_2 = this.timeout;
        AsyncTimeout.Companion.access$cancelScheduledTimeout((AsyncTimeout.Companion)AsyncTimeout.Companion, (AsyncTimeout)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void exitNetworkInterceptorExchange$okhttp(boolean closeExchange2) {
        void var1_1;
        RealCall realCall = this;
        synchronized (realCall) {
            if (!this.expectMoreExchanges) {
                String closeExchange2 = "released";
                throw new IllegalStateException(closeExchange2.toString());
            }
        }
        if (var1_1 != false) {
            Exchange exchange = this.exchange;
            if (exchange != null) {
                exchange.detachWithViolence();
            }
        }
        this.interceptorScopedExchange = null;
    }

    public final boolean retryAfterFailure() {
        TrieNodeKt trieNodeKt = this.exchangeFinder$1e566719;
        Intrinsics.checkNotNull((Object)trieNodeKt);
        return trieNodeKt.retryAfterFailure();
    }

    public final String redactedUrl$okhttp() {
        return this.originalRequest.url().redact();
    }

    public static final /* synthetic */ String access$toLoggableString(RealCall $this) {
        RealCall realCall = $this;
        RealCall realCall2 = realCall;
        return (realCall2.canceled ? "canceled " : "") + (realCall.forWebSocket ? "web socket" : "call") + " to " + realCall.redactedUrl$okhttp();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0080\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0012\u0010\u001a\u001a\u00020\u00172\n\u0010\u001b\u001a\u00060\u0000R\u00020\u0006J\b\u0010\u001c\u001a\u00020\u0017H\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lokhttp3/internal/connection/RealCall$AsyncCall;", "Ljava/lang/Runnable;", "responseCallback", "Lokhttp3/Callback;", "(Lokhttp3/internal/connection/RealCall;Lokhttp3/Callback;)V", "call", "Lokhttp3/internal/connection/RealCall;", "getCall", "()Lokhttp3/internal/connection/RealCall;", "<set-?>", "Ljava/util/concurrent/atomic/AtomicInteger;", "callsPerHost", "getCallsPerHost", "()Ljava/util/concurrent/atomic/AtomicInteger;", "host", "", "getHost", "()Ljava/lang/String;", "request", "Lokhttp3/Request;", "getRequest", "()Lokhttp3/Request;", "executeOn", "", "executorService", "Ljava/util/concurrent/ExecutorService;", "reuseCallsPerHostFrom", "other", "run", "okhttp"})
    public final class AsyncCall
    implements Runnable {
        private final Callback responseCallback;
        private volatile AtomicInteger callsPerHost;
        private /* synthetic */ RealCall this$0;

        /*
         * WARNING - void declaration
         */
        public AsyncCall(RealCall this$0, Callback responseCallback) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)responseCallback, (String)"responseCallback");
            this.this$0 = var1_1;
            this.responseCallback = var2_2;
            this.callsPerHost = new AtomicInteger(0);
        }

        public final AtomicInteger getCallsPerHost() {
            return this.callsPerHost;
        }

        /*
         * WARNING - void declaration
         */
        public final void reuseCallsPerHostFrom(AsyncCall other) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            this.callsPerHost = var1_1.callsPerHost;
        }

        public final String getHost() {
            return this.this$0.getOriginalRequest().url().host();
        }

        public final RealCall getCall() {
            return this.this$0;
        }

        /*
         * WARNING - void declaration
         */
        public final void executeOn(ExecutorService executorService) {
            Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
            ExtensionsKt $this$assertThreadDoesntHoldLock$iv = this.this$0.getClient().dispatcher$3783a349();
            if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
            }
            try {
                try {
                    executorService.execute(this);
                    return;
                }
                catch (RejectedExecutionException e) {
                    void var2_4;
                    void var1_2;
                    InterruptedIOException ioException = new InterruptedIOException("executor rejected");
                    ioException.initCause((Throwable)var1_2);
                    this.this$0.noMoreExchanges$okhttp(ioException);
                    this.responseCallback.onFailure$1b4f1832((IOException)var2_4);
                    return;
                }
            }
            finally {
                this.this$0.getClient().dispatcher$3783a349().finished$okhttp(this);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void run() {
            void name$iv;
            String string = Intrinsics.stringPlus((String)"OkHttp ", (Object)this.this$0.redactedUrl$okhttp());
            RealCall realCall = this.this$0;
            Thread currentThread$iv = Thread.currentThread();
            String oldName$iv = currentThread$iv.getName();
            currentThread$iv.setName((String)name$iv);
            try {
                boolean signalledCallback = false;
                realCall.timeout.enter();
                try {
                    Response response = realCall.getResponseWithInterceptorChain$okhttp();
                    signalledCallback = true;
                    this.responseCallback.onResponse$42f4142c(response);
                }
                catch (IOException e) {
                    if (signalledCallback) {
                        Platform.access$getPlatform$cp();
                        Platform.log(Intrinsics.stringPlus((String)"Callback failure for ", (Object)RealCall.access$toLoggableString(realCall)), 4, e);
                    } else {
                        this.responseCallback.onFailure$1b4f1832(e);
                    }
                }
                catch (Throwable t) {
                    realCall.cancel();
                    if (!signalledCallback) {
                        void var1_3;
                        IOException canceledException = new IOException(Intrinsics.stringPlus((String)"canceled due to ", (Object)t));
                        ExceptionsKt.addSuppressed((Throwable)canceledException, (Throwable)t);
                        this.responseCallback.onFailure$1b4f1832((IOException)var1_3);
                    }
                    throw t;
                }
                finally {
                    realCall.getClient().dispatcher$3783a349().finished$okhttp(this);
                }
                currentThread$iv.setName(oldName$iv);
                return;
            }
            catch (Throwable throwable) {
                void var3_6;
                var3_6.setName(oldName$iv);
                throw throwable;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lokhttp3/internal/connection/RealCall$CallReference;", "Ljava/lang/ref/WeakReference;", "Lokhttp3/internal/connection/RealCall;", "referent", "callStackTrace", "", "(Lokhttp3/internal/connection/RealCall;Ljava/lang/Object;)V", "getCallStackTrace", "()Ljava/lang/Object;", "okhttp"})
    public static final class CallReference
    extends WeakReference<RealCall> {
        private final Object callStackTrace;

        /*
         * WARNING - void declaration
         */
        public CallReference(RealCall referent, Object callStackTrace) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)referent, (String)"referent");
            super(var1_1);
            this.callStackTrace = var2_2;
        }

        public final Object getCallStackTrace() {
            return this.callStackTrace;
        }
    }
}

