/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import androidx.compose.foundation.interaction.DragInteraction;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.UtilsKt;
import androidx.compose.runtime.saveable.ListSaverKt;
import java.io.IOException;
import java.lang.ref.Reference;
import java.net.ConnectException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownServiceException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Address;
import okhttp3.Call;
import okhttp3.CertificatePinner;
import okhttp3.ConnectionSpec;
import okhttp3.EventListener;
import okhttp3.Handshake;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.internal.Util;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.connection.RouteException;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http1.Http1ExchangeCodec;
import okhttp3.internal.http2.ConnectionShutdownException;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Http2Connection;
import okhttp3.internal.http2.Http2ExchangeCodec;
import okhttp3.internal.http2.Http2Stream;
import okhttp3.internal.http2.Settings;
import okhttp3.internal.http2.StreamResetException;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.tls.OkHostnameVerifier;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00ec\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 {2\u00020\u00012\u00020\u0002:\u0001{B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u00105\u001a\u000206J\u0018\u00107\u001a\u00020\u001d2\u0006\u00108\u001a\u0002092\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J>\u0010:\u001a\u0002062\u0006\u0010;\u001a\u00020\t2\u0006\u0010<\u001a\u00020\t2\u0006\u0010=\u001a\u00020\t2\u0006\u0010>\u001a\u00020\t2\u0006\u0010?\u001a\u00020\u001d2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CJ%\u0010D\u001a\u0002062\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020\u00062\u0006\u0010H\u001a\u00020IH\u0000\u00a2\u0006\u0002\bJJ(\u0010K\u001a\u0002062\u0006\u0010;\u001a\u00020\t2\u0006\u0010<\u001a\u00020\t2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0002J\u0010\u0010L\u001a\u0002062\u0006\u0010M\u001a\u00020NH\u0002J0\u0010O\u001a\u0002062\u0006\u0010;\u001a\u00020\t2\u0006\u0010<\u001a\u00020\t2\u0006\u0010=\u001a\u00020\t2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0002J*\u0010P\u001a\u0004\u0018\u00010Q2\u0006\u0010<\u001a\u00020\t2\u0006\u0010=\u001a\u00020\t2\u0006\u0010R\u001a\u00020Q2\u0006\u00108\u001a\u000209H\u0002J\b\u0010S\u001a\u00020QH\u0002J(\u0010T\u001a\u0002062\u0006\u0010M\u001a\u00020N2\u0006\u0010>\u001a\u00020\t2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0002J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\r\u0010U\u001a\u000206H\u0000\u00a2\u0006\u0002\bVJ%\u0010W\u001a\u00020\u001d2\u0006\u0010X\u001a\u00020Y2\u000e\u0010Z\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010[H\u0000\u00a2\u0006\u0002\b\\J\u000e\u0010]\u001a\u00020\u001d2\u0006\u0010^\u001a\u00020\u001dJ\u001d\u0010_\u001a\u00020`2\u0006\u0010E\u001a\u00020F2\u0006\u0010a\u001a\u00020bH\u0000\u00a2\u0006\u0002\bcJ\u0015\u0010d\u001a\u00020e2\u0006\u0010f\u001a\u00020gH\u0000\u00a2\u0006\u0002\bhJ\r\u0010 \u001a\u000206H\u0000\u00a2\u0006\u0002\biJ\r\u0010!\u001a\u000206H\u0000\u00a2\u0006\u0002\bjJ\u0018\u0010k\u001a\u0002062\u0006\u0010l\u001a\u00020\u00152\u0006\u0010m\u001a\u00020nH\u0016J\u0010\u0010o\u001a\u0002062\u0006\u0010p\u001a\u00020qH\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010r\u001a\u00020\u001d2\f\u0010s\u001a\b\u0012\u0004\u0012\u00020\u00060[H\u0002J\b\u00101\u001a\u00020(H\u0016J\u0010\u0010t\u001a\u0002062\u0006\u0010>\u001a\u00020\tH\u0002J\u0010\u0010u\u001a\u00020\u001d2\u0006\u00108\u001a\u000209H\u0002J\b\u0010v\u001a\u00020wH\u0016J\u001f\u0010x\u001a\u0002062\u0006\u0010@\u001a\u00020\r2\b\u0010y\u001a\u0004\u0018\u00010IH\u0000\u00a2\u0006\u0002\bzR\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0017X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001d8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001f\"\u0004\b#\u0010$R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010*\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u0010\u0010/\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00102\u001a\u0004\u0018\u000103X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006|"}, d2={"Lokhttp3/internal/connection/RealConnection;", "Lokhttp3/internal/http2/Http2Connection$Listener;", "Lokhttp3/Connection;", "connectionPool", "Lokhttp3/internal/connection/RealConnectionPool;", "route", "Lokhttp3/Route;", "(Lokhttp3/internal/connection/RealConnectionPool;Lokhttp3/Route;)V", "allocationLimit", "", "calls", "", "Ljava/lang/ref/Reference;", "Lokhttp3/internal/connection/RealCall;", "getCalls", "()Ljava/util/List;", "getConnectionPool", "()Lokhttp3/internal/connection/RealConnectionPool;", "handshake", "Lokhttp3/Handshake;", "http2Connection", "Lokhttp3/internal/http2/Http2Connection;", "idleAtNs", "", "getIdleAtNs$okhttp", "()J", "setIdleAtNs$okhttp", "(J)V", "isMultiplexed", "", "isMultiplexed$okhttp", "()Z", "noCoalescedConnections", "noNewExchanges", "getNoNewExchanges", "setNoNewExchanges", "(Z)V", "protocol", "Lokhttp3/Protocol;", "rawSocket", "Ljava/net/Socket;", "refusedStreamCount", "routeFailureCount", "getRouteFailureCount$okhttp", "()I", "setRouteFailureCount$okhttp", "(I)V", "sink", "Lokio/BufferedSink;", "socket", "source", "Lokio/BufferedSource;", "successCount", "cancel", "", "certificateSupportHost", "url", "Lokhttp3/HttpUrl;", "connect", "connectTimeout", "readTimeout", "writeTimeout", "pingIntervalMillis", "connectionRetryEnabled", "call", "Lokhttp3/Call;", "eventListener", "Lokhttp3/EventListener;", "connectFailed", "client", "Lokhttp3/OkHttpClient;", "failedRoute", "failure", "Ljava/io/IOException;", "connectFailed$okhttp", "connectSocket", "connectTls", "connectionSpecSelector", "Lokhttp3/internal/connection/ConnectionSpecSelector;", "connectTunnel", "createTunnel", "Lokhttp3/Request;", "tunnelRequest", "createTunnelRequest", "establishProtocol", "incrementSuccessCount", "incrementSuccessCount$okhttp", "isEligible", "address", "Lokhttp3/Address;", "routes", "", "isEligible$okhttp", "isHealthy", "doExtensiveChecks", "newCodec", "Lokhttp3/internal/http/ExchangeCodec;", "chain", "Lokhttp3/internal/http/RealInterceptorChain;", "newCodec$okhttp", "newWebSocketStreams", "Lokhttp3/internal/ws/RealWebSocket$Streams;", "exchange", "Lokhttp3/internal/connection/Exchange;", "newWebSocketStreams$okhttp", "noCoalescedConnections$okhttp", "noNewExchanges$okhttp", "onSettings", "connection", "settings", "Lokhttp3/internal/http2/Settings;", "onStream", "stream", "Lokhttp3/internal/http2/Http2Stream;", "routeMatchesAny", "candidates", "startHttp2", "supportsUrl", "toString", "", "trackFailure", "e", "trackFailure$okhttp", "Companion", "okhttp"})
public final class RealConnection
extends Http2Connection.Listener
implements DragInteraction {
    private final Route route;
    private Socket rawSocket;
    private Socket socket;
    private Handshake handshake;
    private Protocol protocol;
    private Http2Connection http2Connection;
    private BufferedSource source;
    private BufferedSink sink;
    private boolean noNewExchanges;
    private boolean noCoalescedConnections;
    private int routeFailureCount;
    private int successCount;
    private int refusedStreamCount;
    private int allocationLimit;
    private final List<Reference<RealCall>> calls;
    private long idleAtNs;

    /*
     * WARNING - void declaration
     */
    public RealConnection(RealConnectionPool connectionPool, Route route) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)connectionPool, (String)"connectionPool");
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        this.route = var2_2;
        this.allocationLimit = 1;
        this.calls = new ArrayList();
        this.idleAtNs = Long.MAX_VALUE;
    }

    public final boolean getNoNewExchanges() {
        return this.noNewExchanges;
    }

    public final void setNoNewExchanges(boolean bl) {
        this.noNewExchanges = true;
    }

    public final int getRouteFailureCount$okhttp() {
        return this.routeFailureCount;
    }

    public final List<Reference<RealCall>> getCalls() {
        return this.calls;
    }

    public final long getIdleAtNs$okhttp() {
        return this.idleAtNs;
    }

    /*
     * WARNING - void declaration
     */
    public final void setIdleAtNs$okhttp(long l) {
        void var1_1;
        this.idleAtNs = var1_1;
    }

    public final boolean isMultiplexed$okhttp() {
        return this.http2Connection != null;
    }

    public final synchronized void noNewExchanges$okhttp() {
        this.noNewExchanges = true;
    }

    public final synchronized void noCoalescedConnections$okhttp() {
        this.noCoalescedConnections = true;
    }

    public final synchronized void incrementSuccessCount$okhttp() {
        int n = this.successCount;
        this.successCount = n + 1;
    }

    public final void connect(int connectTimeout, int readTimeout, int writeTimeout, int pingIntervalMillis, boolean connectionRetryEnabled, Call call, EventListener eventListener) {
        Object host;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)eventListener, (String)"eventListener");
        if (!(this.protocol == null)) {
            String string = "already connected";
            throw new IllegalStateException(string.toString());
        }
        RouteException routeException = null;
        List<ConnectionSpec> connectionSpecs = this.route.address().connectionSpecs();
        UtilsKt connectionSpecSelector = new UtilsKt(connectionSpecs);
        if (this.route.address().sslSocketFactory() == null) {
            if (!connectionSpecs.contains(ConnectionSpec.CLEARTEXT)) {
                throw new RouteException(new UnknownServiceException("CLEARTEXT communication not enabled for client"));
            }
            host = this.route.address().url().host();
            if (!Platform.access$getPlatform$cp().isCleartextTrafficPermitted((String)host)) {
                throw new RouteException(new UnknownServiceException("CLEARTEXT communication to " + (String)host + " not permitted by network security policy"));
            }
        } else if (this.route.address().protocols().contains((Object)Protocol.H2_PRIOR_KNOWLEDGE)) {
            throw new RouteException(new UnknownServiceException("H2_PRIOR_KNOWLEDGE cannot be used with HTTPS"));
        }
        while (true) {
            try {
                if (this.route.requiresTunnel()) {
                    this.connectTunnel(connectTimeout, readTimeout, writeTimeout, call, eventListener);
                    if (this.rawSocket == null) {
                        break;
                    }
                } else {
                    this.connectSocket(connectTimeout, readTimeout, call, eventListener);
                }
                host = eventListener;
                Call call2 = call;
                int n = pingIntervalMillis;
                UtilsKt utilsKt = connectionSpecSelector;
                host = this;
                if (((RealConnection)host).route.address().sslSocketFactory() == null) {
                    if (((RealConnection)host).route.address().protocols().contains((Object)Protocol.H2_PRIOR_KNOWLEDGE)) {
                        ((RealConnection)host).socket = ((RealConnection)host).rawSocket;
                        ((RealConnection)host).protocol = Protocol.H2_PRIOR_KNOWLEDGE;
                        super.startHttp2(n);
                    } else {
                        ((RealConnection)host).socket = ((RealConnection)host).rawSocket;
                        ((RealConnection)host).protocol = Protocol.HTTP_1_1;
                    }
                } else {
                    EventListener.secureConnectStart(call2);
                    super.connectTls$7263ff53(utilsKt);
                    EventListener.secureConnectEnd$30e623dc(call2);
                    if (((RealConnection)host).protocol == Protocol.HTTP_2) {
                        super.startHttp2(n);
                    }
                }
                EventListener.connectEnd$786dda5e(call, this.route.socketAddress(), this.route.proxy());
            }
            catch (IOException e) {
                Socket socket = this.socket;
                if (socket != null) {
                    Util.closeQuietly(socket);
                }
                Socket socket2 = this.rawSocket;
                if (socket2 != null) {
                    Util.closeQuietly(socket2);
                }
                this.socket = null;
                this.rawSocket = null;
                this.source = null;
                this.sink = null;
                this.handshake = null;
                this.protocol = null;
                this.http2Connection = null;
                this.allocationLimit = 1;
                EventListener.connectFailed$2677936a(call, this.route.socketAddress(), this.route.proxy(), e);
                if (routeException == null) {
                    routeException = new RouteException(e);
                    continue;
                }
                routeException.addConnectException(e);
                if (connectionRetryEnabled && connectionSpecSelector.connectionFailed(e)) continue;
                throw routeException;
            }
            break;
        }
        if (this.route.requiresTunnel() && this.rawSocket == null) {
            throw new RouteException(new ProtocolException("Too many tunnel connections attempted: 21"));
        }
        this.idleAtNs = System.nanoTime();
    }

    private final void connectTunnel(int connectTimeout, int readTimeout, int writeTimeout, Call call, EventListener eventListener) throws IOException {
        Request request;
        RealConnection realConnection = this;
        Request request2 = new Request.Builder().url(realConnection.route.address().url()).method("CONNECT", null).header("Host", Util.toHostHeader(realConnection.route.address().url(), true)).header("Proxy-Connection", "Keep-Alive").header("User-Agent", "okhttp/4.10.0").build();
        Response response = new Response.Builder().request(request2).protocol(Protocol.HTTP_1_1).code(407).message("Preemptive Authenticate").body(Util.EMPTY_RESPONSE).sentRequestAtMillis(-1L).receivedResponseAtMillis(-1L).header("Proxy-Authenticate", "OkHttp-Preemptive").build();
        Request request3 = request = realConnection.route.address().proxyAuthenticator().authenticate(realConnection.route, response);
        if (request == null) {
            request3 = request2;
        }
        Object tunnelRequest = request3;
        HttpUrl url = request3.url();
        int n = 0;
        while (n < 21) {
            Request request4;
            ++n;
            this.connectSocket(connectTimeout, readTimeout, call, eventListener);
            Object object = url;
            request = tunnelRequest;
            int n2 = writeTimeout;
            int n3 = readTimeout;
            tunnelRequest = this;
            object = "CONNECT " + Util.toHostHeader((HttpUrl)object, true) + " HTTP/1.1";
            block5: while (true) {
                BufferedSink bufferedSink;
                BufferedSource bufferedSource;
                Intrinsics.checkNotNull((Object)((RealConnection)tunnelRequest).source);
                Intrinsics.checkNotNull((Object)((RealConnection)tunnelRequest).sink);
                Http1ExchangeCodec http1ExchangeCodec = new Http1ExchangeCodec(null, (RealConnection)tunnelRequest, bufferedSource, bufferedSink);
                bufferedSource.timeout().timeout((long)n3, TimeUnit.MILLISECONDS);
                bufferedSink.timeout().timeout((long)n2, TimeUnit.MILLISECONDS);
                http1ExchangeCodec.writeRequest(request.headers(), (String)object);
                http1ExchangeCodec.finishRequest();
                Response.Builder builder = http1ExchangeCodec.readResponseHeaders(false);
                Intrinsics.checkNotNull((Object)builder);
                Response response2 = builder.request(request).build();
                http1ExchangeCodec.skipConnectBody(response2);
                switch (response2.code()) {
                    case 200: {
                        if (!bufferedSource.getBuffer().exhausted() || !bufferedSink.getBuffer().exhausted()) {
                            throw new IOException("TLS tunnel buffered too many bytes!");
                        }
                        request4 = null;
                        break block5;
                    }
                    case 407: {
                        request = ((RealConnection)tunnelRequest).route.address().proxyAuthenticator().authenticate(((RealConnection)tunnelRequest).route, response2);
                        if (request != null) continue block5;
                        throw new IOException("Failed to authenticate with proxy");
                        if (!StringsKt.equals((String)"close", (String)Response.header$default$b4243d8(response2, "Connection", null, 2), (boolean)true)) continue block5;
                        request4 = request;
                        break block5;
                    }
                    default: {
                        throw new IOException(Intrinsics.stringPlus((String)"Unexpected response code for CONNECT: ", (Object)response2.code()));
                    }
                }
                break;
            }
            tunnelRequest = request4;
            if (request4 == null) break;
            Socket socket = this.rawSocket;
            if (socket != null) {
                Util.closeQuietly(socket);
            }
            this.rawSocket = null;
            this.sink = null;
            this.source = null;
            EventListener.connectEnd$786dda5e(call, this.route.socketAddress(), this.route.proxy());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void connectSocket(int connectTimeout, int readTimeout, Call call, EventListener eventListener) throws IOException {
        void var2_4;
        ConnectException connectException;
        Socket rawSocket;
        Socket socket;
        Proxy proxy = this.route.proxy();
        Address address = this.route.address();
        Proxy.Type type = proxy.type();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: 
            case 2: {
                Socket socket2 = address.socketFactory().createSocket();
                socket = socket2;
                Intrinsics.checkNotNull((Object)socket2);
                break;
            }
            default: {
                socket = new Socket(proxy);
            }
        }
        this.rawSocket = rawSocket = socket;
        EventListener.connectStart((Call)((Object)connectException), this.route.socketAddress(), proxy);
        rawSocket.setSoTimeout((int)var2_4);
        try {
            Platform.access$getPlatform$cp().connectSocket(rawSocket, this.route.socketAddress(), connectTimeout);
        }
        catch (ConnectException e) {
            ConnectException connectException2;
            connectException = connectException2 = new ConnectException(Intrinsics.stringPlus((String)"Failed to connect to ", (Object)this.route.socketAddress()));
            connectException2.initCause(e);
            throw (Throwable)connectException2;
        }
        try {
            this.source = Okio.buffer((Source)Okio.source((Socket)rawSocket));
            this.sink = Okio.buffer((Sink)Okio.sink((Socket)rawSocket));
            return;
        }
        catch (NullPointerException nullPointerException) {
            NullPointerException npe = nullPointerException;
            if (Intrinsics.areEqual((Object)nullPointerException.getMessage(), (Object)"throw with null exception")) {
                void var1_3;
                throw new IOException((Throwable)var1_3);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void startHttp2(int pingIntervalMillis) throws IOException {
        void var1_2;
        void var3_4;
        void var2_3;
        Http2Connection http2Connection;
        Socket socket = this.socket;
        Intrinsics.checkNotNull((Object)socket);
        Socket socket2 = socket;
        BufferedSource bufferedSource = this.source;
        Intrinsics.checkNotNull((Object)bufferedSource);
        BufferedSource source = bufferedSource;
        BufferedSink bufferedSink = this.sink;
        Intrinsics.checkNotNull((Object)bufferedSink);
        BufferedSink sink = bufferedSink;
        socket2.setSoTimeout(0);
        this.http2Connection = http2Connection = new Http2Connection.Builder(true, TaskRunner.INSTANCE).socket((Socket)var2_3, this.route.address().url().host(), (BufferedSource)var3_4, sink).listener(this).pingIntervalMillis(pingIntervalMillis).build();
        this.allocationLimit = Http2Connection.access$getDEFAULT_SETTINGS$cp().getMaxConcurrentStreams();
        Http2Connection.start$default$48aa1d6a((Http2Connection)var1_2, false, null, 3);
    }

    /*
     * WARNING - void declaration
     */
    private final void connectTls$7263ff53(UtilsKt connectionSpecSelector) throws IOException {
        Address address = this.route.address();
        SSLSocketFactory sslSocketFactory = address.sslSocketFactory();
        SSLSocket sslSocket = null;
        try {
            void var1_1;
            void var2_3;
            void var3_4;
            X509Certificate cert;
            SSLSocketFactory sSLSocketFactory = sslSocketFactory;
            Intrinsics.checkNotNull((Object)sSLSocketFactory);
            Socket socket = sSLSocketFactory.createSocket(this.rawSocket, address.url().host(), address.url().port(), true);
            if (socket == null) {
                throw new NullPointerException("null cannot be cast to non-null type javax.net.ssl.SSLSocket");
            }
            sslSocket = (SSLSocket)socket;
            ConnectionSpec connectionSpec = connectionSpecSelector.configureSecureSocket(sslSocket);
            if (connectionSpec.supportsTlsExtensions()) {
                Platform.access$getPlatform$cp().configureTlsExtensions(sslSocket, address.url().host(), address.protocols());
            }
            sslSocket.startHandshake();
            SSLSession sslSocketSession = sslSocket.getSession();
            Intrinsics.checkNotNullExpressionValue((Object)sslSocketSession, (String)"sslSocketSession");
            Handshake unverifiedHandshake = Handshake.Companion.get(sslSocketSession);
            HostnameVerifier hostnameVerifier = address.hostnameVerifier();
            Intrinsics.checkNotNull((Object)hostnameVerifier);
            if (!hostnameVerifier.verify(address.url().host(), sslSocketSession)) {
                List<Certificate> peerCertificates2 = unverifiedHandshake.peerCertificates();
                if (!((Collection)peerCertificates2).isEmpty()) {
                    cert = (X509Certificate)peerCertificates2.get(0);
                    throw new SSLPeerUnverifiedException(StringsKt.trimMargin$default((String)("\n              |Hostname " + address.url().host() + " not verified:\n              |    certificate: " + CertificatePinner.Companion.pin(cert) + "\n              |    DN: " + cert.getSubjectDN().getName() + "\n              |    subjectAltNames: " + OkHostnameVerifier.INSTANCE.allSubjectAltNames(cert) + "\n              "), null, (int)1, null));
                }
                throw new SSLPeerUnverifiedException("Hostname " + address.url().host() + " not verified (no certificates)");
            }
            CertificatePinner certificatePinner = address.certificatePinner();
            Intrinsics.checkNotNull((Object)certificatePinner);
            CertificatePinner certificatePinner2 = certificatePinner;
            this.handshake = new Handshake(unverifiedHandshake.tlsVersion(), unverifiedHandshake.cipherSuite(), unverifiedHandshake.localCertificates(), (Function0<? extends List<? extends Certificate>>)((Function0)new Function0<List<? extends Certificate>>(certificatePinner2, unverifiedHandshake, address){
                private /* synthetic */ CertificatePinner $certificatePinner;
                private /* synthetic */ Handshake $unverifiedHandshake;
                private /* synthetic */ Address $address;
                {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.$certificatePinner = var1_1;
                    this.$unverifiedHandshake = var2_2;
                    this.$address = var3_3;
                    super(0);
                }
            }));
            var3_4.check$okhttp(var2_3.url().host(), (Function0<? extends List<? extends X509Certificate>>)((Function0)new Function0<List<? extends X509Certificate>>(this){
                private /* synthetic */ RealConnection this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    super(0);
                }
            }));
            String maybeProtocol = ((ConnectionSpec)((Object)cert)).supportsTlsExtensions() ? Platform.access$getPlatform$cp().getSelectedProtocol(sslSocket) : (String)null;
            this.socket = sslSocket;
            this.source = Okio.buffer((Source)Okio.source((Socket)sslSocket));
            this.sink = Okio.buffer((Sink)Okio.sink((Socket)sslSocket));
            this.protocol = maybeProtocol != null ? Protocol.Companion.get((String)var1_1) : Protocol.HTTP_1_1;
        }
        catch (Throwable throwable) {
            if (sslSocket != null) {
                Platform.access$getPlatform$cp().afterHandshake(sslSocket);
            }
            SSLSocket sSLSocket = sslSocket;
            if (sSLSocket != null) {
                Util.closeQuietly(sSLSocket);
            }
            throw throwable;
        }
        Platform.access$getPlatform$cp().afterHandshake(sslSocket);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isEligible$okhttp(Address address, List<Route> routes) {
        boolean bl;
        Object object;
        List<Certificate> list;
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        RealConnection $this$assertThreadHoldsLock$iv = this;
        if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + list));
        }
        if (this.calls.size() >= this.allocationLimit) return false;
        if (this.noNewExchanges) {
            return false;
        }
        if (!this.route.address().equalsNonHost$okhttp(address)) {
            return false;
        }
        list = this;
        if (Intrinsics.areEqual((Object)address.url().host(), (Object)((RealConnection)((Object)list)).route.address().url().host())) {
            return true;
        }
        if (this.http2Connection == null) {
            return false;
        }
        if (routes == null) return false;
        if (!this.routeMatchesAny((List<Route>)object)) {
            return false;
        }
        if (address.hostnameVerifier() != OkHostnameVerifier.INSTANCE) {
            return false;
        }
        list = address.url();
        Object object2 = object = this;
        if (Util.assertionsEnabled && !Thread.holdsLock(object2)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + object2));
        }
        object2 = ((RealConnection)object).route.address().url();
        if (((HttpUrl)((Object)list)).port() != ((HttpUrl)object2).port()) return false;
        if (Intrinsics.areEqual((Object)((HttpUrl)((Object)list)).host(), (Object)((HttpUrl)object2).host())) {
            bl = true;
        } else {
            if (((RealConnection)object).noCoalescedConnections) return false;
            if (((RealConnection)object).handshake == null) return false;
            List<Certificate> list2 = list;
            Handshake handshake2 = ((RealConnection)object).handshake;
            Intrinsics.checkNotNull((Object)handshake2);
            list = handshake2;
            object = list2;
            list = ((Handshake)((Object)list)).peerCertificates();
            if (((Collection)list).isEmpty()) return false;
            boolean bl2 = true;
            if (!bl2) return false;
            if (!OkHostnameVerifier.INSTANCE.verify(((HttpUrl)object).host(), (X509Certificate)list.get(0))) return false;
            boolean bl3 = true;
            if (!bl3) return false;
            bl = true;
        }
        if (!bl) {
            return false;
        }
        try {
            void var1_1;
            CertificatePinner certificatePinner = address.certificatePinner();
            Intrinsics.checkNotNull((Object)certificatePinner);
            String string = var1_1.url().host();
            list = this;
            Handshake handshake3 = ((RealConnection)((Object)list)).handshake;
            Intrinsics.checkNotNull((Object)handshake3);
            certificatePinner.check(string, handshake3.peerCertificates());
            return true;
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            return false;
        }
    }

    private final boolean routeMatchesAny(List<Route> candidates) {
        Iterable $this$any$iv = candidates;
        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) {
            Iterator iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                Route it = (Route)t;
                if (!(it.proxy().type() == Proxy.Type.DIRECT && this.route.proxy().type() == Proxy.Type.DIRECT && Intrinsics.areEqual((Object)this.route.socketAddress(), (Object)((Route)t).socketAddress()))) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final ExchangeCodec newCodec$okhttp$55b10e78(OkHttpClient client, ListSaverKt chain) throws SocketException {
        void var1_1;
        void var2_2;
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Socket socket = this.socket;
        Intrinsics.checkNotNull((Object)socket);
        Socket socket2 = socket;
        BufferedSource bufferedSource = this.source;
        Intrinsics.checkNotNull((Object)bufferedSource);
        BufferedSource source = bufferedSource;
        BufferedSink bufferedSink = this.sink;
        Intrinsics.checkNotNull((Object)bufferedSink);
        BufferedSink sink = bufferedSink;
        Http2Connection http2Connection = this.http2Connection;
        if (http2Connection != null) {
            return new Http2ExchangeCodec(client, this, chain, http2Connection);
        }
        var3_3.setSoTimeout(chain.readTimeoutMillis());
        source.timeout().timeout((long)chain.getReadTimeoutMillis$okhttp(), TimeUnit.MILLISECONDS);
        sink.timeout().timeout((long)var2_2.getWriteTimeoutMillis$okhttp(), TimeUnit.MILLISECONDS);
        return new Http1ExchangeCodec((OkHttpClient)var1_1, this, source, sink);
    }

    public final Route route() {
        return this.route;
    }

    public final void cancel() {
        Socket socket = this.rawSocket;
        if (socket == null) {
            return;
        }
        Util.closeQuietly(socket);
    }

    public final Socket socket() {
        Socket socket = this.socket;
        Intrinsics.checkNotNull((Object)socket);
        return socket;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isHealthy(boolean doExtensiveChecks) {
        void var1_1;
        void var11_8;
        RealConnection $this$assertThreadDoesntHoldLock$iv = this;
        if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
        }
        long nowNs = System.nanoTime();
        Socket socket = this.rawSocket;
        Intrinsics.checkNotNull((Object)socket);
        Socket rawSocket = socket;
        Socket socket2 = this.socket;
        Intrinsics.checkNotNull((Object)socket2);
        Socket socket3 = socket2;
        BufferedSource bufferedSource = this.source;
        Intrinsics.checkNotNull((Object)bufferedSource);
        BufferedSource source = bufferedSource;
        if (rawSocket.isClosed() || socket3.isClosed() || socket3.isInputShutdown() || socket3.isOutputShutdown()) {
            return false;
        }
        Http2Connection http2Connection = this.http2Connection;
        if (http2Connection != null) {
            return http2Connection.isHealthy(nowNs);
        }
        RealConnection realConnection = this;
        synchronized (realConnection) {
            void var2_3;
            RealConnection realConnection2 = this;
            var11_8 = var2_3 - realConnection2.idleAtNs;
        }
        void var8_10 = var11_8;
        if (var8_10 >= 10000000000L && var1_1 != false) {
            return Util.isHealthy(socket3, source);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void onStream(Http2Stream stream) throws IOException {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        var1_1.close(ErrorCode.REFUSED_STREAM, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized void onSettings(Http2Connection connection, Settings settings) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.allocationLimit = var2_2.getMaxConcurrentStreams();
    }

    public final Handshake handshake() {
        return this.handshake;
    }

    public final synchronized void trackFailure$okhttp(RealCall call22, IOException e) {
        block7: {
            block8: {
                block5: {
                    RealCall call22;
                    block6: {
                        Intrinsics.checkNotNullParameter((Object)call22, (String)"call");
                        if (!(e instanceof StreamResetException)) break block5;
                        if (((StreamResetException)e).errorCode != ErrorCode.REFUSED_STREAM) break block6;
                        int call22 = this.refusedStreamCount;
                        this.refusedStreamCount = call22 + 1;
                        if (this.refusedStreamCount <= 1) break block7;
                        this.noNewExchanges = true;
                        break block8;
                    }
                    if (((StreamResetException)e).errorCode == ErrorCode.CANCEL && call22.isCanceled()) break block7;
                    this.noNewExchanges = true;
                    break block8;
                }
                if (this.isMultiplexed$okhttp() && !(e instanceof ConnectionShutdownException)) break block7;
                this.noNewExchanges = true;
                if (this.successCount != 0) break block7;
                if (e != null) {
                    OkHttpClient okHttpClient;
                    Route route;
                    void var3_5 = route;
                    route = this.route;
                    okHttpClient = ((RealCall)((Object)okHttpClient)).getClient();
                    Intrinsics.checkNotNullParameter((Object)okHttpClient, (String)"client");
                    Intrinsics.checkNotNullParameter((Object)route, (String)"failedRoute");
                    Intrinsics.checkNotNullParameter((Object)var3_5, (String)"failure");
                    if (route.proxy().type() != Proxy.Type.DIRECT) {
                        Address address = route.address();
                        address.proxySelector().connectFailed(address.url().uri(), route.proxy().address(), (IOException)var3_5);
                    }
                    okHttpClient.getRouteDatabase$1aaf981f().failed(route);
                }
            }
            int n = this.routeFailureCount;
            this.routeFailureCount = n + 1;
        }
    }

    public final String toString() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder("Connection{").append(this.route.address().url().host()).append(':').append(this.route.address().url().port()).append(", proxy=").append(this.route.proxy()).append(" hostAddress=").append(this.route.socketAddress()).append(" cipherSuite=");
        Handshake handshake2 = this.handshake;
        if (handshake2 == null) {
            object = "none";
        } else {
            object = handshake2.cipherSuite();
            if (object == null) {
                object = "none";
            }
        }
        return stringBuilder.append(object).append(" protocol=").append((Object)this.protocol).append('}').toString();
    }

    public static final /* synthetic */ Handshake access$getHandshake$p(RealConnection $this) {
        return $this.handshake;
    }

    static {
        new Companion(0);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lokhttp3/internal/connection/RealConnection$Companion;", "", "()V", "IDLE_CONNECTION_HEALTHY_NS", "", "MAX_TUNNEL_ATTEMPTS", "", "NPE_THROW_WITH_NULL", "", "newTestConnection", "Lokhttp3/internal/connection/RealConnection;", "connectionPool", "Lokhttp3/internal/connection/RealConnectionPool;", "route", "Lokhttp3/Route;", "socket", "Ljava/net/Socket;", "idleAtNs", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(byte by) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Proxy.Type.values().length];
            int[] nArray2 = nArray;
            nArray[Proxy.Type.DIRECT.ordinal()] = 1;
            nArray2[Proxy.Type.HTTP.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray2;
        }
    }
}

