/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import com.ibm.icu.text.UnicodeSet;
import java.lang.ref.Reference;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Address;
import okhttp3.Route;
import okhttp3.internal.Util;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.platform.Platform;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005*\u0001\u000e\u0018\u0000 (2\u00020\u0001:\u0001(B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ.\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001b2\u0006\u0010\u001d\u001a\u00020\u0015J\u000e\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007J\u000e\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u0012J\u0006\u0010\"\u001a\u00020\u0005J\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020\u0005J\u0018\u0010&\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0007H\u0002J\u000e\u0010'\u001a\u00020$2\u0006\u0010!\u001a\u00020\u0012R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lokhttp3/internal/connection/RealConnectionPool;", "", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "maxIdleConnections", "", "keepAliveDuration", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "(Lokhttp3/internal/concurrent/TaskRunner;IJLjava/util/concurrent/TimeUnit;)V", "cleanupQueue", "Lokhttp3/internal/concurrent/TaskQueue;", "cleanupTask", "okhttp3/internal/connection/RealConnectionPool$cleanupTask$1", "Lokhttp3/internal/connection/RealConnectionPool$cleanupTask$1;", "connections", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lokhttp3/internal/connection/RealConnection;", "keepAliveDurationNs", "callAcquirePooledConnection", "", "address", "Lokhttp3/Address;", "call", "Lokhttp3/internal/connection/RealCall;", "routes", "", "Lokhttp3/Route;", "requireMultiplexed", "cleanup", "now", "connectionBecameIdle", "connection", "connectionCount", "evictAll", "", "idleConnectionCount", "pruneAndGetAllocationCount", "put", "Companion", "okhttp"})
public final class RealConnectionPool {
    private final int maxIdleConnections;
    private final long keepAliveDurationNs;
    private final TaskQueue cleanupQueue;
    private final cleanupTask.1 cleanupTask;
    private final ConcurrentLinkedQueue<RealConnection> connections;

    /*
     * WARNING - void declaration
     */
    public RealConnectionPool(TaskRunner taskRunner, int maxIdleConnections, long keepAliveDuration, TimeUnit timeUnit) {
        String string;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)taskRunner, (String)"taskRunner");
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        this.maxIdleConnections = var2_2;
        this.keepAliveDurationNs = timeUnit.toNanos(keepAliveDuration);
        this.cleanupQueue = ((TaskRunner)((Object)string)).newQueue();
        string = Intrinsics.stringPlus((String)Util.okHttpName, (Object)" ConnectionPool");
        this.cleanupTask = new UnicodeSet.XSymbolTable(this, string){
            private /* synthetic */ RealConnectionPool this$0;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super((String)var2_2, false, 2);
            }

            public final long runOnce() {
                return this.this$0.cleanup(System.nanoTime());
            }
        };
        this.connections = new ConcurrentLinkedQueue();
        if (!(keepAliveDuration > 0L)) {
            void var3_3;
            string = Intrinsics.stringPlus((String)"keepAliveDuration <= 0: ", (Object)((long)var3_3));
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final boolean callAcquirePooledConnection(Address address, RealCall call, List<Route> routes, boolean requireMultiplexed) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        for (RealConnection connection : this.connections) {
            Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"connection");
            RealConnection realConnection = connection;
            synchronized (realConnection) {
                block5: {
                    if (requireMultiplexed && !connection.isMultiplexed$okhttp() || !connection.isEligible$okhttp(address, routes)) break block5;
                    call.acquireConnectionNoEvents(connection);
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final void put(RealConnection connection) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        RealConnection $this$assertThreadHoldsLock$iv = connection;
        if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            void var2_2;
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + var2_2));
        }
        this.connections.add((RealConnection)var1_1);
        TaskQueue.schedule$default$6ac1683b$560effd7(this.cleanupQueue, this.cleanupTask, 0L, 2);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean connectionBecameIdle(RealConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        RealConnection $this$assertThreadHoldsLock$iv = connection;
        if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            void var2_2;
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + var2_2));
        }
        if (connection.getNoNewExchanges() || this.maxIdleConnections == 0) {
            void var1_1;
            connection.setNoNewExchanges(true);
            this.connections.remove(var1_1);
            if (this.connections.isEmpty()) {
                this.cleanupQueue.cancelAll();
            }
            return true;
        }
        TaskQueue.schedule$default$6ac1683b$560effd7(this.cleanupQueue, this.cleanupTask, 0L, 2);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final long cleanup(long now) {
        void var3_4;
        int inUseConnectionCount = 0;
        int idleConnectionCount = 0;
        RealConnection longestIdleConnection = null;
        long longestIdleDurationNs = Long.MIN_VALUE;
        for (RealConnection connection : this.connections) {
            Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"connection");
            RealConnection realConnection = connection;
            synchronized (realConnection) {
                int n;
                int n2;
                block19: {
                    long l = now;
                    RealConnection realConnection2 = connection;
                    RealConnectionPool realConnectionPool = this;
                    Object object = realConnection2;
                    if (Util.assertionsEnabled && !Thread.holdsLock(object)) {
                        throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + object));
                    }
                    object = realConnection2.getCalls();
                    int n3 = 0;
                    while (n3 < object.size()) {
                        Reference reference = (Reference)object.get(n3);
                        if (reference.get() != null) {
                            int n4 = n3;
                            n3 = n4 + 1;
                            continue;
                        }
                        reference = (RealCall.CallReference)reference;
                        String string = "A connection to " + realConnection2.route().address().url() + " was leaked. Did you forget to close a response body?";
                        Platform.access$getPlatform$cp().logCloseableLeak(string, ((RealCall.CallReference)reference).getCallStackTrace());
                        object.remove(n3);
                        realConnection2.setNoNewExchanges(true);
                        if (!object.isEmpty()) continue;
                        realConnection2.setIdleAtNs$okhttp(l - realConnectionPool.keepAliveDurationNs);
                        n2 = 0;
                        break block19;
                    }
                    n2 = object.size();
                }
                if (n2 > 0) {
                    n = inUseConnectionCount;
                    inUseConnectionCount = n + 1;
                    Integer.valueOf(n);
                } else {
                    n = idleConnectionCount;
                    idleConnectionCount = n + 1;
                    long idleDurationNs = now - connection.getIdleAtNs$okhttp();
                    if (idleDurationNs > longestIdleDurationNs) {
                        longestIdleDurationNs = idleDurationNs;
                        longestIdleConnection = connection;
                    }
                }
            }
        }
        if (longestIdleDurationNs >= this.keepAliveDurationNs || idleConnectionCount > this.maxIdleConnections) {
            RealConnection realConnection = longestIdleConnection;
            Intrinsics.checkNotNull(realConnection);
            RealConnection connection = realConnection;
            RealConnection realConnection3 = realConnection;
            synchronized (realConnection) {
                block21: {
                    void var1_1;
                    block20: {
                        if (!(!((Collection)connection.getCalls()).isEmpty())) break block20;
                        // ** MonitorExit[var7_9] (shouldn't be in output)
                        return 0L;
                    }
                    if (connection.getIdleAtNs$okhttp() + longestIdleDurationNs == var1_1) break block21;
                    // ** MonitorExit[var7_9] (shouldn't be in output)
                    return 0L;
                }
                connection.setNoNewExchanges(true);
                this.connections.remove(longestIdleConnection);
                // ** MonitorExit[var7_9] (shouldn't be in output)
                Util.closeQuietly(connection.socket());
                if (this.connections.isEmpty()) {
                    this.cleanupQueue.cancelAll();
                }
                return 0L;
            }
        }
        if (idleConnectionCount > 0) {
            return this.keepAliveDurationNs - longestIdleDurationNs;
        }
        if (var3_4 > 0) {
            return this.keepAliveDurationNs;
        }
        return -1L;
    }

    static {
        new Companion(0);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lokhttp3/internal/connection/RealConnectionPool$Companion;", "", "()V", "get", "Lokhttp3/internal/connection/RealConnectionPool;", "connectionPool", "Lokhttp3/ConnectionPool;", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(byte by) {
            this();
        }
    }
}

