/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import androidx.compose.runtime.internal.ComposableLambdaKt;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Address;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.HttpUrl;
import okhttp3.Route;
import okhttp3.internal.Util;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 !2\u00020\u0001:\u0002!\"B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0015\u001a\u00020\u0016H\u0086\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\t\u0010\u0018\u001a\u00020\u0019H\u0086\u0002J\b\u0010\u001a\u001a\u00020\u0014H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0014H\u0002J\u001a\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lokhttp3/internal/connection/RouteSelector;", "", "address", "Lokhttp3/Address;", "routeDatabase", "Lokhttp3/internal/connection/RouteDatabase;", "call", "Lokhttp3/Call;", "eventListener", "Lokhttp3/EventListener;", "(Lokhttp3/Address;Lokhttp3/internal/connection/RouteDatabase;Lokhttp3/Call;Lokhttp3/EventListener;)V", "inetSocketAddresses", "", "Ljava/net/InetSocketAddress;", "nextProxyIndex", "", "postponedRoutes", "", "Lokhttp3/Route;", "proxies", "Ljava/net/Proxy;", "hasNext", "", "hasNextProxy", "next", "Lokhttp3/internal/connection/RouteSelector$Selection;", "nextProxy", "resetNextInetSocketAddress", "", "proxy", "resetNextProxy", "url", "Lokhttp3/HttpUrl;", "Companion", "Selection", "okhttp"})
public final class RouteSelector {
    private static Companion Companion = new Companion(0);
    private final Address address;
    private final ComposableLambdaKt routeDatabase$7baadc7e;
    private final Call call;
    private final EventListener eventListener;
    private List<? extends Proxy> proxies;
    private int nextProxyIndex;
    private List<? extends InetSocketAddress> inetSocketAddresses;
    private final List<Route> postponedRoutes;

    public RouteSelector(Address address, ComposableLambdaKt routeDatabase, Call call, EventListener eventListener) {
        List<Proxy> list;
        Object object;
        HttpUrl httpUrl;
        RouteSelector routeSelector;
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)routeDatabase, (String)"routeDatabase");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)eventListener, (String)"eventListener");
        this.address = routeSelector;
        this.routeDatabase$7baadc7e = httpUrl;
        this.call = object;
        this.eventListener = eventListener;
        this.proxies = CollectionsKt.emptyList();
        this.inetSocketAddresses = CollectionsKt.emptyList();
        this.postponedRoutes = new ArrayList();
        RouteSelector routeSelector2 = this;
        object = this.address.proxy();
        httpUrl = routeSelector2.address.url();
        routeSelector = routeSelector2;
        EventListener.proxySelectStart(routeSelector2.call, httpUrl);
        RouteSelector routeSelector3 = routeSelector;
        Object object2 = httpUrl;
        if (object != null) {
            list = CollectionsKt.listOf((Object)object);
        } else {
            object = object2.uri();
            if (object.getHost() == null) {
                Proxy[] proxyArray = new Proxy[1];
                object = proxyArray;
                proxyArray[0] = Proxy.NO_PROXY;
                list = Util.immutableListOf(object);
            } else {
                object = routeSelector3.address.proxySelector().select((URI)object);
                object2 = (Collection)object;
                if (object2 == null || object2.isEmpty()) {
                    Proxy[] proxyArray = new Proxy[1];
                    object2 = proxyArray;
                    proxyArray[0] = Proxy.NO_PROXY;
                    list = Util.immutableListOf(object2);
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"proxiesOrNull");
                    list = Util.toImmutableList(object);
                }
            }
        }
        routeSelector.proxies = list;
        routeSelector.nextProxyIndex = 0;
        EventListener.proxySelectEnd(routeSelector.call, httpUrl, routeSelector.proxies);
    }

    public final boolean hasNext() {
        return this.hasNextProxy() || !((Collection)this.postponedRoutes).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public final Selection next() throws IOException {
        void var1_1;
        Iterator<? extends InetSocketAddress> iterator;
        Object object;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        List routes = new ArrayList();
        while (this.hasNextProxy()) {
            object = this;
            if (!((RouteSelector)object).hasNextProxy()) {
                throw new SocketException("No route to " + ((RouteSelector)object).address.url().host() + "; exhausted proxy configurations: " + ((RouteSelector)object).proxies);
            }
            int n = ((RouteSelector)object).nextProxyIndex;
            ((RouteSelector)object).nextProxyIndex = n + 1;
            iterator = ((RouteSelector)object).proxies.get(n);
            super.resetNextInetSocketAddress((Proxy)((Object)iterator));
            Iterator<? extends InetSocketAddress> proxy = iterator;
            for (InetSocketAddress inetSocketAddress : this.inetSocketAddresses) {
                Route route = new Route(this.address, (Proxy)((Object)proxy), inetSocketAddress);
                if (this.routeDatabase$7baadc7e.shouldPostpone(route)) {
                    ((Collection)this.postponedRoutes).add(route);
                    continue;
                }
                ((Collection)routes).add(route);
            }
            if (!(!((Collection)routes).isEmpty())) continue;
        }
        if (routes.isEmpty()) {
            object = routes;
            iterator = this.postponedRoutes;
            CollectionsKt.addAll((Collection)object, (Iterable)((Object)iterator));
            this.postponedRoutes.clear();
        }
        return new Selection((List<Route>)var1_1);
    }

    private final boolean hasNextProxy() {
        return this.nextProxyIndex < this.proxies.size();
    }

    /*
     * WARNING - void declaration
     */
    private final void resetNextInetSocketAddress(Proxy proxy) throws IOException {
        Iterator<InetAddress> iterator;
        int socketPort;
        Object socketHost2;
        List mutableInetSocketAddresses;
        this.inetSocketAddresses = mutableInetSocketAddresses = (List)new ArrayList();
        if (proxy.type() == Proxy.Type.DIRECT || proxy.type() == Proxy.Type.SOCKS) {
            socketHost2 = this.address.url().host();
            socketPort = this.address.url().port();
        } else {
            Object object;
            SocketAddress proxyAddress = proxy.address();
            if (!(proxyAddress instanceof InetSocketAddress)) {
                String socketHost2 = Intrinsics.stringPlus((String)"Proxy.address() is not an InetSocketAddress: ", proxyAddress.getClass());
                throw new IllegalArgumentException(socketHost2.toString());
            }
            Intrinsics.checkNotNullExpressionValue((Object)proxyAddress, (String)"proxyAddress");
            socketHost2 = (InetSocketAddress)proxyAddress;
            Intrinsics.checkNotNullParameter((Object)socketHost2, (String)"<this>");
            InetAddress inetAddress = ((InetSocketAddress)socketHost2).getAddress();
            if (inetAddress == null) {
                socketHost2 = ((InetSocketAddress)socketHost2).getHostName();
                Intrinsics.checkNotNullExpressionValue((Object)socketHost2, (String)"hostName");
                object = socketHost2;
            } else {
                socketHost2 = inetAddress;
                socketHost2 = inetAddress.getHostAddress();
                Intrinsics.checkNotNullExpressionValue((Object)socketHost2, (String)"address.hostAddress");
                object = socketHost2;
            }
            socketHost2 = object;
            socketPort = ((InetSocketAddress)proxyAddress).getPort();
        }
        if (!(socketPort > 0 ? socketPort < 65536 : false)) {
            throw new SocketException("No route to " + (String)socketHost2 + ':' + socketPort + "; port is out of range");
        }
        if (((Proxy)((Object)iterator)).type() == Proxy.Type.SOCKS) {
            ((Collection)mutableInetSocketAddresses).add(InetSocketAddress.createUnresolved((String)socketHost2, socketPort));
            return;
        }
        EventListener.dnsStart(this.call, (String)socketHost2);
        List<InetAddress> addresses = this.address.dns().lookup((String)socketHost2);
        if (addresses.isEmpty()) {
            throw new UnknownHostException(this.address.dns() + " returned no addresses for " + (String)socketHost2);
        }
        EventListener.dnsEnd(this.call, (String)socketHost2, addresses);
        for (InetAddress inetAddress : addresses) {
            void var3_3;
            ((Collection)mutableInetSocketAddresses).add(new InetSocketAddress((InetAddress)var3_3, socketPort));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\n\u001a\u00020\u000bH\u0086\u0002J\t\u0010\f\u001a\u00020\u0004H\u0086\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lokhttp3/internal/connection/RouteSelector$Selection;", "", "routes", "", "Lokhttp3/Route;", "(Ljava/util/List;)V", "nextRouteIndex", "", "getRoutes", "()Ljava/util/List;", "hasNext", "", "next", "okhttp"})
    public static final class Selection {
        private final List<Route> routes;
        private int nextRouteIndex;

        /*
         * WARNING - void declaration
         */
        public Selection(List<Route> routes) {
            void var1_1;
            Intrinsics.checkNotNullParameter(routes, (String)"routes");
            this.routes = var1_1;
        }

        public final List<Route> getRoutes() {
            return this.routes;
        }

        public final boolean hasNext() {
            return this.nextRouteIndex < this.routes.size();
        }

        public final Route next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int n = this.nextRouteIndex;
            this.nextRouteIndex = n + 1;
            return this.routes.get(n);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lokhttp3/internal/connection/RouteSelector$Companion;", "", "()V", "socketHost", "", "Ljava/net/InetSocketAddress;", "getSocketHost", "(Ljava/net/InetSocketAddress;)Ljava/lang/String;", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(byte by) {
            this();
        }
    }
}

