/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http1;

import java.io.EOFException;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.CookieJar;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.RequestLine;
import okhttp3.internal.http.StatusLine;
import okhttp3.internal.http1.HeadersReader;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ForwardingTimeout;
import okio.Sink;
import okio.Source;
import okio.Timeout;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u0000 ?2\u00020\u0001:\u0007<=>?@ABB'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020\u001cH\u0016J\b\u0010&\u001a\u00020\u001cH\u0016J\b\u0010'\u001a\u00020\u001eH\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020!H\u0002J\b\u0010.\u001a\u00020\u001eH\u0002J\b\u0010/\u001a\u00020)H\u0002J\u0010\u00100\u001a\u00020)2\u0006\u00101\u001a\u00020\u0019H\u0016J\u0012\u00102\u001a\u0004\u0018\u0001032\u0006\u00104\u001a\u00020\u0010H\u0016J\u0010\u00105\u001a\u00020!2\u0006\u00101\u001a\u00020\u0019H\u0016J\u000e\u00106\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u0019J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u00107\u001a\u00020\u001c2\u0006\u00108\u001a\u00020\u00152\u0006\u00109\u001a\u00020:J\u0010\u0010;\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u0017H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0016\u001a\u00020\u0010*\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u0018\u0010\u0016\u001a\u00020\u0010*\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u001a\u00a8\u0006C"}, d2={"Lokhttp3/internal/http1/Http1ExchangeCodec;", "Lokhttp3/internal/http/ExchangeCodec;", "client", "Lokhttp3/OkHttpClient;", "connection", "Lokhttp3/internal/connection/RealConnection;", "source", "Lokio/BufferedSource;", "sink", "Lokio/BufferedSink;", "(Lokhttp3/OkHttpClient;Lokhttp3/internal/connection/RealConnection;Lokio/BufferedSource;Lokio/BufferedSink;)V", "getConnection", "()Lokhttp3/internal/connection/RealConnection;", "headersReader", "Lokhttp3/internal/http1/HeadersReader;", "isClosed", "", "()Z", "state", "", "trailers", "Lokhttp3/Headers;", "isChunked", "Lokhttp3/Request;", "(Lokhttp3/Request;)Z", "Lokhttp3/Response;", "(Lokhttp3/Response;)Z", "cancel", "", "createRequestBody", "Lokio/Sink;", "request", "contentLength", "", "detachTimeout", "timeout", "Lokio/ForwardingTimeout;", "finishRequest", "flushRequest", "newChunkedSink", "newChunkedSource", "Lokio/Source;", "url", "Lokhttp3/HttpUrl;", "newFixedLengthSource", "length", "newKnownLengthSink", "newUnknownLengthSource", "openResponseBodySource", "response", "readResponseHeaders", "Lokhttp3/Response$Builder;", "expectContinue", "reportedContentLength", "skipConnectBody", "writeRequest", "headers", "requestLine", "", "writeRequestHeaders", "AbstractSource", "ChunkedSink", "ChunkedSource", "Companion", "FixedLengthSource", "KnownLengthSink", "UnknownLengthSource", "okhttp"})
public final class Http1ExchangeCodec
implements ExchangeCodec {
    private final OkHttpClient client;
    private final RealConnection connection;
    private final BufferedSource source;
    private final BufferedSink sink;
    private int state;
    private final HeadersReader headersReader;
    private Headers trailers;

    /*
     * WARNING - void declaration
     */
    public Http1ExchangeCodec(OkHttpClient client, RealConnection connection, BufferedSource source, BufferedSink sink) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        this.client = var1_1;
        this.connection = var2_2;
        this.source = var3_3;
        this.sink = sink;
        this.headersReader = new HeadersReader(this.source);
    }

    @Override
    public final RealConnection getConnection() {
        return this.connection;
    }

    private static boolean isChunked(Response $this$isChunked) {
        Response response;
        return StringsKt.equals((String)"chunked", (String)Response.header$default$b4243d8(response, "Transfer-Encoding", null, 2), (boolean)true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Sink createRequestBody(Request request, long contentLength) {
        void var2_2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (request.body() != null) {
            request.body();
        }
        if (StringsKt.equals((String)"chunked", (String)((Request)object).header("Transfer-Encoding"), (boolean)true)) {
            object = this;
            if (!(((Http1ExchangeCodec)object).state == 1)) {
                object = Intrinsics.stringPlus((String)"state: ", (Object)((Http1ExchangeCodec)object).state);
                throw new IllegalStateException(object.toString());
            }
            ((Http1ExchangeCodec)object).state = 2;
            return new ChunkedSink((Http1ExchangeCodec)object);
        }
        if (var2_2 != -1L) {
            object = this;
            if (!(((Http1ExchangeCodec)object).state == 1)) {
                object = Intrinsics.stringPlus((String)"state: ", (Object)((Http1ExchangeCodec)object).state);
                throw new IllegalStateException(object.toString());
            }
            ((Http1ExchangeCodec)object).state = 2;
            return new KnownLengthSink((Http1ExchangeCodec)object);
        }
        throw new IllegalStateException("Cannot stream a request body without chunked encoding or a known content length!");
    }

    @Override
    public final void cancel() {
        Http1ExchangeCodec http1ExchangeCodec = this;
        http1ExchangeCodec.connection.cancel();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeRequestHeaders(Request request) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Object object = this;
        object = object.connection.route().proxy().type();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"connection.route().proxy.type()");
        String requestLine = RequestLine.get(request, (Proxy.Type)((Object)object));
        this.writeRequest(var1_1.headers(), (String)object);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long reportedContentLength(Response response) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (!HttpHeaders.promisesBody(response)) {
            return 0L;
        }
        if (Http1ExchangeCodec.isChunked(response)) {
            return -1L;
        }
        return Util.headersContentLength((Response)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Source openResponseBodySource(Response response) {
        Http1ExchangeCodec http1ExchangeCodec;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (!HttpHeaders.promisesBody((Response)response)) {
            return this.newFixedLengthSource(0L);
        }
        if (Http1ExchangeCodec.isChunked((Response)response)) {
            HttpUrl httpUrl = ((Response)response).request().url();
            response = this;
            if (!(((Http1ExchangeCodec)response).state == 4)) {
                response = Intrinsics.stringPlus((String)"state: ", (Object)((Http1ExchangeCodec)response).state);
                throw new IllegalStateException(response.toString());
            }
            ((Http1ExchangeCodec)response).state = 5;
            return new ChunkedSource((Http1ExchangeCodec)response, httpUrl);
        }
        long contentLength = Util.headersContentLength((Response)((Object)http1ExchangeCodec));
        if (contentLength != -1L) {
            void var2_3;
            return this.newFixedLengthSource((long)var2_3);
        }
        http1ExchangeCodec = this;
        if (!(http1ExchangeCodec.state == 4)) {
            String string = Intrinsics.stringPlus((String)"state: ", (Object)http1ExchangeCodec.state);
            throw new IllegalStateException(string.toString());
        }
        http1ExchangeCodec.state = 5;
        Http1ExchangeCodec http1ExchangeCodec2 = http1ExchangeCodec;
        http1ExchangeCodec2.connection.noNewExchanges$okhttp();
        return new UnknownLengthSource(http1ExchangeCodec);
    }

    @Override
    public final void flushRequest() {
        this.sink.flush();
    }

    @Override
    public final void finishRequest() {
        this.sink.flush();
    }

    /*
     * WARNING - void declaration
     */
    public final void writeRequest(Headers headers, String requestLine) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)requestLine, (String)"requestLine");
        if (!(this.state == 0)) {
            String string = Intrinsics.stringPlus((String)"state: ", (Object)this.state);
            throw new IllegalStateException(string.toString());
        }
        this.sink.writeUtf8((String)var2_2).writeUtf8("\r\n");
        int n = 0;
        int n2 = headers.size();
        while (n < n2) {
            int i = n++;
            this.sink.writeUtf8(headers.name(i)).writeUtf8(": ").writeUtf8(headers.value(i)).writeUtf8("\r\n");
        }
        this.sink.writeUtf8("\r\n");
        this.state = 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Response.Builder readResponseHeaders(boolean expectContinue) {
        if (!(this.state == 1 || this.state == 3)) {
            String string = Intrinsics.stringPlus((String)"state: ", (Object)this.state);
            throw new IllegalStateException(string.toString());
        }
        try {
            void var1_1;
            StatusLine statusLine = StatusLine.Companion.parse(this.headersReader.readLine());
            Response.Builder responseBuilder = new Response.Builder().protocol(statusLine.protocol).code(statusLine.code).message(statusLine.message).headers(this.headersReader.readHeaders());
            if (var1_1 != false && statusLine.code == 100) {
                return null;
            }
            if (statusLine.code == 100) {
                this.state = 3;
                return responseBuilder;
            }
            this.state = 4;
            return responseBuilder;
        }
        catch (EOFException e) {
            void var2_7;
            void var3_5;
            Http1ExchangeCodec http1ExchangeCodec = this;
            String address = http1ExchangeCodec.connection.route().address().url().redact();
            throw new IOException(Intrinsics.stringPlus((String)"unexpected end of stream on ", (Object)var3_5), (Throwable)var2_7);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Source newFixedLengthSource(long length2) {
        void var1_1;
        if (!(this.state == 4)) {
            String length2 = Intrinsics.stringPlus((String)"state: ", (Object)this.state);
            throw new IllegalStateException(length2.toString());
        }
        this.state = 5;
        return new FixedLengthSource(this, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void skipConnectBody(Response response) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        long contentLength = Util.headersContentLength(response);
        if (contentLength == -1L) {
            return;
        }
        Source body = this.newFixedLengthSource((long)var2_2);
        Util.skipAll(body, Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
        var1_1.close();
    }

    public static final /* synthetic */ void access$detachTimeout(Http1ExchangeCodec $this, ForwardingTimeout timeout2) {
        Http1ExchangeCodec http1ExchangeCodec = timeout2;
        Timeout timeout3 = http1ExchangeCodec.delegate();
        http1ExchangeCodec.setDelegate(Timeout.NONE);
        timeout3.clearDeadline();
        timeout3.clearTimeout();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setState$p(Http1ExchangeCodec $this, int n) {
        void var1_1;
        $this.state = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setTrailers$p(Http1ExchangeCodec $this, Headers headers) {
        void var1_1;
        $this.trailers = var1_1;
    }

    static {
        new Companion(0);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\u0005\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lokhttp3/internal/http1/Http1ExchangeCodec$KnownLengthSink;", "Lokio/Sink;", "(Lokhttp3/internal/http1/Http1ExchangeCodec;)V", "closed", "", "timeout", "Lokio/ForwardingTimeout;", "close", "", "flush", "Lokio/Timeout;", "write", "source", "Lokio/Buffer;", "byteCount", "", "okhttp"})
    final class KnownLengthSink
    implements Sink {
        private final ForwardingTimeout timeout;
        private boolean closed;
        private /* synthetic */ Http1ExchangeCodec this$0;

        /*
         * WARNING - void declaration
         */
        public KnownLengthSink(Http1ExchangeCodec this$0) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this.this$0 = var1_1;
            this.timeout = new ForwardingTimeout(this.this$0.sink.timeout());
        }

        public final Timeout timeout() {
            return (Timeout)this.timeout;
        }

        /*
         * WARNING - void declaration
         */
        public final void write(Buffer source, long byteCount) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            if (!(!this.closed)) {
                source = "closed";
                throw new IllegalStateException(source.toString());
            }
            Util.checkOffsetAndCount(source.size(), 0L, byteCount);
            this.this$0.sink.write((Buffer)var1_1, (long)var2_2);
        }

        public final void flush() {
            if (this.closed) {
                return;
            }
            this.this$0.sink.flush();
        }

        public final void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            Http1ExchangeCodec.access$detachTimeout(this.this$0, this.timeout);
            Http1ExchangeCodec.access$setState$p(this.this$0, 3);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\u0005\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lokhttp3/internal/http1/Http1ExchangeCodec$ChunkedSink;", "Lokio/Sink;", "(Lokhttp3/internal/http1/Http1ExchangeCodec;)V", "closed", "", "timeout", "Lokio/ForwardingTimeout;", "close", "", "flush", "Lokio/Timeout;", "write", "source", "Lokio/Buffer;", "byteCount", "", "okhttp"})
    final class ChunkedSink
    implements Sink {
        private final ForwardingTimeout timeout;
        private boolean closed;
        private /* synthetic */ Http1ExchangeCodec this$0;

        /*
         * WARNING - void declaration
         */
        public ChunkedSink(Http1ExchangeCodec this$0) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this.this$0 = var1_1;
            this.timeout = new ForwardingTimeout(this.this$0.sink.timeout());
        }

        public final Timeout timeout() {
            return (Timeout)this.timeout;
        }

        /*
         * WARNING - void declaration
         */
        public final void write(Buffer source, long byteCount) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            if (!(!this.closed)) {
                source = "closed";
                throw new IllegalStateException(source.toString());
            }
            if (byteCount == 0L) {
                return;
            }
            this.this$0.sink.writeHexadecimalUnsignedLong(byteCount);
            this.this$0.sink.writeUtf8("\r\n");
            this.this$0.sink.write((Buffer)var1_1, (long)var2_2);
            this.this$0.sink.writeUtf8("\r\n");
        }

        public final synchronized void flush() {
            if (this.closed) {
                return;
            }
            this.this$0.sink.flush();
        }

        public final synchronized void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.this$0.sink.writeUtf8("0\r\n\r\n");
            Http1ExchangeCodec.access$detachTimeout(this.this$0, this.timeout);
            Http1ExchangeCodec.access$setState$p(this.this$0, 3);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\t\u001a\u00020\u0014H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lokhttp3/internal/http1/Http1ExchangeCodec$AbstractSource;", "Lokio/Source;", "(Lokhttp3/internal/http1/Http1ExchangeCodec;)V", "closed", "", "getClosed", "()Z", "setClosed", "(Z)V", "timeout", "Lokio/ForwardingTimeout;", "getTimeout", "()Lokio/ForwardingTimeout;", "read", "", "sink", "Lokio/Buffer;", "byteCount", "responseBodyComplete", "", "Lokio/Timeout;", "okhttp"})
    abstract class AbstractSource
    implements Source {
        private final ForwardingTimeout timeout;
        private boolean closed;
        private /* synthetic */ Http1ExchangeCodec this$0;

        /*
         * WARNING - void declaration
         */
        public AbstractSource(Http1ExchangeCodec this$0) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this.this$0 = var1_1;
            this.timeout = new ForwardingTimeout(this.this$0.source.timeout());
        }

        protected final boolean getClosed() {
            return this.closed;
        }

        protected final void setClosed(boolean bl) {
            this.closed = true;
        }

        public final Timeout timeout() {
            return (Timeout)this.timeout;
        }

        /*
         * WARNING - void declaration
         */
        public long read(Buffer sink, long byteCount) {
            long l;
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            try {
                void var2_3;
                l = this.this$0.source.read(sink, (long)var2_3);
            }
            catch (IOException e) {
                void var1_2;
                this.this$0.getConnection().noNewExchanges$okhttp();
                this.responseBodyComplete();
                throw var1_2;
            }
            return l;
        }

        public final void responseBodyComplete() {
            if (this.this$0.state == 6) {
                return;
            }
            if (this.this$0.state != 5) {
                throw new IllegalStateException(Intrinsics.stringPlus((String)"state: ", (Object)this.this$0.state));
            }
            Http1ExchangeCodec.access$detachTimeout(this.this$0, this.timeout);
            Http1ExchangeCodec.access$setState$p(this.this$0, 6);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lokhttp3/internal/http1/Http1ExchangeCodec$FixedLengthSource;", "Lokhttp3/internal/http1/Http1ExchangeCodec$AbstractSource;", "Lokhttp3/internal/http1/Http1ExchangeCodec;", "bytesRemaining", "", "(Lokhttp3/internal/http1/Http1ExchangeCodec;J)V", "close", "", "read", "sink", "Lokio/Buffer;", "byteCount", "okhttp"})
    final class FixedLengthSource
    extends AbstractSource {
        private long bytesRemaining;
        private /* synthetic */ Http1ExchangeCodec this$0;

        /*
         * WARNING - void declaration
         */
        public FixedLengthSource(Http1ExchangeCodec this$0, long bytesRemaining) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this.this$0 = this$0;
            super((Http1ExchangeCodec)var1_1);
            this.bytesRemaining = var2_2;
            if (this.bytesRemaining == 0L) {
                this.responseBodyComplete();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final long read(Buffer sink, long byteCount) {
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            if (!(byteCount >= 0L)) {
                String string = Intrinsics.stringPlus((String)"byteCount < 0: ", (Object)byteCount);
                throw new IllegalArgumentException(string.toString());
            }
            if (!(!this.getClosed())) {
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            if (this.bytesRemaining == 0L) {
                return -1L;
            }
            long read = super.read(sink, Math.min(this.bytesRemaining, (long)var2_2));
            if (read == -1L) {
                void var1_1;
                this.this$0.getConnection().noNewExchanges$okhttp();
                ProtocolException e = new ProtocolException("unexpected end of stream");
                this.responseBodyComplete();
                throw var1_1;
            }
            this.bytesRemaining -= read;
            if (this.bytesRemaining == 0L) {
                this.responseBodyComplete();
            }
            return read;
        }

        public final void close() {
            if (this.getClosed()) {
                return;
            }
            if (this.bytesRemaining != 0L && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                this.this$0.getConnection().noNewExchanges$okhttp();
                this.responseBodyComplete();
            }
            this.setClosed(true);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lokhttp3/internal/http1/Http1ExchangeCodec$ChunkedSource;", "Lokhttp3/internal/http1/Http1ExchangeCodec$AbstractSource;", "Lokhttp3/internal/http1/Http1ExchangeCodec;", "url", "Lokhttp3/HttpUrl;", "(Lokhttp3/internal/http1/Http1ExchangeCodec;Lokhttp3/HttpUrl;)V", "bytesRemainingInChunk", "", "hasMoreChunks", "", "close", "", "read", "sink", "Lokio/Buffer;", "byteCount", "readChunkSize", "okhttp"})
    final class ChunkedSource
    extends AbstractSource {
        private final HttpUrl url;
        private long bytesRemainingInChunk;
        private boolean hasMoreChunks;
        private /* synthetic */ Http1ExchangeCodec this$0;

        /*
         * WARNING - void declaration
         */
        public ChunkedSource(Http1ExchangeCodec this$0, HttpUrl url) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.this$0 = this$0;
            super((Http1ExchangeCodec)var1_1);
            this.url = var2_2;
            this.bytesRemainingInChunk = -1L;
            this.hasMoreChunks = true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final long read(Buffer sink, long byteCount) {
            long l;
            void var2_2;
            void var1_1;
            long read;
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            if (!(byteCount >= 0L)) {
                String string = Intrinsics.stringPlus((String)"byteCount < 0: ", (Object)byteCount);
                throw new IllegalArgumentException(string.toString());
            }
            if (!(!this.getClosed())) {
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            if (!this.hasMoreChunks) {
                return -1L;
            }
            if (this.bytesRemainingInChunk == 0L || this.bytesRemainingInChunk == -1L) {
                ChunkedSource chunkedSource = this;
                if (chunkedSource.bytesRemainingInChunk != -1L) {
                    chunkedSource.this$0.source.readUtf8LineStrict();
                }
                try {
                    chunkedSource.bytesRemainingInChunk = chunkedSource.this$0.source.readHexadecimalUnsignedLong();
                    String string = ((Object)StringsKt.trim((CharSequence)chunkedSource.this$0.source.readUtf8LineStrict())).toString();
                    if (chunkedSource.bytesRemainingInChunk < 0L || ((CharSequence)string).length() > 0 && !StringsKt.startsWith$default((String)string, (String)";", (boolean)false, (int)2, null)) {
                        throw new ProtocolException("expected chunk size and optional extensions but was \"" + chunkedSource.bytesRemainingInChunk + string + '\"');
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ProtocolException(numberFormatException.getMessage());
                }
                if (chunkedSource.bytesRemainingInChunk == 0L) {
                    chunkedSource.hasMoreChunks = false;
                    Http1ExchangeCodec.access$setTrailers$p(chunkedSource.this$0, chunkedSource.this$0.headersReader.readHeaders());
                    OkHttpClient okHttpClient = chunkedSource.this$0.client;
                    Intrinsics.checkNotNull((Object)okHttpClient);
                    CookieJar cookieJar = okHttpClient.cookieJar();
                    HttpUrl httpUrl = chunkedSource.url;
                    Headers headers = chunkedSource.this$0.trailers;
                    Intrinsics.checkNotNull((Object)headers);
                    HttpHeaders.receiveHeaders(cookieJar, httpUrl, headers);
                    chunkedSource.responseBodyComplete();
                }
                if (!this.hasMoreChunks) {
                    return -1L;
                }
            }
            if ((read = super.read((Buffer)var1_1, Math.min((long)var2_2, l = this.bytesRemainingInChunk))) == -1L) {
                this.this$0.getConnection().noNewExchanges$okhttp();
                ProtocolException e = new ProtocolException("unexpected end of stream");
                this.responseBodyComplete();
                throw e;
            }
            this.bytesRemainingInChunk -= read;
            return read;
        }

        public final void close() {
            if (this.getClosed()) {
                return;
            }
            if (this.hasMoreChunks && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                this.this$0.getConnection().noNewExchanges$okhttp();
                this.responseBodyComplete();
            }
            this.setClosed(true);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lokhttp3/internal/http1/Http1ExchangeCodec$UnknownLengthSource;", "Lokhttp3/internal/http1/Http1ExchangeCodec$AbstractSource;", "Lokhttp3/internal/http1/Http1ExchangeCodec;", "(Lokhttp3/internal/http1/Http1ExchangeCodec;)V", "inputExhausted", "", "close", "", "read", "", "sink", "Lokio/Buffer;", "byteCount", "okhttp"})
    final class UnknownLengthSource
    extends AbstractSource {
        private boolean inputExhausted;

        /*
         * WARNING - void declaration
         */
        public UnknownLengthSource(Http1ExchangeCodec this$0) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            super((Http1ExchangeCodec)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final long read(Buffer sink, long byteCount) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            if (!(byteCount >= 0L)) {
                String string = Intrinsics.stringPlus((String)"byteCount < 0: ", (Object)byteCount);
                throw new IllegalArgumentException(string.toString());
            }
            if (!(!this.getClosed())) {
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            if (this.inputExhausted) {
                return -1L;
            }
            long read = super.read((Buffer)var1_1, (long)var2_2);
            if (read == -1L) {
                this.inputExhausted = true;
                this.responseBodyComplete();
                return -1L;
            }
            return read;
        }

        public final void close() {
            if (this.getClosed()) {
                return;
            }
            if (!this.inputExhausted) {
                this.responseBodyComplete();
            }
            this.setClosed(true);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lokhttp3/internal/http1/Http1ExchangeCodec$Companion;", "", "()V", "NO_CHUNK_YET", "", "STATE_CLOSED", "", "STATE_IDLE", "STATE_OPEN_REQUEST_BODY", "STATE_OPEN_RESPONSE_BODY", "STATE_READING_RESPONSE_BODY", "STATE_READ_RESPONSE_HEADERS", "STATE_WRITING_REQUEST_BODY", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(byte by) {
            this();
        }
    }
}

