/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.Util;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Huffman;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Source;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005J\u0014\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004H\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lokhttp3/internal/http2/Hpack;", "", "()V", "NAME_TO_FIRST_INDEX", "", "Lokio/ByteString;", "", "getNAME_TO_FIRST_INDEX", "()Ljava/util/Map;", "PREFIX_4_BITS", "PREFIX_5_BITS", "PREFIX_6_BITS", "PREFIX_7_BITS", "SETTINGS_HEADER_TABLE_SIZE", "SETTINGS_HEADER_TABLE_SIZE_LIMIT", "STATIC_HEADER_TABLE", "", "Lokhttp3/internal/http2/Header;", "getSTATIC_HEADER_TABLE", "()[Lokhttp3/internal/http2/Header;", "[Lokhttp3/internal/http2/Header;", "checkLowercase", "name", "nameToFirstIndex", "Reader", "Writer", "okhttp"})
public final class Hpack {
    public static final Hpack INSTANCE = new Hpack();
    private static final Header[] STATIC_HEADER_TABLE;
    private static final Map<ByteString, Integer> NAME_TO_FIRST_INDEX;

    private Hpack() {
    }

    public static Header[] getSTATIC_HEADER_TABLE() {
        return STATIC_HEADER_TABLE;
    }

    public static Map<ByteString, Integer> getNAME_TO_FIRST_INDEX() {
        return NAME_TO_FIRST_INDEX;
    }

    /*
     * WARNING - void declaration
     */
    public static ByteString checkLowercase(ByteString name) throws IOException {
        ByteString byteString;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        int n = 0;
        ByteString byteString2 = name;
        int n2 = byteString2.getSize$okio();
        while (n < n2) {
            void var3_3;
            int i = n++;
            ByteString byteString3 = name;
            void var4_7 = var3_3;
            byte by = byteString3.internalGet$okio((int)var4_7);
            boolean bl = 65 <= by ? by <= 90 : false;
            if (!bl) continue;
            throw new IOException(Intrinsics.stringPlus((String)"PROTOCOL_ERROR response malformed: mixed case name: ", (Object)name.utf8()));
        }
        return byteString;
    }

    static {
        Header[] headerArray = new Header[61];
        Object object = headerArray;
        headerArray[0] = new Header(Header.TARGET_AUTHORITY, "");
        object[1] = new Header(Header.TARGET_METHOD, "GET");
        object[2] = new Header(Header.TARGET_METHOD, "POST");
        object[3] = new Header(Header.TARGET_PATH, "/");
        object[4] = new Header(Header.TARGET_PATH, "/index.html");
        object[5] = new Header(Header.TARGET_SCHEME, "http");
        object[6] = new Header(Header.TARGET_SCHEME, "https");
        object[7] = new Header(Header.RESPONSE_STATUS, "200");
        object[8] = new Header(Header.RESPONSE_STATUS, "204");
        object[9] = new Header(Header.RESPONSE_STATUS, "206");
        object[10] = new Header(Header.RESPONSE_STATUS, "304");
        object[11] = new Header(Header.RESPONSE_STATUS, "400");
        object[12] = new Header(Header.RESPONSE_STATUS, "404");
        object[13] = new Header(Header.RESPONSE_STATUS, "500");
        object[14] = new Header("accept-charset", "");
        object[15] = new Header("accept-encoding", "gzip, deflate");
        object[16] = new Header("accept-language", "");
        object[17] = new Header("accept-ranges", "");
        object[18] = new Header("accept", "");
        object[19] = new Header("access-control-allow-origin", "");
        object[20] = new Header("age", "");
        object[21] = new Header("allow", "");
        object[22] = new Header("authorization", "");
        object[23] = new Header("cache-control", "");
        object[24] = new Header("content-disposition", "");
        object[25] = new Header("content-encoding", "");
        object[26] = new Header("content-language", "");
        object[27] = new Header("content-length", "");
        object[28] = new Header("content-location", "");
        object[29] = new Header("content-range", "");
        object[30] = new Header("content-type", "");
        object[31] = new Header("cookie", "");
        object[32] = new Header("date", "");
        object[33] = new Header("etag", "");
        object[34] = new Header("expect", "");
        object[35] = new Header("expires", "");
        object[36] = new Header("from", "");
        object[37] = new Header("host", "");
        object[38] = new Header("if-match", "");
        object[39] = new Header("if-modified-since", "");
        object[40] = new Header("if-none-match", "");
        object[41] = new Header("if-range", "");
        object[42] = new Header("if-unmodified-since", "");
        object[43] = new Header("last-modified", "");
        object[44] = new Header("link", "");
        object[45] = new Header("location", "");
        object[46] = new Header("max-forwards", "");
        object[47] = new Header("proxy-authenticate", "");
        object[48] = new Header("proxy-authorization", "");
        object[49] = new Header("range", "");
        object[50] = new Header("referer", "");
        object[51] = new Header("refresh", "");
        object[52] = new Header("retry-after", "");
        object[53] = new Header("server", "");
        object[54] = new Header("set-cookie", "");
        object[55] = new Header("strict-transport-security", "");
        object[56] = new Header("transfer-encoding", "");
        object[57] = new Header("user-agent", "");
        object[58] = new Header("vary", "");
        object[59] = new Header("via", "");
        object[60] = new Header("www-authenticate", "");
        STATIC_HEADER_TABLE = object;
        object = new LinkedHashMap(STATIC_HEADER_TABLE.length);
        int n = 0;
        int n2 = STATIC_HEADER_TABLE.length;
        while (n < n2) {
            int n3 = n++;
            if (((HashMap)object).containsKey(Hpack.STATIC_HEADER_TABLE[n3].name)) continue;
            Map map = (Map)object;
            ByteString byteString = Hpack.STATIC_HEADER_TABLE[n3].name;
            Integer n4 = n3;
            map.put(byteString, n4);
        }
        Map map = Collections.unmodifiableMap((Map)object);
        Intrinsics.checkNotNullExpressionValue(map, (String)"unmodifiableMap(result)");
        NAME_TO_FIRST_INDEX = map;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\u0018\u00002\u00020\u0001B!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u0018\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\nH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u0006\u0010\u0006\u001a\u00020\u0005J\b\u0010!\u001a\u00020\u0005H\u0002J\u0006\u0010\"\u001a\u00020\u001cJ\u0006\u0010#\u001a\u00020\u0013J\u0010\u0010$\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u0016\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0005J\u0010\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u0005H\u0002J\b\u0010*\u001a\u00020\u0013H\u0002J\u0010\u0010+\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\b\u0010,\u001a\u00020\u0013H\u0002R\u001c\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0012\u0010\f\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lokhttp3/internal/http2/Hpack$Reader;", "", "source", "Lokio/Source;", "headerTableSizeSetting", "", "maxDynamicTableByteCount", "(Lokio/Source;II)V", "dynamicTable", "", "Lokhttp3/internal/http2/Header;", "[Lokhttp3/internal/http2/Header;", "dynamicTableByteCount", "headerCount", "headerList", "", "nextHeaderIndex", "Lokio/BufferedSource;", "adjustDynamicTableByteCount", "", "clearDynamicTable", "dynamicTableIndex", "index", "evictToRecoverBytes", "bytesToRecover", "getAndResetHeaderList", "", "getName", "Lokio/ByteString;", "insertIntoDynamicTable", "entry", "isStaticHeader", "", "readByte", "readByteString", "readHeaders", "readIndexedHeader", "readInt", "firstByte", "prefixMask", "readLiteralHeaderWithIncrementalIndexingIndexedName", "nameIndex", "readLiteralHeaderWithIncrementalIndexingNewName", "readLiteralHeaderWithoutIndexingIndexedName", "readLiteralHeaderWithoutIndexingNewName", "okhttp"})
    public static final class Reader {
        private final int headerTableSizeSetting;
        private int maxDynamicTableByteCount;
        private final List<Header> headerList;
        private final BufferedSource source;
        @JvmField
        private Header[] dynamicTable;
        private int nextHeaderIndex;
        @JvmField
        private int headerCount;
        @JvmField
        private int dynamicTableByteCount;

        /*
         * WARNING - void declaration
         */
        @JvmOverloads
        private Reader(Source source, int headerTableSizeSetting, int maxDynamicTableByteCount) {
            void var1_1;
            void var3_3;
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            this.headerTableSizeSetting = var2_2;
            this.maxDynamicTableByteCount = var3_3;
            this.headerList = new ArrayList();
            this.source = Okio.buffer((Source)var1_1);
            this.dynamicTable = new Header[8];
            this.nextHeaderIndex = this.dynamicTable.length - 1;
        }

        public /* synthetic */ Reader(Source source, int n, int n2, int n3) {
            this(source, 4096, 4096);
        }

        /*
         * WARNING - void declaration
         */
        public final List<Header> getAndResetHeaderList() {
            void var1_1;
            List result = CollectionsKt.toList((Iterable)this.headerList);
            this.headerList.clear();
            return var1_1;
        }

        private final void adjustDynamicTableByteCount() {
            if (this.maxDynamicTableByteCount < this.dynamicTableByteCount) {
                if (this.maxDynamicTableByteCount == 0) {
                    this.clearDynamicTable();
                    return;
                }
                Reader reader = this;
                reader.evictToRecoverBytes(reader.dynamicTableByteCount - this.maxDynamicTableByteCount);
            }
        }

        private final void clearDynamicTable() {
            ArraysKt.fill$default((Object[])this.dynamicTable, null, (int)0, (int)0, (int)6, null);
            this.nextHeaderIndex = this.dynamicTable.length - 1;
            this.headerCount = 0;
            this.dynamicTableByteCount = 0;
        }

        /*
         * WARNING - void declaration
         */
        private final int evictToRecoverBytes(int bytesToRecover) {
            void var2_2;
            int entriesToEvict = 0;
            if (bytesToRecover > 0) {
                int j = this.dynamicTable.length - 1;
                while (j >= this.nextHeaderIndex && bytesToRecover > 0) {
                    Header toEvict;
                    Intrinsics.checkNotNull((Object)this.dynamicTable[j]);
                    bytesToRecover -= toEvict.hpackSize;
                    this.dynamicTableByteCount -= toEvict.hpackSize;
                    int n = this.headerCount;
                    this.headerCount = n + -1;
                    n = entriesToEvict;
                    entriesToEvict = n + 1;
                    n = j;
                    j = n + -1;
                }
                System.arraycopy(this.dynamicTable, this.nextHeaderIndex + 1, this.dynamicTable, this.nextHeaderIndex + 1 + entriesToEvict, this.headerCount);
                this.nextHeaderIndex += entriesToEvict;
            }
            return (int)var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public final void readHeaders() throws IOException {
            while (!this.source.exhausted()) {
                void var1_1;
                Object object;
                int n;
                int index22;
                int b = Util.and(this.source.readByte(), 255);
                if (b == 128) {
                    throw new IOException("index == 0");
                }
                if ((b & 0x80) == 128) {
                    index22 = this.readInt(b, 127);
                    n = index22 - 1;
                    Reader index22 = this;
                    if (Reader.isStaticHeader(n)) {
                        object = INSTANCE.getSTATIC_HEADER_TABLE()[n];
                        index22.headerList.add((Header)object);
                        continue;
                    }
                    int n2 = index22.dynamicTableIndex(n - INSTANCE.getSTATIC_HEADER_TABLE().length);
                    if (n2 < 0 || n2 >= index22.dynamicTable.length) {
                        throw new IOException(Intrinsics.stringPlus((String)"Header index too large ", (Object)(n + 1)));
                    }
                    Collection collection = index22.headerList;
                    Header header = index22.dynamicTable[n2];
                    Intrinsics.checkNotNull((Object)header);
                    collection.add(header);
                    continue;
                }
                if (index22 == 64) {
                    Reader index22 = this;
                    ByteString byteString = Hpack.checkLowercase(index22.readByteString());
                    object = index22.readByteString();
                    index22.insertIntoDynamicTable(-1, new Header(byteString, (ByteString)object));
                    continue;
                }
                if ((index22 & 0x40) == 64) {
                    index22 = this.readInt(index22, 63);
                    n = index22 - 1;
                    Reader index = this;
                    object = index.getName(n);
                    ByteString byteString = index.readByteString();
                    index.insertIntoDynamicTable(-1, new Header((ByteString)object, byteString));
                    continue;
                }
                if ((index22 & 0x20) == 32) {
                    this.maxDynamicTableByteCount = this.readInt(index22, 31);
                    if (this.maxDynamicTableByteCount < 0 || this.maxDynamicTableByteCount > this.headerTableSizeSetting) {
                        throw new IOException(Intrinsics.stringPlus((String)"Invalid dynamic table size update ", (Object)this.maxDynamicTableByteCount));
                    }
                    this.adjustDynamicTableByteCount();
                    continue;
                }
                if (index22 == 16 || index22 == 0) {
                    Reader index = this;
                    ByteString byteString = Hpack.checkLowercase(index.readByteString());
                    object = index.readByteString();
                    index.headerList.add(new Header(byteString, (ByteString)object));
                    continue;
                }
                index22 = this.readInt(index22, 15);
                n = var1_1 - true;
                Reader reader = this;
                object = reader.getName(n);
                ByteString byteString = reader.readByteString();
                reader.headerList.add(new Header((ByteString)object, byteString));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final int dynamicTableIndex(int index) {
            void var1_1;
            return this.nextHeaderIndex + 1 + var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private final ByteString getName(int index) throws IOException {
            void var2_2;
            if (Reader.isStaticHeader(index)) {
                return Hpack.INSTANCE.getSTATIC_HEADER_TABLE()[index].name;
            }
            int dynamicTableIndex = this.dynamicTableIndex(index - INSTANCE.getSTATIC_HEADER_TABLE().length);
            if (dynamicTableIndex < 0 || dynamicTableIndex >= this.dynamicTable.length) {
                void var1_1;
                throw new IOException(Intrinsics.stringPlus((String)"Header index too large ", (Object)((int)(var1_1 + true))));
            }
            Header header = this.dynamicTable[var2_2];
            Intrinsics.checkNotNull((Object)header);
            return header.name;
        }

        private static boolean isStaticHeader(int index) {
            if (index >= 0) {
                int n;
                if (n <= INSTANCE.getSTATIC_HEADER_TABLE().length - 1) {
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private final void insertIntoDynamicTable(int index, Header entry) {
            void var3_5;
            void var2_4;
            this.headerList.add(entry);
            int delta = entry.hpackSize;
            if (delta > this.maxDynamicTableByteCount) {
                this.clearDynamicTable();
                return;
            }
            int bytesToRecover = this.dynamicTableByteCount + delta - this.maxDynamicTableByteCount;
            this.evictToRecoverBytes(bytesToRecover);
            if (this.headerCount + 1 > this.dynamicTable.length) {
                Header[] doubled = new Header[this.dynamicTable.length << 1];
                System.arraycopy(this.dynamicTable, 0, doubled, this.dynamicTable.length, this.dynamicTable.length);
                this.nextHeaderIndex = this.dynamicTable.length - 1;
                this.dynamicTable = doubled;
            }
            int doubled = this.nextHeaderIndex;
            this.nextHeaderIndex = doubled + -1;
            this.dynamicTable[n] = var2_4;
            int n = this.headerCount;
            this.headerCount = n + 1;
            this.dynamicTableByteCount += var3_5;
        }

        private final int readByte() throws IOException {
            return Util.and(this.source.readByte(), 255);
        }

        /*
         * WARNING - void declaration
         */
        private int readInt(int firstByte, int prefixMask) throws IOException {
            void var2_2;
            void var3_3;
            int b;
            int prefix = firstByte & prefixMask;
            if (prefix < prefixMask) {
                return prefix;
            }
            int result = prefixMask;
            int shift = 0;
            while (((b = this.readByte()) & 0x80) != 0) {
                result += (b & 0x7F) << shift;
                shift += 7;
            }
            return (int)(var1_1 += var3_3 << var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private ByteString readByteString() throws IOException {
            void var3_4;
            void var2_3;
            int firstByte = this.readByte();
            boolean huffmanDecode = (firstByte & 0x80) == 128;
            long length = this.readInt(firstByte, 127);
            if (var2_3 != false) {
                void var1_2;
                Buffer decodeBuffer = new Buffer();
                Huffman.decode(this.source, length, (BufferedSink)decodeBuffer);
                return var1_2.readByteString();
            }
            return this.source.readByteString((long)var3_4);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\u0018\u00002\u00020\u0001B#\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J\u000e\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dJ\u0014\u0010\u001e\u001a\u00020\u00142\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0 J\u001e\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0003R\u001c\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0012\u0010\r\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lokhttp3/internal/http2/Hpack$Writer;", "", "headerTableSizeSetting", "", "useCompression", "", "out", "Lokio/Buffer;", "(IZLokio/Buffer;)V", "dynamicTable", "", "Lokhttp3/internal/http2/Header;", "[Lokhttp3/internal/http2/Header;", "dynamicTableByteCount", "emitDynamicTableSizeUpdate", "headerCount", "maxDynamicTableByteCount", "nextHeaderIndex", "smallestHeaderTableSizeSetting", "adjustDynamicTableByteCount", "", "clearDynamicTable", "evictToRecoverBytes", "bytesToRecover", "insertIntoDynamicTable", "entry", "resizeHeaderTable", "writeByteString", "data", "Lokio/ByteString;", "writeHeaders", "headerBlock", "", "writeInt", "value", "prefixMask", "bits", "okhttp"})
    public static final class Writer {
        @JvmField
        private int headerTableSizeSetting;
        private final boolean useCompression;
        private final Buffer out;
        private int smallestHeaderTableSizeSetting;
        private boolean emitDynamicTableSizeUpdate;
        @JvmField
        private int maxDynamicTableByteCount;
        @JvmField
        private Header[] dynamicTable;
        private int nextHeaderIndex;
        @JvmField
        private int headerCount;
        @JvmField
        private int dynamicTableByteCount;

        /*
         * WARNING - void declaration
         */
        @JvmOverloads
        private Writer(int headerTableSizeSetting, boolean useCompression, Buffer out) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            this.headerTableSizeSetting = var1_1;
            this.useCompression = var2_2;
            this.out = var3_3;
            this.smallestHeaderTableSizeSetting = Integer.MAX_VALUE;
            this.maxDynamicTableByteCount = this.headerTableSizeSetting;
            this.dynamicTable = new Header[8];
            this.nextHeaderIndex = this.dynamicTable.length - 1;
        }

        public /* synthetic */ Writer(int n, boolean bl, Buffer buffer, int n2) {
            this(4096, true, buffer);
        }

        private final void clearDynamicTable() {
            ArraysKt.fill$default((Object[])this.dynamicTable, null, (int)0, (int)0, (int)6, null);
            this.nextHeaderIndex = this.dynamicTable.length - 1;
            this.headerCount = 0;
            this.dynamicTableByteCount = 0;
        }

        /*
         * WARNING - void declaration
         */
        private final int evictToRecoverBytes(int bytesToRecover) {
            void var2_2;
            int entriesToEvict = 0;
            if (bytesToRecover > 0) {
                int j = this.dynamicTable.length - 1;
                while (j >= this.nextHeaderIndex && bytesToRecover > 0) {
                    Header header = this.dynamicTable[j];
                    Intrinsics.checkNotNull((Object)header);
                    bytesToRecover -= header.hpackSize;
                    Header header2 = this.dynamicTable[j];
                    Intrinsics.checkNotNull((Object)header2);
                    this.dynamicTableByteCount -= header2.hpackSize;
                    int n = this.headerCount;
                    this.headerCount = n + -1;
                    n = entriesToEvict;
                    entriesToEvict = n + 1;
                    n = j;
                    j = n + -1;
                }
                System.arraycopy(this.dynamicTable, this.nextHeaderIndex + 1, this.dynamicTable, this.nextHeaderIndex + 1 + entriesToEvict, this.headerCount);
                Arrays.fill(this.dynamicTable, this.nextHeaderIndex + 1, this.nextHeaderIndex + 1 + entriesToEvict, null);
                this.nextHeaderIndex += entriesToEvict;
            }
            return (int)var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private final void insertIntoDynamicTable(Header entry) {
            void var2_2;
            void var1_1;
            int delta = entry.hpackSize;
            if (delta > this.maxDynamicTableByteCount) {
                this.clearDynamicTable();
                return;
            }
            int bytesToRecover = this.dynamicTableByteCount + delta - this.maxDynamicTableByteCount;
            this.evictToRecoverBytes(bytesToRecover);
            if (this.headerCount + 1 > this.dynamicTable.length) {
                Header[] doubled = new Header[this.dynamicTable.length << 1];
                System.arraycopy(this.dynamicTable, 0, doubled, this.dynamicTable.length, this.dynamicTable.length);
                this.nextHeaderIndex = this.dynamicTable.length - 1;
                this.dynamicTable = doubled;
            }
            int doubled = this.nextHeaderIndex;
            this.nextHeaderIndex = doubled + -1;
            this.dynamicTable[n] = var1_1;
            int n = this.headerCount;
            this.headerCount = n + 1;
            this.dynamicTableByteCount += var2_2;
        }

        public final void writeHeaders(List<Header> headerBlock) throws IOException {
            Intrinsics.checkNotNullParameter(headerBlock, (String)"headerBlock");
            if (this.emitDynamicTableSizeUpdate) {
                if (this.smallestHeaderTableSizeSetting < this.maxDynamicTableByteCount) {
                    Writer writer = this;
                    writer.writeInt(writer.smallestHeaderTableSizeSetting, 31, 32);
                }
                this.emitDynamicTableSizeUpdate = false;
                this.smallestHeaderTableSizeSetting = Integer.MAX_VALUE;
                Writer writer = this;
                writer.writeInt(writer.maxDynamicTableByteCount, 31, 32);
            }
            int n = 0;
            int n2 = headerBlock.size();
            while (n < n2) {
                int i = n++;
                Header header = headerBlock.get(i);
                ByteString name = header.name.toAsciiLowercase();
                ByteString value = header.value;
                int headerIndex = -1;
                int headerNameIndex = -1;
                Integer staticIndex = INSTANCE.getNAME_TO_FIRST_INDEX().get(name);
                if (staticIndex != null) {
                    headerNameIndex = staticIndex + 1;
                    boolean bl = 2 <= headerNameIndex ? headerNameIndex < 8 : false;
                    if (bl) {
                        if (Intrinsics.areEqual((Object)Hpack.INSTANCE.getSTATIC_HEADER_TABLE()[headerNameIndex - 1].value, (Object)value)) {
                            headerIndex = headerNameIndex;
                        } else if (Intrinsics.areEqual((Object)Hpack.INSTANCE.getSTATIC_HEADER_TABLE()[headerNameIndex].value, (Object)value)) {
                            headerIndex = headerNameIndex + 1;
                        }
                    }
                }
                if (headerIndex == -1) {
                    int n3 = this.nextHeaderIndex + 1;
                    int n4 = this.dynamicTable.length;
                    while (n3 < n4) {
                        int j = n3++;
                        Header header2 = this.dynamicTable[j];
                        Intrinsics.checkNotNull((Object)header2);
                        if (!Intrinsics.areEqual((Object)header2.name, (Object)name)) continue;
                        Header header3 = this.dynamicTable[j];
                        Intrinsics.checkNotNull((Object)header3);
                        if (Intrinsics.areEqual((Object)header3.value, (Object)value)) {
                            headerIndex = j - this.nextHeaderIndex + INSTANCE.getSTATIC_HEADER_TABLE().length;
                            break;
                        }
                        if (headerNameIndex != -1) continue;
                        headerNameIndex = j - this.nextHeaderIndex + INSTANCE.getSTATIC_HEADER_TABLE().length;
                    }
                }
                if (headerIndex != -1) {
                    this.writeInt(headerIndex, 127, 128);
                    continue;
                }
                if (headerNameIndex == -1) {
                    this.out.writeByte(64);
                    this.writeByteString(name);
                    this.writeByteString(value);
                    this.insertIntoDynamicTable(header);
                    continue;
                }
                if (name.startsWith(Header.PSEUDO_PREFIX) && !Intrinsics.areEqual((Object)Header.TARGET_AUTHORITY, (Object)name)) {
                    this.writeInt(headerNameIndex, 15, 0);
                    this.writeByteString(value);
                    continue;
                }
                this.writeInt(headerNameIndex, 63, 64);
                this.writeByteString(value);
                this.insertIntoDynamicTable(header);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void writeInt(int value, int prefixMask, int bits) {
            void var1_1;
            void var3_3;
            if (value < prefixMask) {
                this.out.writeByte(bits | value);
                return;
            }
            this.out.writeByte(var3_3 | prefixMask);
            value -= prefixMask;
            while (value >= 128) {
                void var2_2;
                int b = value & 0x7F;
                this.out.writeByte(var2_2 | 0x80);
                value >>>= 7;
            }
            this.out.writeByte((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private void writeByteString(ByteString data) throws IOException {
            void var1_1;
            ByteString byteString;
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (this.useCompression) {
                byteString = data;
                if (Huffman.encodedLength(data) < byteString.getSize$okio()) {
                    ByteString huffmanBytes;
                    Buffer huffmanBuffer = new Buffer();
                    Huffman.encode(data, (BufferedSink)huffmanBuffer);
                    byteString = huffmanBytes = byteString.readByteString();
                    this.writeInt(byteString.getSize$okio(), 127, 128);
                    this.out.write((ByteString)var1_1);
                    return;
                }
            }
            byteString = var1_1;
            this.writeInt(byteString.getSize$okio(), 127, 0);
            this.out.write((ByteString)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final void resizeHeaderTable(int headerTableSizeSetting) {
            void var1_1;
            this.headerTableSizeSetting = headerTableSizeSetting;
            int effectiveHeaderTableSize = Math.min(headerTableSizeSetting, 16384);
            if (this.maxDynamicTableByteCount == effectiveHeaderTableSize) {
                return;
            }
            if (effectiveHeaderTableSize < this.maxDynamicTableByteCount) {
                this.smallestHeaderTableSizeSetting = Math.min(this.smallestHeaderTableSizeSetting, effectiveHeaderTableSize);
            }
            this.emitDynamicTableSizeUpdate = true;
            this.maxDynamicTableByteCount = var1_1;
            Writer writer = this;
            if (writer.maxDynamicTableByteCount < writer.dynamicTableByteCount) {
                if (writer.maxDynamicTableByteCount == 0) {
                    writer.clearDynamicTable();
                    return;
                }
                Writer writer2 = writer;
                writer2.evictToRecoverBytes(writer2.dynamicTableByteCount - writer.maxDynamicTableByteCount);
            }
        }
    }
}

