/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import com.ibm.icu.text.UnicodeSet;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import okhttp3.Headers;
import okhttp3.internal.Util;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.http2.ConnectionShutdownException;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Http2Reader;
import okhttp3.internal.http2.Http2Stream;
import okhttp3.internal.http2.Http2Writer;
import okhttp3.internal.http2.PushObserver;
import okhttp3.internal.http2.Settings;
import okhttp3.internal.platform.Platform;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u0000 \u0099\u00012\u00020\u0001:\b\u0098\u0001\u0099\u0001\u009a\u0001\u009b\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010P\u001a\u00020QJ\b\u0010R\u001a\u00020QH\u0016J'\u0010R\u001a\u00020Q2\u0006\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020T2\b\u0010V\u001a\u0004\u0018\u00010WH\u0000\u00a2\u0006\u0002\bXJ\u0012\u0010Y\u001a\u00020Q2\b\u0010Z\u001a\u0004\u0018\u00010WH\u0002J\u0006\u0010[\u001a\u00020QJ\u0010\u0010\\\u001a\u0004\u0018\u00010B2\u0006\u0010]\u001a\u00020\u0012J\u000e\u0010^\u001a\u00020\t2\u0006\u0010_\u001a\u00020\u0006J&\u0010`\u001a\u00020B2\u0006\u0010a\u001a\u00020\u00122\f\u0010b\u001a\b\u0012\u0004\u0012\u00020d0c2\u0006\u0010e\u001a\u00020\tH\u0002J\u001c\u0010`\u001a\u00020B2\f\u0010b\u001a\b\u0012\u0004\u0012\u00020d0c2\u0006\u0010e\u001a\u00020\tJ\u0006\u0010f\u001a\u00020\u0012J-\u0010g\u001a\u00020Q2\u0006\u0010h\u001a\u00020\u00122\u0006\u0010i\u001a\u00020j2\u0006\u0010k\u001a\u00020\u00122\u0006\u0010l\u001a\u00020\tH\u0000\u00a2\u0006\u0002\bmJ+\u0010n\u001a\u00020Q2\u0006\u0010h\u001a\u00020\u00122\f\u0010b\u001a\b\u0012\u0004\u0012\u00020d0c2\u0006\u0010l\u001a\u00020\tH\u0000\u00a2\u0006\u0002\boJ#\u0010p\u001a\u00020Q2\u0006\u0010h\u001a\u00020\u00122\f\u0010b\u001a\b\u0012\u0004\u0012\u00020d0cH\u0000\u00a2\u0006\u0002\bqJ\u001d\u0010r\u001a\u00020Q2\u0006\u0010h\u001a\u00020\u00122\u0006\u0010s\u001a\u00020TH\u0000\u00a2\u0006\u0002\btJ$\u0010u\u001a\u00020B2\u0006\u0010a\u001a\u00020\u00122\f\u0010b\u001a\b\u0012\u0004\u0012\u00020d0c2\u0006\u0010e\u001a\u00020\tJ\u0015\u0010v\u001a\u00020\t2\u0006\u0010h\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\bwJ\u0017\u0010x\u001a\u0004\u0018\u00010B2\u0006\u0010h\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\byJ\r\u0010z\u001a\u00020QH\u0000\u00a2\u0006\u0002\b{J\u000e\u0010|\u001a\u00020Q2\u0006\u0010}\u001a\u00020&J\u000e\u0010~\u001a\u00020Q2\u0006\u0010\u007f\u001a\u00020TJ\u001e\u0010\u0080\u0001\u001a\u00020Q2\t\b\u0002\u0010\u0081\u0001\u001a\u00020\t2\b\b\u0002\u0010E\u001a\u00020FH\u0007J\u0018\u0010\u0082\u0001\u001a\u00020Q2\u0007\u0010\u0083\u0001\u001a\u00020\u0006H\u0000\u00a2\u0006\u0003\b\u0084\u0001J,\u0010\u0085\u0001\u001a\u00020Q2\u0006\u0010h\u001a\u00020\u00122\u0007\u0010\u0086\u0001\u001a\u00020\t2\n\u0010\u0087\u0001\u001a\u0005\u0018\u00010\u0088\u00012\u0006\u0010k\u001a\u00020\u0006J/\u0010\u0089\u0001\u001a\u00020Q2\u0006\u0010h\u001a\u00020\u00122\u0007\u0010\u0086\u0001\u001a\u00020\t2\r\u0010\u008a\u0001\u001a\b\u0012\u0004\u0012\u00020d0cH\u0000\u00a2\u0006\u0003\b\u008b\u0001J\u0007\u0010\u008c\u0001\u001a\u00020QJ\"\u0010\u008c\u0001\u001a\u00020Q2\u0007\u0010\u008d\u0001\u001a\u00020\t2\u0007\u0010\u008e\u0001\u001a\u00020\u00122\u0007\u0010\u008f\u0001\u001a\u00020\u0012J\u0007\u0010\u0090\u0001\u001a\u00020QJ\u001f\u0010\u0091\u0001\u001a\u00020Q2\u0006\u0010h\u001a\u00020\u00122\u0006\u0010\u007f\u001a\u00020TH\u0000\u00a2\u0006\u0003\b\u0092\u0001J\u001f\u0010\u0093\u0001\u001a\u00020Q2\u0006\u0010h\u001a\u00020\u00122\u0006\u0010s\u001a\u00020TH\u0000\u00a2\u0006\u0003\b\u0094\u0001J \u0010\u0095\u0001\u001a\u00020Q2\u0006\u0010h\u001a\u00020\u00122\u0007\u0010\u0096\u0001\u001a\u00020\u0006H\u0000\u00a2\u0006\u0003\b\u0097\u0001R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001b\"\u0004\b$\u0010\u001dR\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010(\"\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u00102\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u001e\u00105\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00104R\u0015\u00107\u001a\u000608R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u000e\u0010;\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010<\u001a\u00020=X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R \u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020B0AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010DR\u000e\u0010E\u001a\u00020FX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010G\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u00104R\u001e\u0010I\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u00104R\u0011\u0010K\u001a\u00020L\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010NR\u000e\u0010O\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u009c\u0001"}, d2={"Lokhttp3/internal/http2/Http2Connection;", "Ljava/io/Closeable;", "builder", "Lokhttp3/internal/http2/Http2Connection$Builder;", "(Lokhttp3/internal/http2/Http2Connection$Builder;)V", "awaitPingsSent", "", "awaitPongsReceived", "client", "", "getClient$okhttp", "()Z", "connectionName", "", "getConnectionName$okhttp", "()Ljava/lang/String;", "currentPushRequests", "", "", "degradedPingsSent", "degradedPongDeadlineNs", "degradedPongsReceived", "intervalPingsSent", "intervalPongsReceived", "isShutdown", "lastGoodStreamId", "getLastGoodStreamId$okhttp", "()I", "setLastGoodStreamId$okhttp", "(I)V", "listener", "Lokhttp3/internal/http2/Http2Connection$Listener;", "getListener$okhttp", "()Lokhttp3/internal/http2/Http2Connection$Listener;", "nextStreamId", "getNextStreamId$okhttp", "setNextStreamId$okhttp", "okHttpSettings", "Lokhttp3/internal/http2/Settings;", "getOkHttpSettings", "()Lokhttp3/internal/http2/Settings;", "peerSettings", "getPeerSettings", "setPeerSettings", "(Lokhttp3/internal/http2/Settings;)V", "pushObserver", "Lokhttp3/internal/http2/PushObserver;", "pushQueue", "Lokhttp3/internal/concurrent/TaskQueue;", "<set-?>", "readBytesAcknowledged", "getReadBytesAcknowledged", "()J", "readBytesTotal", "getReadBytesTotal", "readerRunnable", "Lokhttp3/internal/http2/Http2Connection$ReaderRunnable;", "getReaderRunnable", "()Lokhttp3/internal/http2/Http2Connection$ReaderRunnable;", "settingsListenerQueue", "socket", "Ljava/net/Socket;", "getSocket$okhttp", "()Ljava/net/Socket;", "streams", "", "Lokhttp3/internal/http2/Http2Stream;", "getStreams$okhttp", "()Ljava/util/Map;", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "writeBytesMaximum", "getWriteBytesMaximum", "writeBytesTotal", "getWriteBytesTotal", "writer", "Lokhttp3/internal/http2/Http2Writer;", "getWriter", "()Lokhttp3/internal/http2/Http2Writer;", "writerQueue", "awaitPong", "", "close", "connectionCode", "Lokhttp3/internal/http2/ErrorCode;", "streamCode", "cause", "Ljava/io/IOException;", "close$okhttp", "failConnection", "e", "flush", "getStream", "id", "isHealthy", "nowNs", "newStream", "associatedStreamId", "requestHeaders", "", "Lokhttp3/internal/http2/Header;", "out", "openStreamCount", "pushDataLater", "streamId", "source", "Lokio/BufferedSource;", "byteCount", "inFinished", "pushDataLater$okhttp", "pushHeadersLater", "pushHeadersLater$okhttp", "pushRequestLater", "pushRequestLater$okhttp", "pushResetLater", "errorCode", "pushResetLater$okhttp", "pushStream", "pushedStream", "pushedStream$okhttp", "removeStream", "removeStream$okhttp", "sendDegradedPingLater", "sendDegradedPingLater$okhttp", "setSettings", "settings", "shutdown", "statusCode", "start", "sendConnectionPreface", "updateConnectionFlowControl", "read", "updateConnectionFlowControl$okhttp", "writeData", "outFinished", "buffer", "Lokio/Buffer;", "writeHeaders", "alternating", "writeHeaders$okhttp", "writePing", "reply", "payload1", "payload2", "writePingAndAwaitPong", "writeSynReset", "writeSynReset$okhttp", "writeSynResetLater", "writeSynResetLater$okhttp", "writeWindowUpdateLater", "unacknowledgedBytesRead", "writeWindowUpdateLater$okhttp", "Builder", "Companion", "Listener", "ReaderRunnable", "okhttp"})
public final class Http2Connection
implements Closeable {
    public static final Companion Companion;
    private final boolean client;
    private final Listener listener;
    private final Map<Integer, Http2Stream> streams;
    private final String connectionName;
    private int lastGoodStreamId;
    private int nextStreamId;
    private boolean isShutdown;
    private final TaskRunner taskRunner;
    private final TaskQueue writerQueue;
    private final TaskQueue pushQueue;
    private final TaskQueue settingsListenerQueue;
    private final PushObserver pushObserver;
    private long intervalPingsSent;
    private long intervalPongsReceived;
    private long degradedPingsSent;
    private long degradedPongsReceived;
    private long awaitPongsReceived;
    private long degradedPongDeadlineNs;
    private final Settings okHttpSettings;
    private Settings peerSettings;
    private long readBytesTotal;
    private long readBytesAcknowledged;
    private long writeBytesTotal;
    private long writeBytesMaximum;
    private final Socket socket;
    private final Http2Writer writer;
    private final ReaderRunnable readerRunnable;
    private final Set<Integer> currentPushRequests;
    private static final Settings DEFAULT_SETTINGS;

    /*
     * WARNING - void declaration
     */
    public Http2Connection(Builder builder) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.client = ((Builder)builder).getClient$okhttp();
        this.listener = ((Builder)builder).getListener$okhttp();
        this.streams = new LinkedHashMap();
        Object object5 = builder;
        object5 = ((Builder)object5).connectionName;
        if (object5 != null) {
            object4 = object5;
        } else {
            Intrinsics.throwUninitializedPropertyAccessException((String)"connectionName");
            object4 = null;
        }
        this.connectionName = object4;
        this.nextStreamId = ((Builder)builder).getClient$okhttp() ? 3 : 2;
        this.taskRunner = ((Builder)builder).getTaskRunner$okhttp();
        this.writerQueue = this.taskRunner.newQueue();
        this.pushQueue = this.taskRunner.newQueue();
        this.settingsListenerQueue = this.taskRunner.newQueue();
        this.pushObserver = ((Builder)builder).getPushObserver$okhttp();
        object5 = new Settings();
        Settings settings = object5;
        Http2Connection http2Connection = this;
        if (((Builder)builder).getClient$okhttp()) {
            settings.set(7, 0x1000000);
        }
        http2Connection.okHttpSettings = object5;
        this.peerSettings = DEFAULT_SETTINGS;
        this.writeBytesMaximum = this.peerSettings.getInitialWindowSize();
        object5 = builder;
        object5 = ((Builder)object5).socket;
        if (object5 != null) {
            object3 = object5;
        } else {
            Intrinsics.throwUninitializedPropertyAccessException((String)"socket");
            object3 = null;
        }
        this.socket = object3;
        object5 = builder;
        object5 = ((Builder)object5).sink;
        if (object5 != null) {
            object2 = object5;
        } else {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sink");
            object2 = null;
        }
        this.writer = new Http2Writer((BufferedSink)object2, this.client);
        object5 = builder;
        object5 = ((Builder)object5).source;
        if (object5 != null) {
            object = object5;
        } else {
            Intrinsics.throwUninitializedPropertyAccessException((String)"source");
            object = null;
        }
        this.readerRunnable = new ReaderRunnable(this, new Http2Reader((BufferedSource)object, this.client));
        this.currentPushRequests = new LinkedHashSet();
        if (((Builder)builder).getPingIntervalMillis$okhttp() != 0) {
            void var2_3;
            void var1_1;
            long pingIntervalNanos = TimeUnit.MILLISECONDS.toNanos(((Builder)builder).getPingIntervalMillis$okhttp());
            builder = this.writerQueue;
            String name$iv = Intrinsics.stringPlus((String)this.connectionName, (Object)" ping");
            var1_1.schedule$7751fff5(new UnicodeSet.XSymbolTable(name$iv, this, pingIntervalNanos){
                private /* synthetic */ Http2Connection this$0;
                private /* synthetic */ long $pingIntervalNanos$inlined;
                {
                    void var1_1;
                    this.this$0 = http2Connection;
                    this.$pingIntervalNanos$inlined = l;
                    super((String)var1_1, false, 2);
                }

                public final long runOnce() {
                    boolean bl;
                    Http2Connection http2Connection = this.this$0;
                    synchronized (http2Connection) {
                        boolean bl2;
                        if (Http2Connection.access$getIntervalPongsReceived$p(this.this$0) < Http2Connection.access$getIntervalPingsSent$p(this.this$0)) {
                            bl2 = true;
                        } else {
                            long l = Http2Connection.access$getIntervalPingsSent$p(this.this$0);
                            Http2Connection.access$setIntervalPingsSent$p(this.this$0, l + 1L);
                            bl2 = false;
                        }
                        bl = bl2;
                    }
                    boolean bl3 = bl;
                    if (bl3) {
                        Http2Connection.access$failConnection(this.this$0, null);
                        return -1L;
                    }
                    this.this$0.writePing(false, 1, 0);
                    return this.$pingIntervalNanos$inlined;
                }
            }, (long)var2_3);
        }
    }

    public final boolean getClient$okhttp() {
        return this.client;
    }

    public final Listener getListener$okhttp() {
        return this.listener;
    }

    public final Map<Integer, Http2Stream> getStreams$okhttp() {
        return this.streams;
    }

    public final String getConnectionName$okhttp() {
        return this.connectionName;
    }

    public final int getLastGoodStreamId$okhttp() {
        return this.lastGoodStreamId;
    }

    /*
     * WARNING - void declaration
     */
    public final void setLastGoodStreamId$okhttp(int n) {
        void var1_1;
        this.lastGoodStreamId = var1_1;
    }

    public final int getNextStreamId$okhttp() {
        return this.nextStreamId;
    }

    public final Settings getOkHttpSettings() {
        return this.okHttpSettings;
    }

    public final Settings getPeerSettings() {
        return this.peerSettings;
    }

    /*
     * WARNING - void declaration
     */
    public final void setPeerSettings(Settings settings) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"<set-?>");
        this.peerSettings = var1_1;
    }

    public final long getWriteBytesMaximum() {
        return this.writeBytesMaximum;
    }

    public final Http2Writer getWriter() {
        return this.writer;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized Http2Stream getStream(int id) {
        void var1_1;
        return this.streams.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized Http2Stream removeStream$okhttp(int streamId) {
        void var1_2;
        Http2Stream stream = this.streams.remove(streamId);
        Http2Connection http2Connection = this;
        ((Object)http2Connection).notifyAll();
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void updateConnectionFlowControl$okhttp(long read) {
        void var1_1;
        this.readBytesTotal += var1_1;
        long readBytesToAcknowledge = this.readBytesTotal - this.readBytesAcknowledged;
        if (readBytesToAcknowledge >= (long)(this.okHttpSettings.getInitialWindowSize() / 2)) {
            void var3_2;
            this.writeWindowUpdateLater$okhttp(0, readBytesToAcknowledge);
            this.readBytesAcknowledged += var3_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Http2Stream newStream(List<Header> requestHeaders, boolean out) throws IOException {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
        return this.newStream(0, (List<Header>)var1_1, (boolean)var2_2);
    }

    /*
     * Unable to fully structure code
     */
    private final Http2Stream newStream(int associatedStreamId, List<Header> requestHeaders, boolean out) throws IOException {
        outFinished = out == false;
        var6_6 = this.writer;
        synchronized (var6_6) {
            var7_7 = this;
            synchronized (var7_7) {
                var8_8 = this;
                if (var8_8.nextStreamId > 0x3FFFFFFF) {
                    this.shutdown(ErrorCode.REFUSED_STREAM);
                }
                if (this.isShutdown) {
                    throw new ConnectionShutdownException();
                }
                var8_8 = this;
                streamId = var8_8.nextStreamId;
                var8_8 = this;
                var8_9 = var8_8.nextStreamId + 2;
                var4_14 = var8_8;
                var8_8.nextStreamId = var8_9;
                stream = new Http2Stream(streamId, this, outFinished, false, null);
                if (!out) ** GOTO lbl-1000
                v0 = this;
                var8_10 = v0;
                var8_10 = this;
                if (v0.writeBytesTotal >= var8_10.writeBytesMaximum || stream.getWriteBytesTotal() >= stream.getWriteBytesMaximum()) lbl-1000:
                // 2 sources

                {
                    v1 = true;
                } else {
                    v1 = flushHeaders = false;
                }
                if (stream.isOpen()) {
                    var8_11 = this;
                    var8_11.streams.put(streamId, stream);
                }
            }
            var8_12 = this;
            var8_12.writer.headers((boolean)var1_1, streamId, (List<Header>)var2_4);
        }
        if (var3_5 != false) {
            this.writer.flush();
        }
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    public final void writeHeaders$okhttp(int streamId, boolean outFinished, List<Header> alternating) throws IOException {
        void var3_3;
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter(alternating, (String)"alternating");
        this.writer.headers((boolean)var2_2, (int)var1_1, (List<Header>)var3_3);
    }

    public final void writeData(int streamId, boolean outFinished, Buffer buffer, long byteCount3) throws IOException {
        if (byteCount3 == 0L) {
            this.writer.data(outFinished, streamId, buffer, 0);
            return;
        }
        long byteCount2 = byteCount3;
        while (byteCount2 > 0L) {
            int toWrite;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                Http2Connection http2Connection2;
                try {
                    while (true) {
                        Http2Connection http2Connection3 = this;
                        http2Connection2 = http2Connection3;
                        http2Connection2 = this;
                        if (http2Connection3.writeBytesTotal >= http2Connection2.writeBytesMaximum) {
                            http2Connection2 = this;
                            if (!http2Connection2.streams.containsKey(streamId)) {
                                throw new IOException("stream closed");
                            }
                            Http2Connection byteCount3 = this;
                            ((Object)byteCount3).wait();
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
                Http2Connection http2Connection4 = this;
                http2Connection2 = http2Connection4;
                http2Connection2 = this;
                int byteCount3 = (int)Math.min(byteCount2, http2Connection4.writeBytesMaximum - http2Connection2.writeBytesTotal);
                http2Connection2 = this;
                toWrite = Math.min(byteCount3, http2Connection2.writer.maxDataLength());
                http2Connection2 = this;
                http2Connection2.writeBytesTotal += (long)toWrite;
            }
            this.writer.data(outFinished && (byteCount2 -= (long)toWrite) == 0L, streamId, buffer, toWrite);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void writeSynResetLater$okhttp(int streamId, ErrorCode errorCode) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
        TaskQueue taskQueue = this.writerQueue;
        String name$iv = this.connectionName + '[' + streamId + "] writeSynReset";
        taskQueue.schedule$7751fff5(new UnicodeSet.XSymbolTable(name$iv, true, this, (int)var1_1, (ErrorCode)var2_2){
            private /* synthetic */ Http2Connection this$0;
            private /* synthetic */ int $streamId$inlined;
            private /* synthetic */ ErrorCode $errorCode$inlined;
            {
                void var1_1;
                this.this$0 = http2Connection;
                this.$streamId$inlined = n;
                this.$errorCode$inlined = errorCode;
                super((String)var1_1, true);
            }

            /*
             * WARNING - void declaration
             */
            public final long runOnce() {
                try {
                    this.this$0.writeSynReset$okhttp(this.$streamId$inlined, this.$errorCode$inlined);
                }
                catch (IOException e) {
                    void var1_1;
                    Http2Connection.access$failConnection(this.this$0, (IOException)var1_1);
                }
                return -1L;
            }
        }, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeSynReset$okhttp(int streamId, ErrorCode statusCode) throws IOException {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)statusCode), (String)"statusCode");
        this.writer.rstStream((int)var1_1, (ErrorCode)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeWindowUpdateLater$okhttp(int streamId, long unacknowledgedBytesRead) {
        void var2_2;
        void var1_1;
        void this_$iv;
        TaskQueue taskQueue = this.writerQueue;
        String name$iv = this.connectionName + '[' + streamId + "] windowUpdate";
        this_$iv.schedule$7751fff5(new UnicodeSet.XSymbolTable(name$iv, true, this, (int)var1_1, (long)var2_2){
            private /* synthetic */ Http2Connection this$0;
            private /* synthetic */ int $streamId$inlined;
            private /* synthetic */ long $unacknowledgedBytesRead$inlined;
            {
                void var1_1;
                this.this$0 = http2Connection;
                this.$streamId$inlined = n;
                this.$unacknowledgedBytesRead$inlined = l;
                super((String)var1_1, true);
            }

            /*
             * WARNING - void declaration
             */
            public final long runOnce() {
                try {
                    this.this$0.getWriter().windowUpdate(this.$streamId$inlined, this.$unacknowledgedBytesRead$inlined);
                }
                catch (IOException e) {
                    void var1_1;
                    Http2Connection.access$failConnection(this.this$0, (IOException)var1_1);
                }
                return -1L;
            }
        }, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public final void writePing(boolean reply, int payload1, int payload2) {
        try {
            void var3_4;
            void var2_3;
            this.writer.ping(reply, (int)var2_3, (int)var3_4);
            return;
        }
        catch (IOException e) {
            void var1_2;
            this.failConnection((IOException)var1_2);
            return;
        }
    }

    public final void flush() throws IOException {
        this.writer.flush();
    }

    /*
     * WARNING - void declaration
     */
    private void shutdown(ErrorCode statusCode) throws IOException {
        Intrinsics.checkNotNullParameter((Object)((Object)statusCode), (String)"statusCode");
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            void var1_1;
            void var3_5;
            Http2Connection http2Connection;
            Ref.IntRef lastGoodStreamId = new Ref.IntRef();
            Http2Connection http2Connection2 = this;
            synchronized (http2Connection2) {
                if (this.isShutdown) {
                    return;
                }
                this.isShutdown = true;
                http2Connection = this;
                lastGoodStreamId.element = http2Connection.lastGoodStreamId;
            }
            http2Connection = this;
            http2Connection.writer.goAway(var3_5.element, (ErrorCode)var1_1, Util.EMPTY_BYTE_ARRAY);
            return;
        }
    }

    @Override
    public final void close() {
        this.close$okhttp(ErrorCode.NO_ERROR, ErrorCode.CANCEL, null);
    }

    public final void close$okhttp(ErrorCode connectionCode, ErrorCode streamCode, IOException cause) {
        Http2Connection http2Connection;
        Intrinsics.checkNotNullParameter((Object)((Object)connectionCode), (String)"connectionCode");
        Intrinsics.checkNotNullParameter((Object)((Object)streamCode), (String)"streamCode");
        Http2Connection $this$assertThreadDoesntHoldLock$iv = this;
        if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
        }
        try {
            this.shutdown((ErrorCode)((Object)http2Connection));
        }
        catch (IOException iOException) {}
        Http2Stream[] streamsToClose = null;
        http2Connection = this;
        synchronized (http2Connection) {
            Object object = this;
            if (!((Http2Connection)object).streams.isEmpty()) {
                object = this;
                streamsToClose = ((Http2Connection)object).streams.values();
                object = streamsToClose;
                Http2Stream[] http2StreamArray = streamsToClose.toArray(new Http2Stream[0]);
                if (http2StreamArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                streamsToClose = http2StreamArray;
                object = this;
                ((Http2Connection)object).streams.clear();
            }
        }
        Http2Stream[] http2StreamArray = streamsToClose;
        if (http2StreamArray != null) {
            Http2Stream[] $this$forEach$iv = http2StreamArray;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Http2Stream http2Stream;
                Http2Stream stream = http2Stream = $this$forEach$iv[i];
                try {
                    stream.close(streamCode, cause);
                    continue;
                }
                catch (IOException iOException) {}
            }
        }
        try {
            Http2Connection http2Connection2 = this;
            http2Connection2.writer.close();
        }
        catch (IOException iOException) {}
        try {
            Http2Connection http2Connection3 = this;
            http2Connection3.socket.close();
        }
        catch (IOException iOException) {}
        this.writerQueue.shutdown();
        this.pushQueue.shutdown();
        this.settingsListenerQueue.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    private final void failConnection(IOException e) {
        void var1_1;
        ErrorCode errorCode = ErrorCode.PROTOCOL_ERROR;
        this.close$okhttp(errorCode, errorCode, (IOException)var1_1);
    }

    public static /* synthetic */ void start$default$48aa1d6a(Http2Connection http2Connection, boolean n, TaskRunner object, int n2) throws IOException {
        object = TaskRunner.INSTANCE;
        n = 1;
        Intrinsics.checkNotNullParameter((Object)object, (String)"taskRunner");
        if (n) {
            http2Connection.writer.connectionPreface();
            http2Connection.writer.settings(http2Connection.okHttpSettings);
            n = http2Connection.okHttpSettings.getInitialWindowSize();
            if (n != 65535) {
                http2Connection.writer.windowUpdate(0, n - 65535);
            }
        }
        TaskQueue taskQueue = ((TaskRunner)object).newQueue();
        object = http2Connection.connectionName;
        http2Connection = http2Connection.readerRunnable;
        taskQueue.schedule$7751fff5(new UnicodeSet.XSymbolTable((String)object, true, (Function0<Unit>)http2Connection){
            private /* synthetic */ Function0<Unit> $block;
            {
                void var1_1;
                void var3_3;
                this.$block = var3_3;
                super((String)var1_1, true);
            }

            public final long runOnce() {
                this.$block.invoke();
                return -1L;
            }
        }, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized boolean isHealthy(long nowNs) {
        void var1_1;
        if (this.isShutdown) {
            return false;
        }
        return this.degradedPongsReceived >= this.degradedPingsSent || var1_1 < this.degradedPongDeadlineNs;
    }

    /*
     * WARNING - void declaration
     */
    public final void sendDegradedPingLater$okhttp() {
        void var2_4;
        Object object = this;
        synchronized (object) {
            if (this.degradedPongsReceived < this.degradedPingsSent) {
                return;
            }
            long l = this.degradedPingsSent;
            this.degradedPingsSent = l + 1L;
            this.degradedPongDeadlineNs = System.nanoTime() + 1000000000L;
        }
        object = this.writerQueue;
        String name$iv = Intrinsics.stringPlus((String)this.connectionName, (Object)" ping");
        ((TaskQueue)object).schedule$7751fff5(new UnicodeSet.XSymbolTable((String)var2_4, true, this){
            private /* synthetic */ Http2Connection this$0;
            {
                void var1_1;
                this.this$0 = http2Connection;
                super((String)var1_1, true);
            }

            public final long runOnce() {
                this.this$0.writePing(false, 2, 0);
                return -1L;
            }
        }, 0L);
    }

    public static boolean pushedStream$okhttp(int streamId) {
        int n;
        return streamId != 0 && (n & 1) == 0;
    }

    /*
     * WARNING - void declaration
     */
    public final void pushRequestLater$okhttp(int streamId, List<Header> requestHeaders) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
        Object object = this;
        synchronized (object) {
            if (this.currentPushRequests.contains(streamId)) {
                this.writeSynResetLater$okhttp(streamId, ErrorCode.PROTOCOL_ERROR);
                return;
            }
            this.currentPushRequests.add(streamId);
        }
        object = this.pushQueue;
        String name$iv = this.connectionName + '[' + streamId + "] onRequest";
        ((TaskQueue)object).schedule$7751fff5(new UnicodeSet.XSymbolTable(name$iv, true, this, (int)var1_1, (List)var2_2){
            private /* synthetic */ Http2Connection this$0;
            private /* synthetic */ int $streamId$inlined;
            private /* synthetic */ List $requestHeaders$inlined;
            {
                void var1_1;
                this.this$0 = http2Connection;
                this.$streamId$inlined = n;
                this.$requestHeaders$inlined = list;
                super((String)var1_1, true);
            }

            public final long runOnce() {
                Http2Connection.access$getPushObserver$p(this.this$0).onRequest$163bb723(this.$requestHeaders$inlined);
                try {
                    this.this$0.getWriter().rstStream(this.$streamId$inlined, ErrorCode.CANCEL);
                    Http2Connection http2Connection = this.this$0;
                    synchronized (http2Connection) {
                        Http2Connection.access$getCurrentPushRequests$p(this.this$0).remove(this.$streamId$inlined);
                    }
                }
                catch (IOException iOException) {}
                return -1L;
            }
        }, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public final void pushHeadersLater$okhttp(int streamId, List<Header> requestHeaders, boolean inFinished) {
        void var3_3;
        void var2_2;
        void var1_1;
        void this_$iv;
        Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
        TaskQueue taskQueue = this.pushQueue;
        String name$iv = this.connectionName + '[' + streamId + "] onHeaders";
        this_$iv.schedule$7751fff5(new UnicodeSet.XSymbolTable(name$iv, true, this, (int)var1_1, (List)var2_2, (boolean)var3_3){
            private /* synthetic */ Http2Connection this$0;
            private /* synthetic */ int $streamId$inlined;
            private /* synthetic */ List $requestHeaders$inlined;
            private /* synthetic */ boolean $inFinished$inlined;
            {
                void var1_1;
                this.this$0 = http2Connection;
                this.$streamId$inlined = n;
                this.$requestHeaders$inlined = list;
                this.$inFinished$inlined = bl;
                super((String)var1_1, true);
            }

            public final long runOnce() {
                Http2Connection.access$getPushObserver$p(this.this$0).onHeaders$4ec42067(this.$requestHeaders$inlined);
                try {
                    this.this$0.getWriter().rstStream(this.$streamId$inlined, ErrorCode.CANCEL);
                    Http2Connection http2Connection = this.this$0;
                    synchronized (http2Connection) {
                        Http2Connection.access$getCurrentPushRequests$p(this.this$0).remove(this.$streamId$inlined);
                    }
                }
                catch (IOException iOException) {}
                return -1L;
            }
        }, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public final void pushDataLater$okhttp(int streamId, BufferedSource source, int byteCount, boolean inFinished) throws IOException {
        void var3_3;
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Buffer buffer = new Buffer();
        source.require((long)byteCount);
        source.read(buffer, (long)byteCount);
        source = this.pushQueue;
        String name$iv = this.connectionName + '[' + streamId + "] onData";
        var2_2.schedule$7751fff5(new UnicodeSet.XSymbolTable(name$iv, true, this, (int)var1_1, buffer, (int)var3_3, inFinished){
            private /* synthetic */ Http2Connection this$0;
            private /* synthetic */ int $streamId$inlined;
            private /* synthetic */ Buffer $buffer$inlined;
            private /* synthetic */ int $byteCount$inlined;
            private /* synthetic */ boolean $inFinished$inlined;
            {
                void var1_1;
                this.this$0 = http2Connection;
                this.$streamId$inlined = n;
                this.$buffer$inlined = buffer;
                this.$byteCount$inlined = n2;
                this.$inFinished$inlined = bl;
                super((String)var1_1, true);
            }

            public final long runOnce() {
                try {
                    Http2Connection.access$getPushObserver$p(this.this$0).onData$749b27ff((BufferedSource)this.$buffer$inlined, this.$byteCount$inlined);
                    this.this$0.getWriter().rstStream(this.$streamId$inlined, ErrorCode.CANCEL);
                    Http2Connection http2Connection = this.this$0;
                    synchronized (http2Connection) {
                        Http2Connection.access$getCurrentPushRequests$p(this.this$0).remove(this.$streamId$inlined);
                    }
                }
                catch (IOException iOException) {}
                return -1L;
            }
        }, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public final void pushResetLater$okhttp(int streamId, ErrorCode errorCode) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
        TaskQueue taskQueue = this.pushQueue;
        String name$iv = this.connectionName + '[' + streamId + "] onReset";
        taskQueue.schedule$7751fff5(new UnicodeSet.XSymbolTable(name$iv, true, this, (int)var1_1, (ErrorCode)var2_2){
            private /* synthetic */ Http2Connection this$0;
            private /* synthetic */ int $streamId$inlined;
            private /* synthetic */ ErrorCode $errorCode$inlined;
            {
                void var1_1;
                this.this$0 = http2Connection;
                this.$streamId$inlined = n;
                this.$errorCode$inlined = errorCode;
                super((String)var1_1, true);
            }

            public final long runOnce() {
                Http2Connection.access$getPushObserver$p(this.this$0).onReset$613c779f(this.$errorCode$inlined);
                Http2Connection http2Connection = this.this$0;
                synchronized (http2Connection) {
                    Http2Connection.access$getCurrentPushRequests$p(this.this$0).remove(this.$streamId$inlined);
                }
                return -1L;
            }
        }, 0L);
    }

    public static final /* synthetic */ TaskQueue access$getSettingsListenerQueue$p(Http2Connection $this) {
        return $this.settingsListenerQueue;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$failConnection(Http2Connection $this, IOException e) {
        void var1_1;
        $this.failConnection((IOException)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setIntervalPongsReceived$p(Http2Connection $this, long l) {
        void var1_1;
        $this.intervalPongsReceived = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setDegradedPongsReceived$p(Http2Connection $this, long l) {
        void var1_1;
        $this.degradedPongsReceived = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setAwaitPongsReceived$p(Http2Connection $this, long l) {
        void var1_1;
        $this.awaitPongsReceived = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setWriteBytesMaximum$p(Http2Connection $this, long l) {
        void var1_1;
        $this.writeBytesMaximum = var1_1;
    }

    public static final /* synthetic */ Settings access$getDEFAULT_SETTINGS$cp() {
        return DEFAULT_SETTINGS;
    }

    public static final /* synthetic */ long access$getIntervalPingsSent$p(Http2Connection $this) {
        return $this.intervalPingsSent;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setIntervalPingsSent$p(Http2Connection $this, long l) {
        void var1_1;
        $this.intervalPingsSent = var1_1;
    }

    public static final /* synthetic */ Set access$getCurrentPushRequests$p(Http2Connection $this) {
        return $this.currentPushRequests;
    }

    public static final /* synthetic */ PushObserver access$getPushObserver$p(Http2Connection $this) {
        return $this.pushObserver;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_1;
        Settings settings;
        Companion = new Companion(0);
        Settings $this$DEFAULT_SETTINGS_u24lambda_u2d35 = settings = new Settings();
        settings.set(7, 65535);
        var1_1.set(5, 16384);
        DEFAULT_SETTINGS = settings;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u00107\u001a\u000208J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001eJ.\u0010)\u001a\u00020\u00002\u0006\u0010)\u001a\u00020*2\b\b\u0002\u00109\u001a\u00020\f2\b\b\u0002\u0010/\u001a\u0002002\b\b\u0002\u0010#\u001a\u00020$H\u0007R\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020*X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u0010/\u001a\u000200X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106\u00a8\u0006:"}, d2={"Lokhttp3/internal/http2/Http2Connection$Builder;", "", "client", "", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "(ZLokhttp3/internal/concurrent/TaskRunner;)V", "getClient$okhttp", "()Z", "setClient$okhttp", "(Z)V", "connectionName", "", "getConnectionName$okhttp", "()Ljava/lang/String;", "setConnectionName$okhttp", "(Ljava/lang/String;)V", "listener", "Lokhttp3/internal/http2/Http2Connection$Listener;", "getListener$okhttp", "()Lokhttp3/internal/http2/Http2Connection$Listener;", "setListener$okhttp", "(Lokhttp3/internal/http2/Http2Connection$Listener;)V", "pingIntervalMillis", "", "getPingIntervalMillis$okhttp", "()I", "setPingIntervalMillis$okhttp", "(I)V", "pushObserver", "Lokhttp3/internal/http2/PushObserver;", "getPushObserver$okhttp", "()Lokhttp3/internal/http2/PushObserver;", "setPushObserver$okhttp", "(Lokhttp3/internal/http2/PushObserver;)V", "sink", "Lokio/BufferedSink;", "getSink$okhttp", "()Lokio/BufferedSink;", "setSink$okhttp", "(Lokio/BufferedSink;)V", "socket", "Ljava/net/Socket;", "getSocket$okhttp", "()Ljava/net/Socket;", "setSocket$okhttp", "(Ljava/net/Socket;)V", "source", "Lokio/BufferedSource;", "getSource$okhttp", "()Lokio/BufferedSource;", "setSource$okhttp", "(Lokio/BufferedSource;)V", "getTaskRunner$okhttp", "()Lokhttp3/internal/concurrent/TaskRunner;", "build", "Lokhttp3/internal/http2/Http2Connection;", "peerName", "okhttp"})
    public static final class Builder {
        private boolean client;
        private final TaskRunner taskRunner;
        public Socket socket;
        public String connectionName;
        public BufferedSource source;
        public BufferedSink sink;
        private Listener listener;
        private PushObserver pushObserver;
        private int pingIntervalMillis;

        /*
         * WARNING - void declaration
         */
        public Builder(boolean client, TaskRunner taskRunner) {
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)taskRunner, (String)"taskRunner");
            this.client = true;
            this.taskRunner = var2_2;
            this.listener = Listener.REFUSE_INCOMING_STREAMS;
            this.pushObserver = PushObserver.CANCEL;
        }

        public final boolean getClient$okhttp() {
            return this.client;
        }

        public final TaskRunner getTaskRunner$okhttp() {
            return this.taskRunner;
        }

        /*
         * WARNING - void declaration
         */
        private void setSocket$okhttp(Socket socket) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)socket, (String)"<set-?>");
            this.socket = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private void setConnectionName$okhttp(String string) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.connectionName = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private void setSource$okhttp(BufferedSource bufferedSource) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)bufferedSource, (String)"<set-?>");
            this.source = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private void setSink$okhttp(BufferedSink bufferedSink) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)bufferedSink, (String)"<set-?>");
            this.sink = var1_1;
        }

        public final Listener getListener$okhttp() {
            return this.listener;
        }

        /*
         * WARNING - void declaration
         */
        private void setListener$okhttp(Listener listener) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)listener, (String)"<set-?>");
            this.listener = var1_1;
        }

        public final PushObserver getPushObserver$okhttp() {
            return this.pushObserver;
        }

        public final int getPingIntervalMillis$okhttp() {
            return this.pingIntervalMillis;
        }

        /*
         * WARNING - void declaration
         */
        @JvmOverloads
        public final Builder socket(Socket socket, String peerName, BufferedSource source, BufferedSink sink) throws IOException {
            void var3_3;
            void var2_2;
            Builder builder;
            Builder builder2;
            Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
            Intrinsics.checkNotNullParameter((Object)peerName, (String)"peerName");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            Builder $this$socket_u24lambda_u2d0 = builder2 = this;
            builder2.setSocket$okhttp((Socket)((Object)builder));
            builder = $this$socket_u24lambda_u2d0;
            builder.setConnectionName$okhttp(builder.client ? Util.okHttpName + ' ' + peerName : Intrinsics.stringPlus((String)"MockWebServer ", (Object)var2_2));
            $this$socket_u24lambda_u2d0.setSource$okhttp((BufferedSource)var3_3);
            $this$socket_u24lambda_u2d0.setSink$okhttp(sink);
            return builder2;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder listener(Listener listener) {
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            Builder builder2 = builder = this;
            builder.setListener$okhttp((Listener)var1_1);
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder pingIntervalMillis(int pingIntervalMillis) {
            void var1_1;
            Builder builder;
            Builder builder2 = builder = this;
            void var3_5 = var1_1;
            Builder builder3 = builder;
            builder.pingIntervalMillis = var3_5;
            return builder;
        }

        public final Http2Connection build() {
            return new Http2Connection(this);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0086\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u000f\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\u0003H\u0016J8\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J(\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\fH\u0016J \u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0010H\u0016J.\u0010$\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010%\u001a\u00020\f2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0016J\t\u0010)\u001a\u00020\u0003H\u0096\u0002J \u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020\fH\u0016J(\u0010.\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010/\u001a\u00020\f2\u0006\u00100\u001a\u00020\f2\u0006\u00101\u001a\u00020\u0017H\u0016J&\u00102\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00103\u001a\u00020\f2\f\u00104\u001a\b\u0012\u0004\u0012\u00020(0'H\u0016J\u0018\u00105\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u00106\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00107\u001a\u00020\u0014H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u00068"}, d2={"Lokhttp3/internal/http2/Http2Connection$ReaderRunnable;", "Lokhttp3/internal/http2/Http2Reader$Handler;", "Lkotlin/Function0;", "", "reader", "Lokhttp3/internal/http2/Http2Reader;", "(Lokhttp3/internal/http2/Http2Connection;Lokhttp3/internal/http2/Http2Reader;)V", "getReader$okhttp", "()Lokhttp3/internal/http2/Http2Reader;", "ackSettings", "alternateService", "streamId", "", "origin", "", "protocol", "Lokio/ByteString;", "host", "port", "maxAge", "", "applyAndAckSettings", "clearPrevious", "", "settings", "Lokhttp3/internal/http2/Settings;", "data", "inFinished", "source", "Lokio/BufferedSource;", "length", "goAway", "lastGoodStreamId", "errorCode", "Lokhttp3/internal/http2/ErrorCode;", "debugData", "headers", "associatedStreamId", "headerBlock", "", "Lokhttp3/internal/http2/Header;", "invoke", "ping", "ack", "payload1", "payload2", "priority", "streamDependency", "weight", "exclusive", "pushPromise", "promisedStreamId", "requestHeaders", "rstStream", "windowUpdate", "windowSizeIncrement", "okhttp"})
    public final class ReaderRunnable
    implements Function0<Unit>,
    Http2Reader.Handler {
        private final Http2Reader reader;
        final /* synthetic */ Http2Connection this$0;

        /*
         * WARNING - void declaration
         */
        public ReaderRunnable(Http2Connection this$0, Http2Reader reader) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            this.this$0 = var1_1;
            this.reader = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void data(boolean inFinished, int streamId, BufferedSource source, int length) throws IOException {
            void var1_1;
            void var3_3;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            if (Http2Connection.pushedStream$okhttp(streamId)) {
                this.this$0.pushDataLater$okhttp(streamId, source, length, inFinished);
                return;
            }
            Http2Stream dataStream = this.this$0.getStream(streamId);
            if (dataStream == null) {
                void var2_2;
                this.this$0.writeSynResetLater$okhttp((int)var2_2, ErrorCode.PROTOCOL_ERROR);
                this.this$0.updateConnectionFlowControl$okhttp(length);
                source.skip((long)length);
                return;
            }
            dataStream.receiveData((BufferedSource)var3_3, length);
            if (var1_1 != false) {
                dataStream.receiveHeaders(Util.EMPTY_HEADERS, true);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void headers$64c3d190(boolean inFinished, int streamId, List<Header> headerBlock) {
            void var1_1;
            void var3_5;
            Intrinsics.checkNotNullParameter(headerBlock, (String)"headerBlock");
            if (Http2Connection.pushedStream$okhttp(streamId)) {
                this.this$0.pushHeadersLater$okhttp(streamId, headerBlock, inFinished);
                return;
            }
            Http2Connection http2Connection = this.this$0;
            Http2Connection http2Connection2 = this.this$0;
            Http2Connection http2Connection3 = http2Connection;
            synchronized (http2Connection3) {
                Object stream = http2Connection2.getStream(streamId);
                if (stream == null) {
                    void var1_2;
                    void var2_4;
                    if (http2Connection2.isShutdown) {
                        return;
                    }
                    if (streamId <= http2Connection2.getLastGoodStreamId$okhttp()) {
                        return;
                    }
                    if (streamId % 2 == http2Connection2.getNextStreamId$okhttp() % 2) {
                        return;
                    }
                    Object headers = Util.toHeaders(headerBlock);
                    Http2Stream newStream = new Http2Stream(streamId, http2Connection2, false, inFinished, (Headers)headers);
                    http2Connection2.setLastGoodStreamId$okhttp(streamId);
                    headers = http2Connection2.getStreams$okhttp();
                    stream = streamId;
                    headers.put(stream, newStream);
                    headers = http2Connection2.taskRunner.newQueue();
                    String name$iv = http2Connection2.getConnectionName$okhttp() + '[' + (int)var2_4 + "] onStream";
                    var3_5.schedule$7751fff5(new UnicodeSet.XSymbolTable(name$iv, true, http2Connection2, (Http2Stream)var1_2){
                        private /* synthetic */ Http2Connection this$0;
                        private /* synthetic */ Http2Stream $newStream$inlined;
                        {
                            void var1_1;
                            this.this$0 = http2Connection;
                            this.$newStream$inlined = http2Stream;
                            super((String)var1_1, true);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final long runOnce() {
                            try {
                                this.this$0.getListener$okhttp().onStream(this.$newStream$inlined);
                            }
                            catch (IOException e) {
                                Platform.access$getPlatform$cp();
                                Platform.log(Intrinsics.stringPlus((String)"Http2Connection.Listener failure for ", (Object)this.this$0.getConnectionName$okhttp()), 4, e);
                                try {
                                    void var1_1;
                                    this.$newStream$inlined.close(ErrorCode.PROTOCOL_ERROR, (IOException)var1_1);
                                }
                                catch (IOException iOException) {}
                            }
                            return -1L;
                        }
                    }, 0L);
                    return;
                }
            }
            ((Http2Stream)((Object)http2Connection)).receiveHeaders(Util.toHeaders((List<Header>)var3_5), (boolean)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void rstStream(int streamId, ErrorCode errorCode) {
            void var2_3;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
            if (Http2Connection.pushedStream$okhttp(streamId)) {
                this.this$0.pushResetLater$okhttp(streamId, errorCode);
                return;
            }
            Http2Stream http2Stream = this.this$0.removeStream$okhttp((int)var1_1);
            if (http2Stream == null) {
                return;
            }
            http2Stream.receiveRstStream((ErrorCode)var2_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void settings(boolean clearPrevious2, Settings settings) {
            void var2_3;
            void var3_4;
            void var1_2;
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            TaskQueue clearPrevious2 = this.this$0.writerQueue;
            String name$iv = Intrinsics.stringPlus((String)this.this$0.getConnectionName$okhttp(), (Object)" applyAndAckSettings");
            var1_2.schedule$7751fff5(new UnicodeSet.XSymbolTable((String)var3_4, true, this, false, (Settings)var2_3){
                private /* synthetic */ ReaderRunnable this$0;
                private /* synthetic */ boolean $clearPrevious$inlined;
                private /* synthetic */ Settings $settings$inlined;
                {
                    void var1_1;
                    this.this$0 = readerRunnable;
                    this.$clearPrevious$inlined = bl;
                    this.$settings$inlined = settings;
                    super((String)var1_1, true);
                }

                public final long runOnce() {
                    Http2Stream[] http2StreamArray;
                    long l;
                    Object object;
                    Object object2 = this.$settings$inlined;
                    boolean bl = this.$clearPrevious$inlined;
                    ReaderRunnable collection4 = this.this$0;
                    Intrinsics.checkNotNullParameter((Object)object2, (String)"settings");
                    Ref.ObjectRef objectRef = new Ref.ObjectRef();
                    Http2Stream[] http2StreamArray2 = collection4.this$0.getWriter();
                    Http2Connection http2Connection = collection4.this$0;
                    Http2Writer http2Writer = http2StreamArray2;
                    synchronized (http2Writer) {
                        object = http2Connection;
                        synchronized (object) {
                            Http2Stream[] http2StreamArray3;
                            Settings settings;
                            Settings settings2 = http2Connection.getPeerSettings();
                            Ref.ObjectRef objectRef2 = objectRef;
                            if (bl) {
                                settings = object2;
                            } else {
                                Settings settings22 = new Settings();
                                http2StreamArray2 = settings22;
                                Ref.ObjectRef objectRef3 = objectRef2;
                                http2StreamArray2.merge(settings2);
                                http2StreamArray2.merge((Settings)object2);
                                objectRef2 = objectRef3;
                                settings = settings22;
                            }
                            objectRef2.element = settings;
                            long l2 = ((Settings)objectRef.element).getInitialWindowSize();
                            l = l2 - (long)settings2.getInitialWindowSize();
                            if (l == 0L || http2Connection.getStreams$okhttp().isEmpty()) {
                                http2StreamArray3 = null;
                            } else {
                                Collection<Http2Stream> collection3;
                                Collection<Http2Stream> collection = collection3 = http2Connection.getStreams$okhttp().values();
                                Http2Stream[] http2StreamArray4 = collection3.toArray(new Http2Stream[0]);
                                if (http2StreamArray4 == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                                }
                                http2StreamArray3 = http2StreamArray4;
                            }
                            http2StreamArray = http2StreamArray3;
                            http2Connection.setPeerSettings((Settings)objectRef.element);
                            TaskQueue taskQueue = Http2Connection.access$getSettingsListenerQueue$p(http2Connection);
                            object2 = Intrinsics.stringPlus((String)http2Connection.getConnectionName$okhttp(), (Object)" onSettings");
                            taskQueue.schedule$7751fff5(new UnicodeSet.XSymbolTable((String)object2, true, http2Connection, objectRef){
                                private /* synthetic */ Http2Connection this$0;
                                private /* synthetic */ Ref.ObjectRef $newPeerSettings$inlined;
                                {
                                    void var1_1;
                                    this.this$0 = http2Connection;
                                    this.$newPeerSettings$inlined = objectRef;
                                    super((String)var1_1, true);
                                }

                                public final long runOnce() {
                                    this.this$0.getListener$okhttp().onSettings(this.this$0, (Settings)this.$newPeerSettings$inlined.element);
                                    return -1L;
                                }
                            }, 0L);
                        }
                        try {
                            http2Connection.getWriter().applyAndAckSettings((Settings)objectRef.element);
                        }
                        catch (IOException iOException) {
                            Http2Connection.access$failConnection(http2Connection, iOException);
                        }
                    }
                    if (http2StreamArray != null) {
                        for (Http2Stream http2Stream : http2StreamArray) {
                            object = http2Stream;
                            synchronized (object) {
                                http2Stream.addBytesToWriteWindow(l);
                            }
                        }
                    }
                    return -1L;
                }
            }, 0L);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void ping(boolean ack2, int payload12, int payload2) {
            void var3_7;
            void var2_4;
            void name$iv;
            void var1_3;
            if (ack2) {
                Http2Connection ack2 = this.this$0;
                Http2Connection http2Connection = this.this$0;
                synchronized (ack2) {
                    switch (payload12) {
                        case 1: {
                            long l = http2Connection.intervalPongsReceived;
                            Http2Connection.access$setIntervalPongsReceived$p(http2Connection, l + 1L);
                            Long.valueOf(l);
                            break;
                        }
                        case 2: {
                            long l = http2Connection.degradedPongsReceived;
                            Http2Connection.access$setDegradedPongsReceived$p(http2Connection, l + 1L);
                            Long.valueOf(l);
                            break;
                        }
                        case 3: {
                            long l = http2Connection.awaitPongsReceived;
                            Http2Connection.access$setAwaitPongsReceived$p(http2Connection, l + 1L);
                            Http2Connection payload12 = http2Connection;
                            ((Object)payload12).notifyAll();
                            break;
                        }
                    }
                    return;
                }
            }
            TaskQueue ack2 = this.this$0.writerQueue;
            String string = Intrinsics.stringPlus((String)this.this$0.getConnectionName$okhttp(), (Object)" ping");
            Http2Connection http2Connection = this.this$0;
            var1_3.schedule$7751fff5(new UnicodeSet.XSymbolTable((String)name$iv, true, http2Connection, (int)var2_4, (int)var3_7){
                private /* synthetic */ Http2Connection this$0;
                private /* synthetic */ int $payload1$inlined;
                private /* synthetic */ int $payload2$inlined;
                {
                    void var1_1;
                    this.this$0 = http2Connection;
                    this.$payload1$inlined = n;
                    this.$payload2$inlined = n2;
                    super((String)var1_1, true);
                }

                public final long runOnce() {
                    this.this$0.writePing(true, this.$payload1$inlined, this.$payload2$inlined);
                    return -1L;
                }
            }, 0L);
        }

        @Override
        public final void goAway(int lastGoodStreamId, ErrorCode errorCode, ByteString debugData) {
            Http2Stream[] http2StreamArray;
            Http2Connection http2Connection;
            Intrinsics.checkNotNullParameter((Object)errorCode, (String)"errorCode");
            Intrinsics.checkNotNullParameter((Object)debugData, (String)"debugData");
            errorCode = http2Connection;
            errorCode.getSize$okio();
            errorCode = this.this$0;
            http2Connection = this.this$0;
            Object object = errorCode;
            synchronized (object) {
                Collection<Http2Stream> collection = http2Connection.getStreams$okhttp().values();
                errorCode = collection;
                errorCode = collection;
                Http2Stream[] http2StreamArray2 = collection.toArray(new Http2Stream[0]);
                if (http2StreamArray2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                Http2Stream[] streamsCopy = http2StreamArray2;
                http2Connection.isShutdown = true;
            }
            for (Http2Stream http2Stream : (Http2Stream[])http2StreamArray) {
                if (http2Stream.getId() <= lastGoodStreamId || !http2Stream.isLocallyInitiated()) continue;
                http2Stream.receiveRstStream(ErrorCode.REFUSED_STREAM);
                this.this$0.removeStream$okhttp(http2Stream.getId());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void windowUpdate(int streamId22, long windowSizeIncrement2) {
            int streamId22;
            if (streamId22 == 0) {
                Http2Connection streamId22 = this.this$0;
                Http2Connection http2Connection = this.this$0;
                synchronized (streamId22) {
                    Http2Connection http2Connection2 = http2Connection;
                    Http2Connection.access$setWriteBytesMaximum$p(http2Connection2, http2Connection2.getWriteBytesMaximum() + windowSizeIncrement2);
                    Http2Connection windowSizeIncrement2 = http2Connection;
                    ((Object)windowSizeIncrement2).notifyAll();
                    return;
                }
            }
            Http2Stream stream = this.this$0.getStream(streamId22);
            if (stream != null) {
                Http2Stream http2Stream = stream;
                synchronized (http2Stream) {
                    void var2_5;
                    void var1_3;
                    var1_3.addBytesToWriteWindow((long)var2_5);
                    return;
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void pushPromise$16014a7a(int promisedStreamId, List<Header> requestHeaders) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
            this.this$0.pushRequestLater$okhttp((int)var1_1, (List<Header>)var2_2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH&\u00a8\u0006\r"}, d2={"Lokhttp3/internal/http2/Http2Connection$Listener;", "", "()V", "onSettings", "", "connection", "Lokhttp3/internal/http2/Http2Connection;", "settings", "Lokhttp3/internal/http2/Settings;", "onStream", "stream", "Lokhttp3/internal/http2/Http2Stream;", "Companion", "okhttp"})
    public static abstract class Listener {
        @JvmField
        public static final Listener REFUSE_INCOMING_STREAMS;

        public abstract void onStream(Http2Stream var1) throws IOException;

        /*
         * WARNING - void declaration
         */
        public void onSettings(Http2Connection connection, Settings settings) {
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"settings");
        }

        static {
            new Companion(0);
            REFUSE_INCOMING_STREAMS = new Listener(){

                /*
                 * WARNING - void declaration
                 */
                public final void onStream(Http2Stream stream) throws IOException {
                    void var1_1;
                    Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                    var1_1.close(ErrorCode.REFUSED_STREAM, null);
                }
            };
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lokhttp3/internal/http2/Http2Connection$Listener$Companion;", "", "()V", "REFUSE_INCOMING_STREAMS", "Lokhttp3/internal/http2/Http2Connection$Listener;", "okhttp"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(byte by) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lokhttp3/internal/http2/Http2Connection$Companion;", "", "()V", "AWAIT_PING", "", "DEFAULT_SETTINGS", "Lokhttp3/internal/http2/Settings;", "getDEFAULT_SETTINGS", "()Lokhttp3/internal/http2/Settings;", "DEGRADED_PING", "DEGRADED_PONG_TIMEOUT_NS", "INTERVAL_PING", "OKHTTP_CLIENT_WINDOW_SIZE", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(byte by) {
            this();
        }
    }
}

