/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import androidx.compose.runtime.saveable.ListSaverKt;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.RequestLine;
import okhttp3.internal.http.StatusLine;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Http2Connection;
import okhttp3.internal.http2.Http2Stream;
import okio.Sink;
import okio.Source;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 (2\u00020\u0001:\u0001(B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0014H\u0016J\b\u0010\u001c\u001a\u00020\u0014H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\fH\u0016J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lokhttp3/internal/http2/Http2ExchangeCodec;", "Lokhttp3/internal/http/ExchangeCodec;", "client", "Lokhttp3/OkHttpClient;", "connection", "Lokhttp3/internal/connection/RealConnection;", "chain", "Lokhttp3/internal/http/RealInterceptorChain;", "http2Connection", "Lokhttp3/internal/http2/Http2Connection;", "(Lokhttp3/OkHttpClient;Lokhttp3/internal/connection/RealConnection;Lokhttp3/internal/http/RealInterceptorChain;Lokhttp3/internal/http2/Http2Connection;)V", "canceled", "", "getConnection", "()Lokhttp3/internal/connection/RealConnection;", "protocol", "Lokhttp3/Protocol;", "stream", "Lokhttp3/internal/http2/Http2Stream;", "cancel", "", "createRequestBody", "Lokio/Sink;", "request", "Lokhttp3/Request;", "contentLength", "", "finishRequest", "flushRequest", "openResponseBodySource", "Lokio/Source;", "response", "Lokhttp3/Response;", "readResponseHeaders", "Lokhttp3/Response$Builder;", "expectContinue", "reportedContentLength", "trailers", "Lokhttp3/Headers;", "writeRequestHeaders", "Companion", "okhttp"})
public final class Http2ExchangeCodec
implements ExchangeCodec {
    private static Companion Companion = new Companion(0);
    private final RealConnection connection;
    private final ListSaverKt chain$756c3740;
    private final Http2Connection http2Connection;
    private volatile Http2Stream stream;
    private final Protocol protocol;
    private volatile boolean canceled;
    private static final List<String> HTTP_2_SKIPPED_REQUEST_HEADERS;
    private static final List<String> HTTP_2_SKIPPED_RESPONSE_HEADERS;

    /*
     * WARNING - void declaration
     */
    public Http2ExchangeCodec(OkHttpClient client, RealConnection connection, ListSaverKt chain, Http2Connection http2Connection) {
        void var1_1;
        void var3_3;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)http2Connection, (String)"http2Connection");
        this.connection = var2_2;
        this.chain$756c3740 = var3_3;
        this.http2Connection = http2Connection;
        this.protocol = var1_1.protocols().contains((Object)Protocol.H2_PRIOR_KNOWLEDGE) ? Protocol.H2_PRIOR_KNOWLEDGE : Protocol.HTTP_2;
    }

    @Override
    public final RealConnection getConnection() {
        return this.connection;
    }

    @Override
    public final Sink createRequestBody(Request request, long contentLength) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull((Object)http2Stream);
        return http2Stream.getSink();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeRequestHeaders(Request request2) {
        void var2_4;
        void var1_3;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        if (this.stream != null) {
            return;
        }
        boolean hasRequestBody = request2.body() != null;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Headers headers = request2.headers();
        ArrayList<Header> arrayList = new ArrayList<Header>(headers.size() + 4);
        arrayList.add(new Header(Header.TARGET_METHOD, request2.method()));
        arrayList.add(new Header(Header.TARGET_PATH, RequestLine.requestPath(request2.url())));
        String string = request2.header("Host");
        if (string != null) {
            arrayList.add(new Header(Header.TARGET_AUTHORITY, string));
        }
        arrayList.add(new Header(Header.TARGET_SCHEME, request2.url().scheme()));
        int request2 = 0;
        int n = headers.size();
        while (request2 < n) {
            int n2 = request2++;
            String string2 = headers.name(n2);
            Object object = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"US");
            String string3 = string2.toLowerCase((Locale)object);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
            object = string3;
            if (HTTP_2_SKIPPED_REQUEST_HEADERS.contains(object) && (!Intrinsics.areEqual((Object)object, (Object)"te") || !Intrinsics.areEqual((Object)headers.value(n2), (Object)"trailers"))) continue;
            arrayList.add(new Header((String)object, headers.value(n2)));
        }
        List requestHeaders = arrayList;
        this.stream = this.http2Connection.newStream((List<Header>)var1_3, (boolean)var2_4);
        if (this.canceled) {
            Http2Stream http2Stream = this.stream;
            Intrinsics.checkNotNull((Object)http2Stream);
            http2Stream.closeLater(ErrorCode.CANCEL);
            throw new IOException("Canceled");
        }
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull((Object)http2Stream);
        http2Stream.readTimeout().timeout((long)this.chain$756c3740.getReadTimeoutMillis$okhttp(), TimeUnit.MILLISECONDS);
        Http2Stream http2Stream2 = this.stream;
        Intrinsics.checkNotNull((Object)http2Stream2);
        http2Stream2.writeTimeout().timeout((long)this.chain$756c3740.getWriteTimeoutMillis$okhttp(), TimeUnit.MILLISECONDS);
    }

    @Override
    public final void flushRequest() {
        this.http2Connection.flush();
    }

    @Override
    public final void finishRequest() {
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull((Object)http2Stream);
        http2Stream.getSink().close();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Response.Builder readResponseHeaders(boolean expectContinue) {
        void var1_1;
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull((Object)http2Stream);
        Headers headers = http2Stream.takeHeaders();
        Headers headers2 = headers;
        Protocol protocol = this.protocol;
        headers2 = headers;
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headerBlock");
        Intrinsics.checkNotNullParameter((Object)((Object)protocol), (String)"protocol");
        StatusLine statusLine = null;
        Headers.Builder builder = new Headers.Builder();
        int n = 0;
        int n2 = headers2.size();
        while (n < n2) {
            int n3 = n++;
            String string = headers2.name(n3);
            String string2 = headers2.value(n3);
            if (Intrinsics.areEqual((Object)string, (Object)":status")) {
                statusLine = StatusLine.Companion.parse(Intrinsics.stringPlus((String)"HTTP/1.1 ", (Object)string2));
                continue;
            }
            if (HTTP_2_SKIPPED_RESPONSE_HEADERS.contains(string)) continue;
            builder.addLenient$okhttp(string, string2);
        }
        if (statusLine == null) {
            throw new ProtocolException("Expected ':status' header not present");
        }
        Response.Builder responseBuilder = new Response.Builder().protocol(protocol).code(statusLine.code).message(statusLine.message).headers(builder.build());
        if (var1_1 != false && responseBuilder.getCode$okhttp() == 100) {
            return null;
        }
        return headers2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long reportedContentLength(Response response) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (!HttpHeaders.promisesBody(response)) {
            return 0L;
        }
        return Util.headersContentLength((Response)var1_1);
    }

    @Override
    public final Source openResponseBodySource(Response response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull((Object)http2Stream);
        return http2Stream.getSource$okhttp();
    }

    @Override
    public final void cancel() {
        this.canceled = true;
        Http2Stream http2Stream = this.stream;
        if (http2Stream == null) {
            return;
        }
        http2Stream.closeLater(ErrorCode.CANCEL);
    }

    static {
        String[] stringArray = new String[12];
        String[] stringArray2 = stringArray;
        stringArray[0] = "connection";
        stringArray2[1] = "host";
        stringArray2[2] = "keep-alive";
        stringArray2[3] = "proxy-connection";
        stringArray2[4] = "te";
        stringArray2[5] = "transfer-encoding";
        stringArray2[6] = "encoding";
        stringArray2[7] = "upgrade";
        stringArray2[8] = ":method";
        stringArray2[9] = ":path";
        stringArray2[10] = ":scheme";
        stringArray2[11] = ":authority";
        HTTP_2_SKIPPED_REQUEST_HEADERS = Util.immutableListOf(stringArray2);
        String[] stringArray3 = new String[8];
        stringArray2 = stringArray3;
        stringArray3[0] = "connection";
        stringArray2[1] = "host";
        stringArray2[2] = "keep-alive";
        stringArray2[3] = "proxy-connection";
        stringArray2[4] = "te";
        stringArray2[5] = "transfer-encoding";
        stringArray2[6] = "encoding";
        stringArray2[7] = "upgrade";
        HTTP_2_SKIPPED_RESPONSE_HEADERS = Util.immutableListOf(stringArray2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\b2\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lokhttp3/internal/http2/Http2ExchangeCodec$Companion;", "", "()V", "CONNECTION", "", "ENCODING", "HOST", "HTTP_2_SKIPPED_REQUEST_HEADERS", "", "HTTP_2_SKIPPED_RESPONSE_HEADERS", "KEEP_ALIVE", "PROXY_CONNECTION", "TE", "TRANSFER_ENCODING", "UPGRADE", "http2HeadersList", "Lokhttp3/internal/http2/Header;", "request", "Lokhttp3/Request;", "readHttp2HeadersList", "Lokhttp3/Response$Builder;", "headerBlock", "Lokhttp3/Headers;", "protocol", "Lokhttp3/Protocol;", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(byte by) {
            this();
        }
    }
}

