/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import okhttp3.internal.Util;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Hpack;
import okhttp3.internal.http2.Http2;
import okhttp3.internal.http2.Settings;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Source;
import okio.Timeout;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 #2\u00020\u0001:\u0003#$%B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J(\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J(\u0010\u0017\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J.\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J(\u0010\u001c\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J(\u0010\u001d\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J\u0018\u0010\u001e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J(\u0010\u001e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J(\u0010\u001f\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J(\u0010 \u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J(\u0010!\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J(\u0010\"\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lokhttp3/internal/http2/Http2Reader;", "Ljava/io/Closeable;", "source", "Lokio/BufferedSource;", "client", "", "(Lokio/BufferedSource;Z)V", "continuation", "Lokhttp3/internal/http2/Http2Reader$ContinuationSource;", "hpackReader", "Lokhttp3/internal/http2/Hpack$Reader;", "close", "", "nextFrame", "requireSettings", "handler", "Lokhttp3/internal/http2/Http2Reader$Handler;", "readConnectionPreface", "readData", "length", "", "flags", "streamId", "readGoAway", "readHeaderBlock", "", "Lokhttp3/internal/http2/Header;", "padding", "readHeaders", "readPing", "readPriority", "readPushPromise", "readRstStream", "readSettings", "readWindowUpdate", "Companion", "ContinuationSource", "Handler", "okhttp"})
public final class Http2Reader
implements Closeable {
    public static final Companion Companion = new Companion(0);
    private final BufferedSource source;
    private final boolean client;
    private final ContinuationSource continuation;
    private final Hpack.Reader hpackReader;
    private static final Logger logger;

    /*
     * WARNING - void declaration
     */
    public Http2Reader(BufferedSource source, boolean client) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = var1_1;
        this.client = var2_2;
        this.continuation = new ContinuationSource(this.source);
        this.hpackReader = new Hpack.Reader(this.continuation, 4096, 0, 4);
    }

    /*
     * WARNING - void declaration
     */
    public final void readConnectionPreface(Handler handler) throws IOException {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        if (this.client) {
            if (!this.nextFrame(true, handler)) {
                throw new IOException("Required SETTINGS preface not received");
            }
        } else {
            handler = Http2.CONNECTION_PREFACE;
            ByteString connectionPreface = this.source.readByteString((long)handler.getSize$okio());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(Util.format(Intrinsics.stringPlus((String)"<< CONNECTION ", (Object)connectionPreface.hex()), new Object[0]));
            }
            if (!Intrinsics.areEqual((Object)Http2.CONNECTION_PREFACE, (Object)connectionPreface)) {
                void var1_1;
                throw new IOException(Intrinsics.stringPlus((String)"Expected a connection header but was ", (Object)var1_1.utf8()));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean nextFrame(boolean requireSettings, Handler handler) throws IOException {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        try {
            this.source.require(9L);
        }
        catch (EOFException eOFException) {
            return false;
        }
        int length32 = Util.readMedium(this.source);
        if (length32 > 16384) {
            throw new IOException(Intrinsics.stringPlus((String)"FRAME_SIZE_ERROR: ", (Object)length32));
        }
        int type = Util.and(this.source.readByte(), 255);
        int flags = Util.and(this.source.readByte(), 255);
        int streamId = this.source.readInt() & Integer.MAX_VALUE;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(Http2.INSTANCE.frameLog(true, streamId, length32, type, flags));
        }
        if (var1_1 != false && type != 4) {
            throw new IOException(Intrinsics.stringPlus((String)"Expected a SETTINGS frame but was ", (Object)Http2.formattedType$okhttp(type)));
        }
        switch (type) {
            case 0: {
                int n = flags;
                flags = streamId;
                int n2 = n;
                Http2Reader http2Reader = this;
                if (flags == 0) {
                    throw new IOException("PROTOCOL_ERROR: TYPE_DATA streamId == 0");
                }
                boolean bl = (n2 & 1) != 0;
                boolean bl2 = (n2 & 0x20) != 0;
                if (bl2) {
                    throw new IOException("PROTOCOL_ERROR: FLAG_COMPRESSED without SETTINGS_COMPRESS_DATA");
                }
                streamId = (n2 & 8) != 0 ? Util.and(http2Reader.source.readByte(), 255) : 0;
                length32 = okhttp3.internal.http2.Http2Reader$Companion.lengthWithoutPadding(length32, n2, streamId);
                handler.data(bl, flags, http2Reader.source, length32);
                http2Reader.source.skip((long)streamId);
                break;
            }
            case 1: {
                int n = flags;
                flags = streamId;
                int n2 = n;
                Http2Reader http2Reader = this;
                if (flags == 0) {
                    throw new IOException("PROTOCOL_ERROR: TYPE_HEADERS streamId == 0");
                }
                boolean bl = (n2 & 1) != 0;
                int n3 = (n2 & 8) != 0 ? Util.and(http2Reader.source.readByte(), 255) : 0;
                streamId = length32;
                if ((n2 & 0x20) != 0) {
                    http2Reader.readPriority(handler, flags);
                    streamId -= 5;
                }
                streamId = okhttp3.internal.http2.Http2Reader$Companion.lengthWithoutPadding(streamId, n2, n3);
                List<Header> length32 = http2Reader.readHeaderBlock(streamId, n3, n2, flags);
                handler.headers$64c3d190(bl, flags, length32);
                break;
            }
            case 2: {
                int n2 = streamId;
                Http2Reader http2Reader = this;
                if (length32 != 5) {
                    throw new IOException("TYPE_PRIORITY length: " + length32 + " != 5");
                }
                if (n2 == 0) {
                    throw new IOException("TYPE_PRIORITY streamId == 0");
                }
                http2Reader.readPriority(handler, n2);
                break;
            }
            case 3: {
                int n2 = streamId;
                Http2Reader http2Reader = this;
                if (length32 != 4) {
                    throw new IOException("TYPE_RST_STREAM length: " + length32 + " != 4");
                }
                if (n2 == 0) {
                    throw new IOException("TYPE_RST_STREAM streamId == 0");
                }
                int n = http2Reader.source.readInt();
                ErrorCode errorCode = ErrorCode.Companion.fromHttp2(n);
                if (errorCode == null) {
                    throw new IOException(Intrinsics.stringPlus((String)"TYPE_RST_STREAM unexpected error code: ", (Object)n));
                }
                ErrorCode errorCode2 = errorCode;
                handler.rstStream(n2, errorCode2);
                break;
            }
            case 4: {
                this.readSettings(handler, length32, flags, streamId);
                break;
            }
            case 5: {
                int n = flags;
                flags = streamId;
                int n2 = n;
                Http2Reader http2Reader = this;
                if (flags == 0) {
                    throw new IOException("PROTOCOL_ERROR: TYPE_PUSH_PROMISE streamId == 0");
                }
                int n4 = (n2 & 8) != 0 ? Util.and(http2Reader.source.readByte(), 255) : 0;
                int n5 = http2Reader.source.readInt() & Integer.MAX_VALUE;
                streamId = okhttp3.internal.http2.Http2Reader$Companion.lengthWithoutPadding(length32 - 4, n2, n4);
                List<Header> length32 = http2Reader.readHeaderBlock(streamId, n4, n2, flags);
                handler.pushPromise$16014a7a(n5, length32);
                break;
            }
            case 6: {
                int n = streamId;
                int n2 = flags;
                Http2Reader http2Reader = this;
                if (length32 != 8) {
                    throw new IOException(Intrinsics.stringPlus((String)"TYPE_PING length != 8: ", (Object)length32));
                }
                if (n != 0) {
                    throw new IOException("TYPE_PING streamId != 0");
                }
                int n6 = http2Reader.source.readInt();
                int n7 = http2Reader.source.readInt();
                streamId = (n2 & 1) != 0 ? 1 : 0;
                handler.ping(streamId != 0, n6, n7);
                break;
            }
            case 7: {
                int n2 = streamId;
                Http2Reader http2Reader = this;
                if (length32 < 8) {
                    throw new IOException(Intrinsics.stringPlus((String)"TYPE_GOAWAY length < 8: ", (Object)length32));
                }
                if (n2 != 0) {
                    throw new IOException("TYPE_GOAWAY streamId != 0");
                }
                int n = http2Reader.source.readInt();
                int n8 = http2Reader.source.readInt();
                streamId = length32 - 8;
                ErrorCode errorCode = ErrorCode.Companion.fromHttp2(n8);
                if (errorCode == null) {
                    throw new IOException(Intrinsics.stringPlus((String)"TYPE_GOAWAY unexpected error code: ", (Object)n8));
                }
                ErrorCode length32 = errorCode;
                ByteString byteString = ByteString.EMPTY;
                if (streamId > 0) {
                    byteString = http2Reader.source.readByteString((long)streamId);
                }
                handler.goAway(n, length32, byteString);
                break;
            }
            case 8: {
                void var2_10;
                int n2 = streamId;
                Http2Reader http2Reader = this;
                if (length32 != 4) {
                    throw new IOException(Intrinsics.stringPlus((String)"TYPE_WINDOW_UPDATE length !=4: ", (Object)length32));
                }
                long l = Util.and(http2Reader.source.readInt(), Integer.MAX_VALUE);
                if (l == 0L) {
                    throw new IOException("windowSizeIncrement was 0");
                }
                var2_10.windowUpdate(n2, l);
                break;
            }
            default: {
                void var3_11;
                this.source.skip((long)var3_11);
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Header> readHeaderBlock(int length, int padding, int flags, int streamId) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.continuation.setLeft((int)var1_1);
        this.continuation.setLength(this.continuation.getLeft());
        this.continuation.setPadding((int)var2_2);
        this.continuation.setFlags((int)var3_3);
        this.continuation.setStreamId(streamId);
        this.hpackReader.readHeaders();
        return this.hpackReader.getAndResetHeaderList();
    }

    private final void readPriority(Handler handler, int streamId) throws IOException {
        this.source.readInt();
        Util.and(this.source.readByte(), 255);
    }

    /*
     * WARNING - void declaration
     */
    private final void readSettings(Handler handler, int length, int flags, int streamId) throws IOException {
        void var3_6;
        void var1_1;
        void var2_2;
        if (streamId != 0) {
            throw new IOException("TYPE_SETTINGS streamId != 0");
        }
        if ((flags & 1) != 0) {
            if (length != 0) {
                throw new IOException("FRAME_SIZE_ERROR ack frame should be empty!");
            }
            return;
        }
        if (length % 6 != 0) {
            throw new IOException(Intrinsics.stringPlus((String)"TYPE_SETTINGS length % 6 != 0: ", (Object)length));
        }
        Settings settings = new Settings();
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)var2_2)), (int)6);
        int n = intProgression.getFirst();
        int n2 = intProgression.getLast();
        int n3 = intProgression.getStep();
        if (n3 > 0 && n <= n2 || n3 < 0 && n2 <= n) {
            int i;
            do {
                i = n;
                n += n3;
                int id = Util.and(this.source.readShort(), 65535);
                int value = this.source.readInt();
                switch (id) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        if (value == 0 || value == 1) break;
                        throw new IOException("PROTOCOL_ERROR SETTINGS_ENABLE_PUSH != 0 or 1");
                    }
                    case 3: {
                        id = 4;
                        break;
                    }
                    case 4: {
                        id = 7;
                        if (value >= 0) break;
                        throw new IOException("PROTOCOL_ERROR SETTINGS_INITIAL_WINDOW_SIZE > 2^31 - 1");
                    }
                    case 5: {
                        if (value >= 16384 && value <= 0xFFFFFF) break;
                        throw new IOException(Intrinsics.stringPlus((String)"PROTOCOL_ERROR SETTINGS_MAX_FRAME_SIZE: ", (Object)value));
                    }
                }
                settings.set(id, value);
            } while (i != n2);
        }
        var1_1.settings(false, (Settings)var3_6);
    }

    @Override
    public final void close() throws IOException {
        this.source.close();
    }

    static {
        Logger logger = Logger.getLogger(Http2.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(Http2::class.java.name)");
        Http2Reader.logger = logger;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001aH\u0016J\b\u0010\u001e\u001a\u00020\u0018H\u0002J\b\u0010\u001f\u001a\u00020 H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u001a\u0010\u000e\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\b\"\u0004\b\u0010\u0010\nR\u001a\u0010\u0011\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\b\"\u0004\b\u0013\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\b\"\u0004\b\u0016\u0010\n\u00a8\u0006!"}, d2={"Lokhttp3/internal/http2/Http2Reader$ContinuationSource;", "Lokio/Source;", "source", "Lokio/BufferedSource;", "(Lokio/BufferedSource;)V", "flags", "", "getFlags", "()I", "setFlags", "(I)V", "left", "getLeft", "setLeft", "length", "getLength", "setLength", "padding", "getPadding", "setPadding", "streamId", "getStreamId", "setStreamId", "close", "", "read", "", "sink", "Lokio/Buffer;", "byteCount", "readContinuationHeader", "timeout", "Lokio/Timeout;", "okhttp"})
    public static final class ContinuationSource
    implements Source {
        private final BufferedSource source;
        private int length;
        private int flags;
        private int streamId;
        private int left;
        private int padding;

        /*
         * WARNING - void declaration
         */
        public ContinuationSource(BufferedSource source) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            this.source = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final void setLength(int n) {
            void var1_1;
            this.length = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final void setFlags(int n) {
            void var1_1;
            this.flags = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final void setStreamId(int n) {
            void var1_1;
            this.streamId = var1_1;
        }

        public final int getLeft() {
            return this.left;
        }

        /*
         * WARNING - void declaration
         */
        public final void setLeft(int n) {
            void var1_1;
            this.left = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final void setPadding(int n) {
            void var1_1;
            this.padding = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final long read(Buffer sink, long byteCount) throws IOException {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            while (this.left == 0) {
                this.source.skip((long)this.padding);
                this.padding = 0;
                if ((this.flags & 4) != 0) {
                    return -1L;
                }
                ContinuationSource continuationSource = this;
                int n = continuationSource.streamId;
                continuationSource.length = continuationSource.left = Util.readMedium(continuationSource.source);
                int n2 = Util.and(continuationSource.source.readByte(), 255);
                continuationSource.flags = Util.and(continuationSource.source.readByte(), 255);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(Http2.INSTANCE.frameLog(true, continuationSource.streamId, continuationSource.length, n2, continuationSource.flags));
                }
                continuationSource.streamId = continuationSource.source.readInt() & Integer.MAX_VALUE;
                if (n2 != 9) {
                    throw new IOException(n2 + " != TYPE_CONTINUATION");
                }
                if (continuationSource.streamId == n) continue;
                throw new IOException("TYPE_CONTINUATION streamId changed");
            }
            long l = this.left;
            long read = this.source.read((Buffer)var1_1, Math.min((long)var2_2, l));
            if (read == -1L) {
                return -1L;
            }
            this.left -= (int)read;
            return read;
        }

        public final Timeout timeout() {
            return this.source.timeout();
        }

        public final void close() throws IOException {
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J8\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH&J(\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006H&J \u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\nH&J.\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH&J \u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u0006H&J(\u0010#\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u0011H&J&\u0010'\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u00062\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH&J\u0018\u0010*\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018H&J\u0018\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u00112\u0006\u0010+\u001a\u00020-H&J\u0018\u0010.\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010/\u001a\u00020\u000eH&\u00a8\u00060"}, d2={"Lokhttp3/internal/http2/Http2Reader$Handler;", "", "ackSettings", "", "alternateService", "streamId", "", "origin", "", "protocol", "Lokio/ByteString;", "host", "port", "maxAge", "", "data", "inFinished", "", "source", "Lokio/BufferedSource;", "length", "goAway", "lastGoodStreamId", "errorCode", "Lokhttp3/internal/http2/ErrorCode;", "debugData", "headers", "associatedStreamId", "headerBlock", "", "Lokhttp3/internal/http2/Header;", "ping", "ack", "payload1", "payload2", "priority", "streamDependency", "weight", "exclusive", "pushPromise", "promisedStreamId", "requestHeaders", "rstStream", "settings", "clearPrevious", "Lokhttp3/internal/http2/Settings;", "windowUpdate", "windowSizeIncrement", "okhttp"})
    public static interface Handler {
        public void data(boolean var1, int var2, BufferedSource var3, int var4) throws IOException;

        public void headers$64c3d190(boolean var1, int var2, List<Header> var3);

        public void rstStream(int var1, ErrorCode var2);

        public void settings(boolean var1, Settings var2);

        public void ping(boolean var1, int var2, int var3);

        public void goAway(int var1, ErrorCode var2, ByteString var3);

        public void windowUpdate(int var1, long var2);

        public void pushPromise$16014a7a(int var1, List<Header> var2) throws IOException;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lokhttp3/internal/http2/Http2Reader$Companion;", "", "()V", "logger", "Ljava/util/logging/Logger;", "getLogger", "()Ljava/util/logging/Logger;", "lengthWithoutPadding", "", "length", "flags", "padding", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public static int lengthWithoutPadding(int length, int flags, int padding) throws IOException {
            void var2_2;
            void var1_1;
            int result = length;
            if ((var1_1 & 8) != 0) {
                result += -1;
            }
            if (padding > result) {
                throw new IOException("PROTOCOL_ERROR padding " + padding + " > remaining length " + result);
            }
            return var0 -= var2_2;
        }

        public /* synthetic */ Companion(byte by) {
            this();
        }
    }
}

