/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.ArrayDeque;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Headers;
import okhttp3.internal.Util;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Http2Connection;
import okhttp3.internal.http2.StreamResetException;
import okio.AsyncTimeout;
import okio.Buffer;
import okio.BufferedSource;
import okio.Sink;
import okio.Source;
import okio.Timeout;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 _2\u00020\u0001:\u0004_`abB1\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020#J\r\u0010C\u001a\u00020AH\u0000\u00a2\u0006\u0002\bDJ\r\u0010E\u001a\u00020AH\u0000\u00a2\u0006\u0002\bFJ\u0018\u0010G\u001a\u00020A2\u0006\u0010H\u001a\u00020\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u001a\u0010I\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u000e\u0010J\u001a\u00020A2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010K\u001a\u00020A2\u0006\u0010L\u001a\u00020\nJ\u0006\u0010M\u001a\u00020NJ\u0006\u0010O\u001a\u00020PJ\u0006\u0010,\u001a\u00020QJ\u0016\u0010R\u001a\u00020A2\u0006\u00104\u001a\u00020S2\u0006\u0010T\u001a\u00020\u0003J\u0016\u0010U\u001a\u00020A2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0007J\u000e\u0010V\u001a\u00020A2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010W\u001a\u00020\nJ\u0006\u0010L\u001a\u00020\nJ\r\u0010X\u001a\u00020AH\u0000\u00a2\u0006\u0002\bYJ$\u0010Z\u001a\u00020A2\f\u0010[\u001a\b\u0012\u0004\u0012\u00020]0\\2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010^\u001a\u00020\u0007J\u0006\u0010>\u001a\u00020QR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u0004\u0018\u00010\u000f8@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b!\u0010 R$\u0010$\u001a\u00020#2\u0006\u0010\"\u001a\u00020#@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R$\u0010)\u001a\u00020#2\u0006\u0010\"\u001a\u00020#@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010&\"\u0004\b+\u0010(R\u0018\u0010,\u001a\u00060-R\u00020\u0000X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0018\u00100\u001a\u000601R\u00020\u0000X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0018\u00104\u001a\u000605R\u00020\u0000X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R$\u00108\u001a\u00020#2\u0006\u0010\"\u001a\u00020#@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010&\"\u0004\b:\u0010(R$\u0010;\u001a\u00020#2\u0006\u0010\"\u001a\u00020#@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010&\"\u0004\b=\u0010(R\u0018\u0010>\u001a\u00060-R\u00020\u0000X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010/\u00a8\u0006c"}, d2={"Lokhttp3/internal/http2/Http2Stream;", "", "id", "", "connection", "Lokhttp3/internal/http2/Http2Connection;", "outFinished", "", "inFinished", "headers", "Lokhttp3/Headers;", "(ILokhttp3/internal/http2/Http2Connection;ZZLokhttp3/Headers;)V", "getConnection", "()Lokhttp3/internal/http2/Http2Connection;", "errorCode", "Lokhttp3/internal/http2/ErrorCode;", "getErrorCode$okhttp", "()Lokhttp3/internal/http2/ErrorCode;", "setErrorCode$okhttp", "(Lokhttp3/internal/http2/ErrorCode;)V", "errorException", "Ljava/io/IOException;", "getErrorException$okhttp", "()Ljava/io/IOException;", "setErrorException$okhttp", "(Ljava/io/IOException;)V", "hasResponseHeaders", "headersQueue", "Ljava/util/ArrayDeque;", "getId", "()I", "isLocallyInitiated", "()Z", "isOpen", "<set-?>", "", "readBytesAcknowledged", "getReadBytesAcknowledged", "()J", "setReadBytesAcknowledged$okhttp", "(J)V", "readBytesTotal", "getReadBytesTotal", "setReadBytesTotal$okhttp", "readTimeout", "Lokhttp3/internal/http2/Http2Stream$StreamTimeout;", "getReadTimeout$okhttp", "()Lokhttp3/internal/http2/Http2Stream$StreamTimeout;", "sink", "Lokhttp3/internal/http2/Http2Stream$FramingSink;", "getSink$okhttp", "()Lokhttp3/internal/http2/Http2Stream$FramingSink;", "source", "Lokhttp3/internal/http2/Http2Stream$FramingSource;", "getSource$okhttp", "()Lokhttp3/internal/http2/Http2Stream$FramingSource;", "writeBytesMaximum", "getWriteBytesMaximum", "setWriteBytesMaximum$okhttp", "writeBytesTotal", "getWriteBytesTotal", "setWriteBytesTotal$okhttp", "writeTimeout", "getWriteTimeout$okhttp", "addBytesToWriteWindow", "", "delta", "cancelStreamIfNecessary", "cancelStreamIfNecessary$okhttp", "checkOutNotClosed", "checkOutNotClosed$okhttp", "close", "rstStatusCode", "closeInternal", "closeLater", "enqueueTrailers", "trailers", "getSink", "Lokio/Sink;", "getSource", "Lokio/Source;", "Lokio/Timeout;", "receiveData", "Lokio/BufferedSource;", "length", "receiveHeaders", "receiveRstStream", "takeHeaders", "waitForIo", "waitForIo$okhttp", "writeHeaders", "responseHeaders", "", "Lokhttp3/internal/http2/Header;", "flushHeaders", "Companion", "FramingSink", "FramingSource", "StreamTimeout", "okhttp"})
public final class Http2Stream {
    private final int id;
    private final Http2Connection connection;
    private long readBytesTotal;
    private long readBytesAcknowledged;
    private long writeBytesTotal;
    private long writeBytesMaximum;
    private final ArrayDeque<Headers> headersQueue;
    private boolean hasResponseHeaders;
    private final FramingSource source;
    private final FramingSink sink;
    private final StreamTimeout readTimeout;
    private final StreamTimeout writeTimeout;
    private ErrorCode errorCode;
    private IOException errorException;

    /*
     * WARNING - void declaration
     */
    public Http2Stream(int id, Http2Connection connection, boolean outFinished, boolean inFinished, Headers headers) {
        void var3_5;
        void var2_4;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        this.id = var1_1;
        this.connection = var2_4;
        this.writeBytesMaximum = this.connection.getPeerSettings().getInitialWindowSize();
        this.headersQueue = new ArrayDeque();
        Http2Stream http2Stream = this;
        this.source = new FramingSource(http2Stream, http2Stream.connection.getOkHttpSettings().getInitialWindowSize(), inFinished);
        this.sink = new FramingSink(this, (boolean)var3_5);
        this.readTimeout = new StreamTimeout(this);
        this.writeTimeout = new StreamTimeout(this);
        if (headers != null) {
            if (!(!this.isLocallyInitiated())) {
                String string = "locally-initiated streams shouldn't have headers yet";
                throw new IllegalStateException(string.toString());
            }
            ((Collection)this.headersQueue).add(headers);
            return;
        }
        if (!this.isLocallyInitiated()) {
            String string = "remotely-initiated streams should have headers";
            throw new IllegalStateException(string.toString());
        }
    }

    public final int getId() {
        return this.id;
    }

    public final Http2Connection getConnection() {
        return this.connection;
    }

    public final long getReadBytesTotal() {
        return this.readBytesTotal;
    }

    /*
     * WARNING - void declaration
     */
    public final void setReadBytesTotal$okhttp(long l) {
        void var1_1;
        this.readBytesTotal = var1_1;
    }

    public final long getReadBytesAcknowledged() {
        return this.readBytesAcknowledged;
    }

    /*
     * WARNING - void declaration
     */
    public final void setReadBytesAcknowledged$okhttp(long l) {
        void var1_1;
        this.readBytesAcknowledged = var1_1;
    }

    public final long getWriteBytesTotal() {
        return this.writeBytesTotal;
    }

    /*
     * WARNING - void declaration
     */
    public final void setWriteBytesTotal$okhttp(long l) {
        void var1_1;
        this.writeBytesTotal = var1_1;
    }

    public final long getWriteBytesMaximum() {
        return this.writeBytesMaximum;
    }

    public final FramingSource getSource$okhttp() {
        return this.source;
    }

    public final FramingSink getSink$okhttp() {
        return this.sink;
    }

    public final StreamTimeout getReadTimeout$okhttp() {
        return this.readTimeout;
    }

    public final StreamTimeout getWriteTimeout$okhttp() {
        return this.writeTimeout;
    }

    public final synchronized ErrorCode getErrorCode$okhttp() {
        return this.errorCode;
    }

    public final IOException getErrorException$okhttp() {
        return this.errorException;
    }

    public final synchronized boolean isOpen() {
        if (this.errorCode != null) {
            return false;
        }
        return !this.source.getFinished$okhttp() && !this.source.getClosed$okhttp() || !this.sink.getFinished() && !this.sink.getClosed() || !this.hasResponseHeaders;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isLocallyInitiated() {
        void var1_1;
        boolean streamIsClient;
        boolean bl = streamIsClient = (this.id & 1) == 1;
        return this.connection.getClient$okhttp() == var1_1;
    }

    public final synchronized Headers takeHeaders() throws IOException {
        this.readTimeout.enter();
        try {
            while (this.headersQueue.isEmpty() && this.errorCode == null) {
                this.waitForIo$okhttp();
            }
        }
        finally {
            this.readTimeout.exitAndThrowIfTimedOut();
        }
        if (!((Collection)this.headersQueue).isEmpty()) {
            Headers headers = this.headersQueue.removeFirst();
            Intrinsics.checkNotNullExpressionValue((Object)headers, (String)"headersQueue.removeFirst()");
            return headers;
        }
        IOException iOException = this.errorException;
        if (iOException == null) {
            ErrorCode errorCode = this.errorCode;
            Intrinsics.checkNotNull((Object)((Object)errorCode));
            iOException = new StreamResetException(errorCode);
        }
        throw (Throwable)iOException;
    }

    public final Timeout readTimeout() {
        return (Timeout)this.readTimeout;
    }

    public final Timeout writeTimeout() {
        return (Timeout)this.writeTimeout;
    }

    public final Sink getSink() {
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            if (!(this.hasResponseHeaders || this.isLocallyInitiated())) {
                String string = "reply before requesting the sink";
                throw new IllegalStateException(string.toString());
            }
        }
        return this.sink;
    }

    /*
     * WARNING - void declaration
     */
    public final void close(ErrorCode rstStatusCode, IOException errorException) throws IOException {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)((Object)rstStatusCode), (String)"rstStatusCode");
        if (!this.closeInternal(rstStatusCode, (IOException)var2_2)) {
            return;
        }
        this.connection.writeSynReset$okhttp(this.id, (ErrorCode)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void closeLater(ErrorCode errorCode) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
        if (!this.closeInternal(errorCode, null)) {
            return;
        }
        this.connection.writeSynResetLater$okhttp(this.id, (ErrorCode)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean closeInternal(ErrorCode errorCode, IOException errorException) {
        Http2Stream http2Stream;
        Http2Stream $this$assertThreadDoesntHoldLock$iv = this;
        if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + http2Stream));
        }
        http2Stream = this;
        synchronized (http2Stream) {
            void var2_3;
            Http2Stream http2Stream2;
            Http2Stream http2Stream3;
            block7: {
                block6: {
                    if (this.getErrorCode$okhttp() == null) break block6;
                    return false;
                }
                http2Stream3 = this;
                if (!http2Stream3.source.getFinished$okhttp()) break block7;
                http2Stream3 = this;
                if (!http2Stream3.sink.getFinished()) break block7;
                return false;
            }
            http2Stream3 = http2Stream2;
            http2Stream2 = this;
            this.errorCode = http2Stream3;
            http2Stream3 = var2_3;
            http2Stream2 = this;
            this.errorException = http2Stream3;
            http2Stream2 = this;
            ((Object)http2Stream2).notifyAll();
        }
        this.connection.removeStream$okhttp(this.id);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void receiveData(BufferedSource source, int length) throws IOException {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Http2Stream $this$assertThreadDoesntHoldLock$iv = this;
        if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            void var3_3;
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + var3_3));
        }
        this.source.receive$okhttp((BufferedSource)var1_1, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void receiveHeaders(Headers headers, boolean inFinished) {
        void var3_5;
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Http2Stream $this$assertThreadDoesntHoldLock$iv = this;
        if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
        }
        Http2Stream http2Stream = this;
        synchronized (http2Stream) {
            void var2_3;
            Http2Stream http2Stream2;
            if (!this.hasResponseHeaders || !inFinished) {
                this.hasResponseHeaders = true;
                ((Collection)this.headersQueue).add(http2Stream2);
            } else {
                http2Stream2 = this;
                FramingSource cfr_ignored_0 = http2Stream2.source;
            }
            if (var2_3 != false) {
                http2Stream2 = this;
                http2Stream2.source.setFinished$okhttp(true);
            }
            boolean open = this.isOpen();
            http2Stream2 = this;
            ((Object)http2Stream2).notifyAll();
        }
        if (var3_5 == false) {
            this.connection.removeStream$okhttp(this.id);
        }
    }

    public final synchronized void receiveRstStream(ErrorCode errorCode) {
        Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
        if (this.errorCode == null) {
            Http2Stream http2Stream;
            this.errorCode = http2Stream;
            http2Stream = this;
            ((Object)http2Stream).notifyAll();
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void cancelStreamIfNecessary$okhttp() throws IOException {
        $this$assertThreadDoesntHoldLock$iv = this;
        if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
        }
        var3_4 = this;
        synchronized (var3_4) {
            $this$assertThreadDoesntHoldLock$iv = this;
            if ($this$assertThreadDoesntHoldLock$iv.source.getFinished$okhttp()) ** GOTO lbl-1000
            $this$assertThreadDoesntHoldLock$iv = this;
            if (!$this$assertThreadDoesntHoldLock$iv.source.getClosed$okhttp()) ** GOTO lbl-1000
            $this$assertThreadDoesntHoldLock$iv = this;
            if ($this$assertThreadDoesntHoldLock$iv.sink.getFinished()) ** GOTO lbl-1000
            $this$assertThreadDoesntHoldLock$iv = this;
            if ($this$assertThreadDoesntHoldLock$iv.sink.getClosed()) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else lbl-1000:
            // 3 sources

            {
                v0 = false;
            }
            cancel = v0;
            open = this.isOpen();
        }
        if (var2_5 != false) {
            this.close(ErrorCode.CANCEL, null);
            return;
        }
        if (var1_2 == false) {
            this.connection.removeStream$okhttp(this.id);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void addBytesToWriteWindow(long delta) {
        void var1_1;
        this.writeBytesMaximum += delta;
        if (var1_1 > 0L) {
            Http2Stream http2Stream = this;
            ((Object)http2Stream).notifyAll();
        }
    }

    public final void checkOutNotClosed$okhttp() throws IOException {
        if (this.sink.getClosed()) {
            throw new IOException("stream closed");
        }
        if (this.sink.getFinished()) {
            throw new IOException("stream finished");
        }
        if (this.errorCode != null) {
            IOException iOException = this.errorException;
            if (iOException == null) {
                ErrorCode errorCode = this.errorCode;
                Intrinsics.checkNotNull((Object)((Object)errorCode));
                iOException = new StreamResetException(errorCode);
            }
            throw (Throwable)iOException;
        }
    }

    public final void waitForIo$okhttp() throws InterruptedIOException {
        try {
            Http2Stream http2Stream = this;
            ((Object)http2Stream).wait();
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
    }

    static {
        new Companion(0);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J\u001d\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\"J\b\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0003H\u0002R\u001a\u0010\u0007\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006&"}, d2={"Lokhttp3/internal/http2/Http2Stream$FramingSource;", "Lokio/Source;", "maxByteCount", "", "finished", "", "(Lokhttp3/internal/http2/Http2Stream;JZ)V", "closed", "getClosed$okhttp", "()Z", "setClosed$okhttp", "(Z)V", "getFinished$okhttp", "setFinished$okhttp", "readBuffer", "Lokio/Buffer;", "getReadBuffer", "()Lokio/Buffer;", "receiveBuffer", "getReceiveBuffer", "trailers", "Lokhttp3/Headers;", "getTrailers", "()Lokhttp3/Headers;", "setTrailers", "(Lokhttp3/Headers;)V", "close", "", "read", "sink", "byteCount", "receive", "source", "Lokio/BufferedSource;", "receive$okhttp", "timeout", "Lokio/Timeout;", "updateConnectionFlowControl", "okhttp"})
    public final class FramingSource
    implements Source {
        private final long maxByteCount;
        private boolean finished;
        private final Buffer receiveBuffer;
        private final Buffer readBuffer;
        private boolean closed;
        private /* synthetic */ Http2Stream this$0;

        /*
         * WARNING - void declaration
         */
        public FramingSource(Http2Stream this$0, long maxByteCount, boolean finished) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this.this$0 = var1_1;
            this.maxByteCount = var2_2;
            this.finished = finished;
            this.receiveBuffer = new Buffer();
            this.readBuffer = new Buffer();
        }

        public final boolean getFinished$okhttp() {
            return this.finished;
        }

        public final void setFinished$okhttp(boolean bl) {
            this.finished = true;
        }

        public final boolean getClosed$okhttp() {
            return this.closed;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final long read(Buffer sink, long byteCount) throws IOException {
            IOException errorExceptionToDeliver;
            long readBytesDelivered;
            boolean tryAgain;
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            if (!(byteCount >= 0L)) {
                sink = Intrinsics.stringPlus((String)"byteCount < 0: ", (Object)((long)byteCount));
                throw new IllegalArgumentException(sink.toString());
            }
            do {
                block15: {
                    tryAgain = false;
                    readBytesDelivered = -1L;
                    errorExceptionToDeliver = null;
                    Http2Stream http2Stream = this.this$0;
                    Http2Stream http2Stream2 = this.this$0;
                    synchronized (http2Stream) {
                        http2Stream2.getReadTimeout$okhttp().enter();
                        try {
                            if (http2Stream2.getErrorCode$okhttp() != null) {
                                IOException iOException = http2Stream2.getErrorException$okhttp();
                                if (iOException == null) {
                                    ErrorCode errorCode = http2Stream2.getErrorCode$okhttp();
                                    Intrinsics.checkNotNull((Object)((Object)errorCode));
                                    iOException = new StreamResetException(errorCode);
                                }
                                errorExceptionToDeliver = iOException;
                            }
                            FramingSource framingSource = this;
                            if (framingSource.closed) {
                                throw new IOException("stream closed");
                            }
                            framingSource = this;
                            if (framingSource.readBuffer.size() > 0L) {
                                FramingSource framingSource2 = this;
                                framingSource = framingSource2;
                                framingSource = this;
                                long l = framingSource.readBuffer.size();
                                readBytesDelivered = framingSource2.readBuffer.read((Buffer)sink, Math.min((long)byteCount, l));
                                Http2Stream http2Stream3 = http2Stream2;
                                http2Stream3.setReadBytesTotal$okhttp(http2Stream3.getReadBytesTotal() + readBytesDelivered);
                                long unacknowledgedBytesRead = http2Stream2.getReadBytesTotal() - http2Stream2.getReadBytesAcknowledged();
                                if (errorExceptionToDeliver == null && unacknowledgedBytesRead >= (long)(http2Stream2.getConnection().getOkHttpSettings().getInitialWindowSize() / 2)) {
                                    http2Stream2.getConnection().writeWindowUpdateLater$okhttp(http2Stream2.getId(), unacknowledgedBytesRead);
                                    Http2Stream http2Stream4 = http2Stream2;
                                    http2Stream4.setReadBytesAcknowledged$okhttp(http2Stream4.getReadBytesTotal());
                                }
                                break block15;
                            }
                            framingSource = this;
                            if (!framingSource.finished && errorExceptionToDeliver == null) {
                                http2Stream2.waitForIo$okhttp();
                                tryAgain = true;
                            }
                        }
                        finally {
                            http2Stream2.getReadTimeout$okhttp().exitAndThrowIfTimedOut();
                        }
                    }
                }
            } while (tryAgain);
            if (readBytesDelivered != -1L) {
                this.updateConnectionFlowControl(readBytesDelivered);
                return readBytesDelivered;
            }
            if (errorExceptionToDeliver != null) {
                throw (Throwable)errorExceptionToDeliver;
            }
            return -1L;
        }

        /*
         * WARNING - void declaration
         */
        private final void updateConnectionFlowControl(long read) {
            void var1_1;
            Http2Stream $this$assertThreadDoesntHoldLock$iv = this.this$0;
            if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
                void var3_2;
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + var3_2));
            }
            this.this$0.getConnection().updateConnectionFlowControl$okhttp((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final void receive$okhttp(BufferedSource source, long byteCount) throws IOException {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Http2Stream $this$assertThreadDoesntHoldLock$iv = this.this$0;
            if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
            }
            long byteCount2 = byteCount;
            while (byteCount2 > 0L) {
                void var2_5;
                void var3_12;
                FramingSource framingSource;
                Http2Stream http2Stream = this.this$0;
                synchronized (http2Stream) {
                    framingSource = this;
                    boolean finished = framingSource.finished;
                    framingSource = this;
                    boolean flowControlError = byteCount2 + framingSource.readBuffer.size() > this.maxByteCount;
                }
                if (var3_12 != false) {
                    source.skip(byteCount2);
                    this.this$0.closeLater(ErrorCode.FLOW_CONTROL_ERROR);
                    return;
                }
                if (var2_5 != false) {
                    source.skip(byteCount2);
                    return;
                }
                long read = source.read(this.receiveBuffer, byteCount2);
                if (read == -1L) {
                    throw new EOFException();
                }
                byteCount2 -= read;
                long bytesDiscarded = 0L;
                Http2Stream http2Stream2 = this.this$0;
                Http2Stream http2Stream3 = this.this$0;
                synchronized (http2Stream2) {
                    framingSource = this;
                    if (framingSource.closed) {
                        framingSource = this;
                        bytesDiscarded = framingSource.receiveBuffer.size();
                        framingSource = this;
                        framingSource.receiveBuffer.clear();
                    } else {
                        framingSource = this;
                        boolean wasEmpty = framingSource.readBuffer.size() == 0L;
                        FramingSource framingSource2 = this;
                        framingSource = framingSource2;
                        framingSource = this;
                        framingSource2.readBuffer.writeAll((Source)framingSource.receiveBuffer);
                        if (wasEmpty) {
                            ((Object)http2Stream3).notifyAll();
                        }
                    }
                }
                if (bytesDiscarded <= 0L) continue;
                this.updateConnectionFlowControl(bytesDiscarded);
            }
        }

        public final Timeout timeout() {
            return (Timeout)this.this$0.getReadTimeout$okhttp();
        }

        public final void close() throws IOException {
            long bytesDiscarded;
            Http2Stream http2Stream = this.this$0;
            Http2Stream http2Stream2 = this.this$0;
            synchronized (http2Stream) {
                boolean bl = true;
                FramingSource framingSource = this;
                this.closed = true;
                framingSource = this;
                bytesDiscarded = framingSource.readBuffer.size();
                framingSource = this;
                framingSource.readBuffer.clear();
                ((Object)http2Stream2).notifyAll();
            }
            if (bytesDiscarded > 0L) {
                this.updateConnectionFlowControl(bytesDiscarded);
            }
            this.this$0.cancelStreamIfNecessary$okhttp();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\b\u0010\u0018\u001a\u00020\u0015H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\tR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lokhttp3/internal/http2/Http2Stream$FramingSink;", "Lokio/Sink;", "finished", "", "(Lokhttp3/internal/http2/Http2Stream;Z)V", "closed", "getClosed", "()Z", "setClosed", "(Z)V", "getFinished", "setFinished", "sendBuffer", "Lokio/Buffer;", "trailers", "Lokhttp3/Headers;", "getTrailers", "()Lokhttp3/Headers;", "setTrailers", "(Lokhttp3/Headers;)V", "close", "", "emitFrame", "outFinishedOnLastFrame", "flush", "timeout", "Lokio/Timeout;", "write", "source", "byteCount", "", "okhttp"})
    public final class FramingSink
    implements Sink {
        private boolean finished;
        private final Buffer sendBuffer;
        private Headers trailers;
        private boolean closed;
        private /* synthetic */ Http2Stream this$0;

        /*
         * WARNING - void declaration
         */
        public FramingSink(Http2Stream this$0, boolean finished) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this.this$0 = var1_1;
            this.finished = var2_2;
            this.sendBuffer = new Buffer();
        }

        public final boolean getFinished() {
            return this.finished;
        }

        public final boolean getClosed() {
            return this.closed;
        }

        /*
         * WARNING - void declaration
         */
        public final void write(Buffer source, long byteCount) throws IOException {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Http2Stream $this$assertThreadDoesntHoldLock$iv = this.this$0;
            if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
            }
            this.sendBuffer.write((Buffer)var1_1, (long)var2_2);
            while (this.sendBuffer.size() >= 16384L) {
                this.emitFrame(false);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void emitFrame(boolean outFinishedOnLastFrame) throws IOException {
            long toWrite;
            Http2Stream http2Stream = this.this$0;
            Http2Stream http2Stream2 = this.this$0;
            synchronized (http2Stream) {
                http2Stream2.getWriteTimeout$okhttp().enter();
                try {
                    while (http2Stream2.getWriteBytesTotal() >= http2Stream2.getWriteBytesMaximum()) {
                        FramingSink framingSink = this;
                        if (!framingSink.finished) {
                            framingSink = this;
                            if (!framingSink.closed && http2Stream2.getErrorCode$okhttp() == null) {
                                http2Stream2.waitForIo$okhttp();
                                continue;
                            }
                        }
                        break;
                    }
                }
                finally {
                    http2Stream2.getWriteTimeout$okhttp().exitAndThrowIfTimedOut();
                }
                http2Stream2.checkOutNotClosed$okhttp();
                toWrite = Math.min(http2Stream2.getWriteBytesMaximum() - http2Stream2.getWriteBytesTotal(), this.sendBuffer.size());
                Http2Stream http2Stream3 = http2Stream2;
                http2Stream3.setWriteBytesTotal$okhttp(http2Stream3.getWriteBytesTotal() + toWrite);
                boolean outFinished = outFinishedOnLastFrame && toWrite == this.sendBuffer.size();
            }
            this.this$0.getWriteTimeout$okhttp().enter();
            try {
                void var1_1;
                this.this$0.getConnection().writeData(this.this$0.getId(), (boolean)var1_1, this.sendBuffer, toWrite);
                return;
            }
            finally {
                this.this$0.getWriteTimeout$okhttp().exitAndThrowIfTimedOut();
            }
        }

        public final void flush() throws IOException {
            Http2Stream http2Stream;
            Http2Stream $this$assertThreadDoesntHoldLock$iv = this.this$0;
            if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + http2Stream));
            }
            http2Stream = this.this$0;
            Http2Stream http2Stream2 = this.this$0;
            synchronized (http2Stream) {
                http2Stream2.checkOutNotClosed$okhttp();
            }
            while (this.sendBuffer.size() > 0L) {
                this.emitFrame(false);
                this.this$0.getConnection().flush();
            }
        }

        public final Timeout timeout() {
            return (Timeout)this.this$0.getWriteTimeout$okhttp();
        }

        /*
         * WARNING - void declaration
         */
        public final void close() throws IOException {
            boolean bl;
            boolean outFinished;
            Object $this$assertThreadDoesntHoldLock$iv = this.this$0;
            if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
            }
            Http2Stream http2Stream = this.this$0;
            Http2Stream http2Stream2 = this.this$0;
            synchronized (http2Stream) {
                $this$assertThreadDoesntHoldLock$iv = this;
                if (((FramingSink)$this$assertThreadDoesntHoldLock$iv).closed) {
                    return;
                }
                outFinished = http2Stream2.getErrorCode$okhttp() == null;
            }
            if (!this.this$0.getSink$okhttp().finished) {
                void var2_6;
                boolean hasData = this.sendBuffer.size() > 0L;
                boolean bl2 = this.trailers != null;
                if (bl2) {
                    while (this.sendBuffer.size() > 0L) {
                        this.emitFrame(false);
                    }
                    Http2Connection http2Connection = this.this$0.getConnection();
                    int n = this.this$0.getId();
                    Headers headers = this.trailers;
                    Intrinsics.checkNotNull((Object)headers);
                    http2Connection.writeHeaders$okhttp(n, outFinished, Util.toHeaderList(headers));
                } else if (var2_6 != false) {
                    while (this.sendBuffer.size() > 0L) {
                        this.emitFrame(true);
                    }
                } else if (bl) {
                    this.this$0.getConnection().writeData(this.this$0.getId(), true, null, 0L);
                }
            }
            Http2Stream http2Stream3 = this.this$0;
            synchronized (http2Stream3) {
                bl = true;
                FramingSink framingSink = this;
                this.closed = true;
            }
            this.this$0.getConnection().flush();
            this.this$0.cancelStreamIfNecessary$okhttp();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lokhttp3/internal/http2/Http2Stream$Companion;", "", "()V", "EMIT_BUFFER_SIZE", "", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(byte by) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0014J\b\u0010\b\u001a\u00020\u0004H\u0014\u00a8\u0006\t"}, d2={"Lokhttp3/internal/http2/Http2Stream$StreamTimeout;", "Lokio/AsyncTimeout;", "(Lokhttp3/internal/http2/Http2Stream;)V", "exitAndThrowIfTimedOut", "", "newTimeoutException", "Ljava/io/IOException;", "cause", "timedOut", "okhttp"})
    public final class StreamTimeout
    extends AsyncTimeout {
        private /* synthetic */ Http2Stream this$0;

        /*
         * WARNING - void declaration
         */
        public StreamTimeout(Http2Stream this$0) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this.this$0 = var1_1;
        }

        protected final void timedOut() {
            this.this$0.closeLater(ErrorCode.CANCEL);
            this.this$0.getConnection().sendDegradedPingLater$okhttp();
        }

        /*
         * WARNING - void declaration
         */
        protected final IOException newTimeoutException(IOException cause) {
            SocketTimeoutException socketTimeoutException;
            SocketTimeoutException $this$newTimeoutException_u24lambda_u2d0 = socketTimeoutException = new SocketTimeoutException("timeout");
            if (cause != null) {
                void var1_1;
                void var3_3;
                var3_3.initCause((Throwable)var1_1);
            }
            return socketTimeoutException;
        }

        public final void exitAndThrowIfTimedOut() throws IOException {
            StreamTimeout streamTimeout = this;
            if (AsyncTimeout.Companion.access$cancelScheduledTimeout((AsyncTimeout.Companion)AsyncTimeout.Companion, (AsyncTimeout)streamTimeout)) {
                throw this.newTimeoutException(null);
            }
        }
    }
}

