/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.Util;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Hpack;
import okhttp3.internal.http2.Http2;
import okhttp3.internal.http2.Settings;
import okio.Buffer;
import okio.BufferedSink;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u0000 :2\u00020\u0001:\u0001:B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\u0006\u0010\u0015\u001a\u00020\u0011J(\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u000f2\b\u0010\u0019\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001a\u001a\u00020\u000fJ(\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f2\b\u0010\u001d\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001a\u001a\u00020\u000fJ\u0006\u0010\u001e\u001a\u00020\u0011J&\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000fJ\u001e\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J$\u0010(\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u000f2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*J\u0006\u0010,\u001a\u00020\u000fJ\u001e\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u00020\u000fJ$\u00101\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u00102\u001a\u00020\u000f2\f\u00103\u001a\b\u0012\u0004\u0012\u00020+0*J\u0016\u00104\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%J\u000e\u00105\u001a\u00020\u00112\u0006\u00105\u001a\u00020\u0013J\u0016\u00106\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u00107\u001a\u000208J\u0018\u00109\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u000208H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lokhttp3/internal/http2/Http2Writer;", "Ljava/io/Closeable;", "sink", "Lokio/BufferedSink;", "client", "", "(Lokio/BufferedSink;Z)V", "closed", "hpackBuffer", "Lokio/Buffer;", "hpackWriter", "Lokhttp3/internal/http2/Hpack$Writer;", "getHpackWriter", "()Lokhttp3/internal/http2/Hpack$Writer;", "maxFrameSize", "", "applyAndAckSettings", "", "peerSettings", "Lokhttp3/internal/http2/Settings;", "close", "connectionPreface", "data", "outFinished", "streamId", "source", "byteCount", "dataFrame", "flags", "buffer", "flush", "frameHeader", "length", "type", "goAway", "lastGoodStreamId", "errorCode", "Lokhttp3/internal/http2/ErrorCode;", "debugData", "", "headers", "headerBlock", "", "Lokhttp3/internal/http2/Header;", "maxDataLength", "ping", "ack", "payload1", "payload2", "pushPromise", "promisedStreamId", "requestHeaders", "rstStream", "settings", "windowUpdate", "windowSizeIncrement", "", "writeContinuationFrames", "Companion", "okhttp"})
public final class Http2Writer
implements Closeable {
    private final BufferedSink sink;
    private final boolean client;
    private final Buffer hpackBuffer;
    private int maxFrameSize;
    private boolean closed;
    private final Hpack.Writer hpackWriter;
    private static final Logger logger;

    /*
     * WARNING - void declaration
     */
    public Http2Writer(BufferedSink sink, boolean client) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        this.sink = var1_1;
        this.client = var2_2;
        this.hpackBuffer = new Buffer();
        this.maxFrameSize = 16384;
        this.hpackWriter = new Hpack.Writer(0, false, this.hpackBuffer, 3);
    }

    public final synchronized void connectionPreface() throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        if (!this.client) {
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(Util.format(Intrinsics.stringPlus((String)">> CONNECTION ", (Object)Http2.CONNECTION_PREFACE.hex()), new Object[0]));
        }
        this.sink.write(Http2.CONNECTION_PREFACE);
        this.sink.flush();
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void applyAndAckSettings(Settings peerSettings) throws IOException {
        Intrinsics.checkNotNullParameter((Object)peerSettings, (String)"peerSettings");
        if (this.closed) {
            throw new IOException("closed");
        }
        this.maxFrameSize = peerSettings.getMaxFrameSize(this.maxFrameSize);
        if (peerSettings.getHeaderTableSize() != -1) {
            void var1_1;
            this.hpackWriter.resizeHeaderTable(var1_1.getHeaderTableSize());
        }
        this.frameHeader(0, 0, 4, 1);
        this.sink.flush();
    }

    public final synchronized void flush() throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        this.sink.flush();
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void rstStream(int streamId2, ErrorCode errorCode) throws IOException {
        void var2_3;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
        if (this.closed) {
            throw new IOException("closed");
        }
        if (!(errorCode.getHttpCode() != -1)) {
            String streamId2 = "Failed requirement.";
            throw new IllegalArgumentException(streamId2.toString());
        }
        this.frameHeader((int)var1_1, 4, 3, 0);
        this.sink.writeInt(var2_3.getHttpCode());
        this.sink.flush();
    }

    public final int maxDataLength() {
        return this.maxFrameSize;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void data(boolean outFinished, int streamId, Buffer source, int byteCount) throws IOException {
        void var2_3;
        void var3_4;
        void var1_1;
        if (this.closed) {
            throw new IOException("closed");
        }
        int flags = 0;
        if (var1_1 != false) {
            flags = 1;
        }
        int n = byteCount;
        void var4_7 = var3_4;
        int n2 = flags;
        Http2Writer http2Writer = this;
        http2Writer.frameHeader((int)var2_3, n, 0, n2);
        if (n > 0) {
            BufferedSink bufferedSink = http2Writer.sink;
            void v1 = var4_7;
            Intrinsics.checkNotNull((Object)v1);
            bufferedSink.write((Buffer)v1, (long)n);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void settings(Settings settings) throws IOException {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (this.closed) {
            throw new IOException("closed");
        }
        this.frameHeader(0, settings.size() * 6, 4, 0);
        int n = 0;
        while (n < 10) {
            void var3_3;
            int n2;
            int i;
            if (!settings.isSet(i = n++)) continue;
            switch (i) {
                case 4: {
                    n2 = 3;
                    break;
                }
                case 7: {
                    n2 = 4;
                    break;
                }
                default: {
                    n2 = i;
                }
            }
            int id = n2;
            this.sink.writeShort(id);
            this.sink.writeInt(settings.get((int)var3_3));
        }
        this.sink.flush();
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void ping(boolean ack, int payload1, int payload2) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.closed) {
            throw new IOException("closed");
        }
        this.frameHeader(0, 8, 6, var1_1 != false ? 1 : 0);
        this.sink.writeInt((int)var2_2);
        this.sink.writeInt((int)var3_3);
        this.sink.flush();
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void goAway(int lastGoodStreamId2, ErrorCode errorCode, byte[] debugData) throws IOException {
        void var2_3;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
        Intrinsics.checkNotNullParameter((Object)debugData, (String)"debugData");
        if (this.closed) {
            throw new IOException("closed");
        }
        if (!(errorCode.getHttpCode() != -1)) {
            String lastGoodStreamId2 = "errorCode.httpCode == -1";
            throw new IllegalArgumentException(lastGoodStreamId2.toString());
        }
        this.frameHeader(0, 8 + debugData.length, 7, 0);
        this.sink.writeInt((int)var1_1);
        this.sink.writeInt(var2_3.getHttpCode());
        if (!(debugData.length == 0)) {
            void var3_4;
            this.sink.write((byte[])var3_4);
        }
        this.sink.flush();
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void windowUpdate(int streamId2, long windowSizeIncrement) throws IOException {
        void var2_3;
        void var1_1;
        if (this.closed) {
            throw new IOException("closed");
        }
        if (!(windowSizeIncrement != 0L && windowSizeIncrement <= Integer.MAX_VALUE)) {
            String streamId2 = Intrinsics.stringPlus((String)"windowSizeIncrement == 0 || windowSizeIncrement > 0x7fffffffL: ", (Object)windowSizeIncrement);
            throw new IllegalArgumentException(streamId2.toString());
        }
        this.frameHeader((int)var1_1, 4, 8, 0);
        this.sink.writeInt((int)var2_3);
        this.sink.flush();
    }

    /*
     * WARNING - void declaration
     */
    private void frameHeader(int streamId22, int length, int type, int flags) throws IOException {
        void var1_1;
        void var3_5;
        void var2_4;
        int streamId22;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(Http2.INSTANCE.frameLog(false, streamId22, length, type, flags));
        }
        if (!(length <= this.maxFrameSize)) {
            String streamId22 = "FRAME_SIZE_ERROR length > " + this.maxFrameSize + ": " + length;
            throw new IllegalArgumentException(streamId22.toString());
        }
        if (!((streamId22 & Integer.MIN_VALUE) == 0)) {
            String streamId22 = Intrinsics.stringPlus((String)"reserved bit set: ", (Object)streamId22);
            throw new IllegalArgumentException(streamId22.toString());
        }
        Util.writeMedium(this.sink, (int)var2_4);
        this.sink.writeByte(var3_5 & 0xFF);
        this.sink.writeByte(flags & 0xFF);
        this.sink.writeInt(var1_1 & Integer.MAX_VALUE);
    }

    @Override
    public final synchronized void close() throws IOException {
        this.closed = true;
        this.sink.close();
    }

    private final void writeContinuationFrames(int streamId, long byteCount) throws IOException {
        long byteCount2 = byteCount;
        while (byteCount2 > 0L) {
            long length = Math.min((long)this.maxFrameSize, byteCount2);
            this.frameHeader(streamId, (int)length, 9, (byteCount2 -= length) == 0L ? 4 : 0);
            this.sink.write(this.hpackBuffer, length);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void headers(boolean outFinished, int streamId, List<Header> headerBlock) throws IOException {
        void var3_4;
        void var1_1;
        int flags;
        Intrinsics.checkNotNullParameter(headerBlock, (String)"headerBlock");
        if (this.closed) {
            throw new IOException("closed");
        }
        this.hpackWriter.writeHeaders(headerBlock);
        long byteCount = this.hpackBuffer.size();
        long length = Math.min((long)this.maxFrameSize, byteCount);
        int n = flags = byteCount == length ? 4 : 0;
        if (var1_1 != false) {
            flags |= 1;
        }
        this.frameHeader(streamId, (int)length, 1, (int)var3_4);
        this.sink.write(this.hpackBuffer, length);
        if (byteCount > length) {
            void var2_2;
            this.writeContinuationFrames((int)var2_2, byteCount - length);
        }
    }

    static {
        new Companion(0);
        logger = Logger.getLogger(Http2.class.getName());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lokhttp3/internal/http2/Http2Writer$Companion;", "", "()V", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(byte by) {
            this();
        }
    }
}

