/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import android.os.Build;
import android.security.NetworkSecurityPolicy;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Protocol;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.platform.android.AndroidCertificateChainCleaner;
import okhttp3.internal.platform.android.AndroidSocketAdapter;
import okhttp3.internal.platform.android.BouncyCastleSocketAdapter;
import okhttp3.internal.platform.android.CloseGuard;
import okhttp3.internal.platform.android.ConscryptSocketAdapter;
import okhttp3.internal.platform.android.DeferredSocketAdapter;
import okhttp3.internal.platform.android.SocketAdapter;
import okhttp3.internal.platform.android.StandardAndroidSocketAdapter;
import okhttp3.internal.tls.CertificateChainCleaner;
import okhttp3.internal.tls.TrustRootIndex;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 )2\u00020\u0001:\u0002)*B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J-\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0011\u0010\u0014\u001a\r\u0012\t\u0012\u00070\u0015\u00a2\u0006\u0002\b\u00160\u0006H\u0016J \u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u0013H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u00132\b\u0010&\u001a\u0004\u0018\u00010 H\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010'\u001a\u00020(H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lokhttp3/internal/platform/AndroidPlatform;", "Lokhttp3/internal/platform/Platform;", "()V", "closeGuard", "Lokhttp3/internal/platform/android/CloseGuard;", "socketAdapters", "", "Lokhttp3/internal/platform/android/SocketAdapter;", "buildCertificateChainCleaner", "Lokhttp3/internal/tls/CertificateChainCleaner;", "trustManager", "Ljavax/net/ssl/X509TrustManager;", "buildTrustRootIndex", "Lokhttp3/internal/tls/TrustRootIndex;", "configureTlsExtensions", "", "sslSocket", "Ljavax/net/ssl/SSLSocket;", "hostname", "", "protocols", "Lokhttp3/Protocol;", "Lkotlin/jvm/JvmSuppressWildcards;", "connectSocket", "socket", "Ljava/net/Socket;", "address", "Ljava/net/InetSocketAddress;", "connectTimeout", "", "getSelectedProtocol", "getStackTraceForCloseable", "", "closer", "isCleartextTrafficPermitted", "", "logCloseableLeak", "message", "stackTrace", "sslSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "Companion", "CustomTrustRootIndex", "okhttp"})
public final class AndroidPlatform
extends Platform {
    public static final Companion Companion;
    private final List<SocketAdapter> socketAdapters;
    private final CloseGuard closeGuard;
    private static final boolean isSupported;

    /*
     * WARNING - void declaration
     */
    public AndroidPlatform() {
        Object[] objectArray = new SocketAdapter[4];
        Object object = objectArray;
        boolean bl = true;
        Object object2 = null;
        object2 = StandardAndroidSocketAdapter.Companion;
        object2 = "com.android.org.conscrypt";
        objectArray[0] = StandardAndroidSocketAdapter.Companion.buildIfSupported("com.android.org.conscrypt");
        object[1] = new DeferredSocketAdapter(AndroidSocketAdapter.access$getPlayProviderFactory$cp());
        object[2] = new DeferredSocketAdapter(ConscryptSocketAdapter.access$getFactory$cp());
        object[3] = new DeferredSocketAdapter(BouncyCastleSocketAdapter.access$getFactory$cp());
        object = CollectionsKt.listOfNotNull((Object[])object);
        AndroidPlatform androidPlatform = this;
        Collection destination$iv$iv = new ArrayList();
        object = object.iterator();
        while (object.hasNext()) {
            void var3_5;
            Object element$iv$iv = object.next();
            SocketAdapter socketAdapter = (SocketAdapter)element$iv$iv;
            if (!socketAdapter.isSupported()) continue;
            destination$iv$iv.add(var3_5);
        }
        androidPlatform.socketAdapters = (List)object2;
        this.closeGuard = CloseGuard.Companion.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void connectSocket(Socket socket, InetSocketAddress address, int connectTimeout) throws IOException {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        try {
            void var3_4;
            void var2_3;
            socket.connect((SocketAddress)var2_3, (int)var3_4);
            return;
        }
        catch (ClassCastException e) {
            void var1_2;
            if (Build.VERSION.SDK_INT == 26) {
                throw new IOException("Exception in connect", e);
            }
            throw var1_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
            Intrinsics.checkNotNullParameter(protocols, (String)"protocols");
            for (Object t : (Iterable)this.socketAdapters) {
                SocketAdapter socketAdapter = (SocketAdapter)t;
                if (!socketAdapter.matchesSocket(sslSocket)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        SocketAdapter socketAdapter = v0;
        if (socketAdapter != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            socketAdapter.configureTlsExtensions((SSLSocket)var1_1, (String)var2_2, (List<? extends Protocol>)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String getSelectedProtocol(SSLSocket sslSocket) {
        void var1_1;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
            for (Object t : (Iterable)this.socketAdapters) {
                SocketAdapter socketAdapter = (SocketAdapter)t;
                if (!socketAdapter.matchesSocket(sslSocket)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        SocketAdapter socketAdapter = v0;
        if (socketAdapter == null) {
            return null;
        }
        return socketAdapter.getSelectedProtocol((SSLSocket)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object getStackTraceForCloseable(String closer) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)closer, (String)"closer");
        return this.closeGuard.createAndOpen((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void logCloseableLeak(String message, Object stackTrace) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        boolean bl = this.closeGuard.warnIfOpen(var2_2);
        if (!bl) {
            void var1_1;
            Platform.log$default(this, (String)var1_1, 5, null, 4, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isCleartextTrafficPermitted(String hostname) {
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        if (Build.VERSION.SDK_INT >= 24) {
            void var1_1;
            return NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted((String)var1_1);
        }
        if (Build.VERSION.SDK_INT >= 23) {
            return NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted();
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CertificateChainCleaner buildCertificateChainCleaner(X509TrustManager trustManager) {
        Intrinsics.checkNotNullParameter((Object)trustManager, (String)"trustManager");
        AndroidCertificateChainCleaner androidCertificateChainCleaner = AndroidCertificateChainCleaner.Companion.buildIfSupported(trustManager);
        if (androidCertificateChainCleaner == null) {
            void var1_1;
            return super.buildCertificateChainCleaner((X509TrustManager)var1_1);
        }
        return androidCertificateChainCleaner;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final TrustRootIndex buildTrustRootIndex(X509TrustManager trustManager) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)trustManager, (String)"trustManager");
        try {
            Class[] classArray = new Class[1];
            object = classArray;
            classArray[0] = X509Certificate.class;
            Method method = trustManager.getClass().getDeclaredMethod("findTrustAnchorByIssuerAndSignature", (Class<?>)object);
            method.setAccessible(true);
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method");
            object = new CustomTrustRootIndex(trustManager, (Method)object);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            void var1_1;
            object = super.buildTrustRootIndex((X509TrustManager)var1_1);
        }
        return object;
    }

    public static final /* synthetic */ boolean access$isSupported$cp() {
        return isSupported;
    }

    static {
        boolean bl;
        Companion = new Companion(0);
        if (!Platform.Companion.isAndroid()) {
            bl = false;
        } else if (Build.VERSION.SDK_INT >= 30) {
            bl = false;
        } else {
            if (!(Build.VERSION.SDK_INT >= 21)) {
                String string = Intrinsics.stringPlus((String)"Expected Android API level 21+ but was ", (Object)Build.VERSION.SDK_INT);
                throw new IllegalStateException(string.toString());
            }
            bl = true;
        }
        isSupported = bl;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0007\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\b\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lokhttp3/internal/platform/AndroidPlatform$CustomTrustRootIndex;", "Lokhttp3/internal/tls/TrustRootIndex;", "trustManager", "Ljavax/net/ssl/X509TrustManager;", "findByIssuerAndSignatureMethod", "Ljava/lang/reflect/Method;", "(Ljavax/net/ssl/X509TrustManager;Ljava/lang/reflect/Method;)V", "component1", "component2", "copy", "equals", "", "other", "", "findByIssuerAndSignature", "Ljava/security/cert/X509Certificate;", "cert", "hashCode", "", "toString", "", "okhttp"})
    public static final class CustomTrustRootIndex
    implements TrustRootIndex {
        private final X509TrustManager trustManager;
        private final Method findByIssuerAndSignatureMethod;

        /*
         * WARNING - void declaration
         */
        public CustomTrustRootIndex(X509TrustManager trustManager, Method findByIssuerAndSignatureMethod) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)trustManager, (String)"trustManager");
            Intrinsics.checkNotNullParameter((Object)findByIssuerAndSignatureMethod, (String)"findByIssuerAndSignatureMethod");
            this.trustManager = var1_1;
            this.findByIssuerAndSignatureMethod = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final X509Certificate findByIssuerAndSignature(X509Certificate cert) {
            X509Certificate x509Certificate;
            Intrinsics.checkNotNullParameter((Object)cert, (String)"cert");
            try {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = cert;
                Object object = this.findByIssuerAndSignatureMethod.invoke((Object)this.trustManager, objectArray2);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.security.cert.TrustAnchor");
                }
                cert = (TrustAnchor)object;
                cert = ((TrustAnchor)cert).getTrustedCert();
            }
            catch (IllegalAccessException e) {
                void var1_2;
                throw new AssertionError("unable to get issues and signature", (Throwable)var1_2);
            }
            catch (InvocationTargetException invocationTargetException) {
                x509Certificate = null;
            }
            return x509Certificate;
        }

        public final String toString() {
            return "CustomTrustRootIndex(trustManager=" + this.trustManager + ", findByIssuerAndSignatureMethod=" + this.findByIssuerAndSignatureMethod + ')';
        }

        public final int hashCode() {
            int n = this.trustManager.hashCode();
            n = n * 31 + this.findByIssuerAndSignatureMethod.hashCode();
            return n;
        }

        public final boolean equals(Object other) {
            CustomTrustRootIndex customTrustRootIndex;
            if (this == other) {
                return true;
            }
            if (!(other instanceof CustomTrustRootIndex)) {
                return false;
            }
            customTrustRootIndex = customTrustRootIndex;
            if (!Intrinsics.areEqual((Object)this.trustManager, (Object)customTrustRootIndex.trustManager)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.findByIssuerAndSignatureMethod, (Object)customTrustRootIndex.findByIssuerAndSignatureMethod);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006\b"}, d2={"Lokhttp3/internal/platform/AndroidPlatform$Companion;", "", "()V", "isSupported", "", "()Z", "buildIfSupported", "Lokhttp3/internal/platform/Platform;", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(byte by) {
            this();
        }
    }
}

