/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.internal.platform.Android10Platform;
import okhttp3.internal.platform.AndroidPlatform;
import okhttp3.internal.platform.BouncyCastlePlatform;
import okhttp3.internal.platform.ConscryptPlatform;
import okhttp3.internal.platform.Jdk8WithJettyBootPlatform;
import okhttp3.internal.platform.Jdk9Platform;
import okhttp3.internal.platform.OpenJSSEPlatform;
import okhttp3.internal.platform.android.AndroidLog;
import okhttp3.internal.tls.BasicCertificateChainCleaner;
import okhttp3.internal.tls.BasicTrustRootIndex;
import okhttp3.internal.tls.CertificateChainCleaner;
import okhttp3.internal.tls.TrustRootIndex;
import okio.Buffer;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 /2\u00020\u0001:\u0001/B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J-\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0011\u0010\u0010\u001a\r\u0012\t\u0012\u00070\u0012\u00a2\u0006\u0002\b\u00130\u0011H\u0016J \u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0006\u0010\u001b\u001a\u00020\u000fJ\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001e\u001a\u00020\u000fH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J&\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u000f2\b\b\u0002\u0010#\u001a\u00020\u001a2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u001a\u0010&\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u000f2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u0016J\b\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010,\u001a\u00020\nH\u0016J\b\u0010-\u001a\u00020\u000fH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010.\u001a\u00020+H\u0016\u00a8\u00060"}, d2={"Lokhttp3/internal/platform/Platform;", "", "()V", "afterHandshake", "", "sslSocket", "Ljavax/net/ssl/SSLSocket;", "buildCertificateChainCleaner", "Lokhttp3/internal/tls/CertificateChainCleaner;", "trustManager", "Ljavax/net/ssl/X509TrustManager;", "buildTrustRootIndex", "Lokhttp3/internal/tls/TrustRootIndex;", "configureTlsExtensions", "hostname", "", "protocols", "", "Lokhttp3/Protocol;", "Lkotlin/jvm/JvmSuppressWildcards;", "connectSocket", "socket", "Ljava/net/Socket;", "address", "Ljava/net/InetSocketAddress;", "connectTimeout", "", "getPrefix", "getSelectedProtocol", "getStackTraceForCloseable", "closer", "isCleartextTrafficPermitted", "", "log", "message", "level", "t", "", "logCloseableLeak", "stackTrace", "newSSLContext", "Ljavax/net/ssl/SSLContext;", "newSslSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "platformTrustManager", "toString", "sslSocketFactory", "Companion", "okhttp"})
public class Platform {
    public static final Companion Companion = new Companion(0);
    private static volatile Platform platform = okhttp3.internal.platform.Platform$Companion.access$findPlatform(Companion);
    private static final Logger logger = Logger.getLogger(OkHttpClient.class.getName());

    public SSLContext newSSLContext() {
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        Intrinsics.checkNotNullExpressionValue((Object)sSLContext, (String)"getInstance(\"TLS\")");
        return sSLContext;
    }

    /*
     * WARNING - void declaration
     */
    public X509TrustManager platformTrustManager() {
        void var1_1;
        TrustManagerFactory factory2 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory2.init((KeyStore)null);
        Object[] objectArray = factory2.getTrustManagers();
        Intrinsics.checkNotNull((Object)objectArray);
        Object trustManagers = objectArray;
        if (!(objectArray.length == 1 && trustManagers[0] instanceof X509TrustManager)) {
            String string = Arrays.toString((Object[])trustManagers);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this)");
            trustManagers = Intrinsics.stringPlus((String)"Unexpected default trust managers: ", (Object)string);
            throw new IllegalStateException(trustManagers.toString());
        }
        void v2 = var1_1[0];
        if (v2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
        }
        return (X509TrustManager)v2;
    }

    /*
     * WARNING - void declaration
     */
    public void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"protocols");
    }

    public void afterHandshake(SSLSocket sslSocket) {
        Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
    }

    public String getSelectedProtocol(SSLSocket sslSocket) {
        Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void connectSocket(Socket socket, InetSocketAddress address, int connectTimeout) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        var1_1.connect((SocketAddress)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static void log(String message, int level, Throwable t) {
        void var2_3;
        String string;
        void var1_2;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Level logLevel = level == 5 ? Level.WARNING : Level.INFO;
        logger.log((Level)var1_2, string, (Throwable)var2_3);
    }

    public static /* synthetic */ void log$default(Platform platform, String string, int n, Throwable throwable, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: log");
        }
        if ((n2 & 2) != 0) {
            n = 4;
        }
        if ((n2 & 4) != 0) {
            throwable = null;
        }
        Platform.log(string, n, throwable);
    }

    public boolean isCleartextTrafficPermitted(String hostname) {
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public Object getStackTraceForCloseable(String closer) {
        Intrinsics.checkNotNullParameter((Object)closer, (String)"closer");
        if (logger.isLoggable(Level.FINE)) {
            void var1_1;
            return new Throwable((String)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void logCloseableLeak(String message, Object stackTrace) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (stackTrace == null) {
            String logMessage;
            logMessage = Intrinsics.stringPlus((String)logMessage, (Object)" To see where this was allocated, set the OkHttpClient logger level to FINE: Logger.getLogger(OkHttpClient.class.getName()).setLevel(Level.FINE);");
        }
        Platform.log((String)var1_1, 5, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public CertificateChainCleaner buildCertificateChainCleaner(X509TrustManager trustManager) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)trustManager, (String)"trustManager");
        return new BasicCertificateChainCleaner(this.buildTrustRootIndex((X509TrustManager)var1_1));
    }

    public TrustRootIndex buildTrustRootIndex(X509TrustManager trustManager) {
        X509Certificate[] x509CertificateArray;
        Intrinsics.checkNotNullParameter((Object)trustManager, (String)"trustManager");
        x509CertificateArray = x509CertificateArray.getAcceptedIssuers();
        Intrinsics.checkNotNullExpressionValue((Object)x509CertificateArray, (String)"trustManager.acceptedIssuers");
        return new BasicTrustRootIndex(Arrays.copyOf(x509CertificateArray, x509CertificateArray.length));
    }

    /*
     * WARNING - void declaration
     */
    public SSLSocketFactory newSslSocketFactory(X509TrustManager trustManager) {
        Intrinsics.checkNotNullParameter((Object)trustManager, (String)"trustManager");
        try {
            TrustManager[] trustManagerArray;
            TrustManager[] trustManagerArray2 = trustManagerArray = this.newSSLContext();
            TrustManager[] trustManagerArray3 = new TrustManager[1];
            trustManagerArray2 = trustManagerArray3;
            trustManagerArray3[0] = (TrustManager)trustManager;
            trustManagerArray.init(null, trustManagerArray2, null);
            trustManager = trustManagerArray.getSocketFactory();
            Intrinsics.checkNotNullExpressionValue((Object)trustManager, (String)"newSSLContext().apply {\n\u2026ll)\n      }.socketFactory");
            return trustManager;
        }
        catch (GeneralSecurityException e) {
            void var1_2;
            throw new AssertionError(Intrinsics.stringPlus((String)"No System TLS: ", (Object)e), (Throwable)var1_2);
        }
    }

    public String toString() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        return string;
    }

    public static final /* synthetic */ Platform access$getPlatform$cp() {
        return platform;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012J\u0014\u0010\u0016\u001a\u00020\u00172\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012J\b\u0010\u0018\u001a\u00020\u0010H\u0002J\b\u0010\u0019\u001a\u00020\u0010H\u0002J\b\u0010\u001a\u001a\u00020\u0010H\u0002J\b\u0010\u001b\u001a\u00020\u0010H\u0007J\u0010\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR\u0014\u0010\t\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\bR\u0014\u0010\n\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lokhttp3/internal/platform/Platform$Companion;", "", "()V", "INFO", "", "WARN", "isAndroid", "", "()Z", "isBouncyCastlePreferred", "isConscryptPreferred", "isOpenJSSEPreferred", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "platform", "Lokhttp3/internal/platform/Platform;", "alpnProtocolNames", "", "", "protocols", "Lokhttp3/Protocol;", "concatLengthPrefixed", "", "findAndroidPlatform", "findJvmPlatform", "findPlatform", "get", "resetForTests", "", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public static List<String> alpnProtocolNames(List<? extends Protocol> protocols) {
            Iterable<Protocol> iterable;
            Protocol protocol;
            Object $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(protocols, (String)"protocols");
            protocols = protocols;
            Object object = protocols;
            Iterable<Protocol> destination$iv$iv = new ArrayList();
            $this$filterTo$iv$iv = $this$filterTo$iv$iv.iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                Object element$iv$iv = $this$filterTo$iv$iv.next();
                protocol = (Protocol)((Object)element$iv$iv);
                if (!(protocol != Protocol.HTTP_1_0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable<Protocol> $this$map$iv = destination$iv$iv;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            object = object.iterator();
            while (object.hasNext()) {
                Iterable<Protocol> iterable2;
                Object item$iv$iv = object.next();
                Protocol it = (Protocol)((Object)iterable2);
                iterable2 = destination$iv$iv;
                iterable2.add((String)protocol.toString());
            }
            return (List)iterable;
        }

        public static boolean isAndroid() {
            return Intrinsics.areEqual((Object)"Dalvik", (Object)System.getProperty("java.vm.name"));
        }

        /*
         * WARNING - void declaration
         */
        public final byte[] concatLengthPrefixed(List<? extends Protocol> protocols) {
            void var2_2;
            Iterator<String> iterator;
            Intrinsics.checkNotNullParameter(protocols, (String)"protocols");
            Buffer result = new Buffer();
            for (String protocol : okhttp3.internal.platform.Platform$Companion.alpnProtocolNames((List<? extends Protocol>)((Object)iterator))) {
                void var3_3;
                result.writeByte(protocol.length());
                result.writeUtf8((String)var3_3);
            }
            void v0 = var2_2;
            iterator = v0;
            iterator = v0;
            return v0.readByteArray(iterator.size());
        }

        public /* synthetic */ Companion(byte by) {
            this();
        }

        public static final /* synthetic */ Platform access$findPlatform(Companion $this) {
            Object object = $this;
            if (okhttp3.internal.platform.Platform$Companion.isAndroid()) {
                AndroidLog.INSTANCE.enable();
                object = Android10Platform.Companion;
                Platform platform = Android10Platform.access$isSupported$cp() ? (Platform)new Android10Platform() : null;
                if (platform == null) {
                    object = AndroidPlatform.Companion;
                    Platform platform2 = AndroidPlatform.access$isSupported$cp() ? (Platform)new AndroidPlatform() : null;
                    platform = platform2;
                    Intrinsics.checkNotNull(platform2);
                }
                return platform;
            }
            object = Security.getProviders()[0].getName();
            if (Intrinsics.areEqual((Object)"Conscrypt", (Object)object)) {
                object = ConscryptPlatform.Companion;
                object = ConscryptPlatform.access$isSupported$cp() ? new ConscryptPlatform(0) : null;
                if (object != null) {
                    return (Platform)object;
                }
            }
            if (Intrinsics.areEqual((Object)"BC", (Object)(object = Security.getProviders()[0].getName()))) {
                object = BouncyCastlePlatform.Companion;
                object = BouncyCastlePlatform.access$isSupported$cp() ? new BouncyCastlePlatform(0) : null;
                if (object != null) {
                    return (Platform)object;
                }
            }
            if (Intrinsics.areEqual((Object)"OpenJSSE", (Object)(object = Security.getProviders()[0].getName()))) {
                object = OpenJSSEPlatform.Companion;
                object = OpenJSSEPlatform.access$isSupported$cp() ? new OpenJSSEPlatform(0) : null;
                if (object != null) {
                    return (Platform)object;
                }
            }
            object = Jdk9Platform.Companion;
            object = Jdk9Platform.access$isAvailable$cp() ? new Jdk9Platform() : null;
            if (object != null) {
                return (Platform)object;
            }
            object = Jdk8WithJettyBootPlatform.Companion.buildIfSupported();
            if (object != null) {
                return object;
            }
            return new Platform();
        }
    }
}

