/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.publicsuffix;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.IDN;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import okhttp3.internal.Util;
import okhttp3.internal.platform.Platform;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Okio;
import okio.Source;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\fJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\u0016\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000f\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lokhttp3/internal/publicsuffix/PublicSuffixDatabase;", "", "()V", "listRead", "Ljava/util/concurrent/atomic/AtomicBoolean;", "publicSuffixExceptionListBytes", "", "publicSuffixListBytes", "readCompleteLatch", "Ljava/util/concurrent/CountDownLatch;", "findMatchingRule", "", "", "domainLabels", "getEffectiveTldPlusOne", "domain", "readTheList", "", "readTheListUninterruptibly", "setListBytes", "splitDomain", "Companion", "okhttp"})
public final class PublicSuffixDatabase {
    public static final Companion Companion = new Companion(0);
    private final AtomicBoolean listRead = new AtomicBoolean(false);
    private final CountDownLatch readCompleteLatch = new CountDownLatch(1);
    private byte[] publicSuffixListBytes;
    private byte[] publicSuffixExceptionListBytes;
    private static final byte[] WILDCARD_LABEL;
    private static final List<String> PREVAILING_RULE;
    private static final PublicSuffixDatabase instance;

    /*
     * WARNING - void declaration
     */
    public final String getEffectiveTldPlusOne(String domain) {
        void var2_3;
        void var1_1;
        void var3_4;
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        String unicodeDomain = IDN.toUnicode(domain);
        Intrinsics.checkNotNullExpressionValue((Object)unicodeDomain, (String)"unicodeDomain");
        List<String> domainLabels = PublicSuffixDatabase.splitDomain(unicodeDomain);
        List<String> rule = this.findMatchingRule(domainLabels);
        if (domainLabels.size() == rule.size() && rule.get(0).charAt(0) != '!') {
            return null;
        }
        int firstLabelOffset = rule.get(0).charAt(0) == '!' ? domainLabels.size() - rule.size() : domainLabels.size() - (var3_4.size() + 1);
        return SequencesKt.joinToString$default((Sequence)SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)PublicSuffixDatabase.splitDomain((String)var1_1)), (int)var2_3), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
    }

    private static List<String> splitDomain(String domain) {
        List list;
        CharSequence charSequence = (CharSequence)domain;
        char[] cArray = new char[1];
        domain = cArray;
        cArray[0] = 46;
        List domainLabels = StringsKt.split$default((CharSequence)charSequence, (char[])domain, (boolean)false, (int)0, (int)6, null);
        if (Intrinsics.areEqual((Object)CollectionsKt.last((List)domainLabels), (Object)"")) {
            return CollectionsKt.dropLast((List)domainLabels, (int)1);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> findMatchingRule(List<String> domainLabels) {
        Object wildcardRuleLabels;
        List list;
        void var3_8;
        List list2;
        void var2_6;
        String rule;
        String rule22;
        int i2;
        Object object;
        int n;
        Object object2;
        block28: {
            if (!this.listRead.get() && this.listRead.compareAndSet(false, true)) {
                object2 = this;
                n = 0;
                while (true) {
                    try {
                        ((PublicSuffixDatabase)object2).readTheList();
                        break block28;
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        Thread.interrupted();
                        n = 1;
                        continue;
                    }
                    catch (IOException iOException) {
                        Platform.access$getPlatform$cp();
                        Platform.log("Failed to read public suffix list", 5, iOException);
                        break block28;
                    }
                    break;
                }
                finally {
                    if (n != 0) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            try {
                this.readCompleteLatch.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        if (!(this.publicSuffixListBytes != null)) {
            object2 = "Unable to load publicsuffixes.gz resource from the classpath.";
            throw new IllegalStateException(object2.toString());
        }
        int n2 = 0;
        n = domainLabels.size();
        byte[][] byArrayArray = new byte[n][];
        while (n2 < n) {
            int n3 = n2++;
            object = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"UTF_8");
            Intrinsics.checkNotNullExpressionValue((Object)domainLabels.get(n3).getBytes((Charset)object), (String)"this as java.lang.String).getBytes(charset)");
        }
        byte[][] domainLabelsUtf8Bytes = byArrayArray;
        String exactMatch = null;
        n = 0;
        int n4 = ((Object[])domainLabelsUtf8Bytes).length;
        while (n < n4) {
            i2 = n++;
            byte[] byArray = this.publicSuffixListBytes;
            if (this.publicSuffixListBytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"publicSuffixListBytes");
                byArray = null;
            }
            if ((rule22 = okhttp3.internal.publicsuffix.PublicSuffixDatabase$Companion.access$binarySearch(Companion, byArray, domainLabelsUtf8Bytes, i2)) == null) continue;
            exactMatch = rule22;
            break;
        }
        String wildcardMatch = null;
        if (n4 > 1) {
            byte[][] labelsWithWildcard = (byte[][])((Object[])domainLabelsUtf8Bytes).clone();
            i2 = 0;
            int rule22 = ((Object[])labelsWithWildcard).length - 1;
            while (i2 < rule22) {
                int labelIndex = i2++;
                labelsWithWildcard[labelIndex] = WILDCARD_LABEL;
                byte[] byArray = this.publicSuffixListBytes;
                if (this.publicSuffixListBytes == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"publicSuffixListBytes");
                    byArray = null;
                }
                if ((rule = okhttp3.internal.publicsuffix.PublicSuffixDatabase$Companion.access$binarySearch(Companion, byArray, labelsWithWildcard, labelIndex)) == null) continue;
                wildcardMatch = rule;
                break;
            }
        }
        String exception = null;
        if (wildcardMatch != null) {
            i2 = 0;
            int rule22 = ((Object[])domainLabelsUtf8Bytes).length - 1;
            while (i2 < rule22) {
                int labelIndex = i2++;
                byte[] byArray = this.publicSuffixExceptionListBytes;
                if (this.publicSuffixExceptionListBytes == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"publicSuffixExceptionListBytes");
                    byArray = null;
                }
                if ((rule = okhttp3.internal.publicsuffix.PublicSuffixDatabase$Companion.access$binarySearch(Companion, byArray, domainLabelsUtf8Bytes, labelIndex)) == null) continue;
                exception = rule;
                break;
            }
        }
        if (exception != null) {
            String string = Intrinsics.stringPlus((String)"!", exception);
            char[] cArray = new char[1];
            char[] i2 = cArray;
            cArray[0] = 46;
            return StringsKt.split$default((CharSequence)string, (char[])i2, (boolean)false, (int)0, (int)6, null);
        }
        if (exactMatch == null && wildcardMatch == null) {
            return PREVAILING_RULE;
        }
        void v6 = var2_6;
        if (v6 == null) {
            list2 = null;
        } else {
            char[] cArray = new char[1];
            object = cArray;
            cArray[0] = 46;
            list2 = StringsKt.split$default((CharSequence)((CharSequence)v6), (char[])object, (boolean)false, (int)0, (int)6, null);
        }
        rule22 = list2;
        Object exactRuleLabels = list2 == null ? CollectionsKt.emptyList() : rule22;
        void v9 = var3_8;
        if (v9 == null) {
            list = null;
        } else {
            char[] cArray = new char[1];
            char[] cArray2 = cArray;
            cArray[0] = 46;
            list = StringsKt.split$default((CharSequence)((CharSequence)v9), (char[])cArray2, (boolean)false, (int)0, (int)6, null);
        }
        object = list;
        Object object3 = wildcardRuleLabels = list == null ? CollectionsKt.emptyList() : object;
        if (exactRuleLabels.size() > wildcardRuleLabels.size()) {
            return exactRuleLabels;
        }
        return wildcardRuleLabels;
    }

    /*
     * WARNING - void declaration
     */
    private final void readTheList() throws IOException {
        InputStream inputStream = PublicSuffixDatabase.class.getResourceAsStream("publicsuffixes.gz");
        if (inputStream == null) {
            return;
        }
        InputStream resource = inputStream;
        Object object = (Closeable)Okio.buffer((Source)((Source)new GzipSource(Okio.source((InputStream)resource))));
        Throwable throwable = null;
        try {
            BufferedSource bufferedSource = (BufferedSource)object;
            int totalBytes = bufferedSource.readInt();
            byte[] publicSuffixListBytes = bufferedSource.readByteArray((long)totalBytes);
            int totalExceptionBytes = bufferedSource.readInt();
            byte[] publicSuffixExceptionListBytes = bufferedSource.readByteArray((long)totalExceptionBytes);
        }
        catch (Throwable throwable2) {
            Throwable publicSuffixExceptionListBytes = throwable2;
            throwable = throwable2;
            throw publicSuffixExceptionListBytes;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        object = this;
        synchronized (object) {
            void var2_7;
            void var1_3;
            void v2 = var1_3;
            Intrinsics.checkNotNull((Object)v2);
            this.publicSuffixListBytes = v2;
            void v3 = var2_7;
            Intrinsics.checkNotNull((Object)v3);
            this.publicSuffixExceptionListBytes = v3;
        }
        this.readCompleteLatch.countDown();
    }

    public static final /* synthetic */ PublicSuffixDatabase access$getInstance$cp() {
        return instance;
    }

    static {
        byte[] byArray = new byte[1];
        byte[] byArray2 = byArray;
        byArray[0] = 42;
        WILDCARD_LABEL = byArray2;
        PREVAILING_RULE = CollectionsKt.listOf((Object)"*");
        instance = new PublicSuffixDatabase();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\fJ)\u0010\u000e\u001a\u0004\u0018\u00010\u0007*\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lokhttp3/internal/publicsuffix/PublicSuffixDatabase$Companion;", "", "()V", "EXCEPTION_MARKER", "", "PREVAILING_RULE", "", "", "PUBLIC_SUFFIX_RESOURCE", "WILDCARD_LABEL", "", "instance", "Lokhttp3/internal/publicsuffix/PublicSuffixDatabase;", "get", "binarySearch", "labels", "", "labelIndex", "", "([B[[BI)Ljava/lang/String;", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ String access$binarySearch(Companion $this, byte[] $receiver, byte[][] labels, int labelIndex) {
            void var2_2;
            int n;
            void var2_3 = n;
            void var1_1 = var2_2;
            Object object = $receiver;
            n = 0;
            int n2 = ((Object)object).length;
            String string = null;
            while (n < n2) {
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                int n8 = (n + n2) / 2;
                while (n8 >= 0 && object[n8] != 10) {
                    n7 = n8;
                    n8 = n7 + -1;
                }
                n7 = n8;
                n8 = n7 + 1;
                n7 = 1;
                while (object[n8 + n7] != 10) {
                    n6 = n7;
                    n7 = n6 + 1;
                }
                n6 = n8 + n7 - n8;
                int n9 = var2_3;
                int n10 = 0;
                int n11 = 0;
                boolean bl = false;
                while (true) {
                    if (bl) {
                        n5 = 46;
                        bl = false;
                    } else {
                        n5 = Util.and((byte)var1_1[n9][n10], 255);
                    }
                    n4 = Util.and((byte)object[n8 + n11], 255);
                    if ((n5 -= n4) != 0) break;
                    n3 = n11;
                    n11 = n3 + 1;
                    n3 = n10;
                    n10 = n3 + 1;
                    if (n11 == n6) break;
                    if (((void)var1_1[n9]).length != n10) continue;
                    if (n9 == ((Object[])var1_1).length - 1) break;
                    n3 = n9;
                    n9 = n3 + 1;
                    n10 = -1;
                    bl = true;
                }
                if (n5 < 0) {
                    n2 = n8 - 1;
                    continue;
                }
                if (n5 > 0) {
                    n = n8 + n7 + 1;
                    continue;
                }
                n5 = n6 - n11;
                n4 = ((void)var1_1[n9]).length - n10;
                n3 = n9 + true;
                n9 = ((Object[])var1_1).length;
                while (n3 < n9) {
                    n10 = n3++;
                    n4 += ((void)var1_1[n10]).length;
                }
                if (n4 < n5) {
                    n2 = n8 - 1;
                    continue;
                }
                if (n4 > n5) {
                    n = n8 + n7 + 1;
                    continue;
                }
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                string = new String((byte[])object, n8, n6, charset);
                break;
            }
            return string;
        }

        public /* synthetic */ Companion(byte by) {
            this();
        }
    }
}

