/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.tls;

import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.tls.CertificateChainCleaner;
import okhttp3.internal.tls.TrustRootIndex;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lokhttp3/internal/tls/BasicCertificateChainCleaner;", "Lokhttp3/internal/tls/CertificateChainCleaner;", "trustRootIndex", "Lokhttp3/internal/tls/TrustRootIndex;", "(Lokhttp3/internal/tls/TrustRootIndex;)V", "clean", "", "Ljava/security/cert/Certificate;", "chain", "hostname", "", "equals", "", "other", "", "hashCode", "", "verifySignature", "toVerify", "Ljava/security/cert/X509Certificate;", "signingCert", "Companion", "okhttp"})
public final class BasicCertificateChainCleaner
extends CertificateChainCleaner {
    private final TrustRootIndex trustRootIndex;

    /*
     * WARNING - void declaration
     */
    public BasicCertificateChainCleaner(TrustRootIndex trustRootIndex) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)trustRootIndex, (String)"trustRootIndex");
        this.trustRootIndex = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final List<Certificate> clean(List<? extends Certificate> chain, String hostname) throws SSLPeerUnverifiedException {
        void var2_2;
        Intrinsics.checkNotNullParameter(chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        Deque queue = new ArrayDeque(chain);
        List result = new ArrayList();
        Object e = queue.removeFirst();
        Intrinsics.checkNotNullExpressionValue(e, (String)"queue.removeFirst()");
        result.add(e);
        boolean foundTrustedCertificate = false;
        int n = 0;
        block0: while (n < 9) {
            void var3_4;
            ++n;
            List list = result;
            X509Certificate toVerify = (X509Certificate)list.get(list.size() - 1);
            X509Certificate trustedCert = this.trustRootIndex.findByIssuerAndSignature(toVerify);
            if (trustedCert != null) {
                if (result.size() > 1 || !Intrinsics.areEqual((Object)toVerify, (Object)trustedCert)) {
                    result.add(trustedCert);
                }
                X509Certificate x509Certificate = trustedCert;
                if (BasicCertificateChainCleaner.verifySignature(x509Certificate, x509Certificate)) {
                    return result;
                }
                foundTrustedCertificate = true;
                continue;
            }
            Iterator iterator = queue.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"queue.iterator()");
            Iterator i = iterator;
            while (i.hasNext()) {
                Object e2 = i.next();
                if (e2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.security.cert.X509Certificate");
                }
                X509Certificate signingCert = (X509Certificate)e2;
                if (!BasicCertificateChainCleaner.verifySignature(toVerify, signingCert)) continue;
                i.remove();
                result.add(signingCert);
                continue block0;
            }
            if (var3_4 != false) {
                return result;
            }
            throw new SSLPeerUnverifiedException(Intrinsics.stringPlus((String)"Failed to find a trusted cert that signed ", (Object)toVerify));
        }
        throw new SSLPeerUnverifiedException(Intrinsics.stringPlus((String)"Certificate chain too long: ", (Object)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private static boolean verifySignature(X509Certificate toVerify, X509Certificate signingCert) {
        boolean bl;
        if (!Intrinsics.areEqual((Object)toVerify.getIssuerDN(), (Object)signingCert.getSubjectDN())) {
            return false;
        }
        try {
            void var1_2;
            X509Certificate x509Certificate;
            x509Certificate.verify(var1_2.getPublicKey());
            bl = true;
        }
        catch (GeneralSecurityException generalSecurityException) {
            bl = false;
        }
        return bl;
    }

    public final int hashCode() {
        return this.trustRootIndex.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        if (other == this) {
            return true;
        }
        return other instanceof BasicCertificateChainCleaner && Intrinsics.areEqual((Object)((BasicCertificateChainCleaner)var1_1).trustRootIndex, (Object)this.trustRootIndex);
    }

    static {
        new Companion(0);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lokhttp3/internal/tls/BasicCertificateChainCleaner$Companion;", "", "()V", "MAX_SIGNERS", "", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(byte by) {
            this();
        }
    }
}

