/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.AltCallingConvention;
import com.sun.jna.Function;
import com.sun.jna.InvocationMapper;
import com.sun.jna.NativeLibrary;
import com.sun.jna.internal.ReflectionUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public interface Library {
    public static final String OPTION_TYPE_MAPPER = "type-mapper";
    public static final String OPTION_FUNCTION_MAPPER = "function-mapper";
    public static final String OPTION_INVOCATION_MAPPER = "invocation-mapper";
    public static final String OPTION_STRUCTURE_ALIGNMENT = "structure-alignment";
    public static final String OPTION_STRING_ENCODING = "string-encoding";
    public static final String OPTION_ALLOW_OBJECTS = "allow-objects";
    public static final String OPTION_CALLING_CONVENTION = "calling-convention";
    public static final String OPTION_OPEN_FLAGS = "open-flags";
    public static final String OPTION_CLASSLOADER = "classloader";

    public static class Handler
    implements InvocationHandler {
        static final Method OBJECT_TOSTRING;
        static final Method OBJECT_HASHCODE;
        static final Method OBJECT_EQUALS;
        private final NativeLibrary nativeLibrary;
        private final Class<?> interfaceClass;
        private final Map<String, Object> options;
        private final InvocationMapper invocationMapper;
        private final Map<Method, FunctionInfo> functions = new WeakHashMap<Method, FunctionInfo>();

        /*
         * WARNING - void declaration
         */
        public Handler(String libname, Class<?> interfaceClass, Map<String, ?> options) {
            void var1_1;
            int callingConvention;
            if (libname != null && "".equals(libname.trim())) {
                throw new IllegalArgumentException("Invalid library name \"" + libname + "\"");
            }
            if (!interfaceClass.isInterface()) {
                throw new IllegalArgumentException(libname + " does not implement an interface: " + interfaceClass.getName());
            }
            this.interfaceClass = interfaceClass;
            this.options = new HashMap(options);
            int n = callingConvention = AltCallingConvention.class.isAssignableFrom(interfaceClass) ? 63 : 0;
            if (this.options.get(Library.OPTION_CALLING_CONVENTION) == null) {
                void var3_4;
                this.options.put(Library.OPTION_CALLING_CONVENTION, (int)var3_4);
            }
            if (this.options.get(Library.OPTION_CLASSLOADER) == null) {
                void var2_2;
                this.options.put(Library.OPTION_CLASSLOADER, var2_2.getClassLoader());
            }
            this.nativeLibrary = NativeLibrary.getInstance((String)var1_1, this.options);
            this.invocationMapper = (InvocationMapper)this.options.get(Library.OPTION_INVOCATION_MAPPER);
        }

        public NativeLibrary getNativeLibrary() {
            return this.nativeLibrary;
        }

        public String getLibraryName() {
            return this.nativeLibrary.getName();
        }

        public Class<?> getInterfaceClass() {
            return this.interfaceClass;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] inArgs) throws Throwable {
            void var3_4;
            void var2_3;
            FunctionInfo functionInfo;
            if (OBJECT_TOSTRING.equals(method)) {
                return "Proxy interface to " + this.nativeLibrary;
            }
            if (OBJECT_HASHCODE.equals(method)) {
                return this.hashCode();
            }
            if (OBJECT_EQUALS.equals(method)) {
                Object o = inArgs[0];
                if (o != null && Proxy.isProxyClass(o.getClass())) {
                    return Function.valueOf(Proxy.getInvocationHandler(o) == this);
                }
                return Boolean.FALSE;
            }
            FunctionInfo f2 = this.functions.get(method);
            if (f2 == null) {
                Map<Method, FunctionInfo> map = this.functions;
                synchronized (map) {
                    f2 = this.functions.get(method);
                    if (f2 == null) {
                        boolean f2 = ReflectionUtils.isDefault(method);
                        if (!f2) {
                            boolean isVarArgs = Function.isVarArgs(method);
                            InvocationHandler handler = null;
                            if (this.invocationMapper != null) {
                                handler = this.invocationMapper.getInvocationHandler(this.nativeLibrary, method);
                            }
                            Function function = null;
                            Class<?>[] parameterTypes = null;
                            HashMap<String, Object> options = null;
                            if (handler == null) {
                                function = this.nativeLibrary.getFunction(method.getName(), method);
                                parameterTypes = method.getParameterTypes();
                                options = new HashMap<String, Object>(this.options);
                                options.put("invoking-method", method);
                            }
                            functionInfo = new FunctionInfo(handler, function, parameterTypes, isVarArgs, options);
                        } else {
                            functionInfo = new FunctionInfo(ReflectionUtils.getMethodHandle(method));
                        }
                        this.functions.put(method, functionInfo);
                    }
                }
            }
            if (functionInfo.methodHandle != null) {
                return ReflectionUtils.invokeDefaultMethod(proxy, functionInfo.methodHandle, inArgs);
            }
            if (functionInfo.isVarArgs) {
                inArgs = Function.concatenateVarArgs(inArgs);
            }
            if (functionInfo.handler != null) {
                void var1_1;
                return functionInfo.handler.invoke(var1_1, method, inArgs);
            }
            return functionInfo.function.invoke(method, functionInfo.parameterTypes, var2_3.getReturnType(), (Object[])var3_4, functionInfo.options);
        }

        static {
            try {
                OBJECT_TOSTRING = Object.class.getMethod("toString", new Class[0]);
                OBJECT_HASHCODE = Object.class.getMethod("hashCode", new Class[0]);
                OBJECT_EQUALS = Object.class.getMethod("equals", Object.class);
                return;
            }
            catch (Exception exception) {
                throw new Error("Error retrieving Object.toString() method");
            }
        }

        private static final class FunctionInfo {
            final InvocationHandler handler;
            final Function function;
            final boolean isVarArgs;
            final Object methodHandle;
            final Map<String, ?> options;
            final Class<?>[] parameterTypes;

            /*
             * WARNING - void declaration
             */
            FunctionInfo(Object mh) {
                void var1_1;
                this.handler = null;
                this.function = null;
                this.isVarArgs = false;
                this.options = null;
                this.parameterTypes = null;
                this.methodHandle = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            FunctionInfo(InvocationHandler handler, Function function, Class<?>[] parameterTypes, boolean isVarArgs, Map<String, ?> options) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.handler = var1_1;
                this.function = var2_2;
                this.isVarArgs = isVarArgs;
                this.options = options;
                this.parameterTypes = var3_3;
                this.methodHandle = null;
            }
        }
    }
}

