/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.WeakMemoryHolder;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class Memory
extends Pointer {
    private static ReferenceQueue<Memory> QUEUE = new ReferenceQueue();
    private static LinkedReference HEAD;
    private static final WeakMemoryHolder buffers;
    private final LinkedReference reference;
    protected long size;

    public static void purge() {
        buffers.clean();
    }

    /*
     * WARNING - void declaration
     */
    public static void disposeAll() {
        Object object = LinkedReference.class;
        synchronized (LinkedReference.class) {
            LinkedReference entry;
            while ((entry = HEAD) != null) {
                Memory memory = (Memory)HEAD.get();
                if (memory != null) {
                    void var2_4;
                    var2_4.dispose();
                } else {
                    Memory.HEAD.unlink();
                }
                if (HEAD != entry) continue;
                throw new IllegalStateException("the HEAD did not change");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            object = QUEUE;
            synchronized (object) {
                LinkedReference stale;
                while ((stale = (LinkedReference)QUEUE.poll()) != null) {
                    void var1_1;
                    ((LinkedReference)var1_1).unlink();
                }
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    static int integrityCheck() {
        Class<LinkedReference> clazz = LinkedReference.class;
        synchronized (LinkedReference.class) {
            void var1_1;
            if (HEAD == null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return 0;
            }
            ArrayList<LinkedReference> entries = new ArrayList<LinkedReference>();
            LinkedReference entry = HEAD;
            while (entry != null) {
                entries.add(entry);
                entry = entry.next;
            }
            int index = entries.size() - 1;
            entry = (LinkedReference)entries.get(index);
            while (entry != null) {
                if (entries.get(index) != entry) {
                    throw new IllegalStateException(entries.get(index) + " vs. " + entry + " at index " + index);
                }
                entry = entry.prev;
                --index;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return var1_1.size();
        }
    }

    /*
     * WARNING - void declaration
     */
    public Memory(long size) {
        this.size = size;
        if (size <= 0L) {
            throw new IllegalArgumentException("Allocation size must be greater than zero");
        }
        this.peer = Memory.malloc(size);
        if (this.peer == 0L) {
            void var1_1;
            throw new OutOfMemoryError("Cannot allocate " + (long)var1_1 + " bytes");
        }
        this.reference = LinkedReference.track(this);
    }

    protected Memory() {
        this.reference = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Pointer share(long offset) {
        void var1_1;
        return this.share(offset, this.size() - var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Pointer share(long offset, long sz) {
        void var3_2;
        void var1_1;
        this.boundsCheck(offset, sz);
        return new SharedMemory((long)var1_1, (long)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public Memory align(int byteBoundary) {
        if (byteBoundary <= 0) {
            throw new IllegalArgumentException("Byte boundary must be positive: " + byteBoundary);
        }
        for (int i = 0; i < 32; ++i) {
            if (byteBoundary != 1 << i) continue;
            long mask = (long)byteBoundary - 1L ^ 0xFFFFFFFFFFFFFFFFL;
            if ((this.peer & mask) != this.peer) {
                void var3_3;
                long newPeer = this.peer + (long)byteBoundary - 1L & var3_3;
                long newSize = this.peer + this.size - newPeer;
                if (newSize <= 0L) {
                    throw new IllegalArgumentException("Insufficient memory to align to the requested boundary");
                }
                return (Memory)this.share(newPeer - this.peer, newSize);
            }
            return this;
        }
        throw new IllegalArgumentException("Byte boundary must be a power of two");
    }

    protected void finalize() {
        this.dispose();
    }

    protected synchronized void dispose() {
        if (this.peer == 0L) {
            return;
        }
        try {
            Memory.free(this.peer);
            return;
        }
        finally {
            this.peer = 0L;
            this.reference.unlink();
        }
    }

    public void clear() {
        Memory memory = this;
        memory.clear(memory.size);
    }

    public boolean valid() {
        return this.peer != 0L;
    }

    public long size() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    protected void boundsCheck(long off, long sz) {
        if (off < 0L) {
            throw new IndexOutOfBoundsException("Invalid offset: " + off);
        }
        if (off + sz > this.size) {
            void var1_2;
            void var3_3;
            String msg = "Bounds exceeds available space : size=" + this.size + ", offset=" + (off + var3_3);
            throw new IndexOutOfBoundsException((String)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void read(long bOff, byte[] buf, int index, int length) {
        void var3_2;
        void var1_1;
        this.boundsCheck(bOff, length);
        super.read((long)var1_1, (byte[])var3_2, index, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void read(long bOff, short[] buf, int index, int length) {
        void var3_2;
        void var1_1;
        this.boundsCheck(bOff, (long)length << 1);
        super.read((long)var1_1, (short[])var3_2, index, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void read(long bOff, char[] buf, int index, int length) {
        void var3_2;
        void var1_1;
        this.boundsCheck(bOff, length * Native.WCHAR_SIZE);
        super.read((long)var1_1, (char[])var3_2, index, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void read(long bOff, int[] buf, int index, int length) {
        void var3_2;
        void var1_1;
        this.boundsCheck(bOff, (long)length << 2);
        super.read((long)var1_1, (int[])var3_2, index, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void read(long bOff, long[] buf, int index, int length) {
        void var3_2;
        void var1_1;
        this.boundsCheck(bOff, (long)length << 3);
        super.read((long)var1_1, (long[])var3_2, index, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void read(long bOff, float[] buf, int index, int length) {
        void var3_2;
        void var1_1;
        this.boundsCheck(bOff, (long)length << 2);
        super.read((long)var1_1, (float[])var3_2, index, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void read(long bOff, double[] buf, int index, int length) {
        void var3_2;
        void var1_1;
        this.boundsCheck(bOff, (long)length << 3);
        super.read((long)var1_1, (double[])var3_2, index, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void read(long bOff, Pointer[] buf, int index, int length) {
        void var3_2;
        void var1_1;
        this.boundsCheck(bOff, length * Native.POINTER_SIZE);
        super.read((long)var1_1, (Pointer[])var3_2, index, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(long bOff, byte[] buf, int index, int length) {
        void var3_2;
        void var1_1;
        this.boundsCheck(bOff, length);
        super.write((long)var1_1, (byte[])var3_2, index, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(long bOff, short[] buf, int index, int length) {
        void var3_2;
        void var1_1;
        this.boundsCheck(bOff, (long)length << 1);
        super.write((long)var1_1, (short[])var3_2, index, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(long bOff, char[] buf, int index, int length) {
        void var3_2;
        void var1_1;
        this.boundsCheck(bOff, length * Native.WCHAR_SIZE);
        super.write((long)var1_1, (char[])var3_2, index, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(long bOff, int[] buf, int index, int length) {
        void var3_2;
        void var1_1;
        this.boundsCheck(bOff, (long)length << 2);
        super.write((long)var1_1, (int[])var3_2, index, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(long bOff, long[] buf, int index, int length) {
        void var3_2;
        void var1_1;
        this.boundsCheck(bOff, (long)length << 3);
        super.write((long)var1_1, (long[])var3_2, index, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(long bOff, float[] buf, int index, int length) {
        void var3_2;
        void var1_1;
        this.boundsCheck(bOff, (long)length << 2);
        super.write((long)var1_1, (float[])var3_2, index, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(long bOff, double[] buf, int index, int length) {
        void var3_2;
        void var1_1;
        this.boundsCheck(bOff, (long)length << 3);
        super.write((long)var1_1, (double[])var3_2, index, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(long bOff, Pointer[] buf, int index, int length) {
        void var3_2;
        void var1_1;
        this.boundsCheck(bOff, length * Native.POINTER_SIZE);
        super.write((long)var1_1, (Pointer[])var3_2, index, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte getByte(long offset) {
        void var1_1;
        this.boundsCheck(offset, 1L);
        return super.getByte((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public char getChar(long offset) {
        void var1_1;
        this.boundsCheck(offset, Native.WCHAR_SIZE);
        return super.getChar((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public short getShort(long offset) {
        void var1_1;
        this.boundsCheck(offset, 2L);
        return super.getShort((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getInt(long offset) {
        void var1_1;
        this.boundsCheck(offset, 4L);
        return super.getInt((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getLong(long offset) {
        void var1_1;
        this.boundsCheck(offset, 8L);
        return super.getLong((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float getFloat(long offset) {
        void var1_1;
        this.boundsCheck(offset, 4L);
        return super.getFloat((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double getDouble(long offset) {
        void var1_1;
        this.boundsCheck(offset, 8L);
        return super.getDouble((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Pointer getPointer(long offset) {
        void var1_1;
        this.boundsCheck(offset, Native.POINTER_SIZE);
        Memory memory = this;
        return memory.shareReferenceIfInBounds(super.getPointer((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuffer getByteBuffer(long offset, long length) {
        void var1_2;
        void var3_3;
        this.boundsCheck(offset, length);
        ByteBuffer b = super.getByteBuffer(offset, (long)var3_3);
        buffers.put(b, this);
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getString(long offset, String encoding) {
        void var3_2;
        void var1_1;
        this.boundsCheck(offset, 0L);
        return super.getString((long)var1_1, (String)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getWideString(long offset) {
        void var1_1;
        this.boundsCheck(offset, 0L);
        return super.getWideString((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setByte(long offset, byte value) {
        void var3_2;
        void var1_1;
        this.boundsCheck(offset, 1L);
        super.setByte((long)var1_1, (byte)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setChar(long offset, char value) {
        void var3_2;
        void var1_1;
        this.boundsCheck(offset, Native.WCHAR_SIZE);
        super.setChar((long)var1_1, (char)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setShort(long offset, short value) {
        void var3_2;
        void var1_1;
        this.boundsCheck(offset, 2L);
        super.setShort((long)var1_1, (short)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setInt(long offset, int value) {
        void var3_2;
        void var1_1;
        this.boundsCheck(offset, 4L);
        super.setInt((long)var1_1, (int)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setLong(long offset, long value) {
        void var3_2;
        void var1_1;
        this.boundsCheck(offset, 8L);
        super.setLong((long)var1_1, (long)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setFloat(long offset, float value) {
        void var3_2;
        void var1_1;
        this.boundsCheck(offset, 4L);
        super.setFloat((long)var1_1, (float)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setDouble(long offset, double value) {
        void var3_2;
        void var1_1;
        this.boundsCheck(offset, 8L);
        super.setDouble((long)var1_1, (double)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setPointer(long offset, Pointer value) {
        void var3_2;
        void var1_1;
        this.boundsCheck(offset, Native.POINTER_SIZE);
        super.setPointer((long)var1_1, (Pointer)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setString(long offset, String value, String encoding) {
        void var3_2;
        void var1_1;
        this.boundsCheck(offset, (long)Native.getBytes(value, encoding).length + 1L);
        super.setString((long)var1_1, (String)var3_2, encoding);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setWideString(long offset, String value) {
        void var3_2;
        void var1_1;
        this.boundsCheck(offset, ((long)value.length() + 1L) * (long)Native.WCHAR_SIZE);
        super.setWideString((long)var1_1, (String)var3_2);
    }

    @Override
    public String toString() {
        return "allocated@0x" + Long.toHexString(this.peer) + " (" + this.size + " bytes)";
    }

    protected static void free(long p) {
        if (p != 0L) {
            long l;
            Native.free(l);
        }
    }

    protected static long malloc(long size) {
        return Native.malloc(size);
    }

    public String dump() {
        return this.dump(0L, (int)this.size());
    }

    /*
     * WARNING - void declaration
     */
    private Pointer shareReferenceIfInBounds(Pointer target) {
        void var1_1;
        if (target == null) {
            return null;
        }
        long offset = target.peer - this.peer;
        if (offset >= 0L && offset < this.size) {
            void var2_2;
            return this.share((long)var2_2);
        }
        return var1_1;
    }

    static {
        buffers = new WeakMemoryHolder();
    }

    private class SharedMemory
    extends Memory {
        /*
         * WARNING - void declaration
         */
        public SharedMemory(long offset, long size) {
            void var2_2;
            this.size = size;
            this.peer = Memory.this.peer + var2_2;
        }

        @Override
        protected synchronized void dispose() {
            this.peer = 0L;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void boundsCheck(long off, long sz) {
            void var3_2;
            void var1_1;
            Memory.this.boundsCheck(this.peer - Memory.this.peer + var1_1, (long)var3_2);
        }

        @Override
        public String toString() {
            return super.toString() + " (shared from " + Memory.this.toString() + ")";
        }
    }

    private static class LinkedReference
    extends WeakReference<Memory> {
        private LinkedReference next;
        private LinkedReference prev;

        /*
         * WARNING - void declaration
         */
        private LinkedReference(Memory referent) {
            super(var1_1, QUEUE);
            void var1_1;
        }

        static LinkedReference track(Memory instance) {
            Memory memory;
            Class<LinkedReference> clazz;
            ReferenceQueue referenceQueue = QUEUE;
            synchronized (referenceQueue) {
                LinkedReference stale;
                while ((stale = (LinkedReference)QUEUE.poll()) != null) {
                    super.unlink();
                }
            }
            LinkedReference entry = new LinkedReference(memory);
            clazz = LinkedReference.class;
            synchronized (LinkedReference.class) {
                if (HEAD != null) {
                    entry.next = HEAD;
                    HEAD.prev = entry;
                    HEAD = HEAD.prev;
                } else {
                    HEAD = entry;
                }
                // ** MonitorExit[var2_4] (shouldn't be in output)
                return referenceQueue;
            }
        }

        private void unlink() {
            Class<LinkedReference> clazz = LinkedReference.class;
            synchronized (LinkedReference.class) {
                LinkedReference next;
                if (HEAD != this) {
                    if (this.prev == null) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                    next = this.prev.next = this.next;
                } else {
                    next = HEAD = HEAD.next;
                }
                if (next != null) {
                    var2_2.prev = this.prev;
                }
                this.prev = null;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }
}

