/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Callback;
import com.sun.jna.CallbackReference;
import com.sun.jna.CallbackThreadInitializer;
import com.sun.jna.FromNativeContext;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.Function;
import com.sun.jna.IntegerType;
import com.sun.jna.JNIEnv;
import com.sun.jna.LastErrorException;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.MethodResultContext;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.Structure;
import com.sun.jna.ToNativeContext;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.Version;
import com.sun.jna.WString;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Window;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.constant.Constable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Native
implements Version {
    private static final Logger LOG = Logger.getLogger(Native.class.getName());
    public static final Charset DEFAULT_CHARSET = Charset.defaultCharset();
    public static final String DEFAULT_ENCODING = DEFAULT_CHARSET.name();
    public static final boolean DEBUG_LOAD = Boolean.getBoolean("jna.debug_load");
    public static final boolean DEBUG_JNA_LOAD = Boolean.getBoolean("jna.debug_load.jna");
    private static final Level DEBUG_JNA_LOAD_LEVEL = DEBUG_JNA_LOAD ? Level.INFO : Level.FINE;
    static String jnidispatchPath = null;
    private static final Map<Class<?>, Map<String, Object>> typeOptions = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<Class<?>, Reference<?>> libraries = Collections.synchronizedMap(new WeakHashMap());
    private static final String _OPTION_ENCLOSING_LIBRARY = "enclosing-library";
    private static final Callback.UncaughtExceptionHandler DEFAULT_HANDLER;
    private static Callback.UncaughtExceptionHandler callbackExceptionHandler;
    public static final int POINTER_SIZE;
    public static final int LONG_SIZE;
    public static final int WCHAR_SIZE;
    public static final int SIZE_T_SIZE;
    public static final int BOOL_SIZE;
    public static final int LONG_DOUBLE_SIZE;
    private static final int TYPE_VOIDP = 0;
    private static final int TYPE_LONG = 1;
    private static final int TYPE_WCHAR_T = 2;
    private static final int TYPE_SIZE_T = 3;
    private static final int TYPE_BOOL = 4;
    private static final int TYPE_LONG_DOUBLE = 5;
    static final int MAX_ALIGNMENT;
    static final int MAX_PADDING;
    private static final Object finalizer;
    static final String JNA_TMPLIB_PREFIX = "jna";
    private static final Map<Class<?>, long[]> registeredClasses;
    private static final Map<Class<?>, NativeLibrary> registeredLibraries;
    static final int CB_HAS_INITIALIZER = 1;
    private static final int CVT_UNSUPPORTED = -1;
    private static final int CVT_DEFAULT = 0;
    private static final int CVT_POINTER = 1;
    private static final int CVT_STRING = 2;
    private static final int CVT_STRUCTURE = 3;
    private static final int CVT_STRUCTURE_BYVAL = 4;
    private static final int CVT_BUFFER = 5;
    private static final int CVT_ARRAY_BYTE = 6;
    private static final int CVT_ARRAY_SHORT = 7;
    private static final int CVT_ARRAY_CHAR = 8;
    private static final int CVT_ARRAY_INT = 9;
    private static final int CVT_ARRAY_LONG = 10;
    private static final int CVT_ARRAY_FLOAT = 11;
    private static final int CVT_ARRAY_DOUBLE = 12;
    private static final int CVT_ARRAY_BOOLEAN = 13;
    private static final int CVT_BOOLEAN = 14;
    private static final int CVT_CALLBACK = 15;
    private static final int CVT_FLOAT = 16;
    private static final int CVT_NATIVE_MAPPED = 17;
    private static final int CVT_NATIVE_MAPPED_STRING = 18;
    private static final int CVT_NATIVE_MAPPED_WSTRING = 19;
    private static final int CVT_WSTRING = 20;
    private static final int CVT_INTEGER_TYPE = 21;
    private static final int CVT_POINTER_TYPE = 22;
    private static final int CVT_TYPE_MAPPER = 23;
    private static final int CVT_TYPE_MAPPER_STRING = 24;
    private static final int CVT_TYPE_MAPPER_WSTRING = 25;
    private static final int CVT_OBJECT = 26;
    private static final int CVT_JNIENV = 27;
    static final int CB_OPTION_DIRECT = 1;
    static final int CB_OPTION_IN_DLL = 2;
    private static final ThreadLocal<Memory> nativeThreadTerminationFlag;
    private static final Map<Thread, Pointer> nativeThreads;

    /*
     * WARNING - void declaration
     */
    static boolean isCompatibleVersion(String expectedVersion, String nativeVersion) {
        void var1_3;
        void var0_1;
        void var3_5;
        void var2_4;
        String[] expectedVersionParts = expectedVersion.split("\\.");
        String[] nativeVersionParts = nativeVersion.split("\\.");
        if (expectedVersionParts.length < 3 || nativeVersionParts.length < 3) {
            return false;
        }
        int expectedMajor = Integer.parseInt(expectedVersionParts[0]);
        int nativeMajor = Integer.parseInt(nativeVersionParts[0]);
        int expectedMinor = Integer.parseInt(expectedVersionParts[1]);
        int nativeMinor = Integer.parseInt(nativeVersionParts[1]);
        if (var2_4 != var3_5) {
            return false;
        }
        return var0_1 <= var1_3;
    }

    private static void dispose() {
        CallbackReference.disposeAll();
        Memory.disposeAll();
        NativeLibrary.disposeAll();
        Native.unregisterAll();
        jnidispatchPath = null;
        System.setProperty("jna.loaded", "false");
    }

    static boolean deleteLibrary(File lib) {
        File file;
        if (lib.delete()) {
            return true;
        }
        Native.markTemporaryFile(file);
        return false;
    }

    private Native() {
    }

    private static native void initIDs();

    public static synchronized native void setProtected(boolean var0);

    public static synchronized native boolean isProtected();

    public static long getWindowID(Window w) throws HeadlessException {
        return AWT.getWindowID(w);
    }

    public static long getComponentID(Component c) throws HeadlessException {
        return AWT.getComponentID(c);
    }

    public static Pointer getWindowPointer(Window w) throws HeadlessException {
        Window window;
        return new Pointer(AWT.getWindowID(window));
    }

    public static Pointer getComponentPointer(Component c) throws HeadlessException {
        Component component;
        return new Pointer(AWT.getComponentID(component));
    }

    static native long getWindowHandle0(Component var0);

    /*
     * WARNING - void declaration
     */
    public static Pointer getDirectBufferPointer(Buffer b) {
        void var1_1;
        long peer = Native._getDirectBufferPointer(b);
        if (peer == 0L) {
            return null;
        }
        return new Pointer((long)var1_1);
    }

    private static native long _getDirectBufferPointer(Buffer var0);

    /*
     * WARNING - void declaration
     */
    private static Charset getCharset(String encoding) {
        void var1_1;
        Charset charset = null;
        if (encoding != null) {
            try {
                charset = Charset.forName(encoding);
            }
            catch (IllegalCharsetNameException e) {
                LOG.log(Level.WARNING, "JNA Warning: Encoding ''{0}'' is unsupported ({1})", new Object[]{encoding, e.getMessage()});
            }
            catch (UnsupportedCharsetException e) {
                void var2_3;
                String string;
                LOG.log(Level.WARNING, "JNA Warning: Encoding ''{0}'' is unsupported ({1})", new Object[]{string, var2_3.getMessage()});
            }
        }
        if (charset == null) {
            LOG.log(Level.WARNING, "JNA Warning: Using fallback encoding {0}", DEFAULT_CHARSET);
            charset = DEFAULT_CHARSET;
        }
        return var1_1;
    }

    public static String toString(byte[] buf) {
        return Native.toString(buf, Native.getDefaultStringEncoding());
    }

    /*
     * WARNING - void declaration
     */
    public static String toString(byte[] buf, String encoding) {
        void var1_1;
        return Native.toString(buf, Native.getCharset((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static String toString(byte[] buf, Charset charset) {
        void var1_1;
        void var2_2;
        byte[] byArray;
        int len = buf.length;
        for (int index = 0; index < len; ++index) {
            if (buf[index] != 0) continue;
            len = index;
            break;
        }
        if (len == 0) {
            return "";
        }
        return new String(byArray, 0, (int)var2_2, (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String toString(char[] buf) {
        void var1_1;
        char[] cArray;
        int len = buf.length;
        for (int index = 0; index < len; ++index) {
            if (buf[index] != '\u0000') continue;
            len = index;
            break;
        }
        if (len == 0) {
            return "";
        }
        return new String(cArray, 0, (int)var1_1);
    }

    public static List<String> toStringList(char[] buf) {
        char[] cArray;
        return Native.toStringList(buf, 0, cArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> toStringList(char[] buf, int offset, int len) {
        void var3_4;
        void var4_5;
        void curPos;
        ArrayList<String> list = new ArrayList<String>();
        int lastPos = offset;
        int maxPos = offset + len;
        while (curPos < maxPos) {
            if (buf[curPos] == '\u0000') {
                if (lastPos == curPos) {
                    return list;
                }
                String value = new String(buf, lastPos, (int)(curPos - lastPos));
                list.add(value);
                var4_5 = curPos + true;
            }
            ++curPos;
        }
        if (var4_5 < maxPos) {
            void var1_2;
            void var2_3;
            char[] cArray;
            String value = new String(cArray, (int)var4_5, (int)(var2_3 - var4_5));
            list.add((String)var1_2);
        }
        return var3_4;
    }

    public static <T extends Library> T load(Class<T> interfaceClass) {
        Class<T> clazz;
        return Native.load(null, clazz);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Library> T load(Class<T> interfaceClass, Map<String, ?> options) {
        void var1_1;
        Class<T> clazz;
        return Native.load(null, clazz, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Library> T load(String name, Class<T> interfaceClass) {
        void var1_1;
        return Native.load(name, var1_1, Collections.emptyMap());
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Library> T load(String name, Class<T> interfaceClass, Map<String, ?> options) {
        Library.Handler handler;
        void var1_1;
        void var2_2;
        if (!Library.class.isAssignableFrom(interfaceClass)) {
            throw new IllegalArgumentException("Interface (" + interfaceClass.getSimpleName() + ") of library=" + name + " does not extend " + Library.class.getSimpleName());
        }
        Library.Handler handler2 = new Library.Handler(name, interfaceClass, options);
        ClassLoader classLoader = interfaceClass.getClassLoader();
        Library.Handler proxy = Proxy.newProxyInstance(classLoader, new Class[]{interfaceClass}, (InvocationHandler)handler2);
        Native.cacheOptions(interfaceClass, var2_2, proxy);
        return (T)((Library)var1_1.cast(handler));
    }

    @Deprecated
    public static <T> T loadLibrary(Class<T> interfaceClass) {
        Class<T> clazz;
        return Native.loadLibrary(null, clazz);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static <T> T loadLibrary(Class<T> interfaceClass, Map<String, ?> options) {
        void var1_1;
        Class<T> clazz;
        return Native.loadLibrary(null, clazz, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static <T> T loadLibrary(String name, Class<T> interfaceClass) {
        void var1_1;
        return Native.loadLibrary(name, var1_1, Collections.emptyMap());
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static <T> T loadLibrary(String name, Class<T> interfaceClass, Map<String, ?> options) {
        Library.Handler handler;
        void var1_1;
        void var2_2;
        if (!Library.class.isAssignableFrom(interfaceClass)) {
            throw new IllegalArgumentException("Interface (" + interfaceClass.getSimpleName() + ") of library=" + name + " does not extend " + Library.class.getSimpleName());
        }
        Library.Handler handler2 = new Library.Handler(name, interfaceClass, options);
        ClassLoader classLoader = interfaceClass.getClassLoader();
        Library.Handler proxy = Proxy.newProxyInstance(classLoader, new Class[]{interfaceClass}, (InvocationHandler)handler2);
        Native.cacheOptions(interfaceClass, var2_2, proxy);
        return var1_1.cast(handler);
    }

    /*
     * WARNING - void declaration
     */
    private static void loadLibraryInstance(Class<?> cls) {
        if (cls != null && !libraries.containsKey(cls)) {
            try {
                void var3_4;
                Field field;
                block5: {
                    Field[] fields = cls.getFields();
                    for (int i = 0; i < fields.length; ++i) {
                        field = fields[i];
                        if (field.getType() != cls || !Modifier.isStatic(field.getModifiers())) {
                            continue;
                        }
                        break block5;
                    }
                    return;
                }
                field.setAccessible(true);
                libraries.put(cls, new WeakReference<Object>(var3_4.get(null)));
            }
            catch (Exception e) {
                void var1_2;
                Class<?> clazz;
                throw new IllegalArgumentException("Could not access instance of " + clazz + " (" + var1_2 + ")");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    static Class<?> findEnclosingLibraryClass(Class<?> cls) {
        while (cls != null) {
            Class<?> fromDeclaring;
            Class<?> enclosingClass;
            Map<String, Object> libOptions = typeOptions.get(cls);
            if (libOptions != null) {
                enclosingClass = (Class<?>)libOptions.get(_OPTION_ENCLOSING_LIBRARY);
                if (enclosingClass != null) {
                    return enclosingClass;
                }
                return cls;
            }
            if (Library.class.isAssignableFrom(cls)) {
                return cls;
            }
            if (Callback.class.isAssignableFrom(cls)) {
                cls = CallbackReference.findCallbackClass(cls);
            }
            if ((fromDeclaring = Native.findEnclosingLibraryClass(enclosingClass = cls.getDeclaringClass())) != null) {
                void var1_1;
                return var1_1;
            }
            cls = cls.getSuperclass();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, Object> getLibraryOptions(Class<?> type) {
        void var2_3;
        HashMap<String, Object> hashMap;
        Object field;
        Map<String, Object> libraryOptions = typeOptions.get(type);
        if (libraryOptions != null) {
            return libraryOptions;
        }
        Class<?> mappingClass = Native.findEnclosingLibraryClass(type);
        if (mappingClass != null) {
            Native.loadLibraryInstance(mappingClass);
        } else {
            mappingClass = type;
        }
        libraryOptions = typeOptions.get(mappingClass);
        if (libraryOptions != null) {
            typeOptions.put(type, libraryOptions);
            return libraryOptions;
        }
        try {
            field = mappingClass.getField("OPTIONS");
            ((Field)field).setAccessible(true);
            field = (Map)((Field)field).get(null);
            if (field == null) {
                throw new IllegalStateException("Null options field");
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            field = Collections.emptyMap();
        }
        catch (Exception e) {
            void var1_2;
            throw new IllegalArgumentException("OPTIONS must be a public field of type java.util.Map (" + var1_2 + "): " + mappingClass);
        }
        hashMap = new HashMap<String, Object>(hashMap);
        if (!hashMap.containsKey("type-mapper")) {
            hashMap.put("type-mapper", Native.lookupField(mappingClass, "TYPE_MAPPER", TypeMapper.class));
        }
        if (!hashMap.containsKey("structure-alignment")) {
            hashMap.put("structure-alignment", Native.lookupField(mappingClass, "STRUCTURE_ALIGNMENT", Integer.class));
        }
        if (!hashMap.containsKey("string-encoding")) {
            hashMap.put("string-encoding", Native.lookupField(mappingClass, "STRING_ENCODING", String.class));
        }
        hashMap = Native.cacheOptions(mappingClass, hashMap, null);
        if (type != var2_3) {
            Class<?> clazz;
            typeOptions.put(clazz, hashMap);
        }
        return hashMap;
    }

    /*
     * WARNING - void declaration
     */
    private static Object lookupField(Class<?> mappingClass, String fieldName, Class<?> resultClass) {
        try {
            Field field = mappingClass.getField(fieldName);
            field.setAccessible(true);
            return field.get(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
        catch (Exception e) {
            Class<?> clazz;
            void var3_4;
            void var2_2;
            void var1_1;
            throw new IllegalArgumentException((String)var1_1 + " must be a public field of type " + var2_2.getName() + " (" + var3_4 + "): " + clazz);
        }
    }

    public static TypeMapper getTypeMapper(Class<?> cls) {
        Map<String, Object> map = Native.getLibraryOptions(cls);
        return (TypeMapper)map.get("type-mapper");
    }

    public static String getStringEncoding(Class<?> cls) {
        String encoding = (String)(cls = Native.getLibraryOptions(cls)).get("string-encoding");
        if (encoding != null) {
            String string;
            return string;
        }
        return Native.getDefaultStringEncoding();
    }

    public static String getDefaultStringEncoding() {
        return System.getProperty("jna.encoding", DEFAULT_ENCODING);
    }

    public static int getStructureAlignment(Class<?> cls) {
        Constable constable;
        Constable alignment = (Integer)Native.getLibraryOptions(cls).get("structure-alignment");
        if (alignment == null) {
            return 0;
        }
        return (Integer)constable;
    }

    static byte[] getBytes(String s) {
        return Native.getBytes(s, Native.getDefaultStringEncoding());
    }

    /*
     * WARNING - void declaration
     */
    static byte[] getBytes(String s, String encoding) {
        void var1_1;
        return Native.getBytes(s, Native.getCharset((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    static byte[] getBytes(String s, Charset charset) {
        void var1_1;
        return s.getBytes((Charset)var1_1);
    }

    public static byte[] toByteArray(String s) {
        return Native.toByteArray(s, Native.getDefaultStringEncoding());
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] toByteArray(String s, String encoding) {
        void var1_1;
        return Native.toByteArray(s, Native.getCharset((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] toByteArray(String s, Charset charset) {
        void var1_1;
        Object object;
        byte[] byArray = Native.getBytes(s, charset);
        Object bytes = byArray;
        byte[] buf = new byte[byArray.length + 1];
        System.arraycopy(bytes, 0, buf, 0, ((Object)object).length);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static char[] toCharArray(String s) {
        void var1_1;
        Object object;
        char[] cArray = s.toCharArray();
        Object chars = cArray;
        char[] buf = new char[cArray.length + 1];
        System.arraycopy(chars, 0, buf, 0, ((Object)object).length);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static void loadNativeDispatchLibrary() {
        String string;
        if (!Boolean.getBoolean("jna.nounpack")) {
            try {
                Native.removeTemporaryFiles();
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "JNA Warning: IOException removing temporary files", e);
            }
        }
        String libName = System.getProperty("jna.boot.library.name", "jnidispatch");
        String bootPath = System.getProperty("jna.boot.library.path");
        if (bootPath != null) {
            StringTokenizer dirs = new StringTokenizer(bootPath, File.pathSeparator);
            while (dirs.hasMoreTokens()) {
                String ext;
                String orig;
                String dir = dirs.nextToken();
                File file = new File(new File(dir), System.mapLibraryName(libName).replace(".dylib", ".jnilib"));
                String path = file.getAbsolutePath();
                LOG.log(DEBUG_JNA_LOAD_LEVEL, "Looking in {0}", path);
                if (file.exists()) {
                    try {
                        LOG.log(DEBUG_JNA_LOAD_LEVEL, "Trying {0}", path);
                        System.setProperty("jnidispatch.path", path);
                        System.load(path);
                        jnidispatchPath = path;
                        LOG.log(DEBUG_JNA_LOAD_LEVEL, "Found jnidispatch at {0}", path);
                        return;
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
                }
                if (!Platform.isMac()) continue;
                if (path.endsWith("dylib")) {
                    orig = "dylib";
                    ext = "jnilib";
                } else {
                    orig = "jnilib";
                    ext = "dylib";
                }
                path = path.substring(0, path.lastIndexOf(orig)) + ext;
                LOG.log(DEBUG_JNA_LOAD_LEVEL, "Looking in {0}", path);
                if (!new File(path).exists()) continue;
                try {
                    LOG.log(DEBUG_JNA_LOAD_LEVEL, "Trying {0}", path);
                    System.setProperty("jnidispatch.path", path);
                    System.load(path);
                    jnidispatchPath = path;
                    LOG.log(DEBUG_JNA_LOAD_LEVEL, "Found jnidispatch at {0}", path);
                    return;
                }
                catch (UnsatisfiedLinkError ex) {
                    void var2_4;
                    void var3_5;
                    LOG.log(Level.WARNING, "File found at " + (String)var3_5 + " but not loadable: " + ex.getMessage(), (Throwable)var2_4);
                }
            }
        }
        if (!Boolean.parseBoolean(string = System.getProperty("jna.nosys", "true")) || Platform.isAndroid()) {
            try {
                void var0_1;
                LOG.log(DEBUG_JNA_LOAD_LEVEL, "Trying (via loadLibrary) {0}", libName);
                System.loadLibrary((String)var0_1);
                LOG.log(DEBUG_JNA_LOAD_LEVEL, "Found jnidispatch on system path");
                return;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
        }
        if (!Boolean.getBoolean("jna.noclasspath")) {
            Native.loadNativeDispatchLibraryFromClasspath();
            return;
        }
        throw new UnsatisfiedLinkError("Unable to locate JNA native support library");
    }

    /*
     * WARNING - void declaration
     */
    private static void loadNativeDispatchLibraryFromClasspath() {
        try {
            File lib;
            String mappedName = System.mapLibraryName("jnidispatch").replace(".dylib", ".jnilib");
            if (Platform.isAIX()) {
                mappedName = "libjnidispatch.a";
            }
            if ((lib = Native.extractFromResourcePath(mappedName = "/com/sun/jna/" + Platform.RESOURCE_PREFIX + "/" + mappedName, Native.class.getClassLoader())) == null && lib == null) {
                throw new UnsatisfiedLinkError("Could not find JNA native support");
            }
            LOG.log(DEBUG_JNA_LOAD_LEVEL, "Trying {0}", lib.getAbsolutePath());
            System.setProperty("jnidispatch.path", lib.getAbsolutePath());
            System.load(lib.getAbsolutePath());
            jnidispatchPath = lib.getAbsolutePath();
            LOG.log(DEBUG_JNA_LOAD_LEVEL, "Found jnidispatch at {0}", jnidispatchPath);
            if (Native.isUnpacked(lib) && !Boolean.getBoolean("jnidispatch.preserve")) {
                Native.deleteLibrary(lib);
            }
            return;
        }
        catch (IOException e) {
            void var0_1;
            throw new UnsatisfiedLinkError(var0_1.getMessage());
        }
    }

    static boolean isUnpacked(File file) {
        return file.getName().startsWith(JNA_TMPLIB_PREFIX);
    }

    public static File extractFromResourcePath(String name) throws IOException {
        return Native.extractFromResourcePath(name, null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File extractFromResourcePath(String name, ClassLoader loader) throws IOException {
        void var3_5;
        URL url;
        Level DEBUG;
        Level level = DEBUG = DEBUG_LOAD || DEBUG_JNA_LOAD && name.contains("jnidispatch") ? Level.INFO : Level.FINE;
        if (loader == null && (loader = Thread.currentThread().getContextClassLoader()) == null) {
            loader = Native.class.getClassLoader();
        }
        LOG.log(DEBUG, "Looking in classpath from {0} for {1}", new Object[]{loader, name});
        String libname = name.startsWith("/") ? name : NativeLibrary.mapSharedLibraryName(name);
        String resourcePath = name.startsWith("/") ? name : Platform.RESOURCE_PREFIX + "/" + libname;
        if (resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        if ((url = loader.getResource(resourcePath)) == null) {
            if (resourcePath.startsWith(Platform.RESOURCE_PREFIX)) {
                if (Platform.RESOURCE_PREFIX.startsWith("darwin")) {
                    url = loader.getResource("darwin/" + resourcePath.substring(Platform.RESOURCE_PREFIX.length() + 1));
                }
                if (url == null) {
                    url = loader.getResource(libname);
                }
            } else if (resourcePath.startsWith("com/sun/jna/" + Platform.RESOURCE_PREFIX + "/")) {
                if (Platform.RESOURCE_PREFIX.startsWith("com/sun/jna/darwin")) {
                    url = loader.getResource("com/sun/jna/darwin" + resourcePath.substring(("com/sun/jna/" + Platform.RESOURCE_PREFIX).length() + 1));
                }
                if (url == null) {
                    url = loader.getResource(libname);
                }
            }
        }
        if (url == null) {
            String path = System.getProperty("java.class.path");
            if (!(loader instanceof URLClassLoader)) throw new IOException("Native library (" + resourcePath + ") not found in resource path (" + path + ")");
            path = Arrays.asList(((URLClassLoader)loader).getURLs()).toString();
            throw new IOException("Native library (" + resourcePath + ") not found in resource path (" + path + ")");
        }
        LOG.log(DEBUG, "Found library resource at {0}", url);
        File lib = null;
        if (url.getProtocol().toLowerCase().equals("file")) {
            try {
                lib = new File(new URI(url.toString()));
            }
            catch (URISyntaxException uRISyntaxException) {
                lib = new File(url.getPath());
            }
            LOG.log(DEBUG, "Looking in {0}", lib.getAbsolutePath());
            if (lib.exists()) return var3_5;
            throw new IOException("File URL " + url + " could not be properly decoded");
        }
        if (Boolean.getBoolean("jna.nounpack")) return var3_5;
        InputStream is = url.openStream();
        if (is == null) {
            throw new IOException("Can't obtain InputStream for " + resourcePath);
        }
        FileOutputStream fos = null;
        try {
            int count;
            File dir = Native.getTempDir();
            dir = File.createTempFile(JNA_TMPLIB_PREFIX, Platform.isWindows() ? ".dll" : null, dir);
            if (!Boolean.getBoolean("jnidispatch.preserve")) {
                dir.deleteOnExit();
            }
            LOG.log(DEBUG, "Extracting library to {0}", dir.getAbsolutePath());
            fos = new FileOutputStream(dir);
            byte[] buf = new byte[1024];
            while ((count = is.read(buf, 0, 1024)) > 0) {
                void var2_4;
                fos.write(buf, 0, (int)var2_4);
            }
        }
        catch (IOException e) {
            try {
                void var3_6;
                String string;
                throw new IOException("Failed to create temporary file for " + string + " library: " + var3_6.getMessage());
            }
            catch (Throwable throwable) {
                try {
                    void var1_2;
                    var1_2.close();
                }
                catch (IOException iOException) {}
                if (fos == null) throw throwable;
                try {
                    fos.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            is.close();
        }
        catch (IOException iOException) {}
        try {
            fos.close();
            return var3_5;
        }
        catch (IOException iOException) {
            return var3_5;
        }
    }

    private static native int sizeof(int var0);

    private static native String getNativeVersion();

    private static native String getAPIChecksum();

    public static native int getLastError();

    public static native void setLastError(int var0);

    /*
     * WARNING - void declaration
     */
    public static Library synchronizedLibrary(Library library) {
        InvocationHandler invocationHandler;
        void var1_1;
        void var2_2;
        Class<?> cls = library.getClass();
        if (!Proxy.isProxyClass(cls)) {
            throw new IllegalArgumentException("Library must be a proxy class");
        }
        InvocationHandler ih = Proxy.getInvocationHandler(library);
        if (!(ih instanceof Library.Handler)) {
            throw new IllegalArgumentException("Unrecognized proxy handler: " + ih);
        }
        Library.Handler handler = (Library.Handler)ih;
        InvocationHandler newHandler = new InvocationHandler((Library.Handler)var2_2, library){
            final /* synthetic */ Library.Handler val$handler;
            final /* synthetic */ Library val$library;
            {
                this.val$handler = handler;
                this.val$library = library;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                NativeLibrary nativeLibrary = this.val$handler.getNativeLibrary();
                synchronized (nativeLibrary) {
                    void var3_4;
                    void var2_2;
                    return this.val$handler.invoke(this.val$library, (Method)var2_2, (Object[])var3_4);
                }
            }
        };
        return (Library)Proxy.newProxyInstance(cls.getClassLoader(), var1_1.getInterfaces(), invocationHandler);
    }

    /*
     * WARNING - void declaration
     */
    public static String getWebStartLibraryPath(String libName) {
        if (System.getProperty("javawebstart.version") == null) {
            return null;
        }
        try {
            void var1_1;
            ClassLoader cl = Native.class.getClassLoader();
            Method method = AccessController.doPrivileged(new PrivilegedAction<Method>(){

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final Method run() {
                    try {
                        void var1_1;
                        Method m = ClassLoader.class.getDeclaredMethod("findLibrary", String.class);
                        m.setAccessible(true);
                        return var1_1;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            });
            String libpath = (String)method.invoke((Object)var1_1, libName);
            if (libpath != null) {
                String string;
                return new File(string).getParent();
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static void markTemporaryFile(File file) {
        Serializable serializable;
        try {
            serializable = new File(file.getParentFile(), ((File)serializable).getName() + ".x");
            ((File)serializable).createNewFile();
            return;
        }
        catch (IOException iOException) {
            serializable = iOException;
            iOException.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    static File getTempDir() throws IOException {
        void var0;
        File jnatmp;
        String prop = System.getProperty("jna.tmpdir");
        if (prop != null) {
            jnatmp = new File(prop);
            jnatmp.mkdirs();
        } else {
            File tmp = new File(System.getProperty("java.io.tmpdir"));
            if (Platform.isMac()) {
                jnatmp = new File(System.getProperty("user.home"), "Library/Caches/JNA/temp");
            } else if (Platform.isLinux() || Platform.isSolaris() || Platform.isAIX() || Platform.isFreeBSD() || Platform.isNetBSD() || Platform.isOpenBSD() || Platform.iskFreeBSD()) {
                File xdgCacheFile;
                String xdgCacheEnvironment = System.getenv("XDG_CACHE_HOME");
                xdgCacheFile = xdgCacheEnvironment == null || xdgCacheEnvironment.trim().isEmpty() ? new File(System.getProperty("user.home"), ".cache") : new File((String)((Object)xdgCacheFile));
                jnatmp = new File(xdgCacheFile, "JNA/temp");
            } else {
                jnatmp = new File(tmp, "jna-" + System.getProperty("user.name").hashCode());
            }
            jnatmp.mkdirs();
            if (!jnatmp.exists() || !jnatmp.canWrite()) {
                void var1_1;
                jnatmp = var1_1;
            }
        }
        if (!jnatmp.exists()) {
            throw new IOException("JNA temporary directory '" + jnatmp + "' does not exist");
        }
        if (!jnatmp.canWrite()) {
            throw new IOException("JNA temporary directory '" + jnatmp + "' is not writable");
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    static void removeTemporaryFiles() throws IOException {
        File dir = Native.getTempDir();
        FilenameFilter filter = new FilenameFilter(){

            /*
             * WARNING - void declaration
             */
            @Override
            public final boolean accept(File dir, String name) {
                void var2_2;
                return name.endsWith(".x") && var2_2.startsWith(Native.JNA_TMPLIB_PREFIX);
            }
        };
        File[] files = dir.listFiles(filter);
        for (int i = 0; files != null && i < files.length; ++i) {
            void var2_3;
            void var3_4;
            File marker = files[i];
            String name = marker.getName();
            name = name.substring(0, name.length() - 2);
            File target = new File(marker.getParentFile(), name);
            if (target.exists() && !var3_4.delete()) continue;
            var2_3.delete();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static int getNativeSize(Class<?> type, Object value) {
        void var1_1;
        if (type.isArray()) {
            int len = Array.getLength(value);
            if (len > 0) {
                Object o = Array.get(value, 0);
                return len * Native.getNativeSize(type.getComponentType(), var1_1);
            }
            throw new IllegalArgumentException("Arrays of length zero not allowed: " + type);
        }
        if (Structure.class.isAssignableFrom(type) && !Structure.ByReference.class.isAssignableFrom(type)) {
            return Structure.size(type, (Structure)var1_1);
        }
        try {
            return Native.getNativeSize(type);
        }
        catch (IllegalArgumentException e) {
            void var2_3;
            Class<?> clazz;
            throw new IllegalArgumentException("The type \"" + clazz.getName() + "\" is not supported: " + var2_3.getMessage());
        }
    }

    public static int getNativeSize(Class<?> cls) {
        Class<?> clazz;
        if (NativeMapped.class.isAssignableFrom(cls)) {
            cls = NativeMappedConverter.getInstance(cls).nativeType();
        }
        if (cls == Boolean.TYPE || cls == Boolean.class) {
            return 4;
        }
        if (cls == Byte.TYPE || cls == Byte.class) {
            return 1;
        }
        if (cls == Short.TYPE || cls == Short.class) {
            return 2;
        }
        if (cls == Character.TYPE || cls == Character.class) {
            return WCHAR_SIZE;
        }
        if (cls == Integer.TYPE || cls == Integer.class) {
            return 4;
        }
        if (cls == Long.TYPE || cls == Long.class) {
            return 8;
        }
        if (cls == Float.TYPE || cls == Float.class) {
            return 4;
        }
        if (cls == Double.TYPE || cls == Double.class) {
            return 8;
        }
        if (Structure.class.isAssignableFrom(cls)) {
            if (Structure.ByValue.class.isAssignableFrom(cls)) {
                return Structure.size(cls);
            }
            return POINTER_SIZE;
        }
        if (Pointer.class.isAssignableFrom(cls) || Platform.HAS_BUFFERS && Buffers.isBuffer(cls) || Callback.class.isAssignableFrom(cls) || String.class == cls || WString.class == cls) {
            return POINTER_SIZE;
        }
        throw new IllegalArgumentException("Native size for type \"" + clazz.getName() + "\" is unknown");
    }

    public static boolean isSupportedNativeType(Class<?> cls) {
        if (Structure.class.isAssignableFrom(cls)) {
            return true;
        }
        try {
            Class<?> clazz;
            return Native.getNativeSize(clazz) != 0;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static void setCallbackExceptionHandler(Callback.UncaughtExceptionHandler eh) {
        Callback.UncaughtExceptionHandler uncaughtExceptionHandler;
        callbackExceptionHandler = eh == null ? DEFAULT_HANDLER : uncaughtExceptionHandler;
    }

    public static Callback.UncaughtExceptionHandler getCallbackExceptionHandler() {
        return callbackExceptionHandler;
    }

    public static void register(String libName) {
        String string;
        Native.register(Native.findDirectMappedClass(Native.getCallingClass()), string);
    }

    public static void register(NativeLibrary lib) {
        NativeLibrary nativeLibrary;
        Native.register(Native.findDirectMappedClass(Native.getCallingClass()), nativeLibrary);
    }

    /*
     * WARNING - void declaration
     */
    static Class<?> findDirectMappedClass(Class<?> cls) {
        Class<?> clazz;
        Method[] methodArray = cls.getDeclaredMethods();
        Method[] methodArray2 = methodArray;
        methodArray2 = methodArray;
        int n = methodArray.length;
        for (int i = 0; i < n; ++i) {
            Method method = methodArray2[i];
            if ((method.getModifiers() & 0x100) == 0) continue;
            return cls;
        }
        int idx = cls.getName().lastIndexOf("$");
        if (idx != -1) {
            void var1_2;
            String name = cls.getName().substring(0, (int)var1_2);
            try {
                void var2_4;
                return Native.findDirectMappedClass(Class.forName((String)var2_4, true, cls.getClassLoader()));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        throw new IllegalArgumentException("Can't determine class with native methods from the current context (" + clazz + ")");
    }

    /*
     * WARNING - void declaration
     */
    static Class<?> getCallingClass() {
        void var0;
        Class<?>[] context = new SecurityManager(){

            @Override
            public final Class<?>[] getClassContext() {
                return super.getClassContext();
            }
        }.getClassContext();
        if (context == null) {
            throw new IllegalStateException("The SecurityManager implementation on this platform is broken; you must explicitly provide the class to register");
        }
        if (context.length < 4) {
            throw new IllegalStateException("This method must be called from the static initializer of a class");
        }
        return var0[3];
    }

    /*
     * WARNING - void declaration
     */
    public static void setCallbackThreadInitializer(Callback cb, CallbackThreadInitializer initializer) {
        void var1_1;
        CallbackReference.setCallbackThreadInitializer(cb, (CallbackThreadInitializer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static void unregisterAll() {
        Map<Class<?>, long[]> map = registeredClasses;
        synchronized (map) {
            for (Map.Entry<Class<?>, long[]> e : registeredClasses.entrySet()) {
                void var2_3;
                Native.unregister(e.getKey(), (long[])var2_3.getValue());
            }
            registeredClasses.clear();
            return;
        }
    }

    public static void unregister() {
        Native.unregister(Native.findDirectMappedClass(Native.getCallingClass()));
    }

    /*
     * WARNING - void declaration
     */
    public static void unregister(Class<?> cls) {
        Map<Class<?>, long[]> map = registeredClasses;
        synchronized (map) {
            long[] handles = registeredClasses.get(cls);
            if (handles != null) {
                Class<?> clazz;
                void var2_3;
                Native.unregister(cls, (long[])var2_3);
                registeredClasses.remove(cls);
                registeredLibraries.remove(clazz);
            }
            return;
        }
    }

    public static boolean registered(Class<?> cls) {
        Map<Class<?>, long[]> map = registeredClasses;
        synchronized (map) {
            Class<?> clazz;
            return registeredClasses.containsKey(clazz);
        }
    }

    private static native void unregister(Class<?> var0, long[] var1);

    static String getSignature(Class<?> cls) {
        Class<?> clazz;
        if (cls.isArray()) {
            return "[" + Native.getSignature(cls.getComponentType());
        }
        if (cls.isPrimitive()) {
            if (cls == Void.TYPE) {
                return "V";
            }
            if (cls == Boolean.TYPE) {
                return "Z";
            }
            if (cls == Byte.TYPE) {
                return "B";
            }
            if (cls == Short.TYPE) {
                return "S";
            }
            if (cls == Character.TYPE) {
                return "C";
            }
            if (cls == Integer.TYPE) {
                return "I";
            }
            if (cls == Long.TYPE) {
                return "J";
            }
            if (cls == Float.TYPE) {
                return "F";
            }
            if (cls == Double.TYPE) {
                return "D";
            }
        }
        return "L" + Native.replace(".", "/", clazz.getName()) + ";";
    }

    /*
     * WARNING - void declaration
     */
    static String replace(String s1, String s2, String str) {
        void var3_3;
        StringBuilder buf = new StringBuilder();
        while (true) {
            int idx;
            if ((idx = str.indexOf(s1)) == -1) break;
            buf.append(str.substring(0, idx));
            buf.append(s2);
            str = str.substring(idx + s1.length());
        }
        buf.append(str);
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static int getConversion(Class<?> type, TypeMapper mapper, boolean allowObjects) {
        void var2_2;
        Class<?> clazz;
        if (type == Void.class) {
            type = Void.TYPE;
        }
        if (mapper != null) {
            Class<?> nativeType;
            FromNativeConverter fromNative = mapper.getFromNativeConverter(type);
            ToNativeConverter toNative = mapper.getToNativeConverter(type);
            if (fromNative != null) {
                nativeType = fromNative.nativeType();
                if (nativeType == String.class) {
                    return 24;
                }
                if (nativeType == WString.class) {
                    return 25;
                }
                return 23;
            }
            if (toNative != null) {
                void var1_1;
                nativeType = var1_1.nativeType();
                if (nativeType == String.class) {
                    return 24;
                }
                if (clazz == WString.class) {
                    return 25;
                }
                return 23;
            }
        }
        if (Pointer.class.isAssignableFrom(clazz)) {
            return 1;
        }
        if (String.class == clazz) {
            return 2;
        }
        if (WString.class.isAssignableFrom(clazz)) {
            return 20;
        }
        if (Platform.HAS_BUFFERS && Buffers.isBuffer(clazz)) {
            return 5;
        }
        if (Structure.class.isAssignableFrom(clazz)) {
            if (Structure.ByValue.class.isAssignableFrom(clazz)) {
                return 4;
            }
            return 3;
        }
        if (clazz.isArray()) {
            switch (clazz.getName().charAt(1)) {
                case 'Z': {
                    return 13;
                }
                case 'B': {
                    return 6;
                }
                case 'S': {
                    return 7;
                }
                case 'C': {
                    return 8;
                }
                case 'I': {
                    return 9;
                }
                case 'J': {
                    return 10;
                }
                case 'F': {
                    return 11;
                }
                case 'D': {
                    return 12;
                }
            }
        }
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return 14;
            }
            return 0;
        }
        if (Callback.class.isAssignableFrom(clazz)) {
            return 15;
        }
        if (IntegerType.class.isAssignableFrom(clazz)) {
            return 21;
        }
        if (PointerType.class.isAssignableFrom(clazz)) {
            return 22;
        }
        if (NativeMapped.class.isAssignableFrom(clazz)) {
            void var3_3;
            Class<?> nativeType = NativeMappedConverter.getInstance(clazz).nativeType();
            if (nativeType == String.class) {
                return 18;
            }
            if (var3_3 == WString.class) {
                return 19;
            }
            return 17;
        }
        if (JNIEnv.class == clazz) {
            return 27;
        }
        if (var2_2 != false) {
            return 26;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static void register(Class<?> cls, String libName) {
        void var1_1;
        Class<?> clazz;
        NativeLibrary library = NativeLibrary.getInstance(libName, Collections.singletonMap("classloader", cls.getClassLoader()));
        Native.register(clazz, (NativeLibrary)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void register(Class<?> cls, NativeLibrary lib) {
        Method[] methods = cls.getDeclaredMethods();
        ArrayList<Method> mlist = new ArrayList<Method>();
        Map<String, ?> options = lib.getOptions();
        TypeMapper mapper = (TypeMapper)options.get("type-mapper");
        boolean allowObjects = Boolean.TRUE.equals(options.get("allow-objects"));
        Native.cacheOptions(cls, options, null);
        for (Method m : methods) {
            if ((m.getModifiers() & 0x100) == 0) continue;
            mlist.add(m);
        }
        long[] handles = new long[mlist.size()];
        for (int i = 0; i < handles.length; ++i) {
            long rtype;
            long closure_rtype;
            Method method = (Method)mlist.get(i);
            String sig = "(";
            Class<?> rclass = method.getReturnType();
            Class<?>[] ptypes = method.getParameterTypes();
            long[] atypes = new long[ptypes.length];
            long[] closure_atypes = new long[ptypes.length];
            int[] cvt = new int[ptypes.length];
            ToNativeConverter[] toNative = new ToNativeConverter[ptypes.length];
            FromNativeConverter fromNative = null;
            int rcvt = Native.getConversion(rclass, mapper, allowObjects);
            boolean throwLastError = false;
            switch (rcvt) {
                case -1: {
                    throw new IllegalArgumentException(rclass + " is not a supported return type (in method " + method.getName() + " in " + cls + ")");
                }
                case 23: 
                case 24: 
                case 25: {
                    fromNative = mapper.getFromNativeConverter(rclass);
                    closure_rtype = Structure.FFIType.get(rclass.isPrimitive() ? rclass : Pointer.class).getPointer().peer;
                    rtype = Structure.FFIType.get(fromNative.nativeType()).getPointer().peer;
                    break;
                }
                case 17: 
                case 18: 
                case 19: 
                case 21: 
                case 22: {
                    closure_rtype = Structure.FFIType.get(Pointer.class).getPointer().peer;
                    rtype = Structure.FFIType.get(NativeMappedConverter.getInstance(rclass).nativeType()).getPointer().peer;
                    break;
                }
                case 3: 
                case 26: {
                    closure_rtype = rtype = Structure.FFIType.get(Pointer.class).getPointer().peer;
                    break;
                }
                case 4: {
                    closure_rtype = Structure.FFIType.get(Pointer.class).getPointer().peer;
                    rtype = Structure.FFIType.get(rclass).getPointer().peer;
                    break;
                }
                default: {
                    closure_rtype = rtype = Structure.FFIType.get(rclass).getPointer().peer;
                }
            }
            block19: for (int t = 0; t < ptypes.length; ++t) {
                int conversionType;
                Class<?> type = ptypes[t];
                sig = sig + Native.getSignature(type);
                cvt[t] = conversionType = Native.getConversion(type, mapper, allowObjects);
                if (conversionType == -1) {
                    throw new IllegalArgumentException(type + " is not a supported argument type (in method " + method.getName() + " in " + cls + ")");
                }
                if (conversionType == 17 || conversionType == 18 || conversionType == 19 || conversionType == 21) {
                    type = NativeMappedConverter.getInstance(type).nativeType();
                } else if (conversionType == 23 || conversionType == 24 || conversionType == 25) {
                    toNative[t] = mapper.getToNativeConverter(type);
                }
                switch (conversionType) {
                    case 4: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 21: 
                    case 22: {
                        atypes[t] = Structure.FFIType.get(type).getPointer().peer;
                        closure_atypes[t] = Structure.FFIType.get(Pointer.class).getPointer().peer;
                        continue block19;
                    }
                    case 23: 
                    case 24: 
                    case 25: {
                        closure_atypes[t] = Structure.FFIType.get(type.isPrimitive() ? type : Pointer.class).getPointer().peer;
                        atypes[t] = Structure.FFIType.get(toNative[t].nativeType()).getPointer().peer;
                        continue block19;
                    }
                    case 0: {
                        closure_atypes[t] = atypes[t] = Structure.FFIType.get(type).getPointer().peer;
                        continue block19;
                    }
                    default: {
                        closure_atypes[t] = atypes[t] = Structure.FFIType.get(Pointer.class).getPointer().peer;
                    }
                }
            }
            sig = sig + ")";
            sig = sig + Native.getSignature(rclass);
            Class<?>[] etypes = method.getExceptionTypes();
            for (int e = 0; e < etypes.length; ++e) {
                if (!LastErrorException.class.isAssignableFrom(etypes[e])) continue;
                throwLastError = true;
                break;
            }
            Function f = lib.getFunction(method.getName(), method);
            try {
                handles[i] = Native.registerMethod(cls, method.getName(), sig, cvt, closure_atypes, atypes, rcvt, closure_rtype, rtype, method, f.peer, f.getCallingConvention(), throwLastError, toNative, fromNative, f.encoding);
                continue;
            }
            catch (NoSuchMethodError noSuchMethodError) {
                throw new UnsatisfiedLinkError("No method " + method.getName() + " with signature " + sig + " in " + cls);
            }
        }
        Map<Class<?>, long[]> map = registeredClasses;
        synchronized (map) {
            void var1_2;
            Class<?> clazz;
            void var2_3;
            registeredClasses.put(cls, (long[])var2_3);
            registeredLibraries.put(clazz, (NativeLibrary)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Map<String, Object> cacheOptions(Class<?> cls, Map<String, ?> options, Object proxy) {
        void var1_1;
        HashMap libOptions = new HashMap(options);
        libOptions.put(_OPTION_ENCLOSING_LIBRARY, cls);
        typeOptions.put(cls, libOptions);
        if (proxy != null) {
            libraries.put(cls, new WeakReference<Object>(proxy));
        }
        if (!cls.isInterface() && Library.class.isAssignableFrom(cls)) {
            Class<?>[] classArray;
            Class<?>[] classArray2 = classArray.getInterfaces();
            classArray = classArray2;
            classArray = classArray2;
            int n = classArray2.length;
            for (int i = 0; i < n; ++i) {
                Class<?> ifc = classArray[i];
                if (!Library.class.isAssignableFrom(ifc)) continue;
                Native.cacheOptions(ifc, libOptions, proxy);
                break;
            }
        }
        return var1_1;
    }

    private static native long registerMethod(Class<?> var0, String var1, String var2, int[] var3, long[] var4, long[] var5, int var6, long var7, long var9, Method var11, long var12, int var14, boolean var15, ToNativeConverter[] var16, FromNativeConverter var17, String var18);

    /*
     * WARNING - void declaration
     */
    private static NativeMapped fromNative(Class<?> cls, Object value) {
        Class<?> clazz;
        void var1_1;
        return (NativeMapped)NativeMappedConverter.getInstance(cls).fromNative(var1_1, new FromNativeContext(clazz));
    }

    /*
     * WARNING - void declaration
     */
    private static NativeMapped fromNative(Method m, Object value) {
        Method method;
        void var2_2;
        void var1_1;
        Class<?> cls = m.getReturnType();
        return (NativeMapped)NativeMappedConverter.getInstance(cls).fromNative(var1_1, new MethodResultContext((Class<?>)var2_2, null, null, method));
    }

    private static Class<?> nativeType(Class<?> cls) {
        return NativeMappedConverter.getInstance(cls).nativeType();
    }

    /*
     * WARNING - void declaration
     */
    private static Object toNative(ToNativeConverter cvt, Object o) {
        void var1_1;
        return cvt.toNative(var1_1, new ToNativeContext());
    }

    /*
     * WARNING - void declaration
     */
    private static Object fromNative(FromNativeConverter cvt, Object o, Method m) {
        void var2_2;
        void var1_1;
        return cvt.fromNative(var1_1, new MethodResultContext(m.getReturnType(), null, null, (Method)var2_2));
    }

    public static native long ffi_prep_cif(int var0, int var1, long var2, long var4);

    public static native void ffi_call(long var0, long var2, long var4, long var6);

    public static native long ffi_prep_closure(long var0, ffi_callback var2);

    public static native void ffi_free_closure(long var0);

    static native int initialize_ffi_type(long var0);

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) {
        void var2_2;
        Package package_;
        void var1_1;
        String version;
        Package pkg = Native.class.getPackage();
        String title = pkg != null ? pkg.getSpecificationTitle() : "Java Native Access (JNA)";
        if (title == null) {
            title = "Java Native Access (JNA)";
        }
        if ((version = pkg != null ? pkg.getSpecificationVersion() : "5.8.0") == null) {
            version = "5.8.0";
        }
        title = title + " API Version " + version;
        System.out.println((String)var1_1);
        version = pkg != null ? package_.getImplementationVersion() : "5.8.0 (package information missing)";
        if (version == null) {
            version = "5.8.0 (package information missing)";
        }
        System.out.println("Version: " + (String)var2_2);
        System.out.println(" Native: " + Native.getNativeVersion() + " (" + Native.getAPIChecksum() + ")");
        System.out.println(" Prefix: " + Platform.RESOURCE_PREFIX);
    }

    static synchronized native void freeNativeCallback(long var0);

    static synchronized native long createNativeCallback(Callback var0, Method var1, Class<?>[] var2, Class<?> var3, int var4, int var5, String var6);

    static native int invokeInt(Function var0, long var1, int var3, Object[] var4);

    static native long invokeLong(Function var0, long var1, int var3, Object[] var4);

    static native void invokeVoid(Function var0, long var1, int var3, Object[] var4);

    static native float invokeFloat(Function var0, long var1, int var3, Object[] var4);

    static native double invokeDouble(Function var0, long var1, int var3, Object[] var4);

    static native long invokePointer(Function var0, long var1, int var3, Object[] var4);

    private static native void invokeStructure(Function var0, long var1, int var3, Object[] var4, long var5, long var7);

    /*
     * WARNING - void declaration
     */
    static Structure invokeStructure(Function function, long fp, int callFlags, Object[] args, Structure s) {
        void var3_2;
        void var1_1;
        Native.invokeStructure(function, (long)var1_1, (int)var3_2, args, s.getPointer().peer, s.getTypeInfo().peer);
        return s;
    }

    static native Object invokeObject(Function var0, long var1, int var3, Object[] var4);

    static long open(String name) {
        return Native.open(name, -1);
    }

    static native long open(String var0, int var1);

    static native void close(long var0);

    static native long findSymbol(long var0, String var2);

    static native long indexOf(Pointer var0, long var1, long var3, byte var5);

    static native void read(Pointer var0, long var1, long var3, byte[] var5, int var6, int var7);

    static native void read(Pointer var0, long var1, long var3, short[] var5, int var6, int var7);

    static native void read(Pointer var0, long var1, long var3, char[] var5, int var6, int var7);

    static native void read(Pointer var0, long var1, long var3, int[] var5, int var6, int var7);

    static native void read(Pointer var0, long var1, long var3, long[] var5, int var6, int var7);

    static native void read(Pointer var0, long var1, long var3, float[] var5, int var6, int var7);

    static native void read(Pointer var0, long var1, long var3, double[] var5, int var6, int var7);

    static native void write(Pointer var0, long var1, long var3, byte[] var5, int var6, int var7);

    static native void write(Pointer var0, long var1, long var3, short[] var5, int var6, int var7);

    static native void write(Pointer var0, long var1, long var3, char[] var5, int var6, int var7);

    static native void write(Pointer var0, long var1, long var3, int[] var5, int var6, int var7);

    static native void write(Pointer var0, long var1, long var3, long[] var5, int var6, int var7);

    static native void write(Pointer var0, long var1, long var3, float[] var5, int var6, int var7);

    static native void write(Pointer var0, long var1, long var3, double[] var5, int var6, int var7);

    static native byte getByte(Pointer var0, long var1, long var3);

    static native char getChar(Pointer var0, long var1, long var3);

    static native short getShort(Pointer var0, long var1, long var3);

    static native int getInt(Pointer var0, long var1, long var3);

    static native long getLong(Pointer var0, long var1, long var3);

    static native float getFloat(Pointer var0, long var1, long var3);

    static native double getDouble(Pointer var0, long var1, long var3);

    /*
     * WARNING - void declaration
     */
    static Pointer getPointer(long addr) {
        void var2_1;
        long peer = Native._getPointer(addr);
        if (peer == 0L) {
            return null;
        }
        return new Pointer((long)var2_1);
    }

    private static native long _getPointer(long var0);

    static native String getWideString(Pointer var0, long var1, long var3);

    /*
     * WARNING - void declaration
     */
    static String getString(Pointer pointer, long offset) {
        void var1_1;
        return Native.getString(pointer, (long)var1_1, Native.getDefaultStringEncoding());
    }

    /*
     * WARNING - void declaration
     */
    static String getString(Pointer pointer, long offset, String encoding) {
        Object object;
        void var1_1;
        Pointer pointer2 = pointer;
        Object data = Native.getStringBytes(pointer2, pointer2.peer, (long)var1_1);
        if (encoding != null) {
            try {
                void var3_2;
                return new String((byte[])data, (String)var3_2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return new String((byte[])object);
    }

    static native byte[] getStringBytes(Pointer var0, long var1, long var3);

    static native void setMemory(Pointer var0, long var1, long var3, long var5, byte var7);

    static native void setByte(Pointer var0, long var1, long var3, byte var5);

    static native void setShort(Pointer var0, long var1, long var3, short var5);

    static native void setChar(Pointer var0, long var1, long var3, char var5);

    static native void setInt(Pointer var0, long var1, long var3, int var5);

    static native void setLong(Pointer var0, long var1, long var3, long var5);

    static native void setFloat(Pointer var0, long var1, long var3, float var5);

    static native void setDouble(Pointer var0, long var1, long var3, double var5);

    static native void setPointer(Pointer var0, long var1, long var3, long var5);

    static native void setWideString(Pointer var0, long var1, long var3, String var5);

    static native ByteBuffer getDirectByteBuffer(Pointer var0, long var1, long var3, long var5);

    public static native long malloc(long var0);

    public static native void free(long var0);

    /*
     * WARNING - void declaration
     */
    public static void detach(boolean detach) {
        Thread thread = Thread.currentThread();
        if (detach) {
            nativeThreads.remove(thread);
            nativeThreadTerminationFlag.get();
            Native.setDetachState(true, 0L);
            return;
        }
        if (!nativeThreads.containsKey(thread)) {
            void var0_1;
            void var1_2;
            Pointer p = nativeThreadTerminationFlag.get();
            nativeThreads.put((Thread)var1_2, p);
            Native.setDetachState(false, var0_1.peer);
        }
    }

    static Pointer getTerminationFlag(Thread t) {
        Thread thread;
        return nativeThreads.get(thread);
    }

    private static native void setDetachState(boolean var0, long var1);

    /*
     * WARNING - void declaration
     */
    static {
        callbackExceptionHandler = DEFAULT_HANDLER = new Callback.UncaughtExceptionHandler(){

            /*
             * WARNING - void declaration
             */
            @Override
            public final void uncaughtException(Callback c, Throwable e) {
                void var2_2;
                void var1_1;
                LOG.log(Level.WARNING, "JNA: Callback " + var1_1 + " threw the following exception", (Throwable)var2_2);
            }
        };
        Native.loadNativeDispatchLibrary();
        if (!Native.isCompatibleVersion("6.1.1", Native.getNativeVersion())) {
            void var0;
            String LS = System.getProperty("line.separator");
            throw new Error(LS + LS + "There is an incompatible JNA native library installed on this system" + LS + "Expected: 6.1.1" + LS + "Found:    " + Native.getNativeVersion() + LS + (jnidispatchPath != null ? "(at " + jnidispatchPath + ")" : System.getProperty("java.library.path")) + "." + LS + "To resolve this issue you may do one of the following:" + LS + " - remove or uninstall the offending library" + LS + " - set the system property jna.nosys=true" + LS + " - set jna.boot.library.path to include the path to the version of the " + LS + "   jnidispatch library included with the JNA jar file you are using" + (String)var0);
        }
        POINTER_SIZE = Native.sizeof(0);
        LONG_SIZE = Native.sizeof(1);
        WCHAR_SIZE = Native.sizeof(2);
        SIZE_T_SIZE = Native.sizeof(3);
        BOOL_SIZE = Native.sizeof(4);
        LONG_DOUBLE_SIZE = Native.sizeof(5);
        Native.initIDs();
        if (Boolean.getBoolean("jna.protected")) {
            Native.setProtected(true);
        }
        MAX_ALIGNMENT = Platform.isSPARC() || Platform.isWindows() || Platform.isLinux() && (Platform.isARM() || Platform.isPPC() || Platform.isMIPS()) || Platform.isAIX() || Platform.isAndroid() && !Platform.isIntel() ? 8 : LONG_SIZE;
        MAX_PADDING = Platform.isMac() && Platform.isPPC() ? 8 : MAX_ALIGNMENT;
        System.setProperty("jna.loaded", "true");
        finalizer = new Object(){

            protected final void finalize() throws Throwable {
                Native.dispose();
                super.finalize();
            }
        };
        registeredClasses = new WeakHashMap();
        registeredLibraries = new WeakHashMap();
        nativeThreadTerminationFlag = new ThreadLocal<Memory>(){

            /*
             * WARNING - void declaration
             */
            @Override
            protected final Memory initialValue() {
                void var1_1;
                Memory m = new Memory(4L);
                m.clear();
                return var1_1;
            }
        };
        nativeThreads = Collections.synchronizedMap(new WeakHashMap());
    }

    private static class AWT {
        private AWT() {
        }

        static long getWindowID(Window w) throws HeadlessException {
            return AWT.getComponentID(w);
        }

        static long getComponentID(Object o) throws HeadlessException {
            Object object;
            if (GraphicsEnvironment.isHeadless()) {
                throw new HeadlessException("No native windows when headless");
            }
            Object c = (Component)o;
            if (((Component)c).isLightweight()) {
                throw new IllegalArgumentException("Component must be heavyweight");
            }
            if (!((Component)c).isDisplayable()) {
                throw new IllegalStateException("Component must be displayable");
            }
            if (Platform.isX11() && System.getProperty("java.version").startsWith("1.4") && !((Component)c).isVisible()) {
                throw new IllegalStateException("Component must be visible");
            }
            return Native.getWindowHandle0((Component)object);
        }
    }

    private static class Buffers {
        private Buffers() {
        }

        static boolean isBuffer(Class<?> cls) {
            Class<?> clazz;
            return Buffer.class.isAssignableFrom(clazz);
        }
    }

    public static interface ffi_callback {
        public void invoke(long var1, long var3, long var5);
    }
}

