/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.WString;

class NativeString
implements CharSequence,
Comparable {
    static final String WIDE_STRING = "--WIDE-STRING--";
    private Pointer pointer;
    private String encoding;

    /*
     * WARNING - void declaration
     */
    public NativeString(String string) {
        this((String)var1_1, Native.getDefaultStringEncoding());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public NativeString(String string, boolean wide) {
        this((String)var1_1, var2_2 != false ? WIDE_STRING : Native.getDefaultStringEncoding());
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public NativeString(WString string) {
        this(var1_1.toString(), WIDE_STRING);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public NativeString(String string, String encoding) {
        void var2_2;
        void len2;
        void var1_1;
        if (string == null) {
            throw new NullPointerException("String must not be null");
        }
        this.encoding = encoding;
        if (WIDE_STRING.equals(this.encoding)) {
            int len2 = (string.length() + 1) * Native.WCHAR_SIZE;
            this.pointer = new StringMemory(len2);
            this.pointer.setWideString(0L, string);
            return;
        }
        byte[] data = Native.getBytes((String)var1_1, (String)len2);
        this.pointer = new StringMemory(data.length + 1);
        this.pointer.write(0L, data, 0, data.length);
        this.pointer.setByte(((void)var2_2).length, (byte)0);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object other) {
        if (other instanceof CharSequence) {
            void var1_1;
            return this.compareTo((Object)var1_1) == 0;
        }
        return false;
    }

    @Override
    public String toString() {
        boolean bl = WIDE_STRING.equals(this.encoding);
        if (bl) {
            return this.pointer.getWideString(0L);
        }
        return this.pointer.getString(0L, this.encoding);
    }

    public Pointer getPointer() {
        return this.pointer;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public char charAt(int index) {
        void var1_1;
        return this.toString().charAt((int)var1_1);
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CharSequence subSequence(int start, int end) {
        void var2_2;
        void var1_1;
        return this.toString().subSequence((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public int compareTo(Object other) {
        void var1_1;
        if (other == null) {
            return 1;
        }
        return this.toString().compareTo(var1_1.toString());
    }

    private class StringMemory
    extends Memory {
        /*
         * WARNING - void declaration
         */
        public StringMemory(long size) {
            void var2_2;
            super((long)var2_2);
        }

        @Override
        public String toString() {
            return NativeString.this.toString();
        }
    }
}

