/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Function;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeString;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StringArray
extends Memory
implements Function.PostCallRead {
    private String encoding;
    private List<NativeString> natives = new ArrayList<NativeString>();
    private Object[] original;

    /*
     * WARNING - void declaration
     */
    public StringArray(String[] strings) {
        this((String[])var1_1, false);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StringArray(String[] strings, boolean wide) {
        this((Object[])var1_1, var2_2 != false ? "--WIDE-STRING--" : Native.getDefaultStringEncoding());
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StringArray(String[] strings, String encoding) {
        this((Object[])var1_1, (String)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StringArray(WString[] strings) {
        this((Object[])var1_1, "--WIDE-STRING--");
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private StringArray(Object[] strings, String encoding) {
        super((strings.length + 1) * Native.POINTER_SIZE);
        void var1_1;
        this.original = strings;
        this.encoding = encoding;
        for (int i = 0; i < strings.length; ++i) {
            Pointer pointer;
            Object p = null;
            if (strings[i] != null) {
                NativeString ns = new NativeString(strings[i].toString(), encoding);
                this.natives.add(ns);
                pointer = ns.getPointer();
            }
            this.setPointer(Native.POINTER_SIZE * i, pointer);
        }
        this.setPointer(Native.POINTER_SIZE * ((void)var1_1).length, null);
    }

    @Override
    public void read() {
        boolean returnWide = this.original instanceof WString[];
        boolean wide = "--WIDE-STRING--".equals(this.encoding);
        for (int si = 0; si < this.original.length; ++si) {
            Pointer p = this.getPointer(si * Native.POINTER_SIZE);
            CharSequence s = null;
            if (p != null) {
                String string = s = wide ? p.getWideString(0L) : p.getString(0L, this.encoding);
                if (returnWide) {
                    s = new WString((String)s);
                }
            }
            this.original[si] = s;
        }
    }

    @Override
    public String toString() {
        String string;
        boolean bl = "--WIDE-STRING--".equals(this.encoding);
        String s = bl ? "const wchar_t*[]" : "const char*[]";
        string = string + Arrays.asList(this.original);
        return string;
    }
}

