/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Callback;
import com.sun.jna.FromNativeContext;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.Function;
import com.sun.jna.IntegerType;
import com.sun.jna.Klass;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.NativeString;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.StructureReadContext;
import com.sun.jna.StructureWriteContext;
import com.sun.jna.ToNativeContext;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.Union;
import com.sun.jna.WString;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Structure {
    private static final Logger LOG = Logger.getLogger(Structure.class.getName());
    public static final int ALIGN_DEFAULT = 0;
    public static final int ALIGN_NONE = 1;
    public static final int ALIGN_GNUC = 2;
    public static final int ALIGN_MSVC = 3;
    protected static final int CALCULATE_SIZE = -1;
    static final Map<Class<?>, LayoutInfo> layoutInfo = new WeakHashMap();
    static final Map<Class<?>, List<String>> fieldOrder = new WeakHashMap();
    private Pointer memory;
    private int size = -1;
    private int alignType;
    private String encoding;
    private int actualAlignType;
    private int structAlignment;
    private Map<String, StructField> structFields;
    private final Map<String, NativeStringTracking> nativeStrings = new HashMap<String, NativeStringTracking>(8);
    private TypeMapper typeMapper;
    private long typeInfo;
    private boolean autoRead = true;
    private boolean autoWrite = true;
    private Structure[] array;
    private boolean readCalled;
    private static final ThreadLocal<Map<Pointer, Structure>> reads = new ThreadLocal<Map<Pointer, Structure>>(){

        @Override
        protected final synchronized Map<Pointer, Structure> initialValue() {
            return new HashMap<Pointer, Structure>();
        }
    };
    private static final ThreadLocal<Set<Structure>> busy = new ThreadLocal<Set<Structure>>(){

        @Override
        protected final synchronized Set<Structure> initialValue() {
            return new StructureSet();
        }
    };
    private static final Pointer PLACEHOLDER_MEMORY = new Pointer(0L){
        {
            void var1_1;
        }

        @Override
        public final Pointer share(long offset, long sz) {
            return this;
        }
    };

    protected Structure() {
        this(0);
    }

    /*
     * WARNING - void declaration
     */
    protected Structure(TypeMapper mapper) {
        this(null, 0, (TypeMapper)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected Structure(int alignType) {
        this(null, (int)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected Structure(int alignType, TypeMapper mapper) {
        this(null, (int)var1_1, (TypeMapper)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected Structure(Pointer p) {
        this((Pointer)var1_1, 0);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected Structure(Pointer p, int alignType) {
        this((Pointer)var1_1, (int)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected Structure(Pointer p, int alignType, TypeMapper mapper) {
        void var3_3;
        void var2_2;
        this.setAlignType((int)var2_2);
        Structure structure = this;
        structure.setStringEncoding(Native.getStringEncoding(structure.getClass()));
        this.initializeTypeMapper((TypeMapper)var3_3);
        this.validateFields();
        if (p != null) {
            void var1_1;
            this.useMemory((Pointer)var1_1, 0, true);
        } else {
            this.allocateMemory(-1);
        }
        this.initializeFields();
    }

    Map<String, StructField> fields() {
        return this.structFields;
    }

    TypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    /*
     * WARNING - void declaration
     */
    private void initializeTypeMapper(TypeMapper mapper) {
        void var1_1;
        if (mapper == null) {
            mapper = Native.getTypeMapper(this.getClass());
        }
        this.typeMapper = var1_1;
        this.layoutChanged();
    }

    private void layoutChanged() {
        if (this.size != -1) {
            this.size = -1;
            if (this.memory instanceof AutoAllocated) {
                this.memory = null;
            }
            this.ensureAllocated();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void setStringEncoding(String encoding) {
        void var1_1;
        this.encoding = var1_1;
    }

    protected String getStringEncoding() {
        return this.encoding;
    }

    /*
     * WARNING - void declaration
     */
    protected void setAlignType(int alignType) {
        void var1_1;
        this.alignType = alignType;
        if (alignType == 0 && (alignType = Native.getStructureAlignment(this.getClass())) == 0) {
            alignType = Platform.isWindows() ? 3 : 2;
        }
        this.actualAlignType = var1_1;
        this.layoutChanged();
    }

    /*
     * WARNING - void declaration
     */
    protected Memory autoAllocate(int size) {
        void var1_1;
        return new AutoAllocated((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void useMemory(Pointer m) {
        void var1_1;
        this.useMemory((Pointer)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    protected void useMemory(Pointer m, int offset) {
        void var2_2;
        void var1_1;
        this.useMemory((Pointer)var1_1, (int)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    void useMemory(Pointer m, int offset, boolean force) {
        try {
            void var3_5;
            this.nativeStrings.clear();
            if (this instanceof ByValue && var3_5 == false) {
                byte[] buf = new byte[this.size()];
                m.read(0L, buf, 0, buf.length);
                this.memory.write(0L, buf, 0, buf.length);
            } else {
                void var1_1;
                void buf;
                if (this.size == -1) {
                    this.size = this.calculateSize(false);
                }
                this.memory = this.size != -1 ? m.share((long)buf, this.size) : var1_1.share((long)buf);
            }
            this.array = null;
            this.readCalled = false;
            return;
        }
        catch (IndexOutOfBoundsException e) {
            void var2_4;
            throw new IllegalArgumentException("Structure exceeds provided memory bounds", (Throwable)var2_4);
        }
    }

    protected void ensureAllocated() {
        this.ensureAllocated(false);
    }

    /*
     * WARNING - void declaration
     */
    private void ensureAllocated(boolean avoidFFIType) {
        if (this.memory == null) {
            this.allocateMemory(avoidFFIType);
            return;
        }
        if (this.size == -1) {
            this.size = this.calculateSize(true, avoidFFIType);
            if (!(this.memory instanceof AutoAllocated)) {
                try {
                    this.memory = this.memory.share(0L, this.size);
                    return;
                }
                catch (IndexOutOfBoundsException e) {
                    void var1_2;
                    throw new IllegalArgumentException("Structure exceeds provided memory bounds", (Throwable)var1_2);
                }
            }
        }
    }

    protected void allocateMemory() {
        this.allocateMemory(false);
    }

    /*
     * WARNING - void declaration
     */
    private void allocateMemory(boolean avoidFFIType) {
        void var1_1;
        Structure structure = this;
        structure.allocateMemory(structure.calculateSize(true, (boolean)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    protected void allocateMemory(int size) {
        if (size == -1) {
            size = this.calculateSize(false);
        } else if (size <= 0) {
            throw new IllegalArgumentException("Structure size must be greater than zero: " + size);
        }
        if (size != -1) {
            void var1_1;
            if (this.memory == null || this.memory instanceof AutoAllocated) {
                this.memory = this.autoAllocate(size);
            }
            this.size = var1_1;
        }
    }

    public int size() {
        this.ensureAllocated();
        return this.size;
    }

    public void clear() {
        this.ensureAllocated();
        this.nativeStrings.clear();
        this.memory.clear(this.size());
    }

    public Pointer getPointer() {
        this.ensureAllocated();
        return this.memory;
    }

    static Set<Structure> busy() {
        return busy.get();
    }

    static Map<Pointer, Structure> reading() {
        return reads.get();
    }

    void conditionalAutoRead() {
        if (!this.readCalled) {
            this.autoRead();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void read() {
        if (this.memory == PLACEHOLDER_MEMORY) {
            return;
        }
        this.readCalled = true;
        this.ensureAllocated();
        if (!Structure.busy().add(this)) {
            return;
        }
        if (this instanceof ByReference) {
            Structure.reading().put(this.getPointer(), this);
        }
        try {
            for (StructField structField : this.fields().values()) {
                void var2_3;
                this.readField((StructField)var2_3);
            }
            Structure.busy().remove(this);
        }
        catch (Throwable throwable) {
            Structure.busy().remove(this);
            if (this instanceof ByReference && Structure.reading().get(this.getPointer()) == this) {
                Structure.reading().remove(this.getPointer());
            }
            throw throwable;
        }
        if (this instanceof ByReference && Structure.reading().get(this.getPointer()) == this) {
            Structure.reading().remove(this.getPointer());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected int fieldOffset(String name) {
        void var2_2;
        this.ensureAllocated();
        StructField f = this.fields().get(name);
        if (f == null) {
            void var1_1;
            throw new IllegalArgumentException("No such field: " + (String)var1_1);
        }
        return var2_2.offset;
    }

    /*
     * WARNING - void declaration
     */
    public Object readField(String name) {
        void var2_2;
        this.ensureAllocated();
        StructField f = this.fields().get(name);
        if (f == null) {
            void var1_1;
            throw new IllegalArgumentException("No such field: " + (String)var1_1);
        }
        return this.readField((StructField)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    Object getFieldValue(Field field) {
        try {
            return field.get(this);
        }
        catch (Exception e) {
            void var2_2;
            void var1_1;
            throw new Error("Exception reading field '" + var1_1.getName() + "' in " + this.getClass(), (Throwable)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    void setFieldValue(Field field, Object value) {
        void var2_2;
        void var1_1;
        this.setFieldValue((Field)var1_1, var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    private void setFieldValue(Field field, Object value, boolean overrideFinal) {
        try {
            field.set(this, value);
            return;
        }
        catch (IllegalAccessException e) {
            void var2_3;
            void var1_1;
            int n = field.getModifiers();
            if (Modifier.isFinal(n)) {
                void var3_4;
                if (var3_4 != false) {
                    throw new UnsupportedOperationException("This VM does not support Structures with final fields (field '" + field.getName() + "' within " + this.getClass() + ")", e);
                }
                throw new UnsupportedOperationException("Attempt to write to read-only field '" + field.getName() + "' within " + this.getClass(), e);
            }
            throw new Error("Unexpectedly unable to write to field '" + var1_1.getName() + "' within " + this.getClass(), (Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    static <T extends Structure> T updateStructureByReference(Class<T> type, T s, Pointer address) {
        T t;
        if (address == null) {
            s = null;
        } else if (s == null || !address.equals(s.getPointer())) {
            Structure s1 = Structure.reading().get(address);
            if (s1 != null && type.equals(s1.getClass())) {
                ((Structure)t).autoRead();
            } else {
                void var2_2;
                Class<T> clazz;
                t = Structure.newInstance(clazz, (Pointer)var2_2);
                ((Structure)t).conditionalAutoRead();
            }
        } else {
            ((Structure)t).autoRead();
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    protected Object readField(StructField structField) {
        void var2_3;
        void var1_1;
        void result;
        Pointer p;
        Object currentValue;
        int offset = structField.offset;
        Class<?> fieldType = structField.type;
        FromNativeConverter readConverter = structField.readConverter;
        if (readConverter != null) {
            fieldType = readConverter.nativeType();
        }
        Object object = currentValue = Structure.class.isAssignableFrom(fieldType) || Callback.class.isAssignableFrom(fieldType) || Platform.HAS_BUFFERS && Buffer.class.isAssignableFrom(fieldType) || Pointer.class.isAssignableFrom(fieldType) || NativeMapped.class.isAssignableFrom(fieldType) || fieldType.isArray() ? this.getFieldValue(structField.field) : null;
        Object result2 = fieldType == String.class ? ((p = this.memory.getPointer(offset)) == null ? null : p.getString(0L, this.encoding)) : this.memory.getValue((long)result, fieldType, currentValue);
        if (readConverter != null) {
            result2 = readConverter.fromNative(result2, structField.context);
            if (currentValue != null && currentValue.equals(result2)) {
                result2 = currentValue;
            }
        }
        if (fieldType.equals(String.class) || fieldType.equals(WString.class)) {
            if (result2 != null) {
                NativeStringTracking current = new NativeStringTracking(result2);
                NativeStringTracking previous = this.nativeStrings.put(structField.name, current);
                if (previous != null) {
                    void var3_4;
                    NativeStringTracking.access$002(current, ((NativeStringTracking)var3_4).peer);
                }
            } else {
                this.nativeStrings.remove(structField.name);
            }
        }
        this.setFieldValue(var1_1.field, result2, true);
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public void write() {
        if (this.memory == PLACEHOLDER_MEMORY) {
            return;
        }
        this.ensureAllocated();
        if (this instanceof ByValue) {
            this.getTypeInfo();
        }
        if (!Structure.busy().add(this)) {
            return;
        }
        try {
            for (StructField sf : this.fields().values()) {
                void var2_3;
                if (sf.isVolatile) continue;
                this.writeField((StructField)var2_3);
            }
            return;
        }
        finally {
            Structure.busy().remove(this);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void writeField(String name) {
        void var2_2;
        this.ensureAllocated();
        StructField f = this.fields().get(name);
        if (f == null) {
            void var1_1;
            throw new IllegalArgumentException("No such field: " + (String)var1_1);
        }
        this.writeField((StructField)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void writeField(String name, Object value) {
        void var2_2;
        void var3_3;
        this.ensureAllocated();
        StructField structField = this.fields().get(name);
        if (structField == null) {
            void var1_1;
            throw new IllegalArgumentException("No such field: " + (String)var1_1);
        }
        this.setFieldValue(structField.field, value);
        this.writeField((StructField)var3_3, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void writeField(StructField structField) {
        void var2_2;
        void var1_1;
        if (structField.isReadOnly) {
            return;
        }
        Object value = this.getFieldValue(structField.field);
        this.writeField((StructField)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void writeField(StructField structField, Object value) {
        Pointer pointer;
        int offset = structField.offset;
        Class<?> fieldType = structField.type;
        ToNativeConverter converter = structField.writeConverter;
        if (converter != null) {
            value = converter.toNative(value, new StructureWriteContext(this, structField.field));
            fieldType = converter.nativeType();
        }
        if (String.class == fieldType || WString.class == fieldType) {
            if (value != null) {
                NativeStringTracking current = new NativeStringTracking(value);
                NativeStringTracking previous22 = this.nativeStrings.put(structField.name, current);
                if (previous22 != null && value.equals(previous22.value)) {
                    NativeStringTracking.access$002(current, previous22.peer);
                    return;
                }
                boolean previous22 = fieldType == WString.class;
                NativeString nativeString = previous22 ? new NativeString(value.toString(), true) : new NativeString(value.toString(), this.encoding);
                NativeStringTracking.access$002(current, nativeString);
                pointer = ((NativeString)((Object)pointer)).getPointer();
            } else {
                this.nativeStrings.remove(structField.name);
            }
        }
        try {
            void var3_3;
            this.memory.setValue((long)var3_3, pointer, fieldType);
            return;
        }
        catch (IllegalArgumentException e) {
            void var1_1;
            String msg = "Structure field \"" + structField.name + "\" was declared as " + structField.type + (var1_1.type == fieldType ? "" : " (native type " + fieldType + ")") + ", which is not supported within a Structure";
            throw new IllegalArgumentException(msg, e);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected List<String> getFieldOrder() {
        void var1_1;
        LinkedList<String> fields = new LinkedList<String>();
        for (Class<?> clazz = this.getClass(); clazz != Structure.class; clazz = clazz.getSuperclass()) {
            void var3_3;
            FieldOrder order = clazz.getAnnotation(FieldOrder.class);
            if (order == null) continue;
            fields.addAll(0, Arrays.asList(var3_3.value()));
        }
        return Collections.unmodifiableList(var1_1);
    }

    protected void sortFields(List<Field> fields, List<String> names) {
        block0: for (int i = 0; i < names.size(); ++i) {
            String name = names.get(i);
            for (int f = 0; f < fields.size(); ++f) {
                Field field = fields.get(f);
                if (!name.equals(field.getName())) continue;
                Collections.swap(fields, i, f);
                continue block0;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected List<Field> getFieldList() {
        void var1_1;
        ArrayList flist = new ArrayList();
        Class<?> cls = this.getClass();
        while (!cls.equals(Structure.class)) {
            void var3_3;
            ArrayList<Field> classFields = new ArrayList<Field>();
            Field[] fields = cls.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                int modifiers = fields[i].getModifiers();
                if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
                classFields.add(fields[i]);
            }
            flist.addAll(0, var3_3);
            cls = cls.getSuperclass();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private List<String> fieldOrder() {
        Class<?> clazz = this.getClass();
        Map<Class<?>, List<String>> map = fieldOrder;
        synchronized (map) {
            void var3_4;
            List<String> list = fieldOrder.get(clazz);
            if (list == null) {
                void var1_1;
                list = this.getFieldOrder();
                fieldOrder.put((Class<?>)var1_1, list);
            }
            return var3_4;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> createFieldsOrder(List<String> baseFields, String ... extraFields) {
        void var1_1;
        return Structure.createFieldsOrder(baseFields, Arrays.asList(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static List<String> createFieldsOrder(List<String> baseFields, List<String> extraFields) {
        void var2_2;
        void var1_1;
        List<String> list;
        ArrayList<String> fields = new ArrayList<String>(baseFields.size() + extraFields.size());
        fields.addAll(list);
        fields.addAll((Collection<String>)var1_1);
        return Collections.unmodifiableList(var2_2);
    }

    public static List<String> createFieldsOrder(String field) {
        return Collections.unmodifiableList(Collections.singletonList(field));
    }

    public static List<String> createFieldsOrder(String ... fields) {
        return Collections.unmodifiableList(Arrays.asList(fields));
    }

    private static <T extends Comparable<T>> List<T> sort(Collection<? extends T> c) {
        Collection<? extends T> collection;
        Collection<? extends T> list = new ArrayList<T>(c);
        Collections.sort(list);
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    protected List<Field> getFields(boolean force) {
        void var2_2;
        List<Field> flist = this.getFieldList();
        HashSet<String> names = new HashSet<String>();
        for (Field f : flist) {
            names.add(f.getName());
        }
        List<String> fieldOrder = this.fieldOrder();
        if (fieldOrder.size() != flist.size() && flist.size() > 1) {
            void var1_1;
            if (var1_1 != false) {
                throw new Error("Structure.getFieldOrder() on " + this.getClass() + (fieldOrder.size() < flist.size() ? " does not provide enough" : " provides too many") + " names [" + fieldOrder.size() + "] (" + Structure.sort(fieldOrder) + ") to match declared fields [" + flist.size() + "] (" + Structure.sort(names) + ")");
            }
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>(fieldOrder);
        if (!hashSet.equals(names)) {
            void var3_3;
            throw new Error("Structure.getFieldOrder() on " + this.getClass() + " returns names (" + Structure.sort(fieldOrder) + ") which do not match declared field names (" + Structure.sort(var3_3) + ")");
        }
        this.sortFields(flist, fieldOrder);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected int calculateSize(boolean force) {
        void var1_1;
        return this.calculateSize((boolean)var1_1, false);
    }

    static int size(Class<? extends Structure> type) {
        return Structure.size(type, null);
    }

    /*
     * WARNING - void declaration
     */
    static <T extends Structure> int size(Class<T> type, T value) {
        void var3_4;
        void var2_5;
        LayoutInfo info;
        Map<Class<?>, LayoutInfo> map = layoutInfo;
        synchronized (map) {
            info = layoutInfo.get(type);
        }
        int sz = info != null && !info.variable ? ((LayoutInfo)var2_5).size : -1;
        if (sz == -1) {
            void var1_2;
            if (value == null) {
                Class<T> clazz;
                value = Structure.newInstance(clazz, PLACEHOLDER_MEMORY);
            }
            sz = var1_2.size();
        }
        return (int)var3_4;
    }

    /*
     * WARNING - void declaration
     */
    int calculateSize(boolean force, boolean avoidFFIType) {
        void var3_5;
        LayoutInfo info;
        int size = -1;
        Class<?> clazz = this.getClass();
        Map<Class<?>, LayoutInfo> map = layoutInfo;
        synchronized (map) {
            info = layoutInfo.get(clazz);
        }
        if (info == null || this.alignType != info.alignType || this.typeMapper != info.typeMapper) {
            void var2_4;
            void var1_1;
            info = this.deriveLayout((boolean)var1_1, (boolean)var2_4);
        }
        if (info != null) {
            this.structAlignment = info.alignment;
            this.structFields = info.fields;
            if (!info.variable) {
                map = layoutInfo;
                synchronized (map) {
                    if (!layoutInfo.containsKey(clazz) || this.alignType != 0 || this.typeMapper != null) {
                        layoutInfo.put(clazz, info);
                    }
                }
            }
            size = info.size;
        }
        return (int)var3_5;
    }

    /*
     * WARNING - void declaration
     */
    private void validateField(String name, Class<?> type) {
        ToNativeConverter toNative;
        while (this.typeMapper != null && (toNative = this.typeMapper.getToNativeConverter(type)) != null) {
            type = toNative.nativeType();
        }
        if (type.isArray()) {
            this.validateField(name, type.getComponentType());
            return;
        }
        try {
            this.getNativeSize(type);
            return;
        }
        catch (IllegalArgumentException e) {
            void var3_4;
            void var1_1;
            void var2_2;
            String msg = "Invalid Structure field in " + this.getClass() + ", field name '" + name + "' (" + var2_2 + "): " + e.getMessage();
            throw new IllegalArgumentException((String)var1_1, (Throwable)var3_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void validateFields() {
        Object object = this.getFieldList();
        object = object.iterator();
        while (object.hasNext()) {
            void var2_2;
            Field f = (Field)object.next();
            this.validateField(f.getName(), var2_2.getType());
        }
    }

    /*
     * WARNING - void declaration
     */
    private LayoutInfo deriveLayout(boolean force, boolean avoidFFIType) {
        int calculatedSize = 0;
        List<Field> fields = this.getFields(force);
        if (fields == null) {
            return null;
        }
        LayoutInfo info = new LayoutInfo();
        LayoutInfo.access$402(info, this.alignType);
        LayoutInfo.access$502(info, this.typeMapper);
        boolean firstField = true;
        for (Field field : fields) {
            int modifiers = field.getModifiers();
            Class<?> type = field.getType();
            if (type.isArray()) {
                LayoutInfo.access$202(info, true);
            }
            StructField structField = new StructField();
            new StructField().isVolatile = Modifier.isVolatile(modifiers);
            structField.isReadOnly = Modifier.isFinal(modifiers);
            if (structField.isReadOnly) {
                if (!Platform.RO_FIELDS) {
                    throw new IllegalArgumentException("This VM does not support read-only fields (field '" + field.getName() + "' within " + this.getClass() + ")");
                }
                field.setAccessible(true);
            }
            structField.field = field;
            structField.name = field.getName();
            structField.type = type;
            if (Callback.class.isAssignableFrom(type) && !type.isInterface()) {
                throw new IllegalArgumentException("Structure Callback field '" + field.getName() + "' must be an interface");
            }
            if (type.isArray() && Structure.class.equals(type.getComponentType())) {
                String msg = "Nested Structure arrays must use a derived Structure type so that the size of the elements can be determined";
                throw new IllegalArgumentException(msg);
            }
            if (Modifier.isPublic(field.getModifiers())) {
                int fieldAlignment;
                Object value = this.getFieldValue(structField.field);
                if (value == null && type.isArray()) {
                    if (force) {
                        throw new IllegalStateException("Array fields must be initialized");
                    }
                    return null;
                }
                Class<Object> nativeType = type;
                if (NativeMapped.class.isAssignableFrom(type)) {
                    NativeMappedConverter tc = NativeMappedConverter.getInstance(type);
                    nativeType = tc.nativeType();
                    structField.writeConverter = tc;
                    structField.readConverter = tc;
                    structField.context = new StructureReadContext(this, field);
                } else if (this.typeMapper != null) {
                    ToNativeConverter writeConverter = this.typeMapper.getToNativeConverter(type);
                    FromNativeConverter readConverter = this.typeMapper.getFromNativeConverter(type);
                    if (writeConverter != null && readConverter != null) {
                        nativeType = (value = writeConverter.toNative(value, new StructureWriteContext(this, structField.field))) != null ? value.getClass() : Pointer.class;
                        structField.writeConverter = writeConverter;
                        structField.readConverter = readConverter;
                        structField.context = new StructureReadContext(this, field);
                    } else if (writeConverter != null || readConverter != null) {
                        void var1_2;
                        String msg = "Structures require bidirectional type conversion for " + type;
                        throw new IllegalArgumentException((String)var1_2);
                    }
                }
                if (value == null) {
                    value = this.initializeField(structField.field, type);
                }
                try {
                    void msg;
                    structField.size = this.getNativeSize(nativeType, value);
                    fieldAlignment = this.getNativeAlignment(nativeType, value, (boolean)msg);
                }
                catch (IllegalArgumentException e) {
                    void var1_1;
                    if (var1_1 == false && this.typeMapper == null) {
                        return null;
                    }
                    String msg = "Invalid Structure field in " + this.getClass() + ", field name '" + structField.name + "' (" + structField.type + "): " + e.getMessage();
                    throw new IllegalArgumentException(msg, e);
                }
                if (fieldAlignment == 0) {
                    throw new Error("Field alignment is zero for field '" + structField.name + "' within " + this.getClass());
                }
                LayoutInfo layoutInfo = info;
                LayoutInfo.access$602(layoutInfo, Math.max(layoutInfo.alignment, fieldAlignment));
                if (calculatedSize % fieldAlignment != 0) {
                    calculatedSize += fieldAlignment - calculatedSize % fieldAlignment;
                }
                if (this instanceof Union) {
                    structField.offset = 0;
                    calculatedSize = Math.max(calculatedSize, structField.size);
                } else {
                    structField.offset = calculatedSize;
                    calculatedSize += structField.size;
                }
                info.fields.put(structField.name, structField);
            }
            boolean bl = false;
        }
        if (calculatedSize > 0) {
            void var2_3;
            void var3_4;
            int size = this.addPadding((int)var3_4, info.alignment);
            if (this instanceof ByValue && var2_3 == false) {
                this.getTypeInfo();
            }
            LayoutInfo.access$302(info, size);
            return info;
        }
        throw new IllegalArgumentException("Structure " + this.getClass() + " has unknown or zero size (ensure all fields are public)");
    }

    /*
     * WARNING - void declaration
     */
    private void initializeFields() {
        Object object = this.getFieldList();
        object = object.iterator();
        while (object.hasNext()) {
            Field f = (Field)object.next();
            try {
                Object object2 = f.get(this);
                if (object2 != null) continue;
                Field field = f;
                this.initializeField(field, field.getType());
            }
            catch (Exception e) {
                void var3_4;
                void var2_2;
                throw new Error("Exception reading field '" + var2_2.getName() + "' in " + this.getClass(), (Throwable)var3_4);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private Object initializeField(Field field, Class<?> type) {
        void var3_4;
        NativeMappedConverter nativeMappedConverter;
        void var1_1;
        NativeMapped value = null;
        if (Structure.class.isAssignableFrom(type) && !ByReference.class.isAssignableFrom(type)) {
            try {
                value = (NativeMapped)Structure.newInstance(type, PLACEHOLDER_MEMORY);
                this.setFieldValue(field, value);
            }
            catch (IllegalArgumentException e) {
                void var2_3;
                String msg = "Can't determine size of nested structure";
                throw new IllegalArgumentException((String)var1_1, (Throwable)var2_3);
            }
        } else if (NativeMapped.class.isAssignableFrom((Class<?>)((Object)nativeMappedConverter))) {
            nativeMappedConverter = NativeMappedConverter.getInstance(nativeMappedConverter);
            value = nativeMappedConverter.defaultValue();
            this.setFieldValue((Field)var1_1, value);
        }
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    private int addPadding(int calculatedSize) {
        void var1_1;
        return this.addPadding((int)var1_1, this.structAlignment);
    }

    /*
     * WARNING - void declaration
     */
    private int addPadding(int calculatedSize, int alignment) {
        void var1_1;
        if (this.actualAlignType != 1 && calculatedSize % alignment != 0) {
            void var2_2;
            calculatedSize += alignment - calculatedSize % var2_2;
        }
        return (int)var1_1;
    }

    protected int getStructAlignment() {
        if (this.size == -1) {
            this.calculateSize(true);
        }
        return this.structAlignment;
    }

    /*
     * WARNING - void declaration
     */
    protected int getNativeAlignment(Class<?> type, Object value, boolean isFirstElement) {
        void var2_3;
        int alignment22;
        if (NativeMapped.class.isAssignableFrom(type)) {
            NativeMappedConverter tc = NativeMappedConverter.getInstance(type);
            type = tc.nativeType();
            value = tc.toNative(value, new ToNativeContext());
        }
        int size = Native.getNativeSize(type, value);
        if (type.isPrimitive() || Long.class == type || Integer.class == type || Short.class == type || Character.class == type || Byte.class == type || Boolean.class == type || Float.class == type || Double.class == type) {
            alignment22 = size;
        } else if (Pointer.class.isAssignableFrom(type) && !Function.class.isAssignableFrom(type) || Platform.HAS_BUFFERS && Buffer.class.isAssignableFrom(type) || Callback.class.isAssignableFrom(type) || WString.class == type || String.class == type) {
            alignment22 = Native.POINTER_SIZE;
        } else if (Structure.class.isAssignableFrom(type)) {
            if (ByReference.class.isAssignableFrom(type)) {
                alignment22 = Native.POINTER_SIZE;
            } else {
                Object alignment22;
                if (alignment22 == null) {
                    alignment22 = Structure.newInstance(type, PLACEHOLDER_MEMORY);
                }
                alignment22 = ((Structure)alignment22).getStructAlignment();
            }
        } else if (type.isArray()) {
            alignment22 = this.getNativeAlignment(type.getComponentType(), null, isFirstElement);
        } else {
            throw new IllegalArgumentException("Type " + type + " has unknown native alignment");
        }
        if (this.actualAlignType == 1) {
            alignment22 = 1;
        } else if (this.actualAlignType == 3) {
            alignment22 = Math.min(8, alignment22);
        } else if (this.actualAlignType == 2) {
            void var1_1;
            void var3_4;
            if (!(isFirstElement && Platform.isMac() && Platform.isPPC())) {
                alignment22 = Math.min(Native.MAX_ALIGNMENT, alignment22);
            }
            if (var3_4 == false && Platform.isAIX() && (type == Double.TYPE || var1_1 == Double.class)) {
                alignment22 = 4;
            }
        }
        return (int)var2_3;
    }

    public String toString() {
        return this.toString(Boolean.getBoolean("jna.dump_memory"));
    }

    /*
     * WARNING - void declaration
     */
    public String toString(boolean debug) {
        void var1_1;
        return this.toString(0, true, (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private String format(Class<?> type) {
        void var2_2;
        void var1_1;
        String s = type.getName();
        int dot = s.lastIndexOf(".");
        return var1_1.substring((int)(var2_2 + true));
    }

    /*
     * WARNING - void declaration
     */
    private String toString(int indent, boolean showContents, boolean dumpMemory) {
        void var3_4;
        void var1_1;
        this.ensureAllocated();
        String LS = System.getProperty("line.separator");
        Structure structure = this;
        String name = structure.format(structure.getClass()) + "(" + this.getPointer() + ")";
        if (!(this.getPointer() instanceof Memory)) {
            name = name + " (" + this.size() + " bytes)";
        }
        String prefix = "";
        for (int idx = 0; idx < indent; ++idx) {
            prefix = prefix + "  ";
        }
        String contents = LS;
        if (!showContents) {
            contents = "...}";
        } else {
            Iterator<StructField> i = this.fields().values().iterator();
            while (i.hasNext()) {
                StructField sf = i.next();
                Object value = this.getFieldValue(sf.field);
                String type = this.format(sf.type);
                String index = "";
                contents = contents + prefix;
                if (sf.type.isArray() && value != null) {
                    type = this.format(sf.type.getComponentType());
                    index = "[" + Array.getLength(value) + "]";
                }
                contents = contents + String.format("  %s %s%s@0x%X", type, sf.name, index, sf.offset);
                if (value instanceof Structure) {
                    value = ((Structure)value).toString(indent + 1, !(value instanceof ByReference), dumpMemory);
                }
                contents = contents + "=";
                contents = value instanceof Long ? contents + String.format("0x%08X", (Long)value) : (value instanceof Integer ? contents + String.format("0x%04X", (Integer)value) : (value instanceof Short ? contents + String.format("0x%02X", (Short)value) : (value instanceof Byte ? contents + String.format("0x%01X", (Byte)value) : contents + String.valueOf(value).trim())));
                contents = contents + LS;
                if (i.hasNext()) continue;
                contents = contents + prefix + "}";
            }
        }
        if (var1_1 == false && var3_4 != false) {
            contents = contents + LS + "memory dump" + LS;
            byte[] buf = this.getPointer().getByteArray(0L, this.size());
            for (int i = 0; i < buf.length; ++i) {
                if (i % 4 == 0) {
                    contents = contents + "[";
                }
                if (buf[i] >= 0 && buf[i] < 16) {
                    contents = contents + "0";
                }
                contents = contents + Integer.toHexString(buf[i] & 0xFF);
                if (i % 4 != 3 || i >= buf.length - 1) continue;
                contents = contents + "]" + LS;
            }
            contents = contents + "]";
        }
        return name + " {" + contents;
    }

    /*
     * WARNING - void declaration
     */
    public Structure[] toArray(Structure[] array) {
        void var1_1;
        this.ensureAllocated();
        if (this.memory instanceof AutoAllocated) {
            Memory m = (Memory)this.memory;
            int requiredSize = array.length * this.size();
            if (m.size() < (long)requiredSize) {
                Structure structure = this;
                structure.useMemory(structure.autoAllocate(requiredSize));
            }
        }
        array[0] = this;
        int size = this.size();
        for (int i = 1; i < array.length; ++i) {
            array[i] = Structure.newInstance(this.getClass(), this.memory.share(i * size, size));
            array[i].conditionalAutoRead();
        }
        if (!(this instanceof ByValue)) {
            this.array = array;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Structure[] toArray(int size) {
        void var1_1;
        Structure structure = this;
        return structure.toArray((Structure[])Array.newInstance(structure.getClass(), (int)var1_1));
    }

    private Class<?> baseClass() {
        if ((this instanceof ByReference || this instanceof ByValue) && Structure.class.isAssignableFrom(this.getClass().getSuperclass())) {
            return this.getClass().getSuperclass();
        }
        return this.getClass();
    }

    /*
     * WARNING - void declaration
     */
    public boolean dataEquals(Structure s) {
        void var1_1;
        return this.dataEquals((Structure)var1_1, false);
    }

    public boolean dataEquals(Structure s, boolean clear) {
        byte[] ref;
        byte[] data;
        if (clear) {
            s.getPointer().clear(s.size());
            s.write();
            this.getPointer().clear(this.size());
            this.write();
        }
        if ((data = s.getPointer().getByteArray(0L, s.size())).length == (ref = this.getPointer().getByteArray(0L, this.size())).length) {
            for (int i = 0; i < data.length; ++i) {
                if (data[i] == ref[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        return o instanceof Structure && o.getClass() == this.getClass() && ((Structure)var1_1).getPointer().equals(this.getPointer());
    }

    public int hashCode() {
        Pointer pointer = this.getPointer();
        if (pointer != null) {
            return this.getPointer().hashCode();
        }
        return this.getClass().hashCode();
    }

    /*
     * WARNING - void declaration
     */
    protected void cacheTypeInfo(Pointer p) {
        void var1_1;
        this.typeInfo = var1_1.peer;
    }

    /*
     * WARNING - void declaration
     */
    FFIType getFieldTypeInfo(StructField f) {
        void var2_2;
        void var1_1;
        ToNativeConverter nc;
        Class<?> type = f.type;
        Object value = this.getFieldValue(f.field);
        if (this.typeMapper != null && (nc = this.typeMapper.getToNativeConverter(type)) != null) {
            void var3_3;
            type = nc.nativeType();
            value = var3_3.toNative(value, new ToNativeContext());
        }
        return FFIType.access$900(var1_1, (Class)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    Pointer getTypeInfo() {
        void var1_1;
        Pointer p = Structure.getTypeInfo(this).getPointer();
        this.cacheTypeInfo(p);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setAutoSynch(boolean auto) {
        void var1_1;
        this.setAutoRead(auto);
        this.setAutoWrite((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setAutoRead(boolean auto) {
        void var1_1;
        this.autoRead = var1_1;
    }

    public boolean getAutoRead() {
        return this.autoRead;
    }

    /*
     * WARNING - void declaration
     */
    public void setAutoWrite(boolean auto) {
        void var1_1;
        this.autoWrite = var1_1;
    }

    public boolean getAutoWrite() {
        return this.autoWrite;
    }

    static FFIType getTypeInfo(Object obj) {
        return FFIType.get(obj);
    }

    /*
     * WARNING - void declaration
     */
    private static <T extends Structure> T newInstance(Class<T> type, long init) {
        try {
            void var1_2;
            Class<T> s = Structure.newInstance(type, init == 0L ? PLACEHOLDER_MEMORY : new Pointer(init));
            if (var1_2 != 0L) {
                ((Structure)((Object)s)).conditionalAutoRead();
            }
            return (T)s;
        }
        catch (Throwable e) {
            void var0_1;
            LOG.log(Level.WARNING, "JNA: Error creating structure", (Throwable)var0_1);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Structure> T newInstance(Class<T> type, Pointer init) throws IllegalArgumentException {
        void var2_2;
        Object object;
        Object msg;
        try {
            Constructor<T> ctor = Structure.getPointerConstructor(type);
            if (ctor != null) {
                return (T)((Structure)ctor.newInstance(init));
            }
        }
        catch (SecurityException securityException) {
        }
        catch (InstantiationException e) {
            msg = "Can't instantiate " + type;
            throw new IllegalArgumentException((String)msg, e);
        }
        catch (IllegalAccessException e) {
            msg = "Instantiation of " + msg + " (Pointer) not allowed, is it public?";
            throw new IllegalArgumentException((String)msg, e);
        }
        catch (InvocationTargetException e) {
            msg = "Exception thrown while instantiating an instance of " + msg;
            throw new IllegalArgumentException((String)object, e);
        }
        T s = Structure.newInstance(object);
        if (init != PLACEHOLDER_MEMORY) {
            void var1_1;
            ((Structure)s).useMemory((Pointer)var1_1);
        }
        return var2_2;
    }

    public static <T extends Structure> T newInstance(Class<T> type) throws IllegalArgumentException {
        Structure structure;
        Structure s = (Structure)Klass.newInstance(type);
        if (s instanceof ByValue) {
            s.allocateMemory();
        }
        return (T)structure;
    }

    /*
     * WARNING - void declaration
     */
    private static <T> Constructor<T> getPointerConstructor(Class<T> type) {
        for (Constructor<?> constructor : type.getConstructors()) {
            void var3_3;
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != 1 || !parameterTypes[0].equals(Pointer.class)) continue;
            return var3_3;
        }
        return null;
    }

    private static void structureArrayCheck(Structure[] ss) {
        if (ByReference[].class.isAssignableFrom(ss.getClass())) {
            return;
        }
        Pointer base = ss[0].getPointer();
        int size = ss[0].size();
        for (int si = 1; si < ss.length; ++si) {
            Object object;
            if (ss[si].getPointer().peer == base.peer + (long)(size * si)) continue;
            Object msg = "Structure array elements must use contiguous memory (bad backing address at Structure array index " + si + ")";
            throw new IllegalArgumentException((String)object);
        }
    }

    public static void autoRead(Structure[] ss) {
        Structure.structureArrayCheck(ss);
        if (ss[0].array == ss) {
            ss[0].autoRead();
            return;
        }
        for (int si = 0; si < ss.length; ++si) {
            if (ss[si] == null) continue;
            ss[si].autoRead();
        }
    }

    public void autoRead() {
        if (this.getAutoRead()) {
            this.read();
            if (this.array != null) {
                for (int i = 1; i < this.array.length; ++i) {
                    this.array[i].autoRead();
                }
            }
        }
    }

    public static void autoWrite(Structure[] ss) {
        Structure.structureArrayCheck(ss);
        if (ss[0].array == ss) {
            ss[0].autoWrite();
            return;
        }
        for (int si = 0; si < ss.length; ++si) {
            if (ss[si] == null) continue;
            ss[si].autoWrite();
        }
    }

    public void autoWrite() {
        if (this.getAutoWrite()) {
            this.write();
            if (this.array != null) {
                for (int i = 1; i < this.array.length; ++i) {
                    this.array[i].autoWrite();
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected int getNativeSize(Class<?> nativeType) {
        void var1_1;
        return this.getNativeSize((Class<?>)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    protected int getNativeSize(Class<?> nativeType, Object value) {
        void var2_2;
        return Native.getNativeSize(nativeType, var2_2);
    }

    static void validate(Class<? extends Structure> cls) {
        Class<? extends Structure> clazz;
        try {
            cls.getConstructor(new Class[0]);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {}
        throw new IllegalArgumentException("No suitable constructor found for class: " + clazz.getName());
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$2300(Structure x0, boolean x1) {
        void var1_1;
        x0.ensureAllocated((boolean)var1_1);
    }

    private static class AutoAllocated
    extends Memory {
        /*
         * WARNING - void declaration
         */
        public AutoAllocated(int size) {
            super((long)var1_1);
            void var1_1;
            super.clear();
        }

        @Override
        public String toString() {
            return "auto-" + super.toString();
        }
    }

    @FieldOrder(value={"size", "alignment", "type", "elements"})
    static class FFIType
    extends Structure {
        private static final Map<Class, FFIType> typeInfoMap = new WeakHashMap<Class, FFIType>();
        private static final Map<Class, FFIType> unionHelper = new WeakHashMap<Class, FFIType>();
        private static final Map<Pointer, FFIType> ffiTypeInfo = new HashMap<Pointer, FFIType>();
        private static final int FFI_TYPE_STRUCT = 13;
        public size_t size;
        public short alignment;
        public short type = (short)13;
        public Pointer elements;

        private static boolean isIntegerType(FFIType type) {
            Pointer pointer;
            Pointer typePointer = type.getPointer();
            return typePointer.equals(FFITypes.ffi_type_uint8) || typePointer.equals(FFITypes.ffi_type_sint8) || typePointer.equals(FFITypes.ffi_type_uint16) || typePointer.equals(FFITypes.ffi_type_sint16) || typePointer.equals(FFITypes.ffi_type_uint32) || typePointer.equals(FFITypes.ffi_type_sint32) || typePointer.equals(FFITypes.ffi_type_uint64) || typePointer.equals(FFITypes.ffi_type_sint64) || pointer.equals(FFITypes.ffi_type_pointer);
        }

        private static boolean isFloatType(FFIType type) {
            Pointer pointer;
            Pointer typePointer = type.getPointer();
            return typePointer.equals(FFITypes.ffi_type_float) || pointer.equals(FFITypes.ffi_type_double);
        }

        /*
         * WARNING - void declaration
         */
        public FFIType(FFIType reference) {
            void var1_1;
            this.size = reference.size;
            this.alignment = reference.alignment;
            this.type = reference.type;
            this.elements = var1_1.elements;
        }

        public FFIType() {
        }

        public FFIType(Structure ref) {
            Pointer[] els;
            Iterator<StructField> iterator;
            Structure.access$2300(ref, true);
            if (ref instanceof Union) {
                Structure unionType = null;
                int size = 0;
                boolean hasInteger = false;
                iterator = ref.fields().values().iterator();
                while (iterator.hasNext()) {
                    StructField sf = iterator.next();
                    FFIType type = ref.getFieldTypeInfo(sf);
                    if (FFIType.isIntegerType(type)) {
                        hasInteger = true;
                    }
                    if (unionType != null && size >= sf.size && (size != sf.size || !Structure.class.isAssignableFrom(sf.type))) continue;
                    unionType = type;
                    size = sf.size;
                }
                if ((Platform.isIntel() && Platform.is64Bit() && !Platform.isWindows() || Platform.isARM()) && hasInteger && FFIType.isFloatType(unionType)) {
                    unionType = new FFIType((FFIType)unionType);
                    if (((FFIType)unionType).size.intValue() == 4) {
                        ((FFIType)unionType).type = FFIType.ffiTypeInfo.get((Object)FFITypes.ffi_type_uint32).type;
                    } else if (((FFIType)unionType).size.intValue() == 8) {
                        ((FFIType)unionType).type = FFIType.ffiTypeInfo.get((Object)FFITypes.ffi_type_uint64).type;
                    }
                    unionType.write();
                }
                els = new Pointer[]{unionType.getPointer(), null};
                unionHelper.put(ref.getClass(), (FFIType)unionType);
            } else {
                els = new Pointer[ref.fields().size() + 1];
                int idx = 0;
                for (StructField sf : ref.fields().values()) {
                    els[idx++] = ref.getFieldTypeInfo(sf).getPointer();
                }
            }
            this.init((Pointer[])iterator);
            this.write();
        }

        /*
         * WARNING - void declaration
         */
        public FFIType(Object array, Class<?> type) {
            void var3_4;
            int length = Array.getLength(array);
            Pointer[] els = new Pointer[length + 1];
            Pointer p = FFIType.get(null, type.getComponentType()).getPointer();
            for (int i = 0; i < length; ++i) {
                els[i] = p;
            }
            this.init((Pointer[])var3_4);
            this.write();
        }

        /*
         * WARNING - void declaration
         */
        private void init(Pointer[] els) {
            void var1_1;
            this.elements = new Memory(Native.POINTER_SIZE * els.length);
            this.elements.write(0L, els, 0, ((void)var1_1).length);
            this.write();
        }

        static FFIType get(Object obj) {
            Object object;
            if (obj == null) {
                return typeInfoMap.get(Pointer.class);
            }
            if (obj instanceof Class) {
                return FFIType.get(null, (Class)obj);
            }
            Object object2 = object;
            return FFIType.get(object2, object2.getClass());
        }

        /*
         * WARNING - void declaration
         */
        private static FFIType get(Object obj, Class<?> cls) {
            Map<Class, FFIType> map;
            ToNativeConverter nc;
            TypeMapper mapper = Native.getTypeMapper(cls);
            if (mapper != null && (nc = mapper.getToNativeConverter(cls)) != null) {
                cls = map.nativeType();
            }
            map = typeInfoMap;
            synchronized (map) {
                void var1_2;
                FFIType type;
                FFIType o = typeInfoMap.get(cls);
                if (o != null) {
                    return o;
                }
                if (Platform.HAS_BUFFERS && Buffer.class.isAssignableFrom(cls) || Callback.class.isAssignableFrom(cls)) {
                    typeInfoMap.put(cls, typeInfoMap.get(Pointer.class));
                    return typeInfoMap.get(Pointer.class);
                }
                if (Structure.class.isAssignableFrom(cls)) {
                    if (obj == null) {
                        obj = FFIType.newInstance(cls, PLACEHOLDER_MEMORY);
                    }
                    if (ByReference.class.isAssignableFrom(cls)) {
                        typeInfoMap.put(cls, typeInfoMap.get(Pointer.class));
                        return typeInfoMap.get(Pointer.class);
                    }
                    type = new FFIType((Structure)obj);
                    typeInfoMap.put(cls, type);
                    return type;
                }
                if (NativeMapped.class.isAssignableFrom(cls)) {
                    NativeMappedConverter c = NativeMappedConverter.getInstance(cls);
                    return FFIType.get(c.toNative(obj, new ToNativeContext()), c.nativeType());
                }
                if (cls.isArray()) {
                    void var3_4;
                    Object object;
                    type = new FFIType(object, cls);
                    typeInfoMap.put(cls, type);
                    return var3_4;
                }
                throw new IllegalArgumentException("Unsupported type " + var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ FFIType access$900(Object x0, Class x1) {
            void var1_1;
            return FFIType.get(x0, var1_1);
        }

        static {
            if (Native.POINTER_SIZE == 0) {
                throw new Error("Native library not initialized");
            }
            if (FFITypes.ffi_type_void == null) {
                throw new Error("FFI types not initialized");
            }
            ffiTypeInfo.put(FFITypes.ffi_type_void, Structure.newInstance(FFIType.class, FFITypes.ffi_type_void));
            ffiTypeInfo.put(FFITypes.ffi_type_float, Structure.newInstance(FFIType.class, FFITypes.ffi_type_float));
            ffiTypeInfo.put(FFITypes.ffi_type_double, Structure.newInstance(FFIType.class, FFITypes.ffi_type_double));
            ffiTypeInfo.put(FFITypes.ffi_type_longdouble, Structure.newInstance(FFIType.class, FFITypes.ffi_type_longdouble));
            ffiTypeInfo.put(FFITypes.ffi_type_uint8, Structure.newInstance(FFIType.class, FFITypes.ffi_type_uint8));
            ffiTypeInfo.put(FFITypes.ffi_type_sint8, Structure.newInstance(FFIType.class, FFITypes.ffi_type_sint8));
            ffiTypeInfo.put(FFITypes.ffi_type_uint16, Structure.newInstance(FFIType.class, FFITypes.ffi_type_uint16));
            ffiTypeInfo.put(FFITypes.ffi_type_sint16, Structure.newInstance(FFIType.class, FFITypes.ffi_type_sint16));
            ffiTypeInfo.put(FFITypes.ffi_type_uint32, Structure.newInstance(FFIType.class, FFITypes.ffi_type_uint32));
            ffiTypeInfo.put(FFITypes.ffi_type_sint32, Structure.newInstance(FFIType.class, FFITypes.ffi_type_sint32));
            ffiTypeInfo.put(FFITypes.ffi_type_uint64, Structure.newInstance(FFIType.class, FFITypes.ffi_type_uint64));
            ffiTypeInfo.put(FFITypes.ffi_type_sint64, Structure.newInstance(FFIType.class, FFITypes.ffi_type_sint64));
            ffiTypeInfo.put(FFITypes.ffi_type_pointer, Structure.newInstance(FFIType.class, FFITypes.ffi_type_pointer));
            Iterator<FFIType> iterator = ffiTypeInfo.values().iterator();
            while (iterator.hasNext()) {
                FFIType fFIType = iterator.next();
                fFIType.read();
            }
            typeInfoMap.put(Void.TYPE, ffiTypeInfo.get(FFITypes.ffi_type_void));
            typeInfoMap.put(Void.class, ffiTypeInfo.get(FFITypes.ffi_type_void));
            typeInfoMap.put(Float.TYPE, ffiTypeInfo.get(FFITypes.ffi_type_float));
            typeInfoMap.put(Float.class, ffiTypeInfo.get(FFITypes.ffi_type_float));
            typeInfoMap.put(Double.TYPE, ffiTypeInfo.get(FFITypes.ffi_type_double));
            typeInfoMap.put(Double.class, ffiTypeInfo.get(FFITypes.ffi_type_double));
            typeInfoMap.put(Long.TYPE, ffiTypeInfo.get(FFITypes.ffi_type_sint64));
            typeInfoMap.put(Long.class, ffiTypeInfo.get(FFITypes.ffi_type_sint64));
            typeInfoMap.put(Integer.TYPE, ffiTypeInfo.get(FFITypes.ffi_type_sint32));
            typeInfoMap.put(Integer.class, ffiTypeInfo.get(FFITypes.ffi_type_sint32));
            typeInfoMap.put(Short.TYPE, ffiTypeInfo.get(FFITypes.ffi_type_sint16));
            typeInfoMap.put(Short.class, ffiTypeInfo.get(FFITypes.ffi_type_sint16));
            FFIType ctype = Native.WCHAR_SIZE == 2 ? ffiTypeInfo.get(FFITypes.ffi_type_uint16) : ffiTypeInfo.get(FFITypes.ffi_type_uint32);
            typeInfoMap.put(Character.TYPE, ctype);
            typeInfoMap.put(Character.class, (FFIType)((Object)iterator));
            typeInfoMap.put(Byte.TYPE, ffiTypeInfo.get(FFITypes.ffi_type_sint8));
            typeInfoMap.put(Byte.class, ffiTypeInfo.get(FFITypes.ffi_type_sint8));
            typeInfoMap.put(Pointer.class, ffiTypeInfo.get(FFITypes.ffi_type_pointer));
            typeInfoMap.put(String.class, ffiTypeInfo.get(FFITypes.ffi_type_pointer));
            typeInfoMap.put(WString.class, ffiTypeInfo.get(FFITypes.ffi_type_pointer));
            typeInfoMap.put(Boolean.TYPE, ffiTypeInfo.get(FFITypes.ffi_type_uint32));
            typeInfoMap.put(Boolean.class, ffiTypeInfo.get(FFITypes.ffi_type_uint32));
        }

        private static class FFITypes {
            private static Pointer ffi_type_void;
            private static Pointer ffi_type_float;
            private static Pointer ffi_type_double;
            private static Pointer ffi_type_longdouble;
            private static Pointer ffi_type_uint8;
            private static Pointer ffi_type_sint8;
            private static Pointer ffi_type_uint16;
            private static Pointer ffi_type_sint16;
            private static Pointer ffi_type_uint32;
            private static Pointer ffi_type_sint32;
            private static Pointer ffi_type_uint64;
            private static Pointer ffi_type_sint64;
            private static Pointer ffi_type_pointer;

            private FFITypes() {
            }
        }

        public static class size_t
        extends IntegerType {
            private static final long serialVersionUID = 1L;

            public size_t() {
                this(0L);
            }

            /*
             * WARNING - void declaration
             */
            public size_t(long value) {
                super(Native.SIZE_T_SIZE, (long)var1_1);
                void var1_1;
            }
        }
    }

    protected static class StructField {
        public String name;
        public Class<?> type;
        public Field field;
        public int size = -1;
        public int offset = -1;
        public boolean isVolatile;
        public boolean isReadOnly;
        public FromNativeConverter readConverter;
        public ToNativeConverter writeConverter;
        public FromNativeContext context;

        protected StructField() {
        }

        public String toString() {
            return this.name + "@" + this.offset + "[" + this.size + "] (" + this.type + ")";
        }
    }

    private static class LayoutInfo {
        private int size = -1;
        private int alignment = 1;
        private final Map<String, StructField> fields = Collections.synchronizedMap(new LinkedHashMap());
        private int alignType = 0;
        private TypeMapper typeMapper;
        private boolean variable;

        private LayoutInfo() {
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ int access$402(LayoutInfo x0, int x1) {
            void var1_1;
            x0.alignType = var1_1;
            return x0.alignType;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ TypeMapper access$502(LayoutInfo x0, TypeMapper x1) {
            void var1_1;
            x0.typeMapper = var1_1;
            return x0.typeMapper;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ boolean access$202(LayoutInfo x0, boolean x1) {
            void var1_1;
            x0.variable = var1_1;
            return x0.variable;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ int access$602(LayoutInfo x0, int x1) {
            void var1_1;
            x0.alignment = var1_1;
            return x0.alignment;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ int access$302(LayoutInfo x0, int x1) {
            void var1_1;
            x0.size = var1_1;
            return x0.size;
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface FieldOrder {
        public String[] value();
    }

    static class StructureSet
    extends AbstractCollection<Structure>
    implements Set<Structure> {
        Structure[] elements;
        private int count;

        StructureSet() {
        }

        /*
         * WARNING - void declaration
         */
        private void ensureCapacity(int size) {
            if (this.elements == null) {
                this.elements = new Structure[size * 3 / 2];
                return;
            }
            if (this.elements.length < size) {
                void var1_2;
                Structure[] e = new Structure[size * 3 / 2];
                System.arraycopy(this.elements, 0, e, 0, this.elements.length);
                this.elements = var1_2;
            }
        }

        public Structure[] getElements() {
            return this.elements;
        }

        @Override
        public int size() {
            return this.count;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object o) {
            void var1_1;
            return this.indexOf((Structure)var1_1) != -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean add(Structure o) {
            if (!this.contains(o)) {
                void var1_1;
                StructureSet structureSet = this;
                structureSet.ensureCapacity(structureSet.count + 1);
                this.elements[this.count++] = var1_1;
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private int indexOf(Structure s1) {
            for (int i = 0; i < this.count; ++i) {
                void var3_3;
                Structure s2 = this.elements[i];
                if (s1 != s2 && (s1.getClass() != s2.getClass() || s1.size() != s2.size() || !s1.getPointer().equals(var3_3.getPointer()))) continue;
                return i;
            }
            return -1;
        }

        @Override
        public boolean remove(Object o) {
            int idx = this.indexOf((Structure)o);
            if (idx != -1) {
                if (--this.count >= 0) {
                    this.elements[var1_2] = this.elements[this.count];
                    this.elements[this.count] = null;
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Iterator<Structure> iterator() {
            void var1_1;
            Structure[] e = new Structure[this.count];
            if (this.count > 0) {
                System.arraycopy(this.elements, 0, e, 0, this.count);
            }
            return Arrays.asList(var1_1).iterator();
        }
    }

    private static class NativeStringTracking {
        private final Object value;
        private NativeString peer;

        /*
         * WARNING - void declaration
         */
        NativeStringTracking(Object lastValue) {
            void var1_1;
            this.value = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ NativeString access$002(NativeStringTracking x0, NativeString x1) {
            void var1_1;
            x0.peer = var1_1;
            return x0.peer;
        }
    }

    public static interface ByReference {
    }

    public static interface ByValue {
    }
}

