/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReflectionUtils {
    private static final Logger LOG;
    private static final Method METHOD_IS_DEFAULT;
    private static final Method METHOD_HANDLES_LOOKUP;
    private static final Method METHOD_HANDLES_LOOKUP_IN;
    private static final Method METHOD_HANDLES_PRIVATE_LOOKUP_IN;
    private static final Method METHOD_HANDLES_LOOKUP_UNREFLECT_SPECIAL;
    private static final Method METHOD_HANDLES_LOOKUP_FIND_SPECIAL;
    private static final Method METHOD_HANDLES_BIND_TO;
    private static final Method METHOD_HANDLES_INVOKE_WITH_ARGUMENTS;
    private static final Method METHOD_TYPE;
    private static Constructor CONSTRUCTOR_LOOKUP_CLASS;

    private static Constructor getConstructorLookupClass() {
        if (CONSTRUCTOR_LOOKUP_CLASS == null) {
            Class clazz = ReflectionUtils.lookupClass("java.lang.invoke.MethodHandles$Lookup");
            CONSTRUCTOR_LOOKUP_CLASS = ReflectionUtils.lookupDeclaredConstructor(clazz, Class.class);
        }
        return CONSTRUCTOR_LOOKUP_CLASS;
    }

    /*
     * WARNING - void declaration
     */
    private static Constructor lookupDeclaredConstructor(Class clazz, Class ... arguments) {
        if (clazz == null) {
            LOG.log(Level.FINE, "Failed to lookup method: <init>#{1}({2})", new Object[]{clazz, Arrays.toString(arguments)});
            return null;
        }
        try {
            void var2_2;
            Constructor init = clazz.getDeclaredConstructor(arguments);
            init.setAccessible(true);
            return var2_2;
        }
        catch (Exception exception) {
            void var1_1;
            Class clazz2;
            LOG.log(Level.FINE, "Failed to lookup method: <init>#{1}({2})", new Object[]{clazz2, Arrays.toString((Object[])var1_1)});
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Method lookupMethod(Class clazz, String methodName, Class ... arguments) {
        if (clazz == null) {
            LOG.log(Level.FINE, "Failed to lookup method: {0}#{1}({2})", new Object[]{clazz, methodName, Arrays.toString(arguments)});
            return null;
        }
        try {
            return clazz.getMethod(methodName, arguments);
        }
        catch (Exception exception) {
            void var2_2;
            void var1_1;
            Class clazz2;
            LOG.log(Level.FINE, "Failed to lookup method: {0}#{1}({2})", new Object[]{clazz2, var1_1, Arrays.toString((Object[])var2_2)});
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Class lookupClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException ex) {
            void var1_1;
            String string;
            LOG.log(Level.FINE, "Failed to lookup class: " + string, (Throwable)var1_1);
            return null;
        }
    }

    public static boolean isDefault(Method method) {
        if (METHOD_IS_DEFAULT == null) {
            return false;
        }
        try {
            return (Boolean)METHOD_IS_DEFAULT.invoke((Object)method, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException invocationTargetException2;
            InvocationTargetException ex = invocationTargetException;
            InvocationTargetException cause = invocationTargetException.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)((Object)cause);
            }
            if (cause instanceof Error) {
                throw (Error)((Object)cause);
            }
            throw new RuntimeException(invocationTargetException2);
        }
    }

    public static Object getMethodHandle(Method method) throws Exception {
        Object object;
        assert (ReflectionUtils.isDefault(method));
        Object baseLookup = ReflectionUtils.createLookup();
        try {
            object = ReflectionUtils.createPrivateLookupIn(method.getDeclaringClass(), object);
            object = ReflectionUtils.mhViaFindSpecial(object, method);
            return object;
        }
        catch (Exception exception) {
            Object object2;
            object = ReflectionUtils.getConstructorLookupClass().newInstance(method.getDeclaringClass());
            object2 = ReflectionUtils.mhViaUnreflectSpecial(object, (Method)object2);
            return object2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Object mhViaFindSpecial(Object lookup, Method method) throws Exception {
        void var1_1;
        Object object;
        return METHOD_HANDLES_LOOKUP_FIND_SPECIAL.invoke(object, method.getDeclaringClass(), method.getName(), METHOD_TYPE.invoke(null, method.getReturnType(), method.getParameterTypes()), var1_1.getDeclaringClass());
    }

    /*
     * WARNING - void declaration
     */
    private static Object mhViaUnreflectSpecial(Object lookup, Method method) throws Exception {
        void var1_1;
        Object object;
        Object l2 = METHOD_HANDLES_LOOKUP_IN.invoke(lookup, method.getDeclaringClass());
        return METHOD_HANDLES_LOOKUP_UNREFLECT_SPECIAL.invoke(object, method, var1_1.getDeclaringClass());
    }

    /*
     * WARNING - void declaration
     */
    private static Object createPrivateLookupIn(Class type, Object lookup) throws Exception {
        void var1_1;
        Class clazz;
        return METHOD_HANDLES_PRIVATE_LOOKUP_IN.invoke(null, clazz, var1_1);
    }

    private static Object createLookup() throws Exception {
        return METHOD_HANDLES_LOOKUP.invoke(null, new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static Object invokeDefaultMethod(Object target, Object methodHandle, Object ... args) throws Throwable {
        void var2_2;
        Object object;
        void var1_1;
        Object boundMethodHandle = METHOD_HANDLES_BIND_TO.invoke((Object)var1_1, target);
        return METHOD_HANDLES_INVOKE_WITH_ARGUMENTS.invoke(object, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void var2_2;
        void var0;
        void var1_1;
        LOG = Logger.getLogger(ReflectionUtils.class.getName());
        Class methodHandles = ReflectionUtils.lookupClass("java.lang.invoke.MethodHandles");
        Class methodHandle = ReflectionUtils.lookupClass("java.lang.invoke.MethodHandle");
        Class lookup = ReflectionUtils.lookupClass("java.lang.invoke.MethodHandles$Lookup");
        Class methodType = ReflectionUtils.lookupClass("java.lang.invoke.MethodType");
        METHOD_IS_DEFAULT = ReflectionUtils.lookupMethod(Method.class, "isDefault", new Class[0]);
        METHOD_HANDLES_LOOKUP = ReflectionUtils.lookupMethod(methodHandles, "lookup", new Class[0]);
        METHOD_HANDLES_LOOKUP_IN = ReflectionUtils.lookupMethod(lookup, "in", Class.class);
        METHOD_HANDLES_LOOKUP_UNREFLECT_SPECIAL = ReflectionUtils.lookupMethod(lookup, "unreflectSpecial", Method.class, Class.class);
        METHOD_HANDLES_LOOKUP_FIND_SPECIAL = ReflectionUtils.lookupMethod(lookup, "findSpecial", Class.class, String.class, methodType, Class.class);
        METHOD_HANDLES_BIND_TO = ReflectionUtils.lookupMethod(methodHandle, "bindTo", Object.class);
        METHOD_HANDLES_INVOKE_WITH_ARGUMENTS = ReflectionUtils.lookupMethod((Class)var1_1, "invokeWithArguments", Object[].class);
        METHOD_HANDLES_PRIVATE_LOOKUP_IN = ReflectionUtils.lookupMethod((Class)var0, "privateLookupIn", new Class[]{Class.class, var2_2});
        METHOD_TYPE = ReflectionUtils.lookupMethod((Class)var3_3, "methodType", Class.class, Class[].class);
    }
}

