/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections.builders;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import kotlin.Metadata;
import kotlin.collections.AbstractList;
import kotlin.collections.AbstractMutableList;
import kotlin.collections.ArrayDeque;
import kotlin.collections.ArraysKt;
import kotlin.collections.builders.ListBuilderKt;
import kotlin.collections.builders.SerializedCollection;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableList;
import kotlin.jvm.internal.markers.KMutableListIterator;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0010+\n\u0002\b\u0015\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00060\u0003j\u0002`\u00042\b\u0012\u0004\u0012\u0002H\u00010\u00052\u00060\u0006j\u0002`\u0007:\u0001VB\u0007\b\u0016\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bBM\b\u0002\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u0012\u0006\u0010\u000e\u001a\u00020\n\u0012\u0006\u0010\u000f\u001a\u00020\n\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0000\u0012\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0014J\u0015\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u001d\u0010\u001b\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010 J\u001e\u0010!\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\n2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#H\u0016J\u0016\u0010!\u001a\u00020\u00112\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#H\u0016J&\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\n2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#2\u0006\u0010&\u001a\u00020\nH\u0002J\u001d\u0010'\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010 J\f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000)J\b\u0010*\u001a\u00020\u001eH\u0002J\b\u0010+\u001a\u00020\u001eH\u0016J\u0014\u0010,\u001a\u00020\u00112\n\u0010-\u001a\u0006\u0012\u0002\b\u00030)H\u0002J\u0010\u0010.\u001a\u00020\u001e2\u0006\u0010/\u001a\u00020\nH\u0002J\u0010\u00100\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\nH\u0002J\u0013\u00101\u001a\u00020\u00112\b\u0010-\u001a\u0004\u0018\u000102H\u0096\u0002J\u0016\u00103\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00020\nH\u0096\u0002\u00a2\u0006\u0002\u00104J\b\u00105\u001a\u00020\nH\u0016J\u0015\u00106\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00107J\u0018\u00108\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\nH\u0002J\b\u00109\u001a\u00020\u0011H\u0016J\u000f\u0010:\u001a\b\u0012\u0004\u0012\u00028\u00000;H\u0096\u0002J\u0015\u0010<\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00107J\u000e\u0010=\u001a\b\u0012\u0004\u0012\u00028\u00000>H\u0016J\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00028\u00000>2\u0006\u0010\u001f\u001a\u00020\nH\u0016J\u0015\u0010?\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010@\u001a\u00020\u00112\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#H\u0016J\u0015\u0010A\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u00104J\u0015\u0010B\u001a\u00028\u00002\u0006\u0010%\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u00104J\u0018\u0010C\u001a\u00020\u001e2\u0006\u0010D\u001a\u00020\n2\u0006\u0010E\u001a\u00020\nH\u0002J\u0016\u0010F\u001a\u00020\u00112\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#H\u0016J.\u0010G\u001a\u00020\n2\u0006\u0010D\u001a\u00020\n2\u0006\u0010E\u001a\u00020\n2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000#2\u0006\u0010H\u001a\u00020\u0011H\u0002J\u001e\u0010I\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010JJ\u001e\u0010K\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010L\u001a\u00020\n2\u0006\u0010M\u001a\u00020\nH\u0016J\u0015\u0010N\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001020\rH\u0016\u00a2\u0006\u0002\u0010OJ'\u0010N\u001a\b\u0012\u0004\u0012\u0002HP0\r\"\u0004\b\u0001\u0010P2\f\u0010Q\u001a\b\u0012\u0004\u0012\u0002HP0\rH\u0016\u00a2\u0006\u0002\u0010RJ\b\u0010S\u001a\u00020TH\u0016J\b\u0010U\u001a\u000202H\u0002R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006W"}, d2={"Lkotlin/collections/builders/ListBuilder;", "E", "", "Ljava/util/RandomAccess;", "Lkotlin/collections/RandomAccess;", "Lkotlin/collections/AbstractMutableList;", "Ljava/io/Serializable;", "Lkotlin/io/Serializable;", "()V", "initialCapacity", "", "(I)V", "array", "", "offset", "length", "isReadOnly", "", "backing", "root", "([Ljava/lang/Object;IIZLkotlin/collections/builders/ListBuilder;Lkotlin/collections/builders/ListBuilder;)V", "[Ljava/lang/Object;", "isEffectivelyReadOnly", "()Z", "size", "getSize", "()I", "add", "element", "(Ljava/lang/Object;)Z", "", "index", "(ILjava/lang/Object;)V", "addAll", "elements", "", "addAllInternal", "i", "n", "addAtInternal", "build", "", "checkIsMutable", "clear", "contentEquals", "other", "ensureCapacity", "minCapacity", "ensureExtraCapacity", "equals", "", "get", "(I)Ljava/lang/Object;", "hashCode", "indexOf", "(Ljava/lang/Object;)I", "insertAtInternal", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "remove", "removeAll", "removeAt", "removeAtInternal", "removeRangeInternal", "rangeOffset", "rangeLength", "retainAll", "retainOrRemoveAllInternal", "retain", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "subList", "fromIndex", "toIndex", "toArray", "()[Ljava/lang/Object;", "T", "destination", "([Ljava/lang/Object;)[Ljava/lang/Object;", "toString", "", "writeReplace", "Itr", "kotlin-stdlib"})
public final class ListBuilder<E>
extends AbstractMutableList<E>
implements Serializable,
List<E>,
RandomAccess,
KMutableList {
    private E[] array;
    private int offset;
    private int length;
    private boolean isReadOnly;
    private final ListBuilder<E> backing;
    private final ListBuilder<E> root;

    /*
     * WARNING - void declaration
     */
    private ListBuilder(E[] array, int offset, int length, boolean isReadOnly, ListBuilder<E> backing, ListBuilder<E> root) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.array = var1_1;
        this.offset = var2_2;
        this.length = var3_3;
        this.isReadOnly = isReadOnly;
        this.backing = backing;
        this.root = root;
    }

    public ListBuilder() {
        this(10);
    }

    /*
     * WARNING - void declaration
     */
    public ListBuilder(int initialCapacity) {
        this(ListBuilderKt.arrayOfUninitializedElements((int)var1_1), 0, 0, false, null, null);
        void var1_1;
    }

    public final List<E> build() {
        if (this.backing != null) {
            throw new IllegalStateException();
        }
        this.checkIsMutable();
        this.isReadOnly = true;
        return this;
    }

    private final Object writeReplace() {
        if (this.isEffectivelyReadOnly()) {
            return new SerializedCollection(this, 0);
        }
        throw new NotSerializableException("The list cannot be serialized while it is being built.");
    }

    @Override
    public final int getSize() {
        return this.length;
    }

    @Override
    public final boolean isEmpty() {
        return this.length == 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final E get(int index) {
        void var1_1;
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(index, this.length);
        return this.array[this.offset + var1_1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final E set(int index, E element) {
        void var3_3;
        void var2_2;
        this.checkIsMutable();
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(index, this.length);
        E old = this.array[this.offset + index];
        this.array[this.offset + var1_1] = var2_2;
        return var3_3;
    }

    @Override
    public final int indexOf(Object element) {
        for (int i = 0; i < this.length; ++i) {
            if (!Intrinsics.areEqual(this.array[this.offset + i], element)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(Object element) {
        for (int i = this.length - 1; i >= 0; --i) {
            if (!Intrinsics.areEqual(this.array[this.offset + i], element)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final Iterator<E> iterator() {
        return new Itr(this, 0);
    }

    @Override
    public final ListIterator<E> listIterator() {
        return new Itr(this, 0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ListIterator<E> listIterator(int index) {
        void var1_1;
        AbstractList.Companion.checkPositionIndex$kotlin_stdlib(index, this.length);
        return new Itr(this, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean add(E element) {
        void var1_1;
        this.checkIsMutable();
        ListBuilder listBuilder = this;
        listBuilder.addAtInternal(listBuilder.offset + this.length, var1_1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void add(int index, E element) {
        void var2_2;
        void var1_1;
        this.checkIsMutable();
        AbstractList.Companion.checkPositionIndex$kotlin_stdlib(index, this.length);
        ListBuilder listBuilder = this;
        listBuilder.addAtInternal(listBuilder.offset + var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean addAll(Collection<? extends E> elements) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(elements, "elements");
        this.checkIsMutable();
        int n = elements.size();
        ListBuilder listBuilder = this;
        listBuilder.addAllInternal(listBuilder.offset + this.length, (Collection<? extends E>)var1_1, n);
        return var2_2 > 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean addAll(int index, Collection<? extends E> elements) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(elements, "elements");
        this.checkIsMutable();
        AbstractList.Companion.checkPositionIndex$kotlin_stdlib(index, this.length);
        int n = elements.size();
        ListBuilder listBuilder = this;
        listBuilder.addAllInternal(listBuilder.offset + var1_1, (Collection<? extends E>)var2_2, n);
        return var3_3 > 0;
    }

    @Override
    public final void clear() {
        this.checkIsMutable();
        ListBuilder listBuilder = this;
        listBuilder.removeRangeInternal(listBuilder.offset, this.length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final E removeAt(int index) {
        void var1_1;
        this.checkIsMutable();
        AbstractList.Companion.checkElementIndex$kotlin_stdlib(index, this.length);
        ListBuilder listBuilder = this;
        return listBuilder.removeAtInternal(listBuilder.offset + var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean remove(Object element) {
        void var1_2;
        this.checkIsMutable();
        int i = this.indexOf(element);
        if (i >= 0) {
            this.remove(i);
        }
        return var1_2 >= 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean removeAll(Collection<? extends Object> elements) {
        void var1_1;
        Intrinsics.checkNotNullParameter(elements, "elements");
        this.checkIsMutable();
        ListBuilder listBuilder = this;
        return listBuilder.retainOrRemoveAllInternal(listBuilder.offset, this.length, (Collection<? extends E>)var1_1, false) > 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean retainAll(Collection<? extends Object> elements) {
        void var1_1;
        Intrinsics.checkNotNullParameter(elements, "elements");
        this.checkIsMutable();
        ListBuilder listBuilder = this;
        return listBuilder.retainOrRemoveAllInternal(listBuilder.offset, this.length, (Collection<? extends E>)var1_1, true) > 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final List<E> subList(int fromIndex, int toIndex) {
        void var1_1;
        void var2_2;
        AbstractList.Companion.checkRangeIndexes$kotlin_stdlib(fromIndex, toIndex, this.length);
        void v0 = var2_2 - var1_1;
        ListBuilder listBuilder = this;
        ListBuilder listBuilder2 = listBuilder.root;
        if (listBuilder2 == null) {
            listBuilder2 = this;
        }
        return new ListBuilder<E>(this.array, this.offset + fromIndex, (int)v0, this.isReadOnly, listBuilder, listBuilder2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> T[] toArray(T[] destination) {
        void var1_1;
        Intrinsics.checkNotNullParameter(destination, "destination");
        if (destination.length < this.length) {
            T[] TArray = Arrays.copyOfRange(this.array, this.offset, this.offset + this.length, destination.getClass());
            Intrinsics.checkNotNullExpressionValue(TArray, "copyOfRange(array, offse\u2026h, destination.javaClass)");
            return TArray;
        }
        ArraysKt.copyInto(this.array, destination, 0, this.offset, this.offset + this.length);
        if (destination.length > this.length) {
            destination[this.length] = null;
        }
        return var1_1;
    }

    @Override
    public final Object[] toArray() {
        E[] EArray = this.array;
        int n = this.offset;
        int n2 = this.offset + this.length;
        return ArraysKt.copyOfRange(EArray, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object other) {
        void var1_1;
        return other == this || other instanceof List && this.contentEquals((List)var1_1);
    }

    @Override
    public final int hashCode() {
        return ListBuilderKt.access$subarrayContentHashCode(this.array, this.offset, this.length);
    }

    @Override
    public final String toString() {
        return ListBuilderKt.access$subarrayContentToString(this.array, this.offset, this.length);
    }

    /*
     * WARNING - void declaration
     */
    private final void ensureCapacity(int minCapacity) {
        if (this.backing != null) {
            throw new IllegalStateException();
        }
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        if (minCapacity > this.array.length) {
            void var1_1;
            int newSize = ArrayDeque.Companion.newCapacity$kotlin_stdlib(this.array.length, minCapacity);
            this.array = ListBuilderKt.copyOfUninitializedElements(this.array, (int)var1_1);
        }
    }

    private final void checkIsMutable() {
        if (this.isEffectivelyReadOnly()) {
            throw new UnsupportedOperationException();
        }
    }

    private final boolean isEffectivelyReadOnly() {
        return this.isReadOnly || this.root != null && this.root.isReadOnly;
    }

    /*
     * WARNING - void declaration
     */
    private final void ensureExtraCapacity(int n) {
        void var1_1;
        ListBuilder listBuilder = this;
        listBuilder.ensureCapacity(listBuilder.length + var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean contentEquals(List<?> other) {
        void var1_1;
        return ListBuilderKt.access$subarrayContentEquals(this.array, this.offset, this.length, (List)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final void insertAtInternal(int i, int n) {
        void var2_2;
        void var1_1;
        this.ensureExtraCapacity(n);
        E[] EArray = this.array;
        E[] EArray2 = this.array;
        int n2 = this.offset + this.length;
        int n3 = i + n;
        ArraysKt.copyInto(EArray, EArray2, n3, (int)var1_1, n2);
        this.length += var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private final void addAtInternal(int i, E element) {
        void var2_2;
        if (this.backing != null) {
            super.addAtInternal(i, element);
            this.array = this.backing.array;
            i = this.length;
            this.length = i + 1;
            return;
        }
        this.insertAtInternal(i, 1);
        this.array[var1_1] = var2_2;
    }

    private final void addAllInternal(int i, Collection<? extends E> elements, int n) {
        if (this.backing != null) {
            super.addAllInternal(i, elements, n);
            this.array = this.backing.array;
            this.length += n;
            return;
        }
        this.insertAtInternal(i, n);
        Iterator<E> it = elements.iterator();
        for (int j = 0; j < n; ++j) {
            this.array[i + j] = it.next();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final E removeAtInternal(int i) {
        void var2_3;
        void var1_1;
        if (this.backing != null) {
            E old = super.removeAtInternal(i);
            int n = this.length;
            this.length = n + -1;
            return old;
        }
        E old = this.array[i];
        E[] EArray = this.array;
        E[] EArray2 = this.array;
        int n = i + 1;
        int n2 = this.offset + this.length;
        ArraysKt.copyInto(EArray, EArray2, (int)var1_1, n, n2);
        ListBuilderKt.resetAt(this.array, this.offset + this.length - 1);
        int n3 = this.length;
        this.length = n3 + -1;
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    private final void removeRangeInternal(int rangeOffset, int rangeLength) {
        void var2_2;
        if (this.backing != null) {
            super.removeRangeInternal(rangeOffset, rangeLength);
        } else {
            void var1_1;
            E[] EArray = this.array;
            E[] EArray2 = this.array;
            int n = rangeOffset + rangeLength;
            int n2 = this.length;
            ArraysKt.copyInto(EArray, EArray2, (int)var1_1, n, n2);
            ListBuilderKt.resetRange(this.array, this.length - rangeLength, this.length);
        }
        this.length -= var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private final int retainOrRemoveAllInternal(int rangeOffset, int rangeLength, Collection<? extends E> elements, boolean retain) {
        void var3_4;
        int n;
        if (this.backing != null) {
            int removed = super.retainOrRemoveAllInternal(rangeOffset, rangeLength, elements, retain);
            this.length -= removed;
            return removed;
        }
        int i = 0;
        int j = 0;
        while (i < rangeLength) {
            if (elements.contains(this.array[rangeOffset + i]) == retain) {
                this.array[rangeOffset + j++] = this.array[rangeOffset + i++];
                continue;
            }
            ++i;
        }
        int removed = rangeLength - j;
        E[] EArray = this.array;
        E[] EArray2 = this.array;
        n = rangeOffset + n;
        int n2 = this.length;
        ArraysKt.copyInto(EArray, EArray2, (int)(var1_1 += j), n, n2);
        ListBuilderKt.resetRange(this.array, this.length - removed, this.length);
        this.length -= removed;
        return (int)var3_4;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010+\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001d\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\fJ\t\u0010\r\u001a\u00020\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u000e\u0010\u0010\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0006H\u0016J\r\u0010\u0013\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0014\u001a\u00020\u0006H\u0016J\b\u0010\u0015\u001a\u00020\nH\u0016J\u0015\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lkotlin/collections/builders/ListBuilder$Itr;", "E", "", "list", "Lkotlin/collections/builders/ListBuilder;", "index", "", "(Lkotlin/collections/builders/ListBuilder;I)V", "lastIndex", "add", "", "element", "(Ljava/lang/Object;)V", "hasNext", "", "hasPrevious", "next", "()Ljava/lang/Object;", "nextIndex", "previous", "previousIndex", "remove", "set", "kotlin-stdlib"})
    @SourceDebugExtension(value={"SMAP\nListBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListBuilder.kt\nkotlin/collections/builders/ListBuilder$Itr\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,429:1\n1#2:430\n*E\n"})
    private static final class Itr<E>
    implements ListIterator<E>,
    KMutableListIterator {
        private final ListBuilder<E> list;
        private int index;
        private int lastIndex;

        /*
         * WARNING - void declaration
         */
        public Itr(ListBuilder<E> list, int index) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter(list, "list");
            this.list = var1_1;
            this.index = var2_2;
            this.lastIndex = -1;
        }

        @Override
        public final boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public final boolean hasNext() {
            return this.index < ((ListBuilder)this.list).length;
        }

        @Override
        public final int previousIndex() {
            return this.index - 1;
        }

        @Override
        public final int nextIndex() {
            return this.index;
        }

        @Override
        public final E previous() {
            if (this.index <= 0) {
                throw new NoSuchElementException();
            }
            Itr itr = this;
            itr.index = this.index + -1;
            itr.lastIndex = this.index;
            return (E)((ListBuilder)this.list).array[((ListBuilder)this.list).offset + this.lastIndex];
        }

        @Override
        public final E next() {
            if (this.index >= ((ListBuilder)this.list).length) {
                throw new NoSuchElementException();
            }
            int n = this.index;
            this.index = n + 1;
            this.lastIndex = n;
            return (E)((ListBuilder)this.list).array[((ListBuilder)this.list).offset + this.lastIndex];
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void set(E element) {
            void var1_1;
            boolean bl = this.lastIndex != -1;
            if (!bl) {
                element = "Call next() or previous() before replacing element from the iterator.";
                throw new IllegalStateException(element.toString());
            }
            this.list.set(this.lastIndex, var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void add(E element) {
            void var1_1;
            int n = this.index;
            this.index = n + 1;
            this.list.add(n, var1_1);
            this.lastIndex = -1;
        }

        @Override
        public final void remove() {
            boolean bl = this.lastIndex != -1;
            if (!bl) {
                String string = "Call next() or previous() before removing element from the iterator.";
                throw new IllegalStateException(string.toString());
            }
            this.list.remove(this.lastIndex);
            this.index = this.lastIndex;
            this.lastIndex = -1;
        }
    }
}

