/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.internal.InlineOnly;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.ExposingBufferByteArrayOutputStream;
import kotlin.io.FilesKt;
import kotlin.io.FilesKt__FilePathComponentsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;

@Metadata(mv={1, 8, 0}, k=5, xi=49, d1={"\u0000z\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001c\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u001a!\u0010\n\u001a\u00020\u000b*\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\rH\u0087\b\u001a!\u0010\u000e\u001a\u00020\u000f*\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\rH\u0087\b\u001aB\u0010\u0010\u001a\u00020\u0001*\u00020\u000226\u0010\u0011\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00010\u0012\u001aJ\u0010\u0010\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\r26\u0010\u0011\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00010\u0012\u001a7\u0010\u0018\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\t2!\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u00010\u0019\u001a\r\u0010\u001b\u001a\u00020\u001c*\u00020\u0002H\u0087\b\u001a\r\u0010\u001d\u001a\u00020\u001e*\u00020\u0002H\u0087\b\u001a\u0017\u0010\u001f\u001a\u00020 *\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\tH\u0087\b\u001a\n\u0010!\u001a\u00020\u0004*\u00020\u0002\u001a\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070#*\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\t\u001a\u0014\u0010$\u001a\u00020\u0007*\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\t\u001a\u0017\u0010%\u001a\u00020&*\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\tH\u0087\b\u001a?\u0010'\u001a\u0002H(\"\u0004\b\u0000\u0010(*\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\t2\u0018\u0010)\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070*\u0012\u0004\u0012\u0002H(0\u0019H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+\u001a\u0012\u0010,\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001c\u0010-\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u001a\u0017\u0010.\u001a\u00020/*\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\tH\u0087\b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00060"}, d2={"appendBytes", "", "Ljava/io/File;", "array", "", "appendText", "text", "", "charset", "Ljava/nio/charset/Charset;", "bufferedReader", "Ljava/io/BufferedReader;", "bufferSize", "", "bufferedWriter", "Ljava/io/BufferedWriter;", "forEachBlock", "action", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "buffer", "bytesRead", "blockSize", "forEachLine", "Lkotlin/Function1;", "line", "inputStream", "Ljava/io/FileInputStream;", "outputStream", "Ljava/io/FileOutputStream;", "printWriter", "Ljava/io/PrintWriter;", "readBytes", "readLines", "", "readText", "reader", "Ljava/io/InputStreamReader;", "useLines", "T", "block", "Lkotlin/sequences/Sequence;", "(Ljava/io/File;Ljava/nio/charset/Charset;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "writeBytes", "writeText", "writer", "Ljava/io/OutputStreamWriter;", "kotlin-stdlib"}, xs="kotlin/io/FilesKt")
@SourceDebugExtension(value={"SMAP\nFileReadWrite.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileReadWrite.kt\nkotlin/io/FilesKt__FileReadWriteKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,232:1\n231#1:234\n1#2:233\n1#2:235\n*S KotlinDebug\n*F\n+ 1 FileReadWrite.kt\nkotlin/io/FilesKt__FileReadWriteKt\n*L\n230#1:234\n230#1:235\n*E\n"})
class FilesKt__FileReadWriteKt
extends FilesKt__FilePathComponentsKt {
    /*
     * WARNING - void declaration
     */
    @InlineOnly
    private static final InputStreamReader reader(File $this$reader, Charset charset) {
        void var1_1;
        File file;
        Intrinsics.checkNotNullParameter($this$reader, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        return new InputStreamReader((InputStream)new FileInputStream(file), (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ InputStreamReader reader$default(File $this$reader_u24default, Charset charset, int n, Object object) {
        void var1_1;
        File file;
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter($this$reader_u24default, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        return new InputStreamReader((InputStream)new FileInputStream(file), (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @InlineOnly
    private static final BufferedReader bufferedReader(File $this$bufferedReader, Charset charset, int bufferSize) {
        void var2_2;
        void var1_1;
        Reader reader;
        Intrinsics.checkNotNullParameter($this$bufferedReader, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        reader = new InputStreamReader((InputStream)new FileInputStream((File)((Object)reader)), (Charset)var1_1);
        return new BufferedReader(reader, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ BufferedReader bufferedReader$default(File $this$bufferedReader_u24default, Charset charset, int bufferSize, int n, Object object) {
        void var2_2;
        void var1_1;
        File file;
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        if ((n & 2) != 0) {
            bufferSize = 8192;
        }
        Intrinsics.checkNotNullParameter($this$bufferedReader_u24default, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Object object2 = file;
        object2 = new InputStreamReader((InputStream)new FileInputStream((File)object2), (Charset)var1_1);
        return new BufferedReader((Reader)object2, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @InlineOnly
    private static final OutputStreamWriter writer(File $this$writer, Charset charset) {
        void var1_1;
        File file;
        Intrinsics.checkNotNullParameter($this$writer, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        return new OutputStreamWriter((OutputStream)new FileOutputStream(file), (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ OutputStreamWriter writer$default(File $this$writer_u24default, Charset charset, int n, Object object) {
        void var1_1;
        File file;
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter($this$writer_u24default, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        return new OutputStreamWriter((OutputStream)new FileOutputStream(file), (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @InlineOnly
    private static final BufferedWriter bufferedWriter(File $this$bufferedWriter, Charset charset, int bufferSize) {
        void var2_2;
        void var1_1;
        Writer writer;
        Intrinsics.checkNotNullParameter($this$bufferedWriter, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        writer = new OutputStreamWriter((OutputStream)new FileOutputStream((File)((Object)writer)), (Charset)var1_1);
        return new BufferedWriter(writer, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ BufferedWriter bufferedWriter$default(File $this$bufferedWriter_u24default, Charset charset, int bufferSize, int n, Object object) {
        void var2_2;
        void var1_1;
        File file;
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        if ((n & 2) != 0) {
            bufferSize = 8192;
        }
        Intrinsics.checkNotNullParameter($this$bufferedWriter_u24default, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Object object2 = file;
        object2 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object2), (Charset)var1_1);
        return new BufferedWriter((Writer)object2, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @InlineOnly
    private static final PrintWriter printWriter(File $this$printWriter, Charset charset) {
        void var1_1;
        Writer writer;
        Intrinsics.checkNotNullParameter($this$printWriter, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        writer = new OutputStreamWriter((OutputStream)new FileOutputStream((File)((Object)writer)), (Charset)var1_1);
        return new PrintWriter(new BufferedWriter(writer, 8192));
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ PrintWriter printWriter$default(File $this$printWriter_u24default, Charset charset, int n, Object object) {
        void var1_1;
        Object object2;
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        Intrinsics.checkNotNullParameter($this$printWriter_u24default, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        File file = object2;
        object2 = file;
        object2 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object2), (Charset)var1_1);
        return new PrintWriter(new BufferedWriter((Writer)object2, 8192));
    }

    /*
     * WARNING - void declaration
     */
    public static final byte[] readBytes(File $this$readBytes) {
        Intrinsics.checkNotNullParameter($this$readBytes, "<this>");
        Closeable closeable = new FileInputStream($this$readBytes);
        Throwable throwable = null;
        try {
            byte[] byArray;
            int read;
            FileInputStream input = (FileInputStream)closeable;
            int offset = 0;
            long l = $this$readBytes.length();
            if (l > Integer.MAX_VALUE) {
                throw new OutOfMemoryError("File " + $this$readBytes + " is too big (" + l + " bytes) to fit in memory.");
            }
            int remaining = (int)l;
            byte[] result = new byte[remaining];
            while (remaining > 0 && (read = input.read(result, offset, remaining)) >= 0) {
                remaining -= read;
                offset += read;
            }
            if (remaining > 0) {
                byte[] byArray2 = Arrays.copyOf(result, offset);
                byArray = byArray2;
                Intrinsics.checkNotNullExpressionValue(byArray2, "copyOf(this, newSize)");
            } else {
                int extraByte = input.read();
                if (extraByte == -1) {
                    byArray = result;
                } else {
                    void var3_4;
                    ExposingBufferByteArrayOutputStream extra = new ExposingBufferByteArrayOutputStream(8193);
                    extra.write(extraByte);
                    ByteStreamsKt.copyTo$default(input, extra, 0, 2, null);
                    int resultingSize = result.length + extra.size();
                    if (resultingSize < 0) {
                        File file;
                        throw new OutOfMemoryError("File " + file + " is too big to fit in memory.");
                    }
                    byte[] byArray3 = extra.getBuffer();
                    byte[] byArray4 = Arrays.copyOf(result, (int)var3_4);
                    Intrinsics.checkNotNullExpressionValue(byArray4, "copyOf(this, newSize)");
                    byArray = ArraysKt.copyInto(byArray3, byArray4, result.length, 0, extra.size());
                }
            }
            byte[] byArray5 = byArray;
            return byArray5;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throwable = throwable2;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void writeBytes(File $this$writeBytes, byte[] array) {
        Closeable closeable;
        Intrinsics.checkNotNullParameter($this$writeBytes, "<this>");
        Intrinsics.checkNotNullParameter(array, "array");
        closeable = new FileOutputStream((File)((Object)closeable));
        Throwable throwable = null;
        try {
            void var1_1;
            FileOutputStream fileOutputStream = (FileOutputStream)closeable;
            fileOutputStream.write((byte[])var1_1);
            return;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throwable = throwable2;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void appendBytes(File $this$appendBytes, byte[] array) {
        Closeable closeable;
        Intrinsics.checkNotNullParameter($this$appendBytes, "<this>");
        Intrinsics.checkNotNullParameter(array, "array");
        closeable = new FileOutputStream((File)((Object)closeable), true);
        Throwable throwable = null;
        try {
            void var1_1;
            FileOutputStream fileOutputStream = (FileOutputStream)closeable;
            fileOutputStream.write((byte[])var1_1);
            return;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throwable = throwable2;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    public static final String readText(File $this$readText, Charset charset) {
        Throwable throwable;
        Closeable closeable;
        Intrinsics.checkNotNullParameter($this$readText, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        closeable = new InputStreamReader((InputStream)new FileInputStream((File)((Object)closeable)), (Charset)((Object)throwable));
        throwable = null;
        try {
            Object object = (InputStreamReader)closeable;
            object = TextStreamsKt.readText((Reader)object);
            return object;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throwable = throwable2;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    public static /* synthetic */ String readText$default(File file, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return FilesKt.readText(file, charset);
    }

    /*
     * WARNING - void declaration
     */
    public static final void writeText(File $this$writeText, String text, Charset charset) {
        File file;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$writeText, "<this>");
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(charset, "charset");
        byte[] byArray = var1_1.getBytes((Charset)var2_2);
        Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
        FilesKt.writeBytes(file, byArray);
    }

    public static /* synthetic */ void writeText$default(File file, String string, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        FilesKt.writeText(file, string, charset);
    }

    /*
     * WARNING - void declaration
     */
    public static final void appendText(File $this$appendText, String text, Charset charset) {
        File file;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter($this$appendText, "<this>");
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(charset, "charset");
        byte[] byArray = var1_1.getBytes((Charset)var2_2);
        Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
        FilesKt.appendBytes(file, byArray);
    }

    public static /* synthetic */ void appendText$default(File file, String string, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        FilesKt.appendText(file, string, charset);
    }

    /*
     * WARNING - void declaration
     */
    public static final void forEachBlock(File $this$forEachBlock, Function2<? super byte[], ? super Integer, Unit> action) {
        void var1_1;
        File file;
        Intrinsics.checkNotNullParameter($this$forEachBlock, "<this>");
        Intrinsics.checkNotNullParameter(action, "action");
        FilesKt.forEachBlock(file, 4096, (Function2<? super byte[], ? super Integer, Unit>)var1_1);
    }

    public static final void forEachBlock(File $this$forEachBlock, int blockSize, Function2<? super byte[], ? super Integer, Unit> action) {
        Closeable closeable;
        Intrinsics.checkNotNullParameter($this$forEachBlock, "<this>");
        Intrinsics.checkNotNullParameter(action, "action");
        byte[] arr = new byte[RangesKt.coerceAtLeast(blockSize, 512)];
        closeable = new FileInputStream((File)((Object)closeable));
        Throwable throwable = null;
        try {
            int size;
            FileInputStream input = (FileInputStream)closeable;
            while ((size = input.read(arr)) > 0) {
                action.invoke((byte[])arr, (Integer)size);
            }
            return;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throwable = throwable2;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void forEachLine(File $this$forEachLine, Charset charset, Function1<? super String, Unit> action) {
        void var2_2;
        void var1_1;
        File file;
        Intrinsics.checkNotNullParameter($this$forEachLine, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Intrinsics.checkNotNullParameter(action, "action");
        TextStreamsKt.forEachLine(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), (Charset)var1_1)), (Function1<? super String, Unit>)var2_2);
    }

    public static /* synthetic */ void forEachLine$default(File file, Charset charset, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        FilesKt.forEachLine(file, charset, function1);
    }

    @InlineOnly
    private static final FileInputStream inputStream(File $this$inputStream) {
        File file;
        Intrinsics.checkNotNullParameter($this$inputStream, "<this>");
        return new FileInputStream(file);
    }

    @InlineOnly
    private static final FileOutputStream outputStream(File $this$outputStream) {
        File file;
        Intrinsics.checkNotNullParameter($this$outputStream, "<this>");
        return new FileOutputStream(file);
    }

    /*
     * WARNING - void declaration
     */
    public static final List<String> readLines(File $this$readLines, Charset charset) {
        void var2_2;
        void var1_1;
        File file;
        Intrinsics.checkNotNullParameter($this$readLines, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        ArrayList<String> result = new ArrayList<String>();
        FilesKt.forEachLine(file, (Charset)var1_1, (Function1<? super String, Unit>)new Function1<String, Unit>(result){
            final /* synthetic */ ArrayList<String> $result;
            {
                void var1_1;
                this.$result = var1_1;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(String it) {
                void var1_1;
                Intrinsics.checkNotNullParameter(it, "it");
                this.$result.add((String)var1_1);
            }
        });
        return (List)var2_2;
    }

    public static /* synthetic */ List readLines$default(File file, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return FilesKt.readLines(file, charset);
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> T useLines(File $this$useLines, Charset charset, Function1<? super Sequence<String>, ? extends T> block) {
        Throwable throwable;
        Closeable closeable;
        Intrinsics.checkNotNullParameter($this$useLines, "<this>");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Intrinsics.checkNotNullParameter(block, "block");
        Object object = closeable;
        object = new InputStreamReader((InputStream)new FileInputStream((File)object), (Charset)((Object)throwable));
        closeable = new BufferedReader((Reader)object, 8192);
        throwable = null;
        try {
            void var2_2;
            BufferedReader it = (BufferedReader)closeable;
            object = var2_2.invoke(TextStreamsKt.lineSequence((BufferedReader)object));
            return (T)object;
        }
        catch (Throwable throwable2) {
            object = throwable2;
            throwable = throwable2;
            throw object;
        }
        finally {
            InlineMarker.finallyStart(1);
            CloseableKt.closeFinally(closeable, throwable);
            InlineMarker.finallyEnd(1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Object useLines$default(File $this$useLines_u24default, Charset charset, Function1 block, int n, Object object) {
        Throwable throwable;
        Closeable closeable;
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        Object object2 = closeable;
        object2 = new InputStreamReader((InputStream)new FileInputStream((File)object2), (Charset)((Object)throwable));
        closeable = new BufferedReader((Reader)object2, 8192);
        throwable = null;
        try {
            void var2_2;
            BufferedReader it$iv = (BufferedReader)closeable;
            object2 = var2_2.invoke(TextStreamsKt.lineSequence((BufferedReader)object2));
            return object2;
        }
        catch (Throwable throwable2) {
            object2 = throwable2;
            throwable = throwable2;
            throw object2;
        }
        finally {
            InlineMarker.finallyStart(1);
            CloseableKt.closeFinally(closeable, throwable);
            InlineMarker.finallyEnd(1);
        }
    }
}

